<?PHP

ini_set('display_errors', E_ERROR); ## LIVE
error_reporting(E_ERROR); ## LIVE

#ini_set('display_errors', 1); ## TESTING
#error_reporting(E_ALL);  ## TESTING


header("Content-Type: text/html; charset=utf-8");
mb_internal_encoding('UTF-8');

/* CREATE SESSION AND VALIDATE LOGIN */

function logout($sessionName)
{
	session_unset();
	$_SESSION=array();
	session_destroy();
	session_name($sessionName);
	@session_start();
}

function isLoginValid($configValues)
{
	$retValue = true;
	if ($configValues['webuisetting_maintenancemode'] == 1 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 2))
		$retValue = false;
	
	return $retValue;
}

function disableOnlyFullGroupBy($class_db)
{
	$found = false;
	$newSQLModes = "";
	$resSQLModes = $class_db->db_query("SELECT @@sql_mode");
	if (mysqli_num_rows($resSQLModes) > 0)
	{
		$row = mysqli_fetch_row($resSQLModes);
		$sqlModes = explode(",", $row[0]);
		for ($i = 0; $i < count($sqlModes); $i++)
		{
			if (strtolower(trim($sqlModes[$i])) != "only_full_group_by")
			{
				if ($newSQLModes != "")
					$newSQLModes .= ",";
				
				$newSQLModes .= $sqlModes[$i];
			}
			else
				$found = true;
		}
	}
	
	if ($found)
		$class_db->db_query("SET SESSION sql_mode = '".$newSQLModes."'");
}

ini_set('session.use_only_cookies', 1);
ini_set('session.gc_probability', 1);
ini_set('session.gc_divisor', 50);
ini_set('session.gc_maxlifetime', 1440);

$sessionName = "JTS3ServerModWebUI";
session_name($sessionName);
@session_start();

//Session IP Check
if (!isset($_SESSION['ipaddress']) || $_SESSION['ipaddress'] == "")
{
	$_SESSION['ipaddress'] = $_SERVER["REMOTE_ADDR"];
}
else if ($_SESSION['ipaddress'] != $_SERVER["REMOTE_ADDR"])
{
	logout($sessionName);
}

if (isset($_GET['languageid']) && is_numeric($_GET['languageid']))
{
	$_SESSION['languageid'] = $_GET['languageid'];
}

require("class/dbconnect.php");
$class_db = new dbconnect();

disableOnlyFullGroupBy($class_db);

$configValues = array();
$resultSettings = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermodwebui_settings WHERE configkey IN ('webuisetting_maintenancemode', 'webuisetting_allowlanguagechooser', 'webuisetting_allowregistration', 'webuisetting_allowcreatebot', 'webuisetting_allowcontact', 'webuisetting_themecss', 'webui_build')");
while($row = mysqli_fetch_row($resultSettings))
{
	$configValues[$row[0]] = $row[1];
}

if (!isset($configValues['webuisetting_maintenancemode']))
	$configValues['webuisetting_maintenancemode'] = 0;

$verifyFailReason = null;
require("include/verifylogin.php");

if (!isLoginValid($configValues))
	logout($sessionName);

$userid = -1;
if (isset($_SESSION['userid']) && is_numeric($_SESSION['userid']))
{
	$userid = $_SESSION['userid'];
}
/* CREATE HTML PAGE */

// Parsing subpage
$requestPage = (isset($_GET['page']) ? $_GET['page'] : "");
$page404 = "include/404.php";
$page = $page404;
$displayplusminus = true;

if ($requestPage == "register" && isLoginValid($configValues))
{
	$page = "include/register.php";
}
else if ($requestPage == "contact")
{
	$page = "include/contact.php";
}
else if ($userid == -1 || !isLoginValid($configValues))
{
	$page = "include/welcome.php";
	$displayplusminus = false;
}
else if ($requestPage == "" || $requestPage == "index" || $requestPage == "botlist")
{
	if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1)
	{
		require("include/update.php");
		sqlUpdateCheck($class_db);
	}
	
	$page = "include/botlist.php";
}
else if ($requestPage == "botcreate")
{
	$page = "include/botcreate.php";
}
else if ($requestPage == "botmanager")
{
	$page = "include/botmanager.php";
}
else if ($requestPage == "botlogview")
{
	$page = "include/botlogview.php";
}
else if ($requestPage == "settings")
{
	$page = "include/settings.php";
}
else if ($requestPage == "userlist")
{
	$page = "include/userlist.php";
}
else if ($requestPage == "botuser")
{
	$page = "include/botuser.php";
}

require("class/Translation.php");
$translation = new Translation($class_db, (isset($_SESSION['languageid']) && is_numeric($_SESSION['languageid']) ? $_SESSION['languageid'] : null));

require("class/BBCode.php");
require("class/BotTelnet.php");
$botTelnet = new BotTelnet($class_db);

$output = implode(" ", file("templates/index.tmpl"));
$for_output = "";

if (file_exists($page))
{
	include($page);
}
else
{
	include($page404);
}

$allowLanguageBox = true;
if (isset($configValues['webuisetting_allowlanguagechooser']))
	$allowLanguageBox = !($configValues['webuisetting_allowlanguagechooser'] != 1);

$languagechooser = "";
if ($allowLanguageBox)
{
	$languagechooser = "<div class=\"framemenublock_nowidth\"><div id=\"languagename\">Language:</div>\n";
	$languagechooser .= $translation->getLanguageImageList()."</div>";
}

$allowContactPage = false;
if (isset($configValues['webuisetting_allowcontact']))
{
	if (($configValues['webuisetting_allowcontact'] == 1) || ($configValues['webuisetting_allowcontact'] == 2 && $userid >= 0))
		$allowContactPage = true;
}

$contactLink = "";
if ($allowContactPage)
{
	$contactLink = "<div class=\"framemenublock_big\"><a href=\"index.php?page=register&mode=privacy\" class=\"nounderline\"><img src=\"images/information.png\" border=\"0\" alt=\"\" class=\"middle\"> {webui_register_privacyinfo_title}</a>\n<br>\n<a href=\"index.php?page=contact\" class=\"nounderline\"><img src=\"images/email.png\" border=\"0\" alt=\"\" class=\"middle\"> {webui_contact}</a></div>\n";
}
else
{
	$contactLink = "<div class=\"framemenublock_single\"><a href=\"index.php?page=register&mode=privacy\" class=\"nounderline\"><img src=\"images/information.png\" border=\"0\" alt=\"\" class=\"middle\"> {webui_register_privacyinfo_title}</a></div>\n";
}

$frametop = "";
if ($userid == -1)
{
	$allowRegistration = false;
	if (isset($configValues['webuisetting_allowregistration']))
		$allowRegistration = ($configValues['webuisetting_allowregistration'] == 1);

	$frametop = implode(" ", file("templates/framemenu.tmpl"));
	
	if ($allowRegistration)	$frametop = str_replace('{registerlink}', "<a href=\"index.php?page=register\" class=\"nounderline\"><img src=\"images/user_add.png\" border=\"0\" alt=\"\"> {webui_register}</a><br>", $frametop);
	else $frametop = str_replace('{registerlink}', "", $frametop);
	
	if ($verifyFailReason != null)
	{
		$frametop .= "<br><div align=\"center\" class=\"errormessage\">".$verifyFailReason."</div>";
	}
	
	$frametop = $translation->replaceTranslationsForPage($frametop, "frameleft");
}
else
{
	$allowCreateBot = false;
	if (isset($configValues['webuisetting_allowcreatebot']))
		$allowCreateBot = ($configValues['webuisetting_allowcreatebot'] == 1);
	
	$botcount = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE user_id = ".$userid);
	$frametop = implode(" ", file("templates/framemenu_user.tmpl"));
	$frametop_admin = implode(" ", file("templates/framemenu_user_admin.tmpl"));
	
	$frametop = str_replace('{loginname}', $_SESSION['username'], $frametop);
	$frametop = str_replace('{botcount}', $botcount[0], $frametop);
	
	if (((isset($_SESSION['adminlevel']) ? $_SESSION['adminlevel'] : "0") > 0) || $allowCreateBot)
	{
		$frametop = str_replace('{botcreate}', implode(" ", file("templates/framemenu_user_botcreate.tmpl")), $frametop);
	}
	else
	{
		$frametop = str_replace('{botcreate}', "", $frametop);
	}
	
	$frametop_admin_used = false;
	if ((isset($_SESSION['adminlevel']) ? $_SESSION['adminlevel'] : "0") > 0)
	{
		$frametop_admin = str_replace('{usermanager}', implode(" ", file("templates/framemenu_user_usermanager.tmpl")), $frametop_admin);
		$frametop_admin_used = true;
		
		$frametop = str_replace('{botlistmode}', "&amp;list=all", $frametop);
	}
	else
	{
		$frametop_admin = str_replace('{usermanager}', "", $frametop_admin);
		$frametop = str_replace('{botlistmode}', "", $frametop);
	}
	
	if ((isset($_SESSION['adminlevel']) ? $_SESSION['adminlevel'] : "0") > 1)
	{
		$frametop_admin = str_replace('{settings}', implode(" ", file("templates/framemenu_user_settings.tmpl")), $frametop_admin);
		$frametop_admin_used = true;
	}
	else
	{
		$frametop_admin = str_replace('{settings}', "", $frametop_admin);
	}
	
	if ($frametop_admin_used)
	{
		$frametop = str_replace('{frameleft_user_admin}', $frametop_admin, $frametop);
	}
	else
	{
		$frametop = str_replace('{frameleft_user_admin}', "", $frametop);
	}
	
	$frametop = $translation->replaceTranslationsForPage($frametop, "frameleft_user");
}

$frametop = str_replace('{language_menu}', ($allowLanguageBox ? $languagechooser : ""), $frametop);
$frametop = str_replace('{contactpage}', $contactLink, $frametop);

if ((isset($_SESSION['adminlevel']) ? $_SESSION['adminlevel'] : "0") > 0)
	$output = str_replace('{build}', "<span class=\"build\"> Build ".$configValues['webui_build']."</span>", $output);
else
	$output = str_replace('{build}', "", $output);

$output = str_replace('{displayplusminus}', ($displayplusminus ? "" : "display:none;"), $output);
$output = str_replace('{content}', $for_output, $output);
$output = str_replace('{frametop}', $frametop, $output);
$output = $translation->replaceTranslationsForPage($output, "various");
$output = str_replace('{css_file}', (isset($configValues['webuisetting_themecss']) ? $configValues['webuisetting_themecss'] : "bright"), $output);

echo $output;

?>