<?PHP

require_once("include/formularfunctions.php");
require_once("include/botheaderfunctions.php");

function getPermissionLevelComboBoxDef($name, $default, $disabled = false)
{	
	$formChooser = "<select name=\"".$name."\" id=\"".$name."\" size=\"1\" onchange=\"toggleDescriptionMessages();\" class=\"textinput\"".($disabled ? " disabled" : "").">\n";
	
	$formChooser = $formChooser."<option value=\"1\"".(1 == $default ? " selected" : "").">{webui_botuser_permissionfull}</option>\n";
	$formChooser = $formChooser."<option value=\"0\"".(0 == $default ? " selected" : "").">{webui_botuser_permissiondefault}</option>\n";
	$formChooser = $formChooser."<option value=\"-1\"".(-1 == $default ? " selected" : "").">{webui_botuser_permissionremove}</option>\n";
	
	return $formChooser."\n</select>\n";
}

$useBotID = -1;
$isAllowed = false;
$canDoChanges = false;

if (isset($_REQUEST['botID']) && is_numeric($_REQUEST['botID']))
{
	if ((isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0))
	{
		$isAllowed = true;
		$canDoChanges = true;
	}
	else
	{
		$isValid = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE user_id = ".$userid." AND instance_id = ".$_REQUEST['botID']." AND fullaccess = TRUE");
		if ($isValid[0] == 1)
		{
			$isAllowed = true;
			$canDoChanges = true;
		}
		
		if (!$isAllowed)
		{
			$isValid = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE user_id = ".$userid." AND instance_id = ".$_REQUEST['botID']);
			if ($isValid[0] == 1)
			{
				$isAllowed = true;
			}
		}
	}
	
	$isValid = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_instances WHERE id = ".$_REQUEST['botID']);
	if ($isValid[0] == 1)
	{
		$useBotID = $_REQUEST['botID'];
	}
}

if ($useBotID > 0 && $isAllowed)
{
	$status = null;
	if (isset($_GET['mode']) && $_GET['mode'] == "addUser")
	{
		if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0)
		{
			$for_output .= implode(" ", file("templates/botuser_add.tmpl"));
			$for_output = str_replace('{bot_header}', getBotHeader($class_db, $useBotID), $for_output);
			$for_output = str_replace('{botID}', $useBotID, $for_output);
			$for_output = str_replace('{botuser_userlist}', getUserListComboBoxDef("botuser_userlist", "-1", $class_db), $for_output);
		}
	}
	else if (isset($_POST['mode']) && $_POST['mode'] == "addUser")
	{
		if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0)
		{
			if (isset($_POST['botuser_userlist']) && is_numeric($_POST['botuser_userlist']))
			{
				$isValid = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE user_id = ".$_POST['botuser_userlist']." AND instance_id = ".$useBotID);
				if ($isValid[0] >= 1)
					$status = "{webui_botuser_alreadyexist}";
				else
				{
					$class_db->db_query("INSERT INTO jts3servermodwebui_usersinstances (`user_id`, `instance_id`, `fullaccess`) VALUES (".$class_db->getRealEscapeString($_POST['botuser_userlist']).", ".$useBotID.", false)");
					$status = "{webui_botuser_addedsuccessfully}";
				}
			}
			else
			{
				$status = "Error: Call with invalid arguments!";
			}
		}
	}
	else if (isset($_GET['mode']) && $_GET['mode'] == "changePermission")
	{
		if (isset($_GET['userid']) && is_numeric($_GET['userid']))
		{
			$userInfo = $class_db->getQuery("SELECT id, name, fullaccess FROM jts3servermodwebui_users, jts3servermodwebui_usersinstances WHERE jts3servermodwebui_users.id = jts3servermodwebui_usersinstances.user_id AND user_id = ".$_GET['userid']." AND instance_id = ".$useBotID);
			
			$for_output .= implode(" ", file("templates/botuser_edit.tmpl"));
			$for_output = str_replace('{bot_header}', getBotHeader($class_db, $useBotID), $for_output);
			$for_output = str_replace('{botID}', $useBotID, $for_output);
			$for_output = str_replace('{userid}', $_GET['userid'], $for_output);
			$for_output = str_replace('{webuiuser_name}', $userInfo[1], $for_output);
			$for_output = str_replace('{botuser_permissionlist}', getPermissionLevelComboBoxDef("botuser_permissionlist", $userInfo[2]), $for_output);
			
			$for_output = str_replace('{description_full_class}', ($userInfo[2] == true ? "" : "hidden"), $for_output);
			$for_output = str_replace('{description_normal_class}', ($userInfo[2] == false ? "" : "hidden"), $for_output);
		}
		else
		{
			$status = "Error: Call with invalid arguments!";
		}
	}
	else if (isset($_POST['mode']) && $_POST['mode'] == "changePermission")
	{
		if (isset($_POST['botuser_permissionlist']) && is_numeric($_POST['botuser_permissionlist']) && isset($_POST['userid']) && is_numeric($_POST['userid']))
		{
			if ($canDoChanges || ($_POST['botuser_permissionlist'] == -1 && $_POST['userid'] == $userid))
			{
				if ($_POST['botuser_permissionlist'] == 1)
				{
					$class_db->db_query("UPDATE jts3servermodwebui_usersinstances SET `fullaccess` = 1 WHERE `user_id` = ".$_POST['userid']." AND `instance_id` = ".$useBotID);
					$status = "{webui_botuser_changedsuccessfully}";
				}
				else
				{
					$isAllowed = true;
					$isValid = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE user_id = ".$_POST['userid']." AND instance_id = ".$useBotID." AND fullaccess = TRUE");
					if ($isValid[0] == 1)
					{
						$isValid = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE instance_id = ".$useBotID." AND fullaccess = TRUE");
						if ($isValid[0] < 2)
							$isAllowed = false;
					}
					
					if ($isAllowed)
					{
						if ($_POST['botuser_permissionlist'] == 0)
						{
							$class_db->db_query("UPDATE jts3servermodwebui_usersinstances SET `fullaccess` = 0 WHERE `user_id` = ".$_POST['userid']." AND `instance_id` = ".$useBotID);
							$status = "{webui_botuser_changedsuccessfully}";
						}
						else if ($_POST['botuser_permissionlist'] == -1)
						{
							$class_db->db_query("DELETE FROM jts3servermodwebui_usersinstances WHERE `user_id` = ".$_POST['userid']." AND `instance_id` = ".$useBotID);
							$status = "{webui_botuser_permdeletedsuccessfully}";
						}
					}
					else
					{
						$status = "{webui_botuser_notallowedlastowner}";
					}
				}
			}
			else
			{
				$status = "{webui_botuser_nopermission}";
			}
		}
		else
		{
			$status = "Error: Call with invalid arguments!";
		}
	}
	
	if ($for_output == "")
	{
		$resListUsers = $class_db->db_query("SELECT id, name, adminlevel, userstatus, lastvisit, fullaccess FROM jts3servermodwebui_users, jts3servermodwebui_usersinstances WHERE jts3servermodwebui_users.id = jts3servermodwebui_usersinstances.user_id AND instance_id = ".$useBotID);
			
		$userIcons = file("templates/userlist_icons.tmpl");
		
		if (mysqli_num_rows($resListUsers) > 0)
		{
			$for_output .= implode(" ", file("templates/botuser.tmpl"));
			$userlistentrytmpl = implode(" ", file("templates/botuser_entry.tmpl"));
			
			$userlistContent = "";
			while($row = mysqli_fetch_row($resListUsers))
			{
				$userCurrent = $userIcons[2];
				if ($row[3] < 0)
				{
					$userCurrent = $userIcons[4];
				}
				else if ($row[2] > 1)
				{
					$userCurrent = $userIcons[0];
				}
				else if ($row[2] > 0)
				{
					$userCurrent = $userIcons[1];
				}
				else if ($row[5] == false)
				{
					$userCurrent = $userIcons[3];
				}
				
				$userlistContent .= $userlistentrytmpl;
				$userlistContent = str_replace('{userstate}', $userCurrent, $userlistContent);
				$userlistContent = str_replace('{userid}', $row[0], $userlistContent);
				$userlistContent = str_replace('{username}', $row[1], $userlistContent);
				$userlistContent = str_replace('{lastvisit}', getFormattedTime($row[4], $translation), $userlistContent);
			}
			
			$for_output = str_replace('{icon_userFullAdmin}', $userIcons[0], $for_output);
			$for_output = str_replace('{icon_userAdmin}', $userIcons[1], $for_output);
			$for_output = str_replace('{icon_userActiveFullAccess}', $userIcons[2], $for_output);
			$for_output = str_replace('{icon_userActive}', $userIcons[3], $for_output);
			$for_output = str_replace('{icon_userDisabled}', $userIcons[4], $for_output);
			
			$for_output = str_replace('{userlistcontent}', $userlistContent, $for_output);
			$for_output = str_replace('{webui_userimageactive}', "{webui_botuser_permissiondefault}", $for_output);
			$for_output = str_replace('{adduserblock}', ((isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0) ? implode(" ", file("templates/botuser_adduserbutton.tmpl")) : "{webui_botuser_adduseronlyadministrators}"), $for_output);
			$for_output = str_replace('{bot_header}', getBotHeader($class_db, $useBotID), $for_output);
			$for_output = str_replace('{botID}', $useBotID, $for_output);
			$for_output = addStatusMessage($for_output, $status);
		}
	}
}
else if ($useBotID > 0)
{
	$for_output = implode(" ", file("templates/backtomain.tmpl"));
	$for_output = str_replace('{title}', "{webui_botuser_title}", $for_output);
	$for_output = str_replace('{message}', "{webui_onlyadministrator}", $for_output);
}
else
{
	$for_output = implode(" ", file("templates/backtomain.tmpl"));
	$for_output = str_replace('{title}', "{webui_botuser_title}", $for_output);
	$for_output = str_replace('{message}', "{webui_botnotexists}", $for_output);
}

$for_output = $translation->replaceTranslationsForPage($for_output, "botuser");
$for_output = $translation->replaceTranslationsForPage($for_output, "userlist");

?>