<?PHP

$useBotID = -1;
$logEnabled = 2;
$botlogcount = 20;

require_once("include/botlogview_functions.php");
require_once("include/botheaderfunctions.php");
require_once("include/formularfunctions.php");

function getLogEntryCountChooser($botID, $logType)
{
	$formChooser = "<select name=\"logentriesperpage\" size=\"1\" class=\"textinput\" onchange=\"loadOtherPage(this.value)\">\n";
	
	$formChooser = $formChooser."<option value=\"\">{webui_numberoflogentriesperpage}</option>\n";
	$formChooser = $formChooser."<option value=\"index.php?page=botlogview&botID=".$botID."&logtype=".$logType."&logentriesperpage=20\">20</option>\n";
	$formChooser = $formChooser."<option value=\"index.php?page=botlogview&botID=".$botID."&logtype=".$logType."&logentriesperpage=50\">50</option>\n";
	$formChooser = $formChooser."<option value=\"index.php?page=botlogview&botID=".$botID."&logtype=".$logType."&logentriesperpage=100\">100</option>\n";
	$formChooser = $formChooser."<option value=\"index.php?page=botlogview&botID=".$botID."&logtype=".$logType."&logentriesperpage=200\">200</option>\n";
	
	return $formChooser."\n</select>\n";
}

if (isset($_GET['botID']) && is_numeric($_GET['botID']))
{
	$isAllowed = false;
	
	if ((isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0))
	{
		$isAllowed = true;
	}
	else
	{
		$isValid = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE user_id = ".$userid." AND instance_id = ".$_GET['botID']);
		if ($isValid[0] == 1)
		{
			$isAllowed = true;
		}
	}
	
	if ($isAllowed)
	{
		$isValid = $class_db->getQuery("SELECT COUNT(*), logmode FROM jts3servermod_instances WHERE id = ".$_GET['botID']);
		if ($isValid[0] == 1)
		{
			$useBotID = $_GET['botID'];
			if (is_numeric($isValid[1]))
				$logEnabled = $isValid[1];
		}
	}
}

if ($useBotID > 0 && $logEnabled == 2)
{
	if (isset($_GET['mode']) && $_GET['mode'] == "confirmdeletelog")
	{
		if (isset($_POST['logdeletetime']) && is_numeric($_POST['logdeletetime']))
		{
			$for_output = getDeleteConfirm($useBotID, $_POST['logdeletetime'], (isset($_POST['logdeleteconnections']) && $_POST['logdeleteconnections'] == "yes" ? true : false), $class_db);
		}
	}
	else
	{
		$status = null;
		
		if (isset($_POST['mode']) && $_POST['mode'] == "deletelog")
		{
			if (isset($_POST['logdeletetime']) && is_numeric($_POST['logdeletetime']) && isset($_POST['deleteYes']))
			{
				$deleteConnections = (isset($_POST['logdeleteconnections']) && $_POST['logdeleteconnections'] == "yes" ? true : false);
				$class_db->db_query("DELETE FROM jts3servermod_log WHERE".($deleteConnections ? "" : " logtype != \"CLIENT_CONNECTED\" AND")." instance_id = ".$useBotID.($_POST['logdeletetime'] > 0 ? " AND logtime < ".((time() - $_POST['logdeletetime']) * 1000) : ""));
				$status = "{webui_deletelog_successful}";
			}
			else
			{
				$status = "{webui_deletelog_aborted}";
			}
		}
		
		$usePage = 1;
		if (isset($_GET['logpage']) && is_numeric($_GET['logpage'])) $usePage = $_GET['logpage'];
		
		$logtypeSearch = " AND logtype != \"CLIENT_CONNECTED\" ";
		$logtypeLink = "";
		if (isset($_GET['logtype']))
		{
			$logtypeLink = "&amp;logtype=".$_GET['logtype'];
			if ($_GET['logtype'] == "warning")
			{
				$logtypeSearch = " AND logtype IN (\"WARNING\", \"ERROR\", \"EXCEPTION\", \"CRITICAL\", \"STATUS\") ";
			}
			else if ($_GET['logtype'] == "login")
			{
				$logtypeSearch = " AND logtype = \"CLIENT_CONNECTED\" ";
			}
		}
		
		$resserverinfo = $class_db->db_query("SELECT name, ts3serverip, ts3portid FROM jts3servermod_instances WHERE id = ".$useBotID);
		$serverInfo = mysqli_fetch_array($resserverinfo);
		
		// Start Save Block
		if (isset($_GET['outputtype']) && $_GET['outputtype'] == "save")
		{
			header('Content-type: text/plain', true);
			if (isset($_GET['logtype']) && $_GET['logtype'] == "login")
				header('Content-Disposition: attachment; filename=JTS3ServerMod_'.$serverInfo[0].'_login.csv', true);
			else
				header('Content-Disposition: attachment; filename=JTS3ServerMod_'.$serverInfo[0].'.log', true);
			
			$linebreak = "\r\n";
			if (strpos(strtolower($_SERVER['HTTP_USER_AGENT']), "windows") === false)
				$linebreak = "\n";
			
			$firstLine = true;
			setlocale(LC_TIME, "en_US");
			$reslog = $class_db->db_query("SELECT logtime, functionname, logtype, message FROM jts3servermod_log WHERE instance_id = ".$useBotID.$logtypeSearch."ORDER BY logtime ASC");
			while($row = mysqli_fetch_row($reslog))
			{
				if (!$firstLine)
				{
					echo $linebreak;
				}
				
				echo strftime("%Y-%m-%d %H:%M:%S", ($row[0] / 1000));
				if (isset($_GET['logtype']) && $_GET['logtype'] == "login")
				{
					echo ";";
					echo $row[3];
				}
				else
				{
					echo "\t";
					echo $row[1];
					echo "\t";
					echo $row[2];
					echo "\t";
					echo trim($row[3]);
				}
				
				$firstLine = false;
			}
			die();
		}
		// End Save Block
		
		$logEntryCount = $class_db->getQuery("SELECT lastbotlogcount FROM jts3servermodwebui_users WHERE id = ".$_SESSION['userid']);
		if ($logEntryCount[0] >= 10 && $logEntryCount[0] <= 250)
			$botlogcount = $logEntryCount[0];
		
		if (isset($_GET['logentriesperpage']) && is_numeric($_GET['logentriesperpage']) && $_GET['logentriesperpage'] <= 250 && $_GET['logentriesperpage'] >= 10)
		{
			if ($botlogcount != $_GET['logentriesperpage'])
			{
				$class_db->db_query("UPDATE jts3servermodwebui_users SET lastbotlogcount = ".$_GET['logentriesperpage']." WHERE id = ".$_SESSION['userid']);
				$botlogcount = $_GET['logentriesperpage'];
			}
		}
		
		$loglevel = array();
		$loglevel['DEBUG'] = 0;
		$loglevel['INFO'] = 1;
		$loglevel['WARNING'] = 2;
		$loglevel['ERROR'] = 3;
		$loglevel['EXCEPTION'] = 4;
		$loglevel['CRITICAL'] = 5;
		$loglevel['STATUS'] = 6;
		$logtypeimage = file("templates/botlog_logtype_images.tmpl");
		
		$logentrytmpl = implode(" ", file("templates/botlog_entry.tmpl"));
		$tablecontent = "";
		$reslog = $class_db->db_query("SELECT logtime, functionname, logtype, message FROM jts3servermod_log WHERE instance_id = ".$useBotID.$logtypeSearch."ORDER BY logtime DESC LIMIT ".(($usePage - 1) * $botlogcount).",".$botlogcount);
		$visiblelogentries = mysqli_num_rows($reslog);
		
		while($row = mysqli_fetch_row($reslog))
		{
			$tablecontent .= $logentrytmpl;
			$tablecontent = str_replace('{logdate}', $translation->getDate($row[0] / 1000), $tablecontent);
			
			if (isset($_GET['logtype']) && $_GET['logtype'] == "login")
			{
				$logindata = explode(";", $row[3]);
				$tablecontent = str_replace('{functionname}', nl2br(htmlentities($logindata[2], ENT_QUOTES, "UTF-8")), $tablecontent);
				$tablecontent = str_replace('{logtype}', nl2br(htmlentities($logindata[1], ENT_QUOTES, "UTF-8")), $tablecontent);
				$tablecontent = str_replace('{logmessage}', nl2br(htmlentities($logindata[0], ENT_QUOTES, "UTF-8")), $tablecontent);
			}
			else
			{
				$functionname_link = "";
				if ($row[1] == "JTS3ServerMod")
				{
					$functionname_link = "<a href=\"index.php?page=botmanager&amp;mode=editGeneralSettings&amp;botID=".$useBotID."\" class=\"nounderline\">JTS3ServerMod</a>";
				}
				else if ($row[1] == "slotchecker")
				{
					$functionname_link = "<a href=\"index.php?page=botmanager&amp;mode=editSlotCheckerSettings&amp;botID=".$useBotID."\" class=\"nounderline\">".$translation->getTranslation("webui_slotchecker_title")."</a>";
				}
				else
				{
					$functionname_link = "<a href=\"index.php?page=botmanager&amp;mode=editBotFunction&amp;function_class=&amp;function_prefix=".$row[1]."&amp;botID=".$useBotID."\" class=\"nounderline\">".$row[1]."</a>";
				}
				
				$tablecontent = str_replace('{functionname}', $functionname_link, $tablecontent);
				$tablecontent = str_replace('{logtype}', $logtypeimage[$loglevel[$row[2]]], $tablecontent);
				$tablecontent = str_replace('{logmessage}', nl2br(htmlentities($row[3], ENT_QUOTES, "UTF-8")), $tablecontent);
			}
		}
		
		if ($tablecontent == "")
		{
			$tablecontent = "<tr><td colspan=\"4\" align=\"center\">{webui_nologentries}</td></tr>";
		}
		
		$logtmpl = implode(" ", file("templates/botlog.tmpl"));
		$logtmpl = str_replace('{bot_header}', getBotHeader($class_db, $useBotID, $serverInfo), $logtmpl);
		$logtmpl = str_replace('{tableheader}', implode(" ", file((isset($_GET['logtype']) && $_GET['logtype'] == "login" ? "templates/botlog_loginheader.tmpl" : "templates/botlog_logheader.tmpl"))), $logtmpl);
		$logtmpl = str_replace('{logcontent}', $tablecontent, $logtmpl);
		$logtmpl = str_replace('{botID}', $useBotID, $logtmpl);
		$logtmpl = str_replace('{webui_botedit}', $translation->getTranslation("webui_botedit"), $logtmpl);
		$logtmpl = str_replace('{webui_botlogentries_tabletitle}', $translation->getTranslation("webui_botlogentries_tabletitle"), $logtmpl);
		$logtmpl = str_replace('{count}', $visiblelogentries, $logtmpl);
		$logtmpl = str_replace('{logpage}', $usePage, $logtmpl);
		$logtmpl = str_replace('{logentrycountchooser}', getLogEntryCountChooser($useBotID, (isset($_GET['logtype']) ? $_GET['logtype'] : "all")), $logtmpl);
		$logtmpl = str_replace('{logdeletetime}', getTimeDeleteComboBoxDef(), $logtmpl);
		$logtmpl = str_replace('{logtype_name}', (isset($_GET['logtype']) ? $_GET['logtype'] : "all"), $logtmpl);
		if (!isset($_GET['logtype']) || $_GET['logtype'] != "login") $logtmpl = str_replace('{webui_botlogentries_loginlog_info}', "", $logtmpl);
		
		$logtmpl = str_replace('{icon_debug}', $logtypeimage[$loglevel['DEBUG']], $logtmpl);
		$logtmpl = str_replace('{icon_information}', $logtypeimage[$loglevel['INFO']], $logtmpl);
		$logtmpl = str_replace('{icon_warning}', $logtypeimage[$loglevel['WARNING']], $logtmpl);
		$logtmpl = str_replace('{icon_error}', $logtypeimage[$loglevel['ERROR']], $logtmpl);
		$logtmpl = str_replace('{icon_critical}', $logtypeimage[$loglevel['CRITICAL']], $logtmpl);
		$logtmpl = str_replace('{icon_status}', $logtypeimage[$loglevel['STATUS']], $logtmpl);
		
		$logtmpl = addStatusMessage($logtmpl, $status);
		
		$logCount = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_log WHERE instance_id = ".$useBotID.$logtypeSearch);
		$logfooter = "{webui_page} (".$usePage.") - <a href=\"index.php?page=botlogview&amp;botID=".$useBotID."&amp;logpage=1".$logtypeLink."\">1</a>"; 
		for ($i = 2; $i <= ceil($logCount[0] / $botlogcount); $i++)
		{
			$logfooter .= ", <a href=\"index.php?page=botlogview&amp;botID=".$useBotID."&amp;logpage=".$i.$logtypeLink."\">".$i."</a>";
		}
		
		$logtmpl = str_replace('{logviewpages}', $logfooter, $logtmpl);
		
		$for_output = $logtmpl;
	}
}
else if ($useBotID > 0 && $logEnabled == 1)
{
	$resserverinfo = $class_db->db_query("SELECT name, ts3serverip, ts3portid FROM jts3servermod_instances WHERE id = ".$useBotID);
	$serverInfo = mysqli_fetch_array($resserverinfo);

	$logtmpl = implode(" ", file("templates/botlog_disabled.tmpl"));
	$logtmpl = str_replace('{bot_header}', getBotHeader($class_db, $useBotID, $serverInfo), $logtmpl);
	$logtmpl = str_replace('{statusmsg}', "{webui_botlog_file}", $logtmpl);
	$for_output = $logtmpl;
	
}
else if ($useBotID > 0 && $logEnabled == 0)
{
	$resserverinfo = $class_db->db_query("SELECT name, ts3serverip, ts3portid FROM jts3servermod_instances WHERE id = ".$useBotID);
	$serverInfo = mysqli_fetch_array($resserverinfo);

	$logtmpl = implode(" ", file("templates/botlog_disabled.tmpl"));
	$logtmpl = str_replace('{bot_header}', getBotHeader($class_db, $useBotID, $serverInfo), $logtmpl);
	$logtmpl = str_replace('{statusmsg}', "{webui_botlog_disabled}", $logtmpl);
	$for_output = $logtmpl;
}
else
{
	$logtmpl = implode(" ", file("templates/botlog_disabled.tmpl"));
	$logtmpl = str_replace('{bot_header}', "", $logtmpl);
	$logtmpl = str_replace('{statusmsg}', "{webui_error_logviewforbidden}", $logtmpl);
	$for_output = $logtmpl;
}

$for_output = $translation->replaceTranslationsForPage($for_output, "botlogview");
$for_output = $translation->replaceTranslationsForPage($for_output, "formularfunctions");

?>