<?PHP

function getUserBotsOnlyOneFullAccess($class_db, $userid)
{
	if (!is_numeric($userid)) return -1;
	
	$userBotListResultSize = 0;
	$userBotListResult = array();
	$botListResult = array();
	
	$botList = $class_db->db_query("SELECT instance_id, name, COUNT(*) AS numOfUsers FROM jts3servermodwebui_usersinstances, jts3servermod_instances WHERE jts3servermodwebui_usersinstances.instance_id = jts3servermod_instances.id AND fullaccess = 1 GROUP BY instance_id");
	while($row = mysqli_fetch_row($botList))
	{
		$botListResult[$row[0]]['name'] = $row[1];
		$botListResult[$row[0]]['numOfUsers'] = $row[2];
	}

	$userBotList = $class_db->db_query("SELECT instance_id FROM jts3servermodwebui_usersinstances WHERE fullaccess = 1 AND user_id = ".$userid);
	while($row = mysqli_fetch_row($userBotList))
	{
		if ($botListResult[$row[0]]['numOfUsers'] == 1)
		{
			$userBotListResult[$userBotListResultSize]['id'] = $row[0];
			$userBotListResult[$userBotListResultSize]['name'] = $botListResult[$row[0]]['name'];
			++$userBotListResultSize;
		}
	}
	
	return $userBotListResult;
}

function deleteBot($class_db, $botTelnet, $instanceid, $doInstanceListReload = true)
{
	if (!is_numeric($instanceid)) return 1;
	if (!is_numeric($_SESSION['userid'])) return 2;

	$isOwner = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE fullaccess = 1 AND instance_id = ".$instanceid." AND user_id = ".$_SESSION['userid']);

	if ($isOwner[0] == 1 || (isset($_SESSION['adminlevel']) && is_numeric($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0))
	{
		$botname = null;
		$botinfo = $class_db->db_query("SELECT name FROM jts3servermod_instances WHERE id = ".$instanceid);
		if (mysqli_num_rows($botinfo) == 1)
		{
			$botname = mysqli_fetch_array($botinfo);
		}
		else
		{
			return 4;
		}

		$botStatus = $botTelnet->getBotStatus($botname[0]);
		if ($botStatus == 1) $botTelnet->stopBot($botname[0]);

		$class_db->db_query("DELETE FROM jts3servermod_log WHERE `instance_id` = ".$instanceid);
		$class_db->db_query("DELETE FROM jts3servermod_advertising WHERE `instance_id` = ".$instanceid);
		$class_db->db_query("DELETE FROM jts3servermod_badchannelname WHERE `instance_id` = ".$instanceid);
		$class_db->db_query("DELETE FROM jts3servermod_badnickname WHERE `instance_id` = ".$instanceid);
		$class_db->db_query("DELETE FROM jts3servermod_servergroupprotection WHERE `instance_id` = ".$instanceid);
		$class_db->db_query("DELETE FROM jts3servermodwebui_usersinstances WHERE `instance_id` = ".$instanceid);
		$class_db->db_query("DELETE FROM jts3servermod_instanceconfig WHERE `instance_id` = ".$instanceid);
		$class_db->db_query("DELETE FROM jts3servermod_instances WHERE `id` = ".$instanceid);

		if ($doInstanceListReload) $botTelnet->instancelistReload();
	}
	else
	{
		return 3;
	}

	return 0;
}

function deleteAllBotsOfUser($class_db, $botTelnet, $userid)
{
	if (!is_numeric($userid)) return -1;
	
	$userBotList = getUserBotsOnlyOneFullAccess($class_db, $userid);

	$deletedCount = 0;
	foreach($userBotList as $userBot)
	{
		if (deleteBot($class_db, $botTelnet, $userBot['id'], false) == 0)
		{
			++$deletedCount;
		}
	}

	if ($deletedCount > 0) $botTelnet->instancelistReload();

	return $deletedCount;
}

function changeBotOwner($class_db, $instanceid, $currentOwner, $newOwner)
{
	if (!is_numeric($instanceid)) return 2;
	if (!is_numeric($currentOwner)) return 3;
	if (!is_numeric($newOwner)) return 4;

	if (isset($_SESSION['adminlevel']) && is_numeric($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0)
	{
		$isOwner = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE fullaccess = 1 AND instance_id = ".$instanceid." AND user_id = ".$currentOwner);

		if ($isOwner[0] == 1)
		{
			$class_db->db_query("UPDATE `jts3servermodwebui_usersinstances` SET `user_id` = '".$class_db->getRealEscapeString($newOwner)."' WHERE instance_id = ".$instanceid." AND user_id = ".$currentOwner);
		}
		else
		{
			return 5;
		}
	}
	else
	{
		return 6;
	}
}

function changeOwnerOfAllUserBots($class_db, $currentOwner, $newOwner)
{
	if (!is_numeric($currentOwner)) return -1;
	if (!is_numeric($newOwner)) return -2;
	
	$userBotList = getUserBotsOnlyOneFullAccess($class_db, $currentOwner);

	$changedCount = 0;
	foreach($userBotList as $userBot)
	{
		if (changeBotOwner($class_db, $userBot['id'], $currentOwner, $newOwner) == 0)
		{
			++$changedCount;
		}
	}

	return $changedCount;
}

?>