<?PHP

require_once("include/formularfunctions.php");
require_once("include/botheaderfunctions.php");
require_once("class/PWCrypt.php");

$currentUserList = FALSE;
$currentServerGrpList = FALSE;
$currentChannelList = FALSE;
$lastTS3Status = NULL;

function getTS3ServerInformations($serverAddress, $serverQueryPort, $loginName, $loginPassword, $serverVirtualServerID, $serverVirtualServerPort, $sshMode)
{
	$retValue = -3;
	
	require_once("class/TS3Telnet.php");
	$telnet = new TS3Telnet(null, null, $serverAddress, $serverQueryPort, $loginName, $loginPassword, $serverVirtualServerID, $serverVirtualServerPort, $sshMode);
	$result = $telnet->TSConnect();
	
	if ($result === true)
	{
		$result = $telnet->TSLogin();
		if (is_array($result) && $result['id'] == 0)
		{
			$result = $telnet->SelectServer();
			if (is_array($result) && $result['id'] == 0)
			{
				$retValue = 1;
				global $currentUserList, $currentChannelList, $currentServerGrpList;
				$currentUserList = $telnet->GetList("usersonline");
				$currentChannelList = $telnet->GetList("channels");
				$currentServerGrpList = $telnet->GetList("servergrouplist");
			}
			else
			{
				$retValue = -2;
				if (is_array($result))
				{
					global $lastTS3Status;
					$lastTS3Status = $result['msg'].(isset($result['extra_msg']) ? " - ".$result['extra_msg'] : "");
				}
			}
		}
		else
		{
			$retValue = 0;
			if (is_array($result))
			{
				global $lastTS3Status;
				$lastTS3Status = $result['msg'].(isset($result['extra_msg']) ? " - ".$result['extra_msg'] : "");
			}
		}
	}
	else
	{
		$retValue = -1;
		if (is_array($result))
		{
			global $lastTS3Status;
			if (isset($result['retvalue']))
				$retValue = $result['retvalue'];
			
			$lastTS3Status = $result['msg'].(isset($result['extra_msg']) ? " - ".$result['extra_msg'] : "");
		}
	}

	$telnet->Disconnect();
	
	return $retValue;
}

function getFormular($class_db, $currentUserID, $copyFromID = -1, $defaultMode = false, $status = null)
{
	$createForUserID = $currentUserID;
	$createForUserName = $_SESSION['username'];
	$configValues = array();
	if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] >= 1)
	{
		$PWCrypt = new PWCrypt();
		
		$resList = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermodwebui_settings WHERE configkey LIKE 'defbotsetting_%'");
		
		while($row = mysqli_fetch_row($resList))
		{
			if ($row[0] == "defbotsetting_ts3_server_query_password")
				$configValues[substr($row[0], 14)] = $PWCrypt->decryptString($row[1]);
			else
				$configValues[substr($row[0], 14)] = $row[1];
		}
		
		if (isset($_POST['targetid']) && is_numeric($_POST['targetid']))
		{
			$createForUserID = $_POST['targetid'];
		}
		else if (isset($_GET['botcreateuserid']) && is_numeric($_GET['botcreateuserid']))
		{
			$createForUserID = $_GET['botcreateuserid'];
		}
		
		if ($currentUserID != $createForUserID)
		{
			$resUserName = $class_db->db_query("SELECT name FROM jts3servermodwebui_users WHERE id = ".$createForUserID);
			if (mysqli_num_rows($resUserName) == 1)
			{
				$curUserName = mysqli_fetch_array($resUserName);
				$createForUserName = $curUserName[0];
			}
			else
			{
				$createForUserID = $currentUserID;
			}
		}
	}
	
	$copyFromBotName = "";
	if ($copyFromID >= 0)
	{
		$resBotName = $class_db->db_query("SELECT name FROM jts3servermod_instances WHERE id = ".$copyFromID);
		if (mysqli_num_rows($resBotName) < 1)
		{
			$botCheckError = implode(" ", file("templates/backtomain.tmpl"));
			$botCheckError = str_replace('{title}', "{webui_botcreate}", $botCheckError);
			$botCheckError = str_replace('{message}', "{webui_botnotexists}", $botCheckError);
			return $botCheckError;
		}
		
		$botCopyAllowed = isBotCreateAllowed($class_db, $copyFromID);
		if ($botCopyAllowed != 1 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 1))
		{
			$botCheckError = implode(" ", file("templates/backtomain.tmpl"));
			$botCheckError = str_replace('{title}', "{webui_botcreate}", $botCheckError);
			$botCheckError = str_replace('{message}', "{webui_onlyadministrator} Haha", $botCheckError);
			return $botCheckError;
		}
		
		$copyFromBotName = mysqli_fetch_array($resBotName);
	}

	if ($defaultMode)
	{
		if (!isset($configValues['ts3_server_address']))
		{
			global $translation;
			$botcreatetmpl = implode(" ", file("templates/backtomain.tmpl"));
			$botcreatetmpl = str_replace('{title}', "{webui_createserver_title} ".$createForUserName, $botcreatetmpl);
			$botcreatetmpl = str_replace('{message}', $translation->getTranslation("webui_defaultbot_none"), $botcreatetmpl);
		}
		else
		{
			$botcreatetmpl = implode(" ", file("templates/botcreate_default.tmpl"));
			$botcreatetmpl = addStatusMessage($botcreatetmpl, $status);
			$botcreatetmpl = str_replace('{targetid}', $createForUserID, $botcreatetmpl);
			$botcreatetmpl = str_replace('{copyfromid}', $copyFromID, $botcreatetmpl);
			$botcreatetmpl = str_replace('{copy_info}', ($copyFromID > 0 ? "{webui_copysettingsfrombot}: ".$copyFromBotName[0] : ""), $botcreatetmpl);
			$botcreatetmpl = str_replace('{username}', $createForUserName, $botcreatetmpl);
			$botcreatetmpl = str_replace('{ts3_virtualserver_id}', "<input type=\"text\" name=\"ts3_virtualserver_id\" value=\"".(isset($_POST['ts3_virtualserver_id']) ? returnSafeHTML($_POST['ts3_virtualserver_id']) : (isset($configValues['ts3_virtualserver_id']) ? $configValues['ts3_virtualserver_id'] : "-1"))."\" size=\"18\" maxlength=\"50\" class=\"textinput\" onkeyup=\"checkVirtualServerSettings();\"></input>\n", $botcreatetmpl);
			$botcreatetmpl = str_replace('{ts3_virtualserver_port}', getTextInput("ts3_virtualserver_port", (isset($_POST['ts3_virtualserver_port']) ? $_POST['ts3_virtualserver_port'] : (isset($configValues['ts3_virtualserver_port']) ? $configValues['ts3_virtualserver_port'] : "9987")), 18, 50, true, 0, 65535), $botcreatetmpl);
		}
	}
	else
	{
		$botcreatetmpl = implode(" ", file("templates/botcreate.tmpl"));
		$botcreatetmpl = addStatusMessage($botcreatetmpl, $status);
		$botcreatetmpl = str_replace('{targetid}', $createForUserID, $botcreatetmpl);
		$botcreatetmpl = str_replace('{copyfromid}', $copyFromID, $botcreatetmpl);
		$botcreatetmpl = str_replace('{copy_info}', ($copyFromID > 0 ? "<b>{webui_copysettingsfrombot}:</b> ".$copyFromBotName[0] : ""), $botcreatetmpl);
		$botcreatetmpl = str_replace('{username}', $createForUserName, $botcreatetmpl);
		$botcreatetmpl = str_replace('{ts3_server_address}', getTextInput("ts3_server_address", (isset($_POST['ts3_server_address']) ? $_POST['ts3_server_address'] : (isset($configValues['ts3_server_address']) ? $configValues['ts3_server_address'] : "")), 18, 50), $botcreatetmpl);
		$botcreatetmpl = str_replace('{ts3_server_query_port}', getTextInput("ts3_server_query_port", (isset($_POST['ts3_server_query_port']) ? $_POST['ts3_server_query_port'] : (isset($configValues['ts3_server_query_port']) ? $configValues['ts3_server_query_port'] : "10011")), 18, 50, true, 0, 65535), $botcreatetmpl);
		$botcreatetmpl = str_replace('{ts3_server_query_login}', getTextInput("ts3_server_query_login", (isset($_POST['ts3_server_query_login']) ? $_POST['ts3_server_query_login'] : (isset($configValues['ts3_server_query_login']) ? $configValues['ts3_server_query_login'] : "")), 18, 50), $botcreatetmpl);
		$botcreatetmpl = str_replace('{ts3_server_query_password}', getTextInput("ts3_server_query_password", (isset($_POST['ts3_server_query_password']) ? $_POST['ts3_server_query_password'] : ""), 18, 50), $botcreatetmpl);
		$botcreatetmpl = str_replace('{ts3_virtualserver_id}', "<input type=\"text\" name=\"ts3_virtualserver_id\" id=\"ts3_virtualserver_id\" value=\"".(isset($_POST['ts3_virtualserver_id']) ? returnSafeHTML($_POST['ts3_virtualserver_id']) : (isset($configValues['ts3_virtualserver_id']) ? $configValues['ts3_virtualserver_id'] : "-1"))."\" maxlength=\"50\" class=\"textinput small\" onkeyup=\"checkVirtualServerSettings();\"></input>\n", $botcreatetmpl);
		$botcreatetmpl = str_replace('{ts3_virtualserver_port}', getTextInput("ts3_virtualserver_port", (isset($_POST['ts3_virtualserver_port']) ? $_POST['ts3_virtualserver_port'] : (isset($configValues['ts3_virtualserver_port']) ? $configValues['ts3_virtualserver_port'] : "9987")), 18, 50, true, 0, 65535), $botcreatetmpl);
		$botcreatetmpl = str_replace('{ts3_server_query_mode}', getQueryModeComboBoxDef((isset($_POST['ts3_server_query_mode']) ? $_POST['ts3_server_query_mode'] : (isset($configValues['ts3_server_query_mode']) ? $configValues['ts3_server_query_mode'] : "raw"))), $botcreatetmpl);
		$botcreatetmpl = str_replace('{bot_slowmode}', getYesNoComboBoxDef("bot_slowmode", (isset($_POST['bot_slowmode']) ? $_POST['bot_slowmode'] : (isset($configValues['bot_slowmode']) ? $configValues['bot_slowmode'] : 0))), $botcreatetmpl);
		
		if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1)
		{
			$botcreatetmpl = str_replace('{makedefault}', " <input type=\"submit\" name=\"MakeDefaultBot\" value=\"{webui_makedefault}\">", $botcreatetmpl);
		}
		else
		{
			$botcreatetmpl = str_replace('{makedefault}', "", $botcreatetmpl);
			$botcreatetmpl = str_replace('{webui_savehelptext}', "", $botcreatetmpl);
			$botcreatetmpl = str_replace(' {webui_botcreate_passwordinfo}', "", $botcreatetmpl);
		}
	}
	
	return $botcreatetmpl;
}

function getFormularForEdit($class_db, $instanceid, $status = null)
{
	if (!is_numeric($instanceid))
	{
		$returnTMPL = implode(" ", file("templates/backtomain.tmpl"));
		$returnTMPL = str_replace('{title}', "{webui_botsettings}", $returnTMPL);
		$returnTMPL = str_replace('{message}', "{webui_error_instanceidvalue}", $returnTMPL);
		return $returnTMPL;
	}

	$configValues = array();
	$resList = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$instanceid." AND configkey IN ".
		"('ts3_server_address', 'ts3_server_query_port', 'ts3_server_query_login', 'ts3_server_query_password', 'ts3_virtualserver_id', 'ts3_virtualserver_port', 'ts3_server_query_mode', 'bot_slowmode')");

	while($row = mysqli_fetch_row($resList))
	{
		$configValues[$row[0]] = $row[1];
	}
	
	$virtualServerID = (isset($_POST['ts3_virtualserver_id']) ? $_POST['ts3_virtualserver_id'] : (isset($configValues['ts3_virtualserver_id']) ? $configValues['ts3_virtualserver_id'] : "-1"));

	$botcreatetmpl = implode(" ", file("templates/botcreate_edit.tmpl"));
	$botcreatetmpl = str_replace('{bot_header}', getBotHeader($class_db, $instanceid), $botcreatetmpl);
	$botcreatetmpl = addStatusMessage($botcreatetmpl, $status);
	$botcreatetmpl = str_replace('{instanceid}', $instanceid, $botcreatetmpl);
	$botcreatetmpl = str_replace('{ts3_server_address}', getTextInput("ts3_server_address", (isset($_POST['ts3_server_address']) ? $_POST['ts3_server_address'] : (isset($configValues['ts3_server_address']) ? $configValues['ts3_server_address'] : "")), 18, 50), $botcreatetmpl);
	$botcreatetmpl = str_replace('{ts3_server_query_port}', getTextInput("ts3_server_query_port", (isset($_POST['ts3_server_query_port']) ? $_POST['ts3_server_query_port'] : (isset($configValues['ts3_server_query_port']) ? $configValues['ts3_server_query_port'] : "")), 18, 50, true, 0, 65535), $botcreatetmpl);
	$botcreatetmpl = str_replace('{ts3_server_query_login}', getTextInput("ts3_server_query_login", (isset($_POST['ts3_server_query_login']) ? $_POST['ts3_server_query_login'] : (isset($configValues['ts3_server_query_login']) ? $configValues['ts3_server_query_login'] : "")), 18, 50), $botcreatetmpl);
	$botcreatetmpl = str_replace('{ts3_server_query_password}', getTextInput("ts3_server_query_password", (isset($_POST['ts3_server_query_password']) ? $_POST['ts3_server_query_password'] : ""), 18, 50), $botcreatetmpl);
	$botcreatetmpl = str_replace('{ts3_virtualserver_id}', "<input type=\"text\" name=\"ts3_virtualserver_id\" id=\"ts3_virtualserver_id\" value=\"".returnSafeHTML($virtualServerID)."\" size=\"18\" maxlength=\"50\" class=\"textinput small\" onkeyup=\"checkVirtualServerSettings();\"></input>\n", $botcreatetmpl);
	$botcreatetmpl = str_replace('{ts3_virtualserver_port}', getTextInput("ts3_virtualserver_port", (isset($_POST['ts3_virtualserver_port']) ? $_POST['ts3_virtualserver_port'] : (isset($configValues['ts3_virtualserver_port']) ? $configValues['ts3_virtualserver_port'] : "9987")), 18, 50, true, 0, 65535, $virtualServerID >= 1), $botcreatetmpl);
	$botcreatetmpl = str_replace('{ts3_server_query_mode}', getQueryModeComboBoxDef((isset($_POST['ts3_server_query_mode']) ? $_POST['ts3_server_query_mode'] : (isset($configValues['ts3_server_query_mode']) ? $configValues['ts3_server_query_mode'] : "raw"))), $botcreatetmpl);
	$botcreatetmpl = str_replace('{bot_slowmode}', getYesNoComboBoxDef("bot_slowmode", (isset($_POST['bot_slowmode']) ? $_POST['bot_slowmode'] : (isset($configValues['bot_slowmode']) ? $configValues['bot_slowmode'] : 1))), $botcreatetmpl);

	if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1)
	{
		$botcreatetmpl = str_replace('{makedefault}', " <input type=\"submit\" name=\"MakeDefaultBot\" value=\"{webui_makedefault}\">", $botcreatetmpl);
	}
	else
	{
		$botcreatetmpl = str_replace('{makedefault}', "", $botcreatetmpl);
		$botcreatetmpl = str_replace('{webui_savehelptext}', "", $botcreatetmpl);
	}
	
	global $translation;
	$botcreatetmpl = str_replace('{webui_botsettings}', $translation->getTranslation("webui_botsettings"), $botcreatetmpl);
	$botcreatetmpl = str_replace('{webui_userpassword_edit}', $translation->getTranslation("webui_userpassword_edit"), $botcreatetmpl);

	return $botcreatetmpl;
}

function getFormularForRename($class_db, $instanceid)
{
	if (!is_numeric($instanceid))
	{
		$returnTMPL = implode(" ", file("templates/backtomain.tmpl"));
		$returnTMPL = str_replace('{title}', "{webui_renamebot}", $returnTMPL);
		$returnTMPL = str_replace('{message}', "{webui_error_instanceidvalue}", $returnTMPL);
		return $returnTMPL;
	}

	$curName = $class_db->getQuery("SELECT name FROM jts3servermod_instances WHERE id = ".$instanceid);

	$botcreatetmpl = implode(" ", file("templates/botcreate_rename.tmpl"));
	$botcreatetmpl = str_replace('{bot_header}', getBotHeader($class_db, $instanceid), $botcreatetmpl);
	$botcreatetmpl = str_replace('{instanceid}', $instanceid, $botcreatetmpl);
	$botcreatetmpl = str_replace('{newname}', getTextInput("newname", (isset($_POST['newname']) ? $_POST['newname'] : (isset($curName[0]) ? $curName[0] : "")), -1, 20), $botcreatetmpl);

	global $translation;
	$botcreatetmpl = str_replace('{webui_renamebot_info}', $translation->getTranslation("webui_renamebot_info"), $botcreatetmpl);
	$botcreatetmpl = str_replace('{webui_renamebot_newname}', $translation->getTranslation("webui_renamebot_newname"), $botcreatetmpl);

	return $botcreatetmpl;
}

function getQueryModeComboBoxDef($default)
{
	$formChooser = "<select name=\"ts3_server_query_mode\" id=\"ts3_server_query_mode\" size=\"1\" class=\"textinput\">\n";
	
	$formChooser = $formChooser."<option value=\"raw\"".("raw" == $default ? " selected" : "").">RAW</option>\n";
	$formChooser = $formChooser."<option value=\"ssh\"".("ssh" == $default ? " selected" : "").">SSH</option>\n";
	
	return $formChooser."\n</select>\n";
}

function getTS3QueryPassword($class_db, $instanceID, $decrypt = true)
{
	$ts3QueryPassword = "";
	
	if (is_numeric($instanceID))
	{
		if ($instanceID > 0)
		{
			$resList = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$instanceID." AND configkey = 'ts3_server_query_password'");

			while($row = mysqli_fetch_row($resList))
			{
				$ts3QueryPassword = $row[1];
			}
		}
		else
		{
			if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1)
			{
				$resList = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermodwebui_settings WHERE configkey = 'defbotsetting_ts3_server_query_password'");

				while($row = mysqli_fetch_row($resList))
				{
					$ts3QueryPassword = $row[1];
				}
			}
		}
	}
	
	if ($ts3QueryPassword != "" && $decrypt)
	{
		$PWCrypt = new PWCrypt();
		$ts3QueryPassword = $PWCrypt->decryptString($ts3QueryPassword);
	}
	
	return $ts3QueryPassword;
}

function checkConnectInformations($class_db, $editMode, $targetid)
{
	$errorMessage = "";
	$allOK = false;
	$ts3QueryPassword = "";

	if (isset($_POST['ts3_server_address']) && isset($_POST['ts3_server_query_port']) && isset($_POST['ts3_server_query_login']) && isset($_POST['ts3_server_query_password']) && isset($_POST['ts3_virtualserver_id']) && isset($_POST['ts3_virtualserver_port']) && isset($_POST['bot_slowmode']))
	{
		$allOK = true;

		if (!is_numeric($targetid) || $targetid < 1 || $targetid > 99999999)
		{
			$errorMessage .= ($editMode ? "{webui_error_instanceidvalue}" : "{webui_error_useridvalue}")."<br>";
			$allOK = false;
		}

		if (!is_numeric($_POST['ts3_server_query_port']) || $_POST['ts3_server_query_port'] < 0 || $_POST['ts3_server_query_port'] > 65535)
		{
			$errorMessage .= "{webui_error_ts3serverqueryportvalue}<br>";
			$allOK = false;
		}

		if (!is_numeric($_POST['ts3_virtualserver_id']) || $_POST['ts3_virtualserver_id'] < -1 || $_POST['ts3_virtualserver_id'] > 99999999)
		{
			$errorMessage .= "{webui_error_ts3virtualserveridvalue}<br>";
			$allOK = false;
		}

		if ($_POST['ts3_virtualserver_id'] == -1)
		{
			if (!is_numeric($_POST['ts3_virtualserver_port']) || $_POST['ts3_virtualserver_port'] < 0 || $_POST['ts3_virtualserver_port'] > 65535)
			{
				$errorMessage .= "{webui_error_ts3virtualserverportvalue}<br>";
				$allOK = false;
			}
		}

		if (!is_numeric($_POST['bot_slowmode']) || $_POST['bot_slowmode'] < 0 || $_POST['bot_slowmode'] > 2)
		{
			$errorMessage .= "{webui_error_botslowmodevalue}<br>";
			$allOK = false;
		}
		
		if ($_POST['ts3_server_query_password'] == "")
		{
			if ($editMode)
				$ts3QueryPassword = getTS3QueryPassword($class_db, $targetid);
			else
				$ts3QueryPassword = getTS3QueryPassword($class_db, -1);
		}
		else
		{
			$ts3QueryPassword = $_POST['ts3_server_query_password'];
		}
	}
	
	if ($allOK)
		return checkTS3Connection($_POST['ts3_server_address'], $_POST['ts3_server_query_port'], $_POST['ts3_server_query_login'], $ts3QueryPassword, $_POST['ts3_virtualserver_id'], $_POST['ts3_virtualserver_port'], $_POST['ts3_server_query_mode']);
	else
		return $errorMessage;
}

function checkTS3Connection($address, $port, $login, $password, $vserver_id, $vserver_port, $sshMode)
{
	$errorMessage = "";
	$allOK = true;

	$ts3ConnectResult = 666;
	if ($allOK)
	{
		$ts3ConnectResult = getTS3ServerInformations($address, $port, $login, $password, $vserver_id, $vserver_port, $sshMode);
	}
	
	if ($ts3ConnectResult == 1)
	{
		global $currentUserList, $currentChannelList, $currentServerGrpList;
		
		if ($currentUserList === FALSE || $currentUserList['id'] != 0)
		{
			$errorMessage .= "{webui_error_clientlist}<br>{webui_ts3servererror} ".$currentUserList['msg'].(isset($currentUserList['extra_msg']) ? " - ".$currentUserList['extra_msg'] : "")."<br>";
			$allOK = false;
		}

		if ($currentServerGrpList === FALSE || $currentServerGrpList['id'] != 0)
		{
			$errorMessage .= "{webui_error_servergrouplist}<br>{webui_ts3servererror} ".$currentServerGrpList['msg'].(isset($currentServerGrpList['extra_msg']) ? " - ".$currentServerGrpList['extra_msg'] : "")."<br>";
			$allOK = false;
		}

		if ($currentChannelList === FALSE || $currentChannelList['id'] != 0)
		{
			$errorMessage .= "{webui_error_channellist}<br>{webui_ts3servererror} ".$currentChannelList['msg'].(isset($currentChannelList['extra_msg']) ? " - ".$currentChannelList['extra_msg'] : "")."<br>";
			$allOK = false;
		}
	}
	else
	{
		global $lastTS3Status;
		if ($ts3ConnectResult == -1) $errorMessage .= "{webui_ts3noconnectionpossible}".($lastTS3Status == null ? "" : "<br>{webui_ts3servererror} ".$lastTS3Status);
		else if ($ts3ConnectResult == 0) $errorMessage .= "{webui_ts3logindetailswrong}".($lastTS3Status == null ? "" : "<br>{webui_ts3servererror} ".$lastTS3Status);
		else if ($ts3ConnectResult == -2) $errorMessage .= "{webui_ts3virtualserverselectionerror}".($lastTS3Status == null ? "" : "<br>{webui_ts3servererror} ".$lastTS3Status);
		else if ($ts3ConnectResult == -3) $errorMessage .= "{webui_ts3unknownerroroccurred}".($lastTS3Status == null ? "" : "<br>".$lastTS3Status);
		
		$allOK = false;
	}

	if ($allOK)
	{
		return null;
	}
	else
	{
		return $errorMessage;
	}
}

function copyBotSettings($class_db, $fromBotID, $toBotID)
{
	if (is_numeric($fromBotID) && is_numeric($toBotID))
	{
		$resList = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$fromBotID." AND configkey NOT LIKE \"ts3_%\" AND configkey != \"bot_slowmode\"");
		while($row = mysqli_fetch_row($resList))
		{
			$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$toBotID.", '".$class_db->getRealEscapeString($row[0])."', '".$class_db->getRealEscapeString($row[1])."')");
		}
		
		$resList = $class_db->db_query("SELECT prefix, textentry FROM jts3servermod_advertising WHERE instance_id = ".$fromBotID);
		while($row = mysqli_fetch_row($resList))
		{
			$class_db->db_query("INSERT INTO jts3servermod_advertising (`instance_id`, `prefix`, `textentry`) VALUES (".$toBotID.", '".$class_db->getRealEscapeString($row[0])."', '".$class_db->getRealEscapeString($row[1])."')");
		}
		
		$resList = $class_db->db_query("SELECT servergroup_id, channel_id FROM jts3servermod_automove WHERE instance_id = ".$fromBotID);
		while($row = mysqli_fetch_row($resList))
		{
			$class_db->db_query("INSERT INTO jts3servermod_automove (`instance_id`, `servergroup_id`, `channel_id`) VALUES (".$toBotID.", '".$class_db->getRealEscapeString($row[0])."', '".$class_db->getRealEscapeString($row[1])."')");
		}
		
		$resList = $class_db->db_query("SELECT prefix, textentry FROM jts3servermod_badchannelname WHERE instance_id = ".$fromBotID);
		while($row = mysqli_fetch_row($resList))
		{
			$class_db->db_query("INSERT INTO jts3servermod_badchannelname (`instance_id`, `prefix`, `textentry`) VALUES (".$toBotID.", '".$class_db->getRealEscapeString($row[0])."', '".$class_db->getRealEscapeString($row[1])."')");
		}
		
		$resList = $class_db->db_query("SELECT prefix, textentry FROM jts3servermod_badnickname WHERE instance_id = ".$fromBotID);
		while($row = mysqli_fetch_row($resList))
		{
			$class_db->db_query("INSERT INTO jts3servermod_badnickname (`instance_id`, `prefix`, `textentry`) VALUES (".$toBotID.", '".$class_db->getRealEscapeString($row[0])."', '".$class_db->getRealEscapeString($row[1])."')");
		}
		
		$resList = $class_db->db_query("SELECT servergroup_id, client_unique_id, comment FROM jts3servermod_servergroupprotection WHERE instance_id = ".$fromBotID);
		while($row = mysqli_fetch_row($resList))
		{
			$class_db->db_query("INSERT INTO jts3servermod_servergroupprotection (`instance_id`, `servergroup_id`, `client_unique_id`, `comment`) VALUES (".$toBotID.", '".$class_db->getRealEscapeString($row[0])."', '".$class_db->getRealEscapeString($row[1])."', '".$class_db->getRealEscapeString($row[2])."')");
		}
		
		return true;
	}
	
	return false;
}

$useBotID = -1;
if (isset($_REQUEST['instanceid']) && is_numeric($_REQUEST['instanceid']))
	$useBotID = $_REQUEST['instanceid'];
$botCreateAllowed = isBotCreateAllowed($class_db, $useBotID);

$copyFromID = -1;
if (isset($_REQUEST['copyfromid']) && is_numeric($_REQUEST['copyfromid']))
	$copyFromID = $_REQUEST['copyfromid'];

if ($botCreateAllowed == 0 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 1))
{
	$for_output = implode(" ", file("templates/backtomain.tmpl"));
	$for_output = str_replace('{title}', "{webui_botcreate}", $for_output);
	$for_output = str_replace('{message}', "{webui_onlyadministrator}", $for_output);
}
else if ($botCreateAllowed == -1 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 1))
{
	$for_output = implode(" ", file("templates/backtomain.tmpl"));
	$for_output = str_replace('{title}', "{webui_botcreate}", $for_output);
	$for_output = str_replace('{message}', "{webui_maxbotcountreached}", $for_output);
}
else if (isset($_GET['mode']) && $_GET['mode'] == "renameBot")
{
	if ($useBotID >= 0)
	{
		$botExists = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_instances WHERE id = ".$useBotID);

		if ($botExists[0] >= 1)
		{
			$for_output = getFormularForRename($class_db, $useBotID);
		}
		else
		{
			$for_output = implode(" ", file("templates/backtomain.tmpl"));
			$for_output = str_replace('{title}', "{webui_renamebot}", $for_output);
			$for_output = str_replace('{message}', "{webui_botnotexists}", $for_output);
		}
	}
	else
	{
		$for_output = implode(" ", file("templates/backtomain.tmpl"));
		$for_output = str_replace('{title}', "{webui_renamebot}", $for_output);
		$for_output = str_replace('{message}', "{webui_error_useridvalue}", $for_output);
	}
}
else if (isset($_POST['mode']) && $_POST['mode'] == "renameBot")
{
	$errorMessage = null;
	global $translation;
	
	if ($useBotID < 0)
	{
		$errorMessage = $translation->getTranslation("webui_error_missingvalue");
	}
	else
	{
		$botNameExists = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_instances WHERE name = \"".$class_db->getRealEscapeString($_POST['newname'])."\"");
		if ($botNameExists[0] >= 1)
		{
			$errorMessage = $translation->getTranslation("webui_botnamealreadyexists");
		}
	}
	
	if (!preg_match("@^[a-z0-9\\_\\-]+$@is", $_POST['newname']))
	{
		if ($errorMessage == null)
			$errorMessage = $translation->getTranslation("webui_renamebot_invalidname");
	}
	
	$namelen = strlen($_POST['newname']);
	if ($namelen < 1 || $namelen > 20)
	{
		if ($errorMessage == null)
			$errorMessage = $translation->getTranslation("webui_renamebot_invalidlength");
	}

	$botRenameSuccessful = false;
	if ($errorMessage == null)
	{
		$resbotinfo = $class_db->db_query("SELECT name FROM jts3servermod_instances WHERE id = ".$useBotID);
		$botInfo = mysqli_fetch_array($resbotinfo);
		
		$botStatus = $botTelnet->getBotStatus($botInfo[0]);
		
		$doDBRename = true;
		if ($botStatus == 1 || $botStatus == 0)
		{
			$doDBRename = $botTelnet->renameBot($botInfo[0], $_POST['newname']);
		}
		
		if ($doDBRename)
		{
			$botRenameSuccessful = true;
			$errorMessage = $translation->getTranslation("webui_botrenamesuccessfull");
			$class_db->db_query("UPDATE `jts3servermod_instances` SET name = \"".$class_db->getRealEscapeString($_POST['newname'])."\" WHERE `id` = ".$useBotID);
		}
		else
		{
			$errorMessage = $translation->getTranslation("webui_botrenamefailed");
		}
	}

	$for_output = getBotHeader($class_db, $useBotID)."\n\n<div class=\"title\">{webui_renamebot}</div>\n<div align=\"center\" class=\"topspacer\">".$errorMessage.($botRenameSuccessful ? "" : "<br><br><a href=\"index.php?page=botcreate&amp;mode=renameBot&amp;instanceid=".$useBotID."\">{webui_back}</a>")."</div>";
}
else if ($botCreateAllowed < 1 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] == 1) && (isset($_POST['mode']) && $_POST['mode'] == "createBotDefault"))
{
	$errorMessage = "";
	$allOK = false;
	
	if (!isset($_POST['targetid']) || !is_numeric($_POST['targetid']))
	{
		$errorMessage = "{webui_error_missingvalue}";
	}
	
	$PWCrypt = new PWCrypt();
	
	$resList = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermodwebui_settings WHERE configkey LIKE 'defbotsetting_%'");
	
	while($row = mysqli_fetch_row($resList))
	{
		if ($row[0] == "defbotsetting_ts3_server_query_password")
			$configValues[substr($row[0], 14)] = $PWCrypt->decryptString($row[1]);
		else
			$configValues[substr($row[0], 14)] = $row[1];
	}
	
	if (!isset($configValues['ts3_server_address']))
	{
		$errorMessage = $translation->getTranslation("webui_defaultbot_none");
	}
	else
	{
		if (!is_numeric($_POST['ts3_virtualserver_id']) || $_POST['ts3_virtualserver_id'] < -1 || $_POST['ts3_virtualserver_id'] > 99999999)
		{
			$errorMessage = "{webui_error_ts3virtualserveridvalue}";
			$allOK = false;
		}

		if ($_POST['ts3_virtualserver_id'] == -1)
		{
			if (!is_numeric($_POST['ts3_virtualserver_port']) || $_POST['ts3_virtualserver_port'] < 0 || $_POST['ts3_virtualserver_port'] > 65535)
			{
				$errorMessage = "{webui_error_ts3virtualserverportvalue}";
				$allOK = false;
			}
		}
		
		if ($errorMessage == "")
		{
			$errorMessage = checkTS3Connection($configValues['ts3_server_address'], $configValues['ts3_server_query_port'], $configValues['ts3_server_query_login'], $configValues['ts3_server_query_password'], $_POST['ts3_virtualserver_id'], $_POST['ts3_virtualserver_port'], $configValues['ts3_server_query_mode']);
		}
		
		if ($copyFromID >= 0)
		{
			$botExists = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_instances WHERE id = ".$copyFromID);
			if ($botExists[0] < 1)
			{
				$for_output = implode(" ", file("templates/backtomain.tmpl"));
				$for_output = str_replace('{title}', "{webui_botcreate}", $for_output);
				$for_output = str_replace('{message}', "{webui_botnotexists}", $for_output);
			}
			else
			{
				$botCopyAllowed = isBotCreateAllowed($class_db, $copyFromID);
				if ($botCopyAllowed != 1 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 1))
				{
					$for_output = implode(" ", file("templates/backtomain.tmpl"));
					$for_output = str_replace('{title}', "{webui_botcreate}", $for_output);
					$for_output = str_replace('{message}', "{webui_onlyadministrator} Haha", $for_output);
				}
			}
		}
	}

	if ($for_output == "")
	{
		if ($errorMessage == null)
		{
			$allOK = true;
		}
		
		if ($allOK)
		{
			if (isset($_POST['CreateNewBot']))
			{
				$isBotMissing = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_instances WHERE ts3serverip = '".$class_db->getRealEscapeString($configValues['ts3_server_address'])."' AND ts3portid = ".($_POST['ts3_virtualserver_id'] == -1 ? $_POST['ts3_virtualserver_port'] : $_POST['ts3_virtualserver_id']));
				if ($isBotMissing[0] == 1)
				{
					$errorMessage .= "{webui_botalreadyexists}<br>";
					$allOK = false;
				}
				else
				{
					$nextBotID = $class_db->getQuery("SELECT nextbotid FROM jts3servermodwebui_users WHERE `id` = ".$_POST['targetid']);
					$class_db->db_query("UPDATE `jts3servermodwebui_users` SET nextbotid = nextbotid + 1 WHERE `id` = ".$_POST['targetid']);
					$class_db->db_query("INSERT INTO jts3servermod_instances (`name`, `enabled`, `logmode`, `logpath`, `ts3serverip`, `ts3portid`) VALUES ('bot".$class_db->getRealEscapeString($_POST['targetid']."_".$nextBotID[0])."', 0, 2, '', '".$class_db->getRealEscapeString($configValues['ts3_server_address'])."', ".($_POST['ts3_virtualserver_id'] == -1 ? $class_db->getRealEscapeString($_POST['ts3_virtualserver_port']) : $class_db->getRealEscapeString($_POST['ts3_virtualserver_id'])).")");
					$lastBotID = $class_db->getLastInsertID();
					$class_db->db_query("INSERT INTO jts3servermodwebui_usersinstances (`user_id`, `instance_id`, `fullaccess`) VALUES (".$class_db->getRealEscapeString($_POST['targetid']).", ".$lastBotID.", true)");
					$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_server_address', '".$class_db->getRealEscapeString($configValues['ts3_server_address'])."')");
					$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_server_query_port', '".$class_db->getRealEscapeString($configValues['ts3_server_query_port'])."')");
					$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_server_query_login', '".$class_db->getRealEscapeString($configValues['ts3_server_query_login'])."')");
					$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_server_query_password', '".$class_db->getRealEscapeString($PWCrypt->encryptString($configValues['ts3_server_query_password']))."')");
					$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_virtualserver_id', '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_id'])."')");
					$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_virtualserver_port', '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_port'])."')");
					$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_server_query_mode', '".$class_db->getRealEscapeString($configValues['ts3_server_query_mode'])."')");
					$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'bot_slowmode', '".$class_db->getRealEscapeString($configValues['bot_slowmode'])."')");
					$botTelnet->instancelistReload();
					
					if ($copyFromID >= 0)
					{
						copyBotSettings($class_db, $copyFromID, $lastBotID);
					}
					else
					{
						$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'bot_connect_forever', '0')");
					}
				}
			}
		}
		
		if ($allOK)
		{
			$for_output = "<div class=\"title\">{webui_botcreate}</div>\n<div align=\"center\" class=\"topspacer\">{webui_botwascreated}<br><br><a href=\"index.php?page=botmanager&amp;botID=".$lastBotID."\">{webui_botsettings}</a></div>";
		}
		else
		{
			$for_output = getFormular($class_db, $userid, $copyFromID, true, $errorMessage);
		}

		$for_output = str_replace('{webui_botlist}', $translation->getTranslation("webui_botlist", true), $for_output);
		$for_output = str_replace('{webui_botsettings}', $translation->getTranslation("webui_botsettings", true), $for_output);
		$for_output = str_replace('{ts3_server_query_login}', $configValues['ts3_server_query_login'], $for_output);
	}
}
else if (isset($_POST['mode']) && $_POST['mode'] == "editBot")
{
	if ($botCreateAllowed < 1 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 2))
	{
		$for_output = implode(" ", file("templates/backtomain.tmpl"));
		$for_output = str_replace('{title}', "{webui_botsettings}", $for_output);
		$for_output = str_replace('{message}', "{webui_onlyadministrator}", $for_output);
	}
	else
	{
		$errorMessage = "";
		$allOK = false;
		
		if ($useBotID < 0)
		{
			$errorMessage = "{webui_error_missingvalue}";
		}
		else
		{
			$errorMessage = checkConnectInformations($class_db, true, $useBotID);
		}

		if ($errorMessage == null)
		{
			$errorMessage = "";
			$allOK = true;
		}

		if ($allOK)
		{
			if (isset($_POST['CreateNewBot']))
			{
				$botExists = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_instances WHERE id = ".$useBotID);

				if ($botExists[0] >= 1)
				{
					if ($_POST['ts3_server_query_password'] != "")
					{
						$PWCrypt = new PWCrypt();
						$class_db->db_query("INSERT INTO `jts3servermod_instanceconfig` (`instance_id`, `configkey`, `configvalue`) VALUES (".$useBotID.", 'ts3_server_query_password', '".$class_db->getRealEscapeString($PWCrypt->encryptString($_POST['ts3_server_query_password']))."') ON DUPLICATE KEY UPDATE `configvalue` = '".$class_db->getRealEscapeString($PWCrypt->encryptString($_POST['ts3_server_query_password']))."'");
					}
					
					$class_db->db_query("UPDATE `jts3servermod_instances` SET `ts3serverip` = '".$class_db->getRealEscapeString($_POST['ts3_server_address'])."', `ts3portid` = ".($_POST['ts3_virtualserver_id'] == -1 ? $class_db->getRealEscapeString($_POST['ts3_virtualserver_port']) : $class_db->getRealEscapeString($_POST['ts3_virtualserver_id']))." WHERE `id` = ".$useBotID);
					$class_db->db_query("INSERT INTO `jts3servermod_instanceconfig` (`instance_id`, `configkey`, `configvalue`) VALUES (".$useBotID.", 'ts3_server_address', '".$class_db->getRealEscapeString($_POST['ts3_server_address'])."') ON DUPLICATE KEY UPDATE `configvalue` = '".$class_db->getRealEscapeString($_POST['ts3_server_address'])."'");
					$class_db->db_query("INSERT INTO `jts3servermod_instanceconfig` (`instance_id`, `configkey`, `configvalue`) VALUES (".$useBotID.", 'ts3_server_query_port', '".$class_db->getRealEscapeString($_POST['ts3_server_query_port'])."') ON DUPLICATE KEY UPDATE `configvalue` = '".$class_db->getRealEscapeString($_POST['ts3_server_query_port'])."'");
					$class_db->db_query("INSERT INTO `jts3servermod_instanceconfig` (`instance_id`, `configkey`, `configvalue`) VALUES (".$useBotID.", 'ts3_server_query_login', '".$class_db->getRealEscapeString($_POST['ts3_server_query_login'])."') ON DUPLICATE KEY UPDATE `configvalue` = '".$class_db->getRealEscapeString($_POST['ts3_server_query_login'])."'");
					$class_db->db_query("INSERT INTO `jts3servermod_instanceconfig` (`instance_id`, `configkey`, `configvalue`) VALUES (".$useBotID.", 'ts3_virtualserver_id', '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_id'])."') ON DUPLICATE KEY UPDATE `configvalue` = '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_id'])."'");
					$class_db->db_query("INSERT INTO `jts3servermod_instanceconfig` (`instance_id`, `configkey`, `configvalue`) VALUES (".$useBotID.", 'ts3_virtualserver_port', '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_port'])."') ON DUPLICATE KEY UPDATE `configvalue` = '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_port'])."'");
					$class_db->db_query("INSERT INTO `jts3servermod_instanceconfig` (`instance_id`, `configkey`, `configvalue`) VALUES (".$useBotID.", 'ts3_server_query_mode', '".$class_db->getRealEscapeString($_POST['ts3_server_query_mode'])."') ON DUPLICATE KEY UPDATE `configvalue` = '".$class_db->getRealEscapeString($_POST['ts3_server_query_mode'])."'");
					$class_db->db_query("INSERT INTO `jts3servermod_instanceconfig` (`instance_id`, `configkey`, `configvalue`) VALUES (".$useBotID.", 'bot_slowmode', '".$class_db->getRealEscapeString($_POST['bot_slowmode'])."') ON DUPLICATE KEY UPDATE `configvalue` = '".$class_db->getRealEscapeString($_POST['bot_slowmode'])."'");
				}
				else
				{
					$errorMessage = "{webui_botnotexists}";
					$allOK = false;
				}
			}
			else if (isset($_POST['MakeDefaultBot']) && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1))
			{
				$PWCrypt = new PWCrypt();
				
				$class_db->db_query("DELETE FROM jts3servermodwebui_settings WHERE configkey LIKE \"defbotsetting_%\"");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_server_address', '".$class_db->getRealEscapeString($_POST['ts3_server_address'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_server_query_port', '".$class_db->getRealEscapeString($_POST['ts3_server_query_port'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_server_query_login', '".$class_db->getRealEscapeString($_POST['ts3_server_query_login'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_server_query_password', '".$class_db->getRealEscapeString($PWCrypt->encryptString($_POST['ts3_server_query_password']))."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_virtualserver_id', '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_id'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_virtualserver_port', '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_port'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_server_query_mode', '".$class_db->getRealEscapeString($_POST['ts3_server_query_mode'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_bot_slowmode', '".$class_db->getRealEscapeString($_POST['bot_slowmode'])."')");

				$errorMessage = "{webui_defbotsaved}";
				$allOK = false;
			}
		}

		if ($allOK)
		{
			$resbotinfo = $class_db->db_query("SELECT name FROM jts3servermod_instances WHERE id = ".$useBotID);
			$botInfo = mysqli_fetch_array($resbotinfo);
			
			$botStatus = $botTelnet->getBotStatus($botInfo[0]);
			$for_output = getFormularForEdit($class_db, $useBotID, "{webui_botchangessaved}".($botStatus == 1 ? "<br><a href=\"javascript:void(0);\" class=\"nounderline\" onclick=\"requestBotCommand(".$useBotID.", 'reload');\">{webui_botsettingssaved_reloadbot} <img src=\"images/arrow_refresh_small.png\" border=\"0\" alt=\"\" class=\"middle\"></a>" : ""));
		}
		else
		{
			$for_output = getFormularForEdit($class_db, $useBotID, $errorMessage);
		}
		
		$for_output = str_replace('{permissionname_clientlist}', "<b>b_virtualserver_client_list</b>", $for_output);
		$for_output = str_replace('{permissionname_servergrouplist}', "<b>b_virtualserver_servergroup_list</b>", $for_output);
		$for_output = str_replace('{permissionname_channellist}', "<b>b_virtualserver_channel_list</b>", $for_output);
		$for_output = str_replace('{ts3_server_query_login}', $_POST['ts3_server_query_login'], $for_output);
		$for_output = str_replace('{webui_botsettingssaved_reloadbot}', $translation->getTranslation("webui_botsettingssaved_reloadbot", true), $for_output);
	}
}
else if (isset($_POST['mode']) && $_POST['mode'] == "createBot")
{
	if ($botCreateAllowed == 0 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 2))
	{
		$for_output = implode(" ", file("templates/backtomain.tmpl"));
		$for_output = str_replace('{title}', "{webui_botcreate}", $for_output);
		$for_output = str_replace('{message}', "{webui_onlyadministrator}", $for_output);
	}
	else if ($botCreateAllowed == -1 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 2))
	{
		$for_output = implode(" ", file("templates/backtomain.tmpl"));
		$for_output = str_replace('{title}', "{webui_botcreate}", $for_output);
		$for_output = str_replace('{message}', "{webui_maxbotcountreached}", $for_output);
	}
	else
	{
		$errorMessage = "";
		$allOK = false;
		
		if (!isset($_POST['targetid']) || !is_numeric($_POST['targetid']))
		{
			$errorMessage = "{webui_error_missingvalue}";
		}
		else
		{
			$errorMessage = checkConnectInformations($class_db, false, $_POST['targetid']);
		}
		
		if ($copyFromID >= 0)
		{
			$botExists = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_instances WHERE id = ".$copyFromID);
			if ($botExists[0] < 1)
			{
				$for_output = implode(" ", file("templates/backtomain.tmpl"));
				$for_output = str_replace('{title}', "{webui_botcreate}", $for_output);
				$for_output = str_replace('{message}', "{webui_botnotexists}", $for_output);
			}
			else
			{
				$botCopyAllowed = isBotCreateAllowed($class_db, $copyFromID);
				if ($botCopyAllowed != 1 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 1))
				{
					$for_output = implode(" ", file("templates/backtomain.tmpl"));
					$for_output = str_replace('{title}', "{webui_botcreate}", $for_output);
					$for_output = str_replace('{message}', "{webui_onlyadministrator} Haha", $for_output);
				}
			}
		}

		if ($for_output == "")
		{
			if ($errorMessage == null)
			{
				$errorMessage = "";
				$allOK = true;
			}
			
			if ($allOK)
			{
				if (isset($_POST['CreateNewBot']))
				{
					$isBotMissing = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_instances WHERE ts3serverip = '".$class_db->getRealEscapeString($_POST['ts3_server_address'])."' AND ts3portid = ".($_POST['ts3_virtualserver_id'] == -1 ? $_POST['ts3_virtualserver_port'] : $_POST['ts3_virtualserver_id']));
					if ($isBotMissing[0] == 1)
					{
						$errorMessage .= "{webui_botalreadyexists}<br>";
						$allOK = false;
					}
					else
					{
						$ts3QueryPassword = $_POST['ts3_server_query_password'];
						if ($ts3QueryPassword == "")
							$ts3QueryPassword = getTS3QueryPassword($class_db, -1, false);
						else
						{
							$PWCrypt = new PWCrypt();
							$ts3QueryPassword = $PWCrypt->encryptString($_POST['ts3_server_query_password']);
						}
						
						$nextBotID = $class_db->getQuery("SELECT nextbotid FROM jts3servermodwebui_users WHERE `id` = ".$_POST['targetid']);
						$class_db->db_query("UPDATE `jts3servermodwebui_users` SET nextbotid = nextbotid + 1 WHERE `id` = ".$_POST['targetid']);
						$class_db->db_query("INSERT INTO jts3servermod_instances (`name`, `enabled`, `logmode`, `logpath`, `ts3serverip`, `ts3portid`) VALUES ('bot".$class_db->getRealEscapeString($_POST['targetid']."_".$nextBotID[0])."', 0, 2, '', '".$class_db->getRealEscapeString($_POST['ts3_server_address'])."', ".($_POST['ts3_virtualserver_id'] == -1 ? $class_db->getRealEscapeString($_POST['ts3_virtualserver_port']) : $class_db->getRealEscapeString($_POST['ts3_virtualserver_id'])).")");
						$lastBotID = $class_db->getLastInsertID();
						$class_db->db_query("INSERT INTO jts3servermodwebui_usersinstances (`user_id`, `instance_id`, `fullaccess`) VALUES (".$class_db->getRealEscapeString($_POST['targetid']).", ".$lastBotID.", true)");
						$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_server_address', '".$class_db->getRealEscapeString($_POST['ts3_server_address'])."')");
						$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_server_query_port', '".$class_db->getRealEscapeString($_POST['ts3_server_query_port'])."')");
						$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_server_query_login', '".$class_db->getRealEscapeString($_POST['ts3_server_query_login'])."')");
						$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_server_query_password', '".$class_db->getRealEscapeString($ts3QueryPassword)."')");
						$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_virtualserver_id', '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_id'])."')");
						$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_virtualserver_port', '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_port'])."')");
						$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'ts3_server_query_mode', '".$class_db->getRealEscapeString($_POST['ts3_server_query_mode'])."')");
						$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'bot_slowmode', '".$class_db->getRealEscapeString($_POST['bot_slowmode'])."')");
						$botTelnet->instancelistReload();
						
						if ($copyFromID >= 0)
						{
							copyBotSettings($class_db, $copyFromID, $lastBotID);
						}
						else
						{
							$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$lastBotID.", 'bot_connect_forever', '0')");
						}
					}
				}
				else if (isset($_POST['MakeDefaultBot']) && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] >= 2))
				{
					$PWCrypt = new PWCrypt();
				
					$class_db->db_query("DELETE FROM jts3servermodwebui_settings WHERE configkey LIKE \"defbotsetting_%\"");
					$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_server_address', '".$class_db->getRealEscapeString($_POST['ts3_server_address'])."')");
					$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_server_query_port', '".$class_db->getRealEscapeString($_POST['ts3_server_query_port'])."')");
					$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_server_query_login', '".$class_db->getRealEscapeString($_POST['ts3_server_query_login'])."')");
					$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_server_query_password', '".$class_db->getRealEscapeString($PWCrypt->encryptString($_POST['ts3_server_query_password']))."')");
					$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_virtualserver_id', '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_id'])."')");
					$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_virtualserver_port', '".$class_db->getRealEscapeString($_POST['ts3_virtualserver_port'])."')");
					$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_ts3_server_query_mode', '".$class_db->getRealEscapeString($_POST['ts3_server_query_mode'])."')");
					$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('defbotsetting_bot_slowmode', '".$class_db->getRealEscapeString($_POST['bot_slowmode'])."')");

					$errorMessage = "{webui_defbotsaved}";
					$allOK = false;
				}
			}
			
			if ($allOK)
			{
				$for_output = "<div class=\"title\">{webui_botcreate}</div>\n<div align=\"center\" class=\"topspacer\">{webui_botwascreated}<br><br><a href=\"index.php?page=botmanager&amp;botID=".$lastBotID."\">{webui_botsettings}</a></div>";
			}
			else
			{
				$for_output = getFormular($class_db, $userid, $copyFromID, false, $errorMessage);
			}

			$for_output = str_replace('{permissionname_clientlist}', "<b>b_virtualserver_client_list</b>", $for_output);
			$for_output = str_replace('{permissionname_servergrouplist}', "<b>b_virtualserver_servergroup_list</b>", $for_output);
			$for_output = str_replace('{permissionname_channellist}', "<b>b_virtualserver_channel_list</b>", $for_output);
			$for_output = str_replace('{ts3_server_query_login}', $_POST['ts3_server_query_login'], $for_output);
			$for_output = str_replace('{webui_botlist}', $translation->getTranslation("webui_botlist", true), $for_output);
			$for_output = str_replace('{webui_botsettings}', $translation->getTranslation("webui_botsettings", true), $for_output);
		}
	}
}
else if (isset($_GET['mode']) && $_GET['mode'] == "editBot")
{
	if ($botCreateAllowed < 1 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 2))
	{
		$for_output = implode(" ", file("templates/backtomain.tmpl"));
		$for_output = str_replace('{title}', "{webui_botsettings}", $for_output);
		$for_output = str_replace('{message}', "{webui_onlyadministrator}", $for_output);
		$for_output = str_replace('"index.php"', "\"index.php?page=botmanager&amp;botID=".$useBotID."\"", $for_output);
	}
	else
	{
		if ($useBotID >= 0)
		{
			$botExists = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_instances WHERE id = ".$useBotID);

			if ($botExists[0] >= 1)
			{
				$for_output = getFormularForEdit($class_db, $useBotID);
			}
			else
			{
				$for_output = implode(" ", file("templates/backtomain.tmpl"));
				$for_output = str_replace('{title}', "{webui_botsettings}", $for_output);
				$for_output = str_replace('{message}', "{webui_botnotexists}", $for_output);
			}
		}
		else
		{
			$for_output = implode(" ", file("templates/backtomain.tmpl"));
			$for_output = str_replace('{title}', "{webui_botsettings}", $for_output);
			$for_output = str_replace('{message}', "{webui_error_useridvalue}", $for_output);
		}
	}
}
else if ($botCreateAllowed < 1 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] == 1))
{
	$for_output = getFormular($class_db, $userid, $copyFromID, true);
}
else
{
	$for_output = getFormular($class_db, $userid, $copyFromID);
}

$for_output = $translation->replaceTranslationsForPage($for_output, "botcreate");

?>