function getSelectedText(textareaName)
{
	var input = document.forms["content"].elements[textareaName];
	input.focus();
	/* fr aktuelle Browser */
	if(typeof input.selectionStart != 'undefined')
	{
		/* Abfrage des ausgewhlten Textes */
		var start = input.selectionStart;
		var end = input.selectionEnd;
		return input.value.substring(start, end);
	}
	/* fr Internet Explorer */
	else if(typeof document.selection != 'undefined')
	{
		/* Abfrage des ausgewhlten Textes */
		var range = document.selection.createRange();
		return range.text;
	}
}

function insert(textareaName, aTag, eTag)
{
	var input = document.forms["content"].elements[textareaName];
	input.focus();
	/* fr aktuelle Browser */
	if(typeof input.selectionStart != 'undefined')
	{
		/* Einfgen des Formatierungscodes */
		var start = input.selectionStart;
		var end = input.selectionEnd;
		var insText = input.value.substring(start, end);
		input.value = input.value.substr(0, start) + aTag + insText + eTag + input.value.substr(end);
		/* Anpassen der Cursorposition */
		var pos;
		if (insText.length == 0)
		{
			pos = start + aTag.length;
		}
		else
		{
			pos = start + aTag.length + insText.length + eTag.length;
		}
		input.selectionStart = pos;
		input.selectionEnd = pos;
	}
	/* fr Internet Explorer */
	else if(typeof document.selection != 'undefined')
	{
		/* Einfgen des Formatierungscodes */
		var range = document.selection.createRange();
		var insText = range.text;
		range.text = aTag + insText + eTag;
		/* Anpassen der Cursorposition */
		range = document.selection.createRange();
		if (insText.length == 0)
		{
			range.move('character', -eTag.length);
		} else
		{
			range.moveStart('character', aTag.length + insText.length + eTag.length);      
		}
		range.select();
	}
}

function replace(textareaName, newText)
{
	var input = document.forms["content"].elements[textareaName];
	input.focus();
	/* fr aktuelle Browser */
	if(typeof input.selectionStart != 'undefined')
	{
		/* Einfgen des Formatierungscodes */
		var start = input.selectionStart;
		var end = input.selectionEnd;
		var insText = input.value.substring(start, end);
		input.value = input.value.substr(0, start) + newText + input.value.substr(end);
		/* Anpassen der Cursorposition */
		var pos = start + newText.length;
		input.selectionStart = pos;
		input.selectionEnd = pos;
	}
	/* fr Internet Explorer */
	else if(typeof document.selection != 'undefined')
	{
		/* Einfgen des Formatierungscodes */
		var range = document.selection.createRange();
		var insText = range.text;
		range.text = newText;
		/* Anpassen der Cursorposition */
		range = document.selection.createRange();
		range.moveStart('character', newText.length);
		range.select();
	}
}

function supportInsert(textareaName)
{
	try
	{
		var input = document.forms["content"].elements[textareaName];
		if((typeof document.selection != 'undefined') || (typeof input.selectionStart != 'undefined'))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	catch(e)
	{
		//window.alert(e);
		return false;
	}
}

function parseColor(textareaName, selectObj)
{
	colorname = selectObj.options[selectObj.options.selectedIndex].value;
	selectObj.options.selectedIndex = 0;
	
	if(supportInsert(textareaName))
	{
		insert(textareaName, "[COLOR=" + colorname + "]", "[/COLOR]");
	}
}

function parseSize(textareaName, selectObj)
{
	size = selectObj.options[selectObj.options.selectedIndex].value;
	selectObj.options.selectedIndex = 0;
	
	if(supportInsert(textareaName))
	{
		insert(textareaName, "[SIZE=" + size + "]", "[/SIZE]");
	}
}

function parseBold(textareaName)
{
	if(supportInsert(textareaName))
	{
		insert(textareaName, "[B]", "[/B]");
	}
}

function parseItalic(textareaName)
{
	if(supportInsert(textareaName))
	{
		insert(textareaName, "[I]", "[/I]");
	}
}

function parseUnderline(textareaName)
{
	if(supportInsert(textareaName))
	{
		insert(textareaName, "[U]", "[/U]");
	}
}

function parseImage(textareaName)
{
	if(supportInsert(textareaName))
	{
		insert(textareaName, "[IMG]", "[/IMG]");
	}
}

function parseLink(textareaName, message)
{
	text = prompt(message, "");
	// "Bitte einen Link (URL) eingeben:\n(Zum Abbrechen nichts eingeben!)"
	if (text != "")
	{
		if (text == undefined)
		{
			//do nothing
		}
		else
		{
			text2 = getSelectedText(textareaName);
			if (text2 != "")
			{
				if (text2 == undefined)
				{
					text = "[URL]" + text + "[/URL]";
				}
				else
				{
					text = "[URL=" + text + "]" + text2 + "[/URL]";
				}
				
				replace(textareaName, text);
			}
			else
			{
				text = "[URL]" + text + "[/URL]";
				replace(textareaName, text);
			}
		}
	}
	document.forms["content"].elements[textareaName].focus();
}

function parseAlign(textareaName, alignment)
{
	if(supportInsert(textareaName))
	{
		insert(textareaName, "[ALIGN=" + alignment + "]", "[/ALIGN]");
	}
}

function parseList(textareaName, type, message, message2)
{
	var listObjects = new Array();
	var text = prompt(message, "");
	// "Bitte den ersten Listeneintrag eingeben:\n(Zum Abbrechen nichts eingeben!)"
	if (text != "")
	{
		if (text == undefined)
		{
			//do nothing
		}
		else
		{
			listObjects.push(text);
			
			while (true)
			{
				text = prompt(message2, "");
				// "Bitte den naechsten Listeneintrag eingeben:\n(Wenn fertig, nichts eingeben!)"
				if (text == undefined)
				{
					break;
				}
				else if (text != "")
				{
					listObjects.push(text);
				}
				else
				{
					break;
				}
			}
			
			if (type == 1)
			{
				text = "[LIST=1]\n";
			}
			else
			{
				text = "[LIST]\n";
			}
			
			for (var i = 0; i < listObjects.length; i++)
			{
				text += "[*]" + listObjects[i] + "\n";
			}
			
			text += "[/LIST]\n";
			
			document.forms["content"].elements[textareaName].value += text;
		}
	}
	document.forms["content"].elements[textareaName].focus();
}

function insertKeyword(keyword)
{
	if (typeof keyword.parentNode.htmlFor == "undefined")
	{
		if(supportInsert(keyword.parentNode.parentNode.parentNode.htmlFor))
		{
			replace(keyword.parentNode.parentNode.parentNode.htmlFor, keyword.textContent, "");
		}
	}
	else
	{
		if(supportInsert(keyword.parentNode.htmlFor))
		{
			replace(keyword.parentNode.htmlFor, keyword.textContent, "");
		}
	}
}