<?php
class TS3Telnet
{
	private $fp;
	private $serverAddress;
	private $serverQueryPort;
	private $serverVirtualServerID;
	private $serverVirtualServerPort;
	private $loginName;
	private $loginPassword;
	private $DEBUG = false;
	private $sshMode = false;
	
	function __construct($classdb, $botid, $serverAddress = null, $serverQueryPort = null, $loginName = null, $loginPassword = null, $serverVirtualServerID = null, $serverVirtualServerPort = null, $sshMode = false)
	{
        if ($botid == null)
        {
            $this->serverAddress = $serverAddress;
            $this->serverQueryPort = $serverQueryPort;
            $this->serverVirtualServerID = $serverVirtualServerID;
            $this->serverVirtualServerPort = $serverVirtualServerPort;
            $this->loginName = $loginName;
            $this->loginPassword = $loginPassword;
			$this->sshMode = ($sshMode == "ssh" ? true : false);
        }
        else if (is_numeric($botid))
		{
			require_once("class/PWCrypt.php");			
			$PWCrypt = new PWCrypt();
			
			$resList = $classdb->db_query("SELECT configkey, configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey IN ('ts3_server_address', 'ts3_server_query_port', 'ts3_virtualserver_id', 'ts3_virtualserver_port', 'ts3_server_query_login', 'ts3_server_query_password', 'ts3_server_query_mode')");
			
			if (mysqli_num_rows($resList) >= 6)
			{
				while($row = mysqli_fetch_row($resList))
				{
					if ($row[0] == "ts3_server_address")
					{
						$this->serverAddress = $row[1];
					}
					else if ($row[0] == "ts3_server_query_port")
					{
						$this->serverQueryPort = $row[1];
					}
					else if ($row[0] == "ts3_virtualserver_id")
					{
						$this->serverVirtualServerID = $row[1];
					}
					else if ($row[0] == "ts3_virtualserver_port")
					{
						$this->serverVirtualServerPort = $row[1];
					}
					else if ($row[0] == "ts3_server_query_login")
					{
						$this->loginName = $row[1];
					}
					else if ($row[0] == "ts3_server_query_password")
					{
						$this->loginPassword = $PWCrypt->decryptString($row[1]);
					}
					else if ($row[0] == "ts3_server_query_mode")
					{
						$this->sshMode = ($row[1] == "ssh" ? true : false);
					}
				}
			}
		}
	}
	
	function TSConnect()
	{
		if ($this->DEBUG) echo "Connect to TS3 server: ".$this->serverAddress.":".$this->serverQueryPort."<br>\n"; // DEBUG
		
		if ($this->sshMode)
		{
			if ($this->DEBUG) echo "ssh query mode enabled!<br>\n"; // DEBUG
			if (function_exists('ssh2_connect'))
			{
				$connection = ssh2_connect($this->serverAddress, $this->serverQueryPort);
				if (!$connection)
				{
					return array('retvalue' => -1, 'msg' => null);
				}
				
				if (!ssh2_auth_password($connection, $this->loginName, $this->loginPassword))
				{
					return array('retvalue' => 0, 'msg' => null);
				}
				
				$this->fp = ssh2_shell($connection, 'raw');
				if (!$this->fp)
				{
					return array('retvalue' => -3, 'msg' => '{ts3telnet_erroropenshell}');
				}
				
				stream_set_blocking($this->fp, true);
			}
			else
			{
				return array('retvalue' => -3, 'msg' => '{ts3telnet_nossh2connect}');
			}
		}
		else
		{
			if ($this->DEBUG) echo "ssh query mode disabled!<br>\n"; // DEBUG
			$this->fp = @fsockopen($this->serverAddress, $this->serverQueryPort, $errornr, $errorstr, 1);
			
			if (!$this->fp)
			{
				if ($this->DEBUG) echo "Connection failed!<br>\n"; // DEBUG
				return false;
			}
		}
		
		if ($this->DEBUG) echo "Connection established!<br>\n"; // DEBUG
		if (!$this->sshMode)
			stream_set_timeout($this->fp, 0, 2000000);
	
		$errorcon = false;
		$dataReturn = array();
		$chr = "";
		$rawData = "";
		
		while (true)
		{
			$chr = fgetc($this->fp);
			$status = stream_get_meta_data($this->fp);
			
			if ($this->DEBUG) echo $chr; // DEBUG
			
			if ($chr == "\n")
			{
				$dataReturn[] = $rawData;
				
				if (substr($rawData, 0, 9) == "error id=")
				{
					break;
				}
				
				$rawData = "";
			}
			else if ($chr == "\r")
			{
				// just ignore
			}
			else
			{
				$rawData .= $chr;
			}
			
			if ($status['timed_out'])
			{
				$rawData = str_replace('\r', "", $rawData);
				$rawData = str_replace('\n', "", $rawData);
				$dataReturn[] = $rawData;
				if ($this->DEBUG) echo "Stream timed out!<br>\n"; // DEBUG
				break;
			}
			if ($status['unread_bytes'] == 0)
			{
				$rawData = str_replace('\r', "", $rawData);
				$rawData = str_replace('\n', "", $rawData);
				$dataReturn[] = $rawData;
				if ($this->DEBUG) echo "No unread bytes!<br>\n"; // DEBUG
				break;
			}
			if ($status['eof'])
			{
				$rawData = str_replace('\r', "", $rawData);
				$rawData = str_replace('\n', "", $rawData);
				$dataReturn[] = $rawData;
				$errorcon = true;
				break;
			}
		}
		
		if (substr($dataReturn[0], 0, 3) == "TS3" && $errorcon === false)
		{
			if ($this->DEBUG) echo "TS3 server identified!<br>\n"; // DEBUG
			return true;
		}
		else if (substr($dataReturn[0], 0, 8) == "TeaSpeak" && $errorcon === false)
		{
			if ($this->DEBUG) echo "TeaSpeak server identified!<br>\n"; // DEBUG
			return true;
		}
		else if (substr($dataReturn[0], 0, 3) == "TS3")
		{
			if ($this->DEBUG) echo "TS3 server identified, but banned!<br>\n"; // DEBUG
			return $this->parseErrorLine($dataReturn);
		}
		else
		{
			if ($this->DEBUG) echo "Not a TS3 server or currently banned/blocked!<br>\n"; // DEBUG
			return false;
		}
	}
	
	function TSLogin()
	{
		if ($this->sshMode)
			return array("id" => 0, "msg" => "ok");
		
		$result = $this->DoCommand("login ".$this->convertText2TS($this->loginName)." ".$this->convertText2TS($this->loginPassword));
		return $this->parseErrorLine($result);
	}

	function SelectServer()
	{
		if ($this->serverVirtualServerID > 0)
		{
			$result = $this->DoCommand("use ".$this->serverVirtualServerID);
		}
		else
		{
			$result = $this->DoCommand("use port=".$this->serverVirtualServerPort);
		}
		
		return $this->parseErrorLine($result);
	}
	
	function SetClientName($nickname)
	{
		if ($nickname == null) return false;
		
		$result = $this->DoCommand("clientupdate client_nickname=".$this->convertText2TS($nickname));
		return $this->parseErrorLine($result);
	}
	
	function Disconnect()
	{
		if ($this->fp)
		{
			if ($this->DEBUG) echo "SEND: quit\n"; // DEBUG
			
			$error = fputs($this->fp, "quit\r\n", strlen("quit\r\n"));
			if ($error == false)
			{
				return false;
			}
			
			fclose($this->fp);
			
			if ($this->DEBUG) echo "Connection closed!\n"; // DEBUG
		}
	}
	
	function DoCommand($cmd)
	{
		if ($this->fp)
		{
			if ($this->DEBUG) echo "SEND: ".$cmd."\n"; // DEBUG
			
			$error = fputs($this->fp, $cmd."\r\n");
			if ($error == false)
			{
				return false;
			}
			
			$dataReturn = array();
			$chr = "";
			$rawData = "";
			
			while (true)
			{
				$chr = fgetc($this->fp);
				$status = stream_get_meta_data($this->fp);
			
				if ($this->DEBUG) echo $chr; // DEBUG
				
				if ($chr == "\n")
				{
					$dataReturn[] = $rawData;
					
					if (substr($rawData, 0, 9) == "error id=")
					{
						break;
					}
					
					$rawData = "";
				}
				else if ($chr == "\r")
				{
					// just ignore
				}
				else
				{
					$rawData .= $chr;
				}
				
				if ($status['eof'])
				{
					$rawData = str_replace('\r', "", $rawData);
					$rawData = str_replace('\n', "", $rawData);
					$dataReturn[] = $rawData;
					break;
				}
			}
			
			if ($this->DEBUG) print_r($dataReturn); // DEBUG
			
			return $dataReturn;
		}
		else
		{
			return false;
		}
	}
	
	function GetList($listtype)
	{
		$command = null;
		if ($listtype == "usersonline")
		{
			$command = "clientlist -uid";
		}
		else if ($listtype == "channels")
		{
			$command = "channellist -flags";
		}
		else if ($listtype == "servergrouplist")
		{
			$command = "servergrouplist";
		}
		else if ($listtype == "channelgrouplist")
		{
			$command = "channelgrouplist";
		}
		else if ($listtype == "permissionlist")
		{
			$command = "permissionlist";
		}
		else if ($listtype == "iconlist")
		{
			$command = "ftgetfilelist cid=0 cpw= path=\/icons";
		}
		
		if ($command == null)
		{
			return false;
		}
	
		$dataReturn = $this->DoCommand($command);
	
		if ($dataReturn === false)
		{
			return false;
		}
		else
		{
			if ($this->DEBUG) print_r($dataReturn); // DEBUG
			
			$listentry = array();
			$listentry = $this->parseErrorLine($dataReturn);
			
			if ($listentry['id'] != 0)
			{
				return $listentry;
			}
			
			$listtmp = explode("|", $dataReturn[0]);
			for ($i = 0; $i < sizeof($listtmp); $i++)
			{
				$listkeytemp = explode(" ", $listtmp[$i]);
				for ($x = 0; $x < sizeof($listkeytemp); $x++)
				{
					$listkeytemp2 = explode("=", $listkeytemp[$x], 2);
					$listentry['response'][$i][$listkeytemp2[0]] = (sizeof($listkeytemp2) > 1 ? $this->convertTS2Text($listkeytemp2[1]) : "");
				}
			}
			
			return $listentry;
		}
	}
	
	function GetServerInfo()
	{
		if ($this->fp)
		{
			if ($this->DEBUG) echo "SEND: serverinfo\n"; // DEBUG
			
			$dataReturn = $this->DoCommand("serverinfo");
			
			$serverinfo = array();
			$serverinfo = $this->parseErrorLine($dataReturn);
			
			if ($serverinfo['id'] != 0)
			{
				return $serverinfo;
			}
			
			$infotmp = explode(" ", $dataReturn[0]);
			for ($x = 0; $x < sizeof($infotmp); $x++)
			{
				$listkeytemp2 = explode("=", $infotmp[$x], 2);
				$serverinfo['response'][$listkeytemp2[0]] = (sizeof($listkeytemp2) > 1 ? $this->convertTS2Text($listkeytemp2[1]) : "");
			}
			
			return $serverinfo;
		}
		else
		{
			return false;
		}
	}
	
	function parseErrorLine($response)
	{
		if ($response == null || !is_array($response))
		{
			return false;
		}
		
		$errorInfo = false;
	
		foreach ($response as $line)
		{
			if (substr($line, 0, 9) != "error id=")
				continue;
			
			$errorInfo = array();
			$infotmp = explode(" ", $line);
			for ($x = 1; $x < sizeof($infotmp); $x++)
			{
				$listkeytemp2 = explode("=", $infotmp[$x], 2);
				$errorInfo[$listkeytemp2[0]] = (sizeof($listkeytemp2) > 1 ? $this->convertTS2Text($listkeytemp2[1]) : "");
			}
			
			return $errorInfo;
		}
		
		return $errorInfo;
	}
	
	/* Convert Text Strings to be Teamspeak Telnet compatible */
	function convertText2TS($text)
	{
		$returnText = $text;
		$returnText = str_replace('\\','\\\\',$returnText);
		$returnText = str_replace(' ','\\s',$returnText);
		$returnText = str_replace('/','\\/',$returnText);
		$returnText = str_replace('|','\\p',$returnText);
		//$returnText = utf8_encode($returnText);
		
		return $returnText;
	}
	
	/* Convert Text Strings from Teamspeak Telnet */
	function convertTS2Text($text)
	{
		$returnText = $text;
		$returnText = str_replace('\\\\','\\[$mksave]',$returnText);
		$returnText = str_replace('\\s',' ',$returnText);
		$returnText = str_replace('\\/','/',$returnText);
		$returnText = str_replace('\\p','|',$returnText);
		$returnText = str_replace('\\[$mksave]','\\',$returnText);
		//$returnText = utf8_decode($returnText);
		
		return $returnText;
	}
}
?>