<?php
class BotTelnet
{
	private $fp;
	private $botAddress;
	private $botQueryPort;
	private $loginPassword;
	private $isConnected;
	private $isLoggedIn;
	
	function __construct($class_db)
	{
		$resList = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermodwebui_settings WHERE configkey LIKE 'bottelnet_%'");
		
		$configValues = array();
		
		$configReadCount = 0;
		while($row = mysqli_fetch_row($resList))
		{
			$configValues[$row[0]] = $row[1];
			++$configReadCount;
		}
		
		if ($configReadCount == 3)
		{
			$this->botAddress = $configValues['bottelnet_address'];
			$this->botQueryPort = $configValues['bottelnet_port'];
			$this->loginPassword = $configValues['bottelnet_password'];
		}
		else
		{
			$this->botAddress = null;
			$this->botQueryPort = null;
			$this->loginPassword = null;
		}
		
		$this->isConnected = false;
		$this->isLoggedIn = false;
	}
	
	function doBotConnectTest()
	{
		if ($this->botAddress == null || $this->botQueryPort == null || $this->loginPassword == null)
		{
			return "{bottelnet_test_error_missingconfig}";
		}
		
		$retValue = "";
		
		$this->fp = @fsockopen($this->botAddress, $this->botQueryPort, $errornr, $errorstr, 1);
		
		if ($this->fp)
		{
			$returnString = "";
			$chr = "";
			
			stream_set_timeout($this->fp, 0, 500000);
			$errorcon = false;
			
			while (true)
			{
				$chr .= fgetc($this->fp);
				$status = stream_get_meta_data($this->fp);
				if ($status['timed_out']) break;
				if ($status['eof'])
				{
					$errorcon = true;
					break;
				}
				
				if (strlen($chr) == 15) break;
			}
			
			if (substr($chr, 0, 13) == "JTS3ServerMod" && $errorcon === false)
			{
				$returnString = "&lt; ".$chr."<br>&gt; login ".$this->loginPassword;
				$result = $this->doCommand("login ".$this->loginPassword);
				$returnString .= "<br>&lt; ".$result[0];
				if ($result != false && substr($result[0], 0, 9) == "STATUS OK")
				{
					$returnString .= "<br>&gt; instancerunningcount";
					$statusCode = $this->doCommand("instancerunningcount");
					$returnString .= "<br>&lt; ".$statusCode[0]."<br>&lt; ".$statusCode[1];
					if ($statusCode != false && substr($statusCode[1], 0, 9) == "STATUS OK")
					{
						if (is_numeric($statusCode[0]))
						{
							$retValue = "{bottelnet_test_good}";
						}
						else
						{
							$retValue = "{bottelnet_test_error_notexpected}";
						}
					}
					else
					{
						$retValue = "{bottelnet_test_error_notexpected}";
					}
				}
				else
				{
					$retValue = "{bottelnet_test_error_wrongpw}";
				}
			}
			else
			{
				$retValue = "{bottelnet_test_error_bannednobot}";
				if (strlen($chr) > 0) $returnString .= "<br>&lt; ".$chr;
			}
			
			$this->isConnected = false;
			$this->isLoggedIn = false;
			
			if (strlen($returnString) > 0) $returnString .= "<br>&gt; quit";
			$error = fputs($this->fp, "quit\r<br>", strlen("quit\r<br>"));
			
			$chr = "";
			do
			{
				$chr .= fgetc($this->fp);
				$status = socket_get_status($this->fp);
			}
			while ($status["unread_bytes"]);
			
			if (strlen($returnString) > 0 && strlen($chr) > 0) $returnString .= "<br>&lt; ".$chr;
			
			fclose($this->fp);
			
			if (strlen($returnString) > 0) $retValue .= "<br><br>".$returnString;
		}
		else
		{
			$retValue = "{bottelnet_test_error_offline}";
		}
		
		return $retValue;
	}
	
	function doBotConnect()
	{
		if ($this->botAddress == null || $this->botQueryPort == null)
		{
			return false;
		}
		
		$this->fp = @fsockopen($this->botAddress, $this->botQueryPort, $errornr, $errorstr, 1);
		
		if ($this->fp)
		{
			$chr = "";
			
			stream_set_timeout($this->fp, 0, 500000);
			$errorcon = false;
			
			while (true)
			{
				$chr .= fgetc($this->fp);
				$status = stream_get_meta_data($this->fp);
				if ($status['timed_out']) break;
				if ($status['eof'])
				{
					$errorcon = true;
					break;
				}
			}
			
			if (substr($chr, 0, 13) == "JTS3ServerMod" && $errorcon === false)
			{
				$this->isConnected = true;
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	}
	
	function doBotLogin()
	{
		if ($this->loginPassword == null)
		{
			return false;
		}
		
		$result = $this->doCommand("login ".$this->loginPassword);
		if ($result != false && substr($result[0], 0, 9) == "STATUS OK")
		{
			$this->isLoggedIn = true;
			return true;
		}
		
		return false;
	}
	
	function disconnect()
	{
		if (!$this->isConnected)
			return;
		
		$this->isConnected = false;
		$this->isLoggedIn = false;
		
		if ($this->fp)
		{
			$error = fputs($this->fp, "quit\r\n", strlen("quit\r\n"));
			if ($error == false)
			{
				return false;
			}
			
			$chr = "";
			do
			{
				$chr .= fgetc($this->fp);
				$status = socket_get_status($this->fp);
			}
			while ($status["unread_bytes"]);
			
			fclose($this->fp);
		}
	}
	
	function doCommand($cmd)
	{
		if ($this->fp)
		{
			$error = fputs($this->fp, $cmd."\r\n", strlen($cmd."\r\n"));
			if ($error == false)
			{
				return false;
			}
			
			$dataReturn = array();
			$chr = "";
			$rawData = "";
			
			while (true)
			{
				$chr = fgetc($this->fp);
								
				if ($chr == "\n")
				{
					$dataReturn[] = $rawData;
					
					if (substr($rawData, 0, 7) == "STATUS ")
					{
						break;
					}
					
					$rawData = "";
				}
				else if ($chr == "\r")
				{
					// just ignore
				}
				else
				{
					$rawData .= $chr;
				}
			}
			
			return $dataReturn;
		}
		else
		{
			return false;
		}
	}
	
	function getBotStatus($botname, $doDisconnect = true)
	{
		$retValue = -9;
		if ($this->isConnected || $this->doBotConnect())
		{
			$statusCode = $this->doCommand("status ".$botname);
			if ($statusCode != false && substr($statusCode[1], 0, 9) == "STATUS OK")
			{
				if (is_numeric($statusCode[0]))
				{
					$retValue = $statusCode[0];
				}
				else
				{
					$retValue = -2;
				}
			}
			else
			{
				$retValue = -3;
			}
		}
		
		if ($doDisconnect) $this->disconnect();
		
		return $retValue;
	}
	
	function getBotStatusAll($doDisconnect = true)
	{
		$statusList = null;
		$retValue = -9;
		if ($this->isConnected || $this->doBotConnect())
		{
			$statusCode = $this->doCommand("statusall");
			if ($statusCode != false && substr($statusCode[1], 0, 9) == "STATUS OK")
			{
				if ($statusCode[0] == "")
					return array();
				
				$statusList = array();
				
				$botStatusString = explode(",", $statusCode[0]);
				foreach($botStatusString as $botStatus)
				{
					$part = explode(":", $botStatus);
					$statusList[$part[0]] = $part[1];
				}
			}
			else
			{
				$retValue = -3;
			}
		}
		
		if ($doDisconnect) $this->disconnect();
		
		return ($statusList == null ? $retValue : $statusList);
	}
	
	function startBot($botname, $doDisconnect = true)
	{
		$retValue = false;
		if ($this->isConnected || $this->doBotConnect())
		{
			if ($this->isLoggedIn || $this->doBotLogin())
			{
				$statusCode = $this->doCommand("start ".$botname);
				if ($statusCode != false && substr($statusCode[0], 0, 9) == "STATUS OK")
				{
					$retValue = true;
				}
			}
		}
		
		if ($doDisconnect) $this->disconnect();
		
		return $retValue;
	}
	
	function reloadBot($botname, $doDisconnect = true)
	{
		$retValue = false;
		if ($this->isConnected || $this->doBotConnect())
		{
			if ($this->isLoggedIn || $this->doBotLogin())
			{
				$statusCode = $this->doCommand("reload ".$botname);
				if ($statusCode != false && substr($statusCode[0], 0, 9) == "STATUS OK")
				{
					$retValue = true;
				}
			}
		}
		
		if ($doDisconnect) $this->disconnect();
		
		return $retValue;
	}
	
	function reloadBotConfig($botname, $doDisconnect = true)
	{
		$retValue = false;
		if ($this->isConnected || $this->doBotConnect())
		{
			if ($this->isLoggedIn || $this->doBotLogin())
			{
				$statusCode = $this->doCommand("reloadconfig ".$botname);
				if ($statusCode != false && substr($statusCode[0], 0, 9) == "STATUS OK")
				{
					$retValue = true;
				}
			}
		}
		
		if ($doDisconnect) $this->disconnect();
		
		return $retValue;
	}
	
	function stopBot($botname, $doDisconnect = true)
	{
		$retValue = false;
		if ($this->isConnected || $this->doBotConnect())
		{
			if ($this->isLoggedIn || $this->doBotLogin())
			{
				$statusCode = $this->doCommand("stop ".$botname);
				if ($statusCode != false && substr($statusCode[0], 0, 9) == "STATUS OK")
				{
					$retValue = true;
				}
			}
		}
		
		if ($doDisconnect) $this->disconnect();
		
		return $retValue;
	}
	
	function activateFunction($botname, $functionprefix, $doDisconnect = true)
	{
		$retValue = false;
		if ($this->isConnected || $this->doBotConnect())
		{
			if ($this->isLoggedIn || $this->doBotLogin())
			{
				$statusCode = $this->doCommand("activatefunction ".$botname." ".$functionprefix);
				if ($statusCode != false && substr($statusCode[0], 0, 9) == "STATUS OK")
				{
					$retValue = true;
				}
			}
		}
		
		if ($doDisconnect) $this->disconnect();
		
		return $retValue;
	}
	
	function disableFunction($botname, $functionprefix, $doDisconnect = true)
	{
		$retValue = false;
		if ($this->isConnected || $this->doBotConnect())
		{
			if ($this->isLoggedIn || $this->doBotLogin())
			{
				$statusCode = $this->doCommand("disablefunction ".$botname." ".$functionprefix);
				if ($statusCode != false && substr($statusCode[0], 0, 9) == "STATUS OK")
				{
					$retValue = true;
				}
			}
		}
		
		if ($doDisconnect) $this->disconnect();
		
		return $retValue;
	}
	
	function renameBot($currentName, $newName, $doDisconnect = true)
	{
		$retValue = false;
		if ($this->isConnected || $this->doBotConnect())
		{
			if ($this->isLoggedIn || $this->doBotLogin())
			{
				$statusCode = $this->doCommand("rename ".$currentName.";".$newName);
				if ($statusCode != false && substr($statusCode[0], 0, 9) == "STATUS OK")
				{
					$retValue = true;
				}
			}
		}
		
		if ($doDisconnect) $this->disconnect();
		
		return $retValue;
	}
	
	function instancelistReload($doDisconnect = true)
	{
		$retValue = false;
		if ($this->isConnected || $this->doBotConnect())
		{
			if ($this->isLoggedIn || $this->doBotLogin())
			{
				$statusCode = $this->doCommand("instancelistreload");
				if ($statusCode != false && substr($statusCode[0], 0, 9) == "STATUS OK")
				{
					$retValue = true;
				}
			}
		}
		
		if ($doDisconnect) $this->disconnect();
		
		return $retValue;
	}
}
?>