package de.stefan1200.jts3servermod.interfaces;

import java.util.HashMap;
import java.util.Vector;

/**
 * If your plugin needs to do something at the client list check interval (every second by default, but can be changed by the user), your plugin has to implement this interface!<br><br>
 * 
 * The author of the JTS3ServerMod is not responsible for any damage or data loss!<br><br>
 * 
 * <b>E-Mail:</b><br><a href="mailto:info@stefan1200.de">info@stefan1200.de</a><br><br>
 * <b>Homepage:</b><br><a href="http://www.stefan1200.de" target="_blank">http://www.stefan1200.de</a>
 * @author Stefan Martens
 *
 */
public interface HandleClientList
{
	/**
	 * This method will be called, if a new client list was loaded. The interval can be changed by the user, default is every second.
	 * @param clientList The current client list
	 */
	public void handleClientCheck(Vector<HashMap<String, String>> clientList);
}
