package de.stefan1200.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * This MySQLConnect class loads the MySQL JDBC driver and holds the MySQL database connection.<br><br>
 * 
 * The author of the JTS3ServerMod is not responsible for any damage or data loss!<br><br>
 * 
 * <b>E-Mail:</b><br><a href="mailto:info@stefan1200.de">info@stefan1200.de</a><br><br>
 * <b>Homepage:</b><br><a href="http://www.stefan1200.de" target="_blank">http://www.stefan1200.de</a>
 * @author Stefan Martens
 *
 */
public class MySQLConnect
{
    private Connection dbConnection = null;
    private String url = null;
    private String username = null;
    private String password = null;
	
    /**
     * Load the MySQL driver and set all connection parameters.
     * @param mysqlHost MySQL hostname
     * @param mysqlPort MySQL port
     * @param mysqlDB MySQL database
     * @param mysqlUser MySQL username
     * @param mysqlPW MySQL password
     * @param verifyServerCertificate Should the driver verify the server's certificate? -1 = use default, 0 = no, 1 = yes
     * @param useSSL Use SSL when communicating with the server? -1 = use default, 0 = no, 1 = yes
     * @param requireSSL Require server support of SSL connection if useSSL = 1. -1 = use default, 0 = no, 1 = yes
     * @param useCompression Use zlib compression when communicating with the server? -1 = use default, 0 = no, 1 = yes
     * @throws ClassNotFoundException If the MySQL driver was not found.
     */
	public MySQLConnect(String mysqlHost, int mysqlPort, String mysqlDB, String mysqlUser, String mysqlPW, byte verifyServerCertificate, byte useSSL, byte requireSSL, byte useCompression)
	throws ClassNotFoundException
	{
		if (mysqlPort < 0 || mysqlPort > 65535)
		{
			mysqlPort = 3306;
		}
		
		if (mysqlHost == null) mysqlHost = "localhost";
		if (mysqlDB == null) mysqlDB = "";
		if (mysqlUser == null) mysqlUser = "root";
		if (mysqlPW == null) mysqlPW = "";
		
		StringBuffer sbMySQLArgs = new StringBuffer();
		if (verifyServerCertificate >= 0)
		{
			sbMySQLArgs.append("?verifyServerCertificate=");
			sbMySQLArgs.append((verifyServerCertificate == 1 ? "true" : "false"));
		}
		
		if (useSSL >= 0)
		{
			if (sbMySQLArgs.length() > 0)
				sbMySQLArgs.append("&useSSL=");
			else
				sbMySQLArgs.append("?useSSL=");
			
			sbMySQLArgs.append((useSSL == 1 ? "true" : "false"));
		}
		
		if (requireSSL >= 0)
		{
			if (sbMySQLArgs.length() > 0)
				sbMySQLArgs.append("&requireSSL=");
			else
				sbMySQLArgs.append("?requireSSL=");
			
			sbMySQLArgs.append((requireSSL == 1 ? "true" : "false"));
		}
		
		if (useCompression >= 0)
		{
			if (sbMySQLArgs.length() > 0)
				sbMySQLArgs.append("&useCompression=");
			else
				sbMySQLArgs.append("?useCompression=");
			
			sbMySQLArgs.append((useCompression == 1 ? "true" : "false"));
		}
		
		this.url = "jdbc:mysql://" + mysqlHost + ":" + Integer.toString(mysqlPort) + "/" + mysqlDB + sbMySQLArgs.toString();
		this.username = mysqlUser;
		this.password = mysqlPW;
		
		Class.forName("com.mysql.jdbc.Driver");
	}
	
	public void close()
	{
		try
		{
			if (!dbConnection.isClosed())
			{
				dbConnection.close();
			}
		}
		catch (Exception e)
		{
		}
	}
	
	public void connect()
	throws SQLException
	{
		if (dbConnection == null || dbConnection.isClosed())
		{
			dbConnection = DriverManager.getConnection(this.url, username, password);
		}
	}

	public Connection getConnection()
	{
		return dbConnection;
	}
	
	public PreparedStatement getPreparedStatement(String sql)
	throws SQLException
	{
		return dbConnection.prepareStatement(sql);
	}

	public Statement getStatement()
	throws SQLException
	{
		return dbConnection.createStatement();
	}
}
