package de.stefan1200.jts3servermod.interfaces;

import java.util.BitSet;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.util.ArrangedPropertiesWriter;

/**
 * This is the second important interface. If your plugin needs to load a configuration or to add information to the client list, your plugin has to implement this interface!<br><br>
 * 
 * The author of the JTS3ServerMod is not responsible for any damage or data loss!<br><br>
 * 
 * <b>E-Mail:</b><br><a href="mailto:info@stefan1200.de">info@stefan1200.de</a><br><br>
 * <b>Homepage:</b><br><a href="http://www.stefan1200.de" target="_blank">http://www.stefan1200.de</a>
 * @author Stefan Martens
 *
 */
public interface LoadConfiguration
{
	/**
	 * Initialize the needed config keys and values for this plugin.<br>
	 * <br>
	 * <b>Important:</b><br>
	 * The config key names have to be unique for this plugin and have to use the prefix from {@link HandleBotEvents#initClass(JTS3ServerMod_Interface, de.stefan1200.jts3serverquery.JTS3ServerQuery, String)} for this. This is not the right place to load the current configuration or other stuff!<br>
	 * <br>
	 * <b>Example:</b><br>
	 * <code>config.addKey(configPrefix + "_time", "After how many minutes all clients should be kicked?", "5");<br>
	 * if (modClass.getMySQLConnection() == null) config.addKey(configPrefix + "_file", "Path to file which contains the Auto Kick Timer message.", "%apphome%config/server1/autokicktimermessages.cfg");</code><br>
	 * The second line checks first, if the MySQL mode is activated. Some config keys/values might be not needed, if the JTS3ServerMod stores the configuration in a MySQL database.  
	 * @param config The ArrangedPropertiesWriter instance used from the current virtual bot instance.
	 */
	public void initConfig(ArrangedPropertiesWriter config);
	
	/**
	 * Load the configuration of this plugin and prepare everything to make sure, that this plugin can be activated.<br>
	 * <br>
	 * <b>Example:</b><br>
	 * <code>config.getValue(configPrefix + "_time");</code>
	 * @param config The ArrangedPropertiesWriter instance used from the current virtual bot instance.
	 * @param slowMode If set to <code>true</code>, you can decide what can be done without banning the bot (query_ip_whitelist.txt entry is missing).
	 * @return <code>true</code> if the configuration was loaded successfully and the plugin is ready to be activated. <code>false</code> if not.
	 * @throws BotConfigurationException Use this exception, if something was set wrong in the configuration by the user.
	 * @throws NumberFormatException Use this exception, if a number is not a number. :)
	 */
	public boolean loadConfig(ArrangedPropertiesWriter config, boolean slowMode) throws BotConfigurationException, NumberFormatException;
	
	/**
	 * Set wanted clientlist arguments for this plugin.<br>
	 * To save performance at the Teamspeak 3 server and at the JTS3ServerMod process only that information will be requested, that are really needed.
	 * Look into the JTS3ServerMod_Interface at all static variables starting with the name LIST_ to know which are supported.<br>
	 * <br>
	 * If you don't need the client list or you only need the default client list information (clid (client id), cid (channel id), client_database_id, client_nickname and client_type), just do nothing here.<br>
	 * <br>
	 * <b>Example to get the client idle and connection time:</b><br>
	 * <code>listOptions.set(JTS3ServerMod_Interface.LIST_TIMES);</code>
	 * @param listOptions A BitSet containing the wanted clientlist flags.
	 * @see JTS3ServerMod_Interface#LIST_AWAY
	 * @see JTS3ServerMod_Interface#LIST_COUNTRY
	 * @see JTS3ServerMod_Interface#LIST_GROUPS
	 * @see JTS3ServerMod_Interface#LIST_INFO
	 * @see JTS3ServerMod_Interface#LIST_IP
	 * @see JTS3ServerMod_Interface#LIST_TIMES
	 * @see JTS3ServerMod_Interface#LIST_UID
	 * @see JTS3ServerMod_Interface#LIST_VOICE
	 */
	public void setListModes(BitSet listOptions);
}
