<?PHP

ini_set('display_errors', E_ERROR); ## LIVE
error_reporting(E_ERROR); ## LIVE

#ini_set('display_errors', 1); ## TESTING
#error_reporting(E_ALL);  ## TESTING


header("Content-Type: text/html; charset=utf-8");
mb_internal_encoding('UTF-8');

if (file_exists("config/dbconnect_config.php"))
{
	$config = file("config/dbconnect_config.php", FILE_IGNORE_NEW_LINES);
	
	if (sizeof($config) == 6)
	{
		die("Configuration file already exists! Installation aborted. Use <a href=\"index.php\">index.php</a>.\n<br>\nKonfigurationsdatei existiert bereits! Installation abgebrochen. Benutze <a href=\"index.php\">index.php</a>.");
	}
}

$filelist = array();
$filelist[] = "data/css/bright.css";
$filelist[] = "templates/install_page1.tmpl";
$filelist[] = "templates/index_install.tmpl";
$filelist[] = "templates/install_page2.tmpl";
$filelist[] = "templates/install_page2_entry.tmpl";
$filelist[] = "sql/default.sql";

foreach($filelist as $filename)
{
	if (!file_exists($filename))
	{
		die("Important file missing! Installation aborted.\n<br>\nWichtige Datei fehlt! Installation abgebrochen.\n<br><br>\nFile / Datei: ".$filename);
	}
}

require_once("include/formularfunctions.php");

function getFirstPage($status = "", $mysqlhost = "", $mysqluser = "", $mysqlpassword = "", $mysqldatabase = "", $adminuser = "", $adminpassword = "", $adminemail = "", $createtables = "no")
{
	$tmpl = implode(" ", file("templates/install_page1.tmpl"));
	$tmpl = str_replace('{status}', ($status == "" ? "" : "<div align=\"center\">".$status."</div>"), $tmpl);
	$tmpl = str_replace('{mysqlhost}', $mysqlhost, $tmpl);
	$tmpl = str_replace('{mysqluser}', $mysqluser, $tmpl);
	$tmpl = str_replace('{mysqlpassword}', $mysqlpassword, $tmpl);
	$tmpl = str_replace('{mysqldatabase}', $mysqldatabase, $tmpl);
	$tmpl = str_replace('{adminuser}', $adminuser, $tmpl);
	$tmpl = str_replace('{adminpassword}', $adminpassword, $tmpl);
	$tmpl = str_replace('{adminemail}', $adminemail, $tmpl);
	$tmpl = str_replace('{createtables}', $createtables, $tmpl);
	$tmpl = str_replace('{fs_webuiadmin}', ($createtables == "no" ? " class=\"hidden\"" : ""), $tmpl);
	$tmpl = str_replace('{img_tick}', ($createtables == "no" ? " style=\"visibility:hidden;\"" : ""), $tmpl);
	
	return $tmpl;
}

function getPage2Entry($text, $status)
{
	$statusHTML = "n/a";
	if ($status == 0) $statusHTML = "<img src=\"images/cancel.png\" border=\"0\" alt=\"Error / Fehler\">";
	if ($status == 1) $statusHTML = "<img src=\"images/accept.png\" border=\"0\" alt=\"OK\">";
	if ($status == 2) $statusHTML = "<img src=\"images/add.png\" border=\"0\" alt=\"Added / Hinzugefuegt\">";

	$tmpl = implode(" ", file("templates/install_page2_entry.tmpl"));
	$tmpl = str_replace('{text}', $text, $tmpl);
	$tmpl = str_replace('{status}', $statusHTML, $tmpl);
	return $tmpl;
}

function getTableName($sqlline)
{
	$pos1 = strpos($sqlline, "`");
	$pos2 = strpos($sqlline, "`", $pos1+1);
	return substr($sqlline, $pos1+1, $pos2-($pos1+1));
}

function getSQLFile()
{
	return file("sql/default.sql", FILE_IGNORE_NEW_LINES+FILE_SKIP_EMPTY_LINES);
}

function getTableList($dblink)
{
	$queryTableList = mysqli_query($dblink, "SHOW TABLES LIKE 'jts3servermod%'");
	if ($queryTableList === false)
		return null;
	
	if (mysqli_num_rows($queryTableList) == 0)
		return false;
	
	$table_list = array();
	while($row = mysqli_fetch_row($queryTableList))
	{
		$table_list[] = $row[0];
	}
	
	return $table_list;
}

function checkTables($dblink)
{
	$retValue = array();
	$retValue['TableContent'] = "";
	$retValue['MySQLErrors'] = "";
	
	$table_list = getTableList($dblink);
	
	if ($table_list === null)
	{
		$retValue['MySQLErrors'] .= "<br>".mysqli_error($dblink);
		$retValue['TableContent'] .= getPage2Entry("Requesting table list<br>Frage Tabellenliste ab", 0);
	}
	else if ($table_list === false)
	{
		return $retValue;
	}
	else
	{
		$retValue['TableContent'] .= getPage2Entry("Requesting table list<br>Frage Tabellenliste ab", 1);

		$sqlRawData = getSQLFile();
		for ($i = 0; $i < sizeof($sqlRawData); $i++)
		{
			if (substr($sqlRawData[$i], 0, 13) == "CREATE TABLE ")
			{
				$tableName = getTableName($sqlRawData[$i]);
				if (array_search($tableName, $table_list) !== false)
					$retValue['TableContent'] .= getPage2Entry("Already exists / Bereits vorhanden:<br>Table ".$tableName, 1);
			}
		}
	}
	
	return $retValue;
}

function importSQLData($dblink)
{
	$retValue = array();
	$retValue['TableContent'] = "";
	$retValue['MySQLErrors'] = "";

	$table_list = getTableList($dblink);
	
	if ($table_list === null)
	{
		$retValue['MySQLErrors'] .= "<br>".mysqli_error($dblink);
		$retValue['TableContent'] .= getPage2Entry("Requesting table list<br>Frage Tabellenliste ab", 0);
	}
	else
	{
		$retValue['TableContent'] .= getPage2Entry("Requesting table list<br>Frage Tabellenliste ab", 1);
		
		$sqlRawData = getSQLFile();
		$sqlRawDataCount = count($sqlRawData);
		$insertDataTotal = 0;
		$importedDataSuccess = 0;
		
		for ($i = 0; $i < $sqlRawDataCount; $i++)
		{
			if (substr($sqlRawData[$i], 0, 12) == "INSERT INTO ")
			{
				++$insertDataTotal;
				if (mysqli_query($dblink, $sqlRawData[$i]))
				{
					++$importedDataSuccess;
				}
				else
				{
					$retValue['MySQLErrors'] .= "<br>".mysqli_error($dblink);
				}
			}
			else if (substr($sqlRawData[$i], 0, 13) == "CREATE TABLE ")
			{
				$tableName = getTableName($sqlRawData[$i]);
				if (is_array($table_list) && array_search($tableName, $table_list) !== false)
				{
					if (mysqli_query($dblink, "DROP TABLE ".$tableName))
					{
						$retValue['TableContent'] .= getPage2Entry("Deleting existing table / Vorhandene Tabelle l&ouml;schen:<br>Table ".$tableName, 1);
					}
					else
					{
						$retValue['TableContent'] .= getPage2Entry("Deleting existing table / Vorhandene Tabelle l&ouml;schen:<br>Table ".$tableName, 0);
						$retValue['MySQLErrors'] .= "<br>".mysqli_error($dblink);
						break;
					}
				}
				
				if (mysqli_query($dblink, $sqlRawData[$i]))
				{
					$retValue['TableContent'] .= getPage2Entry("Creating / Erstelle:<br>Table ".$tableName, 2);
				}
				else
				{
					$retValue['TableContent'] .= getPage2Entry("Creating / Erstelle:<br>Table ".$tableName, 0);
					$retValue['MySQLErrors'] .= "<br>".mysqli_error($dblink);
				}
			}
		}
		
		if ($insertDataTotal == $importedDataSuccess)
		{
			$retValue['TableContent'] .= getPage2Entry("Importing / Importiere:<br>".$importedDataSuccess." / ".$insertDataTotal." Table contents / Tabellen Inhalte", 2);
		}
		else
		{
			$retValue['TableContent'] .= getPage2Entry("Importing / Importiere:<br>".$importedDataSuccess." / ".$insertDataTotal." Table contents / Tabellen Inhalte", 0);
		}
	}
	
	return $retValue;
}

$output = implode(" ", file("templates/index_install.tmpl"));
$tmpl = "";

if (isset($_POST['mode']) && $_POST['mode'] == "saveMySQL")
{
	if ($_POST['createtables'] == "yes" && (!isset($_POST['adminuser']) || $_POST['adminuser'] == "" || !isset($_POST['adminpassword']) || $_POST['adminpassword'] == "" || !isset($_POST['adminemail']) || $_POST['adminemail'] == ""))
	{
		$tmpl = getFirstPage("<img src=\"images/exclamation.png\" border=\"0\" alt=\"Error\"> Don't forget to set a web interface admin username, password and email! <img src=\"images/exclamation.png\" border=\"0\" alt=\"Error\"><br><img src=\"images/exclamation.png\" border=\"0\" alt=\"Fehler\"> Vergesse nicht ein Web Interface Admin Benutzernamen, Passwort und E-Mail anzugeben! <img src=\"images/exclamation.png\" border=\"0\" alt=\"Fehler\"><br><br>", $_POST['mysqlhost'], $_POST['mysqluser'], $_POST['mysqlpassword'], $_POST['mysqldatabase'], $_POST['adminuser'], $_POST['adminpassword'], $_POST['adminemail'], $_POST['createtables']);
	}
	else if ($_POST['createtables'] == "yes" && !isPasswordValid($_POST['adminpassword']))
	{
		$tmpl = getFirstPage("<img src=\"images/exclamation.png\" border=\"0\" alt=\"Error\"> The admin password is not valid. The length must be between 8 and 30 characters and contain only english letters (A-Z), numbers (0-9), dot (.), plus (+), minus (-), underscore (_), number sign (#), exclamation mark (!) and question mark (?). <img src=\"images/exclamation.png\" border=\"0\" alt=\"Error\"><br><img src=\"images/exclamation.png\" border=\"0\" alt=\"Fehler\"> Das Admin Passwort ist nicht g&uuml;ltig. Die L&auml;nge muss zwischen 8 und 30 Zeichen sein und darf nur englische Buchstaben (A-Z), Zahlen (0-9), Punkt (.), Plus (+), Minus (-), Unterzeichen (_), Nummernzeichen (#), Ausrufezeichen (!) und Fragezeichen (?) beinhalten. <img src=\"images/exclamation.png\" border=\"0\" alt=\"Fehler\"><br><br>", $_POST['mysqlhost'], $_POST['mysqluser'], $_POST['mysqlpassword'], $_POST['mysqldatabase'], $_POST['adminuser'], $_POST['adminpassword'], $_POST['adminemail'], $_POST['createtables']);
	}
	else
	{
		$dblink = mysqli_connect($_POST['mysqlhost'], $_POST['mysqluser'], $_POST['mysqlpassword'], $_POST['mysqldatabase']);
		
		if (mysqli_connect_error() != null)
		{
			$tmpl = getFirstPage("<img src=\"images/exclamation.png\" border=\"0\" alt=\"Error\"> Unable to connect to MySQL server <img src=\"images/exclamation.png\" border=\"0\" alt=\"Error\"><br><img src=\"images/exclamation.png\" border=\"0\" alt=\"Fehler\"> Es konnte keine Verbindung zum MySQL Server hergestellt werden <img src=\"images/exclamation.png\" border=\"0\" alt=\"Fehler\"><br><br>".mysqli_connect_error(), $_POST['mysqlhost'], $_POST['mysqluser'], $_POST['mysqlpassword'], $_POST['mysqldatabase'], $_POST['adminuser'], $_POST['adminpassword'], $_POST['adminemail'], $_POST['createtables']);
		}
		else if (!mysqli_set_charset($dblink, "utf8"))
		{
			$tmpl = getFirstPage("<img src=\"images/exclamation.png\" border=\"0\" alt=\"Error\"> Unable to select UTF8 charset for the MySQL connection <img src=\"images/exclamation.png\" border=\"0\" alt=\"Error\"><br><img src=\"images/exclamation.png\" border=\"0\" alt=\"Fehler\"> Es konnte nicht der UTF8 Zeichensatz f&uuml;r die MySQL Verbindung eingestellt werden <img src=\"images/exclamation.png\" border=\"0\" alt=\"Fehler\"><br><br>", $_POST['mysqlhost'], $_POST['mysqluser'], $_POST['mysqlpassword'], $_POST['mysqldatabase'], $_POST['adminuser'], $_POST['adminpassword'], $_POST['adminemail'], $_POST['createtables']);
		}
		else
		{
			$tmpl = implode(" ", file("templates/install_page2.tmpl"));
			$page2Status = "";
			
			$fh = fopen("config/dbconnect_config.php", 'w');
			if (!$fh)
			{
				$tablecontent = getPage2Entry("Connection to MySQL database<br>Verbindung zur MySQL Datenbank", 1);
				$tablecontent .= getPage2Entry("Creating config file for web interface", 0);
				$page2Status = "Unable to write config file! Please check if PHP can write to config/dbconnect_config.php.<br>Es kann die Konfigdatei nicht geschrieben werden! Bitte pr&uuml;fen, ob PHP nach config/dbconnect_config.php schreiben kann.";
			}
			else
			{
				fwrite($fh, "<?php /*\n");
				fwrite($fh, $_POST['mysqlhost']."\n");
				fwrite($fh, $_POST['mysqluser']."\n");
				fwrite($fh, $_POST['mysqlpassword']."\n");
				fwrite($fh, $_POST['mysqldatabase']."\n");
				fwrite($fh, "*/ ?>");
				fclose($fh);
				chmod("config/dbconnect_config.php", 0777);
				
				$tablecontent = getPage2Entry("Connection to MySQL database<br>Verbindung zur MySQL Datenbank", 1);
				$tablecontent .= getPage2Entry("Creating config file for web interface<br>Erstelle Konfigurationsdatei f&uuml;r das Webinterface", 1);
				
				$anythingOK = true;
				$mySQLErrors = "";
				
				if ($_POST['createtables'] == "yes")
				{
					$result_sqlimport = importSQLData($dblink);
					$tablecontent .= $result_sqlimport['TableContent'];
					
					if ($result_sqlimport['MySQLErrors'] != "")
						$anythingOK = false;
					
					$mySQLErrors .= $result_sqlimport['MySQLErrors'];
					
					if ($anythingOK)
					{
						require_once("class/PWHash.php");
						$PWHash = new PWHash();
						$pwsalt = $PWHash->createSalt();
						
						if (mysqli_query($dblink, "INSERT INTO jts3servermodwebui_users (`name`, `password`, `salt`, `email`, `adminlevel`, `userstatus`, `registertime`) VALUES ('".mysqli_real_escape_string($dblink, $_POST['adminuser'])."', '".mysqli_real_escape_string($dblink, $PWHash->hashString($_POST['adminpassword'], $pwsalt))."', '".$pwsalt."', '".mysqli_real_escape_string($dblink, $_POST['adminemail'])."', '2', '0', '".time()."')"))
						{
							$tablecontent .= getPage2Entry("Creating / Erstelle:<br>Admin Account ".$_POST['adminuser'], 2);
						}
						else
						{
							$tablecontent .= getPage2Entry("Creating / Erstelle:<br>Admin Account ".$_POST['adminuser'], 0);
							$mySQLErrors .= "<br>".mysqli_error($dblink);
							$anythingOK = false;
						}
					}
				}
				else
				{
					$result_tablecheck = checkTables($dblink);
					$tablecontent .= $result_tablecheck['TableContent'];
					
					if ($result_tablecheck['MySQLErrors'] != "")
						$anythingOK = false;
					
					$mySQLErrors .= $result_tablecheck['MySQLErrors'];
				}
				
				if ($anythingOK && $_POST['createtables'] == "yes")
				{
					$page2Status = "Anything OK, you can use the <a href=\"index.php\">web interface</a> now!<br>Alles OK, das <a href=\"index.php\">Web Interface</a> kann nun verwendet werden!";
				}
				else if ($anythingOK)
				{
					$page2Status = "Anything OK, don't forget to create missing tables for the <a href=\"index.php\">web interface</a>!<br>Alles OK, nicht vergessen fehlende Tabellen f&uuml;r das <a href=\"index.php\">Web Interface</a> zu erstellen!";
				}
				else
				{
					$page2Status = "An error occurred while creating the tables or importing the table data!<br>Ein Fehler beim Erstellen der Tabellen oder beim Importieren der Tabellendaten ist aufgetreten!<br><br><b>List of MySQL errors:</b>".$mySQLErrors;
				}
			}
			
			$tmpl = str_replace('{tablecontent}', $tablecontent, $tmpl);
			$tmpl = str_replace('{status}', $page2Status, $tmpl);
			mysqli_close($dblink);
		}
	}
}
else
{
	$tmpl = getFirstPage();
}

$output = str_replace('{content}', $tmpl, $output);
echo $output;

?>