<?PHP

function autoUpdateSQL($class_db, $currentBuild, $newBuild)
{
	if (!is_numeric($newBuild))
		return 0;
	
	$updateFile = file("sql/autoupdate/".$newBuild.".sql", FILE_IGNORE_NEW_LINES+FILE_SKIP_EMPTY_LINES);
	
	if ($updateFile === false)
		return -1;
	
	if ($updateFile[1] != "-- ".$newBuild)
		return -2;
	
	if ($updateFile[3] != "-- ".$currentBuild)
		return -3;
	
	$updateFileCount = count($updateFile);
	for ($i = 4; $i < $updateFileCount; $i++)
	{
		$class_db->db_query($updateFile[$i]);
	}
	
	$class_db->db_query("UPDATE `jts3servermodwebui_settings` SET `configvalue` = '".$newBuild."' WHERE `configkey` = 'webui_build'");
	
	return 1;
}

function sqlUpdateCheck($class_db)
{
	$output = implode(" ", file("templates/index_maintenance.tmpl"));
	$for_output = "";
	
	$resCurrentBuild = $class_db->db_query("SELECT configvalue FROM jts3servermodwebui_settings WHERE configkey = 'webui_build'");
	if (mysqli_num_rows($resCurrentBuild) == 1)
	{
		$sqlFiles = array();
	
		if ($handle = opendir('sql/autoupdate'))
		{
			while (false !== ($file = readdir($handle)))
			{
				if (substr($file, -4, 4) == ".sql" && is_numeric(substr($file, 0, -4)))
				{
					$sqlFiles[] = substr($file, 0, -4);
				}
			}

			closedir($handle);
		}
		
		sort($sqlFiles, SORT_NUMERIC);
		$sqlFilesCount = count($sqlFiles);
		
		$currentBuild = mysqli_fetch_array($resCurrentBuild);
		
		for ($i = 0; $i < $sqlFilesCount; $i++)
		{
			if ($sqlFiles[$i] <= $currentBuild[0])
				unset($sqlFiles[$i]);
			else
				break;
		}
		
		$sqlFiles = array_values($sqlFiles);
		$sqlFilesCount = count($sqlFiles);
		
		if ($sqlFilesCount == 0)
			return;
		
		if (isset($_GET['update']) && $_GET['update'] == "yes")
		{
			$lastSuccessfulBuild = $currentBuild[0];
			for ($i = 0; $i < $sqlFilesCount; $i++)
			{
				$result = autoUpdateSQL($class_db, $lastSuccessfulBuild, $sqlFiles[$i]);
				if ($result == 1)
				{
					$lastSuccessfulBuild = $sqlFiles[$i];
				}
				else if ($result == 0)
				{
					$for_output = "<b>Error!</b><br>Stopped automatic updating of database at build ".$sqlFiles[$i].", because of illegal file name and build number of update file! All previous updates was executed successfully.\n<br><br>\n".
						"<b>Fehler!</b><br>Automatische Datenbank Aktualisierung bei Build ".$sqlFiles[$i]." gestoppt aufgrund einem ung&uuml;ltigen Dateinamen und Build Nummer der Update Datei! Alle vorherigen Updates wurden erfolgreich ausgef&uuml;hrt.";
					break;
				}
				else if ($result == -1)
				{
					$for_output = "<b>Error!</b><br>Stopped automatic updating of database at build ".$sqlFiles[$i].", because of an error while reading the ".$sqlFiles[$i].".sql file! All previous updates was executed successfully.\n<br><br>\n".
						"<b>Fehler!</b><br>Automatische Datenbank Aktualisierung bei Build ".$sqlFiles[$i]." gestoppt aufgrund eines Fehlers beim Lesen der ".$sqlFiles[$i].".sql Datei! Alle vorherigen Updates wurden erfolgreich ausgef&uuml;hrt.";
					break;
				}
				else if ($result == -2)
				{
					$for_output = "<b>Error!</b><br>Stopped automatic updating of database at build ".$sqlFiles[$i].", because of an invalid SQL update file! All previous updates was executed successfully.\n<br><br>\n".
						"<b>Fehler!</b><br>Automatische Datenbank Aktualisierung bei Build ".$sqlFiles[$i]." gestoppt aufgrund einer ung&uuml;ltigen SQL Update Datei! Alle vorherigen Updates wurden erfolgreich ausgef&uuml;hrt.";
					break;
				}
				else if ($result == -3)
				{
					$for_output = "<b>Error!</b><br>Stopped automatic updating of database at build ".$sqlFiles[$i].", because of a missing database build requirement! All previous updates was executed successfully.\n<br><br>\n".
						"<b>Fehler!</b><br>Automatische Datenbank Aktualisierung bei Build ".$sqlFiles[$i]." gestoppt aufgrund einer nicht erf&uuml;llten Datenbank Build Voraussetzung! Alle vorherigen Updates wurden erfolgreich ausgef&uuml;hrt.";
					break;
				}
			}
			
			if ($for_output == "")
			{
				$for_output = "<b>Database update successful!</b><br>Successfully executed the following database updates: Build ".implode(", ", $sqlFiles).
					"\n<br><br>\n<b>Datenbank Update erfolgreich!</b><br>Die folgenden Datenbank Updates wurden erfolgreich ausgef&uuml;hrt: Build ".implode(", ", $sqlFiles).
					"\n<br><br>\n<a href=\"index.php\">Start Page / Startseite</a>";
			}
		}
		else
		{
			$for_output = "<b>An automatic SQL update is necessary!</b><br>If you accept, the following SQL updates will be executed one-by-one: Build ".implode(", ", $sqlFiles).
				"\n<br><br>\n<b>Ein automatisches SQL Update ist notwendig!</b><br>Wenn dem zugestimmt wird, werden folgende SQL updates nacheinander ausgef&uuml;hrt: Build ".implode(", ", $sqlFiles).
				"\n<br><br>\n<a href=\"index.php?update=yes\">Start updating / Starte Aktualisierung</a>";
		}
	}
	else
	{
		$for_output = "<b>Manual SQL update necessary!</b><br>Please make sure that you execute the SQL files of all updates in the MySQL database since your last ".
			"used version of the web interface up to version 3.0. You will find this SQL files in the sql directory of the web interface.\n<br><br>\n".
			"<b>Manuelles SQL Update notwendig!</b><br>Stelle bitte sicher, das in der MySQL Datenbank alle SQL Dateien von allen Updates vom Web Interface seit ".
			"der zuletzt verwendeten Version bis zur Version 3.0 ausgef&uuml;hrt werden. Die SQL Dateien sind im sql Verzeichnis vom Web Interface zu finden.";
	}
	
	if ($for_output != "")
	{
		$output = str_replace('{content}', $for_output, $output);
		die($output);
	}
}

?>