<?PHP

require_once("include/formularfunctions.php");
require_once("include/botheaderfunctions.php");

function getTS3ServerInformations($class_db, $botid)
{
	if (!is_numeric($botid))
	{
		return;
	}
	
	checkTS3CacheTime($class_db);
	
	$resCacheTime = $class_db->db_query("SELECT object_id FROM jts3servermodwebui_ts3cache WHERE instances_id = ".$botid." AND cache_type = 'cache_time'");
	if (mysqli_num_rows($resCacheTime) == 1)
	{
		return;
	}
	
	$currentChannelGrpList = NULL;
	$currentServerGrpList = NULL;
	$currentChannelList = NULL;
	$currentIconList = NULL;
	
	$requestTS3DataSuccess = false;
	require_once("class/TS3Telnet.php");
	$telnet = new TS3Telnet($class_db, $botid);
	$result = $telnet->TSConnect();

	if ($result === true)
	{
		$result = $telnet->TSLogin();
		if (is_array($result) && $result['id'] == 0)
		{
			$result = $telnet->SelectServer();
			if (is_array($result) && $result['id'] == 0)
			{
				$currentChannelList = $telnet->GetList("channels");
				$currentServerGrpList = $telnet->GetList("servergrouplist");
				$currentChannelGrpList = $telnet->GetList("channelgrouplist");
				$currentIconList = $telnet->GetList("iconlist");
				$requestTS3DataSuccess = true;
			}
		}
	}

	$telnet->Disconnect();
	
	if (!$requestTS3DataSuccess)
		return;
	
	$class_db->db_query("INSERT INTO jts3servermodwebui_ts3cache (`instances_id`, `cache_type`, `object_id`) VALUES (".$botid.", '".$class_db->getRealEscapeString("cache_time")."', '".$class_db->getRealEscapeString(time())."')");
	
	if (isset($currentChannelList['response']))
	{
		$listSize = sizeof($currentChannelList['response']);
		for ($i = 0; $i < $listSize; $i++)
		{
			$class_db->db_query("INSERT INTO jts3servermodwebui_ts3cache (`instances_id`, `cache_type`, `object_id`, `object_type`, `object_name`) VALUES (".$botid.", '".$class_db->getRealEscapeString("channel")."', '".$class_db->getRealEscapeString($currentChannelList['response'][$i]['cid'])."', '".$class_db->getRealEscapeString($currentChannelList['response'][$i]['channel_flag_default'])."', '".$class_db->getRealEscapeString($currentChannelList['response'][$i]['channel_name'])."')");
		}
	}
	
	if (isset($currentServerGrpList['response']))
	{
		$listSize = sizeof($currentServerGrpList['response']);
		for ($i = 0; $i < $listSize; $i++)
		{
			$class_db->db_query("INSERT INTO jts3servermodwebui_ts3cache (`instances_id`, `cache_type`, `object_id`, `object_type`, `object_name`) VALUES (".$botid.", '".$class_db->getRealEscapeString("servergroup")."', '".$class_db->getRealEscapeString($currentServerGrpList['response'][$i]['sgid'])."', '".$class_db->getRealEscapeString($currentServerGrpList['response'][$i]['type'])."', '".$class_db->getRealEscapeString($currentServerGrpList['response'][$i]['name'])."')");
		}
	}
	
	if (isset($currentChannelGrpList['response']))
	{
		$listSize = sizeof($currentChannelGrpList['response']);
		for ($i = 0; $i < $listSize; $i++)
		{
			$class_db->db_query("INSERT INTO jts3servermodwebui_ts3cache (`instances_id`, `cache_type`, `object_id`, `object_type`, `object_name`) VALUES (".$botid.", '".$class_db->getRealEscapeString("channelgroup")."', '".$class_db->getRealEscapeString($currentChannelGrpList['response'][$i]['cgid'])."', '".$class_db->getRealEscapeString($currentChannelGrpList['response'][$i]['type'])."', '".$class_db->getRealEscapeString($currentChannelGrpList['response'][$i]['name'])."')");
		}
	}
	
	if (isset($currentIconList['response']))
	{
		$listSize = sizeof($currentIconList['response']);
		for ($i = 0; $i < $listSize; $i++)
		{
			$class_db->db_query("INSERT INTO jts3servermodwebui_ts3cache (`instances_id`, `cache_type`, `object_id`, `object_type`, `object_name`) VALUES (".$botid.", '".$class_db->getRealEscapeString("icons")."', '".$class_db->getRealEscapeString(substr($currentIconList['response'][$i]['name'], 5))."', '0', '".$class_db->getRealEscapeString($currentIconList['response'][$i]['name'])."')");
		}
	}
}

function checkTS3CacheTime($class_db)
{
	$resList = $class_db->db_query("SELECT instances_id FROM jts3servermodwebui_ts3cache WHERE cache_type = 'cache_time' AND object_id < ".(time() - (60*15)));
	while($row = mysqli_fetch_row($resList))
	{
		$class_db->db_query("DELETE FROM jts3servermodwebui_ts3cache WHERE instances_id = ".$row[0]);
	}
}

function deleteTS3Cache($class_db, $botid)
{
	if (!is_numeric($botid))
	{
		return;
	}
	
	$class_db->db_query("DELETE FROM jts3servermodwebui_ts3cache WHERE instances_id = ".$botid);
}

function getTS3CacheTimeHTML($class_db, $botid)
{
	if (!is_numeric($botid))
	{
		return;
	}
	
	checkTS3CacheTime($class_db);
	
	$resCacheTime = $class_db->db_query("SELECT object_id FROM jts3servermodwebui_ts3cache WHERE instances_id = ".$botid." AND cache_type = 'cache_time'");
	if (mysqli_num_rows($resCacheTime) == 1)
	{
		$cacheTime = mysqli_fetch_row($resCacheTime);
		
		global $translation;
		$ts3cachetmpl = implode(" ", file("templates/botmanager_ts3cache_info.tmpl"));
		$ts3cachetmpl = str_replace('{ts3cache_time}', $translation->getDate($cacheTime[0]), $ts3cachetmpl);
		$ts3cachetmpl = str_replace('{botID}', $botid, $ts3cachetmpl);
		return $ts3cachetmpl;
	}
	else
	{
		return "";
	}
}

function isInList($string, $search)
{
	if (!is_array($string)) $list = explode(",", $string);
	else $list = $string;
	
	foreach($list as $id)
	{
		if ($id == $search)
		{
			return true;
		}
	}
	
	return false;
}

function getChannelComboBoxDef($botid, $class_db, $name, $default, $multiple, $hidedefchannel = false, $firstEntryText = null, $showFirstEntry = true)
{
	if (!is_numeric($botid))
	{
		return;
	}
	
	global $translation;
	if ($firstEntryText == null)
	{
		$firstEntryText = "{webui_disablenochannel}";
	}

	$optionCount = 0;
	$channelOptions = "";
	$defaultChannelFound = false;
	
	$resList = $class_db->db_query("SELECT object_id, object_type, object_name FROM jts3servermodwebui_ts3cache WHERE cache_type = 'channel' AND instances_id = ".$botid);
	while($channel = mysqli_fetch_row($resList))
	{
		if ($hidedefchannel && $channel[1] == 1)
		{
			$defaultChannelFound = true;
			continue;
		}
		
		++$optionCount;
		
		if ($multiple)
		{
			$channelName = $channel[2];
			if (mb_strlen($channelName) > 30)
			{
				$channelName = mb_substr($channelName, 0, 27)."...";
			}
			
			if (isInList($default, $channel[0]))
			{
				$channelOptions = $channelOptions."<option value=\"".$channel[0]."\" title=\"".htmlentities($channel[2], ENT_QUOTES, "UTF-8")."\" selected>".htmlentities($channelName, ENT_QUOTES, "UTF-8")."</option>\n";
			}
			else
			{
				$channelOptions = $channelOptions."<option value=\"".$channel[0]."\" title=\"".htmlentities($channel[2], ENT_QUOTES, "UTF-8")."\">".htmlentities($channelName, ENT_QUOTES, "UTF-8")."</option>\n";
			}
		}
		else
		{
			if (isInList($default, $channel[0]))
			{
				$channelOptions = $channelOptions."<option value=\"".$channel[0]."\" selected>".htmlentities($channel[2], ENT_QUOTES, "UTF-8")."</option>\n";
			}
			else
			{
				$channelOptions = $channelOptions."<option value=\"".$channel[0]."\">".htmlentities($channel[2], ENT_QUOTES, "UTF-8")."</option>\n";
			}
		}
	}
	
	if ($defaultChannelFound && $channelOptions == "")
	{
		return "{webui_nootherchannels}";
	}
	else if ($channelOptions == "")
	{
		return str_replace('{permissionname}', "<b>b_virtualserver_channel_list</b>", "<p><font class=\"errormessage\">".$translation->getTranslation("webui_errorchannellist")."</font></p>");
	}
	
	if ($showFirstEntry) $channelOptions = "<option value=\"-1\"".(isInList($default, -1) ? " selected" : "").">".$firstEntryText."</option>\n".$channelOptions;
	
	if ($multiple)
	{
		$formChooser = "<select name=\"".$name."[]\" id=\"".$name."\" class=\"Select_Multiple\" size=\"".($optionCount < 8 ? $optionCount+1 : "8")."\" multiple>\n";
	}
	else
	{
		$formChooser = "<select name=\"".$name."\" id=\"".$name."\" class=\"Select_Single\" size=\"1\">\n";
	}
	
	return $formChooser.$channelOptions."\n</select>\n";
}

function getServerGroupComboBoxDef($botid, $class_db, $name, $default, $multiple, $showFirstEntry = true, $showQueryType = true, $customEntries = null)
{
	$optionCount = 0;
	$serverGroupOptions = "";
	global $currentServerGrpList, $translation;
	
	$resList = $class_db->db_query("SELECT object_id, object_type, object_name FROM jts3servermodwebui_ts3cache WHERE cache_type = 'servergroup' AND instances_id = ".$botid." ORDER BY object_name");
	while($servergrp = mysqli_fetch_row($resList))
	{
		if ($servergrp[1] == 0)
		{
			continue;
		}
		
		if (!$showQueryType && $servergrp[1] == 2)
		{
			continue;
		}
		
		++$optionCount;
		
		if ($multiple)
		{
			$groupName = $servergrp[2];
			if (mb_strlen($groupName) > 30)
			{
				$groupName = mb_substr($groupName, 0, 27)."...";
			}
			
			if (isInList($default, $servergrp[0]))
			{
				$serverGroupOptions = $serverGroupOptions."<option value=\"".$servergrp[0]."\" title=\"".htmlentities($servergrp[2], ENT_QUOTES, "UTF-8")."\" selected>".htmlentities($groupName, ENT_QUOTES, "UTF-8")."</option>\n";
			}
			else
			{
				$serverGroupOptions = $serverGroupOptions."<option value=\"".$servergrp[0]."\" title=\"".htmlentities($servergrp[2], ENT_QUOTES, "UTF-8")."\">".htmlentities($groupName, ENT_QUOTES, "UTF-8")."</option>\n";
			}
		}
		else
		{
			if (isInList($default, $servergrp[0]))
			{
				$serverGroupOptions = $serverGroupOptions."<option value=\"".$servergrp[0]."\" selected>".htmlentities($servergrp[2], ENT_QUOTES, "UTF-8")."</option>\n";
			}
			else
			{
				$serverGroupOptions = $serverGroupOptions."<option value=\"".$servergrp[0]."\">".htmlentities($servergrp[2], ENT_QUOTES, "UTF-8")."</option>\n";
			}
		}
	}
	
	if ($serverGroupOptions == "")
	{
		return str_replace('{permissionname}', "<b>b_virtualserver_servergroup_list</b>", "<p><font class=\"errormessage\">".$translation->getTranslation("webui_errorservergrouplist")."</font></p>");
	}
	
	if ($customEntries != null && is_array($customEntries))
	{
		foreach ($customEntries as $key => $value)
		{
			$serverGroupOptions = "<option value=\"".$key."\"".(isInList($default, $key) ? " selected" : "").">".$value."</option>\n".$serverGroupOptions;
		}
	}
	
	if ($showFirstEntry) $serverGroupOptions = "<option value=\"-1\"".(isInList($default, -1) ? " selected" : "").">{webui_disablenogroup}</option>\n".$serverGroupOptions;
	
	if ($multiple)
	{
		$formChooser = "<select name=\"".$name."[]\" id=\"".$name."\" class=\"Select_Multiple\" size=\"".($optionCount < 8 ? $optionCount+1 : "8")."\" multiple>\n";
	}
	else
	{
		$formChooser = "<select name=\"".$name."\" id=\"".$name."\" class=\"Select_Single\" size=\"1\">\n";
	}
	
	return $formChooser.$serverGroupOptions."\n</select>\n";
}

function getChannelGroupComboBoxDef($botid, $class_db, $name, $default, $multiple, $showFirstEntry = true)
{
	$optionCount = 0;
	$channelGroupOptions = "";
	global $currentChannelGrpList, $translation;
	
	$resList = $class_db->db_query("SELECT object_id, object_type, object_name FROM jts3servermodwebui_ts3cache WHERE cache_type = 'channelgroup' AND instances_id = ".$botid." ORDER BY object_name");
	while($channelgrp = mysqli_fetch_row($resList))
	{
		if ($channelgrp[1] == 0)
		{
			continue;
		}
		
		++$optionCount;
		
		if ($multiple)
		{
			$groupName = $channelgrp[2];
			if (mb_strlen($groupName) > 30)
			{
				$groupName = mb_substr($groupName, 0, 27)."...";
			}
			
			if (isInList($default, $channelgrp[0]))
			{
				$channelGroupOptions = $channelGroupOptions."<option value=\"".$channelgrp[0]."\" title=\"".htmlentities($channelgrp[2], ENT_QUOTES, "UTF-8")."\" selected>".htmlentities($groupName, ENT_QUOTES, "UTF-8")."</option>\n";
			}
			else
			{
				$channelGroupOptions = $channelGroupOptions."<option value=\"".$channelgrp[0]."\" title=\"".htmlentities($channelgrp[2], ENT_QUOTES, "UTF-8")."\">".htmlentities($groupName, ENT_QUOTES, "UTF-8")."</option>\n";
			}
		}
		else
		{
			if (isInList($default, $channelgrp[0]))
			{
				$channelGroupOptions = $channelGroupOptions."<option value=\"".$channelgrp[0]."\" selected>".htmlentities($channelgrp[2], ENT_QUOTES, "UTF-8")."</option>\n";
			}
			else
			{
				$channelGroupOptions = $channelGroupOptions."<option value=\"".$channelgrp[0]."\">".htmlentities($channelgrp[2], ENT_QUOTES, "UTF-8")."</option>\n";
			}
		}
	}
	
	if ($channelGroupOptions == "")
	{
		return str_replace('{permissionname}', "<b>b_virtualserver_channelgroup_list</b>", "<p><font class=\"errormessage\">".$translation->getTranslation("webui_errorchannelgrouplist")."</font></p>");
	}
	
	if ($showFirstEntry) $channelGroupOptions = "<option value=\"-1\"".(isInList($default, -1) ? " selected" : "").">{webui_disablenogroup}</option>\n".$channelGroupOptions;
	
	if ($multiple)
	{
		$formChooser = "<select name=\"".$name."[]\" id=\"".$name."\" class=\"Select_Multiple\" size=\"".($optionCount < 8 ? $optionCount+1 : "8")."\" multiple>\n";
	}
	else
	{
		$formChooser = "<select name=\"".$name."\" id=\"".$name."\" class=\"Select_Single\" size=\"1\">\n";
	}
	
	return $formChooser.$channelGroupOptions."\n</select>\n";
}

function getIconsComboBoxDef($botid, $class_db, $name, $default, $multiple, $showFirstEntry = true)
{
	$optionCount = 0;
	$iconOptions = "";
	global $currentChannelGrpList, $translation;
	
	$resList = $class_db->db_query("SELECT object_id, object_type, object_name FROM jts3servermodwebui_ts3cache WHERE cache_type = 'icons' AND instances_id = ".$botid." ORDER BY object_name");
	while($iconlist = mysqli_fetch_row($resList))
	{
		++$optionCount;

		if (isInList($default, $iconlist[0]))
		{
			$iconOptions = $iconOptions."<option value=\"".$iconlist[0]."\" selected>".htmlentities($iconlist[2], ENT_QUOTES, "UTF-8")."</option>\n";
		}
		else
		{
			$iconOptions = $iconOptions."<option value=\"".$iconlist[0]."\">".htmlentities($iconlist[2], ENT_QUOTES, "UTF-8")."</option>\n";
		}
	}
	
	if ($iconOptions == "")
	{
		return getTextInput($name, $default, 18, 30);
	}
	
	if ($showFirstEntry) $iconOptions = "<option value=\"-1\"".(isInList($default, -1) ? " selected" : "").">{webui_disablenoicon}</option>\n".$iconOptions;
	
	if ($multiple)
	{
		$formChooser = "<select name=\"".$name."[]\" id=\"".$name."\" class=\"Select_Multiple\" size=\"".($optionCount < 8 ? $optionCount+1 : "8")."\" multiple>\n";
	}
	else
	{
		$formChooser = "<select name=\"".$name."\" id=\"".$name."\" class=\"Select_Single\" size=\"1\">\n";
	}
	
	return $formChooser.$iconOptions."\n</select>\n";
}

function getFunctionComboBoxDef($name, $default, $functionclass, $configKey, $options)
{
	$formChooser = "<select name=\"".$name."\" id=\"".$name."\" size=\"1\" class=\"Select_Single\">\n";
	
	$list = explode(",", $options);
	foreach($list as $entry)
	{
		$textOption = "webui_".$functionclass.$configKey."_".$entry;
		if ((substr($configKey, -13) == "_message_mode" || $configKey == "_messagenotified_mode") && $entry == "poke") $textOption = "webui_pokeclient";
		if ((substr($configKey, -13) == "_message_mode" || $configKey == "_messagenotified_mode") && $entry == "chat") $textOption = "webui_chatmessage";
		if ((substr($configKey, -13) == "_message_mode" || $configKey == "_messagenotified_mode") && $entry == "none") $textOption = "webui_nomessage";
		if (($configKey == "_parentchannel_list_mode" || $configKey == "_channel_list_mode" || $configKey == "_group_list_mode" || $configKey == "_channelgroup_list_mode" || $configKey == "_clientcountry_list_mode") && $entry == "ignore") $textOption = "webui_ignoreselected";
		if (($configKey == "_parentchannel_list_mode" || $configKey == "_channel_list_mode" || $configKey == "_group_list_mode" || $configKey == "_channelgroup_list_mode" || $configKey == "_clientcountry_list_mode") && $entry == "only") $textOption = "webui_checkselected";
		if ($entry == "yes") $textOption = "webui_yes";
		if ($entry == "no") $textOption = "webui_no";
		if ($configKey == "_action" && $entry == "move") $textOption = "webui_move";
		if ($configKey == "_action" && $entry == "kick") $textOption = "webui_kick";
		
		$formChooser = $formChooser."<option value=\"".$entry."\"".($default == $entry ? " selected" : "").">{".$textOption."}</option>\n";
	}
	
	return $formChooser."\n</select>\n";
}

function getFunctionClass($botid, $class_db, $prefix)
{
	if (!is_numeric($botid))
		return false;
	
	if ($prefix == null || $prefix == "")
		return false;

	$botFunctions = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions'");
	$functionList = explode(",", $botFunctions[0]);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			if ($prefix == trim($part[1]))
				return trim($part[0]);
		}
	}
	
	$botFunctions = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions_disabled'");
	$functionList = explode(",", $botFunctions[0]);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			if ($prefix == trim($part[1]))
				return trim($part[0]);
		}
	}
	
	return false;
}

function getBotFunctionConfigPage($botid, $class_db, $functionclass, $prefix)
{
	if (is_numeric($botid))
	{
		if ($functionclass == null || $functionclass == "")
		{
			$functionclass = getFunctionClass($botid, $class_db, $prefix);
			if ($functionclass === false)
				return getBotManagerMainpage($class_db, $botid, false, "{webui_functiondoesnotexist}");
		}
		$functionclass = strtolower($functionclass);
		
		global $translation;
		getTS3ServerInformations($class_db, $botid);
		
		$resList = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey LIKE \"".$class_db->getRealEscapeString($prefix)."_%\"");
		
		$configValues = array();
		
		while($row = mysqli_fetch_row($resList))
		{
			$configValues[$row[0]] = $row[1];
		}
		
		$botmanagertmpl = implode(" ", file("templates/botmanager_editfunction.tmpl"));
		$botmanagertmpl = str_replace('{bot_header}', getBotHeader($class_db, $botid), $botmanagertmpl);
		$botmanagertmpl = str_replace('{botID}', $botid, $botmanagertmpl);
		
		$botmanagerconfigentrytmpl = implode(" ", file("templates/botmanager_editfunction_entry.tmpl"));
		$botmanagercontent = "";
		
		$botmanagerspecialconfigtmpl = "";
		$additionalIncludePath = "include/functions/".$functionclass.".php";
		if (file_exists($additionalIncludePath))
		{
			include_once($additionalIncludePath);
			$botmanagerspecialconfigtmpl = str_replace('{setting}', editSpecialFunctionConfig($botid, $class_db, $prefix), $botmanagerconfigentrytmpl);
			$botmanagerspecialconfigtmpl = str_replace('{configkey}', "_specialconfig", $botmanagerspecialconfigtmpl);
			$botmanagerspecialconfigtmpl = str_replace('{tablerowclass}', "", $botmanagerspecialconfigtmpl);
		}
		
		$resList = $class_db->db_query("SELECT typename, configkey, options, defaultValue, groupnext FROM jts3servermodwebui_functionpage, jts3servermodwebui_botfunction WHERE botfunction_id = id AND classname = \"".$class_db->getRealEscapeString($functionclass)."\" ORDER BY sortnr ASC");
		$rowCount = mysqli_num_rows($resList);
		
		if ($botmanagerspecialconfigtmpl != "")
			++$rowCount;
				
		while($row = mysqli_fetch_row($resList))
		{
			--$rowCount;
			
			if ($row[0] == "servergroup" && ($functionclass == "idlecheck" || $functionclass == "idlecheckold") && $row[1] == "_group_id")
			{
				$customEntries = array();
				$customEntries[-9] = "{webui_".$functionclass."_group_id_createright}";
				$customEntries[-6] = "{webui_".$functionclass."_group_id_createleft}";
				$botmanagercontent .= str_replace('{setting}', getServerGroupComboBoxDef($botid, $class_db, $prefix.$row[1], (isset($_POST[$prefix.$row[1]]) ? $_POST[$prefix.$row[1]] : (isset($configValues[$prefix.$row[1]]) ? $configValues[$prefix.$row[1]] : $row[3])), isInList($row[2], "multiple"), isInList($row[2], "showfirstentry"), isInList($row[2], "showquerytype"), $customEntries), $botmanagerconfigentrytmpl);
			}
			else if ($row[0] == "channel")
			{
				$botmanagercontent .= str_replace('{setting}', getChannelComboBoxDef($botid, $class_db, $prefix.$row[1], (isset($_POST[$prefix.$row[1]]) ? $_POST[$prefix.$row[1]] : (isset($configValues[$prefix.$row[1]]) ? $configValues[$prefix.$row[1]] : $row[3])), isInList($row[2], "multiple"), isInList($row[2], "hidedefaultchannel"), null, isInList($row[2], "showfirstentry")), $botmanagerconfigentrytmpl);
			}
			else if ($row[0] == "servergroup")
			{
				$botmanagercontent .= str_replace('{setting}', getServerGroupComboBoxDef($botid, $class_db, $prefix.$row[1], (isset($_POST[$prefix.$row[1]]) ? $_POST[$prefix.$row[1]] : (isset($configValues[$prefix.$row[1]]) ? $configValues[$prefix.$row[1]] : $row[3])), isInList($row[2], "multiple"), isInList($row[2], "showfirstentry"), isInList($row[2], "showquerytype")), $botmanagerconfigentrytmpl);
			}
			else if ($row[0] == "channelgroup")
			{
				$botmanagercontent .= str_replace('{setting}', getChannelGroupComboBoxDef($botid, $class_db, $prefix.$row[1], (isset($_POST[$prefix.$row[1]]) ? $_POST[$prefix.$row[1]] : (isset($configValues[$prefix.$row[1]]) ? $configValues[$prefix.$row[1]] : $row[3])), isInList($row[2], "multiple"), isInList($row[2], "showfirstentry")), $botmanagerconfigentrytmpl);
			}
			else if ($row[0] == "icon")
			{
				$botmanagercontent .= str_replace('{setting}', getIconsComboBoxDef($botid, $class_db, $prefix.$row[1], (isset($_POST[$prefix.$row[1]]) ? $_POST[$prefix.$row[1]] : (isset($configValues[$prefix.$row[1]]) ? $configValues[$prefix.$row[1]] : $row[3])), isInList($row[2], "multiple"), isInList($row[2], "showfirstentry")), $botmanagerconfigentrytmpl);
			}
			else if ($row[0] == "select")
			{
				$botmanagercontent .= str_replace('{setting}', getFunctionComboBoxDef($prefix.$row[1], (isset($_POST[$prefix.$row[1]]) ? $_POST[$prefix.$row[1]] : (isset($configValues[$prefix.$row[1]]) ? $configValues[$prefix.$row[1]] : $row[3])), $functionclass, $row[1], $row[2]), $botmanagerconfigentrytmpl);
			}
			else if ($row[0] == "number")
			{
				$numberRange = explode(",", $row[2]);
				$botmanagercontent .= str_replace('{setting}', getTextInput($prefix.$row[1], (isset($_POST[$prefix.$row[1]]) ? $_POST[$prefix.$row[1]] : (isset($configValues[$prefix.$row[1]]) ? $configValues[$prefix.$row[1]] : $row[3])), 18, 30, true, $numberRange[0], $numberRange[1]), $botmanagerconfigentrytmpl);
			}
			else if ($row[0] == "multilinetext")
			{
				$botmanagercontent .= str_replace('{setting}', getMultilineTextInput($prefix.$row[1], (isset($_POST[$prefix.$row[1]]) ? $_POST[$prefix.$row[1]] : (isset($configValues[$prefix.$row[1]]) ? $configValues[$prefix.$row[1]] : $row[3])), 3, 60), $botmanagerconfigentrytmpl);
				$botmanagercontent = str_replace('{tablerowclass}', "", $botmanagercontent);
			}
			else if ($row[0] == "text")
			{
				$botmanagercontent .= str_replace('{setting}', getTextInput($prefix.$row[1], htmlentities((isset($_POST[$prefix.$row[1]]) ? $_POST[$prefix.$row[1]] : (isset($configValues[$prefix.$row[1]]) ? $configValues[$prefix.$row[1]] : $row[3])), ENT_QUOTES, "UTF-8"), 18, 30), $botmanagerconfigentrytmpl);
			}
			else if ($row[0] == "longtext")
			{
				$botmanagercontent .= str_replace('{setting}', getTextInput($prefix.$row[1], htmlentities((isset($_POST[$prefix.$row[1]]) ? $_POST[$prefix.$row[1]] : (isset($configValues[$prefix.$row[1]]) ? $configValues[$prefix.$row[1]] : $row[3])), ENT_QUOTES, "UTF-8"), 100, 230), $botmanagerconfigentrytmpl);
			}
			else if ($row[0] == "platformselect")
			{
				$botmanagercontent .= str_replace('{setting}', getPlatformListDef($prefix.$row[1], (isset($_POST[$prefix.$row[1]]) ? $_POST[$prefix.$row[1]] : (isset($configValues[$prefix.$row[1]]) ? $configValues[$prefix.$row[1]] : $row[3]))), $botmanagerconfigentrytmpl);
			}
			else if ($row[0] == "fieldset")
			{
				$botmanagercontent .= "</fieldset>\n<fieldset><legend>{webui_".$functionclass.$row[2]."}</legend>\n";
			}
			
			$botmanagercontent = str_replace('{configkey}', $row[1], $botmanagercontent);
			$botmanagercontent = str_replace('{tablerowclass}', ($row[4] ? "" : ($rowCount > 0 ? " borderline" : "")), $botmanagercontent);
		}
		
		$botmanagercontent .= $botmanagerspecialconfigtmpl;
		
		$botmanagertmpl = str_replace('{settingstablecontent}', $botmanagercontent, $botmanagertmpl);
		$botmanagertmpl = str_replace('{functionclass}', $functionclass, $botmanagertmpl);
		$botmanagertmpl = str_replace('{functionprefix}', $prefix, $botmanagertmpl);
		$botmanagertmpl = $translation->replaceTranslationsForPage($botmanagertmpl, $functionclass, true, true);

		return $botmanagertmpl;
	}
	
	return "Error: Call of getBotFunctionConfigPage() with invalid arguments!";
}

function getPlatformListDef($name, $default)
{
	$defString = "";
	if (is_array($default))
		$defString = implode("", $default);
	else
		$defString = $default;
	
	$formChooser = "<select name=\"".$name."[]\" id=\"".$name."\" size=\"6\" class=\"textinput\" multiple>\n";
	$formChooser = $formChooser."<option value=\"\"".($defString == "" ? " selected" : "").">{webui_platform_list_all}</option>\n";
	
	$platformList = array();
	$platformList[0] = "Android";
	$platformList[1] = "iOS";
	$platformList[2] = "Linux";
	$platformList[3] = "Mac";
	$platformList[4] = "Windows";
	
	$arrayLen = count($platformList);
	for ($i = 0; $i < $arrayLen; $i++)
	{
		$formChooser = $formChooser."<option value=\"".$platformList[$i]."\"".(isInList($default, $platformList[$i]) ? " selected" : "").">".$platformList[$i]."</option>\n";
	}
	
	return $formChooser."\n</select>\n";
}

function getLogLevelComboBoxDef($name, $default)
{
	$formChooser = "<select name=\"".$name."\" id=\"".$name."\" size=\"1\" class=\"textinput\">\n";
	
	$logLevel = array();
	$logLevel[0] = "{webui_bot_log_level_debug}";
	$logLevel[1] = "{webui_bot_log_level_info}";
	$logLevel[2] = "{webui_bot_log_level_warning}";
	$logLevel[3] = "{webui_bot_log_level_error}";
	
	$arrayLen = count($logLevel);
	for ($i = 0; $i < $arrayLen; $i++)
	{
		$formChooser = $formChooser."<option value=\"".$i."\"".($i == $default ? " selected" : "").">".$logLevel[$i]."</option>\n";
	}
	
	return $formChooser."\n</select>\n";
}

function getBotGeneralSettings($botid, $class_db)
{
	if (!is_numeric($botid))
	{
		return "Error: Call of getBotGeneralSettings() with invalid arguments!";
	}
	
	global $translation;
	getTS3ServerInformations($class_db, $botid);
	
	$botCSVLogMode = $class_db->getQuery("SELECT csvlogmode FROM jts3servermod_instances WHERE id = ".$botid);
	
	$resList = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid
		." AND configkey IN ('bot_channel_id', 'bot_check_interval', 'bot_clientdblist_cache', 'bot_global_message_vars', 'bot_server_query_name', 'bot_server_query_name_2', 'bot_date_pattern', 'bot_timezone', 'bot_connect_forever', 'bot_admin_list', 'bot_lightadmingroup_list', 'bot_log_level')");
	
	$configValues = array();
	
	while($row = mysqli_fetch_row($resList))
	{
		$configValues[$row[0]] = $row[1];
	}
	
	$botmanagertmpl = implode(" ", file("templates/botmanager_editgeneralsettings.tmpl"));
	$botmanagertmpl = str_replace('{bot_header}', getBotHeader($class_db, $botid), $botmanagertmpl);
	$botmanagertmpl = str_replace('{botID}', $botid, $botmanagertmpl);
	
	$botmanagertmpl = str_replace('{bot_channel_id}', getChannelComboBoxDef($botid, $class_db, "bot_channel_id", (isset($_POST['bot_channel_id']) ? $_POST['bot_channel_id'] : (isset($configValues['bot_channel_id']) ? $configValues['bot_channel_id'] : -1)), false, true, "{webui_defaultchannel}"), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_check_interval}', getTextInput("bot_check_interval", (isset($_POST['bot_check_interval']) ? $_POST['bot_check_interval'] : (isset($configValues['bot_check_interval']) ? $configValues['bot_check_interval'] : "1")), 18, 30, true, 1, 20), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_clientdblist_cache}', getYesNoComboBoxDef("bot_clientdblist_cache", (isset($_POST['bot_clientdblist_cache']) ? $_POST['bot_clientdblist_cache'] : (isset($configValues['bot_clientdblist_cache']) ? $configValues['bot_clientdblist_cache'] : 0))), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_global_message_vars}', getYesNoComboBoxDef("bot_global_message_vars", (isset($_POST['bot_global_message_vars']) ? $_POST['bot_global_message_vars'] : (isset($configValues['bot_global_message_vars']) ? $configValues['bot_global_message_vars'] : 0))), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_server_query_name}', getTextInput("bot_server_query_name", htmlspecialchars((isset($_POST['bot_server_query_name']) ? $_POST['bot_server_query_name'] : (isset($configValues['bot_server_query_name']) ? $configValues['bot_server_query_name'] : "TS3 Bot")), ENT_QUOTES, "UTF-8"), 18, 30), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_server_query_name_2}', getTextInput("bot_server_query_name_2", htmlspecialchars((isset($_POST['bot_server_query_name_2']) ? $_POST['bot_server_query_name_2'] : (isset($configValues['bot_server_query_name_2']) ? $configValues['bot_server_query_name_2'] : "TS Bot")), ENT_QUOTES, "UTF-8"), 18, 30), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_date_pattern}', getTextInput("bot_date_pattern", htmlspecialchars((isset($_POST['bot_date_pattern']) ? $_POST['bot_date_pattern'] : (isset($configValues['bot_date_pattern']) ? $configValues['bot_date_pattern'] : "dd.MM.yyyy HH:mm:ss")), ENT_QUOTES, "UTF-8"), 18, 30), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_timezone}', getTimezoneComboBoxDef("bot_timezone", (isset($_POST['bot_timezone']) ? $_POST['bot_timezone'] : (isset($configValues['bot_timezone']) ? $configValues['bot_timezone'] : "")), true), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_connect_forever}', getYesNoComboBoxDef("bot_connect_forever", (isset($_POST['bot_connect_forever']) ? $_POST['bot_connect_forever'] : (isset($configValues['bot_connect_forever']) ? $configValues['bot_connect_forever'] : 0))), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_admin_list}', getTextInput("bot_admin_list", (isset($_POST['bot_admin_list']) ? $_POST['bot_admin_list'] : (isset($configValues['bot_admin_list']) ? $configValues['bot_admin_list'] : "")), 100, 230), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_lightadmingroup_list}', getServerGroupComboBoxDef($botid, $class_db, "bot_lightadmingroup_list", (isset($_POST["bot_lightadmingroup_list"]) ? $_POST["bot_lightadmingroup_list"] : (isset($configValues["bot_lightadmingroup_list"]) ? $configValues["bot_lightadmingroup_list"] : -1)), true, true, false), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_instance_csvloginlog_mode}', getYesNoComboBoxDef("bot_instance_csvloginlog_mode", (isset($_POST['bot_instance_csvloginlog_mode']) ? $_POST['bot_instance_csvloginlog_mode'] : $botCSVLogMode[0]), 2, 0), $botmanagertmpl);
	$botmanagertmpl = str_replace('{bot_log_level}', getLogLevelComboBoxDef("bot_log_level", (isset($_POST['bot_log_level']) ? $_POST['bot_log_level'] : (isset($configValues['bot_log_level']) ? $configValues['bot_log_level'] : 1))), $botmanagertmpl);
	
	$botmanagertmpl = $translation->replaceTranslationsForPage($botmanagertmpl, "botmanager_editgeneralsettings", true, true);
	
	return $botmanagertmpl;
}

function getBotSlotCheckerSettings($botid, $class_db)
{
	if (!is_numeric($botid))
	{
		return "Error: Call of getBotSlotCheckerSettings() with invalid arguments!";
	}
	
	global $translation;
	
	$resList = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey LIKE \"slotchecker_%\"");
	
	$configValues = array();
	
	while($row = mysqli_fetch_row($resList))
	{
		$configValues[$row[0]] = $row[1];
	}
	
	$botmanagertmpl = implode(" ", file("templates/botmanager_editslotcheckersettings.tmpl"));
	$botmanagertmpl = str_replace('{bot_header}', getBotHeader($class_db, $botid), $botmanagertmpl);
	$botmanagertmpl = str_replace('{botID}', $botid, $botmanagertmpl);
	
	$botmanagertmpl = str_replace('{slotchecker_check_interval}', getTextInput("slotchecker_check_interval", (isset($_POST['slotchecker_check_interval']) ? $_POST['slotchecker_check_interval'] : (isset($configValues['slotchecker_check_interval']) ? $configValues['slotchecker_check_interval'] : "-1")), 18, 30, true, -1, 600), $botmanagertmpl);
	$botmanagertmpl = str_replace('{slotchecker_skip_action_interval}', getTextInput("slotchecker_skip_action_interval", (isset($_POST['slotchecker_skip_action_interval']) ? $_POST['slotchecker_skip_action_interval'] : (isset($configValues['slotchecker_skip_action_interval']) ? $configValues['slotchecker_skip_action_interval'] : "1")), 18, 30, true, 0, 60), $botmanagertmpl);
	$botmanagertmpl = str_replace('{slotchecker_min_slotdistance}', getTextInput("slotchecker_min_slotdistance", (isset($_POST['slotchecker_min_slotdistance']) ? $_POST['slotchecker_min_slotdistance'] : (isset($configValues['slotchecker_min_slotdistance']) ? $configValues['slotchecker_min_slotdistance'] : "")), 18, 30, true, 1, 9999999), $botmanagertmpl);
	$botmanagertmpl = str_replace('{slotchecker_max_slotdistance}', getTextInput("slotchecker_max_slotdistance", (isset($_POST['slotchecker_max_slotdistance']) ? $_POST['slotchecker_max_slotdistance'] : (isset($configValues['slotchecker_max_slotdistance']) ? $configValues['slotchecker_max_slotdistance'] : "")), 18, 30, true, 1, 9999999), $botmanagertmpl);
	$botmanagertmpl = str_replace('{slotchecker_min_slotcount}', getTextInput("slotchecker_min_slotcount", (isset($_POST['slotchecker_min_slotcount']) ? $_POST['slotchecker_min_slotcount'] : (isset($configValues['slotchecker_min_slotcount']) ? $configValues['slotchecker_min_slotcount'] : "")), 18, 30, true, 0, 9999999), $botmanagertmpl);
	$botmanagertmpl = str_replace('{slotchecker_max_slotcount}', getTextInput("slotchecker_max_slotcount", (isset($_POST['slotchecker_max_slotcount']) ? $_POST['slotchecker_max_slotcount'] : (isset($configValues['slotchecker_max_slotcount']) ? $configValues['slotchecker_max_slotcount'] : "")), 18, 30, true, 0, 9999999), $botmanagertmpl);
	$botmanagertmpl = str_replace('{slotchecker_url}', getTextInput("slotchecker_url", htmlentities((isset($_POST['slotchecker_url']) ? $_POST['slotchecker_url'] : (isset($configValues['slotchecker_url']) ? $configValues['slotchecker_url'] : "http://")), ENT_QUOTES, "UTF-8"), 100, 230), $botmanagertmpl);
	$botmanagertmpl = str_replace('{slotchecker_url_confirm}', getTextInput("slotchecker_url_confirm", htmlentities((isset($_POST['slotchecker_url_confirm']) ? $_POST['slotchecker_url_confirm'] : (isset($configValues['slotchecker_url_confirm']) ? $configValues['slotchecker_url_confirm'] : "")), ENT_QUOTES, "UTF-8"), 100, 230), $botmanagertmpl);
	
	$botmanagertmpl = $translation->replaceTranslationsForPage($botmanagertmpl, "SlotChecker", true, true);
	
	return $botmanagertmpl;
}

function getRemoveFunctionPage($botid, $class_db, $functionclass, $prefix)
{
	if (!is_numeric($botid))
	{
		return "Error: Call of getRemoveFunctionPage() with invalid arguments!";
	}
	
	global $translation;
	$botmanagertmpl = implode(" ", file("templates/botmanager_removefunctions.tmpl"));
	$botmanagertmpl = str_replace('{bot_header}', getBotHeader($class_db, $botid), $botmanagertmpl);
	$botmanagertmpl = str_replace('{botID}', $botid, $botmanagertmpl);
	$botmanagertmpl = str_replace('{functionclass}', $functionclass, $botmanagertmpl);
	$botmanagertmpl = str_replace('{functionprefix}', $prefix, $botmanagertmpl);
	
	$botmanagertmpl = $translation->replaceTranslationsForPage($botmanagertmpl, "formularfunctions", true, true);
		
	return $botmanagertmpl;
}

function getRenameFunctionPage($botid, $class_db, $functionclass, $prefix_old)
{
	if (!is_numeric($botid))
	{
		return "Error: Call of getRenameFunctionPage() with invalid arguments!";
	}
	
	global $translation;
	$botmanagertmpl = implode(" ", file("templates/botmanager_renamefunctions.tmpl"));
	$botmanagertmpl = str_replace('{bot_header}', getBotHeader($class_db, $botid), $botmanagertmpl);
	$botmanagertmpl = str_replace('{botID}', $botid, $botmanagertmpl);
	$botmanagertmpl = str_replace('{webui_renamefunction_info}', $translation->getTranslation("webui_renamefunction_info", TRUE), $botmanagertmpl);
	$botmanagertmpl = str_replace('{functionclass}', $functionclass, $botmanagertmpl);
	$botmanagertmpl = str_replace('{function_prefix_old}', $prefix_old, $botmanagertmpl);
	$botmanagertmpl = str_replace('{function_prefix_new}', getTextInput("function_prefix_new", (isset($_POST['function_prefix_new']) ? $_POST['function_prefix_new'] : $prefix_old), -1, 20), $botmanagertmpl);
	
	$botmanagertmpl = $translation->replaceTranslationsForPage($botmanagertmpl, "formularfunctions", true, true);
	$botmanagertmpl = str_replace('{webui_renamebot_newname}', $translation->getTranslation("webui_renamebot_newname"), $botmanagertmpl);
		
	return $botmanagertmpl;
}

function saveValue($botid, $class_db, $configkey, $configvalue)
{
	if (is_numeric($botid))
	{
		$resCheckValue = $class_db->db_query("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = '".$class_db->getRealEscapeString($configkey)."'");
		
		if (is_array($configvalue))
		{
			$configvalue = implode(",", $configvalue);
		}
		
		$configvalue = str_replace("\r", "", $configvalue);
		
		if (mysqli_num_rows($resCheckValue) == 1)
		{
			$checkValue = mysqli_fetch_array($resCheckValue);
			if ($checkValue[0] != $configvalue)
			{
				$class_db->db_query("UPDATE jts3servermod_instanceconfig SET configvalue = '".$class_db->getRealEscapeString($configvalue)."' WHERE instance_id = ".$botid." AND configkey = '".$class_db->getRealEscapeString($configkey)."'");
			}
		}
		else
		{
			$class_db->db_query("INSERT INTO jts3servermod_instanceconfig (`instance_id`, `configkey`, `configvalue`) VALUES (".$botid.", '".$class_db->getRealEscapeString($configkey)."', '".$class_db->getRealEscapeString($configvalue)."')");
		}
		
		return true;
	}
	else
	{
		return false;
	}
}

function getFunctionChooser($class_db)
{
	$formChooser = "<select name=\"function_class\" size=\"1\" class=\"Select_Single\">\n";
	$formChooser = $formChooser."<option value=\"\">{webui_choosefunction}</option>\n";
	
	$resList = $class_db->db_query("SELECT classname FROM jts3servermodwebui_botfunction WHERE hidden = false ORDER BY classname");
	while($row = mysqli_fetch_row($resList))
	{
		$formChooser = $formChooser."<option value=\"".$row[0]."\" title=\"{webui_".strtolower($row[0])."_description}\">{webui_".strtolower($row[0])."_title}</option>\n";
	}
	
	return $formChooser."\n</select>\n";
}

function isFunctionEnabled($botid, $class_db, $functionPrefix)
{
	if (!is_numeric($botid))
	{
		return false;
	}

	$botFunctions = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions'");
	$functionList = explode(",", $botFunctions[0]);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			if ($part[1] == $functionPrefix) return true;
		}
	}
	
	return false;
}

function getFunctionList($botid, $class_db)
{
	if (!is_numeric($botid))
	{
		return "";
	}

	$rethtml = "";
	$activatedrowtmpl = implode(" ", file("templates/botmanager_functionlist_row.tmpl"));
	$disabledrowtmpl = implode(" ", file("templates/botmanager_functionlist_row_disabled.tmpl"));
	
	$botFunctions = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions'");
	$functionList = explode(",", $botFunctions[0]);
	natcasesort($functionList);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			$rethtml .= $activatedrowtmpl;
			$rethtml = str_replace('{function_class}', strtolower(trim($part[0])), $rethtml);
			$rethtml = str_replace('{function_prefix}', trim($part[1]), $rethtml);
		}
	}
	
	$botFunctions = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions_disabled'");
	$functionList = explode(",", $botFunctions[0]);
	natcasesort($functionList);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			$rethtml .= $disabledrowtmpl;
			$rethtml = str_replace('{function_class}', strtolower(trim($part[0])), $rethtml);
			$rethtml = str_replace('{function_prefix}', trim($part[1]), $rethtml);
		}
	}
	
	return $rethtml;
}

function addFunction($botid, $class_db, $functionClass, $functionPrefix)
{
	if (!is_numeric($botid))
	{
		return "Error: Call of addFunction() with invalid arguments!";
	}
	
	if (!preg_match("@^[a-z0-9\\_\\-]+$@is", $functionPrefix))
	{
		return "{webui_addfunction_invalidname}";
	}
	
	if ($functionClass == "")
	{
		return "{webui_addfunction_invalidfunction}";
	}

	$classAlreadyInUse = false;
	$uniqueName = true;
	$botFunctions = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions'");
	$functionList = explode(",", $botFunctions[0]);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			if ($part[0] == $functionClass)
			{
				$classAlreadyInUse = true;
			}
			if ($part[1] == $functionPrefix)
			{
				$uniqueName = false;
			}
		}
	}
	
	if (!$uniqueName)
	{
		return "{webui_addfunction_nouniquename}";
	}
	
	$botFunctionsDisabled = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions_disabled'");
	$functionList = explode(",", $botFunctionsDisabled[0]);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			if ($part[0] == $functionClass)
			{
				$classAlreadyInUse = true;
			}
			if ($part[1] == $functionPrefix)
			{
				$uniqueName = false;
			}
		}
	}
	
	if (!$uniqueName)
	{
		return "{webui_addfunction_nouniquename}";
	}
	
	$checkMultipleUse = $class_db->getQuery("SELECT multiple_use FROM jts3servermodwebui_botfunction WHERE classname = '".$class_db->getRealEscapeString($functionClass)."'");
	if ($classAlreadyInUse && $checkMultipleUse[0] == 0)
	{
		return "{webui_addfunction_nomultipleuseallowed}";
	}
	
	$botFunctionsConfig = $botFunctionsDisabled[0];
	if (strlen($botFunctionsConfig) < 3)
	{
		$botFunctionsConfig = $functionClass.":".$functionPrefix;
	}
	else
	{
		$botFunctionsConfig .= ",".$functionClass.":".$functionPrefix;
	}
	
	saveValue($botid, $class_db, 'bot_functions_disabled', $botFunctionsConfig);
	
	return "{webui_addfunction_successful}: ".$functionClass." / ".$functionPrefix."<br><a href=\"index.php?page=botmanager&amp;mode=editBotFunction&amp;function_class=".strtolower($functionClass)."&amp;function_prefix=".$functionPrefix."&amp;botID=".$botid."\">{webui_addfunction_configure} <img src=\"images/wrench.png\" border=\"0\" alt=\"{webui_botsettings}\" style=\"vertical-align:middle;\"></a>";
}

function disableFunction($botid, $class_db, $functionPrefix, $botStatus, $botTelnet)
{
	if (!is_numeric($botid))
	{
		return "Error: Call of disableFunction() with invalid arguments!";
	}

	$botFunctionsDisabled = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions_disabled'");
	$newBotFunctionsDisabledLine = $botFunctionsDisabled[0];
	
	$newBotFunctionsLine = "";
	$functionClass = "";
	$botFunctions = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions'");
	$functionList = explode(",", $botFunctions[0]);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			if ($part[1] == $functionPrefix)
			{
				$functionClass = $part[0];
				if (strlen($newBotFunctionsDisabledLine) < 3)
				{
					$newBotFunctionsDisabledLine = $part[0].":".$part[1];
				}
				else
				{
					$newBotFunctionsDisabledLine .= ",".$part[0].":".$part[1];
				}
			}
			else
			{
				if (strlen($newBotFunctionsLine) < 3)
				{
					$newBotFunctionsLine = $part[0].":".$part[1];
				}
				else
				{
					$newBotFunctionsLine .= ",".$part[0].":".$part[1];
				}
			}
		}
	}
	
	saveValue($botid, $class_db, 'bot_functions', $newBotFunctionsLine);
	saveValue($botid, $class_db, 'bot_functions_disabled', $newBotFunctionsDisabledLine);
	
	$status = true;
	if ($botStatus == 1)
	{
		$serverInfo = getBotInfo($class_db, $botid);
		$status = $botTelnet->disableFunction($serverInfo[0], $functionPrefix);
	}
	
	return "{webui_disablefunction_successful}: ".$functionClass." / ".$functionPrefix.($status ? "" : "{botreload_info}");
}

function activateFunction($botid, $class_db, $functionPrefix, $botStatus, $botTelnet)
{
	if (!is_numeric($botid))
	{
		return "Error: Call of activateFunction() with invalid arguments!";
	}

	$botFunctions = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions'");
	$newBotFunctionsLine = $botFunctions[0];
	
	$newBotFunctionsDisabledLine = "";
	$functionClass = "";
	$botFunctionsDisabled = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions_disabled'");
	$functionList = explode(",", $botFunctionsDisabled[0]);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			if ($part[1] == $functionPrefix)
			{
				$functionClass = $part[0];
				if (strlen($newBotFunctionsLine) < 3)
				{
					$newBotFunctionsLine = $part[0].":".$part[1];
				}
				else
				{
					$newBotFunctionsLine .= ",".$part[0].":".$part[1];
				}
			}
			else
			{
				if (strlen($newBotFunctionsDisabledLine) < 3)
				{
					$newBotFunctionsDisabledLine = $part[0].":".$part[1];
				}
				else
				{
					$newBotFunctionsDisabledLine .= ",".$part[0].":".$part[1];
				}
			}
		}
	}
	
	saveValue($botid, $class_db, 'bot_functions', $newBotFunctionsLine);
	saveValue($botid, $class_db, 'bot_functions_disabled', $newBotFunctionsDisabledLine);
	
	$status = true;
	if ($botStatus == 1)
	{
		$serverInfo = getBotInfo($class_db, $botid);
		$status = $botTelnet->activateFunction($serverInfo[0], $functionPrefix);
	}
	
	return "{webui_activatefunction_successful}: ".$functionClass." / ".$functionPrefix.($status ? "" : "{botreload_info}");
}

function removeFunction($botid, $class_db, $functionClass, $functionPrefix)
{
	if (!isset($_POST['deleteYes']))
	{
		return "{webui_removefunction_aborted}: ".$functionClass." / ".$functionPrefix;
	}

	if (!is_numeric($botid))
	{
		return "Error: Call of removeFunction() with invalid arguments!";
	}
	
	$result = $class_db->db_query("DELETE FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey LIKE '".$class_db->getRealEscapeString($functionPrefix)."_%'");
	
	$additionalIncludePath = "include/functions/".strtolower($functionClass).".php";
	if (file_exists($additionalIncludePath))
	{
		include_once($additionalIncludePath);
		removeSpecialFunctionConfig($botid, $class_db, $functionPrefix);
	}

	$found = false;
	$botFunctionsDisabled = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions_disabled'");
	$newBotFunctionsDisabledLine = "";
	$functionListDisabled = explode(",", $botFunctionsDisabled[0]);
	foreach($functionListDisabled as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			if ($part[1] == $functionPrefix)
			{
				$found = true;
			}
			else
			{
				if (strlen($newBotFunctionsDisabledLine) < 3)
				{
					$newBotFunctionsDisabledLine = $part[0].":".$part[1];
				}
				else
				{
					$newBotFunctionsDisabledLine .= ",".$part[0].":".$part[1];
				}
			}
		}
	}
	
	if ($found)
	{
		saveValue($botid, $class_db, 'bot_functions_disabled', $newBotFunctionsDisabledLine);
		return "{webui_removefunction_successful}: ".$functionClass." / ".$functionPrefix;
	}
		
	$newBotFunctionsLine = "";
	$botFunctions = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions'");
	$functionList = explode(",", $botFunctions[0]);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			if ($part[1] == $functionPrefix)
			{
				// do nothing
			}
			else
			{
				if (strlen($newBotFunctionsLine) < 3)
				{
					$newBotFunctionsLine = $part[0].":".$part[1];
				}
				else
				{
					$newBotFunctionsLine .= ",".$part[0].":".$part[1];
				}
			}
		}
	}
	
	saveValue($botid, $class_db, 'bot_functions', $newBotFunctionsLine);
	
	return "{webui_removefunction_successful}: ".$functionClass." / ".$functionPrefix."{botreload_info}";
}

function renameFunction($botid, $class_db, $functionClass, $functionPrefix_old, $functionPrefix_new)
{
	if (!is_numeric($botid))
	{
		return "Error: Call of renameFunction() with invalid arguments!";
	}
	
	if (!preg_match("@^[a-z0-9\\_\\-]+$@is", $functionPrefix_new))
	{
		return "{webui_addfunction_invalidname}";
	}
	
	if ($functionClass == "")
	{
		return "{webui_addfunction_invalidfunction}";
	}

	$uniqueName = true;
	$botFunctions = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions'");
	$functionList = explode(",", $botFunctions[0]);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			if ($part[1] == $functionPrefix_new)
			{
				$uniqueName = false;
			}
		}
	}
	
	if (!$uniqueName)
	{
		return "{webui_addfunction_nouniquename}";
	}
	
	$botFunctionsDisabled = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$botid." AND configkey = 'bot_functions_disabled'");
	$functionList = explode(",", $botFunctionsDisabled[0]);
	foreach($functionList as $function)
	{
		$part = explode(":", $function);
		if (count($part) == 2)
		{
			if ($part[1] == $functionPrefix_new)
			{
				$uniqueName = false;
			}
		}
	}
	
	if (!$uniqueName)
	{
		return "{webui_addfunction_nouniquename}";
	}
	
	$newBotFunctionsLine = renameFunctionLine($botFunctions[0], $functionPrefix_old, $functionPrefix_new);
	if ($newBotFunctionsLine === false)
	{
		$newBotFunctionsLine = renameFunctionLine($botFunctionsDisabled[0], $functionPrefix_old, $functionPrefix_new);
		
		if ($newBotFunctionsLine !== false)
			saveValue($botid, $class_db, 'bot_functions_disabled', $newBotFunctionsLine);
	}
	else
	{
		saveValue($botid, $class_db, 'bot_functions', $newBotFunctionsLine);
	}
	
	if ($newBotFunctionsLine === false)
	{
		return "{webui_renamefunction_notfound}: ".$functionPrefix_old;
	}
	else
	{
		$class_db->db_query("UPDATE jts3servermod_log SET functionname = '".$class_db->getRealEscapeString($functionPrefix_new)."' WHERE instance_id = ".$botid." AND functionname = '".$class_db->getRealEscapeString($functionPrefix_old)."'");
		
		$resList = $class_db->db_query("SELECT configkey FROM jts3servermodwebui_functionpage, jts3servermodwebui_botfunction WHERE botfunction_id = id AND classname = \"".$class_db->getRealEscapeString($functionClass)."\"");
		while($row = mysqli_fetch_row($resList))
		{
			$class_db->db_query("UPDATE jts3servermod_instanceconfig SET configkey = '".$class_db->getRealEscapeString($functionPrefix_new.$row[0])."' WHERE instance_id = ".$botid." AND configkey = '".$class_db->getRealEscapeString($functionPrefix_old.$row[0])."'");
		}

		$additionalIncludePath = "include/functions/".strtolower($_POST['function_class']).".php";
		if (file_exists($additionalIncludePath))
		{
			include_once($additionalIncludePath);
			renameSpecialFunctionConfig($botid, $class_db, $functionPrefix_old, $functionPrefix_new);
		}
		
		return "{webui_renamefunction_successful}: ".$functionPrefix_old." -&gt; ".$functionPrefix_new."{botreload_info}";
	}
}

function renameFunctionLine($botFunctionsLine, $functionPrefix_old, $functionPrefix_new)
{
	$newBotFunctionsLine = false;
	
	$pos = strpos($botFunctionsLine, ":".$functionPrefix_old.",");
	if ($pos === FALSE)
	{
		if (substr($botFunctionsLine, (strlen(":".$functionPrefix_old) * (-1))) == ":".$functionPrefix_old)
		{
			$newBotFunctionsLine = substr($botFunctionsLine, 0, (strlen($functionPrefix_old) * (-1)));
			$newBotFunctionsLine .= $functionPrefix_new;
		}
	}
	else
	{
		$newBotFunctionsLine = str_replace(":".$functionPrefix_old.",", ":".$functionPrefix_new.",", $botFunctionsLine);
	}
	
	return $newBotFunctionsLine;
}

function getBotCheckLogInfo($botID)
{
	global $translation;
	$message = $translation->getTranslation("webui_checkloginfo");
	$message = str_replace('{botloglink}', "<a href=\"index.php?page=botlogview&amp;botID=".$botID."&amp;logtype=warning\">", $message);
	$message = str_replace('{botloglinkend}', "</a>", $message);
	return $message;
}

function getBotReloadInfo($botID, $botTelnet, $serverInfo, $status, $botStatus = null)
{
	$pos = strpos($status, '{botreload_info}');
	
	if ($pos === FALSE)
	{
		return "";
	}
	else
	{
		if ($botStatus == null) $botStatus = $botTelnet->getBotStatus($serverInfo[0]);
		return ($botStatus == 1 ? "<br><a href=\"javascript:void(0);\" class=\"nounderline\" onclick=\"requestBotCommand(".$botID.", 'reload');\">{webui_botsettingssaved_reloadbot} <img src=\"images/arrow_refresh_small.png\" border=\"0\" alt=\"\" class=\"middle\"></a>" : "");
	}
}

function getBotManagerMainpage($class_db, $useBotID, $serverInfo, $status)
{
	if (isset($_GET['ts3cache']) && $_GET['ts3cache'] == "delete")
		deleteTS3Cache($class_db, $useBotID);
	
	$botmanagertmpl = implode(" ", file("templates/botmanager.tmpl"));
	$botmanagertmpl = str_replace('{bot_header}', getBotHeader($class_db, $useBotID, $serverInfo), $botmanagertmpl);
	$botmanagertmpl = addStatusMessage($botmanagertmpl, $status);
	$botmanagertmpl = str_replace('{functionchooser}', getFunctionChooser($class_db), $botmanagertmpl);
	$botmanagertmpl = str_replace('{functionlist}', getFunctionList($useBotID, $class_db), $botmanagertmpl);
	$botmanagertmpl = str_replace('{ts3cacheinfo}', getTS3CacheTimeHTML($class_db, $useBotID), $botmanagertmpl);
	
	if (isBotCreateAllowed($class_db, $useBotID) == 1 || (isset($_SESSION['adminlevel']) && is_numeric($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1))
	{
		$botmanagertmpl = str_replace('{botedit}', implode(" ", file("templates/botmanager_functionlist_connectioneditrow.tmpl")), $botmanagertmpl);
		$botmanagertmpl = str_replace('{slotchecker}', implode(" ", file("templates/botmanager_functionlist_slotcheckerrow.tmpl")), $botmanagertmpl);
		
		global $translation;
		$botmanagertmpl = str_replace('{webui_botconnectionsettings}', $translation->getTranslation("webui_botconnectionsettings"), $botmanagertmpl);
	}
	else
	{
		$botmanagertmpl = str_replace('{botedit}', "", $botmanagertmpl);
		$botmanagertmpl = str_replace('{slotchecker}', "", $botmanagertmpl);
	}
	
	$botmanagertmpl = str_replace('{botID}', $useBotID, $botmanagertmpl);
	
	return $botmanagertmpl;
}

function replaceGlobalMessageVars($class_db, $useBotID, $for_output)
{
	if (strpos($for_output, '{globalmessagevars}') === false || !is_numeric($useBotID))
	{
		return str_replace('{globalmessagevars}', "", $for_output);
	}
	$botGlobalMessageVarsSetting = $class_db->getQuery("SELECT configvalue FROM jts3servermod_instanceconfig WHERE instance_id = ".$useBotID." AND configkey = 'bot_global_message_vars'");
	
	if ($_GET['mode'] == "editGeneralSettings" || $botGlobalMessageVarsSetting[0] == 1)
	{
		$globalmessagevarstmpl = implode(" ", file("templates/globalmessagevars.tmpl"));
		
		global $translation;
		$globalmessagevarstmpl = str_replace('{webui_globalmessagevars_short}', "\r\n<br>".$translation->getTranslation("webui_globalmessagevars_short", true), $globalmessagevarstmpl);
		$globalmessagevarstmpl = str_replace('{webui_globalmessagevars}', "\r\n<br>".$translation->getTranslation("webui_globalmessagevars",true), $globalmessagevarstmpl);
		
		$for_output = str_replace('{globalmessagevars}', $globalmessagevarstmpl, $for_output);
	}
	else
	{
		$for_output = str_replace('{globalmessagevars}', "", $for_output);
	}
	
	return $for_output;
}

$useBotID = -1;

if (isset($_GET['botID']) && is_numeric($_GET['botID']))
{
	$isAllowed = false;
	
	if ((isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0))
	{
		$isAllowed = true;
	}
	else
	{
		$isValid = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE user_id = ".$userid." AND instance_id = ".$_GET['botID']);
		if ($isValid[0] == 1)
		{
			$isAllowed = true;
		}
	}
	
	if ($isAllowed)
	{
		$isValid = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_instances WHERE id = ".$_GET['botID']);
		if ($isValid[0] == 1)
		{
			$useBotID = $_GET['botID'];
		}
	}
}

if ($useBotID > 0)
{
	$serverInfo = getBotInfo($class_db, $useBotID);
	
	$status = null;
	if (isset($_POST['mode']) && $_POST['mode'] == "saveBotFunctions")
	{
		$prefix = $_POST['function_prefix'];
		$resList = $class_db->db_query("SELECT configkey FROM jts3servermodwebui_functionpage, jts3servermodwebui_botfunction WHERE botfunction_id = id AND classname = \"".$class_db->getRealEscapeString($_POST['function_class'])."\" AND typename != \"fieldset\"");
		
		while($row = mysqli_fetch_row($resList))
		{
			if (isset($_POST[$prefix.$row[0]])) saveValue($useBotID, $class_db, $prefix.$row[0], $_POST[$prefix.$row[0]]);
		}
		
		$additionalIncludePath = "include/functions/".strtolower($_POST['function_class']).".php";
		if (file_exists($additionalIncludePath))
		{
			include_once($additionalIncludePath);
			saveSpecialFunctionConfig($useBotID, $class_db, $prefix);
		}
		
		$botStatus = $botTelnet->getBotStatus($serverInfo[0]);
		$statusExtra = "";
		if (!isFunctionEnabled($useBotID, $class_db, $prefix)) $statusExtra = "<br><a href=\"index.php?page=botmanager&amp;mode=activateFunction&amp;function_prefix=".$prefix."&amp;botID=".$useBotID."\">{webui_botsettingssaved_activatefunction} <img src=\"images/control_play_blue.png\" border=\"0\" alt=\"{webui_activatefunction}\" style=\"vertical-align:middle;\"></a>";
		else if ($botStatus == 1) $statusExtra = "<br><a href=\"javascript:void(0);\" class=\"nounderline\" onclick=\"requestBotCommand(".$useBotID.", 'reloadconfig');\">{webui_botsettingssaved_reloadbotconfig} <img src=\"images/arrow_refresh_small.png\" border=\"0\" alt=\"\" class=\"middle\"></a>";
		$status = "{webui_botsettingssaved}".$statusExtra;
		
		$_GET['mode'] = "editBotFunction";
		if (isset($_POST['function_class'])) $_GET['function_class'] = $_POST['function_class'];
		if (isset($_POST['function_prefix'])) $_GET['function_prefix'] = $_POST['function_prefix'];
	}
	
	if (isset($_POST['mode']) && $_POST['mode'] == "saveBotGeneralSettings")
	{
		if (isset($_POST['bot_channel_id'])) saveValue($useBotID, $class_db, 'bot_channel_id', $_POST['bot_channel_id']);
		if (isset($_POST['bot_check_interval'])) saveValue($useBotID, $class_db, 'bot_check_interval', $_POST['bot_check_interval']);
		if (isset($_POST['bot_clientdblist_cache'])) saveValue($useBotID, $class_db, 'bot_clientdblist_cache', $_POST['bot_clientdblist_cache']);
		if (isset($_POST['bot_global_message_vars'])) saveValue($useBotID, $class_db, 'bot_global_message_vars', $_POST['bot_global_message_vars']);
		if (isset($_POST['bot_server_query_name'])) saveValue($useBotID, $class_db, 'bot_server_query_name', $_POST['bot_server_query_name']);
		if (isset($_POST['bot_server_query_name_2'])) saveValue($useBotID, $class_db, 'bot_server_query_name_2', $_POST['bot_server_query_name_2']);
		if (isset($_POST['bot_date_pattern'])) saveValue($useBotID, $class_db, 'bot_date_pattern', $_POST['bot_date_pattern']);
		if (isset($_POST['bot_timezone'])) saveValue($useBotID, $class_db, 'bot_timezone', $_POST['bot_timezone']);
		if (isset($_POST['bot_connect_forever'])) saveValue($useBotID, $class_db, 'bot_connect_forever', $_POST['bot_connect_forever']);
		if (isset($_POST['bot_log_level'])) saveValue($useBotID, $class_db, 'bot_log_level', $_POST['bot_log_level']);
		if (isset($_POST['bot_admin_list'])) saveValue($useBotID, $class_db, 'bot_admin_list', $_POST['bot_admin_list']);
		if (isset($_POST['bot_lightadmingroup_list'])) saveValue($useBotID, $class_db, 'bot_lightadmingroup_list', $_POST['bot_lightadmingroup_list']);
		
		if (isset($_POST['bot_instance_csvloginlog_mode']) && is_numeric($_POST['bot_instance_csvloginlog_mode']))
		{
			$botCSVLogMode = $class_db->getQuery("SELECT csvlogmode FROM jts3servermod_instances WHERE id = ".$useBotID);
			if ($botCSVLogMode[0] != $_POST['bot_instance_csvloginlog_mode'])
			{
				$class_db->db_query("UPDATE jts3servermod_instances SET csvlogmode = ".$_POST['bot_instance_csvloginlog_mode']." WHERE id = ".$useBotID);
				$botTelnet->instancelistReload();
			}
		}
		
		$botStatus = $botTelnet->getBotStatus($serverInfo[0]);
		$status = "{webui_botsettingssaved}".($botStatus == 1 ? "<br><a href=\"javascript:void(0);\" class=\"nounderline\" onclick=\"requestBotCommand(".$useBotID.", 'reload');\">{webui_botsettingssaved_reloadbot} <img src=\"images/arrow_refresh_small.png\" border=\"0\" alt=\"\" class=\"middle\"></a>" : "");
		$_GET['mode'] = "editGeneralSettings";
	}
	
	if (isset($_POST['mode']) && $_POST['mode'] == "saveBotSlotCheckerSettings")
	{
		if (isBotCreateAllowed($class_db, $useBotID) == 1 || (isset($_SESSION['adminlevel']) && is_numeric($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1))
		{
			if (isset($_POST['slotchecker_check_interval'])) saveValue($useBotID, $class_db, 'slotchecker_check_interval', $_POST['slotchecker_check_interval']);
			if (isset($_POST['slotchecker_skip_action_interval'])) saveValue($useBotID, $class_db, 'slotchecker_skip_action_interval', $_POST['slotchecker_skip_action_interval']);
			if (isset($_POST['slotchecker_min_slotdistance'])) saveValue($useBotID, $class_db, 'slotchecker_min_slotdistance', $_POST['slotchecker_min_slotdistance']);
			if (isset($_POST['slotchecker_max_slotdistance'])) saveValue($useBotID, $class_db, 'slotchecker_max_slotdistance', $_POST['slotchecker_max_slotdistance']);
			if (isset($_POST['slotchecker_min_slotcount'])) saveValue($useBotID, $class_db, 'slotchecker_min_slotcount', $_POST['slotchecker_min_slotcount']);
			if (isset($_POST['slotchecker_max_slotcount'])) saveValue($useBotID, $class_db, 'slotchecker_max_slotcount', $_POST['slotchecker_max_slotcount']);
			if (isset($_POST['slotchecker_url'])) saveValue($useBotID, $class_db, 'slotchecker_url', $_POST['slotchecker_url']);
			if (isset($_POST['slotchecker_url_confirm'])) saveValue($useBotID, $class_db, 'slotchecker_url_confirm', $_POST['slotchecker_url_confirm']);
			
			$botStatus = $botTelnet->getBotStatus($serverInfo[0]);
			$status = "{webui_botsettingssaved}".($botStatus == 1 ? "<br><a href=\"javascript:void(0);\" class=\"nounderline\" onclick=\"requestBotCommand(".$useBotID.", 'reload');\">{webui_botsettingssaved_reloadbot} <img src=\"images/arrow_refresh_small.png\" border=\"0\" alt=\"\" class=\"middle\"></a>" : "");
			$_GET['mode'] = "editSlotCheckerSettings";
		}
		else
		{
			$for_output = implode(" ", file("templates/backtomain.tmpl"));
			$for_output = str_replace('{title}', "{webui_botsettings}", $for_output);
			$for_output = str_replace('{message}', "{webui_onlyadministrator}", $for_output);
			$for_output = str_replace('"index.php"', "\"index.php?page=botmanager&amp;botID=".$useBotID."\"", $for_output);
		}
	}
	
	if (isset($_POST['mode']) && $_POST['mode'] == "addFunction")
	{
		$status = addFunction($useBotID, $class_db, $_POST['function_class'], $_POST['function_prefix']);
	}
	
	if (isset($_POST['mode']) && $_POST['mode'] == "removeFunction")
	{
		$status = removeFunction($useBotID, $class_db, $_POST['function_class'], $_POST['function_prefix']);
		$status = str_replace('{botreload_info}', getBotReloadInfo($useBotID, $botTelnet, $serverInfo, $status), $status);
	}
	
	if (isset($_POST['mode']) && $_POST['mode'] == "renameFunction")
	{
		$status = renameFunction($useBotID, $class_db, $_POST['function_class'], $_POST['function_prefix_old'], $_POST['function_prefix_new']);
		$status = str_replace('{botreload_info}', getBotReloadInfo($useBotID, $botTelnet, $serverInfo, $status), $status);
	}
	
	if (isset($_GET['mode']) && $_GET['mode'] == "disableFunction")
	{
		$botStatus = $botTelnet->getBotStatus($serverInfo[0]);
		$status = disableFunction($useBotID, $class_db, $_GET['function_prefix'], $botStatus, $botTelnet);
		$status = str_replace('{botreload_info}', getBotReloadInfo($useBotID, $botTelnet, $serverInfo, $status, $botStatus), $status);
	}
	
	if (isset($_GET['mode']) && $_GET['mode'] == "activateFunction")
	{
		$botStatus = $botTelnet->getBotStatus($serverInfo[0]);
		$status = activateFunction($useBotID, $class_db, $_GET['function_prefix'], $botStatus, $botTelnet);
		$status = str_replace('{botreload_info}', getBotReloadInfo($useBotID, $botTelnet, $serverInfo, $status, $botStatus), $status);
	}
	
	if (isset($_GET['mode']) && $_GET['mode'] == "editBotFunction")
	{
		$for_output = getBotFunctionConfigPage($useBotID, $class_db, $_GET['function_class'], $_GET['function_prefix']);
		$for_output = addStatusMessage($for_output, $status);
	}
	else if (isset($_GET['mode']) && $_GET['mode'] == "editGeneralSettings")
	{
		$for_output = getBotGeneralSettings($useBotID, $class_db);
		$for_output = addStatusMessage($for_output, $status);
	}
	else if (isset($_GET['mode']) && $_GET['mode'] == "editSlotCheckerSettings")
	{
		if (isBotCreateAllowed($class_db, $useBotID) == 1 || (isset($_SESSION['adminlevel']) && is_numeric($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1))
		{
			$for_output = getBotSlotCheckerSettings($useBotID, $class_db);
			$for_output = addStatusMessage($for_output, $status);
		}
		else
		{
			$for_output = implode(" ", file("templates/backtomain.tmpl"));
			$for_output = str_replace('{title}', "{webui_botsettings}", $for_output);
			$for_output = str_replace('{message}', "{webui_onlyadministrator}", $for_output);
			$for_output = str_replace('"index.php"', "\"index.php?page=botmanager&amp;botID=".$useBotID."\"", $for_output);
		}
	}
	else if (isset($_GET['mode']) && $_GET['mode'] == "removeFunction")
	{
		$for_output = getRemoveFunctionPage($useBotID, $class_db, $_GET['function_class'], $_GET['function_prefix']);
		$for_output = addStatusMessage($for_output, $status);
	}
	else if (isset($_GET['mode']) && $_GET['mode'] == "renameFunction")
	{
		$for_output = getRenameFunctionPage($useBotID, $class_db, $_GET['function_class'], $_GET['function_prefix']);
		$for_output = addStatusMessage($for_output, $status);
	}
	else
	{
		$for_output = getBotManagerMainpage($class_db, $useBotID, $serverInfo, $status);
	}
}
else
{
	$for_output = implode(" ", file("templates/backtomain.tmpl"));
	$for_output = str_replace('{title}', "{webui_botsettings}", $for_output);
	$for_output = str_replace('{message}', "{webui_error_editbotforbidden}", $for_output);
}

$for_output = $translation->replaceTranslationsForPage($for_output, "botmanager");
$for_output = $translation->replaceTranslationsForPage($for_output, "formularfunctions");
$for_output = replaceGlobalMessageVars($class_db, $useBotID, $for_output);

?>