<?PHP

require_once("include/formularfunctions.php");
$status = null;

function getExceptionCountArray($class_db)
{
	$exceptionCount = array();
	$resExceptionCount = $class_db->db_query("SELECT instance_id, COUNT(*) AS Exception_Count FROM jts3servermod_log WHERE logtype IN (\"EXCEPTION\", \"CRITICAL\", \"ERROR\") AND logtime > ".((time() - (60*60*24))*1000)." GROUP BY instance_id");
	while($row = mysqli_fetch_row($resExceptionCount))
	{
		$exceptionCount[$row[0]] = $row[1];
	}
	
	return $exceptionCount;
}

function getBotDeleteTimeName($seconds)
{
	$retValue = "error";
	switch ($seconds)
	{
		case 259200: $retValue = "{webui_botlist_deletethreedays}"; break;
		case 604800: $retValue = "{webui_botlist_deleteoneweek}"; break;
		case 1209600: $retValue = "{webui_botlist_deletetwoweeks}"; break;
		case 2419200: $retValue = "{webui_botlist_deletemonth}"; break;
		case 4838400: $retValue = "{webui_botlist_deletetwomonths}"; break;
		default: $retValue = "error";
	}
	return $retValue;
}

function getBotDeleteTimeComboBox()
{
	$formChooser = "<select name=\"botinactivitytime\" size=\"1\" class=\"textinput\">\n";
	
	$formChooser = $formChooser."<option value=\"259200\">".getBotDeleteTimeName(259200)."</option>\n";
	$formChooser = $formChooser."<option value=\"604800\">".getBotDeleteTimeName(604800)."</option>\n";
	$formChooser = $formChooser."<option value=\"1209600\">".getBotDeleteTimeName(1209600)."</option>\n";
	$formChooser = $formChooser."<option value=\"2419200\">".getBotDeleteTimeName(2419200)."</option>\n";
	$formChooser = $formChooser."<option value=\"4838400\">".getBotDeleteTimeName(4838400)."</option>\n";
	
	return $formChooser."\n</select>\n";
}

if (isset($_GET['mode']) && $_GET['mode'] == "deletebot")
{
	require_once("include/botheaderfunctions.php");

	if (isset($_GET['botID']) && is_numeric($_GET['botID']))
	{
		$resInfo = $class_db->db_query("SELECT name, ts3serverip FROM jts3servermod_instances WHERE id = ".$_GET['botID']);
		if (mysqli_num_rows($resInfo) > 0)
		{
			$botInfo = mysqli_fetch_array($resInfo);
			$botdeletetmpl = implode(" ", file("templates/botdelete.tmpl"));
			$botdeletetmpl = str_replace('{bot_header}', getBotHeader($class_db, $_GET['botID']), $botdeletetmpl);
			$botdeletetmpl = str_replace('{webui_botdeleteconfirm}', $translation->getTranslation("webui_botdeleteconfirm", true), $botdeletetmpl);
			$botdeletetmpl = str_replace('{botID}', $_GET['botID'], $botdeletetmpl);
			$botdeletetmpl = str_replace('{botname}', $botInfo[0], $botdeletetmpl);
			$botdeletetmpl = str_replace('{serverdata}', $botInfo[1], $botdeletetmpl);
			$botdeletetmpl = $translation->replaceTranslationsForPage($botdeletetmpl, "formularfunctions");
			$for_output = $botdeletetmpl;
		}
		else
		{
			$status = "{webui_error_invalidbotid}";
		}
	}
	else
	{
		$status = "{webui_error_invalidbotid}";
	}
}
else if (isset($_POST['mode']) && $_POST['mode'] == "deletebot")
{
	require_once("include/botdeleteownerfunctions.php");
	
	if (isset($_POST['deleteYes']))
	{
		$result = deleteBot($class_db, $botTelnet, $_POST['botID']);
		if ($result == 0)
		{
			$status = $translation->getTranslation("webui_successfullydeleted");
		}
		else if ($result == 3)
		{
			$status = "{webui_nopermission}";
		}
		else
		{
			$status = "{webui_botnotexists}";
		}
	}
	else
	{
		$status = $translation->getTranslation("webui_notdeleted");
	}
}
else if (isset($_GET['mode']) && $_GET['mode'] == "confirmdeleteinactivebots")
{
	if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1)
	{
		$inactivityTime = 259200;
		if (isset($_POST['botinactivitytime']) && is_numeric($_POST['botinactivitytime']))
			$inactivityTime = $_POST['botinactivitytime'];
		$inactivityTimestamp = (time() - $inactivityTime) * 1000;
		
		$botNameOfflineArray = array();
		$botStatusArray = $botTelnet->getBotStatusAll();
		if (is_array($botStatusArray))
		{
			foreach ($botStatusArray as $key => $value)
			{
				if ($value == 0)
					$botNameOfflineArray[] = "'".$class_db->getRealEscapeString($key)."'";
			}
			
			if (count($botNameOfflineArray) > 0)
			{
				$botlist_content = "";
				$botlistrow_tmpl = implode(" ", file("templates/botlist_deleteinactivebots_row.tmpl"));
				
				$botNameOfflineList = implode(", ", $botNameOfflineArray);
				$botLastLogEntryArray = array();
				$resListBotsLastLogEntry = $class_db->db_query("SELECT jts3servermod_log.instance_id AS botid, MAX(jts3servermod_log.logtime) AS botlastlogtime FROM jts3servermod_instances, jts3servermod_log WHERE jts3servermod_log.instance_id = jts3servermod_instances.id AND jts3servermod_instances.name IN (".$botNameOfflineList.") GROUP BY botid");
				while($row = mysqli_fetch_row($resListBotsLastLogEntry))
				{
					$botLastLogEntryArray[$row[0]] = $row[1];
				}
				
				$botIDsArray = array();
				$resListBots = $class_db->db_query("SELECT jts3servermodwebui_users.id AS userid, jts3servermodwebui_users.name AS username, jts3servermod_instances.id AS botid, jts3servermod_instances.name AS botname, jts3servermod_instances.laststarttime AS botlaststarttime, jts3servermod_instances.lastsuccesslogintime AS botlastsuccesslogintime FROM jts3servermodwebui_users, jts3servermodwebui_usersinstances, jts3servermod_instances WHERE jts3servermodwebui_usersinstances.fullaccess = 1 AND jts3servermodwebui_usersinstances.user_id = jts3servermodwebui_users.id AND jts3servermodwebui_usersinstances.instance_id = jts3servermod_instances.id AND jts3servermod_instances.name IN (".$botNameOfflineList.") GROUP BY botid ORDER BY botname");
				while($row = mysqli_fetch_row($resListBots))
				{
					$logDateExists = false;
					if (isset($botLastLogEntryArray[$row[2]]))
					{
						if ($botLastLogEntryArray[$row[2]] > $inactivityTimestamp)
							continue;
						
						$logDateExists = true;
					}
					
					if ($row[4] > $inactivityTimestamp)
						continue;
					
					$botlist_content .= $botlistrow_tmpl;
					$botlist_content = str_replace('{userID}', $row[0], $botlist_content);
					$botlist_content = str_replace('{username}', $row[1], $botlist_content);
					$botlist_content = str_replace('{botID}', $row[2], $botlist_content);
					$botlist_content = str_replace('{botname}', $row[3], $botlist_content);
					$botlist_content = str_replace('{lastbotstart}', ($row[4] == 0 ? "{webui_never}" : $translation->getDate($row[4] / 1000)), $botlist_content);
					$botlist_content = str_replace('{lastsuccessfulconnect}', ($row[5] == 0 ? "{webui_never}" : $translation->getDate($row[5] / 1000)), $botlist_content);
					
					if ($logDateExists)
						$botlist_content = str_replace('{lastlogentry}', $translation->getDate($botLastLogEntryArray[$row[2]] / 1000), $botlist_content);
					else
						$botlist_content = str_replace('{lastlogentry}', "{webui_never}", $botlist_content);
					
					$botIDsArray[] = $row[2];
				}
				
				if ($botlist_content == "")
				{
					$status = "{webui_nobotsinactivefor}: ".getBotDeleteTimeName($inactivityTime);
					$_GET['list'] = "all";
				}
				else
				{
					$botlist_tmpl = implode(" ", file("templates/botlist_deleteinactivebots.tmpl"));
					$botlist_tmpl = str_replace('{currenttimeselection}', getBotDeleteTimeName($inactivityTime), $botlist_tmpl);
					$botlist_tmpl = str_replace('{content}', $botlist_content, $botlist_tmpl);
					$botlist_tmpl = str_replace('{botIDs}', implode(",", $botIDsArray), $botlist_tmpl);
					$botlist_tmpl = $translation->replaceTranslationsForPage($botlist_tmpl, "formularfunctions");
					$for_output = $botlist_tmpl;
				}
			}
			else
			{
				$status = "{webui_nobotsinactivefor}: ".getBotDeleteTimeName($inactivityTime);
				$_GET['list'] = "all";
			}
		}
		else
		{
			$status = "{webui_botstatenotavailable}";
			$_GET['list'] = "all";
		}
	}
}
else if (isset($_POST['mode']) && $_POST['mode'] == "deleteinactivebots")
{
	if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1)
	{
		$botIDsArray = array();
		if (isset($_POST['botIDs']))
			$botIDsArray = explode(",", $_POST['botIDs']);
		
		require_once("include/botdeleteownerfunctions.php");
		
		if (isset($_POST['deleteYes']))
		{
			$delCount = 0;
			$errCount = 0;
			foreach ($botIDsArray as $botID)
			{
				$result = deleteBot($class_db, $botTelnet, $botID, false);
				if ($result == 0)
				{
					++$delCount;
				}
				else
				{
					++$errCount;
				}
			}
			
			$botTelnet->instancelistReload();
			$status = $translation->getTranslation("webui_botdeletedcount");
			$status = str_replace('{delCount}', $delCount, $status);
			$status = str_replace('{errCount}', $errCount, $status);
			$_GET['list'] = "all";
		}
		else
		{
			$status = $translation->getTranslation("webui_notdeleted");
			$_GET['list'] = "all";
		}
	}
}
else if (isset($_POST['mode']) && $_POST['mode'] == "deletelog")
{
	if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 2)
	{
		$status = "{webui_onlyadministrator}";
	}
	else if (isset($_POST['logdeletetime']) && is_numeric($_POST['logdeletetime']) && isset($_POST['deleteYes']))
	{
		require_once("include/botlogview_functions.php");
		$status = deleteLogAdmin($class_db, $_POST['logdeletetime'], (isset($_POST['logdeleteconnections']) && $_POST['logdeleteconnections'] == "yes" ? true : false));
		$_GET['list'] = "all";
	}
	else
	{
		$status = "{webui_deletelog_aborted}";
		$_GET['list'] = "all";
	}
	
	$status = $translation->replaceTranslationsForPage($status, "botlogview");
}
else if (isset($_GET['mode']) && $_GET['mode'] == "confirmdeletelog")
{
	if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 2)
	{
		$status = "{webui_onlyadministrator}";
	}
	else if (isset($_POST['logdeletetime']) && is_numeric($_POST['logdeletetime']))
	{
		require_once("include/botlogview_functions.php");
		$for_output = getDeleteConfirm(-1, $_POST['logdeletetime'], (isset($_POST['logdeleteconnections']) && $_POST['logdeleteconnections'] == "yes" ? true : false), $class_db);
		$for_output = $translation->replaceTranslationsForPage($for_output, "botlogview");
		$for_output = $translation->replaceTranslationsForPage($for_output, "formularfunctions");
	}
	else
	{
		$status = "Error: Log delete with invalid arguments!";
	}
}

if ($for_output == "")
{
	$botlist_content = "";
	$botlist_tmpl = "";
	$botlistadmintable_tmpl = "";
	$showalllink_tmpl = "";
	$currentUserIDBotList = $userid;
	$currentUserNameBotList = $_SESSION['username'];
	
	$exceptionCount = getExceptionCountArray($class_db);
	
//	Normal User Bot List
	if (!isset($_GET['list']) || $_GET['list'] != "all")
	{
		$botlistadmin_tmpl = "";
		if ((isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0) && (isset($_GET['botlistuserid']) && is_numeric($_GET['botlistuserid'])))
		{
			$currentUserIDBotList = $_GET['botlistuserid'];
			$resUserName = $class_db->db_query("SELECT name FROM jts3servermodwebui_users WHERE id = ".$_GET['botlistuserid']);
			if (mysqli_num_rows($resUserName) == 1)
			{
				$curUserName = mysqli_fetch_array($resUserName);
				$currentUserNameBotList = $curUserName[0];
			}
			else
			{
				$currentUserNameBotList = "Unknown Name";
			}
		}

		$resListBots = $class_db->db_query("SELECT jts3servermod_instances.id AS botid, jts3servermod_instances.name AS botname, jts3servermod_instances.laststarttime AS botlaststarttime, jts3servermod_instances.lastsuccesslogintime AS botlastsuccesslogintime FROM jts3servermodwebui_usersinstances, jts3servermod_instances WHERE jts3servermodwebui_usersinstances.instance_id = jts3servermod_instances.id AND jts3servermodwebui_usersinstances.user_id = ".$currentUserIDBotList);

		if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0)
		{
			$showalllink_tmpl = implode(" ", file("templates/botlist_showalllink.tmpl"));
		}
		
		$botlist_tmpl = implode(" ", file("templates/botlist.tmpl"));
		if (mysqli_num_rows($resListBots) == 0)
		{
			$botlist_content = "<tr><td colspan=\"5\">{webui_nobotsonlist}</td></tr>\n";
		}
		else
		{
			$botlistrow_tmpl = implode(" ", file("templates/botlist_row.tmpl"));
			$renamelink_tmpl = "";
			if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0)
			{
				$renamelink_tmpl = implode(" ", file("templates/botlist_row_rename.tmpl"));
			}
			
			$copylink_tmpl = implode(" ", file("templates/botlist_row_copy.tmpl"));
			

			
			while($row = mysqli_fetch_row($resListBots))
			{
				$botlistrow = $botlistrow_tmpl;
				
				$botCopyAllowed = isBotCreateAllowed($class_db, $row[0]);
				if ($botCopyAllowed == 1 || (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0))
				{
					$botlistrow = str_replace('{botcopylink}', $copylink_tmpl, $botlistrow);
				}
				else
				{
					$botlistrow = str_replace('{botcopylink}', "", $botlistrow);
				}
				
				$botlistrow = str_replace('{botrenamelink}', $renamelink_tmpl, $botlistrow);
				$botlistrow = str_replace('{botname}', $row[1], $botlistrow);
				$botlistrow = str_replace('{errorcount}', (isset($exceptionCount[$row[0]]) ? $exceptionCount[$row[0]] : "0"), $botlistrow);
				$botlistrow = str_replace('{lastbotstart}', ($row[2] == 0 ? "{webui_never}" : $translation->getDate($row[2] / 1000)), $botlistrow);
				$botlistrow = str_replace('{lastsuccessfulconnect}', ($row[3] == 0 ? "{webui_never}" : $translation->getDate($row[3] / 1000)), $botlistrow);
				$botlistrow = str_replace('{botID}', $row[0], $botlistrow);
				$botlist_content .= $botlistrow;
			}
		}
	}

	$botlistadmin_tmpl = "";
	$adminstatus = "";
	if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0)
	{
		$botlistadmin_tmpl = implode(" ", file("templates/botlist_admin.tmpl"));
		
		if (isset($_GET['list']) && $_GET['list'] == "all")
		{
//			Admin Bot List with all Bots
			$sortarrows = file("templates/sortable_arrows.tmpl");
			
			$orderby = "jts3servermod_instances.name";
			$ordertype = "ASC";
			$orderby1next = 11;
			$orderby2next = 2;
			$orderby3next = 3;
			$orderby4next = 4;
			$orderby5next = 5;
			$imageorderby1 = $sortarrows[0];
			$imageorderby2 = "";
			$imageorderby3 = "";
			$imageorderby4 = "";
			$imageorderby5 = "";
			if (isset($_GET['orderby']) && is_numeric($_GET['orderby']))
			{
				if ($_GET['orderby'] == 11)
				{
					$orderby = "jts3servermod_instances.name";
					$ordertype = "DESC";
					$orderby1next = 1;
					$imageorderby1 = $sortarrows[1];
				}
				
				if ($_GET['orderby'] == 2)
				{
					$orderby = "jts3servermodwebui_users.name";
					$ordertype = "ASC";
					$orderby1next = 1;
					$orderby2next = 21;
					$imageorderby1 = "";
					$imageorderby2 = $sortarrows[0];
				}
				
				if ($_GET['orderby'] == 21)
				{
					$orderby = "jts3servermodwebui_users.name";
					$ordertype = "DESC";
					$orderby1next = 1;
					$orderby2next = 1;
					$imageorderby1 = "";
					$imageorderby2 = $sortarrows[1];
				}
				
				if ($_GET['orderby'] == 3)
				{
					$orderby = "jts3servermod_instances.laststarttime";
					$ordertype = "ASC";
					$orderby1next = 1;
					$orderby3next = 31;
					$imageorderby1 = "";
					$imageorderby3 = $sortarrows[0];
				}
				
				if ($_GET['orderby'] == 31)
				{
					$orderby = "jts3servermod_instances.laststarttime";
					$ordertype = "DESC";
					$orderby1next = 1;
					$orderby3next = 1;
					$imageorderby1 = "";
					$imageorderby3 = $sortarrows[1];
				}
				
				if ($_GET['orderby'] == 4)
				{
					$orderby = "jts3servermod_instances.lastsuccesslogintime";
					$ordertype = "ASC";
					$orderby1next = 1;
					$orderby4next = 41;
					$imageorderby1 = "";
					$imageorderby4 = $sortarrows[0];
				}
				
				if ($_GET['orderby'] == 41)
				{
					$orderby = "jts3servermod_instances.lastsuccesslogintime";
					$ordertype = "DESC";
					$orderby1next = 1;
					$orderby4next = 1;
					$imageorderby1 = "";
					$imageorderby4 = $sortarrows[1];
				}
				
				if ($_GET['orderby'] == 5)
				{
					$orderby = "exceptionCount";
					$ordertype = "ASC";
					$orderby1next = 1;
					$orderby5next = 51;
					$imageorderby1 = "";
					$imageorderby5 = $sortarrows[0];
					$adminstatus = "{webui_onlybotswitherrorsdisplayed}";
				}
				
				if ($_GET['orderby'] == 51)
				{
					$orderby = "exceptionCount";
					$ordertype = "DESC";
					$orderby1next = 1;
					$orderby5next = 1;
					$imageorderby1 = "";
					$imageorderby5 = $sortarrows[1];
					$adminstatus = "{webui_onlybotswitherrorsdisplayed}";
				}
			}
			
			$botlist_tmpl = implode(" ", file("templates/botlist_all.tmpl"));

			$botlist_tmpl = str_replace('{orderby1}', $orderby1next, $botlist_tmpl);
			$botlist_tmpl = str_replace('{orderby2}', $orderby2next, $botlist_tmpl);
			$botlist_tmpl = str_replace('{orderby3}', $orderby3next, $botlist_tmpl);
			$botlist_tmpl = str_replace('{orderby4}', $orderby4next, $botlist_tmpl);
			$botlist_tmpl = str_replace('{orderby5}', $orderby5next, $botlist_tmpl);
			$botlist_tmpl = str_replace('{image_orderby1}', $imageorderby1, $botlist_tmpl);
			$botlist_tmpl = str_replace('{image_orderby2}', $imageorderby2, $botlist_tmpl);
			$botlist_tmpl = str_replace('{image_orderby3}', $imageorderby3, $botlist_tmpl);
			$botlist_tmpl = str_replace('{image_orderby4}', $imageorderby4, $botlist_tmpl);
			$botlist_tmpl = str_replace('{image_orderby5}', $imageorderby5, $botlist_tmpl);
			
			$resListBots = null;
			if ($orderby == "exceptionCount")
				$resListBots = $class_db->db_query("SELECT jts3servermodwebui_users.id AS userid, jts3servermodwebui_users.name AS username, jts3servermod_instances.id AS botid, jts3servermod_instances.name AS botname, jts3servermod_instances.laststarttime AS botlaststarttime, jts3servermod_instances.lastsuccesslogintime AS botlastsuccesslogintime, COUNT(*) AS Error_Count FROM jts3servermodwebui_users, jts3servermodwebui_usersinstances, jts3servermod_instances, jts3servermod_log WHERE jts3servermodwebui_usersinstances.fullaccess = 1 AND jts3servermodwebui_usersinstances.user_id = jts3servermodwebui_users.id AND jts3servermodwebui_usersinstances.instance_id = jts3servermod_instances.id AND jts3servermod_instances.id = jts3servermod_log.instance_id AND logtype IN (\"EXCEPTION\", \"CRITICAL\", \"ERROR\") AND logtime > ".((time() - (60*60*24))*1000)." GROUP BY botid ORDER BY Error_Count ".$ordertype);
			else
				$resListBots = $class_db->db_query("SELECT jts3servermodwebui_users.id AS userid, jts3servermodwebui_users.name AS username, jts3servermod_instances.id AS botid, jts3servermod_instances.name AS botname, jts3servermod_instances.laststarttime AS botlaststarttime, jts3servermod_instances.lastsuccesslogintime AS botlastsuccesslogintime FROM jts3servermodwebui_users, jts3servermodwebui_usersinstances, jts3servermod_instances WHERE jts3servermodwebui_usersinstances.fullaccess = 1 AND jts3servermodwebui_usersinstances.user_id = jts3servermodwebui_users.id AND jts3servermodwebui_usersinstances.instance_id = jts3servermod_instances.id GROUP BY botid ORDER BY ".$orderby." ".$ordertype);
			
			if (mysqli_num_rows($resListBots) == 0)
			{
				$botlist_content = "<tr><td colspan=\"6\">{webui_nobotsonlist}</td></tr>\n";
			}
			else
			{
				$botlistrow_tmpl = implode(" ", file("templates/botlist_all_row.tmpl"));
				
				while($row = mysqli_fetch_row($resListBots))
				{
					$botlistrow = $botlistrow_tmpl;
					$botlistrow = str_replace('{userID}', $row[0], $botlistrow);
					$botlistrow = str_replace('{username}', $row[1], $botlistrow);
					$botlistrow = str_replace('{botID}', $row[2], $botlistrow);
					$botlistrow = str_replace('{botname}', $row[3], $botlistrow);
					$botlistrow = str_replace('{errorcount}', (isset($exceptionCount[$row[2]]) ? $exceptionCount[$row[2]] : "0"), $botlistrow);
					$botlistrow = str_replace('{lastbotstart}', ($row[4] == 0 ? "{webui_never}" : $translation->getDate($row[4] / 1000)), $botlistrow);
					$botlistrow = str_replace('{lastsuccessfulconnect}', ($row[5] == 0 ? "{webui_never}" : $translation->getDate($row[5] / 1000)), $botlistrow);
					$botlist_content .= $botlistrow;
				}
			}
			$botlistadmin_tmpl = str_replace('{botlist_admin_table}', "", $botlistadmin_tmpl);
		}
		else
		{
//			List of users with Bots on the normal user bot list (Admins only)
			$resListUsers = $class_db->db_query("SELECT jts3servermodwebui_users.id, jts3servermodwebui_users.name, COUNT(jts3servermodwebui_usersinstances.instance_id) AS BotCount FROM jts3servermodwebui_users, jts3servermodwebui_usersinstances WHERE jts3servermodwebui_usersinstances.user_id = jts3servermodwebui_users.id GROUP BY jts3servermodwebui_users.id ORDER BY jts3servermodwebui_users.name");
			
			if (mysqli_num_rows($resListUsers) > 0)
			{
				$botlistadminrow_tmpl = implode(" ", file("templates/botlist_admin_tablerow.tmpl"));
				$botlistadmin_content = "";
				
				while($row = mysqli_fetch_row($resListUsers))
				{
					if ($currentUserIDBotList == $row[0])
					{
						continue;
					}
					
					$botlistadmin_content .= $botlistadminrow_tmpl;
					$botlistadmin_content = str_replace('{userid}', $row[0], $botlistadmin_content);
					$botlistadmin_content = str_replace('{username}', $row[1], $botlistadmin_content);
					$botlistadmin_content = str_replace('{botcount}', $row[2], $botlistadmin_content);
				}
				
				if ($botlistadmin_content != "")
				{
					$botlistadmintable_tmpl = implode(" ", file("templates/botlist_admin_table.tmpl"));
					$botlistadmintable_tmpl = str_replace('{admin_content}', $botlistadmin_content, $botlistadmintable_tmpl);
				}
			}
		}
		
		$fullbotcount = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_instances");
		$botlistadmin_tmpl = str_replace('{totalbotcount}', $fullbotcount[0], $botlistadmin_tmpl);
		$botlistadmin_tmpl = str_replace('{adminstatus}', ($adminstatus == "" ? "" : $adminstatus."<br>"), $botlistadmin_tmpl);
		
		$botlistadmin_tmpl = str_replace('{botinstancelistreload}', ($_SESSION['adminlevel'] > 1 ? implode(" ", file("templates/botlist_instancelistreload.tmpl")) : ""), $botlistadmin_tmpl);
		$botlistadmin_tmpl = str_replace('{webui_helpinstancelistreload}', $translation->getTranslation("webui_helpinstancelistreload", true), $botlistadmin_tmpl);
		
		$botlistadmin_tmpl = str_replace('{botdeletetime}', getBotDeleteTimeComboBox(), $botlistadmin_tmpl);
		
		require_once("include/botlogview_functions.php");
		$botlistadmin_tmpl = str_replace('{logdeletetime}', getTimeDeleteComboBoxDef(), $botlistadmin_tmpl);
		$botlistadmin_tmpl = $translation->replaceTranslationsForPage($botlistadmin_tmpl, "botlogview");
	}
	else if ($botlist_tmpl == "")
	{
		$botlist_tmpl = implode(" ", file("templates/backtomain.tmpl"));
		$botlist_tmpl = str_replace('{title}', "{webui_botlist_all}", $botlist_tmpl);
		$botlist_tmpl = str_replace('{message}', "{webui_onlyadministrator}", $botlist_tmpl);
	}
				
	$botlistadmin_tmpl = str_replace('{botlist_admin_table}', $botlistadmintable_tmpl, $botlistadmin_tmpl);

	$botlist_tmpl = addStatusMessage($botlist_tmpl, $status);
	$botlist_tmpl = str_replace('{webui_botstatusoff}', $translation->getTranslation("webui_botstatusoff", false, false), $botlist_tmpl);
	$botlist_tmpl = str_replace('{webui_botstatuson}', $translation->getTranslation("webui_botstatuson", false, false), $botlist_tmpl);
	$botlist_tmpl = str_replace('{showalllink}', $showalllink_tmpl, $botlist_tmpl);
	$botlist_tmpl = str_replace('{currentusername}', $currentUserNameBotList, $botlist_tmpl);
	$botlist_tmpl = str_replace('{currentuserid}', $currentUserIDBotList, $botlist_tmpl);
	$botlist_tmpl = str_replace('{content}', $botlist_content, $botlist_tmpl);
	$botlist_tmpl = str_replace('{adminlist}', $botlistadmin_tmpl, $botlist_tmpl);
	$for_output .= $botlist_tmpl;
}

$for_output = $translation->replaceTranslationsForPage($for_output, "botlist");

?>