<?php
class dbconnect
{
	private $sqlcount;
	private $link = false;

	function __construct()
	{
		$output = implode(" ", file("templates/index_maintenance.tmpl"));
		if (!file_exists("config/dbconnect_config.php"))
		{
			die(str_replace('{content}', "Configuration file is missing, create one with the <a href=\"install.php\">install.php</a>.\n<br><br>\nKonfigurationsdatei nicht gefunden, erstelle eine mit der <a href=\"install.php\">install.php</a>.", $output));
		}
		
		$config = file("config/dbconnect_config.php", FILE_IGNORE_NEW_LINES);
		
		if (sizeof($config) != 6)
		{
			die(str_replace('{content}', "Configuration file is empty or corrupt, create a new one with the <a href=\"install.php\">install.php</a>.\n<br><br>\nKonfigurationsdatei ist leer oder fehlerhaft, erstelle eine neue Datei mit der <a href=\"install.php\">install.php</a>.", $output));
		}
		
		$this->link = mysqli_connect($config[1], $config[2], $config[3], $config[4]);
		$this->sqlcount = 0;
		
		if (mysqli_connect_error() != null)
		{
		    printf("MySQL Connect failed: %s\n<br>Please contact the webmaster! / Bitte kontaktieren Sie den Webmaster.", mysqli_connect_error());
		    exit();
		}
		
		if (!mysqli_set_charset($this->link, "utf8mb4"))
		{
		    printf("MySQL charset change failed: %s\n<br>Please contact the webmaster! / Bitte kontaktieren Sie den Webmaster.", mysqli_error($this->link));
		    exit();
		}
	}
	
	function getQuery($sql)
	{
		//echo "getQuery: ".$sql."\r\n";
		$query = mysqli_query($this->link, $sql) or die ($this->sqlError($sql, mysqli_error($this->link)));;
		$this->sqlcount++;
		
 		return mysqli_fetch_array($query);
	}
 	
	function db_query($query, $returnFalseOnError = false)
	{
		//echo "db_query: ".$query."\r\n";

		if ($returnFalseOnError)
		{
			$error = false;
			$res = mysqli_query($this->link, $query) or $error = true;
			if ($error)
				return false;
		}
		else
		{
			$res = mysqli_query($this->link, $query) or die ($this->sqlError($query, mysqli_error($this->link)));
		}
		
		$this->sqlcount++;
		return $res;
	}
	
	function getSQLCount()
	{
		return $this->sqlcount;
	}
	
 	function getLink()
	{
		return $this->link;
	}
	
	function getRealEscapeString($unescaped_string)
	{
		return mysqli_real_escape_string($this->link, $unescaped_string);
	}
	
 	function getLastInsertID()
	{
		return mysqli_insert_id($this->link);
	}
	
	function sqlError($query, $mysqlError)
	{
		if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1)
		{
			echo (isset($_SERVER['HTTP_REFERER']) ? "<b>Referer:</b> ".$_SERVER['HTTP_REFERER']."<br>" : "")."<b>Page:</b> ".$_SERVER['REQUEST_URI']."<br>";
			echo "<b>SQL Statement:</b> ".$query."<br><b>SQL Error:</b> ".$mysqlError."<br><br>";
			echo "If this web interface was not changed, please send this information to info@stefan1200.de and describe what you did to get this error. Thank you in advance!<br><br>";
		}
		$sqlError_tmpl = implode(" ", file("templates/hpSQLError.tmpl"));
		$output = implode(" ", file("templates/index_maintenance.tmpl"));
		
		return str_replace('{content}', $sqlError_tmpl, $output);
	}
	
	function mysqlClose()
	{
		mysqli_close($this->link);
	}
}
?>
