<?PHP

require_once("include/formularfunctions.php");

function getBotCountArray($class_db)
{
	$botCount = array();
	$resBotCount = $class_db->db_query("SELECT user_id, COUNT(*) AS Bot_Count FROM jts3servermodwebui_usersinstances WHERE fullaccess = 1 GROUP BY user_id");
	while($row = mysqli_fetch_row($resBotCount))
	{
		$botCount[$row[0]] = $row[1];
	}
	
	return $botCount;
}

function getAdminLevelComboBoxDef($name, $default)
{
	global $translation;
	$formTranslation = $translation->getTranslationsForPage("formularfunctions");
	
	$formChooser = "<select name=\"".$name."\" id=\"".$name."\" size=\"1\" class=\"textinput\"".($_SESSION['adminlevel'] == 1 ? " disabled" : "").">\n";
	
	$formChooser = $formChooser."<option value=\"2\"".(2 == $default ? " selected" : "").">".$formTranslation['webui_yes']."</option>\n";
	$formChooser = $formChooser."<option value=\"1\"".(1 == $default ? " selected" : "").">".$formTranslation['webui_restricted']."</option>\n";
	$formChooser = $formChooser."<option value=\"0\"".(0 == $default ? " selected" : "").">".$formTranslation['webui_no']."</option>\n";
	
	return $formChooser."\n</select>\n";
}

function getFormular($class_db, $userid, $status = null, $generatedPassword = "")
{
	$useredittmpl = implode(" ", file("templates/useredit.tmpl"));
	
	$defaultMaxBotCount = -1;
	$resultDefaultMaxBotCount = $class_db->db_query("SELECT configvalue FROM jts3servermodwebui_settings WHERE configkey = 'webuisetting_defaultmaxbotcount'");
	if (mysqli_num_rows($resultDefaultMaxBotCount) == 1)
	{
		$defMaxBotCount = mysqli_fetch_row($resultDefaultMaxBotCount);
		if (is_numeric($defMaxBotCount[0])) $defaultMaxBotCount = $defMaxBotCount[0];
	}

	$configValues = array();
	if (is_numeric($userid) && $userid >= 1)
	{
		$resUserInfo = $class_db->db_query("SELECT name, email, adminlevel, userstatus, maxbotcount FROM jts3servermodwebui_users WHERE id = ".$userid);
		if (mysqli_num_rows($resUserInfo) == 1)
		{
			$configValues = mysqli_fetch_array($resUserInfo);
		}

		$useredittmpl = str_replace('{hide_on_add}', '', $useredittmpl);
		$useredittmpl = str_replace('{hide_on_edit}', ' hidden', $useredittmpl);
	}
	else
	{
		$useredittmpl = str_replace('{hide_on_add}', ' hidden', $useredittmpl);
		$useredittmpl = str_replace('{hide_on_edit}', '', $useredittmpl);
	}

	$useredittmpl = addStatusMessage($useredittmpl, $status);
	$useredittmpl = str_replace('{mode}', ($userid >= 1 ? "editUser" : "addUser"), $useredittmpl);
	$useredittmpl = str_replace('{userid}', $userid, $useredittmpl);
	$useredittmpl = str_replace('{webuiuser_name}', getTextInput("webuiuser_name", (isset($_POST['webuiuser_name']) ? $_POST['webuiuser_name'] : (isset($configValues['name']) ? $configValues['name'] : "")), -1, 50, false), $useredittmpl);
	$useredittmpl = str_replace('{webuiuser_email}', getTextInput("webuiuser_email", (isset($_POST['webuiuser_email']) ? $_POST['webuiuser_email'] : (isset($configValues['email']) ? $configValues['email'] : "")), -1, 50, false), $useredittmpl);
	$useredittmpl = str_replace('{webuiuser_password}', getPasswordInput("webuiuser_password", (isset($_POST['webuiuser_password']) ? $_POST['webuiuser_password'] : $generatedPassword), -1, 50), $useredittmpl);
	$useredittmpl = str_replace('{webuiuser_password2}', getPasswordInput("webuiuser_password2", (isset($_POST['webuiuser_password2']) ? $_POST['webuiuser_password2'] : $generatedPassword), -1, 50), $useredittmpl);
	$useredittmpl = str_replace('{webuiuser_maxbotcount}', getTextInput("webuiuser_maxbotcount", (isset($_POST['webuiuser_maxbotcount']) ? $_POST['webuiuser_maxbotcount'] : (isset($configValues['maxbotcount']) ? $configValues['maxbotcount'] : $defaultMaxBotCount)), 18, 30, true, -1, 32767), $useredittmpl);
	$useredittmpl = str_replace('{webuiuser_admin}', getAdminLevelComboBoxDef("webuiuser_admin", (isset($_POST['webuiuser_admin']) ? $_POST['webuiuser_admin'] : (isset($configValues['adminlevel']) ? $configValues['adminlevel'] : 0))), $useredittmpl);
	$useredittmpl = str_replace('{webuiuser_disabled}', getYesNoComboBoxDef("webuiuser_disabled", (isset($_POST['webuiuser_disabled']) ? $_POST['webuiuser_disabled'] : (isset($configValues['userstatus']) ? ($configValues['userstatus'] == -1 ? 1 : 0) : 0))), $useredittmpl);
	$useredittmpl = str_replace('{img_tick}', ((isset($_POST['webuiuser_emailnotification']) ? $_POST['webuiuser_emailnotification'] : "yes") == "no" ? " style=\"visibility:hidden;\"" : ""), $useredittmpl);
	$useredittmpl = str_replace('{webuiuser_emailnotification}', (isset($_POST['webuiuser_emailnotification']) ? $_POST['webuiuser_emailnotification'] : "yes"), $useredittmpl);

	return $useredittmpl;
}

function getUserDeleteTimeName($seconds)
{
	$retValue = "error";
	switch ($seconds)
	{
		case 259200: $retValue = "{webui_userlist_deletethreedays}"; break;
		case 604800: $retValue = "{webui_userlist_deleteoneweek}"; break;
		case 1209600: $retValue = "{webui_userlist_deletetwoweeks}"; break;
		case 2419200: $retValue = "{webui_userlist_deletemonth}"; break;
		case 4838400: $retValue = "{webui_userlist_deletetwomonths}"; break;
		default: $retValue = "error";
	}
	return $retValue;
}

function getUserDeleteTimeComboBox()
{
	$formChooser = "<select name=\"userinactivitytime\" size=\"1\" class=\"textinput\">\n";
	
	$formChooser = $formChooser."<option value=\"259200\">".getUserDeleteTimeName(259200)."</option>\n";
	$formChooser = $formChooser."<option value=\"604800\">".getUserDeleteTimeName(604800)."</option>\n";
	$formChooser = $formChooser."<option value=\"1209600\">".getUserDeleteTimeName(1209600)."</option>\n";
	$formChooser = $formChooser."<option value=\"2419200\">".getUserDeleteTimeName(2419200)."</option>\n";
	$formChooser = $formChooser."<option value=\"4838400\">".getUserDeleteTimeName(4838400)."</option>\n";
	
	return $formChooser."\n</select>\n";
}

require_once("class/PWHash.php");
$PWHash = new PWHash();

if (isset($_SESSION['adminlevel']) && is_numeric($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0)
{
	$status = null;
	if (isset($_GET['mode']) && $_GET['mode'] == "deleteUser" && $_SESSION['adminlevel'] > 1)
	{
		if (isset($_GET['userid']) && is_numeric($_GET['userid']))
		{
			$resUserName = $class_db->db_query("SELECT name FROM jts3servermodwebui_users WHERE id = ".$_GET['userid']);
			if (mysqli_num_rows($resUserName) == 1)
			{
				require_once("include/botdeleteownerfunctions.php");
				
				$botactions_visible = "block";
				$userBotListHTML = "";
				$userBotList = getUserBotsOnlyOneFullAccess($class_db, $_GET['userid']);
				foreach($userBotList as $userBot)
				{
					if (strlen($userBotListHTML) > 0)
						$userBotListHTML .= ", ";
					
					$userBotListHTML .= "<a href=\"index.php?page=botmanager&botID=".$userBot['id']."\" class=\"nounderline\">".$userBot['name']."</a>";
				}
				
				if ($userBotListHTML == "")
					$botactions_visible = "none";
				
				$curUserName = mysqli_fetch_array($resUserName);
				$deleteusertmpl = implode(" ", file("templates/useredit_delete.tmpl"));
				$deleteusertmpl = str_replace('{userid}', $_GET['userid'], $deleteusertmpl);
				$deleteusertmpl = str_replace('{username}', $curUserName[0], $deleteusertmpl);
				$deleteusertmpl = str_replace('{userbotlist}', $userBotListHTML, $deleteusertmpl);
				$deleteusertmpl = str_replace('{botactions_visible}', $botactions_visible, $deleteusertmpl);
				$deleteusertmpl = str_replace('{userchooser}', getUserListComboBoxDef("movebotstouserid", "-1", $class_db), $deleteusertmpl);
				$deleteusertmpl = $translation->replaceTranslationsForPage($deleteusertmpl, "formularfunctions");
				$for_output = $deleteusertmpl;
			}
			else
			{
				$status = "{webui_useredit_errorusernotexist}";
			}
		}
		else
		{
			$status = "{webui_useredit_errormissinguserid}";
		}
	}
	else if (isset($_GET['mode']) && $_GET['mode'] == "deleteUser" && $_SESSION['adminlevel'] < 2)
	{
		$status = "{webui_onlyadministrator}";
	}
	else if (isset($_POST['mode']) && $_POST['mode'] == "deleteUser" && $_SESSION['adminlevel'] > 1)
	{
		if (isset($_POST['userid']) && is_numeric($_POST['userid']) && isset($_POST['deletemode']))
		{
			if (isset($_POST['deleteYes']))
			{
				require_once("include/botdeleteownerfunctions.php");

				$deleteOK = false;
				if ($_POST['deletemode'] == "deletebots")
				{
					deleteAllBotsOfUser($class_db, $botTelnet, $_POST['userid']);
					$deleteOK = true;
				}
				else if ($_POST['deletemode'] == "changebotowner" && isset($_POST['movebotstouserid']) && is_numeric($_POST['movebotstouserid']))
				{
					if ($_POST['userid'] != $_POST['movebotstouserid'])
					{
						changeOwnerOfAllUserBots($class_db, $_POST['userid'], $_POST['movebotstouserid']);
						$deleteOK = true;
					}
				}

				if ($deleteOK)
				{
					$class_db->db_query("DELETE FROM jts3servermodwebui_users WHERE id = ".$_POST['userid']);
					$class_db->db_query("DELETE FROM jts3servermodwebui_usersinstances WHERE user_id = ".$_POST['userid']);
					$status = "{webui_successfullydeleted}";
				}
				else
				{
					$status = "{webui_useredit_errormissinginformations}";
				}
			}
			else
			{
				$status = "{webui_notdeleted}";
			}
		}
		else
		{
			$status = "{webui_useredit_errormissinginformations}";
		}
	}
	else if (isset($_POST['mode']) && $_POST['mode'] == "deleteUser" && $_SESSION['adminlevel'] < 2)
	{
		$status = "{webui_onlyadministrator}";
	}
	else if (isset($_GET['mode']) && $_GET['mode'] == "confirmdeleteinactiveusers" && $_SESSION['adminlevel'] > 1)
	{
		$inactivityTime = 259200;
		if (isset($_POST['userinactivitytime']) && is_numeric($_POST['userinactivitytime']))
			$inactivityTime = $_POST['userinactivitytime'];
		$inactivityTimestamp = time() - $inactivityTime;
		
		$userIDsArray = array();
		$userlist_content = "";
		$userlistrow_tmpl = implode(" ", file("templates/userlist_deleteinactiveusers_row.tmpl"));
		$userIcons = file("templates/userlist_icons.tmpl");
		
		$resListUsers = $class_db->db_query("SELECT `id`, `name`, `email`, `adminlevel`, `userstatus`, `lastvisit`, `registertime` FROM `jts3servermodwebui_users` WHERE `id` NOT IN (SELECT `user_id` FROM `jts3servermodwebui_usersinstances`) AND adminlevel = 0 AND `lastvisit` < ".$inactivityTimestamp." AND `registertime` < ".$inactivityTimestamp);
		
		if (mysqli_num_rows($resListUsers) > 0)
		{
			while($row = mysqli_fetch_row($resListUsers))
			{
				$userCurrent = $userIcons[3];
				if ($row[4] < 0)
				{
					$userCurrent = $userIcons[4];
				}
				else if ($row[3] > 1)
				{
					$userCurrent = $userIcons[0];
				}
				else if ($row[3] > 0)
				{
					$userCurrent = $userIcons[1];
				}
				
				$userlist_content .= $userlistrow_tmpl;
				$userlist_content = str_replace('{userid}', $row[0], $userlist_content);
				$userlist_content = str_replace('{username}', $row[1], $userlist_content);
				$userlist_content = str_replace('{useremail}', $row[2], $userlist_content);
				$userlist_content = str_replace('{userstate}', $userCurrent, $userlist_content);
				$userlist_content = str_replace('{registertime}', getFormattedTime($row[6], $translation), $userlist_content);
				$userlist_content = str_replace('{lastvisit}', getFormattedTime($row[5], $translation), $userlist_content);
				
				$userIDsArray[] = $row[0];
			}
		}
		else
		{
			$userlist_content = "<tr class=\"functionlist\"><td class=\"center\" colspan=\"6\">{webui_userlist_noinactiveusers}</td></tr>";
		}
		
		$for_output = implode(" ", file("templates/userlist_deleteinactiveusers.tmpl"));
		$for_output = str_replace('{currenttimeselection}', getUserDeleteTimeName($inactivityTime), $for_output);
		$for_output = str_replace('{content}', $userlist_content, $for_output);
		$for_output = str_replace('{userIDs}', implode(",", $userIDsArray), $for_output);
		$for_output = str_replace('{icon_userFullAdmin}', $userIcons[0], $for_output);
		$for_output = str_replace('{icon_userAdmin}', $userIcons[1], $for_output);
		$for_output = str_replace('{icon_userActive}', $userIcons[3], $for_output);
		$for_output = str_replace('{icon_userDisabled}', $userIcons[4], $for_output);
		$for_output = $translation->replaceTranslationsForPage($for_output, "formularfunctions");
	}
	else if (isset($_GET['mode']) && $_GET['mode'] == "confirmdeleteinactiveusers" && $_SESSION['adminlevel'] < 2)
	{
		$status = "{webui_onlyadministrator}";
	}
	else if (isset($_POST['mode']) && $_POST['mode'] == "deleteinactiveusers" && $_SESSION['adminlevel'] > 1)
	{
		if (isset($_POST['deleteYes']))
		{
			if (isset($_POST['userIDs']) && $_POST['userIDs'] != "")
			{
				$class_db->db_query("DELETE FROM jts3servermodwebui_users WHERE id IN (".$class_db->getRealEscapeString($_POST['userIDs']).")");
				$status = "{webui_successfullydeleted}";
			}
			else
				$status = "{webui_notdeleted}";
		}
		else
		{
			$status = "{webui_notdeleted}";
		}
	}
	else if (isset($_POST['mode']) && $_POST['mode'] == "deleteinactiveusers" && $_SESSION['adminlevel'] < 2)
	{
		$status = "{webui_onlyadministrator}";
	}
	else if (isset($_GET['mode']) && $_GET['mode'] == "addUser")
	{
		$for_output = getFormular($class_db, -1, null, getPassword(10));
	}
	else if (isset($_POST['mode']) && $_POST['mode'] == "addUser")
	{
		if (isset($_POST['webuiuser_name']) && isset($_POST['webuiuser_password']) && isset($_POST['webuiuser_email']) && isset($_POST['webuiuser_admin']) && isset($_POST['webuiuser_disabled']))
		{
			$errorMessage = "";
			if (strlen($_POST['webuiuser_email']) == 0 || !isEmailValid($_POST['webuiuser_email']))
			{
				$errorMessage .= "{webui_useredit_errorbademail}";
			}
			else if (doEmailExists($class_db, $_POST['webuiuser_email']))
			{
				$errorMessage .= "{webui_useredit_erroremailalreadyexists}";
			}

			if (strlen($_POST['webuiuser_name']) == 0 || !isNameValid($_POST['webuiuser_name']))
			{
				if ($errorMessage != "")
				{
					$errorMessage .= "<br>";
				}
				$errorMessage .= "{webui_useredit_errornamenotvalid}";
			}
			else if (doUsernameExists($class_db, $_POST['webuiuser_name']))
			{
				if ($errorMessage != "")
				{
					$errorMessage .= "<br>";
				}
				$errorMessage .= "{webui_useredit_errornamealreadyexists}";
			}

			if (strlen($_POST['webuiuser_password']) == 0 || !isPasswordValid($_POST['webuiuser_password']))
			{
				if ($errorMessage != "")
				{
					$errorMessage .= "<br>";
				}
				$errorMessage .= "{webui_useredit_errorpasswordnotvalid}";
			}
			else if ($_POST['webuiuser_password'] != $_POST['webuiuser_password2'])
			{
				if ($errorMessage != "")
				{
					$errorMessage .= "<br>";
				}
				$errorMessage .= "{webui_useredit_errorpasswordnotmatch}";
			}
			
			if (!is_numeric($_POST['webuiuser_maxbotcount']) || $_POST['webuiuser_maxbotcount'] < -1 || $_POST['webuiuser_maxbotcount'] > 32767)
			{
				if ($errorMessage != "")
				{
					$errorMessage .= "<br>";
				}
				$errorMessage .= $translation->getTranslation("webui_defaultmaxbotcount_error");
			}

			if ($errorMessage == "")
			{
				$pwsalt = $PWHash->createSalt();
				$class_db->db_query("INSERT INTO jts3servermodwebui_users (`name`, `password`, `salt`, `email`, `adminlevel`, `userstatus`, `registertime`, `maxbotcount`) VALUES ('".$class_db->getRealEscapeString($_POST['webuiuser_name'])."', '".$class_db->getRealEscapeString($PWHash->hashString($_POST['webuiuser_password'], $pwsalt))."', '".$pwsalt."', '".$class_db->getRealEscapeString($_POST['webuiuser_email'])."', '".($_SESSION['adminlevel'] > 1 ? $class_db->getRealEscapeString($_POST['webuiuser_admin']) : 0)."', '".$class_db->getRealEscapeString(($_POST['webuiuser_disabled'] == 1 ? "-1" : "0"))."', '".time()."', '".$class_db->getRealEscapeString($_POST['webuiuser_maxbotcount'])."')");
				$status = "{webui_useredit_useradded}";
				
				if ((isset($_POST['webuiuser_emailnotification']) ? $_POST['webuiuser_emailnotification'] : "no") == "yes")
				{
					$emailTranslation = $translation->getTranslationsForPage("newaccountemail", false);

					$message = implode("", file("templates/newaccount_email.tmpl"));
					$message = $translation->replaceAllKeys($message, $emailTranslation);
					$message = str_replace('{homepageurl}', "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'], $message);
					$message = str_replace('{username}', $_POST['webuiuser_name'], $message);
					$message = str_replace('{password}', $_POST['webuiuser_password'], $message);
					$mailResult = mail($_POST['webuiuser_email'], $emailTranslation['email_subject'], wordwrap($message, 80), "From: ".getReplyAddress($class_db)."\r\nContent-Type: text/plain; charset=UTF-8\r\n");
					
					if (!$mailResult)
						$status .= "\n".$translation->getTranslation("webui_contact_mailinternalerrorwhilesending");
				}
			}
			else
			{
				$for_output = getFormular($class_db, $_POST['userid'], $errorMessage);
			}
		}
		else
		{
			$for_output = getFormular($class_db, -1, "{webui_useredit_errormissinginformations}");
		}
	}
	else if (isset($_GET['mode']) && $_GET['mode'] == "editUser" && $_SESSION['adminlevel'] > 1)
	{
		if (isset($_GET['userid']) && is_numeric($_GET['userid']))
		{
			$doExists = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_users WHERE id = ".$_GET['userid']);
			if ($doExists[0] == 1)
			{
				$for_output = getFormular($class_db, $_GET['userid']);
			}
			else
			{
				$status = "{webui_useredit_errorusernotexist}";
			}
		}
		else
		{
			$status = "{webui_useredit_errormissinguserid}";
		}
	}
	else if (isset($_GET['mode']) && $_GET['mode'] == "editUser" && $_SESSION['adminlevel'] < 2)
	{
		$status = "{webui_onlyadministrator}";
	}
	else if (isset($_POST['mode']) && $_POST['mode'] == "editUser" && $_SESSION['adminlevel'] > 1)
	{
		if (isset($_POST['webuiuser_name']) && isset($_POST['webuiuser_password']) && isset($_POST['webuiuser_email']) && isset($_POST['webuiuser_admin']) && isset($_POST['webuiuser_disabled']) && isset($_POST['userid']) && is_numeric($_POST['userid']))
		{
			$errorMessage = "";
			$resUserInfo = $class_db->db_query("SELECT name, email FROM jts3servermodwebui_users WHERE id = ".$_POST['userid']);
			if (mysqli_num_rows($resUserInfo) == 1)
			{
				$curUserInfo = mysqli_fetch_array($resUserInfo);

				if (strlen($_POST['webuiuser_email']) == 0 || !isEmailValid($_POST['webuiuser_email']))
				{
					$errorMessage .= "{webui_useredit_errorbademail}";
				}
				else if ($curUserInfo[1] != $_POST['webuiuser_email'] && doEmailExists($class_db, $_POST['webuiuser_email']))
				{
					$errorMessage .= "{webui_useredit_erroremailalreadyexists}";
				}

				if (strlen($_POST['webuiuser_name']) == 0 || !isNameValid($_POST['webuiuser_name']))
				{
					if ($errorMessage != "")
					{
						$errorMessage .= "<br>";
					}
					$errorMessage .= "{webui_useredit_errornamenotvalid}";
				}
				else if ($curUserInfo[0] != $_POST['webuiuser_name'] && doUsernameExists($class_db, $_POST['webuiuser_name']))
				{
					if ($errorMessage != "")
					{
						$errorMessage .= "<br>";
					}
					$errorMessage .= "{webui_useredit_errornamealreadyexists}";
				}

				if (strlen($_POST['webuiuser_password']) > 0 && !isPasswordValid($_POST['webuiuser_password']))
				{
					if ($errorMessage != "")
					{
						$errorMessage .= "<br>";
					}
					$errorMessage .= "{webui_useredit_errorpasswordnotvalid}";
				}
				else if ($_POST['webuiuser_password'] != $_POST['webuiuser_password2'])
				{
					if ($errorMessage != "")
					{
						$errorMessage .= "<br>";
					}
					$errorMessage .= "{webui_useredit_errorpasswordnotmatch}";
				}
				
				if (!is_numeric($_POST['webuiuser_maxbotcount']) || $_POST['webuiuser_maxbotcount'] < -1 || $_POST['webuiuser_maxbotcount'] > 32767)
				{
					if ($errorMessage != "")
					{
						$errorMessage .= "<br>";
					}
					$errorMessage .= $translation->getTranslation("webui_defaultmaxbotcount_error");
				}
			}
			else
			{
				$errorMessage = "{webui_useredit_errorusernotexist}";
			}

			if ($errorMessage == "")
			{
				$pwsalt = $PWHash->createSalt();
				$class_db->db_query("UPDATE `jts3servermodwebui_users` SET `name` = '".$class_db->getRealEscapeString($_POST['webuiuser_name'])."'".(isset($_POST['webuiuser_password']) && strlen($_POST['webuiuser_password']) >= 8 ? ", `password` = '".$class_db->getRealEscapeString($PWHash->hashString($_POST['webuiuser_password'], $pwsalt))."', `salt` = '".$pwsalt."'" : "").", `email` = '".$class_db->getRealEscapeString($_POST['webuiuser_email'])."', `adminlevel` = '".$class_db->getRealEscapeString($_POST['webuiuser_admin'])."', `userstatus` = '".$class_db->getRealEscapeString(($_POST['webuiuser_disabled'] == 1 ? "-1" : "0"))."', `maxbotcount` = '".$class_db->getRealEscapeString($_POST['webuiuser_maxbotcount'])."' WHERE `id` = ".$_POST['userid']);
				$status = "{webui_useredit_useredited}";
			}
			else
			{
				$for_output = getFormular($class_db, $_POST['userid'], $errorMessage);
			}
		}
		else
		{
			$for_output = getFormular($class_db, $_POST['userid'], "{webui_useredit_errormissinginformations}");
		}
	}
	else if (isset($_POST['mode']) && $_POST['mode'] == "editUser" && $_SESSION['adminlevel'] < 2)
	{
		$status = "{webui_onlyadministrator}";
	}
	
	if ($for_output == "")
	{
		$sortarrows = file("templates/sortable_arrows.tmpl");
		
		$orderby = "name";
		$ordertype = "ASC";
		$orderby1next = 11;
		$orderby2next = 2;
		$orderby3next = 3;
		$imageorderby1 = $sortarrows[0];
		$imageorderby2 = "";
		$imageorderby3 = "";
		if (isset($_GET['orderby']) && is_numeric($_GET['orderby']))
		{
			if ($_GET['orderby'] == 11)
			{
				$orderby = "name";
				$ordertype = "DESC";
				$orderby1next = 1;
				$imageorderby1 = $sortarrows[1];
			}
			
			if ($_GET['orderby'] == 2)
			{
				$orderby = "registertime";
				$ordertype = "ASC";
				$orderby1next = 1;
				$orderby2next = 21;
				$imageorderby1 = "";
				$imageorderby2 = $sortarrows[0];
			}
			
			if ($_GET['orderby'] == 21)
			{
				$orderby = "registertime";
				$ordertype = "DESC";
				$orderby1next = 1;
				$orderby2next = 1;
				$imageorderby1 = "";
				$imageorderby2 = $sortarrows[1];
			}
			
			if ($_GET['orderby'] == 3)
			{
				$orderby = "lastvisit";
				$ordertype = "ASC";
				$orderby1next = 1;
				$orderby3next = 31;
				$imageorderby1 = "";
				$imageorderby3 = $sortarrows[0];
			}
			
			if ($_GET['orderby'] == 31)
			{
				$orderby = "lastvisit";
				$ordertype = "DESC";
				$orderby1next = 1;
				$orderby3next = 1;
				$imageorderby1 = "";
				$imageorderby3 = $sortarrows[1];
			}
		}
		
		$resListUsers = $class_db->db_query("SELECT id, name, email, adminlevel, userstatus, lastvisit, registertime FROM jts3servermodwebui_users ORDER BY ".$orderby." ".$ordertype);
		
		$userIcons = file("templates/userlist_icons.tmpl");
		
		if (mysqli_num_rows($resListUsers) > 0)
		{
			$for_output .= implode(" ", file("templates/userlist.tmpl"));
			$userlistentrytmpl = implode(" ", file("templates/userlist_entry.tmpl"));
			$userBotCount = getBotCountArray($class_db);
			
			$for_output = addStatusMessage($for_output, $status);
			$for_output = str_replace('{orderby1}', $orderby1next, $for_output);
			$for_output = str_replace('{orderby2}', $orderby2next, $for_output);
			$for_output = str_replace('{orderby3}', $orderby3next, $for_output);
			$for_output = str_replace('{image_orderby1}', $imageorderby1, $for_output);
			$for_output = str_replace('{image_orderby2}', $imageorderby2, $for_output);
			$for_output = str_replace('{image_orderby3}', $imageorderby3, $for_output);
			
			$userlistContent = "";
			while($row = mysqli_fetch_row($resListUsers))
			{
				$userCurrent = $userIcons[3];
				if ($row[4] < 0)
				{
					$userCurrent = $userIcons[4];
				}
				else if ($row[3] > 1)
				{
					$userCurrent = $userIcons[0];
				}
				else if ($row[3] > 0)
				{
					$userCurrent = $userIcons[1];
				}
				
				$userlistContent .= $userlistentrytmpl;
				$userlistContent = str_replace('{userstate}', $userCurrent, $userlistContent);
				$userlistContent = str_replace('{userid}', $row[0], $userlistContent);
				$userlistContent = str_replace('{username}', $row[1], $userlistContent);
				$userlistContent = str_replace('{useremail}', $row[2], $userlistContent);
				$userlistContent = str_replace('{registertime}', getFormattedTime($row[6], $translation), $userlistContent);
				$userlistContent = str_replace('{lastvisit}', getFormattedTime($row[5], $translation), $userlistContent);
				$userlistContent = str_replace('{botcount}', (isset($userBotCount[$row[0]]) ? $userBotCount[$row[0]] : 0), $userlistContent);
			}
			
			$for_output = str_replace('{icon_userFullAdmin}', $userIcons[0], $for_output);
			$for_output = str_replace('{icon_userAdmin}', $userIcons[1], $for_output);
			$for_output = str_replace('{icon_userActive}', $userIcons[3], $for_output);
			$for_output = str_replace('{icon_userDisabled}', $userIcons[4], $for_output);
			
			$for_output = str_replace('{userdeletetime}', getUserDeleteTimeComboBox(), $for_output);
			
			$for_output = str_replace('{userlistcontent}', $userlistContent, $for_output);
			$for_output = str_replace('{webui_botcount}', $translation->getTranslation("webui_botcount"), $for_output);
			$for_output = str_replace('{webui_delete}', $translation->getTranslation("webui_delete"), $for_output);
		}
	}
}
else
{
	$for_output = implode(" ", file("templates/backtomain.tmpl"));
	$for_output = str_replace('{title}', "{webui_userlist_title}", $for_output);
	$for_output = str_replace('{message}', "{webui_onlyadministrator}", $for_output);
}

$for_output = $translation->replaceTranslationsForPage($for_output, "userlist");

?>