<?PHP

$pageTranslation = $translation->getTranslationsForPage("settings", true, true);

require_once("include/formularfunctions.php");

function getCSSListComboBoxDef($name, $default)
{
	$formChooser = "<select name=\"".$name."\" id=\"".$name."\" size=\"1\" class=\"textinput\">\n";

	$cssFiles = scandir('data/css');

	foreach ($cssFiles as $file)
	{
		if ($file == "." || $file == "..")
			continue;
		
		$file = str_replace('.css', '', $file);
		
		$formChooser = $formChooser."<option value=\"".$file."\"".($file == $default ? " selected" : "").">".$file."</option>\n";
	}

	return $formChooser."\n</select>\n";
}

function getAllowContactComboBoxDef($name, $default)
{
	global $translation;
	$formTranslation = $translation->getTranslationsForPage("formularfunctions");
	
	$formChooser = "<select name=\"".$name."\" id=\"".$name."\" size=\"1\" class=\"textinput\">\n";
	
	$formChooser = $formChooser."<option value=\"1\"".(1 == $default ? " selected" : "").">".$formTranslation['webui_yes']."</option>\n";
	$formChooser = $formChooser."<option value=\"2\"".(2 == $default ? " selected" : "").">{webui_settings_afterlogin}</option>\n";
	$formChooser = $formChooser."<option value=\"0\"".(0 == $default ? " selected" : "").">".$formTranslation['webui_no']."</option>\n";
	
	return $formChooser."\n</select>\n";
}

function getFormular($class_db, $pageTranslation, $status = null)
{
	$resList = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermodwebui_settings");
	
	global $translation;
	$configValues = array();
	$defBotSet = false;
	
	while($row = mysqli_fetch_row($resList))
	{
		if ($row[0] == "defbotsetting_ts3_server_address")
		{
			$defBotSet = true;
		}
		
		$configValues[$row[0]] = $row[1];
	}

	$settingstmpl = implode(" ", file("templates/settings.tmpl"));
	$settingstmpl = addStatusMessage($settingstmpl, $status);
	$settingstmpl = str_replace('{webuisetting_defaulttimezone}', getTimezoneComboBoxDef("webuisetting_defaulttimezone", (isset($_POST['webuisetting_defaulttimezone']) ? $_POST['webuisetting_defaulttimezone'] : (isset($configValues['webuisetting_defaulttimezone']) ? $configValues['webuisetting_defaulttimezone'] : "")), true), $settingstmpl);
	$settingstmpl = str_replace('{webuisetting_defaultlanguage}', $translation->getLanguageBox("webuisetting_defaultlanguage"), $settingstmpl);
	$settingstmpl = str_replace('{webui_generalsettings_title}', $translation->getTranslation("webui_generalsettings_title"), $settingstmpl);
	$settingstmpl = str_replace('{webuisetting_themecss}', getCSSListComboBoxDef("webuisetting_themecss", (isset($_POST['webuisetting_themecss']) ? $_POST['webuisetting_themecss'] : (isset($configValues['webuisetting_themecss']) ? $configValues['webuisetting_themecss'] : "bright"))), $settingstmpl);
	$settingstmpl = str_replace('{webuisetting_allowlanguagechooser}', getYesNoComboBoxDef("webuisetting_allowlanguagechooser", (isset($_POST['webuisetting_allowlanguagechooser']) ? $_POST['webuisetting_allowlanguagechooser'] : (isset($configValues['webuisetting_allowlanguagechooser']) ? $configValues['webuisetting_allowlanguagechooser'] : 1))), $settingstmpl);
	$settingstmpl = str_replace('{webuisetting_allowcreatebot}', getYesNoComboBoxDef("webuisetting_allowcreatebot", (isset($_POST['webuisetting_allowcreatebot']) ? $_POST['webuisetting_allowcreatebot'] : (isset($configValues['webuisetting_allowcreatebot']) ? $configValues['webuisetting_allowcreatebot'] : 0))), $settingstmpl);
	$settingstmpl = str_replace('{webuisetting_defaultmaxbotcount}', getTextInput("webuisetting_defaultmaxbotcount", (isset($_POST['webuisetting_defaultmaxbotcount']) ? $_POST['webuisetting_defaultmaxbotcount'] : (isset($configValues['webuisetting_defaultmaxbotcount']) ? $configValues['webuisetting_defaultmaxbotcount'] : -1)), 18, 30, true, -1, 32767), $settingstmpl);
	$settingstmpl = str_replace('{webuisetting_allowregistration}', getYesNoComboBoxDef("webuisetting_allowregistration", (isset($_POST['webuisetting_allowregistration']) ? $_POST['webuisetting_allowregistration'] : (isset($configValues['webuisetting_allowregistration']) ? $configValues['webuisetting_allowregistration'] : 0))), $settingstmpl);
	$settingstmpl = str_replace('{webuisetting_replymailaddress}', getTextInput("webuisetting_replymailaddress", (isset($_POST['webuisetting_replymailaddress']) ? $_POST['webuisetting_replymailaddress'] : (isset($configValues['webuisetting_replymailaddress']) ? $configValues['webuisetting_replymailaddress'] : "donotreply@example.net")), 20, 50, false), $settingstmpl);
	$settingstmpl = str_replace('{webuisetting_allowcontact}', getAllowContactComboBoxDef("webuisetting_allowcontact", (isset($_POST['webuisetting_allowcontact']) ? $_POST['webuisetting_allowcontact'] : (isset($configValues['webuisetting_allowcontact']) ? $configValues['webuisetting_allowcontact'] : 0))), $settingstmpl);
	$settingstmpl = str_replace('{webuisetting_contactmailaddress}', getTextInput("webuisetting_contactmailaddress", (isset($_POST['webuisetting_contactmailaddress']) ? $_POST['webuisetting_contactmailaddress'] : (isset($configValues['webuisetting_contactmailaddress']) ? $configValues['webuisetting_contactmailaddress'] : "donotreply@example.net")), 20, 50, false), $settingstmpl);
	
	if ($defBotSet)
	{
		$settingstmpl = str_replace('{webuisetting_defaultbot}', $configValues['defbotsetting_ts3_server_address']." (id: ".$configValues['defbotsetting_ts3_virtualserver_id']." / port: ".$configValues['defbotsetting_ts3_virtualserver_port'].")<br><a href=\"index.php?page=settings&amp;mode=resetdefbot\">".$pageTranslation['webui_defaultbot_reset']."</a>", $settingstmpl);
	}
	else
	{
		$settingstmpl = str_replace('{webuisetting_defaultbot}', $pageTranslation['webui_defaultbot_none'], $settingstmpl);
	}

	$settingstmpl = str_replace('{webuisetting_welcomemessage}', getMultilineTextInput("webuisetting_welcomemessage", (isset($_POST['webuisetting_welcomemessage']) ? $_POST['webuisetting_welcomemessage'] : (isset($configValues['webuisetting_welcomemessage']) ? $configValues['webuisetting_welcomemessage'] : "Welcome!")), 10, 70), $settingstmpl);
	$settingstmpl = str_replace('{webuisetting_maintenancemode}', getYesNoComboBoxDef("webuisetting_maintenancemode", (isset($_POST['webuisetting_maintenancemode']) ? $_POST['webuisetting_maintenancemode'] : (isset($configValues['webuisetting_maintenancemode']) ? $configValues['webuisetting_maintenancemode'] : 0))), $settingstmpl);
	$settingstmpl = str_replace('{webuisetting_maintenancemodemessage}', getMultilineTextInput("webuisetting_maintenancemodemessage", (isset($_POST['webuisetting_maintenancemodemessage']) ? $_POST['webuisetting_maintenancemodemessage'] : (isset($configValues['webuisetting_maintenancemodemessage']) ? $configValues['webuisetting_maintenancemodemessage'] : "[title]Maintenance Mode[/title]\nMaintenance Mode enabled!")), 10, 70), $settingstmpl);
	
	$settingstmpl = str_replace('{bottelnet_address}', getTextInput("bottelnet_address", (isset($_POST['bottelnet_address']) ? $_POST['bottelnet_address'] : (isset($configValues['bottelnet_address']) ? $configValues['bottelnet_address'] : "")), 20, 50, false), $settingstmpl);
	$settingstmpl = str_replace('{bottelnet_port}', getTextInput("bottelnet_port", (isset($_POST['bottelnet_port']) ? $_POST['bottelnet_port'] : (isset($configValues['bottelnet_port']) ? $configValues['bottelnet_port'] : "5873")), 20, 50, true, 0, 65535), $settingstmpl);
	$settingstmpl = str_replace('{bottelnet_password}', getTextInput("bottelnet_password", (isset($_POST['bottelnet_password']) ? $_POST['bottelnet_password'] : (isset($configValues['bottelnet_password']) ? $configValues['bottelnet_password'] : "")), 20, 50, false), $settingstmpl);

	$botTelnetTest = new BotTelnet($class_db);
	$botTelnetTestResult = $botTelnetTest->doBotConnectTest();
	$settingstmpl = str_replace('{bottelnet_test}', $botTelnetTestResult, $settingstmpl);
	$settingstmpl = str_replace('{bottelnet_textcolorclass}', (substr($botTelnetTestResult, 0, strlen("{bottelnet_test_good}")) == "{bottelnet_test_good}" ? "textcolorgood" : "textcolorerror"), $settingstmpl);

	$settingstmpl = str_replace('{webui_systemdefault}', $translation->getTranslation("webui_systemdefault"), $settingstmpl);
	$settingstmpl = str_replace('{currenttimezone}', date_default_timezone_get(), $settingstmpl);
	
	return $settingstmpl;
}

if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1)
{
	if (isset($_GET['mode']) && $_GET['mode'] == "resetdefbot")
	{
		$class_db->db_query("DELETE FROM jts3servermodwebui_settings WHERE configkey LIKE \"defbotsetting_%\"");
		$for_output = implode(" ", file("templates/backtomain.tmpl"));
		$for_output = str_replace('{title}', "{webui_settings_title}", $for_output);
		$for_output = str_replace('{message}', "{webui_defbotdeleted}", $for_output);
	}
	else if (isset($_POST['SaveSettings']))
	{
		$errorMessage = "";
		$allOK = false;
		
		if (isset($_POST['webuisetting_defaultlanguage']) && isset($_POST['webuisetting_allowlanguagechooser']) && isset($_POST['webuisetting_allowcreatebot']) && isset($_POST['webuisetting_welcomemessage']) && isset($_POST['bottelnet_address']) && isset($_POST['bottelnet_port']) && isset($_POST['bottelnet_password']))
		{
			$allOK = true;
			
			if (!is_numeric($_POST['webuisetting_defaultlanguage']) || $_POST['webuisetting_defaultlanguage'] < 1 || $_POST['webuisetting_defaultlanguage'] > 99999999)
			{
				$errorMessage .= "{webui_defaultlanguage_error}<br>";
				$allOK = false;
			}
			
			if (!is_numeric($_POST['webuisetting_allowlanguagechooser']) || $_POST['webuisetting_allowlanguagechooser'] < 0 || $_POST['webuisetting_allowlanguagechooser'] > 1)
			{
				$errorMessage .= "{webui_allowlanguagechooser_error}<br>";
				$allOK = false;
			}
			
			if (!is_numeric($_POST['webuisetting_allowcreatebot']) || $_POST['webuisetting_allowcreatebot'] < 0 || $_POST['webuisetting_allowcreatebot'] > 1)
			{
				$errorMessage .= "{webui_allowcreatebot_error}<br>";
				$allOK = false;
			}
			
			if (!is_numeric($_POST['webuisetting_defaultmaxbotcount']) || $_POST['webuisetting_defaultmaxbotcount'] < -1 || $_POST['webuisetting_defaultmaxbotcount'] > 32767)
			{
				$errorMessage .= "{webui_defaultmaxbotcount_error}<br>";
				$allOK = false;
			}

			if (!is_numeric($_POST['webuisetting_allowregistration']) || $_POST['webuisetting_allowregistration'] < 0 || $_POST['webuisetting_allowregistration'] > 1)
			{
				$errorMessage .= "{webui_allowregistration_error}<br>";
				$allOK = false;
			}
			
			if (!is_numeric($_POST['bottelnet_port']) || $_POST['bottelnet_port'] < 0 || $_POST['bottelnet_port'] > 65535)
			{
				$errorMessage .= "{webui_bottelnet_port_error}<br>";
				$allOK = false;
			}
			
			if (!file_exists("data/css/".$_POST['webuisetting_themecss'].".css"))
			{
				$errorMessage .= "{webui_themecss_error}<br>";
				$allOK = false;
			}
			
			if ($allOK)
			{
				$class_db->db_query("DELETE FROM jts3servermodwebui_settings WHERE `configkey` LIKE \"bottelnet_%\" OR `configkey` LIKE \"webuisetting_%\"");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_themecss', '".$class_db->getRealEscapeString($_POST['webuisetting_themecss'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_defaulttimezone', '".$class_db->getRealEscapeString($_POST['webuisetting_defaulttimezone'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_defaultlanguage', '".$class_db->getRealEscapeString($_POST['webuisetting_defaultlanguage'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_allowlanguagechooser', '".$class_db->getRealEscapeString($_POST['webuisetting_allowlanguagechooser'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_allowcreatebot', '".$class_db->getRealEscapeString($_POST['webuisetting_allowcreatebot'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_defaultmaxbotcount', '".$class_db->getRealEscapeString($_POST['webuisetting_defaultmaxbotcount'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_allowregistration', '".$class_db->getRealEscapeString($_POST['webuisetting_allowregistration'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_replymailaddress', '".$class_db->getRealEscapeString($_POST['webuisetting_replymailaddress'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_allowcontact', '".$class_db->getRealEscapeString($_POST['webuisetting_allowcontact'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_contactmailaddress', '".$class_db->getRealEscapeString($_POST['webuisetting_contactmailaddress'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_welcomemessage', '".$class_db->getRealEscapeString($_POST['webuisetting_welcomemessage'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_maintenancemode', '".$class_db->getRealEscapeString($_POST['webuisetting_maintenancemode'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('webuisetting_maintenancemodemessage', '".$class_db->getRealEscapeString($_POST['webuisetting_maintenancemodemessage'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('bottelnet_address', '".$class_db->getRealEscapeString($_POST['bottelnet_address'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('bottelnet_port', '".$class_db->getRealEscapeString($_POST['bottelnet_port'])."')");
				$class_db->db_query("INSERT INTO jts3servermodwebui_settings (`configkey`, `configvalue`) VALUES ('bottelnet_password', '".$class_db->getRealEscapeString($_POST['bottelnet_password'])."')");
				
				$class_db->db_query("ALTER TABLE `jts3servermodwebui_users` CHANGE `maxbotcount` `maxbotcount` SMALLINT(6) NOT NULL DEFAULT '".$class_db->getRealEscapeString($_POST['webuisetting_defaultmaxbotcount'])."'");
				
				$errorMessage = "{webui_settingssaved}";
			}
		}
		else
		{
			$errorMessage = "{webui_settingsmissingvalues}";
			$allOK = false;
		}
		
		$for_output = getFormular($class_db, $pageTranslation, $errorMessage.($allOK ? "" : "<br>{webui_settingsnotsaved}"));
	}
	else
	{
		$for_output = getFormular($class_db, $pageTranslation);
	}
}
else
{
	$for_output = implode(" ", file("templates/backtomain.tmpl"));
	$for_output = str_replace('{title}', "{webui_settings_title}", $for_output);
	$for_output = str_replace('{message}', "{webui_onlyadministrator}", $for_output);
}

$for_output = $translation->replaceAllKeys($for_output, $pageTranslation);

?>