<?php

require_once("include/formularfunctions.php");

function getFormularRegister($status = null)
{
	$registertmpl = implode(" ", file("templates/register.tmpl"));
	$registertmpl = addStatusMessage($registertmpl, $status);
	$registertmpl = str_replace('{webuiuser_name}', getTextInput("webuiuser_name", (isset($_POST['webuiuser_name']) ? $_POST['webuiuser_name'] : ""), -1, 50, false), $registertmpl);
	$registertmpl = str_replace('{webuiuser_email}', getTextInput("webuiuser_email", (isset($_POST['webuiuser_email']) ? $_POST['webuiuser_email'] : ""), -1, 50, false), $registertmpl);

	return $registertmpl;
}

function getFormularChangePW($userid, $status = null)
{
	$pwchangetmpl = implode(" ", file("templates/pwchange.tmpl"));
	$pwchangetmpl = addStatusMessage($pwchangetmpl, $status);
	$pwchangetmpl = str_replace('{userid}', $userid, $pwchangetmpl);

	return $pwchangetmpl;
}


require_once("class/PWHash.php");
$PWHash = new PWHash();

if (isset($_GET['mode']) && $_GET['mode'] == "resetpw")
{
	if (isset($_GET['key']))
	{
		$doExists = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_users WHERE resetkey = '".$class_db->getRealEscapeString($_GET['key'])."'");
		if ($doExists[0] == 1)
		{
			$pwresettmpl = implode(" ", file("templates/resetpw_confirm.tmpl"));
			$pwresettmpl = str_replace('{key}', $_GET['key'], $pwresettmpl);
			$for_output = $pwresettmpl;
		}
		else
		{
			$for_output = implode(" ", file("templates/backtomain.tmpl"));
			$for_output = str_replace('{title}', "{webui_resetpw_title}", $for_output);
			$for_output = str_replace('{message}', "{webui_error_invalidkey}", $for_output);
		}
	}
	else
	{
		$pwresettmpl = implode(" ", file("templates/resetpw.tmpl"));
		$pwresettmpl = str_replace('{webui_send}', $translation->getTranslation("webui_send"), $pwresettmpl);
		$for_output = $pwresettmpl;
	}
}
else if (isset($_GET['mode']) && $_GET['mode'] == "changepw")
{
	if ($userid <= 0)
	{
		$for_output = implode(" ", file("templates/backtomain.tmpl"));
		$for_output = str_replace('{title}', "{webui_changepw_title}", $for_output);
		$for_output = str_replace('{message}', "{webui_error_useridvalue}", $for_output);
	}
	else
	{
		$doExists = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_users WHERE id = ".$userid);
		if ($doExists[0] == 1)
		{
			$for_output = getFormularChangePW($userid);
		}
		else
		{
			$for_output = implode(" ", file("templates/backtomain.tmpl"));
			$for_output = str_replace('{title}', "{webui_changepw_title}", $for_output);
			$for_output = str_replace('{message}', "{webui_error_useridvalue}", $for_output);
		}
	}
}
else if (isset($_GET['mode']) && $_GET['mode'] == "privacy")
{
	$for_output = implode(" ", file("templates/register_privacy.tmpl"));
}
else if (isset($_POST['mode']) && $_POST['mode'] == "resetpw")
{
	if (isset($_POST['key']) && strlen($_POST['key']) > 11)
	{
		if (isset($_POST['deleteYes']))
		{
			$resInfo = $class_db->db_query("SELECT id, name, email FROM jts3servermodwebui_users WHERE resetkey = '".$class_db->getRealEscapeString($_POST['key'])."'");
			if (mysqli_num_rows($resInfo) == 1)
			{
				$userInfo = mysqli_fetch_array($resInfo);

				$generatedPassword = getPassword(10);
				$pwsalt = $PWHash->createSalt();
				$class_db->db_query("UPDATE `jts3servermodwebui_users` SET `password` = '".$class_db->getRealEscapeString($PWHash->hashString($generatedPassword, $pwsalt))."', `salt` = '".$pwsalt."', `resetkey` = '' WHERE `id` = ".$userInfo[0]);

				$emailTranslation = $translation->getTranslationsForPage("pwchangeemail", false);

				$message = implode("", file("templates/pwchange_email.tmpl"));
				$message = $translation->replaceAllKeys($message, $emailTranslation);
				$message = str_replace('{homepageurl}', "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'], $message);
				$message = str_replace('{username}', $userInfo[1], $message);
				$message = str_replace('{password}', $generatedPassword, $message);
				$mailResult = mail($userInfo[2], $emailTranslation['email_subject'], wordwrap($message, 80), "From: ".getReplyAddress($class_db)."\r\nContent-Type: text/plain; charset=UTF-8\r\n");

				$for_output = implode(" ", file("templates/backtomain.tmpl"));
				$for_output = str_replace('{title}', "{webui_resetpw_title}", $for_output);
				$for_output = str_replace('{message}', ($mailResult ? "{webui_newpwemailsend}" : "{webui_contact_mailinternalerrorwhilesending}"), $for_output);
			}
			else
			{
				$for_output = implode(" ", file("templates/backtomain.tmpl"));
				$for_output = str_replace('{title}', "{webui_resetpw_title}", $for_output);
				$for_output = str_replace('{message}', "{webui_error_invalidkey}", $for_output);
			}
		}
		else
		{
			$resInfo = $class_db->db_query("SELECT id FROM jts3servermodwebui_users WHERE resetkey = '".$class_db->getRealEscapeString($_POST['key'])."'");
			if (mysqli_num_rows($resInfo) == 1)
			{
				$userInfo = mysqli_fetch_array($resInfo);
				$class_db->db_query("UPDATE jts3servermodwebui_users SET `resetkey` = '' WHERE id = ".$userInfo[0]);
			}
			
			$for_output = implode(" ", file("templates/backtomain.tmpl"));
			$for_output = str_replace('{title}', "{webui_resetpw_title}", $for_output);
			$for_output = str_replace('{message}', "{webui_resetpwaborted}", $for_output);
		}
	}
	else if (isset($_POST['key']))
	{
		$for_output = implode(" ", file("templates/backtomain.tmpl"));
		$for_output = str_replace('{title}', "{webui_resetpw_title}", $for_output);
		$for_output = str_replace('{message}', "{webui_error_invalidkey}", $for_output);
	}
	else
	{
		$resInfo = $class_db->db_query("SELECT id, name, lastresetrequest FROM jts3servermodwebui_users WHERE email = '".$class_db->getRealEscapeString($_POST['email'])."'");
		if (mysqli_num_rows($resInfo) == 1)
		{
			$userInfo = mysqli_fetch_array($resInfo);
			
			if ($userInfo[2] != 0 && (time() - $userInfo[2]) < 600)
			{
				$for_output = implode(" ", file("templates/backtomain.tmpl"));
				$for_output = str_replace('{title}', "{webui_resetpw_title}", $for_output);
				$for_output = str_replace('{message}', "{webui_pwresetspam}", $for_output);
			}
			else
			{
				$newkey = sha1(time().getPassword(10));

				$class_db->db_query("UPDATE `jts3servermodwebui_users` SET `resetkey` = '".$class_db->getRealEscapeString($newkey)."', `lastresetrequest` = '".time()."' WHERE `id` = ".$userInfo[0]);

				$emailTranslation = $translation->getTranslationsForPage("resetpwemail", false);

				$message = implode("", file("templates/resetpw_email.tmpl"));
				$message = $translation->replaceAllKeys($message, $emailTranslation);
				$message = str_replace('{homepageurl}', "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'], $message);
				$message = str_replace('{newkey}', $newkey, $message);
				$message = str_replace('{username}', $userInfo[1], $message);
				$mailResult = mail($_POST['email'], $emailTranslation['email_subject'], wordwrap($message, 80), "From: ".getReplyAddress($class_db)."\r\nContent-Type: text/plain; charset=UTF-8\r\n");

				$for_output = implode(" ", file("templates/backtomain.tmpl"));
				$for_output = str_replace('{title}', "{webui_resetpw_title}", $for_output);
				$for_output = str_replace('{message}', ($mailResult ? "{webui_resetemailsend}" : "{webui_contact_mailinternalerrorwhilesending}"), $for_output);
			}
		}
		else
		{
			$for_output = implode(" ", file("templates/backtomain.tmpl"));
			$for_output = str_replace('{title}', "{webui_resetpw_title}", $for_output);
			$for_output = str_replace('{message}', "{webui_error_invalidemail}", $for_output);
		}
	}
}
else if (isset($_POST['mode']) && $_POST['mode'] == "changepw")
{
	$resInfo = $class_db->db_query("SELECT password, name, email, salt FROM jts3servermodwebui_users WHERE id = ".$userid);
	if (mysqli_num_rows($resInfo) == 1)
	{
		$userInfo = mysqli_fetch_array($resInfo);

		if ($PWHash->hashString($_POST['currentpassword'], $userInfo[3]) == $userInfo[0])
		{
			if ($_POST['newpassword'] == $_POST['newpassword2'])
			{
				if (strlen($_POST['newpassword']) == 0 || !isPasswordValid($_POST['newpassword']))
				{
					$for_output = getFormularChangePW($userid, "{webui_useredit_errorpasswordnotvalid}");
				}
				else
				{
					$pwsalt = $PWHash->createSalt();
					$class_db->db_query("UPDATE `jts3servermodwebui_users` SET `password` = '".$class_db->getRealEscapeString($PWHash->hashString($_POST['newpassword'], $pwsalt))."', `salt` = '".$pwsalt."' WHERE `id` = ".$userid);

					$emailTranslation = $translation->getTranslationsForPage("pwchangeemail", false);

					$message = implode("", file("templates/pwchange_email.tmpl"));
					$message = $translation->replaceAllKeys($message, $emailTranslation);
					$message = str_replace('{homepageurl}', "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'], $message);
					$message = str_replace('{username}', $userInfo[1], $message);
					$message = str_replace('{password}', $_POST['newpassword'], $message);
					$mailResult = mail($userInfo[2], $emailTranslation['email_subject'], wordwrap($message, 80), "From: ".getReplyAddress($class_db)."\r\nContent-Type: text/plain; charset=UTF-8\r\n");

					$for_output = implode(" ", file("templates/backtomain.tmpl"));
					$for_output = str_replace('{title}', "{webui_changepw_title}", $for_output);
					$for_output = str_replace('{message}', "{webui_passwordchanged}".($mailResult ? "" : "\n{webui_contact_mailinternalerrorwhilesending}"), $for_output);
				}
			}
			else
			{
				$for_output = getFormularChangePW($userid, "{webui_error_newpasswordnotmatch}");
			}
		}
		else
		{
			$for_output = getFormularChangePW($userid, "{webui_error_passwordwrong}");
		}
	}
	else
	{
		$for_output = implode(" ", file("templates/backtomain.tmpl"));
		$for_output = str_replace('{title}', "{webui_changepw_title}", $for_output);
		$for_output = str_replace('{message}', "{webui_error_useridvalue}", $for_output);
	}
}
else if (isset($_POST['mode']) && $_POST['mode'] == "register")
{
	$allowRegistration = false;
	$resultRegistration = $class_db->db_query("SELECT configvalue FROM jts3servermodwebui_settings WHERE configkey = 'webuisetting_allowregistration'");
	if (mysqli_num_rows($resultRegistration) == 1)
	{
		$allowReg = mysqli_fetch_array($resultRegistration);
		$allowRegistration = ($allowReg[0] == 1);
	}
	
	if ($allowRegistration)
	{
		if (isset($_POST['webuiuser_name']) && isset($_POST['webuiuser_email']) && isset($_POST['accept_privacyinfo']))
		{
			$errorMessage = "";
			if (strlen($_POST['webuiuser_email']) == 0 || !isEmailValid($_POST['webuiuser_email']) || containsHTMLCode($_POST['webuiuser_email']))
			{
				$errorMessage .= "{webui_useredit_errorbademail}";
				$_POST['webuiuser_email'] = "";
			}
			else if (doEmailExists($class_db, $_POST['webuiuser_email']))
			{
				$errorMessage .= "{webui_useredit_erroremailalreadyexists}";
			}

			if (strlen($_POST['webuiuser_name']) == 0 || !isNameValid($_POST['webuiuser_name']))
			{
				if ($errorMessage != "")
				{
					$errorMessage .= "<br>";
				}
				$errorMessage .= "{webui_useredit_errornamenotvalid}";
				$_POST['webuiuser_name'] = "";
			}
			else if (doUsernameExists($class_db, $_POST['webuiuser_name']))
			{
				if ($errorMessage != "")
				{
					$errorMessage .= "<br>";
				}
				$errorMessage .= "{webui_useredit_errornamealreadyexists}";
			}
			
			if ($_POST['accept_privacyinfo'] != "yes")
			{
				$errorMessage .= "{webui_register_privacyinfonotaccepted}";
			}
			
			if (!isset($_POST['question']) || $_POST['question'] != "")
			{
				if ($errorMessage != "")
				{
					$errorMessage .= "<br>";
				}
				$errorMessage .= "Unknown error while registration, please contact the website administrator.";
			}

			if ($errorMessage == "")
			{
				$generatedPassword = getPassword(10);
				$pwsalt = $PWHash->createSalt();
				$class_db->db_query("INSERT INTO jts3servermodwebui_users (`name`, `password`, `salt`, `email`, `adminlevel`, `userstatus`, `registertime`) VALUES ('".$class_db->getRealEscapeString($_POST['webuiuser_name'])."', '".$class_db->getRealEscapeString($PWHash->hashString($generatedPassword, $pwsalt))."', '".$pwsalt."', '".$class_db->getRealEscapeString($_POST['webuiuser_email'])."', '0', '0', '".time()."')");

				$emailTranslation = $translation->getTranslationsForPage("registeremail", false);

				$message = implode("", file("templates/register_email.tmpl"));
				$message = $translation->replaceAllKeys($message, $emailTranslation);
				$message = str_replace('{homepageurl}', "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'], $message);
				$message = str_replace('{username}', $_POST['webuiuser_name'], $message);
				$message = str_replace('{password}', $generatedPassword, $message);
				$mailResult = mail($_POST['webuiuser_email'], $emailTranslation['email_subject'], wordwrap($message, 80), "From: ".getReplyAddress($class_db)."\r\nContent-Type: text/plain; charset=UTF-8\r\n");

				$for_output = implode(" ", file("templates/backtomain.tmpl"));
				$for_output = str_replace('{title}', "{webui_register_title}", $for_output);
				$for_output = str_replace('{message}', "{webui_registrationsuccessful}".($mailResult ? "" : "\n{webui_contact_mailinternalerrorwhilesending}"), $for_output);
			}
			else
			{
				$for_output = getFormularRegister($errorMessage);
			}
		}
		else
		{
			$for_output = getFormularRegister("{webui_useredit_errormissinginformations}");
		}
	}
	else
	{
		$for_output = implode(" ", file("templates/backtomain.tmpl"));
		$for_output = str_replace('{title}', "{webui_register_title}", $for_output);
		$for_output = str_replace('{message}', "{webui_error_registernotallowed}", $for_output);
	}
}
else
{
	$allowRegistration = false;
	$resultRegistration = $class_db->db_query("SELECT configvalue FROM jts3servermodwebui_settings WHERE configkey = 'webuisetting_allowregistration'");
	if (mysqli_num_rows($resultRegistration) == 1)
	{
		$allowReg = mysqli_fetch_array($resultRegistration);
		$allowRegistration = ($allowReg[0] == 1);
	}
	
	if ($allowRegistration)	$for_output = getFormularRegister();
	else
	{
		$for_output = implode(" ", file("templates/backtomain.tmpl"));
		$for_output = str_replace('{title}', "{webui_register_title}", $for_output);
		$for_output = str_replace('{message}', "{webui_error_registernotallowed}", $for_output);
	}
}

$for_output = str_replace('{webui_contact_mailinternalerrorwhilesending}', $translation->getTranslation("webui_contact_mailinternalerrorwhilesending"), $for_output);
$for_output = $translation->replaceTranslationsForPage($for_output, "userlist");
$for_output = $translation->replaceTranslationsForPage($for_output, "register");
$for_output = $translation->replaceTranslationsForPage($for_output, "formularfunctions");

?>
