<?PHP

// Returns: 1 = bot creation allowed / 0 = bot creation not allowed / -1 = max bot count reached
function isBotCreateAllowed($class_db, $botID)
{
	$allowCreateBot = 0;
	$resultAllowCreateBot = $class_db->db_query("SELECT configvalue FROM jts3servermodwebui_settings WHERE configkey = 'webuisetting_allowcreatebot'");
	if (mysqli_num_rows($resultAllowCreateBot) == 1)
	{
		$allowCB = mysqli_fetch_row($resultAllowCreateBot);
		$allowCreateBot = $allowCB[0];
	}
	
	$userid = -1;
	if (isset($_SESSION['userid']) && is_numeric($_SESSION['userid']))
	{
		$userid = $_SESSION['userid'];
	}
	
	if ($allowCreateBot == 1 && $botID >= 0)
	{
		$isValid = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE user_id = ".$userid." AND instance_id = ".$botID." AND fullaccess = TRUE");
		if ($isValid[0] == 1)
		{
			$allowCreateBot = 1;
		}
		else
		{
			$allowCreateBot = 0;
		}
	}
	
	if ($allowCreateBot == 1 && $botID < 0 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 1))
	{
		$maxBotCount = -1;
		$resultMaxBotCount = $class_db->db_query("SELECT maxbotcount FROM jts3servermodwebui_users WHERE id = '".$userid."'");
		if (mysqli_num_rows($resultMaxBotCount) == 1)
		{
			$maxBotCount_temp = mysqli_fetch_row($resultMaxBotCount);
			if (is_numeric($maxBotCount_temp[0])) $maxBotCount = $maxBotCount_temp[0];
		}
		
		$botCount = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE user_id = ".$userid);
		if ($maxBotCount >= 0 && $botCount[0] >= $maxBotCount)
		{
			$allowCreateBot = -1;
		}
		else
		{
			$allowCreateBot = 1;
		}
	}

	return $allowCreateBot;
}

function getMultilineTextInput($name, $value, $rows, $cols, $bbcodeAllowed = true, $countChars = true)
{
	$inputClass = " small";
	if ($cols < 0)
		$inputClass = " fixed";
	else if ($cols > 30)
		$inputClass = " big";
	
	if ($bbcodeAllowed)
	{
		$bbedit = implode(" ", file("templates/bbedit.tmpl"));
		$bbedit = str_replace('{textareaName}',$name,$bbedit);
	}
	
	if ($countChars)
		global $translation;
	
	return ($bbcodeAllowed ? $bbedit : "")."<textarea name=\"".$name."\" id=\"".$name."\" rows=\"".$rows."\" class=\"textinput".$inputClass."\"".($countChars ? " onkeyup=\"showCharCount(this, '".$name."_count');\"" : "").">".returnSafeHTML($value, false)."</textarea>\n".($countChars ? "<div id=\"".$name."_count_div\" style=\"display:none\">".$translation->getTranslation("webui_textlength")." <span id=\"".$name."_count\">0</span></div>\n" : "");
}

function getYesNoComboBoxDef($name, $default, $yesValue = 1, $noValue = 0)
{
	global $translation;
	$formTranslation = $translation->getTranslationsForPage("formularfunctions");
	
	$formChooser = "<select name=\"".$name."\" id=\"".$name."\" size=\"1\" class=\"textinput\">\n";
	
	$formChooser = $formChooser."<option value=\"".$yesValue."\"".($yesValue == $default ? " selected" : "").">".$formTranslation['webui_yes']."</option>\n";
	$formChooser = $formChooser."<option value=\"".$noValue."\"".($noValue == $default ? " selected" : "").">".$formTranslation['webui_no']."</option>\n";
	
	return $formChooser."\n</select>\n";
}

function getUserListComboBoxDef($name, $default, $class_db)
{
	$formChooser = "<select name=\"".$name."\" id=\"".$name."\" size=\"1\" class=\"textinput\">\n";

	$resListUsers = $class_db->db_query("SELECT id, name FROM jts3servermodwebui_users ORDER BY name");

	while($row = mysqli_fetch_row($resListUsers))
	{
		$formChooser = $formChooser."<option value=\"".$row[0]."\"".($row[0] == $default ? " selected" : "").">".$row[1]."</option>\n";
	}

	return $formChooser."\n</select>\n";
}

function getTextInput($name, $value, $size, $maxsize, $checkNumber = false, $minValue = 0, $maxValue = 99, $readonly = false)
{
	$inputClass = " small";
	if ($size <= -100)
		$inputClass = " fixed300";
	else if ($size < 0)
		$inputClass = " fixed";
	else if ($size > 30)
		$inputClass = " big";
	
	return "<input type=\"text\" name=\"".$name."\" id=\"".$name."\" value=\"".returnSafeHTML($value)."\" maxlength=\"".$maxsize."\" class=\"textinput".$inputClass."\"".($checkNumber ? " onkeyup=\"checkNumber(this, ".$minValue.", ".$maxValue.");\"" : "").($readonly ? " readonly" : "")."></input>\n";
}

function getPasswordInput($name, $value, $size, $maxsize)
{
	$inputClass = " small";
	if ($size < 0)
		$inputClass = " fixed";
	else if ($size > 30)
		$inputClass = " big";
	
	return "<input type=\"password\" name=\"".$name."\" id=\"".$name."\" value=\"".$value."\" maxlength=\"".$maxsize."\" class=\"textinput".$inputClass."\"></input>\n";
}

function isNameValid($username)
{
	if (preg_match("/^[a-zA-Z0-9_\-]{3,30}$/", $username))
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

function containsHTMLCode($string)
{
	if (preg_match("/^.*[\<\>\&].*$/", $string))
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

// Converts < > & " to HTML
function returnSafeHTML($string, $encodeQuotes = true)
{
	if ($encodeQuotes)
		return htmlspecialchars($string, ENT_QUOTES, "UTF-8");
	else
		return htmlspecialchars($string, ENT_NOQUOTES, "UTF-8");
}

function isEmailValid($email)
{
	if (preg_match("/^.+@.+\..+$/", $email))
	{
		if (strpos($email, " ") === false)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		return FALSE;
	}
}

function isPasswordValid($password)
{
	if (preg_match("/^[a-zA-Z0-9+_\-#!?.]{8,30}$/", $password))
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

function doEmailExists($class_db, $email)
{
	$doExists = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_users WHERE email = '".$class_db->getRealEscapeString($email)."'");

	return ($doExists[0] >= 1);
}

function doUsernameExists($class_db, $username)
{
	$doExists = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_users WHERE name = '".$class_db->getRealEscapeString($username)."'");

	return ($doExists[0] >= 1);
}

function getFormattedTime($timestamp, $translation)
{
	if ($timestamp < 87000)
	{
		return "-";
	}
	else
	{
		return $translation->getDate($timestamp);
	}
}

function addStatusMessage($tmpl, $status = null)
{
	$tmpl = str_replace('{statusmsg}', ($status == null ? "" : $status), $tmpl);
	$tmpl = str_replace('{statusdisplay}', ($status == null ? "none" : "block"), $tmpl);
	return $tmpl;
}

function getReplyAddress($class_db)
{
	$replyEmailAddress = "donotreply@example.net";
	$resultReplyEmailAddress = $class_db->db_query("SELECT configvalue FROM jts3servermodwebui_settings WHERE configkey = 'webuisetting_replymailaddress'");
	if (mysqli_num_rows($resultReplyEmailAddress) == 1)
	{
		$replyEA = mysqli_fetch_array($resultReplyEmailAddress);
		if (strlen($replyEA[0]) > 5) $replyEmailAddress = $replyEA[0];
	}
	return $replyEmailAddress;
}

function getPassword($length)
{
	$abc = "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,0,1,2,3,4,5,6,7,8,9";
	$abcarray = explode(",",$abc);
	mt_srand((double)microtime()*1000000);
	$generatedPassword = "";
	$arraysize = sizeof($abcarray) - 1;

	for ($i=1;$i<=$length;$i++)
	{
		$random = mt_rand(0,$arraysize);
		$generatedPassword .= $abcarray[$random];
	}
	
	return $generatedPassword;
}

function getTimezoneArray()
{
	$timezones = DateTimeZone::listAbbreviations();

	$cities = array();
	foreach($timezones as $key => $zones)
	{
		foreach($zones as $id => $zone)
		{
			/**
			 * Only get timezones explicitely not part of "Others".
			 * @see http://www.php.net/manual/en/timezones.others.php
			 */
			if (preg_match('/^(America|Antartica|Arctic|Asia|Atlantic|Europe|Indian|Pacific)\//', $zone['timezone_id']))
				$cities[] = $zone['timezone_id'];
		}
	}

	// Only keep one city.
	$cities = array_unique($cities);

	// Sort by area/city name.
	sort($cities);
	
	return $cities;
}

function getTimezoneComboBoxDef($name, $default, $allowNoSelection = false)
{
	$formChooser = "<select name=\"".$name."\" id=\"".$name."\" size=\"1\" class=\"textinput\">\n";

	$timezoneArray = getTimezoneArray();
	
	if ($allowNoSelection)
		$formChooser = $formChooser."<option value=\"\"".("" == $default ? " selected" : "").">{webui_systemdefault}</option>\n";

	foreach($timezoneArray as $value)
	{
		$formChooser = $formChooser."<option value=\"".$value."\"".($value == $default ? " selected" : "").">".$value."</option>\n";
	}

	return $formChooser."\n</select>\n";
}

?>