<?PHP

require_once("include/formularfunctions.php");

if (($configValues['webuisetting_allowcontact'] == 1) || ($configValues['webuisetting_allowcontact'] == 2 && $userid >= 0))
{
	$status = null;
	
	if (isset($_POST['mode']) && $_POST['mode'] == "send")
	{
		$errorMessage = "";
		if (!isset($_POST['contact_name']) || $_POST['contact_name'] == "" || containsHTMLCode($_POST['contact_name']))
		{
			if ($errorMessage != "")
			{
				$errorMessage .= "<br>";
			}
			$errorMessage .= "{webui_contact_nameisrequired}";
			$_POST['contact_name'] = "";
		}
		
		if (strlen($_POST['contact_email']) == 0 || !isEmailValid($_POST['contact_email']) || containsHTMLCode($_POST['contact_email']))
		{
			if ($errorMessage != "")
			{
				$errorMessage .= "<br>";
			}
			$errorMessage .= $translation->getTranslation("webui_useredit_errorbademail");
			$_POST['contact_email'] = "";
		}
		
		if (!isset($_POST['contact_message']) || strlen($_POST['contact_message']) < 10)
		{
			if ($errorMessage != "")
			{
				$errorMessage .= "<br>";
			}
			$errorMessage .= "{webui_contact_messageisrequired}";
			$_POST['contact_message'] = "";
		}
		else
		{
			$_POST['contact_message'] = returnSafeHTML($_POST['contact_message'], false);
		}
		
		if (isset($_POST['contact_bot']) && containsHTMLCode($_POST['contact_bot']))
		{
			$_POST['contact_bot'] = "-";
		}
		
		if (!isset($_POST['question']) || $_POST['question'] != "")
		{
			if ($errorMessage != "")
			{
				$errorMessage .= "<br>";
			}
			$errorMessage .= "Unknown error while registration, please contact the website administrator.";
		}
		
		if ($errorMessage == "")
		{
			$resContactConfig = $class_db->db_query("SELECT configkey, configvalue FROM jts3servermodwebui_settings WHERE configkey = 'webuisetting_contactmailaddress' OR configkey = 'webuisetting_replymailaddress'");

			$contactConfigValues = array();
			while($row = mysqli_fetch_row($resContactConfig))
			{
				$contactConfigValues[$row[0]] = $row[1];
			}
			
			$botInfo = array();
			$botInfo[0] = "-1";
			$botInfo[1] = "-";
			if (isset($_POST['contact_bot']) && strlen($_POST['contact_bot']) >= 3)
			{
				$botInfo = explode(" ", $_POST['contact_bot'], 2);
			}
			
			$emailTranslation = $translation->getDefaultTranslationsForPage("contactemail", false);

			$message = implode("", file("templates/contact_email.tmpl"));
			$message = $translation->replaceAllKeys($message, $emailTranslation);
			
			if (is_numeric($botInfo[0]) && $botInfo[0] >= 0)
				$message = str_replace('{homepageurl}', "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']."?page=botmanager&botID=".$botInfo[0], $message);
			else
				$message = str_replace('{homepageurl}', "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'], $message);
			
			$message = str_replace('{contact_name}', $_POST['contact_name'], $message);
			$message = str_replace('{contact_email}', $_POST['contact_email'], $message);
			$message = str_replace('{contact_bot}', $botInfo[1], $message);
			$message = str_replace('{contact_message}', $_POST['contact_message'], $message);
			$resultMail = mail($contactConfigValues['webuisetting_contactmailaddress'], $emailTranslation['email_subject'], wordwrap($message, 80), "From: ".$contactConfigValues['webuisetting_replymailaddress']."\r\nReply-To: ".$_POST['contact_email']."\r\nContent-Type: text/plain; charset=UTF-8\r\n");
			
			if ($resultMail)
			{
				$_POST['contact_message'] = "";
				$status = "{webui_contact_mailsuccessfullysent}";
			}
			else
				$status = "{webui_contact_mailinternalerrorwhilesending}";
		}
		else
		{
			$status = $errorMessage;
		}
	}
	
	$username = "";
	$usermailaddress = "";
	$botChooser = "";
	
	if (is_numeric($userid) && $userid >= 0)
	{
		$resInfo = $class_db->db_query("SELECT name, email FROM jts3servermodwebui_users WHERE id = ".$userid);
		$userInfo = mysqli_fetch_array($resInfo);
		$username = $userInfo['name'];
		$usermailaddress = $userInfo['email'];
		
		$botChooser = "<select name=\"contact_bot\" id=\"contact_bot\" size=\"1\" class=\"textinput\">\n";
		$botChooser = $botChooser."<option value=\"-\"".("-" == (isset($_POST['contact_bot']) ? $_POST['contact_bot'] : "") ? " selected" : "").">{webui_contact_notbotrelated}</option>\n";
		$resBotInfo = $class_db->db_query("SELECT id, name FROM jts3servermod_instances, jts3servermodwebui_usersinstances WHERE jts3servermod_instances.id = jts3servermodwebui_usersinstances.instance_id AND jts3servermodwebui_usersinstances.user_id = ".$userid);
		while($row = mysqli_fetch_row($resBotInfo))
		{
			$botChooser = $botChooser."<option value=\"".$row[0]." ".$row[1]."\"".($row[0]." ".$row[1] == (isset($_POST['contact_bot']) ? $_POST['contact_bot'] : "") ? " selected" : "").">".$row[1]."</option>\n";
		}
		$botChooser = $botChooser."\n</select>\n";
	}
	
	$contacttmpl = implode(" ", file("templates/contact.tmpl"));
	$contacttmpl = addStatusMessage($contacttmpl, $status);
	$contacttmpl = str_replace('{contact_name}', getTextInput("contact_name", (isset($_POST['contact_name']) ? $_POST['contact_name'] : $username), 20, 50, false), $contacttmpl);
	$contacttmpl = str_replace('{contact_email}', getTextInput("contact_email", (isset($_POST['contact_email']) ? $_POST['contact_email'] : $usermailaddress), 20, 50, false), $contacttmpl);
	$contacttmpl = str_replace('{contact_bot}', $botChooser, $contacttmpl);
	$contacttmpl = str_replace('{contact_message}', getMultilineTextInput("contact_message", (isset($_POST['contact_message']) ? $_POST['contact_message'] : ""), 10, 70, false, false), $contacttmpl);
	$contacttmpl = str_replace('{botchooser_hidden}', ($botChooser == "" ? " hidden" : ""), $contacttmpl);
	
	$for_output = $contacttmpl;
}
else
{
	$for_output = implode(" ", file("templates/backtomain.tmpl"));
	$for_output = str_replace('{title}', "{webui_contact_title}", $for_output);
	$for_output = str_replace('{message}', "{webui_contact_disabled}", $for_output);
}

$for_output = $translation->replaceTranslationsForPage($for_output, "contact");

?>