<?PHP

function getDeleteConfirm($botid, $deletetime, $deleteconnections, $class_db)
{
	$botlogdeletetmpl = implode(" ", file("templates/botlog_delete.tmpl"));
	$botlogdeletetmpl = str_replace('{page}', ($botid < 0 ? "botlist" : "botlogview&amp;botID={botID}"), $botlogdeletetmpl);
	$botlogdeletetmpl = str_replace('{bot_header}', ($botid < 0 ? "" : getBotHeader($class_db, $botid)), $botlogdeletetmpl);
	$botlogdeletetmpl = str_replace('{botID}', $botid, $botlogdeletetmpl);
	$botlogdeletetmpl = str_replace('{logdeletetime}', $deletetime, $botlogdeletetmpl);
	$botlogdeletetmpl = str_replace('{deletetime}', getTimeName($deletetime), $botlogdeletetmpl);
	$botlogdeletetmpl = str_replace('{deleteconnections}', ($deleteconnections ? "{webui_yes}" : "{webui_no}"), $botlogdeletetmpl);
	$botlogdeletetmpl = str_replace('{logdeleteconnections}', ($deleteconnections ? "yes" : "no"), $botlogdeletetmpl);
	
	return $botlogdeletetmpl;
}

function deleteLogAdmin($class_db, $logdeletetime, $deleteConnections = false)
{
	$status = null;
	if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 1)
	{
		$status = "{webui_onlyadministrator}";
	}
	else if (is_numeric($logdeletetime))
	{
		if ($logdeletetime == 0)
		{
			if ($deleteConnections)
				$class_db->db_query("TRUNCATE jts3servermod_log");
			else
				$class_db->db_query("DELETE FROM jts3servermod_log WHERE logtype != \"CLIENT_CONNECTED\"");
		}
		else
			$class_db->db_query("DELETE FROM jts3servermod_log WHERE".($deleteConnections ? "" : " logtype != \"CLIENT_CONNECTED\" AND")." logtime < ".((time() - $logdeletetime) * 1000));
		
		$status = "{webui_deletelog_successful}";
	}
	else
	{
		$status = "{webui_deletelog_aborted}";
	}
	
	return $status;
}

function getTimeName($seconds)
{
	$retValue = "error";
	switch ($seconds)
	{
		case 0: $retValue = "{webui_botlog_deleteall}"; break;
		case 86400: $retValue = "{webui_botlog_deleteday}"; break;
		case 604800: $retValue = "{webui_botlog_deleteweek}"; break;
		case 2419200: $retValue = "{webui_botlog_deletemonth}"; break;
		case 4838400: $retValue = "{webui_botlog_deletetwomonths}"; break;
		case 7257600: $retValue = "{webui_botlog_deletethreemonths}"; break;
		default: $retValue = "error";
	}
	return $retValue;
}

function getTimeDeleteComboBoxDef()
{
	$formChooser = "<select name=\"logdeletetime\" size=\"1\" class=\"textinput\">\n";
	
	$formChooser = $formChooser."<option value=\"0\">".getTimeName(0)."</option>\n";
	$formChooser = $formChooser."<option value=\"86400\">".getTimeName(86400)."</option>\n";
	$formChooser = $formChooser."<option value=\"604800\">".getTimeName(604800)."</option>\n";
	$formChooser = $formChooser."<option value=\"2419200\">".getTimeName(2419200)."</option>\n";
	$formChooser = $formChooser."<option value=\"4838400\">".getTimeName(4838400)."</option>\n";
	$formChooser = $formChooser."<option value=\"7257600\">".getTimeName(7257600)."</option>\n";
	
	return $formChooser."\n</select>\n";
}

?>