<?PHP

function getBotStatusHTML($botStatus, $botid)
{
	$retHTML = array();
	$retHTML["botstatus"] = "Error";
	$retHTML["botcommands"] = "";
	if (is_numeric($botid))
	{
		if ($botStatus == 1)
		{
			$retHTML["botstatus"] = "{webui_botstaterunning}";
			$retHTML["botcommands"] = implode(" ", file("templates/bot_header_staterunning.tmpl"));
		}
		else if ($botStatus == 0)
		{
			$retHTML["botstatus"] = "{webui_botstatestopped}";
			$retHTML["botcommands"] = implode(" ", file("templates/bot_header_statestopped.tmpl"));
		}
		else if ($botStatus == -1)
		{
			$retHTML["botstatus"] = "{webui_botstateunknown}";
		}
		else if ($botStatus == -9)
		{
			if (isset($_SESSION['adminlevel']) && is_numeric($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1)
			{
				$retHTML["botstatus"] = "<a href=\"index.php?page=settings#bottelnet\" class=\"nounderline\">{webui_botstatenotavailable}</a>";
			}
			else
			{
				$retHTML["botstatus"] = "{webui_botstatenotavailable}";
			}
		}
		else
		{
			$retHTML["botstatus"] = "{webui_botstateerror} (Code: ".$botStatus.")";
		}
	}
	
	return $retHTML;
}

function getBotInfo($class_db, $botid)
{
	if (is_numeric($botid))
	{
		$resserverinfo = $class_db->db_query("SELECT name, ts3serverip, ts3portid FROM jts3servermod_instances WHERE id = ".$botid." LIMIT 1");
		$serverInfo = mysqli_fetch_array($resserverinfo);
		return $serverInfo;
	}
	
	return array();
}

function getLogStatus($botID, $class_db)
{
	$lastBotStartTime = $class_db->getQuery("SELECT laststarttime, lastsuccesslogintime FROM jts3servermod_instances WHERE id = ".$botID);
	
	$warningCount = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_log WHERE instance_id = ".$botID." AND logtime > ".$lastBotStartTime[0]." AND logtype = 'WARNING'");
	$errorCount = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermod_log WHERE instance_id = ".$botID." AND logtime > ".$lastBotStartTime[0]." AND logtype IN ('ERROR', 'CRITICAL', 'EXCEPTION')");
	
	global $translation;
	$logstatus = array();
	$logstatus['warncount'] = $warningCount[0];
	$logstatus['errcount'] = $errorCount[0];
	$logstatus['startdate'] = $translation->getDate($lastBotStartTime[0] / 1000);
	$logstatus['successfulconnectdate'] = $translation->getDate($lastBotStartTime[1] / 1000);
	
	$logstatus['botstate'] = 0;
	if ($errorCount[0] > 0)
		$logstatus['botstate'] = 2;
	else if ($warningCount[0] > 0)
		$logstatus['botstate'] = 1;
	
    $logstatus['cssclass'] = "";
    if ($logstatus['botstate'] == 0)
        $logstatus['cssclass'] = " highlight_green";
    if ($logstatus['botstate'] == 1)
        $logstatus['cssclass'] = " highlight_yellow";
    if ($logstatus['botstate'] == 2)
        $logstatus['cssclass'] = " highlight_red";
    
	return $logstatus;
}

function getBotHeader($class_db, $botID, $serverInfo = false, $botStatus = false)
{
	if ($serverInfo === false)
		$serverInfo = getBotInfo($class_db, $botID);
	
	$botmanagertmpl = implode(" ", file("templates/bot_header.tmpl"));
	$botmanagertmpl = str_replace('{botname}', $serverInfo[0], $botmanagertmpl);
	$botmanagertmpl = str_replace('{serverdata1}', $serverInfo[1], $botmanagertmpl);
	$botmanagertmpl = str_replace('{serverdata2}', $serverInfo[2], $botmanagertmpl);
	
	$botLogStatus = getLogStatus($botID, $class_db);
	
	$botmanagertmpl = str_replace('{botlogstatus}', $botLogStatus['warncount']." / ".$botLogStatus['errcount'], $botmanagertmpl);
	$botmanagertmpl = str_replace('{botstartdate}', $botLogStatus['startdate'], $botmanagertmpl);
	$botmanagertmpl = str_replace('{lastsuccessfulconnect}', $botLogStatus['successfulconnectdate'], $botmanagertmpl);
	$botmanagertmpl = str_replace('{botlogstatuslinkclass}', $botLogStatus['cssclass'], $botmanagertmpl);
	
	if (isset($_SESSION['adminlevel']) && is_numeric($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0)
	{
		$botmanagertmpl = str_replace('{botrename}', implode(" ", file("templates/bot_header_rename.tmpl")), $botmanagertmpl);
	}
	else
	{
		$botmanagertmpl = str_replace('{botrename}', "", $botmanagertmpl);
	}
	
	$botmanagertmpl = str_replace('{botID}', $botID, $botmanagertmpl);
	
	return $botmanagertmpl;
}

?>