function endsWith(str, suffix)
{
    return str.indexOf(suffix, str.length - suffix.length) !== -1;
}

function toggleGlobalMessageVars(topObject)
{
    var c = topObject.childNodes;
    var i;
    for (i = 0; i < c.length; i++)
    {
        if (c[i].nodeName == "SPAN")
        {
			if (c[i].style.display == "none")
				c[i].style.display = "";
			else
				c[i].style.display = "none";
        }
    }
}

function plusminusaction()
{
	var plusminus = document.getElementById("plusminusbutton");
	if (endsWith(plusminus.src, "images/plus.svg"))
	{
		if (document.getElementById("framemenu_smallscreen"))
			document.getElementById("framemenu_smallscreen").style.display = "none";
		if (document.getElementById("framemenu_bigscreen"))
			document.getElementById("framemenu_bigscreen").style.display = "block";
		if (document.getElementById("botheader_smallscreen"))
			document.getElementById("botheader_smallscreen").style.display = "none";
		if (document.getElementById("botheader_bigscreen"))
			document.getElementById("botheader_bigscreen").style.display = "block";
		plusminus.src = "images/minus.svg";
	}
	else
	{
		if (document.getElementById("framemenu_bigscreen"))
			document.getElementById("framemenu_bigscreen").style.display = "none";
		if (document.getElementById("framemenu_smallscreen"))
			document.getElementById("framemenu_smallscreen").style.display = "block";
		if (document.getElementById("botheader_bigscreen"))
			document.getElementById("botheader_bigscreen").style.display = "none";
		if (document.getElementById("botheader_smallscreen"))
			document.getElementById("botheader_smallscreen").style.display = "block";
		plusminus.src = "images/plus.svg";
	}
}

function reloadSendButton()
{
	var now = new Date();
	document.getElementsByName("sendbutton")[0].src = "antispam.php?" + now.getTime();
}

function showCharCount(object, targetid)
{
	if (document.getElementById(targetid + "_div").style.display == "none")
	{
		document.getElementById(targetid + "_div").style.display = "";
	}
	
	document.getElementById(targetid).innerHTML = object.value.length;
}

function toggleLegend(idname)
{
	if (document.getElementById(idname).className == "hidden")
	{
		document.getElementById(idname).className = "";
	}
	else
	{
		document.getElementById(idname).className = "hidden";
	}
}

function toggleVisibility(idname)
{
	if (document.getElementById(idname).style.display == "none")
	{
		document.getElementById(idname).style.display = "";
	}
	else
	{
		document.getElementById(idname).style.display = "none";
	}
}

function toggleCheckBox(idname, idnamevisible)
{
	if (document.getElementsByName(idname)[0].value == "no")
	{
		document.getElementById(idname).style.visibility = "visible";
		document.getElementsByName(idname)[0].value = "yes";
		if (idnamevisible != "")
			document.getElementById(idnamevisible).style.display = "block";
	}
	else
	{
		document.getElementById(idname).style.visibility = "hidden";
		document.getElementsByName(idname)[0].value = "no";
		if (idnamevisible != "")
			document.getElementById(idnamevisible).style.display = "none";
	}
}

function closeStatus()
{
	document.getElementById('statusscreen').style.display = "none";
}

function closeBotStatus()
{
	document.getElementById('botstatusscreen').style.display = "none";
}

function showLoadingScreen(idname)
{
	if (document.getElementById('statusscreen'))
	{
		document.getElementById('statusscreen').style.display = "none";
	}
	
	if (document.getElementById('botstatusscreen'))
	{
		document.getElementById('botstatusscreen').style.display = "none";
	}
	
	if (document.getElementById(idname).style.display != "none")
	{
		document.getElementById(idname).style.display = "none";
	}

	if (document.getElementById(idname).style.display == "none")
	{
		document.getElementById(idname).style.display = "block";
	}
	
	if (window.innerWidth < 700)
	{
		var posY = document.getElementById(idname).offsetTop;
		window.scrollTo(0, (posY-60));
	}
}

function checkNumber(textfield, minValue, maxValue)
{
	if (isNaN(textfield.value) || (textfield.value.indexOf(".") != -1) || textfield.value == "")
	{
		textfield.className = "textinputerror small";
	}
	else
	{
		if (textfield.value >= minValue && textfield.value <= maxValue)
		{
			textfield.className = "textinput small";
		}
		else
		{
			textfield.className = "textinputerror small";
		}
	}
}

function trim(str)
{
	var	str = str.replace(/^\s\s*/, ''),
		ws = /\s/,
		i = str.length;
	while (ws.test(str.charAt(--i)));
	return str.slice(0, i + 1);
}

function hoverLanguage(LanguageImage)
{
	document.getElementById("languagename").innerHTML = LanguageImage.title;
}

function exitLanguage()
{
	document.getElementById("languagename").innerHTML = "Language:";
}

function initHTTPRequest()
{
	var http_request = false;
	
	if (window.XMLHttpRequest)
	{
        http_request = new XMLHttpRequest();
    }
	else if (window.ActiveXObject)
	{
        try
		{
          http_request = new ActiveXObject("Msxml2.XMLHTTP");
        }
		catch (eror)
		{
          http_request = new ActiveXObject("Microsoft.XMLHTTP");
        }
    }
	
	return http_request;
}

function requestBotStatusList(botlistuserid, statusOff, statusOn)
{
	var http_request = false;
	http_request = initHTTPRequest();
    http_request.onreadystatechange = function() { incomingBotStatusList(http_request, statusOff, statusOn); };
    http_request.open("POST", "ajax.php", true);
	http_request.setRequestHeader("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
	if (botlistuserid == -1)
	{
		http_request.send("mode=botstatusall");
	}
	else
	{
		http_request.send("mode=botstatus&botlistuserid="+botlistuserid);
	}
	
	setTimeout(requestBotStatusList, 10000, botlistuserid, statusOff, statusOn);
	
	return false;
}

function requestBotStatusHeader(botid, loadingText)
{
	if (loadingText != null)
	{
		var botStatusText = document.getElementById("botstatus");
		var botStatusText2 = document.getElementById("botstatus2");
		var botStatusButtons = document.getElementById("botstatus_buttons");

		if (botStatusText != null)
		{
			botStatusText.innerHTML = loadingText;
			botStatusText.style.cursor = 'wait';
		}
		if (botStatusText2 != null)
		{
			botStatusText2.innerHTML = loadingText;
			botStatusText2.style.cursor = 'wait';
		}
		if (botStatusButtons != null)
		{
			botStatusButtons.style.cursor = 'wait';
		}
	}
	
	var http_request = false;
	http_request = initHTTPRequest();
    http_request.onreadystatechange = function() { incomingBotStatusHeader(http_request); };
    http_request.open("POST", "ajax.php", true);
	http_request.setRequestHeader("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
	http_request.send("mode=botstatusheader&botid="+botid);
	
	setTimeout(requestBotStatusHeader, 10000, botid, null);
	
	return false;
}

function requestBotCommand(botid, command)
{
	showLoadingScreen('loadingscreencommand');
	
	var http_request = false;
	http_request = initHTTPRequest();
    http_request.onreadystatechange = function() { incomingBotCommandStatus(botid, http_request); };
    http_request.open("POST", "ajax.php", true);
	http_request.setRequestHeader("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
	http_request.send("mode=botcommand&command="+command+"&botid="+botid);
	return false;
}

function incomingBotStatusList(http_request, statusOff, statusOn)
{
	if (http_request.readyState == 4)
	{
		if (http_request.status == 200)
		{
			if (http_request.responseText.length < 7)
			{
				// Error
			}
			else
			{
				var botStatusList = JSON.parse(http_request.responseText);
				for (var key in botStatusList)
				{
					if (botStatusList.hasOwnProperty(key))
					{
						var botStatusImage = document.getElementById(key);
						if (botStatusImage != null)
						{
							if (botStatusList[key] == 0)
							{
								botStatusImage.src = "images/bullet_red.png";
								botStatusImage.title = statusOff;
								botStatusImage.alt = statusOff;
							}
							else if (botStatusList[key] == 1)
							{
								botStatusImage.src = "images/bullet_green.png";
								botStatusImage.title = statusOn;
								botStatusImage.alt = statusOn;
							}
						}
					}
				}
			}
		}
	}
}

function incomingBotStatusHeader(http_request)
{
	if (http_request.readyState == 4)
	{
		var botStatusText = document.getElementById("botstatus");
		var botStatusText2 = document.getElementById("botstatus2");
		var botStatusButtons = document.getElementById("botstatus_buttons");
		var botStartDate = document.getElementById("botstartdate");
		var botLastSuccessfulConnect = document.getElementById("lastsuccessfulconnect");
		var botLogStatus = document.getElementById("botlogstatus");
		
		if (http_request.status == 200)
		{
			if (http_request.responseText.length < 7)
			{
				if (botStatusText != null)
				{
					botStatusText.innerHTML = "Error " + http_request.responseText;
					botStatusText.style.cursor = 'auto';
				}
				if (botStatusText2 != null)
				{
					botStatusText2.innerHTML = "Error " + http_request.responseText;
					botStatusText2.style.cursor = 'auto';
				}
				if (botStatusButtons != null)
				{
					botStatusButtons.innerHTML = "";
					botStatusButtons.style.cursor = 'auto';
				}
			}
			else
			{
				var botStatusHeader = JSON.parse(http_request.responseText);

				if (botStatusText != null)
				{
					botStatusText.innerHTML = botStatusHeader.botstatus;
					botStatusText.style.cursor = 'auto';
				}
				if (botStatusText2 != null)
				{
					botStatusText2.innerHTML = botStatusHeader.botstatus;
					botStatusText2.style.cursor = 'auto';
				}
				if (botStatusButtons != null)
				{
					botStatusButtons.innerHTML = botStatusHeader.botcommands;
					botStatusButtons.style.cursor = 'auto';
				}
				if (botStartDate != null)
				{
					botStartDate.innerHTML = botStatusHeader.startdate;
				}
				if (botLastSuccessfulConnect != null)
				{
					botLastSuccessfulConnect.innerHTML = botStatusHeader.successfulconnectdate;
				}
				if (botLogStatus != null)
				{
					botLogStatus.innerHTML = botStatusHeader.warncount + " / " + botStatusHeader.errcount;
					botLogStatus.className = "nounderline " + botStatusHeader.cssclass;
				}
			}
		}
		else
		{
			if (botStatusText != null)
			{
				botStatusText.innerHTML = "Ajax Error";
				botStatusText.style.cursor = 'auto';
			}
			if (botStatusText2 != null)
			{
				botStatusText2.innerHTML = "Ajax Error";
				botStatusText2.style.cursor = 'auto';
			}
			if (botStatusButtons != null)
			{
				botStatusButtons.innerHTML = "";
				botStatusButtons.style.cursor = 'auto';
			}
		}
	}
}

function incomingBotCommandStatus(botid, http_request)
{
	if (http_request.readyState == 4)
	{
		var botStatusText = document.getElementById("botstatusscreen");
		var statusText = document.getElementById("statusscreen");
		var botStatusLoading = document.getElementById("loadingscreencommand");

		if (botStatusLoading != null)
		{
			botStatusLoading.style.display = "none";
		}
		
		if (statusText != null)
		{
			statusText.style.display = "none";
		}
		
		if (http_request.status == 200)
		{
			if (botStatusText != null)
			{
				botStatusText.innerHTML = http_request.responseText;
				botStatusText.style.display = "block";
			}
			
			requestBotStatusHeader(botid, null);
		}
		else
		{
			if (botStatusText != null)
			{
				botStatusText.innerHTML = "Ajax Error";
				botStatusText.style.display = "block";
			}
		}
	}
}

function loadOtherPage(url)
{
	if (url.length > 0)
		window.location.href = url;
}