<?php

class Translation
{

    private $classdb = null;
    private $languageID = 1;
    private $defaultLanguageID = 1;
	private $defaultTimezone = null;
	private $dateCountryString = null;
	private $dateFormatString = null;

    function __construct($classdb, $languageID)
    {
        $this->classdb = $classdb;

        $resultDefaultLanguage = $this->classdb->db_query("SELECT configkey, configvalue FROM jts3servermodwebui_settings WHERE configkey = 'webuisetting_defaultlanguage' OR configkey = 'webuisetting_defaulttimezone'");
        if (mysqli_num_rows($resultDefaultLanguage) >= 1)
        {
			while ($row = mysqli_fetch_row($resultDefaultLanguage))
			{
				if ($row[0] == "webuisetting_defaultlanguage")
					$this->defaultLanguageID = $row[1];
				else if ($row[0] == "webuisetting_defaulttimezone")
					$this->defaultTimezone = $row[1];
			}
        }

        if ($languageID != null && is_numeric($languageID))
        {
            $this->languageID = $languageID;
        }
        else
        {
            $this->languageID = $this->defaultLanguageID;
        }
		
		$resultdateCountryString = $this->classdb->db_query("SELECT dateCountry, dateFormat FROM jts3servermodwebui_language WHERE id = ".$this->languageID);
		if (mysqli_num_rows($resultdateCountryString) == 1)
		{
			$defDateLangString = mysqli_fetch_array($resultdateCountryString);
			$this->dateCountryString = (strlen($defDateLangString[0]) < 2 ? null : $defDateLangString[0]);
			$this->dateFormatString = (strlen($defDateLangString[1]) < 5 ? null : $defDateLangString[1]);
		}
		
		if ($this->defaultTimezone != null && strlen($this->defaultTimezone) > 1)
			date_default_timezone_set($this->defaultTimezone);
		
		setlocale(LC_TIME, ($this->dateCountryString == null ? "en_US" : $this->dateCountryString));
    }
	
	function getDate($time)
	{
		return strftime(($this->dateFormatString == null ? "%d/%b/%y %I:%M:%S%p" : $this->dateFormatString), $time);
	}

    function getTranslation($textkey, $convertBBCode = false, $convertHTMLEntities = true)
    {
        $resTranslation = $this->classdb->db_query("SELECT textmessage FROM jts3servermodwebui_translation WHERE textkey = '" . $this->classdb->getRealEscapeString($textkey) . "' AND language_id = " . $this->languageID);

        if (mysqli_num_rows($resTranslation) == 0)
        {
            $resTranslation = $this->classdb->db_query("SELECT textmessage FROM jts3servermodwebui_translation WHERE textkey = '" . $this->classdb->getRealEscapeString($textkey) . "' AND language_id = " . $this->defaultLanguageID);
            if (mysqli_num_rows($resTranslation) == 0)
            {
                return "";
            }
        }

        $translationInfo = mysqli_fetch_array($resTranslation);
		if ($convertBBCode) return completeBBCode2HTML($translationInfo[0]);
		else if ($convertHTMLEntities) return nl2br(htmlentities($translationInfo[0], ENT_QUOTES, "UTF-8"));
        else return nl2br($translationInfo[0]);
    }

    function getTranslationsForPage($page, $convertHTML = true, $convertBBCode = false)
    {
        $resTranslation = $this->classdb->db_query("SELECT textkey, textmessage FROM jts3servermodwebui_translation WHERE webpage = '" . $this->classdb->getRealEscapeString($page) . "' AND language_id = " . $this->languageID);
        $resTranslationDefLang = $this->classdb->db_query("SELECT textkey, textmessage FROM jts3servermodwebui_translation WHERE webpage = '" . $this->classdb->getRealEscapeString($page) . "' AND language_id = " . $this->defaultLanguageID);

        $translationLang = array();
        $translationDefLang = array();
		
        while ($row = mysqli_fetch_row($resTranslation))
        {
            $translationLang[$row[0]] = ($convertBBCode ? completeBBCode2HTML($row[1]) : ($convertHTML ? nl2br(htmlentities($row[1], ENT_QUOTES, "UTF-8")) : $row[1]));
        }

        while ($row = mysqli_fetch_row($resTranslationDefLang))
        {
            $translationDefLang[$row[0]] = ($convertBBCode ? completeBBCode2HTML($row[1]) : ($convertHTML ? nl2br(htmlentities($row[1], ENT_QUOTES, "UTF-8")) : $row[1]));
        }

        if (sizeof($translationDefLang) == 0)
        {
            return $translationLang;
        }

        if (sizeof($translationLang) == 0)
        {
            return $translationDefLang;
        }

        $retTranslation = array_merge($translationDefLang, $translationLang);

        return $retTranslation;
    }

    function getDefaultTranslationsForPage($page, $convertHTML = true, $convertBBCode = false)
    {
        $resTranslationDefLang = $this->classdb->db_query("SELECT textkey, textmessage FROM jts3servermodwebui_translation WHERE webpage = '" . $this->classdb->getRealEscapeString($page) . "' AND language_id = " . $this->defaultLanguageID);

        $translationDefLang = array();
		
        while ($row = mysqli_fetch_row($resTranslationDefLang))
        {
            $translationDefLang[$row[0]] = ($convertBBCode ? completeBBCode2HTML($row[1]) : ($convertHTML ? nl2br(htmlentities($row[1], ENT_QUOTES, "UTF-8")) : $row[1]));
        }

        return $translationDefLang;
    }

    function replaceAllKeys($tmpl, $translationArray)
    {
        if (is_array($translationArray))
        {
            foreach ($translationArray as $key => $value)
            {
                $tmpl = str_replace("{" . $key . "}", $value, $tmpl);
            }

            return $tmpl;
        }
        else
        {
            return $tmpl;
        }
    }

    function replaceTranslationsForPage($tmpl, $page, $convertHTML = true, $convertBBCode = false)
    {
        return $this->replaceAllKeys($tmpl, $this->getTranslationsForPage($page, $convertHTML, $convertBBCode));
    }

    function getLanguageBox($name = "languageid")
    {
        $formChooser = "<select name=\"".$name."\" id=\"". $name."\" size=\"1\" class=\"textinput\">\n";

        $resList = $this->classdb->db_query("SELECT id, name FROM jts3servermodwebui_language WHERE showLanguage = 1");

        while ($row = mysqli_fetch_row($resList))
        {
            $formChooser = $formChooser . "<option value=\"" . $row[0] . "\"" . ($this->defaultLanguageID == $row[0] ? " selected" : "") . ">" . $row[1] . "</option>\n";
        }

        return $formChooser . "\n</select>\n";
    }

    function getLanguageImageList()
    {
		$queryString = "languageid={languageid}";
		if (isset($_SERVER["QUERY_STRING"]) && strlen($_SERVER["QUERY_STRING"]) > 0)
		{
			$pos = strpos($_SERVER["QUERY_STRING"], "&command=");
			
			if ($pos === false)
			{
				$pos = strpos($_SERVER["QUERY_STRING"], "&languageid=");
				
				if ($pos === false)
					$queryString = $_SERVER["QUERY_STRING"]."&amp;".$queryString;
				else
					$queryString = substr($_SERVER["QUERY_STRING"], 0, $pos)."&amp;".$queryString;
			}
			else
				$queryString = substr($_SERVER["QUERY_STRING"], 0, $pos)."&amp;".$queryString;
		}
		
        $template = "<a href=\"index.php?".$queryString."\"> <img src=\"{minilogo}\" border=\"0\" class=\"languageimagechooser\" alt=\"{languagename}\" title=\"{languagename}\" onmouseover=\"hoverLanguage(this);\" onmouseout=\"exitLanguage();\"></a>\n";
        $squadImageList = "";

        $resList = $this->classdb->db_query("SELECT id, name, image FROM jts3servermodwebui_language WHERE showLanguage = 1 ORDER BY name");
        while ($row = mysqli_fetch_row($resList))
        {
            $squadImageList .= " " . $template;
            $squadImageList = str_replace('{languageid}', $row[0], $squadImageList);
            $squadImageList = str_replace('{languagename}', $row[1], $squadImageList);
            $squadImageList = str_replace('{minilogo}', "images/language/" . $row[2], $squadImageList);
        }

        return $squadImageList;
    }

}

?>