<?php

error_reporting(0); ## LIVE

#ini_set('display_errors', 1); ## TESTING
#error_reporting(E_ALL);  ## TESTING


header("Content-Type: text/html; charset=utf-8");
mb_internal_encoding('UTF-8');

$sessionName = "JTS3ServerModWebUI";
session_name($sessionName);
@session_start();

if (!isset($_SESSION['ipaddress']) || $_SESSION['ipaddress'] != $_SERVER["REMOTE_ADDR"])
	die("ERR 1");

function getBotCheckLogInfo($botID, $translation)
{
	$message = $translation->getTranslation("webui_checkloginfo");
	$message = str_replace('{botloglink}', "<a href=\"index.php?page=botlogview&amp;botID=".$botID."&amp;logtype=warning\">", $message);
	$message = str_replace('{botloglinkend}', "</a>", $message);
	return $message;
}

require("class/dbconnect.php");
$class_db = new dbconnect();

require("class/BotTelnet.php");
$botTelnet = new BotTelnet($class_db);

if (isset($_POST['mode']) && $_POST['mode'] == "botstatusall")
{
	$botStatusArray = array();
	if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0)
	{
		$botStatusArray = $botTelnet->getBotStatusAll();
	}
	
	echo json_encode($botStatusArray);
}
else if (isset($_POST['mode']) && $_POST['mode'] == "botstatus")
{
	if (!isset($_POST['botlistuserid']) || !is_numeric($_POST['botlistuserid']))
	{
		die("ERR 3");
	}
	
	$currentUserIDBotList = $_SESSION['userid'];
	$botStatusArray = $botTelnet->getBotStatusAll();
	$botStatusArrayLimited = array();
	
	if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 0)
	{
		if ($currentUserIDBotList != $_POST['botlistuserid'])
			$currentUserIDBotList = $_POST['botlistuserid'];
	}
	
	$resListBots = $class_db->db_query("SELECT jts3servermod_instances.name FROM jts3servermodwebui_usersinstances, jts3servermod_instances WHERE jts3servermodwebui_usersinstances.instance_id = jts3servermod_instances.id AND jts3servermodwebui_usersinstances.user_id = ".$currentUserIDBotList);
	while($row = mysqli_fetch_row($resListBots))
	{
		$botStatusArrayLimited[$row[0]] = $botStatusArray[$row[0]];
	}
	
	echo json_encode($botStatusArrayLimited);
}
else if (isset($_POST['mode']) && $_POST['mode'] == "botstatusheader")
{
	if (!isset($_POST['botid']) || !is_numeric($_POST['botid']))
	{
		die("ERR 2");
	}
	
	$isAllowed = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE instance_id = ".$_POST['botid']." AND user_id = ".$_SESSION['userid']);
	if ($isAllowed[0] == 0 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 1))
		die("ERR 4");
	
	require("class/Translation.php");
	$translation = new Translation($class_db, (isset($_SESSION['languageid']) && is_numeric($_SESSION['languageid']) ? $_SESSION['languageid'] : null));
	
	require("include/botheaderfunctions.php");
	
	$serverInfo = getBotInfo($class_db, $_POST['botid']);
	$botStatus = $botTelnet->getBotStatus($serverInfo[0]);
	$botStatusHTML = getBotStatusHTML($botStatus, $_POST['botid']);
	$botStatusHTML = $translation->replaceTranslationsForPage($botStatusHTML, "various");
	if (isset($botStatusHTML["botcommands"]))
		$botStatusHTML["botcommands"] = str_replace('{botID}', $_POST['botid'], $botStatusHTML["botcommands"]);
	
    $botLogStatus = getLogStatus($_POST['botid'], $class_db);
    
	echo json_encode(array_merge($botStatusHTML, $botLogStatus));
}
else if (isset($_POST['mode']) && $_POST['mode'] == "botcommand")
{
	require("class/Translation.php");
	$translation = new Translation($class_db, (isset($_SESSION['languageid']) && is_numeric($_SESSION['languageid']) ? $_SESSION['languageid'] : null));
	
	if ($_POST['command'] == "instancelistreload")
	{
		if (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] > 1)
		{
			if ($botTelnet->instancelistReload())
			{
				die($translation->getTranslation("webui_botcmdinstancelistreloadmsg"));
			}
			else
			{
				die($translation->getTranslation("webui_botcmdinstancelistreloaderror"));
			}
		}
		else
		{
			die($translation->getTranslation("webui_onlyadministrator"));
		}
	}
	else if (!isset($_POST['botid']) || !is_numeric($_POST['botid']))
	{
		die("ERR 2");
	}
	
	$isAllowed = $class_db->getQuery("SELECT COUNT(*) FROM jts3servermodwebui_usersinstances WHERE instance_id = ".$_POST['botid']." AND user_id = ".$_SESSION['userid']);
	if ($isAllowed[0] == 0 && (isset($_SESSION['adminlevel']) && $_SESSION['adminlevel'] < 1))
		die("ERR 4");
	
	require("include/botheaderfunctions.php");
	$serverInfo = getBotInfo($class_db, $_POST['botid']);
	
	if (isset($_SESSION['lastTelnetCMD']) && $_SESSION['lastTelnetCMD'] > (time() - 5))
	{
		$status = "{webui_botcmdspam}";
	}
	else
	{
		$_SESSION['lastTelnetCMD'] = time();
		
		if ($_POST['command'] == "start")
		{
			if ($botTelnet->startBot($serverInfo[0]))
			{
				$class_db->db_query("UPDATE jts3servermod_instances SET `enabled` = '1' WHERE `id` =".$_POST['botid']);
				$status = "{webui_botcmdstartmsg}<br>".getBotCheckLogInfo($_POST['botid'], $translation);
			}
			else
			{
				$status = "{webui_botcmdstarterror}";
			}
		}
		else if ($_POST['command'] == "reload")
		{
			if ($botTelnet->reloadBot($serverInfo[0]))
			{
				$status = "{webui_botcmdreloadmsg}<br>".getBotCheckLogInfo($_POST['botid'], $translation);
			}
			else
			{
				$status = "{webui_botcmdreloaderror}";
			}
		}
		else if ($_POST['command'] == "reloadconfig")
		{
			if ($botTelnet->reloadBotConfig($serverInfo[0]))
			{
				$status = "{webui_botcmdreloadconfigmsg}<br>".getBotCheckLogInfo($_POST['botid'], $translation);
			}
			else
			{
				$status = "{webui_botcmdreloadconfigerror}";
			}
		}
		else if ($_POST['command'] == "stop")
		{
			if ($botTelnet->stopBot($serverInfo[0]))
			{
				$class_db->db_query("UPDATE jts3servermod_instances SET `enabled` = '0' WHERE `id` =".$_POST['botid']);
				$status = "{webui_botcmdstopmsg}";
			}
			else
			{
				$status = "{webui_botcmdstoperror}";
			}
		}
		
		$_SESSION['lastTelnetCMD'] = time();
	}
	
	$status = $translation->replaceTranslationsForPage($status, "botmanager");
	
	echo $status;
}
else
{
	die("ERR 9");
}

?>