@echo off
REM JTS3ServerMod Service Script v2 by Stefan Martens
REM 
REM If you want, change the path to the JTS3ServerMod tools directory. It has to end with a backslash!
SET PR_PATH=%~dp0
REM 
REM Set the service name
SET PR_SERVICE_NAME=JTS3ServerMod
REM 
REM Set the path of the JTS3ServerMod_InstanceManager.cfg file
SET CONFIG_PATH=%~dp0..\config\JTS3ServerMod_InstanceManager.cfg
REM 
REM Set the path to the JTS3ServerMod_InstanceManager.log file
SET LOG_PATH=%~dp0..\JTS3ServerMod_InstanceManager.log
REM 
REM Do not change anything below this line!
SET PR_SERVICE_DESCRIPTION=The multifunction Teamspeak 3 server bot from http://www.stefan1200.de
SET PR_JAR=JTS3ServerMod.jar
SET START_CLASS=de.stefan1200.jts3servermod.JTS3ServerMod
SET START_METHOD=main
SET STOP_CLASS=java.lang.System
SET STOP_METHOD=exit
SET STOP_PARAMS=0
SET JVM_OPTIONS=-Dapp.home="%PR_PATH%..\\"

echo Installing JTS3ServerMod service...
echo.

SET AdminTestPath=%windir%\System32\testadmintemp
mkdir "%AdminTestPath%" 2>nul
IF ERRORLEVEL 1 (
  echo You need admin permissions to run this script!
  goto END;
) else (
  rmdir "%AdminTestPath%"
)

"%PR_PATH%procrun\amd64\prunsrv.exe" //IS//%PR_SERVICE_NAME% --Description="%PR_SERVICE_DESCRIPTION%" --Install="%PR_PATH%procrun\amd64\prunsrv.exe" --Jvm=auto --Startup=auto --StartMode=jvm --StartClass=%START_CLASS% --StartMethod=%START_METHOD% ++StartParams=-config;"%CONFIG_PATH%";-log;"%LOG_PATH%" --StopMode=jvm --StopClass=%STOP_CLASS% --StopMethod=%STOP_METHOD% ++StopParams=%STOP_PARAMS% --Classpath="%PR_PATH%..\%PR_JAR%" --DisplayName="%PR_SERVICE_NAME%" ++JvmOptions=%JVM_OPTIONS% --StdError=auto
IF ERRORLEVEL 1 (
	echo.
	echo Check if the service name %PR_SERVICE_NAME% already exists!
) else (
	echo.
	echo Now you should be able to start service with:
	echo net start %PR_SERVICE_NAME%
)

:END
PAUSE