	public boolean handleChatCommands(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin)
	{
		if (!pluginEnabled) return false;
		
		// Everyone can use the following command
		if (msg.toLowerCase().equalsIgnoreCase("info"))
		{
			modClass.sendMessageToClient(configPrefix, "chat", Integer.parseInt(eventInfo.get("invokerid")), "Information XYZ");
			return true;
		}

		// FullBotAdmins, BotAdmins and specified server groups (if your plugin has an option for this) can use the following command
		if (msg.toLowerCase().equalsIgnoreCase("list"))
		{
			if (isFullAdmin || isAdmin || isCMDAllowed(eventInfo.get("invokerid")))
			{
				modClass.sendMessageToClient(configPrefix, "chat", Integer.parseInt(eventInfo.get("invokerid")), "List XYZ");
			}
			else
			{
				modClass.sendMessageToClient(configPrefix, "chat", Integer.parseInt(eventInfo.get("invokerid")), "You are not my master!");
			}
			return true;
		}
		
		// FullBotAdmins and BotAdmins can use the following command
		if (msg.toLowerCase().startsWith("add"))
		{
			if (isFullAdmin || isAdmin)
			{
				// split arguments from msg here, do something with it
				modClass.sendMessageToClient(configPrefix, "chat", Integer.parseInt(eventInfo.get("invokerid")), "Add XYZ");
			}
			else
			{
				modClass.sendMessageToClient(configPrefix, "chat", Integer.parseInt(eventInfo.get("invokerid")), "You are not my master!");
			}
			return true;
		}
		
		// FullBotAdmins can use the following command
		if (msg.toLowerCase().startsWith("remove"))
		{
			if (isFullAdmin)
			{
				// split arguments from msg here, do something with it
				modClass.sendMessageToClient(configPrefix, "chat", Integer.parseInt(eventInfo.get("invokerid")), "Remove XYZ");
			}
			else
			{
				modClass.sendMessageToClient(configPrefix, "chat", Integer.parseInt(eventInfo.get("invokerid")), "You are not my master!");
			}
			return true;
		}
		
		return false;
	}
		
	private boolean isCMDAllowed(String sClientID)
	{
		int clientID = -1;
		try
		{
			clientID = Integer.parseInt(sClientID);
		}
		catch (Exception e)
		{
			return false;
		}
		
		// listOfAllowedServerGroups is a class member variable with the type Vector<Integer>,
		// which will be filled with server group ids in loadConfig().
		HashMap<String, String> clientListEntry = modClass.getClientListEntry(clientID);
		if (clientListEntry != null)
			return modClass.isGroupListed(clientListEntry.get("client_servergroups"), listOfAllowedServerGroups);
		
		return false;
	}