/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.ChannelEmptyComparator;
import de.stefan1200.jts3servermod.FunctionExceptionLog;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleTS3Events;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InactiveChannelCheck
implements LoadConfiguration,
HandleBotEvents,
HandleTS3Events {
    private static final byte PARENT_MODE_IGNORE = 0;
    private static final byte PARENT_MODE_ONLY = 1;
    private static final byte PARENT_MODE_PARENTONLY = 2;
    private static final byte PARENT_MODE_PARENTIGNORE = 3;
    private String configPrefix = "";
    private JTS3ServerMod_Interface modClass = null;
    private JTS3ServerQuery queryLib = null;
    private boolean pluginEnabled = false;
    private boolean notFirstRun = false;
    private long emptyDeleteTime = -1L;
    private long emptyWarnTime = -1L;
    private long emptyWarnIconID = -1L;
    private Vector<Integer> cache_ChannelID = new Vector();
    private Vector<Long> cache_IconID = new Vector();
    private boolean ignorePermanent = true;
    private boolean ignoreSemiPermanent = false;
    private boolean ignoreSpacer = false;
    private Pattern pSpacer = null;
    private Vector<Integer> ignoreChannelList = new Vector();
    private Vector<Integer> parentChannelList = new Vector();
    private byte parentChannelList_mode = 0;
    private FunctionExceptionLog fel = new FunctionExceptionLog();
    private NumberFormat nfHours = NumberFormat.getInstance();
    private String channelNamePrefix = "\ud83d\uddd1\ufe0f ";
    private long firstCheck = 0L;

    @Override
    public void initClass(JTS3ServerMod_Interface modClass, JTS3ServerQuery queryLib, String prefix) {
        this.modClass = modClass;
        this.queryLib = queryLib;
        this.configPrefix = prefix.trim();
        this.nfHours.setMaximumFractionDigits(1);
        this.nfHours.setMinimumFractionDigits(1);
    }

    @Override
    public void handleOnBotConnect() {
        if (!this.pluginEnabled) {
            return;
        }
        this.firstCheck = System.currentTimeMillis();
        StringBuffer sbList = new StringBuffer();
        if (!this.ignorePermanent) {
            sbList.append("permanent");
        }
        if (!this.ignoreSemiPermanent) {
            if (sbList.length() > 0) {
                sbList.append(" and ");
            }
            sbList.append("semi-permanent");
        }
        String msg = "Delete " + sbList.toString() + " channels if empty for at least " + Long.toString(this.emptyDeleteTime / 60L / 60L) + " hours! Channels will be marked as inactive after " + Long.toString(this.emptyWarnTime / 60L / 60L) + " hours!";
        this.modClass.addLogEntry(this.configPrefix, (byte)1, msg, true);
    }

    @Override
    public void handleAfterCacheUpdate() {
        int parentChannelID;
        if (!this.pluginEnabled) {
            return;
        }
        Matcher mSpacer = null;
        Vector<HashMap<String, String>> channelList = this.modClass.getChannelList();
        Vector<Integer> deletedChannelList = new Vector<Integer>();
        Vector<Integer> newParentChannelList = null;
        if (this.parentChannelList_mode == 3) {
            newParentChannelList = new Vector<Integer>();
            for (HashMap<String, String> channel : channelList) {
                parentChannelID = Integer.parseInt(channel.get("pid"));
                if (parentChannelID == 0 || this.modClass.isIDListed(parentChannelID, newParentChannelList) || this.modClass.isIDListed(parentChannelID, this.parentChannelList)) continue;
                newParentChannelList.addElement(parentChannelID);
            }
        }
        int i = 0;
        while (i < channelList.size()) {
            block22: {
                if (!(channelList.elementAt(i).get("channel_flag_default").equals("1") || this.ignorePermanent && channelList.elementAt(i).get("channel_flag_permanent").equals("1") || this.ignoreSemiPermanent && channelList.elementAt(i).get("channel_flag_semi_permanent").equals("1") || channelList.elementAt(i).get("channel_flag_permanent").equals("0") && channelList.elementAt(i).get("channel_flag_semi_permanent").equals("0"))) {
                    String channelName = channelList.elementAt(i).get("channel_name");
                    if (!this.ignoreSpacer || !(mSpacer = this.pSpacer.matcher(channelName)).matches()) {
                        int channelID = Integer.parseInt(channelList.elementAt(i).get("cid"));
                        parentChannelID = Integer.parseInt(channelList.elementAt(i).get("pid"));
                        if (!this.modClass.isIDListed(channelID, this.ignoreChannelList)) {
                            if (this.modClass.isIDListed(parentChannelID, deletedChannelList)) {
                                deletedChannelList.addElement(channelID);
                            } else {
                                boolean result = this.parentChannelList_mode == 2 ? this.modClass.isIDListed(channelID, this.parentChannelList) : (this.parentChannelList_mode == 3 ? this.modClass.isIDListed(channelID, newParentChannelList) : this.modClass.isIDListed(parentChannelID, this.parentChannelList));
                                if (this.parentChannelList_mode == 0 ? !result : result) {
                                    long emptySeconds = Long.parseLong(channelList.elementAt(i).get("seconds_empty"));
                                    if (emptySeconds > 31536000L) {
                                        this.modClass.addLogEntry(this.configPrefix, (byte)2, "Got bad values for channel \"" + channelName + "\" (id: " + Integer.toString(channelID) + ") from TS3 server, skipping channel!", false);
                                    } else if (this.notFirstRun && emptySeconds > this.emptyDeleteTime) {
                                        try {
                                            this.queryLib.deleteChannel(channelID, false);
                                            deletedChannelList.addElement(channelID);
                                            this.modClass.removeChannelListEntry(channelID);
                                            --i;
                                            this.modClass.addLogEntry(this.configPrefix, (byte)1, "Channel \"" + channelName + "\" (id: " + Integer.toString(channelID) + ") was empty for more than " + Long.toString(emptySeconds / 60L / 60L) + " hours. Channel was deleted!", false);
                                            this.fel.clearException(channelID);
                                        }
                                        catch (TS3ServerQueryException sqe) {
                                            if (this.fel.existsException(sqe, channelID)) break block22;
                                            this.fel.addException(sqe, channelID);
                                            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Channel \"" + channelName + "\" (id: " + Integer.toString(channelID) + ") was empty for more than " + Long.toString(emptySeconds / 60L / 60L) + " hours, but an error occurred while deleting channel!", false);
                                            if (sqe.getFailedPermissionID() < 0) {
                                                this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                                                break block22;
                                            }
                                            this.modClass.addLogEntry(this.configPrefix, sqe, false);
                                        }
                                        catch (Exception e) {
                                            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Channel \"" + channelName + "\" (id: " + Integer.toString(channelID) + ") was empty for more than " + Long.toString(emptySeconds / 60L / 60L) + " hours, but an error occurred while deleting channel!", false);
                                            this.modClass.addLogEntry(this.configPrefix, e, false);
                                        }
                                    } else if (this.emptyWarnTime != -1L && emptySeconds > this.emptyWarnTime) {
                                        this.setChannelDeleteWarning(channelList.elementAt(i), channelID);
                                    } else if (this.emptyWarnTime != -1L) {
                                        this.removeChannelDeleteWarning(channelList.elementAt(i), channelID);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (!this.notFirstRun && System.currentTimeMillis() - this.firstCheck > 600000L) {
            this.notFirstRun = true;
        }
    }

    private void setChannelDeleteWarning(HashMap<String, String> channelInfo, int channelID) {
        if (this.emptyWarnIconID < 0L) {
            HashMap<String, String> renameSuccess;
            if (!channelInfo.get("channel_name").startsWith(this.channelNamePrefix) && !(renameSuccess = this.queryLib.doCommand("channeledit cid=" + Integer.toString(channelID) + " channel_name=" + this.queryLib.encodeTS3String(String.valueOf(this.channelNamePrefix) + channelInfo.get("channel_name")))).get("id").equals("0")) {
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Can't rename channel \"" + channelInfo.get("channel_name") + "\" (id: " + Integer.toString(channelID) + "), reason: " + renameSuccess.get("msg") + ". Maybe the channel name is to long to add the prefix.", false);
            }
        } else {
            long channelIconID = Long.parseLong(channelInfo.get("channel_icon_id"));
            if (channelIconID != this.emptyWarnIconID) {
                this.cache_ChannelID.addElement(channelID);
                this.cache_IconID.addElement(channelIconID);
                HashMap<String, String> iconSuccess = this.queryLib.doCommand("channeladdperm cid=" + Integer.toString(channelID) + " permsid=i_icon_id permvalue=" + this.emptyWarnIconID);
                if (!iconSuccess.get("id").equals("0")) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)3, "Can't set icon to channel \"" + channelInfo.get("channel_name") + "\" (id: " + Integer.toString(channelID) + "), reason: " + iconSuccess.get("msg"), false);
                }
            }
        }
    }

    private void removeChannelDeleteWarning(HashMap<String, String> channelInfo, int channelID) {
        if (this.emptyWarnIconID < 0L) {
            if (channelInfo.get("channel_name").startsWith(this.channelNamePrefix)) {
                this.queryLib.doCommand("channeledit cid=" + Integer.toString(channelID) + " channel_name=" + this.queryLib.encodeTS3String(channelInfo.get("channel_name").substring(this.channelNamePrefix.length())));
            }
        } else if (Long.parseLong(channelInfo.get("channel_icon_id")) == this.emptyWarnIconID) {
            long channelIconID = 0L;
            int pos = this.cache_ChannelID.indexOf(channelID);
            if (pos != -1) {
                channelIconID = this.cache_IconID.elementAt(pos);
                this.cache_ChannelID.removeElementAt(pos);
                this.cache_IconID.removeElementAt(pos);
            }
            this.queryLib.doCommand("channeladdperm cid=" + Integer.toString(channelID) + " permsid=i_icon_id permvalue=" + Long.toString(channelIconID));
        }
    }

    private Vector<HashMap<String, String>> getCheckedChannelList() {
        int parentChannelID;
        Vector<HashMap<String, String>> checkedChannelList = new Vector<HashMap<String, String>>();
        Matcher mSpacer = null;
        Vector<HashMap<String, String>> channelList = this.modClass.getChannelList();
        Vector<Integer> deletedChannelList = new Vector<Integer>();
        Vector<Integer> newParentChannelList = null;
        if (this.parentChannelList_mode == 3) {
            newParentChannelList = new Vector<Integer>();
            for (HashMap<String, String> channel : channelList) {
                parentChannelID = Integer.parseInt(channel.get("pid"));
                if (parentChannelID == 0 || this.modClass.isIDListed(parentChannelID, newParentChannelList) || this.modClass.isIDListed(parentChannelID, this.parentChannelList)) continue;
                newParentChannelList.addElement(parentChannelID);
            }
        }
        for (HashMap<String, String> channel : channelList) {
            if (channel.get("channel_flag_default").equals("1") || this.ignorePermanent && channel.get("channel_flag_permanent").equals("1") || this.ignoreSemiPermanent && channel.get("channel_flag_semi_permanent").equals("1") || channel.get("channel_flag_permanent").equals("0") && channel.get("channel_flag_semi_permanent").equals("0") || this.ignoreSpacer && (mSpacer = this.pSpacer.matcher(channel.get("channel_name"))).matches()) continue;
            int channelID = Integer.parseInt(channel.get("cid"));
            parentChannelID = Integer.parseInt(channel.get("pid"));
            if (this.modClass.isIDListed(channelID, this.ignoreChannelList)) continue;
            if (this.modClass.isIDListed(parentChannelID, deletedChannelList)) {
                deletedChannelList.addElement(channelID);
                continue;
            }
            boolean result = this.parentChannelList_mode == 2 ? this.modClass.isIDListed(channelID, this.parentChannelList) : (this.parentChannelList_mode == 3 ? this.modClass.isIDListed(channelID, newParentChannelList) : this.modClass.isIDListed(parentChannelID, this.parentChannelList));
            if (!(this.parentChannelList_mode == 0 ? !result : result)) continue;
            checkedChannelList.addElement(channel);
        }
        return checkedChannelList;
    }

    @Override
    public void activate() {
        HashMap<String, String> iconList;
        if (this.emptyWarnTime > 0L && this.emptyWarnIconID > -1L && (iconList = this.queryLib.doCommand("ftgetfilelist cid=0 cpw= path=\\/icons")).get("response").indexOf("name=icon_" + Long.toString(this.emptyWarnIconID) + " ") == -1) {
            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Warn Icon ID " + Long.toString(this.emptyWarnIconID) + " does not exist on this TS3 server! Using channel name prefix now.", false);
            this.emptyWarnIconID = -1L;
        }
    }

    @Override
    public void disable() {
        int i = 0;
        while (i < this.cache_ChannelID.size()) {
            this.queryLib.doCommand("channeladdperm cid=" + Integer.toString(this.cache_ChannelID.elementAt(i)) + " permsid=i_icon_id permvalue=" + Long.toString(this.cache_IconID.elementAt(i)));
            ++i;
        }
        this.cache_ChannelID.clear();
        this.cache_IconID.clear();
        if (this.emptyWarnTime > 0L && this.emptyWarnIconID == -1L) {
            Vector<HashMap<String, String>> channelList;
            try {
                channelList = this.queryLib.getList(2);
            }
            catch (Exception e) {
                channelList = this.modClass.getChannelList();
            }
            for (HashMap<String, String> channel : channelList) {
                if (!channel.get("channel_name").startsWith(this.channelNamePrefix)) continue;
                this.queryLib.doCommand("channeledit cid=" + channel.get("cid") + " channel_name=" + this.queryLib.encodeTS3String(channel.get("channel_name").substring(this.channelNamePrefix.length())));
            }
        }
    }

    @Override
    public void unload() {
        this.ignoreChannelList = null;
        this.parentChannelList = null;
        this.fel = null;
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter config) {
        config.addKey(String.valueOf(this.configPrefix) + "_emptydeletetime", "After how many hours an empty channel should be deleted? Possible values between 1 and 10000 hours.", "168");
        config.addKey(String.valueOf(this.configPrefix) + "_emptywarntime", "After how many hours an empty channel will be marked as inactive (a prefix to the channel name or a channel icon will be added)?\nPossible values between 1 and 10000 hours. Set to -1 to disable this feature!", "144");
        config.addKey(String.valueOf(this.configPrefix) + "_emptywarniconid", "Set the TS3 icon id here (will be displayed in TS3 client, if you hover with the mouse on the icon in the icons selection window).\nThis icon will be set as channel icon, if the channel is empty for a longer time than set at the empty warn time.\nSet -1 to use the channel name prefix instead.", "-1");
        config.addKey(String.valueOf(this.configPrefix) + "_ignore_permanent", "Never delete permanent channels? Set yes or no here!", "yes");
        config.addKey(String.valueOf(this.configPrefix) + "_ignore_semipermanent", "Never delete semi permanent channels? Set yes or no here!", "no");
        config.addKey(String.valueOf(this.configPrefix) + "_ignore_spacer", "Never delete spacer channels (like [cspacer])? Set yes or no here!", "no");
        config.addKey(String.valueOf(this.configPrefix) + "_ignore_channels", "A comma separated list (without spaces) of channel ids you like to ignore. This channels don't get deleted!");
        config.addKey(String.valueOf(this.configPrefix) + "_parentchannel_list", "A comma separated list (without spaces) of parent channel ids (use 0 for the top level).\nDepends on the given mode, all sub-channels of this channels can be ignored or only sub-channels of this channels will be checked!\nThe check parent channel only mode allows you to check the activity only on the selected parent channels (which will be reset also on activity in sub-channels) and delete the parent channel including the sub channels, if it is detected inactive.\nIf no parent channels should be ignored, set no channels here and select the channel list mode ignore!");
        config.addKey(String.valueOf(this.configPrefix) + "_parentchannel_list_mode", "Select one of the four modes for the parent channel list.\nignore = All sub-channels of the selected channels will be ignored.\nonly = Only sub-channels of the selected channels will be checked.\nparentignore = Only the parent channels will be checked (and will delete all sub channels), which are not on the list.\nparentonly = Only the parent channels will be checked (and will delete all sub channels), which are on the list.", "ignore");
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter config, boolean slowMode) throws BotConfigurationException, NumberFormatException {
        String lastNumberValue = "";
        String temp = null;
        this.pluginEnabled = false;
        try {
            StringTokenizer st;
            lastNumberValue = String.valueOf(this.configPrefix) + "_emptydeletetime";
            temp = config.getValue(String.valueOf(this.configPrefix) + "_emptydeletetime");
            if (temp == null) {
                throw new NumberFormatException();
            }
            this.emptyDeleteTime = Long.parseLong(temp.trim()) * 60L * 60L;
            if (this.emptyDeleteTime < 3600L) {
                this.emptyDeleteTime = 3600L;
            } else if (this.emptyDeleteTime > 36000000L) {
                this.emptyDeleteTime = 36000000L;
            }
            lastNumberValue = String.valueOf(this.configPrefix) + "_emptywarntime";
            temp = config.getValue(String.valueOf(this.configPrefix) + "_emptywarntime");
            if (temp == null) {
                throw new NumberFormatException();
            }
            this.emptyWarnTime = Long.parseLong(temp.trim()) * 60L * 60L;
            if (this.emptyWarnTime < 3600L) {
                this.emptyWarnTime = -1L;
            } else if (this.emptyWarnTime > 36000000L) {
                this.emptyWarnTime = 36000000L;
            }
            if (this.emptyWarnTime >= this.emptyDeleteTime) {
                throw new BotConfigurationException("The value of Empty Warn Time is not lower than the value of Empty Delete Time, disabled Inactive Channel Check!");
            }
            lastNumberValue = String.valueOf(this.configPrefix) + "_emptywarniconid";
            temp = config.getValue(String.valueOf(this.configPrefix) + "_emptywarniconid");
            if (temp == null) {
                throw new NumberFormatException();
            }
            this.emptyWarnIconID = Long.parseLong(temp.trim());
            if (this.emptyWarnIconID < 0L) {
                this.emptyWarnIconID = -1L;
            }
            this.ignorePermanent = config.getValue(String.valueOf(this.configPrefix) + "_ignore_permanent", "yes").trim().equalsIgnoreCase("yes");
            this.ignoreSemiPermanent = config.getValue(String.valueOf(this.configPrefix) + "_ignore_semipermanent", "no").trim().equalsIgnoreCase("yes");
            if (this.ignorePermanent && this.ignoreSemiPermanent) {
                throw new BotConfigurationException("Ignoring permanent and semi-permanent channels are activated, disabled Inactive Channel Check!");
            }
            this.ignoreSpacer = config.getValue(String.valueOf(this.configPrefix) + "_ignore_spacer", "no").trim().equalsIgnoreCase("yes");
            if (this.ignoreSpacer) {
                this.pSpacer = Pattern.compile("\\[.{0,1}spacer\\d*\\].*", 66);
            }
            temp = null;
            this.ignoreChannelList.clear();
            temp = config.getValue(String.valueOf(this.configPrefix) + "_ignore_channels");
            lastNumberValue = String.valueOf(this.configPrefix) + "_ignore_channels";
            if (temp != null && temp.length() > 0) {
                st = new StringTokenizer(temp, ",", false);
                while (st.hasMoreTokens()) {
                    this.ignoreChannelList.addElement(Integer.parseInt(st.nextToken().trim()));
                }
            }
            temp = null;
            this.parentChannelList.clear();
            temp = config.getValue(String.valueOf(this.configPrefix) + "_parentchannel_list");
            lastNumberValue = String.valueOf(this.configPrefix) + "_parentchannel_list";
            if (temp != null && temp.length() > 0) {
                st = new StringTokenizer(temp, ",", false);
                while (st.hasMoreTokens()) {
                    this.parentChannelList.addElement(Integer.parseInt(st.nextToken().trim()));
                }
            }
            this.parentChannelList_mode = (temp = config.getValue(String.valueOf(this.configPrefix) + "_parentchannel_list_mode", "ignore").trim()).equalsIgnoreCase("only") ? (byte)1 : (temp.equalsIgnoreCase("parentonly") ? (byte)2 : (temp.equalsIgnoreCase("parentignore") ? (byte)3 : (byte)0));
            this.notFirstRun = false;
            this.pluginEnabled = true;
        }
        catch (NumberFormatException e) {
            NumberFormatException nfe = new NumberFormatException("Config value of \"" + lastNumberValue + "\" is not a number! Current value: " + config.getValue(lastNumberValue, "not set"));
            nfe.setStackTrace(e.getStackTrace());
            throw nfe;
        }
        return this.pluginEnabled;
    }

    @Override
    public void setListModes(BitSet listOptions) {
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Inactive Channel Check function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }

    @Override
    public String[] botChatCommandList(HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        if (!this.pluginEnabled) {
            return null;
        }
        if (isFullAdmin || isAdmin) {
            String[] commands = new String[]{"list"};
            return commands;
        }
        return null;
    }

    @Override
    public String botChatCommandHelp(String command) {
        if (command.equalsIgnoreCase("list")) {
            return "Sends you a list of channels, which will be checked for inactivity and deleted!";
        }
        return null;
    }

    @Override
    public boolean handleChatCommands(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        if (!this.pluginEnabled) {
            return false;
        }
        if (msg.equalsIgnoreCase("list")) {
            block10: {
                try {
                    if (isFullAdmin || isAdmin) {
                        Vector<HashMap<String, String>> checkedChannelList = this.getCheckedChannelList();
                        ChannelEmptyComparator cec = new ChannelEmptyComparator();
                        Collections.sort(checkedChannelList, cec);
                        String temp = null;
                        long emptySeconds = 0L;
                        StringBuffer messageListEntry = new StringBuffer("List of channels, which will be checked for inactivity and deleted after " + Long.toString(this.emptyDeleteTime / 60L / 60L) + " hours:");
                        Vector<String> messageList = new Vector<String>();
                        for (HashMap<String, String> channel : checkedChannelList) {
                            try {
                                emptySeconds = Long.parseLong(channel.get("seconds_empty"));
                            }
                            catch (Exception e) {
                                emptySeconds = -1L;
                            }
                            temp = String.valueOf(channel.get("channel_name")) + " (id: " + channel.get("cid") + ")" + (emptySeconds >= 0L ? " - " + this.nfHours.format((double)emptySeconds / 60.0 / 60.0) + " hours" : "");
                            if (this.modClass.getUTF8Length(String.valueOf(messageListEntry.toString()) + "\n" + temp) < 1024) {
                                messageListEntry.append("\n");
                                messageListEntry.append(temp);
                                continue;
                            }
                            messageList.addElement(messageListEntry.toString());
                            messageListEntry.setLength(0);
                            messageListEntry.append(temp);
                        }
                        messageList.addElement(messageListEntry.toString());
                        messageListEntry = null;
                        temp = null;
                        int i = 0;
                        while (i < messageList.size()) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, (String)messageList.elementAt(i));
                            ++i;
                        }
                        break block10;
                    }
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
                }
                catch (Exception e) {
                    this.modClass.addLogEntry(this.configPrefix, e, false);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void handleTS3Events(String eventType, HashMap<String, String> eventInfo) {
    }
}

