/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.FunctionExceptionLog;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleClientList;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class IdleCheck
implements LoadConfiguration,
HandleClientList,
HandleBotEvents {
    private String configPrefix = "";
    private JTS3ServerMod_Interface modClass = null;
    private JTS3ServerQuery queryLib = null;
    private ArrangedPropertiesWriter config = null;
    private boolean pluginEnabled = false;
    private Vector<Integer> IDLE_CHANNEL_LIST = new Vector();
    private boolean IDLE_CHANNEL_LIST_IGNORE = true;
    private Vector<Integer> IDLE_GROUP_LIST = new Vector();
    private boolean IDLE_GROUP_LIST_IGNORE = true;
    private int groupidIdleGroup = -1;
    private int channelidIdleMove = -1;
    private String modeIdleGroupMessage = null;
    private String modeIdleMoveMessage = null;
    private String modeIdleWarnMessage = null;
    private String messageIdleGroupConfig = null;
    private String messageIdleMoveConfig = null;
    private String messageIdleKickConfig = null;
    private String messageIdleWarnConfig = null;
    private long timeIdleWarn = -1L;
    private long timeIdleGroup = -1L;
    private long timeIdleMove = -1L;
    private long timeIdleKick = -1L;
    private int IDLE_MIN_CLIENTS = 0;
    private boolean IDLE_MIN_CLIENTS_MODE_CHANNEL = true;
    private Vector<Integer> listClientsWarnSent = new Vector();
    private Vector<Integer> listClientsWarnSentTemp = new Vector();
    private boolean idleMoveBack = false;
    private Vector<Integer> listClientsGrouped = new Vector();
    private Vector<Integer> listClientsMoved = new Vector();
    private Vector<Integer> listClientsMovedChannel = new Vector();
    private String IDLE_FILE = null;
    private String messageIdleGroup = null;
    private String messageIdleMove = null;
    private String messageIdleKick = null;
    private String messageIdleWarn = null;
    private String channelName = null;
    private FunctionExceptionLog fel = new FunctionExceptionLog();
    private Vector<HashMap<String, String>> clientListCacheCurrent = new Vector();
    private Vector<HashMap<String, String>> clientListCacheOld = new Vector();

    @Override
    public void initClass(JTS3ServerMod_Interface modClass, JTS3ServerQuery queryLib, String prefix) {
        this.modClass = modClass;
        this.queryLib = queryLib;
        this.configPrefix = prefix.trim();
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public void activate() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void unload() {
        this.IDLE_CHANNEL_LIST = null;
        this.IDLE_GROUP_LIST = null;
        this.listClientsWarnSent = null;
        this.listClientsWarnSentTemp = null;
        this.listClientsGrouped = null;
        this.listClientsMoved = null;
        this.listClientsMovedChannel = null;
        this.fel = null;
    }

    @Override
    public void handleAfterCacheUpdate() {
        if (!this.pluginEnabled) {
            return;
        }
        if (this.timeIdleMove > 0L) {
            this.channelName = this.modClass.getChannelName(this.channelidIdleMove);
            if (this.channelName == null) {
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Critical: Channel ID " + this.channelidIdleMove + " don't exists! Check value " + this.configPrefix + "_channel_id in your configuration!", true);
                this.pluginEnabled = false;
                return;
            }
        }
        if (this.modClass.getClientList() != null) {
            this.clientListCacheOld = this.clientListCacheOld.size() == 0 ? this.modClass.getClientList() : this.clientListCacheCurrent;
            this.clientListCacheCurrent = this.modClass.getClientList();
        }
        this.createMessage();
    }

    @Override
    public void handleOnBotConnect() {
        String msg;
        if (!this.pluginEnabled) {
            return;
        }
        if (this.timeIdleGroup > 0L) {
            if (this.groupidIdleGroup == -6) {
                this.createServerGroup(true);
            } else if (this.groupidIdleGroup == -9) {
                this.createServerGroup(false);
            }
            if (this.groupidIdleGroup < 0) {
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "No valid server group id is set in the bot configuration, please check the value at " + this.configPrefix + "_group_id", true);
                this.pluginEnabled = false;
                this.modClass.unloadFunction(this);
                return;
            }
        }
        String prefix = !this.IDLE_GROUP_LIST_IGNORE || this.IDLE_GROUP_LIST.size() > 0 ? "Members of " + Integer.toString(this.IDLE_GROUP_LIST.size()) + " specified server groups will " + (this.IDLE_GROUP_LIST_IGNORE ? "not " : "") : "Clients will ";
        if (this.timeIdleWarn > 0L) {
            msg = "get a warning message after being idle for " + Long.toString(this.timeIdleWarn / 1000L / 60L) + " minutes";
            this.modClass.addLogEntry(this.configPrefix, (byte)1, String.valueOf(prefix) + msg, true);
        }
        if (this.timeIdleGroup > 0L) {
            msg = "be put into the server group id " + Integer.toString(this.groupidIdleGroup) + " after being idle for " + Long.toString(this.timeIdleGroup / 1000L / 60L) + " minutes" + (this.IDLE_MIN_CLIENTS > 0 ? " (if min " + Integer.toString(this.IDLE_MIN_CLIENTS) + " clients online)" : "");
            this.modClass.addLogEntry(this.configPrefix, (byte)1, String.valueOf(prefix) + msg, true);
        }
        if (this.timeIdleMove > 0L) {
            msg = "be moved into the channel \"" + this.channelName + "\" (id: " + Integer.toString(this.channelidIdleMove) + ") after being idle for " + Long.toString(this.timeIdleMove / 1000L / 60L) + " minutes" + (this.IDLE_MIN_CLIENTS > 0 ? " (if min " + Integer.toString(this.IDLE_MIN_CLIENTS) + " clients online)" : "") + (this.idleMoveBack ? ". Clients will be moved back, if not idle anymore." : ".");
            this.modClass.addLogEntry(this.configPrefix, (byte)1, String.valueOf(prefix) + msg, true);
        }
        if (this.timeIdleKick > 0L) {
            msg = "be kicked from the server after being idle for " + Long.toString(this.timeIdleKick / 1000L / 60L) + " minutes" + (this.IDLE_MIN_CLIENTS > 0 ? " (if min " + Integer.toString(this.IDLE_MIN_CLIENTS) + " clients online)" : "");
            this.modClass.addLogEntry(this.configPrefix, (byte)1, String.valueOf(prefix) + msg, true);
        }
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter config) {
        config.addKey(String.valueOf(this.configPrefix) + "_warn_time", "Set the idle warn time in minutes or set -1 to disable this feature.", "-1");
        config.addKey(String.valueOf(this.configPrefix) + "_group_time", "Set the idle group time in minutes or set -1 to disable this feature.\nClients will be added to the specified server group after being idle for this time!", "-1");
        config.addKey(String.valueOf(this.configPrefix) + "_move_time", "Set the idle move time in minutes or set -1 to disable this feature.\nClients will be moved to the specified channel after being idle for this time!", "-1");
        config.addKey(String.valueOf(this.configPrefix) + "_kick_time", "Set the idle kick time in minutes or set -1 to disable this feature.\nClients will be kicked from the server after being idle for this time!", "-1");
        config.addKey(String.valueOf(this.configPrefix) + "_group_id", "If the clients should be put into a temporary server group, set the server group id here.\nYou should use a server group, which adds the server group name to the client name, so everyone can quickly see, that someone is away.\nNotice: That server group only need the following permissions (first three are set by default):\ni_group_needed_modify_power, i_group_needed_member_add_power, i_group_needed_member_remove_power and i_group_show_name_in_tree\nImportant: Make sure, that the specified server group don't has set the permission b_group_is_permanent!\nYou can also set -6 (sg name on the left side) or -9 (sg name on the right side) to create a new server group with the name AFK.\nThis will update the bot configuration and the bot needs the permission b_virtualserver_servergroup_create one time!", "-1");
        config.addKey(String.valueOf(this.configPrefix) + "_channel_id", "If the clients should be moved, set channel id to move idle clients into it.");
        config.addKey(String.valueOf(this.configPrefix) + "_moveback", "If the clients got moved, move client back if not idle anymore? Set yes or no here!", "no");
        config.addKey(String.valueOf(this.configPrefix) + "_channel_list", "A comma separated list (without spaces) of channel ids.\nDepends on the given mode, this channels can be ignored or only this channels will be checked!\nIf no channels should be ignored, set no channels here and select the channel list mode ignore!");
        config.addKey(String.valueOf(this.configPrefix) + "_channel_list_mode", "Select one of the two modes for the channel list.\nignore = The selected channels will be ignored.\nonly = Only the selected channels will be checked.", "ignore");
        config.addKey(String.valueOf(this.configPrefix) + "_group_list", "A comma separated list (without spaces) of server group ids.\nDepends on the given mode, this server groups can be ignored or only this server groups will be checked!\nIf no server groups should be ignored, set no server groups here and select the group list mode ignore!");
        config.addKey(String.valueOf(this.configPrefix) + "_group_list_mode", "Select one of the two modes for the server group list.\nignore = The selected server groups will be ignored.\nonly = Only the selected server groups will be checked.", "ignore");
        config.addKey(String.valueOf(this.configPrefix) + "_min_clients", "A minimum client count to activate the idle check (Query clients are not counted).\nIf less clients are in the channel or on the server, idle check does nothing.", "3");
        config.addKey(String.valueOf(this.configPrefix) + "_min_clients_mode", "Select if the minimum client count is needed in the channel or on the server.\nchannel or server are valid values!", "server");
        config.addKey(String.valueOf(this.configPrefix) + "_warn_message_mode", "Select the message mode, how the client should get the warning message.\npoke or chat are valid values!", "chat");
        config.addKey(String.valueOf(this.configPrefix) + "_group_message_mode", "If the clients should be put into the specified server group, select the message mode, how the client should get the message.\npoke, chat or none are valid values!", "chat");
        config.addKey(String.valueOf(this.configPrefix) + "_move_message_mode", "If the clients should be moved to the specified channel, select the message mode, how the client should get the message.\npoke, chat or none are valid values!", "chat");
        if (this.modClass.getMySQLConnection() == null) {
            config.addKey(String.valueOf(this.configPrefix) + "_file", "Path to file which contains the idle messages", "%apphome%config/server1/idlecheckmessages.cfg");
        }
        config.addKey(String.valueOf(this.configPrefix) + "_warn_message", "Idle warning message, the client get this message as chat or poke message.\nYou can use the following keywords, which will be replaced:\n%IDLE_WARN_TIME% - Replaced with idle warn time\n%IDLE_GROUP_TIME% - Replaced with idle group time\n%IDLE_MOVE_TIME% - Replaced with idle move time\n%IDLE_KICK_TIME% - Replaced with idle kick time\n%IDLE_CHANNEL_NAME% - If clients should be moved, this will be replaced with the channel name of target idle channel\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.\nUse the character sequence \u00a7+\u00a7 to split a long message into multiple messages.", this.modClass.getMySQLConnection() != null);
        config.addKey(String.valueOf(this.configPrefix) + "_group_message", "Idle group message, the client get this message as chat or poke message.\nYou can use the following keywords, which will be replaced:\n%IDLE_WARN_TIME% - Replaced with idle warn time\n%IDLE_GROUP_TIME% - Replaced with idle group time\n%IDLE_MOVE_TIME% - Replaced with idle move time\n%IDLE_KICK_TIME% - Replaced with idle kick time\n%IDLE_CHANNEL_NAME% - If clients should be moved, this will be replaced with the channel name of target idle channel\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.\nUse the character sequence \u00a7+\u00a7 to split a long message into multiple messages.", this.modClass.getMySQLConnection() != null);
        config.addKey(String.valueOf(this.configPrefix) + "_move_message", "Idle move message, the client get this message as chat or poke message.\nYou can use the following keywords, which will be replaced:\n%IDLE_WARN_TIME% - Replaced with idle warn time\n%IDLE_GROUP_TIME% - Replaced with idle group time\n%IDLE_MOVE_TIME% - Replaced with idle move time\n%IDLE_KICK_TIME% - Replaced with idle kick time\n%IDLE_CHANNEL_NAME% - If clients should be moved, this will be replaced with the channel name of target idle channel\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.\nUse the character sequence \u00a7+\u00a7 to split a long message into multiple messages.", this.modClass.getMySQLConnection() != null);
        config.addKey(String.valueOf(this.configPrefix) + "_kick_message", "Idle kick message, the client get this message as kick reason.\nYou can use the following keywords, which will be replaced:\n%IDLE_KICK_TIME% - Replaced with idle kick time", this.modClass.getMySQLConnection() != null);
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter config, boolean slowMode) throws BotConfigurationException, NumberFormatException {
        block19: {
            String lastNumberValue = "";
            String temp = null;
            this.pluginEnabled = false;
            this.config = config;
            try {
                StringTokenizer st;
                lastNumberValue = String.valueOf(this.configPrefix) + "_min_clients";
                this.IDLE_MIN_CLIENTS = Integer.parseInt(config.getValue(String.valueOf(this.configPrefix) + "_min_clients", "0").trim());
                this.IDLE_MIN_CLIENTS_MODE_CHANNEL = config.getValue(String.valueOf(this.configPrefix) + "_min_clients_mode", "server").trim().equalsIgnoreCase("channel");
                this.IDLE_FILE = config.getValue(String.valueOf(this.configPrefix) + "_file");
                String[] configKeys = new String[]{String.valueOf(this.configPrefix) + "_warn_message", String.valueOf(this.configPrefix) + "_group_message", String.valueOf(this.configPrefix) + "_move_message", String.valueOf(this.configPrefix) + "_kick_message"};
                if (!this.modClass.loadMessages(this.configPrefix, "_file", configKeys)) {
                    throw new BotConfigurationException("Idle Check messages could not be loaded!");
                }
                this.messageIdleWarnConfig = config.getValue(configKeys[0]);
                this.messageIdleGroupConfig = config.getValue(configKeys[1]);
                this.messageIdleMoveConfig = config.getValue(configKeys[2]);
                this.messageIdleKickConfig = config.getValue(configKeys[3]);
                lastNumberValue = String.valueOf(this.configPrefix) + "_warn_time";
                this.timeIdleWarn = Long.parseLong(config.getValue(String.valueOf(this.configPrefix) + "_warn_time", "-1").trim());
                if (this.timeIdleWarn > 0L) {
                    this.timeIdleWarn = this.timeIdleWarn * 60L * 1000L;
                    this.modeIdleWarnMessage = config.getValue(String.valueOf(this.configPrefix) + "_warn_message_mode", "chat").trim();
                    if (this.messageIdleWarnConfig == null || this.messageIdleWarnConfig.length() == 0) {
                        throw new BotConfigurationException("Idle Check warn message is missing in config!");
                    }
                }
                this.listClientsWarnSent.clear();
                lastNumberValue = String.valueOf(this.configPrefix) + "_group_time";
                this.timeIdleGroup = Long.parseLong(config.getValue(String.valueOf(this.configPrefix) + "_group_time", "-1").trim());
                if (this.timeIdleGroup > 0L) {
                    this.timeIdleGroup = this.timeIdleGroup * 60L * 1000L;
                    this.modeIdleGroupMessage = config.getValue(String.valueOf(this.configPrefix) + "_group_message_mode", "chat").trim();
                    lastNumberValue = String.valueOf(this.configPrefix) + "_group_id";
                    temp = config.getValue(String.valueOf(this.configPrefix) + "_group_id");
                    if (temp == null) {
                        throw new NumberFormatException();
                    }
                    this.groupidIdleGroup = Integer.parseInt(temp.trim());
                    if (this.messageIdleGroupConfig == null || this.messageIdleGroupConfig.length() == 0) {
                        throw new BotConfigurationException("Idle Check group message is missing in config!");
                    }
                }
                lastNumberValue = String.valueOf(this.configPrefix) + "_move_time";
                this.timeIdleMove = Long.parseLong(config.getValue(String.valueOf(this.configPrefix) + "_move_time", "-1").trim());
                if (this.timeIdleMove > 0L) {
                    this.timeIdleMove = this.timeIdleMove * 60L * 1000L;
                    this.modeIdleMoveMessage = config.getValue(String.valueOf(this.configPrefix) + "_move_message_mode", "chat").trim();
                    lastNumberValue = String.valueOf(this.configPrefix) + "_channel_id";
                    temp = config.getValue(String.valueOf(this.configPrefix) + "_channel_id");
                    if (temp == null) {
                        throw new NumberFormatException();
                    }
                    this.channelidIdleMove = Integer.parseInt(temp.trim());
                    this.idleMoveBack = config.getValue(String.valueOf(this.configPrefix) + "_moveback", "no").trim().equalsIgnoreCase("yes");
                    if (this.messageIdleMoveConfig == null || this.messageIdleMoveConfig.length() == 0) {
                        throw new BotConfigurationException("Idle Check move message is missing in config!");
                    }
                } else {
                    this.idleMoveBack = false;
                }
                lastNumberValue = String.valueOf(this.configPrefix) + "_kick_time";
                this.timeIdleKick = Long.parseLong(config.getValue(String.valueOf(this.configPrefix) + "_kick_time", "-1").trim());
                if (this.timeIdleKick > 0L) {
                    this.timeIdleKick = this.timeIdleKick * 60L * 1000L;
                    if (this.messageIdleKickConfig == null || this.messageIdleKickConfig.length() == 0) {
                        throw new BotConfigurationException("Idle Check kick message is missing in config!");
                    }
                }
                temp = null;
                this.IDLE_CHANNEL_LIST.clear();
                temp = config.getValue(String.valueOf(this.configPrefix) + "_channel_list");
                lastNumberValue = String.valueOf(this.configPrefix) + "_channel_list";
                if (temp != null && temp.length() > 0) {
                    st = new StringTokenizer(temp, ",", false);
                    while (st.hasMoreTokens()) {
                        this.IDLE_CHANNEL_LIST.addElement(Integer.parseInt(st.nextToken().trim()));
                    }
                }
                temp = null;
                this.IDLE_GROUP_LIST.clear();
                temp = config.getValue(String.valueOf(this.configPrefix) + "_group_list");
                lastNumberValue = String.valueOf(this.configPrefix) + "_group_list";
                if (temp != null && temp.length() > 0) {
                    st = new StringTokenizer(temp, ",", false);
                    while (st.hasMoreTokens()) {
                        this.IDLE_GROUP_LIST.addElement(Integer.parseInt(st.nextToken().trim()));
                    }
                }
                this.IDLE_CHANNEL_LIST_IGNORE = !config.getValue(String.valueOf(this.configPrefix) + "_channel_list_mode", "ignore").trim().equalsIgnoreCase("only");
                boolean bl = this.IDLE_GROUP_LIST_IGNORE = !config.getValue(String.valueOf(this.configPrefix) + "_group_list_mode", "ignore").trim().equalsIgnoreCase("only");
                if (this.timeIdleWarn > 0L || this.timeIdleGroup > 0L || this.timeIdleMove > 0L || this.timeIdleKick > 0L) break block19;
                this.modClass.addLogEntry(this.configPrefix, (byte)1, "All idle time limits are disabled, Idle Check function will be disabled now!", true);
                return false;
            }
            catch (NumberFormatException e) {
                NumberFormatException nfe = new NumberFormatException("Config value of \"" + lastNumberValue + "\" is not a number! Current value: " + config.getValue(lastNumberValue, "not set"));
                nfe.setStackTrace(e.getStackTrace());
                throw nfe;
            }
        }
        this.pluginEnabled = true;
        return this.pluginEnabled;
    }

    @Override
    public void setListModes(BitSet listOptions) {
        listOptions.set(1);
        listOptions.set(3);
        listOptions.set(5);
        listOptions.set(0);
    }

    private int createServerGroup(boolean leftTag) {
        int serverGroupID = -1;
        String serverGroupName = "AFK";
        boolean noErrors = true;
        HashMap<String, String> response = this.queryLib.doCommand("servergroupadd name=" + serverGroupName);
        if (response.get("id").equals("0")) {
            try {
                HashMap<String, String> sgid = this.queryLib.parseLine(response.get("response"));
                serverGroupID = Integer.parseInt(sgid.get("sgid"));
            }
            catch (Exception e) {
                noErrors = false;
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to create the new server group!", true);
                this.modClass.addLogEntry(this.configPrefix, e, false);
            }
        } else {
            noErrors = false;
            try {
                throw new TS3ServerQueryException("createServerGroup()", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
            }
            catch (TS3ServerQueryException sqe) {
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to create the new server group!", true);
                if (sqe.getFailedPermissionID() < 0) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                }
                this.modClass.addLogEntry(this.configPrefix, sqe, false);
            }
        }
        if (serverGroupID > 0) {
            response = this.queryLib.doCommand("servergroupdelperm sgid=" + Integer.toString(serverGroupID) + " permsid=b_group_is_permanent");
            if (!response.get("id").equals("0")) {
                noErrors = false;
                try {
                    throw new TS3ServerQueryException("createServerGroup()", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
                }
                catch (TS3ServerQueryException sqe) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to remove the permission b_group_is_permanent from the new server group " + serverGroupName + " (id: " + Integer.toString(serverGroupID) + ")! Please do this manually!", true);
                    if (sqe.getFailedPermissionID() < 0) {
                        this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                    }
                    this.modClass.addLogEntry(this.configPrefix, sqe, false);
                }
            }
            if (!(response = this.queryLib.doCommand("servergroupaddperm sgid=" + Integer.toString(serverGroupID) + " permsid=i_group_show_name_in_tree permvalue=" + (leftTag ? "1" : "2") + " permnegated=0 permskip=0")).get("id").equals("0")) {
                noErrors = false;
                try {
                    throw new TS3ServerQueryException("createServerGroup()", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
                }
                catch (TS3ServerQueryException sqe) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to add the permission i_group_show_name_in_tree to the new server group " + serverGroupName + " (id: " + Integer.toString(serverGroupID) + ")! Please do this manually!", true);
                    if (sqe.getFailedPermissionID() < 0) {
                        this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                    }
                    this.modClass.addLogEntry(this.configPrefix, sqe, false);
                }
            }
            this.groupidIdleGroup = serverGroupID;
            this.config.setValue(String.valueOf(this.configPrefix) + "_group_id", serverGroupID);
            if (!this.config.save()) {
                noErrors = false;
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to save the id of the new server group " + serverGroupName + " to the bot configuration! Please set the server group id " + Integer.toString(serverGroupID) + " at " + this.configPrefix + "_group_id in the bot configuration now!", true);
            }
            if (noErrors) {
                this.modClass.addLogEntry(this.configPrefix, (byte)1, "Successfully created a new server group id " + Integer.toString(serverGroupID) + " with the name " + serverGroupName + ", bot configuration was updated successfully!", true);
            }
        }
        return serverGroupID;
    }

    private int getClientCountFromClientList(Vector<HashMap<String, String>> clientList, String channelID) {
        int count = 0;
        int i = 0;
        while (i < clientList.size()) {
            if (clientList.elementAt(i).get("client_type").equals("0") && (!this.IDLE_MIN_CLIENTS_MODE_CHANNEL || clientList.elementAt(i).get("cid").equals(channelID))) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public void handleClientCheck(Vector<HashMap<String, String>> clientList) {
        boolean found;
        int i;
        if (!this.pluginEnabled) {
            return;
        }
        int i2 = 0;
        while (i2 < clientList.size()) {
            block58: {
                HashMap<String, String> clientInfo = clientList.elementAt(i2);
                if (clientInfo.get("client_type").equals("0")) {
                    int clientID = Integer.parseInt(clientInfo.get("clid"));
                    int clientDBID = Integer.parseInt(clientInfo.get("client_database_id"));
                    int cachePosGroup = -1;
                    int cachePosMove = -1;
                    if (this.timeIdleGroup > 0L && (cachePosGroup = this.listClientsGrouped.indexOf(clientDBID)) == -1 && this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.groupidIdleGroup)) {
                        this.listClientsGrouped.addElement(clientDBID);
                        cachePosGroup = this.listClientsGrouped.indexOf(clientDBID);
                    }
                    if (this.idleMoveBack) {
                        cachePosMove = this.listClientsMoved.indexOf(clientID);
                    }
                    long idleTime = this.modClass.getIdleTime(clientInfo, this.channelidIdleMove);
                    if (this.clientListCacheOld.size() > 0 && this.getClientCountFromClientList(this.clientListCacheOld, clientInfo.get("cid")) >= this.IDLE_MIN_CLIENTS && this.getClientCountFromClientList(clientList, clientInfo.get("cid")) >= this.IDLE_MIN_CLIENTS) {
                        boolean result;
                        int channelID;
                        block57: {
                            channelID = Integer.parseInt(clientInfo.get("cid"));
                            result = this.modClass.isIDListed(channelID, this.IDLE_CHANNEL_LIST);
                            if (this.timeIdleMove > 0L && idleTime > this.timeIdleMove && channelID != this.channelidIdleMove && (this.IDLE_CHANNEL_LIST_IGNORE ? !result : result)) {
                                result = this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_LIST);
                                if (this.IDLE_GROUP_LIST_IGNORE ? !result : result) {
                                    try {
                                        this.queryLib.moveClient(clientID, this.channelidIdleMove, null);
                                        clientInfo.put("cid", Integer.toString(this.channelidIdleMove));
                                        if (this.idleMoveBack) {
                                            this.listClientsMoved.addElement(clientID);
                                            this.listClientsMovedChannel.addElement(channelID);
                                        }
                                        this.modClass.addLogEntry(this.configPrefix, (byte)1, "Client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") was idle, client was moved and got a message!", false);
                                        this.modClass.sendMessageToClient(this.configPrefix, this.modeIdleMoveMessage, clientID, this.messageIdleMove);
                                        this.fel.clearException(clientDBID);
                                    }
                                    catch (TS3ServerQueryException sqe) {
                                        if (!this.fel.existsException(sqe, clientDBID)) {
                                            this.fel.addException(sqe, clientDBID);
                                            this.modClass.addLogEntry(this.configPrefix, (byte)2, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is idle, but an error occurred while moving client!", false);
                                            if (sqe.getFailedPermissionID() < 0) {
                                                this.modClass.addLogEntry(this.configPrefix, (byte)2, sqe.toString(), false);
                                            } else {
                                                this.modClass.addLogEntry(this.configPrefix, sqe, false);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        this.modClass.addLogEntry(this.configPrefix, (byte)3, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is idle, but an error occurred while moving client!", false);
                                        this.modClass.addLogEntry(this.configPrefix, e, false);
                                    }
                                }
                            }
                            if (this.timeIdleGroup > 0L && idleTime > this.timeIdleGroup && (this.IDLE_CHANNEL_LIST_IGNORE ? !result : result) && cachePosGroup == -1 && this.getLowestIdleTime(clientList, clientInfo.get("client_database_id")) > this.timeIdleGroup) {
                                result = this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_LIST);
                                if ((this.IDLE_GROUP_LIST_IGNORE ? !result : result) && !this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.groupidIdleGroup)) {
                                    HashMap<String, String> response = this.queryLib.doCommand("servergroupaddclient sgid=" + Integer.toString(this.groupidIdleGroup) + " cldbid=" + clientInfo.get("client_database_id"));
                                    if (response.get("id").equals("0")) {
                                        if (this.listClientsGrouped.indexOf(clientDBID) == -1) {
                                            this.listClientsGrouped.addElement(clientDBID);
                                        }
                                        this.updateServerGroups(clientList, clientInfo.get("client_database_id"), this.groupidIdleGroup, true);
                                        this.modClass.addLogEntry(this.configPrefix, (byte)1, "Added client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") to server group id " + Integer.toString(this.groupidIdleGroup) + " for being idle!", false);
                                        this.modClass.sendMessageToClient(this.configPrefix, this.modeIdleGroupMessage, clientID, this.messageIdleGroup);
                                        this.fel.clearException(clientDBID);
                                    } else {
                                        try {
                                            throw new TS3ServerQueryException("handleClientCheck()", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
                                        }
                                        catch (TS3ServerQueryException sqe) {
                                            if (this.fel.existsException(sqe, clientDBID)) break block57;
                                            this.fel.addException(sqe, clientDBID);
                                            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Error while adding client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") to server group id " + Integer.toString(this.groupidIdleGroup) + "!", false);
                                            if (sqe.getFailedPermissionID() < 0) {
                                                this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                                            }
                                            this.modClass.addLogEntry(this.configPrefix, sqe, false);
                                        }
                                    }
                                }
                            }
                        }
                        if (this.timeIdleKick > 0L && idleTime > this.timeIdleKick && (this.IDLE_CHANNEL_LIST_IGNORE ? !result : result)) {
                            result = this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_LIST);
                            if ((this.IDLE_GROUP_LIST_IGNORE ? !result : result) && this.kickClient(clientInfo, this.messageIdleKick, clientID)) {
                                clientList.removeElementAt(i2);
                                --i2;
                            }
                        }
                        if (this.timeIdleWarn > 0L && idleTime > this.timeIdleWarn) {
                            if (this.listClientsWarnSent.indexOf(clientID) == -1) {
                                if (channelID != this.channelidIdleMove && (this.IDLE_CHANNEL_LIST_IGNORE ? !result : result)) {
                                    result = this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_LIST);
                                    if (this.IDLE_GROUP_LIST_IGNORE ? !result : result) {
                                        if (!this.modClass.sendMessageToClient(this.configPrefix, this.modeIdleWarnMessage, clientID, this.messageIdleWarn)) {
                                            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to send idle warn message, maybe an invalid message mode in config file?", false);
                                        }
                                        this.listClientsWarnSentTemp.addElement(clientID);
                                    }
                                }
                            } else {
                                this.listClientsWarnSentTemp.addElement(clientID);
                            }
                        }
                        if (this.idleMoveBack && cachePosMove != -1 && idleTime < (long)(this.modClass.getCheckInterval() * 2000) && clientInfo.get("client_away").equals("0") && clientInfo.get("client_output_muted").equals("0") && clientInfo.get("client_input_muted").equals("0") && clientInfo.get("client_output_hardware").equals("1") && clientInfo.get("client_input_hardware").equals("1")) {
                            if (Integer.parseInt(clientInfo.get("cid")) != this.channelidIdleMove) {
                                this.listClientsMoved.removeElementAt(cachePosMove);
                                this.listClientsMovedChannel.removeElementAt(cachePosMove);
                            } else {
                                try {
                                    this.queryLib.moveClient(clientID, this.listClientsMovedChannel.elementAt(cachePosMove), null);
                                    clientInfo.put("cid", Integer.toString(this.listClientsMovedChannel.elementAt(cachePosMove)));
                                    this.listClientsMoved.removeElementAt(cachePosMove);
                                    this.listClientsMovedChannel.removeElementAt(cachePosMove);
                                    this.modClass.addLogEntry(this.configPrefix, (byte)1, "Client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is not idle anymore, client was moved back!", false);
                                    this.fel.clearException(clientDBID);
                                }
                                catch (TS3ServerQueryException sqe) {
                                    if (!this.fel.existsException(sqe, clientDBID)) {
                                        this.fel.addException(sqe, clientDBID);
                                        this.modClass.addLogEntry(this.configPrefix, (byte)2, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is not idle anymore, but an error occurred while moving back!", false);
                                        if (sqe.getFailedPermissionID() < 0) {
                                            this.modClass.addLogEntry(this.configPrefix, (byte)2, sqe.toString(), false);
                                        } else {
                                            this.modClass.addLogEntry(this.configPrefix, sqe, false);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    this.modClass.addLogEntry(this.configPrefix, (byte)3, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is not idle anymore, but an error occurred while moving back!", false);
                                    this.modClass.addLogEntry(this.configPrefix, e, false);
                                }
                            }
                        }
                    }
                    if (this.timeIdleGroup > 0L && cachePosGroup != -1 && idleTime < (long)(this.modClass.getCheckInterval() * 2000)) {
                        if (!this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.groupidIdleGroup)) {
                            this.listClientsGrouped.removeElementAt(cachePosGroup);
                        } else {
                            HashMap<String, String> response = this.queryLib.doCommand("servergroupdelclient sgid=" + Integer.toString(this.groupidIdleGroup) + " cldbid=" + clientInfo.get("client_database_id"));
                            if (response.get("id").equals("0")) {
                                this.listClientsGrouped.removeElementAt(cachePosGroup);
                                this.updateServerGroups(clientList, clientInfo.get("client_database_id"), this.groupidIdleGroup, false);
                                this.modClass.addLogEntry(this.configPrefix, (byte)1, "Removed client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") from server group id " + Integer.toString(this.groupidIdleGroup) + ", client is not idle anymore!", false);
                                this.fel.clearException(clientDBID);
                            } else {
                                try {
                                    throw new TS3ServerQueryException("handleClientCheck()", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
                                }
                                catch (TS3ServerQueryException sqe) {
                                    if (this.fel.existsException(sqe, clientDBID)) break block58;
                                    this.fel.addException(sqe, clientDBID);
                                    this.modClass.addLogEntry(this.configPrefix, (byte)3, "Error while removing client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") from server group id " + Integer.toString(this.groupidIdleGroup) + "!", false);
                                    if (sqe.getFailedPermissionID() < 0) {
                                        this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                                    }
                                    this.modClass.addLogEntry(this.configPrefix, sqe, false);
                                }
                            }
                        }
                    }
                }
            }
            ++i2;
        }
        if (this.timeIdleWarn > 0L) {
            this.listClientsWarnSent.clear();
            this.listClientsWarnSent.addAll(this.listClientsWarnSentTemp);
            this.listClientsWarnSentTemp.clear();
        }
        if (this.timeIdleGroup > 0L) {
            i = 0;
            while (i < this.listClientsGrouped.size()) {
                found = false;
                for (HashMap<String, String> hashMap : clientList) {
                    if (Integer.parseInt(hashMap.get("client_database_id")) != this.listClientsGrouped.elementAt(i)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.listClientsGrouped.removeElementAt(i);
                }
                ++i;
            }
        }
        if (this.timeIdleMove > 0L && this.idleMoveBack) {
            i = 0;
            while (i < this.listClientsMoved.size()) {
                found = false;
                for (HashMap<String, String> hashMap : clientList) {
                    if (Integer.parseInt(hashMap.get("clid")) != this.listClientsMoved.elementAt(i)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.listClientsMoved.removeElementAt(i);
                    this.listClientsMovedChannel.removeElementAt(i);
                }
                ++i;
            }
        }
    }

    private long getLowestIdleTime(Vector<HashMap<String, String>> clientList, String cldbID) {
        if (clientList == null) {
            return 0L;
        }
        if (cldbID == null) {
            return 0L;
        }
        long lowestIdleTime = Long.MAX_VALUE;
        long tempIdleTime = 0L;
        boolean found = false;
        int i = 0;
        while (i < clientList.size()) {
            if (clientList.elementAt(i).get("client_database_id").equals(cldbID)) {
                found = true;
                tempIdleTime = this.modClass.getIdleTime(clientList.elementAt(i), this.channelidIdleMove);
                if (lowestIdleTime > tempIdleTime) {
                    lowestIdleTime = tempIdleTime;
                }
            }
            ++i;
        }
        if (found) {
            return lowestIdleTime;
        }
        return 0L;
    }

    private void updateServerGroups(Vector<HashMap<String, String>> clientList, String cldbID, int sgID, boolean addSG) {
        if (clientList == null) {
            return;
        }
        if (cldbID == null) {
            return;
        }
        int i = 0;
        while (i < clientList.size()) {
            if (clientList.elementAt(i).get("client_database_id").equals(cldbID)) {
                Vector<Integer> newSGList = new Vector<Integer>();
                StringTokenizer groupTokenizer = new StringTokenizer(clientList.elementAt(i).get("client_servergroups"), ",", false);
                while (groupTokenizer.hasMoreTokens()) {
                    int groupID = Integer.parseInt(groupTokenizer.nextToken());
                    if (groupID == sgID) continue;
                    newSGList.addElement(groupID);
                }
                if (addSG) {
                    newSGList.addElement(sgID);
                }
                StringBuffer sbSGList = new StringBuffer();
                for (Integer iSGID : newSGList) {
                    if (sbSGList.length() > 0) {
                        sbSGList.append(",");
                    }
                    sbSGList.append(iSGID);
                }
                clientList.elementAt(i).put("client_servergroups", sbSGList.toString());
            }
            ++i;
        }
    }

    private boolean kickClient(HashMap<String, String> clientInfo, String kickMSG, int clientID) {
        boolean retValue = false;
        try {
            this.queryLib.kickClient(clientID, false, kickMSG);
            this.modClass.addLogEntry(this.configPrefix, (byte)1, "Client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") was idle, client was kicked!", false);
            this.fel.clearException(Integer.parseInt(clientInfo.get("client_database_id")));
            retValue = true;
        }
        catch (TS3ServerQueryException sqe) {
            if (!this.fel.existsException(sqe, Integer.parseInt(clientInfo.get("client_database_id")))) {
                this.fel.addException(sqe, Integer.parseInt(clientInfo.get("client_database_id")));
                this.modClass.addLogEntry(this.configPrefix, (byte)2, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is idle, but an error occurred while kicking client!", false);
                if (sqe.getFailedPermissionID() < 0) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)2, sqe.toString(), false);
                } else {
                    this.modClass.addLogEntry(this.configPrefix, sqe, false);
                }
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is idle, but an error occurred while kicking client!", false);
            this.modClass.addLogEntry(this.configPrefix, e, false);
        }
        return retValue;
    }

    private void createMessage() {
        if (this.timeIdleGroup > 0L) {
            this.messageIdleGroup = new String(this.messageIdleGroupConfig);
            this.messageIdleGroup = this.messageIdleGroup.replace("%IDLE_WARN_TIME%", Long.toString(this.timeIdleWarn / 1000L / 60L));
            this.messageIdleGroup = this.messageIdleGroup.replace("%IDLE_GROUP_TIME%", Long.toString(this.timeIdleGroup / 1000L / 60L));
            this.messageIdleGroup = this.messageIdleGroup.replace("%IDLE_MOVE_TIME%", Long.toString(this.timeIdleMove / 1000L / 60L));
            this.messageIdleGroup = this.messageIdleGroup.replace("%IDLE_KICK_TIME%", Long.toString(this.timeIdleKick / 1000L / 60L));
            if (this.timeIdleMove > 0L) {
                this.messageIdleGroup = this.messageIdleGroup.replace("%IDLE_CHANNEL_NAME%", this.channelName);
            }
            if (!this.modClass.isMessageLengthValid(this.modeIdleGroupMessage, this.messageIdleGroup)) {
                this.modClass.addLogEntry(this.configPrefix, (byte)2, "Idle Check group message is to long! Make sure that " + this.modeIdleMoveMessage + " messages are not longer than " + Short.toString(this.modClass.getMaxMessageLength(this.modeIdleMoveMessage)) + " characters (including spaces and BBCode)" + (this.modClass.getMySQLConnection() == null ? ", check file: " + this.IDLE_FILE : ""), true);
            }
        }
        if (this.timeIdleMove > 0L) {
            this.messageIdleMove = new String(this.messageIdleMoveConfig);
            this.messageIdleMove = this.messageIdleMove.replace("%IDLE_WARN_TIME%", Long.toString(this.timeIdleWarn / 1000L / 60L));
            this.messageIdleMove = this.messageIdleMove.replace("%IDLE_GROUP_TIME%", Long.toString(this.timeIdleGroup / 1000L / 60L));
            this.messageIdleMove = this.messageIdleMove.replace("%IDLE_MOVE_TIME%", Long.toString(this.timeIdleMove / 1000L / 60L));
            this.messageIdleMove = this.messageIdleMove.replace("%IDLE_KICK_TIME%", Long.toString(this.timeIdleKick / 1000L / 60L));
            this.messageIdleMove = this.messageIdleMove.replace("%IDLE_CHANNEL_NAME%", this.channelName);
            if (!this.modClass.isMessageLengthValid(this.modeIdleMoveMessage, this.messageIdleMove)) {
                this.modClass.addLogEntry(this.configPrefix, (byte)2, "Idle Check move message is to long! Make sure that " + this.modeIdleMoveMessage + " messages are not longer than " + Short.toString(this.modClass.getMaxMessageLength(this.modeIdleMoveMessage)) + " characters (including spaces and BBCode)" + (this.modClass.getMySQLConnection() == null ? ", check file: " + this.IDLE_FILE : ""), true);
            }
        }
        if (this.timeIdleWarn > 0L) {
            this.messageIdleWarn = new String(this.messageIdleWarnConfig);
            this.messageIdleWarn = this.messageIdleWarn.replace("%IDLE_WARN_TIME%", Long.toString(this.timeIdleWarn / 1000L / 60L));
            this.messageIdleWarn = this.messageIdleWarn.replace("%IDLE_GROUP_TIME%", Long.toString(this.timeIdleGroup / 1000L / 60L));
            this.messageIdleWarn = this.messageIdleWarn.replace("%IDLE_MOVE_TIME%", Long.toString(this.timeIdleMove / 1000L / 60L));
            this.messageIdleWarn = this.messageIdleWarn.replace("%IDLE_KICK_TIME%", Long.toString(this.timeIdleKick / 1000L / 60L));
            if (this.timeIdleMove > 0L) {
                this.messageIdleWarn = this.messageIdleWarn.replace("%IDLE_CHANNEL_NAME%", this.channelName);
            }
            if (!this.modClass.isMessageLengthValid(this.modeIdleWarnMessage, this.messageIdleWarn)) {
                this.modClass.addLogEntry(this.configPrefix, (byte)2, "Idle Check warn message is to long! Make sure that " + this.modeIdleWarnMessage + " messages are not longer than " + Short.toString(this.modClass.getMaxMessageLength(this.modeIdleWarnMessage)) + " characters (including spaces and BBCode)" + (this.modClass.getMySQLConnection() == null ? ", check file: " + this.IDLE_FILE : ""), true);
            }
        }
        if (this.timeIdleKick > 0L) {
            this.messageIdleKick = new String(this.messageIdleKickConfig);
            this.messageIdleKick = this.messageIdleKick.replace("%IDLE_KICK_TIME%", Long.toString(this.timeIdleKick / 1000L / 60L));
            if (!this.modClass.isMessageLengthValid("kick", this.messageIdleKick)) {
                this.modClass.addLogEntry(this.configPrefix, (byte)2, "Idle Check kick message is to long! Make sure that kick messages are not longer than " + Short.toString(this.modClass.getMaxMessageLength("kick")) + " characters (including spaces and BBCode)" + (this.modClass.getMySQLConnection() == null ? ", check file: " + this.IDLE_FILE : ""), true);
            }
        }
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Idle Check function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }
}

