/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod;

import de.stefan1200.jts3servermod.InstanceManagerServer;
import de.stefan1200.jts3servermod.JTS3ServerMod;
import de.stefan1200.jts3servermod.MyLogger;
import de.stefan1200.util.DatatypeConverter;
import de.stefan1200.util.MySQLConnect;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Pattern;

public class InstanceManager {
    public static final String DEFAULT_LOG_FILE_PATH = "JTS3ServerMod_InstanceManager.log";
    public static final String DEFAULT_CONFIG_FILE_PATH = "config/JTS3ServerMod_InstanceManager.cfg";
    private String CONFIG_FILE_NAME = "config/JTS3ServerMod_InstanceManager.cfg";
    private String LOG_FILE_NAME = "JTS3ServerMod_InstanceManager.log";
    private Vector<String> FULL_ADMIN_UID_LIST = new Vector();
    private Vector<JTS3ServerMod> instanceClass = new Vector();
    private Vector<String> instanceConfigFilePath = new Vector();
    private Vector<String> instanceLogFilePath = new Vector();
    private Vector<String> instanceCSVLogFilePath = new Vector();
    private Vector<String> instanceName = new Vector();
    private Vector<Boolean> instanceDebug = new Vector();
    private Vector<Boolean> instanceEnabled = new Vector();
    private Vector<Integer> instanceID = new Vector();
    private Vector<JTS3ServerMod> instanceClassReloadTemp = new Vector();
    private Vector<String> instanceConfigFilePathReloadTemp = new Vector();
    private Vector<String> instanceLogFilePathReloadTemp = new Vector();
    private Vector<String> instanceCSVLogFilePathReloadTemp = new Vector();
    private Vector<String> instanceNameReloadTemp = new Vector();
    private Vector<Boolean> instanceDebugReloadTemp = new Vector();
    private Vector<Boolean> instanceEnabledReloadTemp = new Vector();
    private Vector<Integer> instanceIDReloadTemp = new Vector();
    private Vector<String> telnetWhitelist = new Vector();
    private Vector<Long> instanceFloodProtect = new Vector();
    private SimpleDateFormat sdfDebug = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private PrintStream logFile = null;
    private InstanceManagerServer botManagerServer = null;
    private MySQLConnect mysqlConnect = null;
    private MyLogger logger = null;
    private Pattern patternBotName = Pattern.compile("[a-z0-9\\_\\-]+", 66);
    private Timer botTimer = null;
    private TimerTask timerCheck = null;
    private TimerTask timerLogDelete = null;
    private int instancesRunningCount = 0;
    private byte botUpdateCheck = 0;
    private boolean botCommandExec = false;
    private boolean alreadyStopped = false;
    private boolean telnetEnable = false;
    private boolean telnetConnectionLog = false;
    private boolean telnetRunForever = false;
    private int telnetPort = -1;
    private String telnetAdminPW = null;
    private String telnetBindTo = null;
    private boolean firstInit = true;
    private boolean mysqlMode = false;
    private String mysqlHost = null;
    private int mysqlPort = 3306;
    private String mysqlDB = null;
    private String mysqlUser = null;
    private String mysqlPW = null;
    private int mysqlLogDelete = 0;
    private int mysqlConnectionLogDelete = 0;
    private byte mysqlVerifyServerCertificate = (byte)-1;
    private byte mysqlUseSSL = (byte)-1;
    private byte mysqlRequireSSL = (byte)-1;
    private byte mysqlUseCompression = (byte)-1;
    private Vector<Integer> portList = new Vector();
    private Vector<Integer> portListUsed = new Vector();
    private String ipMain = null;
    private String ipChat = null;
    private String ipCache = null;
    private int delayBotStart = 1000;
    private File lockFile = null;
    private String cryptKey = "";

    public InstanceManager(String instanceConfig, String instanceLog) {
        if (instanceConfig != null) {
            this.CONFIG_FILE_NAME = instanceConfig;
        }
        if (instanceLog != null) {
            this.LOG_FILE_NAME = instanceLog;
        }
        String msg = null;
        if (this.LOG_FILE_NAME != null) {
            String errorMessage = null;
            File logFileCheck = new File(this.LOG_FILE_NAME);
            try {
                if (logFileCheck.exists()) {
                    File oldLogFileCheck = new File(String.valueOf(this.LOG_FILE_NAME) + ".old");
                    if (oldLogFileCheck.exists()) {
                        if (oldLogFileCheck.delete()) {
                            if (!logFileCheck.renameTo(oldLogFileCheck)) {
                                errorMessage = "Unable to rename file " + this.LOG_FILE_NAME + " to " + this.LOG_FILE_NAME + ".old";
                            }
                        } else {
                            errorMessage = "Unable to delete file " + this.LOG_FILE_NAME + ".old";
                        }
                    } else if (!logFileCheck.renameTo(oldLogFileCheck)) {
                        errorMessage = "Unable to rename file " + this.LOG_FILE_NAME + " to " + this.LOG_FILE_NAME + ".old";
                    }
                }
            }
            catch (Exception e) {
                errorMessage = e.toString();
            }
            try {
                if (this.LOG_FILE_NAME.length() > 4) {
                    this.logFile = new PrintStream((OutputStream)new FileOutputStream(this.LOG_FILE_NAME, true), true, "UTF-8");
                    msg = "Writing InstanceManager log file to: " + logFileCheck.getAbsolutePath();
                    if (errorMessage != null) {
                        this.addLogEntry("LOGFILE", "Error while checking old logfile: " + errorMessage, false);
                    }
                } else {
                    this.logFile = null;
                }
            }
            catch (Exception e) {
                this.logFile = null;
                System.out.println("Error while creating log file: " + this.LOG_FILE_NAME);
                e.printStackTrace();
            }
        }
        this.addLogEntry("START_MANAGER", "JTS3ServerMod 6.5.8 Hosting Edition (16.12.2023) Instance Manager started...", true);
        this.addLogEntry("SYSTEM_INFO", "Operating System : " + System.getProperty("os.name") + " (version: " + System.getProperty("os.version") + " / arch: " + System.getProperty("os.arch") + ")", true);
        this.addLogEntry("SYSTEM_INFO", "Used Java Version: " + System.getProperty("java.version") + " (path: " + System.getProperty("java.home") + ")", true);
        this.addLogEntry("SYSTEM_INFO", "Current directory: " + System.getProperty("user.dir"), true);
        if (msg != null) {
            System.out.println(msg);
        }
        if (!this.loadConfig()) {
            msg = "Error while loading the JTS3ServerMod InstanceManager config file, read error messages above to know more. Quitting now...";
            this.addLogEntry("QUIT_MANAGER", msg, true);
        } else if (this.startAllInstances() == 0 && !this.telnetRunForever) {
            msg = "No instances enabled or needed entries missing in InstanceManager config file, quitting now...";
            this.addLogEntry("QUIT_MANAGER", msg, true);
        } else {
            this.firstInit = false;
            Runtime runtime = Runtime.getRuntime();
            runtime.addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    if (!InstanceManager.this.alreadyStopped) {
                        InstanceManager.this.stopAllInstances(true, "SHUTDOWN", "Got signal from operating system or the last virtual bot instance was stopped, quitting now...");
                    }
                }
            }));
            if (this.telnetEnable) {
                this.botManagerServer = new InstanceManagerServer(this, this.telnetPort, this.telnetAdminPW, this.telnetWhitelist, this.telnetBindTo);
                this.botManagerServer.setName("InstanceManagerServer");
                this.botManagerServer.start();
            }
        }
    }

    public InstanceManager(String instanceConfig) {
        if (instanceConfig != null) {
            this.CONFIG_FILE_NAME = instanceConfig;
        }
        System.out.println("JTS3ServerMod 6.5.8 Hosting Edition (16.12.2023) checking and updating config files...");
        if (!this.loadConfig()) {
            System.out.println("InstanceManager config file does not exists or is not readable, quitting now...");
        } else if (this.mysqlMode) {
            System.out.println("MySQL mode activated, updating configuration is not needed! Quitting now...");
        } else if (this.updateConfigAllInstances() == 0) {
            System.out.println("No instances updated or needed entries missing in InstanceManager config file, quitting now...");
        }
    }

    String getMainIP() {
        return this.ipMain;
    }

    String getChatIP() {
        return this.ipChat;
    }

    String getCacheIP() {
        return this.ipCache;
    }

    boolean isMultiIPModeEnabled() {
        return this.portList.size() != 0;
    }

    boolean isDebugModeEnabled(JTS3ServerMod botClass) {
        try {
            return this.instanceDebug.elementAt(this.instanceClass.indexOf(botClass));
        }
        catch (Exception e) {
            return false;
        }
    }

    String getConnectionLogPath(JTS3ServerMod botClass) {
        try {
            return this.instanceCSVLogFilePath.elementAt(this.instanceClass.indexOf(botClass));
        }
        catch (Exception e) {
            return null;
        }
    }

    boolean isCommandExecAllowed() {
        return this.botCommandExec;
    }

    Vector<String> getFullBotAdminList() {
        return this.FULL_ADMIN_UID_LIST;
    }

    byte getBotUpdateCheckState() {
        return this.botUpdateCheck;
    }

    synchronized int getNextFreePort() {
        if (this.portList.size() > 0) {
            int retValue = this.portList.elementAt(0);
            this.portList.removeElementAt(0);
            this.portListUsed.addElement(retValue);
            return retValue;
        }
        return -1;
    }

    private void fillPortList(int min, int max) {
        int i = min;
        while (i <= max) {
            this.portList.addElement(i);
            ++i;
        }
    }

    synchronized void releasePort(int port) {
        if (this.portListUsed.indexOf(port) != -1 && this.portList.indexOf(port) == -1) {
            this.portList.addElement(port);
            this.portListUsed.removeElement(port);
        }
    }

    private boolean isFloodProtected(int i) {
        return this.instanceFloodProtect.elementAt(i) > System.currentTimeMillis() - 5000L;
    }

    private void resetFloodProtect() {
        this.instanceFloodProtect.clear();
        int i = 0;
        while (i < this.instanceName.size()) {
            this.instanceFloodProtect.addElement(0L);
            ++i;
        }
    }

    void removeInstance(JTS3ServerMod instance) {
        int i = 0;
        while (i < this.instanceClass.size()) {
            if (this.instanceClass.elementAt(i) == instance) {
                this.logger.removeLogInstance(this.instanceID.elementAt(i));
                this.instanceClass.setElementAt(null, i);
                --this.instancesRunningCount;
                break;
            }
            ++i;
        }
        if (this.instancesRunningCount == 0 && !this.alreadyStopped) {
            this.stopAllInstances(false);
        }
    }

    int getInstancesRunningCount() {
        return this.instancesRunningCount;
    }

    int isInstanceRunning(String name) {
        if (name == null || name.length() < 1) {
            return -1;
        }
        int i = 0;
        while (i < this.instanceName.size()) {
            if (this.instanceName.elementAt(i).equalsIgnoreCase(name)) {
                if (this.instanceClass.elementAt(i) == null) {
                    return 0;
                }
                return 1;
            }
            ++i;
        }
        return -1;
    }

    String getAllInstanceStatusString() {
        StringBuffer sbStatusString = new StringBuffer();
        int i = 0;
        while (i < this.instanceName.size()) {
            if (sbStatusString.length() > 0) {
                sbStatusString.append(",");
            }
            sbStatusString.append(this.instanceName.elementAt(i));
            if (this.instanceClass.elementAt(i) == null) {
                sbStatusString.append(":0");
            } else {
                sbStatusString.append(":1");
            }
            ++i;
        }
        return sbStatusString.toString();
    }

    Vector<String> getInstanceNames() {
        Vector<String> retList = new Vector<String>();
        retList.addAll(this.instanceName);
        return retList;
    }

    boolean reloadInstance(String name, String telnetIP) {
        if (name == null || name.length() < 1) {
            return false;
        }
        int i = 0;
        while (i < this.instanceName.size()) {
            if (this.instanceName.elementAt(i).equalsIgnoreCase(name)) {
                if (this.isFloodProtected(i)) {
                    return false;
                }
                if (this.instanceClass.elementAt(i) != null) {
                    this.instanceFloodProtect.setElementAt(System.currentTimeMillis(), i);
                    if (telnetIP != null) {
                        this.instanceClass.elementAt(i).addLogEntry((byte)1, "Got telnet command to reload the bot...", false);
                        this.addLogEntry("RELOAD_INSTANCE", "Got telnet command from " + telnetIP + " to reload virtual bot instance " + this.instanceName.elementAt(i) + "...", false);
                    } else {
                        this.addLogEntry("RELOAD_INSTANCE", "Reload virtual bot instance " + this.instanceName.elementAt(i) + "...", false);
                    }
                    this.instanceClass.elementAt(i).stopBotInstance(2);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    int reloadInstanceConfig(String name, String telnetIP) {
        if (name == null || name.length() < 1) {
            return -10;
        }
        int i = 0;
        while (i < this.instanceName.size()) {
            if (this.instanceName.elementAt(i).equalsIgnoreCase(name)) {
                if (this.isFloodProtected(i)) {
                    return -8;
                }
                if (this.instanceClass.elementAt(i) != null) {
                    this.instanceFloodProtect.setElementAt(System.currentTimeMillis(), i);
                    if (telnetIP != null) {
                        this.instanceClass.elementAt(i).addLogEntry((byte)1, "Got telnet command to reload bot configuration...", false);
                        this.addLogEntry("RELOAD_INSTANCE", "Got telnet command from " + telnetIP + " to reload bot configuration of the virtual bot instance " + this.instanceName.elementAt(i) + "...", false);
                    }
                    if (this.instanceClass.elementAt(i).loadConfigValues()) {
                        int[] count = this.instanceClass.elementAt(i).reloadConfig(false);
                        return count[1];
                    }
                    return -1;
                }
            }
            ++i;
        }
        return -9;
    }

    int activateBotFunction(String botName, String functionPrefix) {
        if (botName == null || botName.length() < 1) {
            return -10;
        }
        int i = 0;
        while (i < this.instanceName.size()) {
            if (this.instanceName.elementAt(i).equalsIgnoreCase(botName)) {
                if (this.isFloodProtected(i)) {
                    return -8;
                }
                if (this.instanceClass.elementAt(i) != null) {
                    this.instanceFloodProtect.setElementAt(System.currentTimeMillis(), i);
                    return this.instanceClass.elementAt(i).activateFunction(functionPrefix);
                }
            }
            ++i;
        }
        return -9;
    }

    int disableBotFunction(String botName, String functionPrefix) {
        if (botName == null || botName.length() < 1) {
            return -10;
        }
        int i = 0;
        while (i < this.instanceName.size()) {
            if (this.instanceName.elementAt(i).equalsIgnoreCase(botName)) {
                if (this.isFloodProtected(i)) {
                    return -8;
                }
                if (this.instanceClass.elementAt(i) != null) {
                    this.instanceFloodProtect.setElementAt(System.currentTimeMillis(), i);
                    return this.instanceClass.elementAt(i).disableFunction(functionPrefix);
                }
            }
            ++i;
        }
        return -9;
    }

    boolean stopInstance(String name, String telnetIP) {
        if (name == null || name.length() < 1) {
            return false;
        }
        int i = 0;
        while (i < this.instanceName.size()) {
            if (this.instanceName.elementAt(i).equalsIgnoreCase(name)) {
                if (this.isFloodProtected(i)) {
                    return false;
                }
                if (this.instanceClass.elementAt(i) != null) {
                    this.instanceFloodProtect.setElementAt(System.currentTimeMillis(), i);
                    if (telnetIP != null) {
                        this.instanceClass.elementAt(i).addLogEntry((byte)1, "Got telnet command to stop the bot...", false);
                        this.addLogEntry("STOP_INSTANCE", "Got telnet command from " + telnetIP + " to stop virtual bot instance " + this.instanceName.elementAt(i) + "...", false);
                    } else {
                        this.addLogEntry("STOP_INSTANCE", "Stop virtual bot instance " + this.instanceName.elementAt(i) + "...", false);
                    }
                    this.instanceClass.elementAt(i).stopBotInstance(0);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    void stopAllInstances(boolean forceQuit) {
        this.stopAllInstances(forceQuit, null, null);
    }

    void stopAllInstances(boolean forceQuit, String messageType, String message) {
        if (messageType != null && message != null) {
            this.addLogEntry(messageType, message, false);
        }
        if (this.getInstancesRunningCount() > 0) {
            this.addLogEntry("STOP_ALL", "Stopping all bots, please wait...", true);
        }
        if (!this.telnetRunForever || forceQuit) {
            this.addLogEntry("QUIT_MANAGER", "Quit instance manager...", false);
            this.alreadyStopped = true;
            if (this.botManagerServer != null) {
                this.botManagerServer.interrupt();
            }
            if (this.timerCheck != null) {
                this.timerCheck.cancel();
            }
            if (this.timerLogDelete != null) {
                this.timerLogDelete.cancel();
            }
            if (this.botTimer != null) {
                this.botTimer.cancel();
            }
        }
        int i = 0;
        while (i < this.instanceClass.size()) {
            if (this.instanceClass.elementAt(i) != null) {
                this.instanceClass.elementAt(i).stopBotInstance(0);
            }
            ++i;
        }
        if (!this.telnetRunForever || forceQuit) {
            int countTimer = 0;
            while (countTimer < 10) {
                ++countTimer;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void reloadAllInstances() {
        this.addLogEntry("RELOAD_ALL", "Reload all virtual bot instances...", false);
        int i = 0;
        while (i < this.instanceClass.size()) {
            if (this.instanceClass.elementAt(i) != null) {
                this.instanceClass.elementAt(i).stopBotInstance(2);
            }
            ++i;
        }
    }

    private boolean startInstance(int i, String telnetIP) {
        if (this.isFloodProtected(i)) {
            return false;
        }
        if (this.instanceClass.elementAt(i) == null) {
            this.instanceFloodProtect.setElementAt(System.currentTimeMillis(), i);
            boolean configOK = false;
            if (this.mysqlMode) {
                configOK = true;
            } else {
                File instanceFile = new File(this.instanceConfigFilePath.elementAt(i));
                configOK = instanceFile.isFile();
            }
            if (configOK) {
                if (telnetIP != null) {
                    this.addLogEntry("START_INSTANCE", "Got telnet command from " + telnetIP + " to start virtual bot instance " + this.instanceName.elementAt(i) + "...", false);
                } else {
                    this.addLogEntry("START_INSTANCE", "Start virtual bot instance " + this.instanceName.elementAt(i) + "...", false);
                }
                try {
                    this.logger.addLogInstance(this.instanceID.elementAt(i), this.instanceName.elementAt(i), this.instanceLogFilePath.elementAt(i), this.instanceDebug.elementAt(i) != false ? (byte)0 : 1);
                    this.instanceClass.setElementAt(new JTS3ServerMod(this, this.instanceName.elementAt(i), this.instanceConfigFilePath.elementAt(i), this.instanceLogFilePath.elementAt(i), this.cryptKey, this.mysqlMode, this.instanceID.elementAt(i), this.mysqlMode ? new MySQLConnect(this.mysqlHost, this.mysqlPort, this.mysqlDB, this.mysqlUser, this.mysqlPW, this.mysqlVerifyServerCertificate, this.mysqlUseSSL, this.mysqlRequireSSL, this.mysqlUseCompression) : null, this.logger), i);
                    this.logger.updateLogInstanceClass(this.instanceID.elementAt(i), this.instanceClass.elementAt(i));
                    ++this.instancesRunningCount;
                    this.instanceClass.elementAt(i).runThread();
                }
                catch (Throwable e) {
                    this.addLogEntry("CHECK_INSTANCE", "Unknown error occurred while starting virtual bot instance " + this.instanceName.elementAt(i) + ": " + e.toString(), true);
                    this.addLogEntry(e);
                    this.instanceClass.setElementAt(null, i);
                    return false;
                }
                return true;
            }
            this.addLogEntry("CHECK_INSTANCE", "Config file of virtual bot instance " + this.instanceName.elementAt(i) + " is missing! Start of this virtual bot instance skipped...", true);
        } else {
            this.addLogEntry("CHECK_INSTANCE", "Virtual bot Instance " + this.instanceName.elementAt(i) + " already running...", true);
        }
        return false;
    }

    boolean startInstance(String name, String telnetIP) {
        if (name == null || name.length() < 1) {
            return false;
        }
        int i = 0;
        while (i < this.instanceName.size()) {
            if (this.instanceName.elementAt(i).equalsIgnoreCase(name)) {
                return this.startInstance(i, telnetIP);
            }
            ++i;
        }
        return false;
    }

    private int startAllInstances() {
        int count = 0;
        int i = 0;
        while (i < this.instanceEnabled.size()) {
            if (this.instanceEnabled.elementAt(i).booleanValue() && this.startInstance(i, null)) {
                ++count;
                try {
                    Thread.sleep(this.delayBotStart);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return count;
    }

    private int updateConfigAllInstances() {
        int count = 0;
        int i = 0;
        while (i < this.instanceEnabled.size()) {
            if (this.instanceEnabled.elementAt(i).booleanValue() && this.updateInstance(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private boolean updateInstance(int i) {
        File instanceFile = new File(this.instanceConfigFilePath.elementAt(i));
        if (instanceFile.isFile()) {
            this.addLogEntry("UPDATE_INSTANCE", "Update config file of virtual bot instance " + this.instanceName.elementAt(i) + "...", false);
            new JTS3ServerMod(this.instanceName.elementAt(i), this.instanceConfigFilePath.elementAt(i));
            return true;
        }
        this.addLogEntry("CHECK_INSTANCE", "Config file of virtual bot instance " + this.instanceName.elementAt(i) + " is missing! Update config file of this virtual bot instance skipped...", true);
        return false;
    }

    boolean renameInstance(String oldName, String newName) {
        if (oldName == null || oldName.length() < 1) {
            return false;
        }
        if (newName == null || newName.length() < 1 || !this.patternBotName.matcher(newName).matches()) {
            return false;
        }
        int i = 0;
        while (i < this.instanceName.size()) {
            if (this.instanceName.elementAt(i).equalsIgnoreCase(oldName)) {
                if (this.isFloodProtected(i)) {
                    return false;
                }
                if (this.instanceClass.elementAt(i) != null) {
                    this.instanceClass.elementAt(i).renameBotInstance(newName);
                }
                this.instanceFloodProtect.setElementAt(System.currentTimeMillis(), i);
                this.instanceName.setElementAt(newName, i);
                this.logger.updateBotName(this.instanceID.elementAt(i), newName);
                return true;
            }
            ++i;
        }
        return false;
    }

    void reconnectMySQLLogger() {
        this.logger.initDB();
    }

    boolean loadConfig() {
        File confFile;
        boolean retValue;
        block74: {
            retValue = false;
            confFile = new File(this.CONFIG_FILE_NAME);
            if (confFile.isFile()) break block74;
            this.addLogEntry("CONFIG", "JTS3ServerMod InstanceManager configuration file does not exists, check file path:", true);
            this.addLogEntry("CONFIG", confFile.getAbsolutePath(), true);
            return false;
        }
        try {
            String temp;
            if (this.lockFile == null) {
                this.lockFile = new File(String.valueOf(this.CONFIG_FILE_NAME) + ".lock");
                if (this.lockFile.exists()) {
                    this.addLogEntry("LOCK_FILE", "", true);
                    this.addLogEntry("LOCK_FILE", "************************************************************************************************", true);
                    this.addLogEntry("LOCK_FILE", "Lock file still exists, it seems this JTS3ServerMod process is running twice! Please check this!", true);
                    this.addLogEntry("LOCK_FILE", "If you are sure, that the JTS3ServerMod process is not running twice, delete the file:", true);
                    this.addLogEntry("LOCK_FILE", this.lockFile.getAbsolutePath(), true);
                    this.addLogEntry("LOCK_FILE", "************************************************************************************************", true);
                    this.addLogEntry("LOCK_FILE", "", true);
                } else {
                    try {
                        this.lockFile.createNewFile();
                        this.lockFile.deleteOnExit();
                    }
                    catch (Exception e) {
                        this.addLogEntry("LOCK_FILE", "Unable to create lock file, reason: " + e.toString(), true);
                    }
                }
            }
            Properties prop = new Properties();
            prop.load(new FileInputStream(confFile));
            if (this.firstInit) {
                this.addLogEntry("CONFIG", "Loading InstanceManager config file from: " + confFile.getAbsolutePath(), true);
            } else {
                this.addLogEntry("CONFIG", "Reloading InstanceManager config file from: " + confFile.getAbsolutePath(), false);
            }
            this.FULL_ADMIN_UID_LIST.clear();
            String fulladminListTemp = prop.getProperty("bot_fulladmin_list");
            if (fulladminListTemp != null) {
                StringTokenizer fulladminListTokenizer = new StringTokenizer(fulladminListTemp, ",", false);
                while (fulladminListTokenizer.hasMoreTokens()) {
                    this.FULL_ADMIN_UID_LIST.addElement(fulladminListTokenizer.nextToken().trim());
                }
            }
            if ((temp = prop.getProperty("bot_command_exec", "0")).equals("1")) {
                if (this.firstInit || !this.botCommandExec) {
                    this.addLogEntry("CONFIG", "Bot chat command !exec is enabled!", true);
                }
                this.botCommandExec = true;
            } else {
                if (this.firstInit || this.botCommandExec) {
                    this.addLogEntry("CONFIG", "Bot chat command !exec is disabled!", false);
                }
                this.botCommandExec = false;
            }
            try {
                this.botUpdateCheck = Byte.parseByte(prop.getProperty("bot_update_check", "0").trim());
            }
            catch (Exception e) {
                this.botUpdateCheck = 0;
            }
            temp = prop.getProperty("telnet_connection_log", "1");
            this.telnetConnectionLog = temp.equals("1");
            if (this.firstInit) {
                temp = prop.getProperty("delay_bot_start", "100");
                try {
                    this.delayBotStart = Integer.parseInt(temp);
                }
                catch (Exception e) {
                    this.delayBotStart = 100;
                }
                this.portList.clear();
                temp = prop.getProperty("multiipmode_enable", "0");
                if (temp.equals("1")) {
                    this.ipMain = prop.getProperty("multiipmode_ip_main");
                    this.ipChat = prop.getProperty("multiipmode_ip_chat");
                    this.ipCache = prop.getProperty("multiipmode_ip_cache");
                    if (this.ipMain == null && this.ipChat == null && this.ipCache == null) {
                        this.addLogEntry("CONFIG", "Multi IP Mode disabled, all three IP addresses must be set!", true);
                    } else {
                        this.ipMain = this.ipMain.trim();
                        this.ipChat = this.ipChat.trim();
                        this.ipCache = this.ipCache.trim();
                        if (this.ipMain.equals(this.ipChat) || this.ipChat.equals(this.ipCache) || this.ipCache.equals(this.ipMain)) {
                            this.addLogEntry("CONFIG", "Multi IP Mode disabled, all three IP addresses must be different!", true);
                            this.ipMain = null;
                            this.ipChat = null;
                            this.ipCache = null;
                        } else {
                            int portMin = -1;
                            try {
                                portMin = Integer.parseInt(prop.getProperty("multiipmode_portrange_min", "50000"));
                            }
                            catch (Exception e) {
                                portMin = -1;
                            }
                            int portMax = -1;
                            try {
                                portMax = Integer.parseInt(prop.getProperty("multiipmode_portrange_max", "51999"));
                            }
                            catch (Exception e) {
                                portMax = -1;
                            }
                            if (portMax <= portMin) {
                                this.addLogEntry("CONFIG", "Multi IP Mode disabled, port range max must be a higher value than port range min!", true);
                                this.ipMain = null;
                                this.ipChat = null;
                                this.ipCache = null;
                            } else if (portMax > 65535) {
                                this.addLogEntry("CONFIG", "Multi IP Mode disabled, port range max must be a lower value than 65536!", true);
                                this.ipMain = null;
                                this.ipChat = null;
                                this.ipCache = null;
                            } else if (portMin < 1024) {
                                this.addLogEntry("CONFIG", "Multi IP Mode disabled, port range min must be a higher value than 1023!", true);
                                this.ipMain = null;
                                this.ipChat = null;
                                this.ipCache = null;
                            } else {
                                this.fillPortList(portMin, portMax);
                                this.addLogEntry("CONFIG", "Multi IP Mode enabled, using port range " + Integer.toString(portMin) + " - " + Integer.toString(portMax), true);
                            }
                        }
                    }
                } else {
                    this.addLogEntry("CONFIG", "Multi IP Mode disabled!", false);
                }
                temp = prop.getProperty("telnet_enable", "0");
                if (temp.equals("1")) {
                    String telnetWhitelistTemp;
                    this.telnetEnable = true;
                    temp = prop.getProperty("telnet_run_forever", "0");
                    if (temp.equals("1")) {
                        this.telnetRunForever = true;
                    }
                    if ((telnetWhitelistTemp = prop.getProperty("telnet_whitelist")) != null) {
                        StringTokenizer telnetWhitelistTokenizer = new StringTokenizer(telnetWhitelistTemp, ",", false);
                        while (telnetWhitelistTokenizer.hasMoreTokens()) {
                            this.telnetWhitelist.addElement(telnetWhitelistTokenizer.nextToken().trim());
                        }
                    }
                    try {
                        this.telnetPort = Integer.parseInt(prop.getProperty("telnet_port", "-1"));
                    }
                    catch (Exception e) {
                        this.telnetPort = -1;
                    }
                    this.telnetAdminPW = prop.getProperty("telnet_password", "").trim();
                    this.telnetBindTo = prop.getProperty("telnet_bindTo");
                    if (this.telnetBindTo != null && this.telnetBindTo.length() < 3) {
                        this.telnetBindTo = null;
                    }
                } else {
                    this.addLogEntry("CONFIG", "Telnet server disabled!", false);
                }
                if ((temp = prop.getProperty("mysql_enable", "0")).equals("1")) {
                    this.mysqlMode = true;
                    this.mysqlHost = prop.getProperty("mysql_host");
                    if (this.mysqlHost == null || this.mysqlHost.length() == 0) {
                        this.mysqlMode = false;
                    }
                    try {
                        this.mysqlPort = Integer.parseInt(prop.getProperty("mysql_port", "-1"));
                        if (this.mysqlPort < 0 || this.mysqlPort > 65535) {
                            this.mysqlMode = false;
                        }
                    }
                    catch (Exception e) {
                        this.mysqlMode = false;
                    }
                    this.mysqlUser = prop.getProperty("mysql_user");
                    if (this.mysqlUser == null || this.mysqlUser.length() == 0) {
                        this.mysqlMode = false;
                    }
                    this.mysqlPW = prop.getProperty("mysql_password");
                    if (this.mysqlPW == null) {
                        this.mysqlMode = false;
                    } else {
                        this.mysqlPW = this.mysqlPW.trim();
                    }
                    this.mysqlDB = prop.getProperty("mysql_database");
                    if (this.mysqlDB == null || this.mysqlDB.length() == 0) {
                        this.mysqlMode = false;
                    }
                    this.mysqlVerifyServerCertificate = Byte.parseByte(prop.getProperty("mysql_verifyServerCertificate", "-1"));
                    this.mysqlUseSSL = Byte.parseByte(prop.getProperty("mysql_useSSL", "-1"));
                    this.mysqlRequireSSL = Byte.parseByte(prop.getProperty("mysql_requireSSL", "-1"));
                    this.mysqlUseCompression = Byte.parseByte(prop.getProperty("mysql_useCompression", "-1"));
                    try {
                        this.mysqlLogDelete = Integer.parseInt(prop.getProperty("mysql_log_delete", "0"));
                        if (this.mysqlLogDelete > 0) {
                            this.addLogEntry("CONFIG", "Automatic MySQL log delete for entries older than " + Integer.toString(this.mysqlLogDelete) + " days is activated!", false);
                        }
                    }
                    catch (Exception e) {
                        this.mysqlLogDelete = 0;
                    }
                    try {
                        this.mysqlConnectionLogDelete = Integer.parseInt(prop.getProperty("mysql_connection_log_delete", "0"));
                        if (this.mysqlConnectionLogDelete > 0) {
                            this.addLogEntry("CONFIG", "Automatic MySQL connection log delete for entries older than " + Integer.toString(this.mysqlConnectionLogDelete) + " days is activated!", false);
                        }
                    }
                    catch (Exception e) {
                        this.mysqlConnectionLogDelete = 0;
                    }
                }
                if ((temp = prop.getProperty("crypt_key", "").trim()).length() > 0) {
                    this.cryptKey = this.hashStringCrypt(temp);
                }
                if (this.mysqlMode) {
                    this.mysqlConnect = new MySQLConnect(this.mysqlHost, this.mysqlPort, this.mysqlDB, this.mysqlUser, this.mysqlPW, this.mysqlVerifyServerCertificate, this.mysqlUseSSL, this.mysqlRequireSSL, this.mysqlUseCompression);
                    this.logger = new MyLogger(new MySQLConnect(this.mysqlHost, this.mysqlPort, this.mysqlDB, this.mysqlUser, this.mysqlPW, this.mysqlVerifyServerCertificate, this.mysqlUseSSL, this.mysqlRequireSSL, this.mysqlUseCompression), this);
                    this.botTimer = new Timer(true);
                    this.timerCheck = new TimerTask(){

                        @Override
                        public void run() {
                            InstanceManager.this.reconnectMySQLLogger();
                        }
                    };
                    this.botTimer.schedule(this.timerCheck, 3600000L, 3600000L);
                    if (this.mysqlLogDelete > 0 || this.mysqlConnectionLogDelete > 0) {
                        this.timerLogDelete = new TimerTask(){

                            @Override
                            public void run() {
                                InstanceManager.this.logger.deleteLogEntries(InstanceManager.this.mysqlLogDelete, true);
                                InstanceManager.this.logger.deleteConnectionLogEntries(InstanceManager.this.mysqlConnectionLogDelete, true);
                            }
                        };
                        this.botTimer.schedule(this.timerLogDelete, 86400000L, 86400000L);
                    }
                } else {
                    this.botTimer = new Timer(true);
                    this.logger = new MyLogger(null, this);
                }
            }
            if (this.mysqlMode) {
                if (this.firstInit) {
                    this.addLogEntry("CONFIG", "MySQL mode enabled!", true);
                }
                retValue = this.loadInstanceListMySQL();
            } else {
                if (this.firstInit) {
                    this.addLogEntry("CONFIG", "MySQL mode disabled!", true);
                }
                retValue = this.loadInstanceListFile(prop);
            }
            if (retValue) {
                int oldNamePos = -1;
                int i = 0;
                while (i < this.instanceNameReloadTemp.size()) {
                    oldNamePos = this.instanceName.indexOf(this.instanceNameReloadTemp.elementAt(i));
                    if (oldNamePos != -1) {
                        this.instanceClassReloadTemp.setElementAt(this.instanceClass.elementAt(oldNamePos), i);
                    }
                    ++i;
                }
                int newNamePos = -1;
                int i2 = 0;
                while (i2 < this.instanceName.size()) {
                    newNamePos = this.instanceNameReloadTemp.indexOf(this.instanceName.elementAt(i2));
                    if (newNamePos == -1) {
                        this.stopInstance(this.instanceName.elementAt(i2), null);
                        this.logger.removeLogInstance(this.instanceID.elementAt(i2));
                    }
                    ++i2;
                }
                this.instanceID.clear();
                this.instanceName.clear();
                this.instanceLogFilePath.clear();
                this.instanceCSVLogFilePath.clear();
                this.instanceEnabled.clear();
                this.instanceDebug.clear();
                this.instanceConfigFilePath.clear();
                this.instanceClass.clear();
                this.instanceID.addAll(this.instanceIDReloadTemp);
                this.instanceName.addAll(this.instanceNameReloadTemp);
                this.instanceLogFilePath.addAll(this.instanceLogFilePathReloadTemp);
                this.instanceCSVLogFilePath.addAll(this.instanceCSVLogFilePathReloadTemp);
                this.instanceEnabled.addAll(this.instanceEnabledReloadTemp);
                this.instanceDebug.addAll(this.instanceDebugReloadTemp);
                this.instanceConfigFilePath.addAll(this.instanceConfigFilePathReloadTemp);
                this.instanceClass.addAll(this.instanceClassReloadTemp);
                this.instanceIDReloadTemp.clear();
                this.instanceNameReloadTemp.clear();
                this.instanceLogFilePathReloadTemp.clear();
                this.instanceCSVLogFilePathReloadTemp.clear();
                this.instanceEnabledReloadTemp.clear();
                this.instanceDebugReloadTemp.clear();
                this.instanceConfigFilePathReloadTemp.clear();
                this.instanceClassReloadTemp.clear();
                this.resetFloodProtect();
            }
        }
        catch (ClassNotFoundException e) {
            this.addLogEntry("MYSQL_ERROR", "MySQL driver class not found!", true);
            return false;
        }
        catch (Throwable e) {
            this.addLogEntry("CONFIG", "Error while loading JTS3ServerMod InstanceManager config file, reason: " + e.toString(), true);
            return false;
        }
        return retValue;
    }

    private String hashStringCrypt(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(text.getBytes("utf8"));
        byte[] digestBytes = digest.digest();
        return DatatypeConverter.printHexBinary(digestBytes).toLowerCase().substring(0, 16);
    }

    private boolean loadInstanceListMySQL() {
        boolean retValue = false;
        Statement st = null;
        ResultSet rs = null;
        try {
            try {
                this.mysqlConnect.connect();
                st = this.mysqlConnect.getStatement();
                rs = st.executeQuery("SELECT id, name, enabled, logmode, logpath, csvlogmode, csvlogpath, debug FROM jts3servermod_instances");
                while (rs.next()) {
                    int id = rs.getInt(1);
                    String name = rs.getString(2);
                    int enabled = rs.getInt(3);
                    int logmode = rs.getInt(4);
                    String logPath = rs.getString(5);
                    int csvlogmode = rs.getInt(6);
                    String csvLogPath = rs.getString(7);
                    boolean debug = rs.getBoolean(8);
                    if (name.length() <= 0) continue;
                    if (!this.patternBotName.matcher(name).matches()) {
                        this.addLogEntry("CHECK_INSTANCE", "Name of bot \"" + name + "\" is not allowed! Disable bot...", true);
                        continue;
                    }
                    this.instanceIDReloadTemp.addElement(id);
                    this.instanceClassReloadTemp.addElement(null);
                    this.instanceNameReloadTemp.addElement(name);
                    this.instanceConfigFilePathReloadTemp.addElement("");
                    if (enabled == 1) {
                        this.instanceEnabledReloadTemp.addElement(true);
                    } else {
                        this.instanceEnabledReloadTemp.addElement(false);
                    }
                    if (logmode == 0) {
                        logPath = null;
                    } else if (logmode == 2) {
                        logPath = "sql";
                    }
                    if (csvlogmode == 0) {
                        csvLogPath = null;
                    } else if (csvlogmode == 2) {
                        csvLogPath = "sql";
                    }
                    this.instanceLogFilePathReloadTemp.addElement(logPath);
                    this.instanceCSVLogFilePathReloadTemp.addElement(csvLogPath);
                    this.instanceDebugReloadTemp.addElement(debug);
                }
                retValue = true;
            }
            catch (SQLException sqle) {
                this.addLogEntry("MYSQL_ERROR", "Error while connecting to database: " + sqle.toString(), true);
                this.addLogEntry(sqle);
                retValue = false;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mysqlConnect.close();
            }
            catch (Exception e) {
                this.addLogEntry("UNKNOWN_ERROR", "Error while connecting to database and reading instance list: " + e.toString(), true);
                this.addLogEntry(e);
                retValue = false;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mysqlConnect.close();
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
            this.mysqlConnect.close();
        }
        return retValue;
    }

    private boolean loadInstanceListFile(Properties prop) {
        try {
            int breakCount = 0;
            int i = 1;
            while (true) {
                String enabled;
                if ((enabled = prop.getProperty(String.valueOf(Integer.toString(i)) + ".instance_enable")) != null) {
                    breakCount = 0;
                    String name = prop.getProperty(String.valueOf(Integer.toString(i)) + ".instance_name");
                    String configPath = prop.getProperty(String.valueOf(Integer.toString(i)) + ".instance_config_path");
                    String logPath = prop.getProperty(String.valueOf(Integer.toString(i)) + ".instance_logfile_path");
                    String csvLogPath = prop.getProperty(String.valueOf(Integer.toString(i)) + ".instance_csvloginlog_path");
                    String debug = prop.getProperty(String.valueOf(Integer.toString(i)) + ".instance_debug", "0");
                    String appHome = System.getProperty("app.home", "");
                    configPath = configPath.replace("%apphome%", appHome);
                    logPath = logPath.replace("%apphome%", appHome);
                    csvLogPath = csvLogPath.replace("%apphome%", appHome);
                    if (name != null && name.length() > 0 && configPath != null && configPath.length() > 0) {
                        if (!this.patternBotName.matcher(name).matches()) {
                            this.addLogEntry("CHECK_INSTANCE", "Name of bot \"" + name + "\" is not allowed! Disable bot...", true);
                        } else {
                            this.instanceIDReloadTemp.addElement(i);
                            this.instanceClassReloadTemp.addElement(null);
                            this.instanceConfigFilePathReloadTemp.addElement(configPath);
                            if (this.instanceNameReloadTemp.indexOf(name) == -1) {
                                this.instanceNameReloadTemp.addElement(name);
                            } else {
                                this.instanceNameReloadTemp.addElement(String.valueOf(name) + Integer.toString(i));
                            }
                            if (logPath == null || logPath.length() < 2) {
                                this.instanceLogFilePathReloadTemp.addElement(null);
                            } else {
                                this.instanceLogFilePathReloadTemp.addElement(logPath);
                            }
                            if (csvLogPath == null || csvLogPath.length() < 2) {
                                this.instanceCSVLogFilePathReloadTemp.addElement(null);
                            } else {
                                this.instanceCSVLogFilePathReloadTemp.addElement(csvLogPath);
                            }
                            if (enabled.equals("1")) {
                                File instanceFile = new File(configPath);
                                if (instanceFile.isFile()) {
                                    this.instanceEnabledReloadTemp.addElement(true);
                                } else {
                                    this.addLogEntry("CHECK_INSTANCE", "Config file \"" + instanceFile.getAbsolutePath() + "\" of bot " + name + " is missing! Disable bot...", true);
                                    this.instanceEnabledReloadTemp.addElement(false);
                                }
                            } else {
                                this.instanceEnabledReloadTemp.addElement(false);
                            }
                            if (debug.equals("1")) {
                                this.instanceDebugReloadTemp.addElement(true);
                            } else {
                                this.instanceDebugReloadTemp.addElement(false);
                            }
                        }
                    }
                } else if (++breakCount > 10) break;
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    boolean isTelnetConnectionLog() {
        return this.telnetConnectionLog;
    }

    void addLogEntry(String type, String msg, boolean outputToSystemOut) {
        try {
            if (this.logFile != null) {
                if (outputToSystemOut) {
                    System.out.println(msg);
                }
                this.logFile.println(String.valueOf(this.sdfDebug.format(new Date(System.currentTimeMillis()))) + "\t" + type.toUpperCase() + "\t" + msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addLogEntry(Throwable e) {
        try {
            if (this.logFile != null) {
                this.logFile.println(String.valueOf(this.sdfDebug.format(new Date(System.currentTimeMillis()))) + "\tJTS3ServerMod " + "6.5.8 Hosting Edition (16.12.2023)" + ": " + "EXCEPTION");
                e.printStackTrace(this.logFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

