/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.util;

import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.util.MySQLConnect;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class ArrangedPropertiesWriter
implements Cloneable {
    private final String SEPARATOR = "***";
    private final String LINE_SEPARATOR = System.getProperty("line.separator");
    private HashMap<String, String> hmHelp = new HashMap();
    private HashMap<String, String> hmValue = new HashMap();
    private HashMap<String, Boolean> hmSave = new HashMap();
    private Vector<String> vKeys = new Vector();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private JTS3ServerMod_Interface mainClass = null;
    private boolean writeProtected = false;
    private MySQLConnect lastMysqlConnect = null;
    private int lastMysqlInstanceID = -1;
    private String lastConfigFileName = null;
    private String lastConfigFileHeader = null;

    public ArrangedPropertiesWriter(JTS3ServerMod_Interface mainClass) {
        this.mainClass = mainClass;
    }

    public ArrangedPropertiesWriter(JTS3ServerMod_Interface mainClass, HashMap<String, String> hmHelp, HashMap<String, String> hmValue, HashMap<String, Boolean> hmSave, Vector<String> vKeys) {
        this.mainClass = mainClass;
        this.hmHelp = hmHelp;
        this.hmValue = hmValue;
        this.hmSave = hmSave;
        this.vKeys = vKeys;
    }

    public ArrangedPropertiesWriter clone() {
        return new ArrangedPropertiesWriter(null, this.hmHelp, this.hmValue, this.hmSave, this.vKeys);
    }

    public void setNewMainClass(JTS3ServerMod_Interface mainClass) {
        this.mainClass = mainClass;
    }

    public void setWriteProtection(boolean flag) {
        this.writeProtected = flag;
    }

    public void setDefaultConfigFileHeader(String header) {
        this.lastConfigFileHeader = header;
    }

    public boolean addKey(String key, String helpText) {
        return this.addKey(key, helpText, null, true);
    }

    public boolean addKey(String key, String helpText, String defaultValue) {
        return this.addKey(key, helpText, defaultValue, true);
    }

    public boolean addKey(String key, String helpText, boolean saveToFile) {
        return this.addKey(key, helpText, null, saveToFile);
    }

    public boolean addKey(String key, String helpText, String defaultValue, boolean saveToFile) {
        if (this.writeProtected) {
            return false;
        }
        if (!key.equals("***") && key.length() > 0 && this.vKeys.indexOf(key) == -1) {
            this.vKeys.addElement(key);
            this.hmValue.put(key, defaultValue);
            this.hmHelp.put(key, helpText);
            this.hmSave.put(key, saveToFile);
            return true;
        }
        return false;
    }

    public boolean insertKey(String key, int pos, String helpText) {
        if (this.writeProtected) {
            return false;
        }
        if (!key.equals("***") && key.length() > 0 && this.vKeys.indexOf(key) == -1) {
            this.vKeys.insertElementAt(key, pos);
            this.hmHelp.put(key, helpText);
            return true;
        }
        return false;
    }

    public boolean canSaveToFile(String key) {
        return this.hmSave.get(key);
    }

    public Vector<String> getKeys() {
        Vector<String> retKeys = new Vector<String>();
        retKeys.addAll(this.vKeys);
        while (retKeys.removeElement("***")) {
        }
        return retKeys;
    }

    public String getValue(String key) {
        return this.hmValue.get(key);
    }

    public String getValue(String key, String defValue) {
        if (this.hmValue.get(key) == null) {
            return defValue;
        }
        return this.hmValue.get(key);
    }

    public boolean setValue(String key, String value) {
        if (this.writeProtected) {
            return false;
        }
        if (!key.equals("***") && key.length() > 0 && this.vKeys.indexOf(key) != -1) {
            this.hmValue.put(key, value);
            return true;
        }
        return false;
    }

    public boolean setValue(String key, long value) {
        return this.setValue(key, Long.toString(value));
    }

    public boolean setValue(String key, double value) {
        return this.setValue(key, Double.toString(value));
    }

    public boolean setValue(String key, boolean value) {
        return this.setValue(key, Boolean.toString(value));
    }

    public void removeAllValues() {
        this.hmValue.clear();
    }

    public void addSeparator() {
        if (this.writeProtected) {
            return;
        }
        this.vKeys.addElement("***");
    }

    public void insertSeparator(int pos) {
        if (this.writeProtected) {
            return;
        }
        this.vKeys.insertElementAt("***", pos);
    }

    public void removeAllSeparators() {
        if (this.writeProtected) {
            return;
        }
        while (this.vKeys.removeElement("***")) {
        }
    }

    public int getKeyCount() {
        return this.vKeys.size();
    }

    public String getHelpText(String key) {
        return this.hmHelp.get(key);
    }

    public boolean removeKey(String key) {
        if (this.writeProtected) {
            return false;
        }
        if (!key.equals("***") && key.length() > 0 && this.vKeys.indexOf(key) != -1) {
            this.vKeys.removeElement(key);
            this.hmHelp.remove(key);
            this.hmValue.remove(key);
            this.hmSave.remove(key);
            return true;
        }
        return false;
    }

    public boolean loadValues(File file) {
        if (this.writeProtected) {
            return false;
        }
        if (file == null || !file.isFile()) {
            return false;
        }
        this.lastConfigFileName = file.getAbsolutePath();
        this.lastMysqlConnect = null;
        this.lastMysqlInstanceID = -1;
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(file));
            for (String key : this.vKeys) {
                String temp = prop.getProperty(key);
                if (temp == null) continue;
                this.hmValue.put(key, temp);
            }
        }
        catch (Exception e) {
            if (this.mainClass != null) {
                this.mainClass.addLogEntry(null, e, false);
            }
            prop = null;
            return false;
        }
        prop = null;
        return true;
    }

    public boolean loadValues(String filename) {
        if (filename == null) {
            return false;
        }
        return this.loadValues(new File(filename));
    }

    public boolean loadValues(MySQLConnect mysqlConnect, int instanceID) {
        if (this.writeProtected) {
            return false;
        }
        this.lastMysqlConnect = mysqlConnect;
        this.lastMysqlInstanceID = instanceID;
        this.lastConfigFileName = null;
        if (mysqlConnect == null || instanceID < 1) {
            return false;
        }
        boolean retValue = false;
        Statement st = null;
        ResultSet rs = null;
        try {
            try {
                mysqlConnect.connect();
                st = mysqlConnect.getStatement();
                rs = st.executeQuery("SELECT configkey, configvalue FROM jts3servermod_instanceconfig WHERE instance_id = " + Integer.toString(instanceID));
                block17: while (rs.next()) {
                    String keyDB = rs.getString(1);
                    for (String key : this.vKeys) {
                        if (!key.equals(keyDB)) continue;
                        String temp = rs.getString(2);
                        if (temp == null) continue block17;
                        this.hmValue.put(key, temp);
                        continue block17;
                    }
                }
                retValue = true;
            }
            catch (Exception e) {
                if (this.mainClass != null) {
                    this.mainClass.addLogEntry(null, e, false);
                }
                retValue = false;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mysqlConnect.close();
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
            mysqlConnect.close();
        }
        return retValue;
    }

    public boolean save() {
        if (this.lastMysqlConnect != null && this.lastMysqlInstanceID >= 0) {
            return this.save(this.lastMysqlConnect, this.lastMysqlInstanceID);
        }
        if (this.lastConfigFileName != null) {
            return this.save(this.lastConfigFileName, this.lastConfigFileHeader);
        }
        return false;
    }

    public boolean save(MySQLConnect mysqlConnect, int instanceID) {
        if (mysqlConnect == null || instanceID < 1) {
            return false;
        }
        boolean retValue = false;
        Statement st = null;
        Statement pst = null;
        try {
            try {
                mysqlConnect.connect();
                st = mysqlConnect.getStatement();
                st.executeUpdate("DELETE FROM jts3servermod_instanceconfig WHERE instance_id = " + Integer.toString(instanceID));
                st.close();
                st = null;
                pst = mysqlConnect.getPreparedStatement("INSERT INTO jts3servermod_instanceconfig (instance_id, configkey, configvalue) VALUES (" + Integer.toString(instanceID) + ", ?, ?)");
                for (String key : this.vKeys) {
                    if (key.equals("***")) continue;
                    pst.setString(1, key);
                    if (this.hmValue.get(key) != null) {
                        pst.setString(2, this.hmValue.get(key));
                    } else {
                        pst.setNull(2, 12);
                    }
                    pst.executeUpdate();
                }
                retValue = true;
            }
            catch (Exception e) {
                if (this.mainClass != null) {
                    this.mainClass.addLogEntry(null, e, false);
                }
                retValue = false;
                try {
                    if (pst != null) {
                        pst.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mysqlConnect.close();
            }
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
            mysqlConnect.close();
        }
        return retValue;
    }

    public boolean save(String filename, String header) {
        PrintStream ps;
        if (filename == null) {
            return false;
        }
        try {
            ps = new PrintStream(filename, "ISO-8859-1");
        }
        catch (Exception e) {
            if (this.mainClass != null) {
                this.mainClass.addLogEntry(null, e, false);
            }
            return false;
        }
        if (header != null && header.length() > 0) {
            ps.println(this.convertString(header));
        }
        ps.println("# File created at " + this.sdf.format(new Date(System.currentTimeMillis())));
        ps.println();
        for (String key : this.vKeys) {
            if (key.equals("***")) {
                ps.println();
                continue;
            }
            if (!this.hmSave.get(key).booleanValue()) continue;
            if (this.hmHelp.get(key) != null) {
                ps.println(this.convertString(this.hmHelp.get(key)));
            }
            ps.print(key);
            ps.print(" = ");
            ps.println(this.hmValue.get(key) == null ? "" : this.hmValue.get(key));
        }
        ps.close();
        return true;
    }

    private String convertString(String text) {
        String retValue = "# " + text;
        retValue = retValue.replace("\\", "$[mkbackslashsave]");
        retValue = retValue.replace("\n", String.valueOf(this.LINE_SEPARATOR) + "# ");
        retValue = retValue.replace("$[mkbackslashsave]", "\\");
        return retValue;
    }
}

