/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.FunctionExceptionLog;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleClientList;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class IdleCheckOld
implements LoadConfiguration,
HandleClientList,
HandleBotEvents {
    private String configPrefix = "";
    private JTS3ServerMod_Interface modClass = null;
    private JTS3ServerQuery queryLib = null;
    private ArrangedPropertiesWriter config = null;
    private boolean pluginEnabled = false;
    final byte IDLE_ACTION_MOVE = 1;
    final byte IDLE_ACTION_KICK = (byte)2;
    final byte IDLE_ACTION_GROUP = (byte)3;
    private byte IDLE_ACTION = 1;
    private Vector<Integer> IDLE_CHANNEL_LIST = new Vector();
    private boolean IDLE_CHANNEL_LIST_IGNORE = true;
    private Vector<Integer> IDLE_GROUP_LIST = new Vector();
    private boolean IDLE_GROUP_LIST_IGNORE = true;
    private int IDLE_GROUP_ID = -1;
    private int IDLE_MOVE_CHANNELID = -1;
    private String IDLE_MESSAGE_MODE = null;
    private String IDLE_MESSAGE = null;
    private String IDLE_SECOND_MESSAGE = null;
    private long IDLE_MAX_TIME = -1L;
    private long IDLE_SECOND_MAX_TIME = -1L;
    private String IDLE_WARN_MESSAGE_MODE = null;
    private String IDLE_WARN_MESSAGE = null;
    private long IDLE_WARN_TIME = -1L;
    private int IDLE_MIN_CLIENTS = 0;
    private boolean IDLE_MIN_CLIENTS_MODE_CHANNEL = true;
    private Vector<Integer> listClientsWarnSent = new Vector();
    private Vector<Integer> listClientsWarnSentTemp = new Vector();
    private boolean IDLE_MOVE_BACK = false;
    private Vector<Integer> listClientsGrouped = new Vector();
    private Vector<Integer> listClientsMoved = new Vector();
    private Vector<Integer> listClientsMovedChannel = new Vector();
    private String IDLE_FILE = null;
    private String idleMessage = null;
    private String idleSecondMessage = null;
    private String idleWarnMessage = null;
    private String channelName = null;
    private FunctionExceptionLog fel = new FunctionExceptionLog();
    private Vector<HashMap<String, String>> clientListCacheCurrent = new Vector();
    private Vector<HashMap<String, String>> clientListCacheOld = new Vector();

    @Override
    public void initClass(JTS3ServerMod_Interface modClass, JTS3ServerQuery queryLib, String prefix) {
        this.modClass = modClass;
        this.queryLib = queryLib;
        this.configPrefix = prefix.trim();
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public void activate() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void unload() {
        this.IDLE_CHANNEL_LIST = null;
        this.IDLE_GROUP_LIST = null;
        this.listClientsWarnSent = null;
        this.listClientsWarnSentTemp = null;
        this.listClientsGrouped = null;
        this.listClientsMoved = null;
        this.listClientsMovedChannel = null;
        this.fel = null;
    }

    @Override
    public void handleAfterCacheUpdate() {
        if (!this.pluginEnabled) {
            return;
        }
        if (this.IDLE_ACTION == 1) {
            this.channelName = this.modClass.getChannelName(this.IDLE_MOVE_CHANNELID);
            if (this.channelName == null) {
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Critical: Channel ID " + this.IDLE_MOVE_CHANNELID + " don't exists! Check value " + this.configPrefix + "_channel_id in your configuration!", true);
                this.pluginEnabled = false;
                return;
            }
        }
        if (this.modClass.getClientList() != null) {
            this.clientListCacheOld = this.clientListCacheOld.size() == 0 ? this.modClass.getClientList() : this.clientListCacheCurrent;
            this.clientListCacheCurrent = this.modClass.getClientList();
        }
        this.createMessage();
    }

    @Override
    public void handleOnBotConnect() {
        String msg;
        if (!this.pluginEnabled) {
            return;
        }
        if (this.IDLE_ACTION == 3) {
            if (this.IDLE_GROUP_ID == -6) {
                this.createServerGroup(true);
            } else if (this.IDLE_GROUP_ID == -9) {
                this.createServerGroup(false);
            }
            if (this.IDLE_GROUP_ID < 0) {
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "No valid server group id is set in the bot configuration, please check the value at " + this.configPrefix + "_group_id", true);
                this.pluginEnabled = false;
                this.modClass.unloadFunction(this);
                return;
            }
        }
        String prefix = !this.IDLE_GROUP_LIST_IGNORE || this.IDLE_GROUP_LIST.size() > 0 ? "Members of " + Integer.toString(this.IDLE_GROUP_LIST.size()) + " specified server groups will " + (this.IDLE_GROUP_LIST_IGNORE ? "not " : "") : "Clients will ";
        if (this.IDLE_WARN_TIME > 0L) {
            msg = "get a warning message after being idle for " + Long.toString(this.IDLE_WARN_TIME / 1000L / 60L) + " minutes";
            this.modClass.addLogEntry(this.configPrefix, (byte)1, String.valueOf(prefix) + msg, true);
        }
        if (this.IDLE_ACTION == 2) {
            msg = "be kicked from the server after being idle for " + Long.toString(this.IDLE_MAX_TIME / 1000L / 60L) + " minutes" + (this.IDLE_MIN_CLIENTS > 0 ? " (if min " + Integer.toString(this.IDLE_MIN_CLIENTS) + " clients online)" : "");
            this.modClass.addLogEntry(this.configPrefix, (byte)1, String.valueOf(prefix) + msg, true);
        } else {
            msg = this.IDLE_ACTION == 3 ? "be put into the server group id " + Integer.toString(this.IDLE_GROUP_ID) + " after being idle for " + Long.toString(this.IDLE_MAX_TIME / 1000L / 60L) + " minutes" + (this.IDLE_MIN_CLIENTS > 0 ? " (if min " + Integer.toString(this.IDLE_MIN_CLIENTS) + " clients online)" : "") : "be moved into the channel \"" + this.channelName + "\" (id: " + Integer.toString(this.IDLE_MOVE_CHANNELID) + ") after being idle for " + Long.toString(this.IDLE_MAX_TIME / 1000L / 60L) + " minutes" + (this.IDLE_MIN_CLIENTS > 0 ? " (if min " + Integer.toString(this.IDLE_MIN_CLIENTS) + " clients online)" : "") + (this.IDLE_MOVE_BACK ? ". Clients will be moved back, if not idle anymore." : ".");
            this.modClass.addLogEntry(this.configPrefix, (byte)1, String.valueOf(prefix) + msg, true);
            if (this.IDLE_SECOND_MAX_TIME > 0L) {
                msg = "be kicked from server after being idle for " + Long.toString(this.IDLE_SECOND_MAX_TIME / 1000L / 60L) + " minutes" + (this.IDLE_MIN_CLIENTS > 0 ? " (if min " + Integer.toString(this.IDLE_MIN_CLIENTS) + " clients online)" : "");
                this.modClass.addLogEntry(this.configPrefix, (byte)1, String.valueOf(prefix) + msg, true);
            }
        }
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter config) {
        config.addKey(String.valueOf(this.configPrefix) + "_action", "Select the action if a client is idle for more than the specified maximum time, possible values: kick, group and move\nIf group is set, the client will be put into the specified server group, while being idle.", "move");
        config.addKey(String.valueOf(this.configPrefix) + "_group_id", "If the clients should be put into a temporary server group, set the server group id here.\nYou should use a server group, which adds the server group name to the client name, so everyone can quickly see, that someone is away.\nNotice: That server group only need the following permissions (first three are set by default):\ni_group_needed_modify_power, i_group_needed_member_add_power, i_group_needed_member_remove_power and i_group_show_name_in_tree\nImportant: Make sure, that the specified server group don't has set the permission b_group_is_permanent!\nYou can also set -6 (sg name on the left side) or -9 (sg name on the right side) to create a new server group with the name AFK.\nThis will update the bot configuration and the bot needs the permission b_virtualserver_servergroup_create one time!", "-1");
        config.addKey(String.valueOf(this.configPrefix) + "_moveback", "If the clients got moved, move client back if not idle anymore? Set yes or no here!", "no");
        config.addKey(String.valueOf(this.configPrefix) + "_channel_id", "If the clients should be moved, set channel id to move idle clients into it.");
        config.addKey(String.valueOf(this.configPrefix) + "_channel_list", "A comma separated list (without spaces) of channel ids.\nDepends on the given mode, this channels can be ignored or only this channels will be checked!\nIf no channels should be ignored, set no channels here and select the channel list mode ignore!");
        config.addKey(String.valueOf(this.configPrefix) + "_channel_list_mode", "Select one of the two modes for the channel list.\nignore = The selected channels will be ignored.\nonly = Only the selected channels will be checked.", "ignore");
        config.addKey(String.valueOf(this.configPrefix) + "_group_list", "A comma separated list (without spaces) of server group ids.\nDepends on the given mode, this server groups can be ignored or only this server groups will be checked!\nIf no server groups should be ignored, set no server groups here and select the group list mode ignore!");
        config.addKey(String.valueOf(this.configPrefix) + "_group_list_mode", "Select one of the two modes for the server group list.\nignore = The selected server groups will be ignored.\nonly = Only the selected server groups will be checked.", "ignore");
        config.addKey(String.valueOf(this.configPrefix) + "_max_time", "Set the max idle time in minutes.\nIf clients should be kicked, the client will be kicked after being idle for this time.\nIf clients should be moved, the client will be moved to specified channel after being idle for this time!\nIf clients should be added to a server group, the client will be added to the specified server group, after being idle for this time!", "60");
        config.addKey(String.valueOf(this.configPrefix) + "_second_max_time", "If the clients should be kicked after being moved or put into a temporary server group, set the second max idle time in minutes to kick a client after reaching this idle time limit.\nHas to be greater than idle_max_time or -1 to disable this feature!", "-1");
        config.addKey(String.valueOf(this.configPrefix) + "_warn_time", "Set the idle warn time in minutes or set -1 to disable this feature.\nThe idle warn time has to be smaller than the max idle time", "-1");
        config.addKey(String.valueOf(this.configPrefix) + "_min_clients", "A minimum client count to activate the idle check (Query clients are not counted).\nIf less clients are in the channel or on the server, idle check does nothing.", "3");
        config.addKey(String.valueOf(this.configPrefix) + "_min_clients_mode", "Select if the minimum client count is needed in the channel or on the server.\nchannel or server are valid values!", "server");
        config.addKey(String.valueOf(this.configPrefix) + "_message_mode", "If the clients should be moved or put into a temporary server group, select the message mode, how the client should get the message.\npoke, chat or none are valid values!", "chat");
        config.addKey(String.valueOf(this.configPrefix) + "_warn_message_mode", "Select the message mode, how the client should get the warning message.\npoke or chat are valid values!", "chat");
        if (this.modClass.getMySQLConnection() == null) {
            config.addKey(String.valueOf(this.configPrefix) + "_file", "Path to file which contains the idle messages", "%apphome%config/server1/idlemessages.cfg");
        }
        config.addKey(String.valueOf(this.configPrefix) + "_message", "Idle message, the client get this message as kick reason (if kick was selected) or chat message.\nYou can use the following keywords, which will be replaced:\n%IDLE_MAX_TIME% - Replaced with max idle time\n%IDLE_CHANNEL_NAME% - If clients should be moved, this will be replaced with the channel name of target idle channel\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.", this.modClass.getMySQLConnection() != null);
        config.addKey(String.valueOf(this.configPrefix) + "_second_message", "If clients should be moved or put into a temporary server group first, set the kick reason for being idle longer than the second idle max time.\nYou can use the following keywords, which will be replaced:\n%IDLE_MAX_TIME% - Replaced with max idle time\n%IDLE_SECOND_MAX_TIME% - This will be replaced with the second idle max time\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.", this.modClass.getMySQLConnection() != null);
        config.addKey(String.valueOf(this.configPrefix) + "_warn_message", "Idle warning message, the client get this message as chat message.\nYou can use the following keywords, which will be replaced:\n%IDLE_WARN_TIME% - Replaced with idle warn time\n%IDLE_MAX_TIME% - Replaced with max idle time\n%IDLE_CHANNEL_NAME% - If clients should be moved, this will be replaced with the channel name of target idle channel", this.modClass.getMySQLConnection() != null);
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter config, boolean slowMode) throws BotConfigurationException, NumberFormatException {
        String lastNumberValue = "";
        String temp = null;
        this.pluginEnabled = false;
        this.config = config;
        try {
            StringTokenizer st;
            temp = config.getValue(String.valueOf(this.configPrefix) + "_action", "move").trim();
            this.IDLE_ACTION = temp.equalsIgnoreCase("group") ? (byte)3 : (temp.equalsIgnoreCase("kick") ? (byte)2 : (byte)1);
            lastNumberValue = String.valueOf(this.configPrefix) + "_max_time";
            temp = config.getValue(String.valueOf(this.configPrefix) + "_max_time");
            if (temp == null) {
                throw new NumberFormatException();
            }
            this.IDLE_MAX_TIME = Long.parseLong(temp.trim()) * 60L * 1000L;
            lastNumberValue = String.valueOf(this.configPrefix) + "_min_clients";
            this.IDLE_MIN_CLIENTS = Integer.parseInt(config.getValue(String.valueOf(this.configPrefix) + "_min_clients", "0").trim());
            this.IDLE_MIN_CLIENTS_MODE_CHANNEL = config.getValue(String.valueOf(this.configPrefix) + "_min_clients_mode", "server").trim().equalsIgnoreCase("channel");
            this.IDLE_MESSAGE_MODE = this.IDLE_ACTION == 2 ? "kick" : config.getValue(String.valueOf(this.configPrefix) + "_message_mode", "chat").trim();
            lastNumberValue = String.valueOf(this.configPrefix) + "_warn_time";
            this.IDLE_WARN_TIME = Long.parseLong(config.getValue(String.valueOf(this.configPrefix) + "_warn_time", "-1").trim());
            if (this.IDLE_WARN_TIME > 0L) {
                this.IDLE_WARN_MESSAGE_MODE = config.getValue(String.valueOf(this.configPrefix) + "_warn_message_mode", "chat").trim();
            }
            this.IDLE_FILE = config.getValue(String.valueOf(this.configPrefix) + "_file");
            String[] configKeys = new String[]{String.valueOf(this.configPrefix) + "_message", String.valueOf(this.configPrefix) + "_second_message", String.valueOf(this.configPrefix) + "_warn_message"};
            if (!this.modClass.loadMessages(this.configPrefix, "_file", configKeys)) {
                throw new BotConfigurationException("Idle Check messages could not be loaded!");
            }
            this.IDLE_MESSAGE = config.getValue(configKeys[0]);
            this.IDLE_SECOND_MESSAGE = config.getValue(configKeys[1]);
            this.IDLE_WARN_MESSAGE = config.getValue(configKeys[2]);
            if (this.IDLE_MESSAGE == null || this.IDLE_MESSAGE.length() == 0) {
                throw new BotConfigurationException("Idle Check message missing in config!");
            }
            if (this.IDLE_ACTION == 3) {
                lastNumberValue = String.valueOf(this.configPrefix) + "_group_id";
                temp = config.getValue(String.valueOf(this.configPrefix) + "_group_id");
                if (temp == null) {
                    throw new NumberFormatException();
                }
                this.IDLE_GROUP_ID = Integer.parseInt(temp.trim());
            }
            if (this.IDLE_ACTION == 1) {
                lastNumberValue = String.valueOf(this.configPrefix) + "_channel_id";
                temp = config.getValue(String.valueOf(this.configPrefix) + "_channel_id");
                if (temp == null) {
                    throw new NumberFormatException();
                }
                this.IDLE_MOVE_CHANNELID = Integer.parseInt(temp.trim());
                this.IDLE_MOVE_BACK = config.getValue(String.valueOf(this.configPrefix) + "_moveback", "no").trim().equalsIgnoreCase("yes");
            } else {
                this.IDLE_MOVE_BACK = false;
            }
            if (this.IDLE_ACTION != 2) {
                lastNumberValue = String.valueOf(this.configPrefix) + "_second_max_time";
                this.IDLE_SECOND_MAX_TIME = Long.parseLong(config.getValue(String.valueOf(this.configPrefix) + "_second_max_time", "-1").trim());
                if (this.IDLE_SECOND_MAX_TIME > 0L) {
                    this.IDLE_SECOND_MAX_TIME = this.IDLE_SECOND_MAX_TIME * 60L * 1000L;
                    if (this.IDLE_SECOND_MAX_TIME <= this.IDLE_MAX_TIME) {
                        throw new BotConfigurationException(String.valueOf(this.configPrefix) + "_second_max_time must be greater than " + this.configPrefix + "_max_time!");
                    }
                    if (this.IDLE_SECOND_MESSAGE == null || this.IDLE_SECOND_MESSAGE.length() == 0) {
                        throw new BotConfigurationException("Second Idle Check message missing in config!");
                    }
                }
            }
            if (this.IDLE_WARN_TIME > 0L) {
                this.IDLE_WARN_TIME = this.IDLE_WARN_TIME * 60L * 1000L;
                if (this.IDLE_WARN_TIME >= this.IDLE_MAX_TIME) {
                    throw new BotConfigurationException(String.valueOf(this.configPrefix) + "_max_time must be greater than " + this.configPrefix + "_warn_time!");
                }
                if (this.IDLE_WARN_MESSAGE == null || this.IDLE_WARN_MESSAGE.length() == 0) {
                    throw new BotConfigurationException("Idle Check warn message missing in config!");
                }
            }
            this.listClientsWarnSent.clear();
            temp = null;
            this.IDLE_CHANNEL_LIST.clear();
            temp = config.getValue(String.valueOf(this.configPrefix) + "_channel_list");
            lastNumberValue = String.valueOf(this.configPrefix) + "_channel_list";
            if (temp != null && temp.length() > 0) {
                st = new StringTokenizer(temp, ",", false);
                while (st.hasMoreTokens()) {
                    this.IDLE_CHANNEL_LIST.addElement(Integer.parseInt(st.nextToken().trim()));
                }
            }
            temp = null;
            this.IDLE_GROUP_LIST.clear();
            temp = config.getValue(String.valueOf(this.configPrefix) + "_group_list");
            lastNumberValue = String.valueOf(this.configPrefix) + "_group_list";
            if (temp != null && temp.length() > 0) {
                st = new StringTokenizer(temp, ",", false);
                while (st.hasMoreTokens()) {
                    this.IDLE_GROUP_LIST.addElement(Integer.parseInt(st.nextToken().trim()));
                }
            }
            this.IDLE_CHANNEL_LIST_IGNORE = !config.getValue(String.valueOf(this.configPrefix) + "_channel_list_mode", "ignore").trim().equalsIgnoreCase("only");
            this.IDLE_GROUP_LIST_IGNORE = !config.getValue(String.valueOf(this.configPrefix) + "_group_list_mode", "ignore").trim().equalsIgnoreCase("only");
            this.pluginEnabled = true;
        }
        catch (NumberFormatException e) {
            NumberFormatException nfe = new NumberFormatException("Config value of \"" + lastNumberValue + "\" is not a number! Current value: " + config.getValue(lastNumberValue, "not set"));
            nfe.setStackTrace(e.getStackTrace());
            throw nfe;
        }
        return this.pluginEnabled;
    }

    @Override
    public void setListModes(BitSet listOptions) {
        listOptions.set(1);
        listOptions.set(3);
        listOptions.set(5);
        listOptions.set(0);
    }

    private int createServerGroup(boolean leftTag) {
        int serverGroupID = -1;
        String serverGroupName = "AFK";
        boolean noErrors = true;
        HashMap<String, String> response = this.queryLib.doCommand("servergroupadd name=" + serverGroupName);
        if (response.get("id").equals("0")) {
            try {
                HashMap<String, String> sgid = this.queryLib.parseLine(response.get("response"));
                serverGroupID = Integer.parseInt(sgid.get("sgid"));
            }
            catch (Exception e) {
                noErrors = false;
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to create the new server group!", true);
                this.modClass.addLogEntry(this.configPrefix, e, false);
            }
        } else {
            noErrors = false;
            try {
                throw new TS3ServerQueryException("createServerGroup()", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
            }
            catch (TS3ServerQueryException sqe) {
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to create the new server group!", true);
                if (sqe.getFailedPermissionID() < 0) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                }
                this.modClass.addLogEntry(this.configPrefix, sqe, false);
            }
        }
        if (serverGroupID > 0) {
            response = this.queryLib.doCommand("servergroupdelperm sgid=" + Integer.toString(serverGroupID) + " permsid=b_group_is_permanent");
            if (!response.get("id").equals("0")) {
                noErrors = false;
                try {
                    throw new TS3ServerQueryException("createServerGroup()", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
                }
                catch (TS3ServerQueryException sqe) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to remove the permission b_group_is_permanent from the new server group " + serverGroupName + " (id: " + Integer.toString(serverGroupID) + ")! Please do this manually!", true);
                    if (sqe.getFailedPermissionID() < 0) {
                        this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                    }
                    this.modClass.addLogEntry(this.configPrefix, sqe, false);
                }
            }
            if (!(response = this.queryLib.doCommand("servergroupaddperm sgid=" + Integer.toString(serverGroupID) + " permsid=i_group_show_name_in_tree permvalue=" + (leftTag ? "1" : "2") + " permnegated=0 permskip=0")).get("id").equals("0")) {
                noErrors = false;
                try {
                    throw new TS3ServerQueryException("createServerGroup()", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
                }
                catch (TS3ServerQueryException sqe) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to add the permission i_group_show_name_in_tree to the new server group " + serverGroupName + " (id: " + Integer.toString(serverGroupID) + ")! Please do this manually!", true);
                    if (sqe.getFailedPermissionID() < 0) {
                        this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                    }
                    this.modClass.addLogEntry(this.configPrefix, sqe, false);
                }
            }
            this.IDLE_GROUP_ID = serverGroupID;
            this.config.setValue(String.valueOf(this.configPrefix) + "_group_id", serverGroupID);
            if (!this.config.save()) {
                noErrors = false;
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to save the id of the new server group " + serverGroupName + " to the bot configuration! Please set the server group id " + Integer.toString(serverGroupID) + " at " + this.configPrefix + "_group_id in the bot configuration now!", true);
            }
            if (noErrors) {
                this.modClass.addLogEntry(this.configPrefix, (byte)1, "Successfully created a new server group id " + Integer.toString(serverGroupID) + " with the name " + serverGroupName + ", bot configuration was updated successfully!", true);
            }
        }
        return serverGroupID;
    }

    private int getClientCountFromClientList(Vector<HashMap<String, String>> clientList, String channelID) {
        int count = 0;
        int i = 0;
        while (i < clientList.size()) {
            if (clientList.elementAt(i).get("client_type").equals("0") && (!this.IDLE_MIN_CLIENTS_MODE_CHANNEL || clientList.elementAt(i).get("cid").equals(channelID))) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleClientCheck(Vector<HashMap<String, String>> clientList) {
        boolean found;
        int i;
        if (!this.pluginEnabled) {
            return;
        }
        int i2 = 0;
        while (i2 < clientList.size()) {
            block51: {
                long idleTime;
                int cachePos;
                int clientDBID;
                HashMap<String, String> clientInfo;
                block50: {
                    int clientID;
                    block49: {
                        block56: {
                            block52: {
                                boolean result;
                                int channelID;
                                block55: {
                                    block54: {
                                        block53: {
                                            clientInfo = clientList.elementAt(i2);
                                            if (!clientInfo.get("client_type").equals("0")) break block51;
                                            clientID = Integer.parseInt(clientInfo.get("clid"));
                                            clientDBID = Integer.parseInt(clientInfo.get("client_database_id"));
                                            cachePos = -1;
                                            if (this.IDLE_ACTION == 3 && (cachePos = this.listClientsGrouped.indexOf(clientDBID)) == -1 && this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_ID)) {
                                                this.listClientsGrouped.addElement(clientDBID);
                                                cachePos = this.listClientsGrouped.indexOf(clientDBID);
                                            }
                                            if (this.IDLE_MOVE_BACK) {
                                                cachePos = this.listClientsMoved.indexOf(clientID);
                                            }
                                            idleTime = this.modClass.getIdleTime(clientInfo, this.IDLE_MOVE_CHANNELID);
                                            if (this.clientListCacheOld.size() <= 0 || this.getClientCountFromClientList(this.clientListCacheOld, clientInfo.get("cid")) < this.IDLE_MIN_CLIENTS || this.getClientCountFromClientList(clientList, clientInfo.get("cid")) < this.IDLE_MIN_CLIENTS) break block50;
                                            if (idleTime <= this.IDLE_MAX_TIME) break block52;
                                            channelID = Integer.parseInt(clientInfo.get("cid"));
                                            result = this.modClass.isIDListed(channelID, this.IDLE_CHANNEL_LIST);
                                            if (this.IDLE_ACTION != 2) break block53;
                                            if (this.IDLE_CHANNEL_LIST_IGNORE ? !result : result) {
                                                result = this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_LIST);
                                                if ((this.IDLE_GROUP_LIST_IGNORE ? !result : result) && this.kickClient(clientInfo, this.idleMessage, clientID)) {
                                                    clientList.removeElementAt(i2);
                                                    --i2;
                                                }
                                            }
                                            break block49;
                                        }
                                        if (this.IDLE_SECOND_MAX_TIME <= 0L || idleTime <= this.IDLE_SECOND_MAX_TIME) break block54;
                                        if (this.IDLE_CHANNEL_LIST_IGNORE ? !result : result) {
                                            result = this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_LIST);
                                            if ((this.IDLE_GROUP_LIST_IGNORE ? !result : result) && this.kickClient(clientInfo, this.idleSecondMessage, clientID)) {
                                                clientList.removeElementAt(i2);
                                                --i2;
                                            }
                                        }
                                        break block49;
                                    }
                                    if (this.IDLE_ACTION != 3 || !(this.IDLE_CHANNEL_LIST_IGNORE ? !result : result)) break block55;
                                    if (cachePos != -1 || this.getLowestIdleTime(clientList, clientInfo.get("client_database_id")) <= this.IDLE_MAX_TIME) break block49;
                                    result = this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_LIST);
                                    if (!(this.IDLE_GROUP_LIST_IGNORE ? !result : result) || this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_ID)) break block49;
                                    HashMap<String, String> response = this.queryLib.doCommand("servergroupaddclient sgid=" + Integer.toString(this.IDLE_GROUP_ID) + " cldbid=" + clientInfo.get("client_database_id"));
                                    if (response.get("id").equals("0")) {
                                        if (this.listClientsGrouped.indexOf(clientDBID) == -1) {
                                            this.listClientsGrouped.addElement(clientDBID);
                                        }
                                        this.updateServerGroups(clientList, clientInfo.get("client_database_id"), this.IDLE_GROUP_ID, true);
                                        this.modClass.addLogEntry(this.configPrefix, (byte)1, "Added client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") to server group id " + Integer.toString(this.IDLE_GROUP_ID) + " for being idle!", false);
                                        this.fel.clearException(clientDBID);
                                        break block49;
                                    } else {
                                        try {
                                            throw new TS3ServerQueryException("handleClientCheck()", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
                                        }
                                        catch (TS3ServerQueryException sqe) {
                                            if (this.fel.existsException(sqe, clientDBID)) break block49;
                                            this.fel.addException(sqe, clientDBID);
                                            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Error while adding client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") to server group id " + Integer.toString(this.IDLE_GROUP_ID) + "!", false);
                                            if (sqe.getFailedPermissionID() < 0) {
                                                this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                                                break block49;
                                            } else {
                                                this.modClass.addLogEntry(this.configPrefix, sqe, false);
                                            }
                                            break block49;
                                        }
                                    }
                                    break block49;
                                }
                                if (channelID == this.IDLE_MOVE_CHANNELID || !(this.IDLE_CHANNEL_LIST_IGNORE ? !result : result)) break block49;
                                result = this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_LIST);
                                if (this.IDLE_GROUP_LIST_IGNORE ? !result : result) {
                                    try {
                                        this.queryLib.moveClient(clientID, this.IDLE_MOVE_CHANNELID, null);
                                        clientInfo.put("cid", Integer.toString(this.IDLE_MOVE_CHANNELID));
                                        if (this.IDLE_MOVE_BACK) {
                                            this.listClientsMoved.addElement(clientID);
                                            this.listClientsMovedChannel.addElement(channelID);
                                        }
                                        this.modClass.addLogEntry(this.configPrefix, (byte)1, "Client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") was idle, client was moved and got a message!", false);
                                        this.modClass.sendMessageToClient(this.configPrefix, this.IDLE_MESSAGE_MODE, clientID, this.idleMessage);
                                        this.fel.clearException(clientDBID);
                                    }
                                    catch (TS3ServerQueryException sqe) {
                                        if (this.fel.existsException(sqe, clientDBID)) break block49;
                                        this.fel.addException(sqe, clientDBID);
                                        this.modClass.addLogEntry(this.configPrefix, (byte)2, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is idle, but an error occurred while moving client!", false);
                                        if (sqe.getFailedPermissionID() < 0) {
                                            this.modClass.addLogEntry(this.configPrefix, (byte)2, sqe.toString(), false);
                                            break block49;
                                        }
                                        this.modClass.addLogEntry(this.configPrefix, sqe, false);
                                    }
                                    catch (Exception e) {
                                        this.modClass.addLogEntry(this.configPrefix, (byte)3, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is idle, but an error occurred while moving client!", false);
                                        this.modClass.addLogEntry(this.configPrefix, e, false);
                                    }
                                }
                                break block49;
                            }
                            if (this.IDLE_WARN_TIME <= 0L || idleTime <= this.IDLE_WARN_TIME) break block49;
                            if (this.listClientsWarnSent.indexOf(clientID) != -1) break block56;
                            int channelID = Integer.parseInt(clientInfo.get("cid"));
                            boolean result = this.modClass.isIDListed(channelID, this.IDLE_CHANNEL_LIST);
                            if (channelID != this.IDLE_MOVE_CHANNELID && (this.IDLE_CHANNEL_LIST_IGNORE ? !result : result)) {
                                result = this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_LIST);
                                if (this.IDLE_GROUP_LIST_IGNORE ? !result : result) {
                                    if (!this.modClass.sendMessageToClient(this.configPrefix, this.IDLE_WARN_MESSAGE_MODE, clientID, this.idleWarnMessage)) {
                                        this.modClass.addLogEntry(this.configPrefix, (byte)3, "Unable to send idle warn message, maybe an invalid message mode in config file?", false);
                                    }
                                    this.listClientsWarnSentTemp.addElement(clientID);
                                }
                            }
                            break block49;
                        }
                        this.listClientsWarnSentTemp.addElement(clientID);
                    }
                    if (this.IDLE_MOVE_BACK && cachePos != -1 && idleTime < (long)(this.modClass.getCheckInterval() * 2000) && clientInfo.get("client_away").equals("0") && clientInfo.get("client_output_muted").equals("0") && clientInfo.get("client_input_muted").equals("0") && clientInfo.get("client_output_hardware").equals("1") && clientInfo.get("client_input_hardware").equals("1")) {
                        if (Integer.parseInt(clientInfo.get("cid")) != this.IDLE_MOVE_CHANNELID) {
                            this.listClientsMoved.removeElementAt(cachePos);
                            this.listClientsMovedChannel.removeElementAt(cachePos);
                        } else {
                            try {
                                this.queryLib.moveClient(clientID, this.listClientsMovedChannel.elementAt(cachePos), null);
                                clientInfo.put("cid", Integer.toString(this.listClientsMovedChannel.elementAt(cachePos)));
                                this.listClientsMoved.removeElementAt(cachePos);
                                this.listClientsMovedChannel.removeElementAt(cachePos);
                                this.modClass.addLogEntry(this.configPrefix, (byte)1, "Client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is not idle anymore, client was moved back!", false);
                                this.fel.clearException(clientDBID);
                            }
                            catch (TS3ServerQueryException sqe) {
                                if (this.fel.existsException(sqe, clientDBID)) break block50;
                                this.fel.addException(sqe, clientDBID);
                                this.modClass.addLogEntry(this.configPrefix, (byte)2, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is not idle anymore, but an error occurred while moving back!", false);
                                if (sqe.getFailedPermissionID() < 0) {
                                    this.modClass.addLogEntry(this.configPrefix, (byte)2, sqe.toString(), false);
                                } else {
                                    this.modClass.addLogEntry(this.configPrefix, sqe, false);
                                }
                            }
                            catch (Exception e) {
                                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is not idle anymore, but an error occurred while moving back!", false);
                                this.modClass.addLogEntry(this.configPrefix, e, false);
                            }
                        }
                    }
                }
                if (this.IDLE_ACTION == 3 && cachePos != -1 && idleTime < (long)(this.modClass.getCheckInterval() * 2000)) {
                    if (!this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.IDLE_GROUP_ID)) {
                        this.listClientsGrouped.removeElementAt(cachePos);
                    } else {
                        HashMap<String, String> response = this.queryLib.doCommand("servergroupdelclient sgid=" + Integer.toString(this.IDLE_GROUP_ID) + " cldbid=" + clientInfo.get("client_database_id"));
                        if (response.get("id").equals("0")) {
                            this.listClientsGrouped.removeElementAt(cachePos);
                            this.updateServerGroups(clientList, clientInfo.get("client_database_id"), this.IDLE_GROUP_ID, false);
                            this.modClass.addLogEntry(this.configPrefix, (byte)1, "Removed client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") from server group id " + Integer.toString(this.IDLE_GROUP_ID) + ", client is not idle anymore!", false);
                            this.fel.clearException(clientDBID);
                        } else {
                            try {
                                throw new TS3ServerQueryException("handleClientCheck()", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
                            }
                            catch (TS3ServerQueryException sqe) {
                                if (this.fel.existsException(sqe, clientDBID)) break block51;
                                this.fel.addException(sqe, clientDBID);
                                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Error while removing client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") from server group id " + Integer.toString(this.IDLE_GROUP_ID) + "!", false);
                                if (sqe.getFailedPermissionID() < 0) {
                                    this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                                }
                                this.modClass.addLogEntry(this.configPrefix, sqe, false);
                            }
                        }
                    }
                }
            }
            ++i2;
        }
        if (this.IDLE_WARN_TIME > 0L) {
            this.listClientsWarnSent.clear();
            this.listClientsWarnSent.addAll(this.listClientsWarnSentTemp);
            this.listClientsWarnSentTemp.clear();
        }
        if (this.IDLE_ACTION == 3) {
            i = 0;
            while (i < this.listClientsGrouped.size()) {
                found = false;
                for (HashMap<String, String> hashMap : clientList) {
                    if (Integer.parseInt(hashMap.get("client_database_id")) != this.listClientsGrouped.elementAt(i)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.listClientsGrouped.removeElementAt(i);
                }
                ++i;
            }
        }
        if (this.IDLE_ACTION == 1 && this.IDLE_MOVE_BACK) {
            i = 0;
            while (i < this.listClientsMoved.size()) {
                found = false;
                for (HashMap<String, String> hashMap : clientList) {
                    if (Integer.parseInt(hashMap.get("clid")) != this.listClientsMoved.elementAt(i)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.listClientsMoved.removeElementAt(i);
                    this.listClientsMovedChannel.removeElementAt(i);
                }
                ++i;
            }
        }
    }

    private long getLowestIdleTime(Vector<HashMap<String, String>> clientList, String cldbID) {
        if (clientList == null) {
            return 0L;
        }
        if (cldbID == null) {
            return 0L;
        }
        long lowestIdleTime = Long.MAX_VALUE;
        long tempIdleTime = 0L;
        boolean found = false;
        int i = 0;
        while (i < clientList.size()) {
            if (clientList.elementAt(i).get("client_database_id").equals(cldbID)) {
                found = true;
                tempIdleTime = this.modClass.getIdleTime(clientList.elementAt(i), this.IDLE_MOVE_CHANNELID);
                if (lowestIdleTime > tempIdleTime) {
                    lowestIdleTime = tempIdleTime;
                }
            }
            ++i;
        }
        if (found) {
            return lowestIdleTime;
        }
        return 0L;
    }

    private void updateServerGroups(Vector<HashMap<String, String>> clientList, String cldbID, int sgID, boolean addSG) {
        if (clientList == null) {
            return;
        }
        if (cldbID == null) {
            return;
        }
        int i = 0;
        while (i < clientList.size()) {
            if (clientList.elementAt(i).get("client_database_id").equals(cldbID)) {
                Vector<Integer> newSGList = new Vector<Integer>();
                StringTokenizer groupTokenizer = new StringTokenizer(clientList.elementAt(i).get("client_servergroups"), ",", false);
                while (groupTokenizer.hasMoreTokens()) {
                    int groupID = Integer.parseInt(groupTokenizer.nextToken());
                    if (groupID == sgID) continue;
                    newSGList.addElement(groupID);
                }
                if (addSG) {
                    newSGList.addElement(sgID);
                }
                StringBuffer sbSGList = new StringBuffer();
                for (Integer iSGID : newSGList) {
                    if (sbSGList.length() > 0) {
                        sbSGList.append(",");
                    }
                    sbSGList.append(iSGID);
                }
                clientList.elementAt(i).put("client_servergroups", sbSGList.toString());
            }
            ++i;
        }
    }

    private boolean kickClient(HashMap<String, String> clientInfo, String kickMSG, int clientID) {
        boolean retValue = false;
        try {
            this.queryLib.kickClient(clientID, false, kickMSG);
            this.modClass.addLogEntry(this.configPrefix, (byte)1, "Client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") was idle, client was kicked!", false);
            this.fel.clearException(Integer.parseInt(clientInfo.get("client_database_id")));
            retValue = true;
        }
        catch (TS3ServerQueryException sqe) {
            if (!this.fel.existsException(sqe, Integer.parseInt(clientInfo.get("client_database_id")))) {
                this.fel.addException(sqe, Integer.parseInt(clientInfo.get("client_database_id")));
                this.modClass.addLogEntry(this.configPrefix, (byte)2, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is idle, but an error occurred while kicking client!", false);
                if (sqe.getFailedPermissionID() < 0) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)2, sqe.toString(), false);
                } else {
                    this.modClass.addLogEntry(this.configPrefix, sqe, false);
                }
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is idle, but an error occurred while kicking client!", false);
            this.modClass.addLogEntry(this.configPrefix, e, false);
        }
        return retValue;
    }

    private void createMessage() {
        this.idleMessage = new String(this.IDLE_MESSAGE);
        this.idleMessage = this.idleMessage.replace("%IDLE_MAX_TIME%", Long.toString(this.IDLE_MAX_TIME / 1000L / 60L));
        if (this.IDLE_ACTION == 1) {
            this.idleMessage = this.idleMessage.replace("%IDLE_CHANNEL_NAME%", this.channelName);
        }
        if (!this.modClass.isMessageLengthValid(this.IDLE_MESSAGE_MODE, this.idleMessage)) {
            this.modClass.addLogEntry(this.configPrefix, (byte)2, "Idle Check message is to long! Make sure that " + this.IDLE_MESSAGE_MODE + " messages are not longer than " + Short.toString(this.modClass.getMaxMessageLength(this.IDLE_MESSAGE_MODE)) + " characters (including spaces and BBCode)" + (this.modClass.getMySQLConnection() == null ? ", check file: " + this.IDLE_FILE : ""), true);
        }
        if (this.IDLE_WARN_TIME > 0L) {
            this.idleWarnMessage = new String(this.IDLE_WARN_MESSAGE);
            this.idleWarnMessage = this.idleWarnMessage.replace("%IDLE_WARN_TIME%", Long.toString(this.IDLE_WARN_TIME / 1000L / 60L));
            this.idleWarnMessage = this.idleWarnMessage.replace("%IDLE_MAX_TIME%", Long.toString(this.IDLE_MAX_TIME / 1000L / 60L));
            if (this.IDLE_ACTION == 1) {
                this.idleWarnMessage = this.idleWarnMessage.replace("%IDLE_CHANNEL_NAME%", this.channelName);
            }
            if (!this.modClass.isMessageLengthValid(this.IDLE_WARN_MESSAGE_MODE, this.idleWarnMessage)) {
                this.modClass.addLogEntry(this.configPrefix, (byte)2, "Idle Check warn message is to long! Make sure that " + this.IDLE_WARN_MESSAGE_MODE + " messages are not longer than " + Short.toString(this.modClass.getMaxMessageLength(this.IDLE_WARN_MESSAGE_MODE)) + " characters (including spaces and BBCode)" + (this.modClass.getMySQLConnection() == null ? ", check file: " + this.IDLE_FILE : ""), true);
            }
        }
        if (this.IDLE_SECOND_MAX_TIME > 0L) {
            this.idleSecondMessage = new String(this.IDLE_SECOND_MESSAGE);
            this.idleSecondMessage = this.idleSecondMessage.replace("%IDLE_SECOND_MAX_TIME%", Long.toString(this.IDLE_SECOND_MAX_TIME / 1000L / 60L));
            this.idleSecondMessage = this.idleSecondMessage.replace("%IDLE_MAX_TIME%", Long.toString(this.IDLE_MAX_TIME / 1000L / 60L));
            if (!this.modClass.isMessageLengthValid("kick", this.idleSecondMessage)) {
                this.modClass.addLogEntry(this.configPrefix, (byte)2, "Second Idle Check message is to long! Make sure that kick messages are not longer than " + Short.toString(this.modClass.getMaxMessageLength("kick")) + " characters (including spaces and BBCode)" + (this.modClass.getMySQLConnection() == null ? ", check file: " + this.IDLE_FILE : ""), true);
            }
        }
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Old Idle Check function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]\nThis function is depreciated, please switch over to the new Idle Check.";
    }
}

