/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.BitSet;
import java.util.HashMap;
import java.util.TimerTask;

public class SlotChecker
implements HandleBotEvents,
LoadConfiguration {
    private String configPrefix = "";
    private JTS3ServerMod_Interface modClass = null;
    private JTS3ServerQuery queryLib = null;
    private boolean pluginEnabled = false;
    private int maxSlotDistance = -1;
    private int minSlotDistance = -1;
    private int minSlotCount = -1;
    private int maxSlotCount = -1;
    private int checkInterval = 10;
    private int skipActionInterval = 1;
    private String urlGetSlotCount = null;
    private String urlConfirmSlotCount = null;
    private String serverAddress = null;
    private byte waitAction = 0;
    private TimerTask timerSlotCheck;

    @Override
    public void initClass(JTS3ServerMod_Interface modClass, JTS3ServerQuery queryLib, String prefix) {
        this.modClass = modClass;
        this.queryLib = queryLib;
        this.configPrefix = prefix.trim();
    }

    @Override
    public void handleOnBotConnect() {
        if (!this.pluginEnabled) {
            return;
        }
        this.modClass.addLogEntry(this.configPrefix, (byte)1, "SlotChecker activated, checking slot count every " + Integer.toString(this.checkInterval) + " seconds!", true);
    }

    @Override
    public void handleAfterCacheUpdate() {
    }

    @Override
    public void activate() {
        if (!this.pluginEnabled) {
            return;
        }
        if (this.timerSlotCheck != null) {
            this.timerSlotCheck.cancel();
        }
        this.timerSlotCheck = null;
        this.timerSlotCheck = new TimerTask(){

            @Override
            public void run() {
                SlotChecker.this.doCheck();
            }
        };
        this.modClass.addBotTimer(this.timerSlotCheck, this.checkInterval * 1000, this.checkInterval * 1000);
    }

    @Override
    public void disable() {
        if (this.timerSlotCheck != null) {
            this.timerSlotCheck.cancel();
        }
        this.timerSlotCheck = null;
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean multipleInstances() {
        return false;
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter config) {
        config.addKey(String.valueOf(this.configPrefix) + "_check_interval", "Check current max clients distance every X seconds! Set to -1 to disable this function. To enable this function, set between 1 and 600 seconds here.", "-1");
        config.addKey(String.valueOf(this.configPrefix) + "_skip_action_interval", "Skip X intervals until a request is send to the specified URL. Possible values between 0 and 60.", "1");
        config.addKey(String.valueOf(this.configPrefix) + "_min_slotdistance", "Minimum allowed distance to the current max clients! Lowest possible value is 1.");
        config.addKey(String.valueOf(this.configPrefix) + "_max_slotdistance", "Maximum allowed distance to the current max clients! Lowest possible value is 1.");
        config.addKey(String.valueOf(this.configPrefix) + "_min_slotcount", "Minimum allowed slot count for this virtual server! This function don't set the max clients lower than this value.");
        config.addKey(String.valueOf(this.configPrefix) + "_max_slotcount", "Maximum allowed slot count for this virtual server! This function don't set the max clients higher than this value.");
        config.addKey(String.valueOf(this.configPrefix) + "_url", "Set http URL here! That URL have to return the new slot count / max clients as number or -1 if nothing should be changed! Put a \n (new line) after the number.\nYou can use the following keywords within the URL, which will be replaced:\n%address% - TS3 server address used by the bot!\n%port% - TS3 voice port reported by the TS3 server!\n%id% - TS3 virtual server id reported by the TS3 server!\n%maxclients% - Current TS3 virtual server slot count / max clients!\n%clientcount% - Current TS3 client count on that virtual server!", "http://");
        config.addKey(String.valueOf(this.configPrefix) + "_url_confirm", "Set confirm http URL here! If changing the max client count was successful, the new value will be send. If not, -1 will be send. Set no URL here to disable confirming new values.\nYou can use the following keywords within the URL, which will be replaced:\n%address% - TS3 server address used by the bot!\n%port% - TS3 voice port reported by the TS3 server!\n%id% - TS3 virtual server id reported by the TS3 server!\n%newmaxclients% - New max client count or -1 if nothing was changed!", "");
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter config, boolean slowMode) throws BotConfigurationException, NumberFormatException {
        String lastNumberValue;
        block13: {
            lastNumberValue = "";
            this.pluginEnabled = false;
            try {
                this.serverAddress = config.getValue("ts3_server_address", "").trim();
                lastNumberValue = String.valueOf(this.configPrefix) + "_check_interval";
                this.checkInterval = Integer.parseInt(config.getValue(String.valueOf(this.configPrefix) + "_check_interval", "-1").trim());
                if (this.checkInterval >= 0) break block13;
                return false;
            }
            catch (NumberFormatException e) {
                NumberFormatException nfe = new NumberFormatException("Config value of \"" + lastNumberValue + "\" is not a number! Current value: " + config.getValue(lastNumberValue, "not set"));
                nfe.setStackTrace(e.getStackTrace());
                throw nfe;
            }
        }
        if (this.checkInterval < 1) {
            this.checkInterval = 1;
        } else if (this.checkInterval > 600) {
            this.checkInterval = 600;
        }
        lastNumberValue = String.valueOf(this.configPrefix) + "_skip_action_interval";
        this.skipActionInterval = Integer.parseInt(config.getValue(String.valueOf(this.configPrefix) + "_skip_action_interval", "1").trim());
        if (this.skipActionInterval < 0) {
            this.skipActionInterval = 0;
        } else if (this.skipActionInterval > 60) {
            this.skipActionInterval = 60;
        }
        lastNumberValue = String.valueOf(this.configPrefix) + "_min_slotdistance";
        this.minSlotDistance = Integer.parseInt(config.getValue(String.valueOf(this.configPrefix) + "_min_slotdistance", "").trim());
        if (this.minSlotDistance < 1) {
            this.minSlotDistance = 1;
        }
        lastNumberValue = String.valueOf(this.configPrefix) + "_max_slotdistance";
        this.maxSlotDistance = Integer.parseInt(config.getValue(String.valueOf(this.configPrefix) + "_max_slotdistance", "").trim());
        if (this.maxSlotDistance < 1) {
            this.maxSlotDistance = 1;
        }
        lastNumberValue = String.valueOf(this.configPrefix) + "_min_slotcount";
        this.minSlotCount = Integer.parseInt(config.getValue(String.valueOf(this.configPrefix) + "_min_slotcount", "").trim());
        lastNumberValue = String.valueOf(this.configPrefix) + "_max_slotcount";
        this.maxSlotCount = Integer.parseInt(config.getValue(String.valueOf(this.configPrefix) + "_max_slotcount", "").trim());
        this.urlGetSlotCount = config.getValue(String.valueOf(this.configPrefix) + "_url", "").trim();
        if (!this.urlGetSlotCount.startsWith("http://") || this.urlGetSlotCount.indexOf(" ") != -1) {
            throw new BotConfigurationException("Unvalid URL! The url has to start with http:// and contains no whitespace characters.");
        }
        this.urlConfirmSlotCount = config.getValue(String.valueOf(this.configPrefix) + "_url_confirm", "").trim();
        if (!(this.urlConfirmSlotCount.length() == 0 || this.urlConfirmSlotCount.startsWith("http://") && this.urlConfirmSlotCount.indexOf(" ") == -1)) {
            throw new BotConfigurationException("Unvalid confirm URL! The confirm url has to start with http:// and contains no whitespace characters.");
        }
        this.pluginEnabled = true;
        return this.pluginEnabled;
    }

    @Override
    public void setListModes(BitSet listOptions) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doCheck() {
        int serverID = -1;
        int serverPort = -1;
        int serverMaxClients = -1;
        int serverClientCount = -1;
        try {
            HashMap<String, String> serverinfo = this.queryLib.getInfo(11, -1);
            serverID = Integer.parseInt(serverinfo.get("virtualserver_id"));
            serverPort = Integer.parseInt(serverinfo.get("virtualserver_port"));
            serverMaxClients = Integer.parseInt(serverinfo.get("virtualserver_maxclients"));
            serverClientCount = Integer.parseInt(serverinfo.get("virtualserver_clientsonline")) - Integer.parseInt(serverinfo.get("virtualserver_queryclientsonline"));
        }
        catch (Exception e) {
            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Error parsing current server info!", false);
            this.modClass.addLogEntry(this.configPrefix, e, false);
            return;
        }
        boolean requestAction = false;
        int distance = serverMaxClients - serverClientCount;
        if (distance > this.maxSlotDistance && serverMaxClients > this.minSlotCount) {
            requestAction = true;
        }
        if (distance < this.minSlotDistance && serverMaxClients < this.maxSlotCount) {
            requestAction = true;
        }
        if (requestAction) {
            if (this.waitAction < this.skipActionInterval) {
                this.waitAction = (byte)(this.waitAction + 1);
                return;
            }
            int newSlotCount = this.getNewSlotCount(serverID, serverPort, serverMaxClients, serverClientCount);
            if (newSlotCount >= this.minSlotCount && newSlotCount <= this.maxSlotCount) {
                HashMap<String, String> response = this.queryLib.doCommand("serveredit virtualserver_maxclients=" + Integer.toString(newSlotCount));
                if (response.get("id").equals("0")) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)1, "Slot count successfully changed to: " + Integer.toString(newSlotCount), false);
                    this.waitAction = 0;
                    this.confirmNewSlotCount(serverID, serverPort, newSlotCount);
                    return;
                }
                try {
                    throw new TS3ServerQueryException("ServerGroupProtection", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
                }
                catch (TS3ServerQueryException sqe) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)3, "Error changing slot count!", false);
                    this.modClass.addLogEntry(this.configPrefix, sqe, false);
                    this.confirmNewSlotCount(serverID, serverPort, -1);
                    return;
                }
            }
            this.confirmNewSlotCount(serverID, serverPort, -1);
            return;
        }
        this.waitAction = 0;
    }

    private int getNewSlotCount(int serverID, int serverPort, int serverMaxClients, int serverClientCount) {
        int newSlotCount = -1;
        String newURL = new String(this.urlGetSlotCount);
        try {
            newURL = newURL.replace("%address%", this.serverAddress);
            newURL = newURL.replace("%port%", Integer.toString(serverPort));
            newURL = newURL.replace("%id%", Integer.toString(serverID));
            newURL = newURL.replace("%maxclients%", Integer.toString(serverMaxClients));
            newURL = newURL.replace("%clientcount%", Integer.toString(serverClientCount));
            URL actionURL = new URL(newURL);
            BufferedReader actionURLStream = new BufferedReader(new InputStreamReader(actionURL.openStream()));
            String tmp = actionURLStream.readLine();
            newSlotCount = Integer.parseInt(tmp);
            actionURLStream.close();
        }
        catch (Exception e) {
            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Error requesting new slot count at " + newURL, false);
            this.modClass.addLogEntry(this.configPrefix, e, false);
            newSlotCount = -1;
        }
        return newSlotCount;
    }

    private void confirmNewSlotCount(int serverID, int serverPort, int newMaxClients) {
        if (this.urlConfirmSlotCount.length() < 10) {
            return;
        }
        String newURL = new String(this.urlConfirmSlotCount);
        try {
            newURL = newURL.replace("%address%", this.serverAddress);
            newURL = newURL.replace("%port%", Integer.toString(serverPort));
            newURL = newURL.replace("%id%", Integer.toString(serverID));
            newURL = newURL.replace("%newmaxclients%", Integer.toString(newMaxClients));
            URL actionURL = new URL(newURL);
            BufferedReader actionURLStream = new BufferedReader(new InputStreamReader(actionURL.openStream()));
            actionURLStream.close();
        }
        catch (Exception e) {
            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Error confirm new slot count at " + newURL, false);
            this.modClass.addLogEntry(this.configPrefix, e, false);
        }
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "SlotChecker function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }
}

