/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod;

import de.stefan1200.jts3servermod.ChatCommands;
import de.stefan1200.jts3servermod.ClientDatabaseCache;
import de.stefan1200.jts3servermod.InstanceManager;
import de.stefan1200.jts3servermod.MyLogger;
import de.stefan1200.jts3servermod.ServerInfoCache;
import de.stefan1200.jts3servermod.SlotChecker;
import de.stefan1200.jts3servermod.interfaces.ClientDatabaseCache_Interface;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleClientList;
import de.stefan1200.jts3servermod.interfaces.HandleTS3Events;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3servermod.interfaces.ServerInfoCache_Interface;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.jts3serverquery.TeamspeakActionListener;
import de.stefan1200.util.ArrangedPropertiesWriter;
import de.stefan1200.util.DatatypeConverter;
import de.stefan1200.util.MySQLConnect;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Key;
import java.sql.Statement;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JTS3ServerMod
implements TeamspeakActionListener,
JTS3ServerMod_Interface {
    public static final int API_BUILD = 4;
    static final String[] LIST_OPTIONS = new String[]{"-away", "-groups", "-info", "-times", "-uid", "-voice", "-country", "-ip"};
    static final String[] ERROR_LEVEL_NAMES = new String[]{"DEBUG", "INFO", "WARNING", "ERROR", "CRITICAL", "STATUS"};
    static final byte ERROR_LEVEL_STATUS = 5;
    static final String VERSIONCHECK_URL = "https://www.stefan1200.de/versioncheck/JTS3ServerMod_HostingEdition.version2";
    private int reloadState = 2;
    private int reconnectTime = 65000;
    private String CONFIG_FILE_NAME = "server_bot.cfg";
    private String defaultConfigFileHeader = "Config file of the JTS3ServerMod 6.5.8 Hosting Edition (16.12.2023)\nhttp://www.stefan1200.de\nThis file must be saved with the encoding ISO-8859-1!";
    private String TS3_ADDRESS;
    private int TS3_QUERY_PORT = 10011;
    private boolean TS3_QUERY_SSH = false;
    private String TS3_LOGIN;
    private String TS3_PASSWORD;
    private int TS3_VIRTUALSERVER_ID;
    private int TS3_VIRTUALSERVER_PORT;
    private int BOT_CHANNEL_ID;
    private boolean SLOW_MODE = false;
    private int CHECK_INTERVAL;
    private String MESSAGE_ENCODING;
    private String SERVER_QUERY_NAME;
    private String SERVER_QUERY_NAME_2;
    private boolean RECONNECT_FOREVER;
    private boolean CLIENT_DATABASE_CACHE = false;
    private boolean GLOBAL_MESSAGE_VARS = false;
    private Vector<String> ADMIN_UID_LIST = new Vector();
    private Vector<Integer> LIGHTADMINGROUP_LIST = new Vector();
    private SlotChecker slotChecker = null;
    private String CSVLOGGER_FILE;
    private String logFilePath;
    private int DEFAULT_CHANNEL_ID = -1;
    private String lastNumberValueAtConfigLoad = null;
    private String lastExceptionAtConfigLoad = null;
    private boolean updateCache = false;
    private boolean DEBUG = false;
    private boolean noLogEntry = false;
    private byte botUpdateCheck = 0;
    private SimpleDateFormat sdf;
    private long startTime = 0L;
    private int exceptionCounter = 0;
    private int exceptionCounterCache = 0;
    private String instanceName;
    private String listArguments = null;
    private int instanceID = -1;
    private boolean mysqlMode = false;
    private MySQLConnect mysqlConnect = null;
    private MyLogger logger = null;
    private Vector<HashMap<String, String>> permissionListCache = null;
    private Vector<HashMap<String, String>> serverGroupListCache = null;
    private Vector<HashMap<String, String>> channelGroupListCache = null;
    private Vector<HashMap<String, String>> channelListCache = null;
    private Vector<HashMap<String, String>> clientList = null;
    private Vector<HandleBotEvents> classList_ts3EventServer = new Vector();
    private Vector<HandleBotEvents> classList_ts3EventChannel = new Vector();
    private Vector<String> functionList_Name = new Vector();
    private Vector<String> functionList_Prefix = new Vector();
    private Vector<Boolean> functionList_Enabled = new Vector();
    private Vector<HandleBotEvents> functionList_Class = new Vector();
    private Vector<JarFile> functionList_JarFile = new Vector();
    private Vector<URLClassLoader> functionList_URLClassLoader = new Vector();
    private ArrangedPropertiesWriter config = null;
    private JTS3ServerQuery queryLib;
    private JTS3ServerQuery queryLibChat = null;
    private JTS3ServerQuery queryLibCache = null;
    private int localPortMain = -1;
    private int localPortChat = -1;
    private int localPortCache = -1;
    private InstanceManager manager;
    private ClientDatabaseCache clientCache = null;
    private ServerInfoCache serverInfoCache = null;
    private ChatCommands chatCommands = null;
    private PrintStream csvLogFile = null;
    private byte botLogLevel = 1;
    private Timer botTimer;
    private TimerTask timerCheck;
    private TimerTask timerReconnect;
    private TimerTask timerKeepAliveChatBranch;
    private TimerTask timerUpdateCache;
    private BitSet listOptions = new BitSet(10);
    private Pattern patternFunctionPrefix = Pattern.compile("[a-z0-9\\_\\-]+", 66);
    private String cryptIV = "d8a9538Ab6609f21";
    private String cryptKey = "";

    public JTS3ServerMod(String configFile, boolean mysqlMode, int instanceID, MySQLConnect mysqlConnect) {
        this.noLogEntry = true;
        this.mysqlMode = mysqlMode;
        this.instanceID = instanceID;
        this.mysqlConnect = mysqlConnect;
        this.initVars();
        this.CONFIG_FILE_NAME = configFile;
        this.reloadState = 3;
    }

    public JTS3ServerMod(ArrangedPropertiesWriter apw, String configFile) {
        this.noLogEntry = true;
        this.initVars();
        this.config = apw;
        this.config.setNewMainClass(this);
        this.CONFIG_FILE_NAME = configFile;
        this.reloadState = 3;
    }

    public JTS3ServerMod(InstanceManager manager, String instanceName, String configFile, String logFilePath, String cryptKey, boolean mysqlMode, int instanceID, MySQLConnect mysqlConnect, MyLogger logger) {
        this.cryptKey = cryptKey;
        this.noLogEntry = false;
        this.CONFIG_FILE_NAME = configFile;
        this.manager = manager;
        this.instanceName = instanceName;
        this.mysqlMode = mysqlMode;
        this.instanceID = instanceID;
        this.mysqlConnect = mysqlConnect;
        this.logger = logger;
        this.logFilePath = logFilePath;
        this.initVars();
        this.queryLib = new JTS3ServerQuery(instanceName);
    }

    public JTS3ServerMod(String instanceName, String configFile) {
        this.noLogEntry = true;
        this.initVars();
        this.CONFIG_FILE_NAME = configFile;
        this.instanceName = instanceName;
        this.reloadState = 3;
        int configOK = this.loadAndCheckConfig(true);
        if (configOK == 0) {
            if (this.config.save(this.CONFIG_FILE_NAME, this.defaultConfigFileHeader)) {
                System.out.println(String.valueOf(instanceName) + ": Config OK and written updated file to disk!");
            } else {
                System.out.println(String.valueOf(instanceName) + ": Config OK, but an error occurred while writing to disk! Maybe file write protected?");
            }
        } else {
            String errorMsg = this.getErrorMessage(configOK);
            System.out.println(String.valueOf(instanceName) + ": Config checked and found following errors:\n" + errorMsg + "\nNot written to disk!");
        }
    }

    static void showHelp() {
        System.out.println("JTS3ServerMod 6.5.8 Hosting Edition (16.12.2023)");
        System.out.println("-help\t\tShows this help message");
        System.out.println("-version\tShows installed and latest version of JTS3ServerMod");
        System.out.println("-config <path>\tSet a different config file for the instance manager, default config/JTS3ServerMod_InstanceManager.cfg");
        System.out.println("-updateconfig\tCheck bot config file and write updated config file to disk");
        System.out.println("-log <path>\tSet a different path for the instance manager logfile, default JTS3ServerMod_InstanceManager.log");
    }

    public static void main(String[] args) {
        String configFilePath = null;
        String logFilePath = null;
        if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-config") || args[i].equalsIgnoreCase("/config") || args[i].equalsIgnoreCase("--config")) {
                    if (args.length > i + 1) {
                        configFilePath = args[i + 1];
                        ++i;
                    }
                } else if (args[i].equalsIgnoreCase("-log") || args[i].equalsIgnoreCase("/log") || args[i].equalsIgnoreCase("--log")) {
                    if (args.length > i + 1) {
                        logFilePath = args[i + 1];
                        ++i;
                    }
                } else if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("/help") || args[i].equalsIgnoreCase("--help")) {
                    JTS3ServerMod.showHelp();
                    System.exit(0);
                } else if (args[i].equalsIgnoreCase("-version") || args[i].equalsIgnoreCase("/version") || args[i].equalsIgnoreCase("--version")) {
                    System.exit(JTS3ServerMod.showVersionCheck());
                } else if (args[i].equalsIgnoreCase("-versioncheck") || args[i].equalsIgnoreCase("/versioncheck") || args[i].equalsIgnoreCase("--versioncheck")) {
                    System.exit(JTS3ServerMod.showVersionCheck());
                } else if (args[i].equalsIgnoreCase("-updateconfig") || args[i].equalsIgnoreCase("/updateconfig") || args[i].equalsIgnoreCase("--updateconfig")) {
                    new InstanceManager(configFilePath);
                    System.exit(0);
                }
                ++i;
            }
        }
        new InstanceManager(configFilePath, logFilePath);
    }

    static int showVersionCheck() {
        System.out.println("JTS3ServerMod");
        System.out.println("Current installed version:");
        System.out.println("6.5.8 Hosting Edition (16.12.2023) [6509]");
        HashMap<String, String> versionData = JTS3ServerMod.getVersionCheckData();
        if (versionData != null) {
            long finalBuild;
            if (versionData.get("final.version") != null) {
                System.out.println("Latest stable version:");
                System.out.println(String.valueOf(versionData.get("final.version")) + " [" + versionData.get("final.build") + "]");
            }
            if (versionData.get("dev.version") != null) {
                System.out.println("Latest development version:");
                System.out.println(String.valueOf(versionData.get("dev.version")) + " [" + versionData.get("dev.build") + "]");
            }
            long devBuild = versionData.get("dev.build") == null ? 0L : Long.parseLong(versionData.get("dev.build"));
            long l = finalBuild = versionData.get("final.build") == null ? 0L : Long.parseLong(versionData.get("final.build"));
            if (6509L < finalBuild) {
                System.out.println("New stable version is available (exit code 1)!");
                return 1;
            }
            if (6509L < devBuild) {
                System.out.println("New development version is available (exit code 2)!");
                return 2;
            }
        } else {
            System.out.println("Unable to request the current JTS3ServerMod version from https://www.stefan1200.de (exit code -1)!");
            return -1;
        }
        return 0;
    }

    static HashMap<String, String> getVersionCheckData() {
        HashMap<String, String> versionData = new HashMap<String, String>();
        try {
            String tmp;
            URL versionCheckUrl = new URL(VERSIONCHECK_URL);
            BufferedReader versionCheckStream = new BufferedReader(new InputStreamReader(versionCheckUrl.openStream()));
            while ((tmp = versionCheckStream.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(tmp, ";", false);
                String modeLine = st.nextToken();
                if (modeLine.equalsIgnoreCase("final")) {
                    versionData.put("final.build", st.nextToken());
                    versionData.put("final.version", st.nextToken());
                    versionData.put("final.url", st.nextToken());
                }
                if (!modeLine.equalsIgnoreCase("development")) continue;
                versionData.put("dev.build", st.nextToken());
                versionData.put("dev.version", st.nextToken());
                versionData.put("dev.url", st.nextToken());
            }
            versionCheckStream.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            versionData = null;
        }
        return versionData;
    }

    public String getPermissionName(int permissionID) {
        if (this.permissionListCache == null) {
            return null;
        }
        String sPermissionID = Integer.toString(permissionID);
        String retValue = null;
        for (HashMap<String, String> permission : this.permissionListCache) {
            if (!permission.get("permid").equals(sPermissionID)) continue;
            retValue = permission.get("permname");
            break;
        }
        return retValue;
    }

    @Override
    public String getMessageEncoding() {
        return this.MESSAGE_ENCODING;
    }

    @Override
    public String getChannelName(int channelID) {
        if (this.channelListCache == null) {
            return null;
        }
        String sChannelID = Integer.toString(channelID);
        String retValue = null;
        for (HashMap<String, String> channel : this.channelListCache) {
            if (!channel.get("cid").equals(sChannelID)) continue;
            retValue = channel.get("channel_name");
            break;
        }
        return retValue;
    }

    @Override
    public boolean setChannelName(int channelID, String newName) {
        if (this.channelListCache == null) {
            return false;
        }
        if (newName == null) {
            return false;
        }
        String sChannelID = Integer.toString(channelID);
        boolean retValue = false;
        int i = 0;
        while (i < this.channelListCache.size()) {
            if (this.channelListCache.elementAt(i).get("cid").equals(sChannelID)) {
                this.channelListCache.elementAt(i).put("channel_name", newName);
                retValue = true;
                break;
            }
            ++i;
        }
        return retValue;
    }

    @Override
    public boolean removeChannelListEntry(int channelID) {
        String sChannelID = Integer.toString(channelID);
        boolean retValue = false;
        int i = 0;
        while (i < this.channelListCache.size()) {
            if (this.channelListCache.elementAt(i).get("cid").equals(sChannelID)) {
                this.channelListCache.removeElementAt(i);
                retValue = true;
                break;
            }
            ++i;
        }
        return retValue;
    }

    private void updateStartTimeMySQL() {
        if (!this.mysqlMode) {
            return;
        }
        Statement st = null;
        try {
            this.mysqlConnect.connect();
            st = this.mysqlConnect.getStatement();
            st.executeUpdate("UPDATE jts3servermod_instances SET laststarttime = " + System.currentTimeMillis() + " WHERE id = " + Integer.toString(this.instanceID));
            this.mysqlConnect.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateSuccessLoginTimeMySQL() {
        if (!this.mysqlMode) {
            return;
        }
        Statement st = null;
        try {
            this.mysqlConnect.connect();
            st = this.mysqlConnect.getStatement();
            st.executeUpdate("UPDATE jts3servermod_instances SET lastsuccesslogintime = " + System.currentTimeMillis() + " WHERE id = " + Integer.toString(this.instanceID));
            this.mysqlConnect.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initVars() {
        this.DEBUG = this.manager != null ? this.manager.isDebugModeEnabled(this) : false;
        if (this.queryLib != null) {
            this.queryLib.DEBUG_COMMLOG_PATH = "JTS3ServerQuery-communication" + (this.instanceName == null ? "" : "_" + this.instanceName) + ".log";
            this.queryLib.DEBUG_ERRLOG_PATH = "JTS3ServerQuery-error" + (this.instanceName == null ? "" : "_" + this.instanceName) + ".log";
            this.queryLib.DEBUG = this.DEBUG;
        }
        this.localPortMain = -1;
        this.localPortChat = -1;
        this.localPortCache = -1;
        this.TS3_ADDRESS = null;
        this.TS3_QUERY_PORT = 10011;
        this.TS3_LOGIN = null;
        this.TS3_PASSWORD = null;
        this.TS3_VIRTUALSERVER_ID = -1;
        this.TS3_VIRTUALSERVER_PORT = -1;
        this.BOT_CHANNEL_ID = -1;
        this.botLogLevel = 1;
        this.exceptionCounter = 0;
        this.exceptionCounterCache = 0;
        this.SLOW_MODE = false;
        this.CHECK_INTERVAL = 1;
        this.MESSAGE_ENCODING = "UTF-8";
        this.SERVER_QUERY_NAME = null;
        this.SERVER_QUERY_NAME_2 = null;
        this.RECONNECT_FOREVER = false;
        this.ADMIN_UID_LIST = new Vector();
        this.LIGHTADMINGROUP_LIST = new Vector();
        this.DEFAULT_CHANNEL_ID = -1;
        this.lastNumberValueAtConfigLoad = null;
        this.updateCache = false;
        this.botUpdateCheck = 0;
        this.permissionListCache = null;
        this.clientCache = null;
        this.serverInfoCache = null;
        this.serverGroupListCache = null;
        this.channelGroupListCache = null;
        this.listArguments = null;
        this.listOptions.clear();
        this.botTimer = new Timer(true);
        this.slotChecker = new SlotChecker();
        this.slotChecker.initClass(this, this.queryLib, "slotchecker");
        this.config = new ArrangedPropertiesWriter(this);
        this.config.setDefaultConfigFileHeader(this.defaultConfigFileHeader);
        this.initConfig();
    }

    private void initConfig() {
        this.config.addKey("ts3_server_address", "Teamspeak 3 server address");
        this.config.addKey("ts3_server_query_port", "Teamspeak 3 server query port, default is 10011", "10011");
        this.config.addKey("ts3_server_query_login", "Teamspeak 3 server query admin account name");
        this.config.addKey("ts3_server_query_password", "Teamspeak 3 server query admin password");
        this.config.addKey("ts3_server_query_mode", "Teamspeak 3 server query mode, possible values: raw and ssh\nraw = The default unencrypted way to connect to the TS3 server.\nssh = The communication to the TS3 server will be encrypted. Possible since TS3 server version 3.3.0 and needs to be activated at the TS3 server.", "raw");
        this.config.addKey("ts3_virtualserver_id", "Teamspeak 3 virtual server ID or -1 to use ts3_virtualserver_port");
        this.config.addKey("ts3_virtualserver_port", "Teamspeak 3 virtual server port, only needed if ts3_virtualserver_id is set to -1");
        this.config.addSeparator();
        this.config.addKey("bot_channel_id", "Channel id, the bot will join into it after connecting. If not wanted, use a negative number like -1.\nDon't set the default channel here, because the bot is already in the default channel after connecting.", "-1");
        this.config.addKey("bot_slowmode", "Activate the slow mode of the bot, 0 = disable, 1 = enable.\nIf slow mode is activated, the bot connects slower to the server\nand disables some bot features to reduce the amount of needed commands.\nThis feature may allow you to use the bot without whitelist the bot IP address.\nSlow mode disables the client database list cache and do not allow the bot check interval to be lower than 3 seconds.", "0");
        this.config.addKey("bot_check_interval", "Check every X seconds, default is 1. Values between 1 and 30 are allowed.\nIf slow mode is activated, 3 is the lowest possible value.", "1");
        if (!this.mysqlMode) {
            this.config.addKey("bot_messages_encoding", "A different encoding of the messages config files.\nDefault is UTF-8 which should be good for all EU and US languages.\nChange this only if you know what you are doing!\nFor English or German language you can also use the encoding ISO-8859-1\nA list of all valid ones: http://docs.oracle.com/javase/1.5.0/docs/guide/intl/encoding.doc.html", "UTF-8");
        }
        this.config.addKey("bot_clientdblist_cache", "This enables the client database list cache. This cache is needed for commands like !searchip or !searchdesc. 1 = Enable, 0 = Disable", "1");
        this.config.addKey("bot_global_message_vars", "This enables the global message variables. See readme file for a list of variables. 1 = Enable, 0 = Disable\nIf enabled, you can use all server variables in all messages. If not needed, disable this to save performance.", "0");
        this.config.addKey("bot_server_query_name", "Server Query name, this will be displayed as name of the connection.", "JTS3ServerMod");
        this.config.addKey("bot_server_query_name_2", "Second Server Query name, this will be displayed as name of the connection.\nThis name will be used, if the first name is already in use.", "MyJTS3ServerMod");
        this.config.addKey("bot_date_pattern", "Change the date pattern, which will be used to format a date in chat functions and welcome message.\nTo get help how to make such a pattern, look here: http://docs.oracle.com/javase/1.5.0/docs/api/java/text/SimpleDateFormat.html", "yyyy-MM-dd HH:mm:ss");
        this.config.addKey("bot_timezone", "Change the timezone of the bot, which will be used for the date of the chat functions and welcome message.\nIf nothing is set here, the default timezone of the operating system will be used.\nTo get a list of valid timezones, look at the TZ column on the following page:\nhttps://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List", "");
        this.config.addKey("bot_connect_forever", "Should the bot try to connect forever if the Teamspeak server or the bot is offline? 0 = disable, 1 = enable", "0");
        this.config.addKey("bot_log_level", "Minimum log level, how much details you want to be written to the bot log files? Default is 1.\nHigher log levels will be also written, as an example: You set log level to 2, level 2, 3 and critical errors will be written to bot log file.\n0 = Debug\n1 = Information (recommended and default)\n2 = Warning (recommended for smaller log files)\n3 = Error (experts only)", "1");
        this.config.addKey("bot_admin_list", "A comma separated list (without spaces) of unique user ids, which should be able to use bot admin commands.\nThe unique user ids looks like this: mBbHRXwDAG7R19Rv3PorhMwbZW4=");
        this.config.addKey("bot_lightadmingroup_list", "A comma separated list (without spaces) of server group ids, which should be able to use the following bot admin commands:\n!channellist, !listchannelgroups, !listinactiveclients, !listinactivechannels, !listservergroups, !msgchannelgroup, !msgservergroup, !pokechannelgroup,\n!pokeservergroup, !removeservergroups, !removechannelgroups, !searchclient, !searchdesc, !searchip, !setchannelgroup and !setchannelname.\nAll other bot admin commands are not allowed!");
        this.config.addSeparator();
        this.slotChecker.initConfig(this.config);
        this.config.addSeparator();
        this.config.addKey("bot_functions", "Set a comma separated list (without spaces) of needed bot functions here.\nEach function needs the function class (or plugin filename) and the function name, both separated with a colon.\nAll possible function classes are listed below, that class is case sensitive!\nYou can use external functions, they have to be in the plugins directory and you have to use the filename\nincluding the jar file extension as function class, as an example: AutoKickTimer.jar:akt\nThat function name you choose is important and has to be unique. It will be used as prefix for the configuration key names and chat commands.\nDon't use spaces in the function names, only use letters, numbers, minus and underscore!\nMost functions allow multiple usage, that allows you to set as many welcome messages or idle check rules, as you want.\nDon't forget that you have to put all settings of the functions in this file.\nHint: Start the bot with the argument -updateconfig after adding bot functions, that writes the configuration for all functions into this file!\nWhole command: java -jar JTS3ServerMod.jar -updateconfig\nNotice: This -updateconfig will also delete all lines of removed or renamed functions in this config file!\nFor more information about the functions read documents/ConfigHelp.html or documents/ConfigHelp_deutsch.html!\n\nExample: IdleCheck:idle,IdleCheck:idle_guest,MuteMover:mute,WelcomeMessage:welcome,WelcomeMessage:welcome_guest\nThis example gives you the following:\n- Two IdleCheck with the name idle and idle_guest\n- One MuteMover with the name mute\n- Two WelcomeMessage with the name welcome and welcome_guest\n\nFunction list (multiple use possible):\nAdvertising - Send messages to channel or server chat every X minutes\nAutoMove - Move connecting clients of a specified server group to a specified channel\nAwayMover - Move the client as soon as away status is set for longer than X seconds\nBadChannelNameCheck - Checking for bad channel names, can delete the channel and punish the client\nBadNicknameCheck - Checking for bad nicknames and can punish the client\nChannelNotify - Notify specified server groups about clients joining a specified channel\nIdleCheck - Move or kick an idle client, can also send an idle warning message\nInactiveChannelCheck - Delete channels if empty for more than X hours\nInactiveClientsCleaner - Deletes clients (including permissions) from the TS3 database after X days inactivity (client database list cache must be enabled!)\nLastSeen - Chat command to check the last online time of a client\nMuteMover - Move the client as soon as the specified mute status is set for longer than X seconds\nRecordCheck - Move or kick a recording client (of course only the record function of the Teamspeak client is detected)\nServerGroupNotify - Notify specified server groups about clients of specified server groups connecting to the TS3 server\nServerGroupProtection - Make sure that only specified clients are members of the specified server groups\nWelcomeMessage - Sends a message to new connected clients");
        this.config.addKey("bot_functions_disabled", "Set a comma separated list (without spaces) of needed but disabled bot functions here.\nSame format as bot_functions!\nAll functions you set here are not activated at bot start, but you can switch on functions using chat commands.");
        this.config.addSeparator();
        this.config.addSeparator();
    }

    String getErrorMessage(int errorCode) {
        if (errorCode == 10) {
            return "Multi IP Mode, Slow Mode and SSH Query mode is enabled for this bot. This combination is not supported!" + (this.mysqlMode ? "" : " Config file: " + this.CONFIG_FILE_NAME);
        }
        if (errorCode == 20) {
            if (this.lastNumberValueAtConfigLoad != null) {
                return "Critical: An expected number value in config is not a number or is completely missing! Look at value " + this.lastNumberValueAtConfigLoad + " in config" + (this.mysqlMode ? "!" : " file: " + this.CONFIG_FILE_NAME);
            }
            return "Critical: An expected number value in config is not a number or is completely missing!" + (this.mysqlMode ? "" : "Config file: " + this.CONFIG_FILE_NAME);
        }
        if (errorCode == 23) {
            return "Critical: Teamspeak 3 server address, loginname or password missing in config file!" + (this.mysqlMode ? "" : " Config file: " + this.CONFIG_FILE_NAME);
        }
        if (errorCode == 31) {
            return "Critical: Server query name in config need at least 3 characters!" + (this.mysqlMode ? "" : " Config file: " + this.CONFIG_FILE_NAME);
        }
        if (errorCode == 32) {
            return "Critical: Config file missing or is not readable, check: " + this.CONFIG_FILE_NAME;
        }
        if (errorCode == 40) {
            return "Critical: Unexpected error occurred in bot configuration!" + (this.mysqlMode ? "" : " Config file: " + this.CONFIG_FILE_NAME) + (this.lastExceptionAtConfigLoad != null && this.logger == null ? "\n" + this.lastExceptionAtConfigLoad : "");
        }
        if (errorCode == 99) {
            return "Critical: Error while reading configuration from MySQL database!";
        }
        return "Unknown";
    }

    private void loadFunctions() {
        int duplicateClassCount = 0;
        boolean loadBotClass = false;
        boolean internalFunction = true;
        int configKeyCount = 0;
        int i = 0;
        while (i < this.functionList_Prefix.size()) {
            try {
                Class<?> newFunction;
                if (this.functionList_Name.elementAt(i).endsWith(".jar")) {
                    File jarFile = new File(String.valueOf(System.getProperty("app.home", "")) + "plugins" + File.separator + this.functionList_Name.elementAt(i));
                    this.functionList_JarFile.setElementAt(new JarFile(jarFile), i);
                    Manifest pluginManifest = this.functionList_JarFile.elementAt(i).getManifest();
                    Attributes pluginManifestAttributes = pluginManifest.getMainAttributes();
                    String mainClass = pluginManifestAttributes.getValue(Attributes.Name.MAIN_CLASS);
                    this.functionList_URLClassLoader.setElementAt(new URLClassLoader(new URL[]{jarFile.toURI().toURL()}), i);
                    newFunction = this.functionList_URLClassLoader.elementAt(i).loadClass(mainClass);
                    internalFunction = false;
                } else {
                    newFunction = Class.forName("de.stefan1200.jts3servermod.functions." + this.functionList_Name.elementAt(i));
                    internalFunction = true;
                }
                if (HandleBotEvents.class.isAssignableFrom(newFunction)) {
                    int plugin_api;
                    loadBotClass = false;
                    HandleBotEvents functionClass = (HandleBotEvents)newFunction.newInstance();
                    if (!internalFunction && (plugin_api = functionClass.getAPIBuild()) != 4) {
                        this.addLogEntry((byte)2, "Plugin \"" + this.functionList_Name.elementAt(i) + "\" is not compatible with this JTS3ServerMod version. Found plugin api build " + Integer.toString(plugin_api) + ", but need api build " + Integer.toString(4) + " - Plugin unloaded!", this.getMySQLConnection() == null);
                        this.simpleRemoveFunction(i);
                        --i;
                    } else {
                        duplicateClassCount = Collections.frequency(this.functionList_Name, this.functionList_Name.elementAt(i));
                        if (duplicateClassCount > 1) {
                            if (functionClass.multipleInstances()) {
                                loadBotClass = true;
                            } else {
                                this.addLogEntry((byte)2, "Function class \"" + this.functionList_Name.elementAt(i) + "\" can only used once per virtual bot instance! Skipping all of this.", this.getMySQLConnection() == null);
                                this.removeDuplicateFunctions(this.functionList_Name.elementAt(i));
                                --i;
                            }
                        } else {
                            loadBotClass = true;
                        }
                        if (loadBotClass) {
                            functionClass.initClass(this, this.queryLib, this.functionList_Prefix.elementAt(i));
                            this.functionList_Class.setElementAt(functionClass, i);
                            if (LoadConfiguration.class.isAssignableFrom(newFunction)) {
                                configKeyCount = this.config.getKeyCount();
                                ((LoadConfiguration)((Object)functionClass)).initConfig(this.config);
                                if (configKeyCount < this.config.getKeyCount()) {
                                    this.config.addSeparator();
                                }
                            }
                            this.addLogEntry((byte)1, "Successfully loaded function: " + this.functionList_Name.elementAt(i) + " / " + this.functionList_Prefix.elementAt(i), false);
                        }
                    }
                } else {
                    this.addLogEntry((byte)3, "Can't load function class \"" + this.functionList_Name.elementAt(i) + "\", it's not a valid bot function! Skipping all of this.", false);
                    this.removeDuplicateFunctions(this.functionList_Name.elementAt(i));
                    --i;
                }
            }
            catch (Exception e) {
                this.addLogEntry((byte)3, "Error loading function, skipping: " + this.functionList_Name.elementAt(i) + " / " + this.functionList_Prefix.elementAt(i), this.getMySQLConnection() == null);
                this.addLogEntry(e, false);
                this.simpleRemoveFunction(i);
                --i;
            }
            ++i;
        }
    }

    private void simpleRemoveFunction(int pos) {
        this.functionList_Name.removeElementAt(pos);
        this.functionList_Prefix.removeElementAt(pos);
        this.functionList_Enabled.removeElementAt(pos);
        this.functionList_Class.removeElementAt(pos);
        if (this.functionList_JarFile.elementAt(pos) != null) {
            try {
                this.functionList_JarFile.elementAt(pos).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.functionList_URLClassLoader.elementAt(pos) != null) {
            try {
                this.functionList_URLClassLoader.elementAt(pos).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.functionList_JarFile.removeElementAt(pos);
        this.functionList_URLClassLoader.removeElementAt(pos);
    }

    int[] reloadConfig(boolean preconnect) {
        String lightAdminListTemp;
        String adminListTemp = this.config.getValue("bot_admin_list");
        if (adminListTemp != null) {
            this.ADMIN_UID_LIST.clear();
            StringTokenizer adminListTokenizer = new StringTokenizer(adminListTemp, ",", false);
            while (adminListTokenizer.hasMoreTokens()) {
                this.ADMIN_UID_LIST.addElement(adminListTokenizer.nextToken().trim());
            }
        }
        if ((lightAdminListTemp = this.config.getValue("bot_lightadmingroup_list")) != null) {
            this.LIGHTADMINGROUP_LIST.clear();
            StringTokenizer lightAdminListTokenizer = new StringTokenizer(lightAdminListTemp, ",", false);
            while (lightAdminListTokenizer.hasMoreTokens()) {
                try {
                    this.LIGHTADMINGROUP_LIST.addElement(Integer.parseInt(lightAdminListTokenizer.nextToken().trim()));
                }
                catch (NumberFormatException nfe) {
                    this.addLogEntry((byte)2, "Invalid light admin server group id, only numbers are allowed at config value bot_lightadmingroup_list!", this.getMySQLConnection() == null);
                }
            }
        }
        try {
            this.slotChecker.loadConfig(this.config, this.SLOW_MODE);
        }
        catch (Exception lightAdminListTokenizer) {
            // empty catch block
        }
        try {
            this.sdf = new SimpleDateFormat(this.config.getValue("bot_date_pattern", "yyyy-MM-dd HH:mm:ss").trim());
        }
        catch (Exception eSDF) {
            this.addLogEntry((byte)3, "Date pattern " + (this.getMySQLConnection() == null ? "from config value bot_date_pattern " : "from bot configuration ") + "is invalid, using the default date pattern now!", this.getMySQLConnection() == null);
            this.addLogEntry(eSDF, false);
        }
        try {
            String botTimezone = this.config.getValue("bot_timezone", "").trim();
            if (botTimezone.length() > 1) {
                this.sdf.setTimeZone(TimeZone.getTimeZone(botTimezone));
                this.addLogEntry((byte)1, "Timezone successfully set to: " + botTimezone, this.getMySQLConnection() == null);
            } else {
                this.sdf.setTimeZone(TimeZone.getDefault());
            }
        }
        catch (Exception eSDF) {
            this.addLogEntry((byte)3, "Timezone " + (this.getMySQLConnection() == null ? "from config value bot_timezone " : "from bot configuration ") + "is invalid, using the default timezone now!", this.getMySQLConnection() == null);
            this.addLogEntry(eSDF, false);
            this.sdf.setTimeZone(TimeZone.getDefault());
        }
        this.GLOBAL_MESSAGE_VARS = this.config.getValue("bot_global_message_vars", "0").equals("1");
        int[] count = new int[2];
        int i = 0;
        while (i < this.functionList_Class.size()) {
            if (LoadConfiguration.class.isAssignableFrom(this.functionList_Class.elementAt(i).getClass())) {
                try {
                    if (this.functionList_Enabled.elementAt(i).booleanValue() && !preconnect) {
                        this.functionList_Class.elementAt(i).disable();
                    }
                    if (((LoadConfiguration)((Object)this.functionList_Class.elementAt(i))).loadConfig(this.config, this.SLOW_MODE)) {
                        if (this.functionList_Enabled.elementAt(i).booleanValue() && !preconnect) {
                            this.functionList_Class.elementAt(i).activate();
                        }
                        count[1] = count[1] + 1;
                    } else {
                        count[0] = count[0] + 1;
                    }
                }
                catch (Exception e) {
                    count[0] = count[0] + 1;
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Exception in loadConfig(), disable() or activate()!", false);
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                }
            }
            ++i;
        }
        return count;
    }

    int reloadConfig(String prefix) {
        int i = 0;
        while (i < this.functionList_Prefix.size()) {
            if (this.functionList_Prefix.elementAt(i).equalsIgnoreCase(prefix)) {
                if (!LoadConfiguration.class.isAssignableFrom(this.functionList_Class.elementAt(i).getClass())) break;
                boolean result = false;
                try {
                    if (this.functionList_Enabled.elementAt(i).booleanValue()) {
                        this.functionList_Class.elementAt(i).disable();
                    }
                }
                catch (Exception e) {
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Exception in disable()!", false);
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                }
                try {
                    result = ((LoadConfiguration)((Object)this.functionList_Class.elementAt(i))).loadConfig(this.config, this.SLOW_MODE);
                }
                catch (Exception e) {
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Exception in loadConfig()!", false);
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                }
                try {
                    if (result && this.functionList_Enabled.elementAt(i).booleanValue()) {
                        this.functionList_Class.elementAt(i).activate();
                    }
                    return result ? 1 : 0;
                }
                catch (Exception e) {
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Exception in activate()!", false);
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                    break;
                }
            }
            ++i;
        }
        return -1;
    }

    String[] getCurrentLoadedFunctions() {
        StringBuffer sbTempEnabled = new StringBuffer();
        StringBuffer sbTempDisabled = new StringBuffer();
        int i = 0;
        while (i < this.functionList_Prefix.size()) {
            if (this.functionList_Enabled.elementAt(i).booleanValue()) {
                if (sbTempEnabled.length() > 0) {
                    sbTempEnabled.append("\n");
                }
                sbTempEnabled.append(this.functionList_Prefix.elementAt(i));
                sbTempEnabled.append(" / ");
                sbTempEnabled.append(this.functionList_Name.elementAt(i));
            } else {
                if (sbTempDisabled.length() > 0) {
                    sbTempDisabled.append("\n");
                }
                sbTempDisabled.append(this.functionList_Prefix.elementAt(i));
                sbTempDisabled.append(" / ");
                sbTempDisabled.append(this.functionList_Name.elementAt(i));
            }
            ++i;
        }
        String[] retValue = new String[]{sbTempEnabled.toString(), sbTempDisabled.toString()};
        return retValue;
    }

    String getFunctionCopyright(String prefix) {
        int i = 0;
        while (i < this.functionList_Prefix.size()) {
            if (this.functionList_Prefix.elementAt(i).equalsIgnoreCase(prefix)) {
                try {
                    return this.functionList_Class.elementAt(i).getCopyright();
                }
                catch (Exception e) {
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Exception in getCopyright()!", false);
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                }
            }
            ++i;
        }
        return null;
    }

    byte activateFunction(String prefix) {
        int i = 0;
        while (i < this.functionList_Prefix.size()) {
            if (this.functionList_Prefix.elementAt(i).equalsIgnoreCase(prefix)) {
                if (this.functionList_Enabled.elementAt(i).booleanValue()) {
                    return 0;
                }
                try {
                    this.functionList_Class.elementAt(i).activate();
                    this.functionList_Enabled.setElementAt(true, i);
                    this.createBotFunctionsConfig();
                    this.addLogEntry((byte)1, "Function activated: " + this.functionList_Name.elementAt(i) + " / " + this.functionList_Prefix.elementAt(i), false);
                    return 1;
                }
                catch (Exception e) {
                    this.addLogEntry((byte)3, "Error in activateFunction(" + prefix + ")!", false);
                    this.addLogEntry(e, false);
                }
            }
            ++i;
        }
        return -1;
    }

    byte disableFunction(String prefix) {
        int i = 0;
        while (i < this.functionList_Prefix.size()) {
            if (this.functionList_Prefix.elementAt(i).equalsIgnoreCase(prefix)) {
                if (!this.functionList_Enabled.elementAt(i).booleanValue()) {
                    return 0;
                }
                try {
                    this.functionList_Class.elementAt(i).disable();
                    this.functionList_Enabled.setElementAt(false, i);
                    this.createBotFunctionsConfig();
                    this.addLogEntry((byte)1, "Function disabled: " + this.functionList_Name.elementAt(i) + " / " + this.functionList_Prefix.elementAt(i), false);
                    return 1;
                }
                catch (Exception e) {
                    this.addLogEntry((byte)3, "Error in disableFunction(" + prefix + ")!", false);
                    this.addLogEntry(e, false);
                }
            }
            ++i;
        }
        return -1;
    }

    void createBotFunctionsConfig() {
        StringBuffer sbBotFunctions = new StringBuffer();
        StringBuffer sbBotFunctionsDisabled = new StringBuffer();
        int i = 0;
        while (i < this.functionList_Prefix.size()) {
            if (this.functionList_Enabled.elementAt(i).booleanValue()) {
                if (sbBotFunctions.length() > 0) {
                    sbBotFunctions.append(",");
                }
                sbBotFunctions.append(this.functionList_Name.elementAt(i));
                sbBotFunctions.append(":");
                sbBotFunctions.append(this.functionList_Prefix.elementAt(i));
            } else {
                if (sbBotFunctionsDisabled.length() > 0) {
                    sbBotFunctionsDisabled.append(",");
                }
                sbBotFunctionsDisabled.append(this.functionList_Name.elementAt(i));
                sbBotFunctionsDisabled.append(":");
                sbBotFunctionsDisabled.append(this.functionList_Prefix.elementAt(i));
            }
            ++i;
        }
        this.config.setValue("bot_functions", sbBotFunctions.toString());
        this.config.setValue("bot_functions_disabled", sbBotFunctionsDisabled.toString());
    }

    String getCommandList(HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        StringBuffer sbTemp = new StringBuffer();
        String sPrefix = null;
        int i = 0;
        while (i < this.functionList_Class.size()) {
            if (this.functionList_Enabled.elementAt(i).booleanValue() && HandleTS3Events.class.isAssignableFrom(this.functionList_Class.elementAt(i).getClass())) {
                try {
                    sPrefix = this.functionList_Prefix.elementAt(i);
                    String[] commands = ((HandleTS3Events)((Object)this.functionList_Class.elementAt(i))).botChatCommandList(eventInfo, isFullAdmin, isAdmin);
                    if (commands != null) {
                        String[] stringArray = commands;
                        int n = commands.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String command = stringArray[n2];
                            if (command.length() == 0) {
                                sbTemp.append("\n!" + sPrefix);
                            } else {
                                sbTemp.append("\n!" + sPrefix + " " + command);
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    this.addLogEntry((byte)3, "Error in getCommandList() at function " + (sPrefix == null ? null : sPrefix) + "!", false);
                    this.addLogEntry(e, false);
                }
            }
            ++i;
        }
        return sbTemp.toString();
    }

    String getCommandHelp(String args) {
        String sPrefix;
        String commandArgs = "";
        int pos = args.indexOf(" ");
        if (pos == -1) {
            sPrefix = args;
        } else {
            sPrefix = args.substring(0, pos);
            commandArgs = args.substring(pos + 1);
        }
        int i = 0;
        while (i < this.functionList_Prefix.size()) {
            if (this.functionList_Enabled.elementAt(i).booleanValue() && this.functionList_Prefix.elementAt(i).equalsIgnoreCase(sPrefix) && HandleTS3Events.class.isAssignableFrom(this.functionList_Class.elementAt(i).getClass())) {
                try {
                    return ((HandleTS3Events)((Object)this.functionList_Class.elementAt(i))).botChatCommandHelp(commandArgs);
                }
                catch (Exception e) {
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Exception in botChatCommandHelp(" + commandArgs + ")!", false);
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                }
            }
            ++i;
        }
        return null;
    }

    private void removeDuplicateFunctions(String className) {
        int i = 0;
        while (i < this.functionList_Prefix.size()) {
            if (this.functionList_Name.elementAt(i).equals(className)) {
                this.simpleRemoveFunction(i);
                --i;
            }
            ++i;
        }
    }

    private void unloadAllFunctions() {
        int i = 0;
        while (i < this.functionList_Class.size()) {
            if (this.functionList_Class.elementAt(i) != null) {
                this.functionList_Class.elementAt(i).disable();
            }
            if (this.functionList_Class.elementAt(i) != null) {
                this.functionList_Class.elementAt(i).unload();
            }
            if (this.functionList_JarFile.elementAt(i) != null) {
                try {
                    this.functionList_JarFile.elementAt(i).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.functionList_URLClassLoader.elementAt(i) != null) {
                try {
                    this.functionList_URLClassLoader.elementAt(i).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.functionList_Name.clear();
        this.functionList_Prefix.clear();
        this.functionList_Enabled.clear();
        this.functionList_Class.clear();
        this.functionList_JarFile.clear();
        this.functionList_URLClassLoader.clear();
        this.classList_ts3EventChannel.clear();
        this.classList_ts3EventServer.clear();
        this.addLogEntry((byte)1, "Unloaded all functions!", false);
    }

    @Override
    public void unloadFunction(Object c) {
        int pos = this.functionList_Class.indexOf(c);
        if (pos != -1) {
            this.addLogEntry((byte)1, "Successfully unloaded function: " + this.functionList_Name.elementAt(pos) + " / " + this.functionList_Prefix.elementAt(pos), false);
            ((HandleBotEvents)c).disable();
            ((HandleBotEvents)c).unload();
            this.simpleRemoveFunction(pos);
            this.classList_ts3EventChannel.removeElement(c);
            this.classList_ts3EventServer.removeElement(c);
        } else {
            this.addLogEntry((byte)2, "Unloading function not possible, function not found!", false);
        }
    }

    private String getFunctionPrefix(Object c) {
        int pos = this.functionList_Class.indexOf(c);
        if (pos != -1) {
            return this.functionList_Prefix.elementAt(pos);
        }
        return null;
    }

    boolean loadConfigValues() {
        if (this.mysqlMode) {
            return this.config.loadValues(this.mysqlConnect, this.instanceID);
        }
        return this.config.loadValues(this.CONFIG_FILE_NAME);
    }

    int loadAndCheckConfig(boolean fromFile) {
        return this.loadConfig(fromFile);
    }

    private int loadConfig(boolean fromFile) {
        String lastNumberValue;
        block52: {
            block53: {
                Matcher ruleCheck;
                StringTokenizer st;
                String[] functionTemp;
                String sFunctionTemp;
                String temp;
                block51: {
                    block50: {
                        block49: {
                            block48: {
                                lastNumberValue = null;
                                if (fromFile) {
                                    if (this.mysqlMode) {
                                        if (!this.config.loadValues(this.mysqlConnect, this.instanceID)) {
                                            return 99;
                                        }
                                    } else if (!this.config.loadValues(this.CONFIG_FILE_NAME)) {
                                        return 32;
                                    }
                                }
                                if (this.DEBUG) {
                                    this.botLogLevel = 0;
                                } else {
                                    lastNumberValue = "bot_log_level";
                                    this.botLogLevel = Byte.parseByte(this.config.getValue("bot_log_level", "1").trim());
                                    if (this.botLogLevel > 3) {
                                        this.botLogLevel = (byte)3;
                                    }
                                    this.addLogEntry((byte)5, "Activate log level: " + ERROR_LEVEL_NAMES[this.botLogLevel], false);
                                    if (this.logger != null) {
                                        this.logger.updateLogLevel(this.instanceID, this.botLogLevel);
                                    }
                                }
                                if (this.manager != null) {
                                    this.CSVLOGGER_FILE = this.manager.getConnectionLogPath(this);
                                    this.botUpdateCheck = this.manager.getBotUpdateCheckState();
                                } else {
                                    this.csvLogFile = null;
                                    this.botUpdateCheck = 0;
                                }
                                temp = this.config.getValue("bot_slowmode", "0");
                                this.SLOW_MODE = temp.equals("1");
                                lastNumberValue = "bot_check_interval";
                                this.CHECK_INTERVAL = Integer.parseInt(this.config.getValue("bot_check_interval", "1").trim());
                                if (this.CHECK_INTERVAL > 30) {
                                    this.CHECK_INTERVAL = 30;
                                }
                                if (this.SLOW_MODE) {
                                    if (this.CHECK_INTERVAL < 3) {
                                        this.CHECK_INTERVAL = 3;
                                    }
                                    if (this.manager.isMultiIPModeEnabled()) {
                                        this.localPortMain = this.manager.getNextFreePort();
                                        this.localPortChat = this.manager.getNextFreePort();
                                        this.localPortCache = this.manager.getNextFreePort();
                                    }
                                } else if (this.CHECK_INTERVAL < 1) {
                                    this.CHECK_INTERVAL = 1;
                                }
                                this.SERVER_QUERY_NAME = this.config.getValue("bot_server_query_name", "JTS3ServerMod");
                                this.SERVER_QUERY_NAME_2 = this.config.getValue("bot_server_query_name_2");
                                this.MESSAGE_ENCODING = this.config.getValue("bot_messages_encoding", "UTF-8");
                                if (this.SERVER_QUERY_NAME.length() >= 3) break block48;
                                return 31;
                            }
                            temp = this.config.getValue("bot_clientdblist_cache", "0");
                            this.CLIENT_DATABASE_CACHE = temp.equals("1") ? !this.SLOW_MODE || this.manager.isMultiIPModeEnabled() : false;
                            temp = this.config.getValue("bot_connect_forever", "0");
                            this.RECONNECT_FOREVER = temp.equals("1");
                            this.TS3_ADDRESS = this.config.getValue("ts3_server_address").trim();
                            lastNumberValue = "ts3_server_query_port";
                            temp = this.config.getValue("ts3_server_query_port");
                            if (temp == null) {
                                throw new NumberFormatException();
                            }
                            this.TS3_QUERY_PORT = Integer.parseInt(temp.trim());
                            this.TS3_QUERY_SSH = this.config.getValue("ts3_server_query_mode").equalsIgnoreCase("ssh");
                            this.TS3_LOGIN = this.config.getValue("ts3_server_query_login");
                            this.TS3_PASSWORD = this.decryptPW(this.config.getValue("ts3_server_query_password"));
                            lastNumberValue = "ts3_virtualserver_id";
                            temp = this.config.getValue("ts3_virtualserver_id");
                            if (temp == null) {
                                throw new NumberFormatException();
                            }
                            this.TS3_VIRTUALSERVER_ID = Integer.parseInt(temp.trim());
                            lastNumberValue = "bot_channel_id";
                            this.BOT_CHANNEL_ID = Integer.parseInt(this.config.getValue("bot_channel_id", "-1").trim());
                            if (!this.manager.isMultiIPModeEnabled() || !this.SLOW_MODE || !this.TS3_QUERY_SSH) break block49;
                            this.TS3_QUERY_SSH = false;
                            return 10;
                        }
                        if (this.TS3_ADDRESS.equalsIgnoreCase("ts3.server.net")) {
                            this.addLogEntry((byte)3, " ", this.getMySQLConnection() == null);
                            this.addLogEntry((byte)3, "**********************************************************************************", this.getMySQLConnection() == null);
                            this.addLogEntry((byte)3, "It seems you never touched the config, check file " + this.CONFIG_FILE_NAME, this.getMySQLConnection() == null);
                            this.addLogEntry((byte)3, "**********************************************************************************", this.getMySQLConnection() == null);
                            this.addLogEntry((byte)3, " ", this.getMySQLConnection() == null);
                        }
                        if (this.TS3_VIRTUALSERVER_ID < 1) {
                            lastNumberValue = "ts3_virtualserver_port";
                            temp = this.config.getValue("ts3_virtualserver_port");
                            if (temp == null) {
                                throw new NumberFormatException();
                            }
                            this.TS3_VIRTUALSERVER_PORT = Integer.parseInt(temp.trim());
                        }
                        if (this.TS3_ADDRESS != null && this.TS3_LOGIN != null && this.TS3_PASSWORD != null) break block50;
                        return 23;
                    }
                    try {
                        this.slotChecker.loadConfig(this.config, this.SLOW_MODE);
                    }
                    catch (Exception e) {
                        if (this.logger != null) {
                            this.addLogEntry("slotchecker", (byte)3, "Exception in loadConfig()!", false);
                        }
                        if (this.logger == null) break block51;
                        this.addLogEntry("slotchecker", e, false);
                    }
                }
                temp = this.config.getValue("bot_functions", "").trim();
                if (temp != null && temp.length() > 0) {
                    sFunctionTemp = null;
                    functionTemp = null;
                    st = new StringTokenizer(temp, ",", false);
                    while (st.hasMoreTokens()) {
                        sFunctionTemp = st.nextToken().trim();
                        functionTemp = sFunctionTemp.split(":");
                        if (functionTemp.length == 2) {
                            if (this.functionList_Prefix.indexOf(functionTemp[1]) == -1) {
                                ruleCheck = this.patternFunctionPrefix.matcher(functionTemp[1]);
                                if (ruleCheck.matches()) {
                                    this.functionList_Name.addElement(functionTemp[0]);
                                    this.functionList_Prefix.addElement(functionTemp[1]);
                                    this.functionList_Enabled.addElement(true);
                                    this.functionList_Class.addElement(null);
                                    this.functionList_JarFile.addElement(null);
                                    this.functionList_URLClassLoader.addElement(null);
                                    continue;
                                }
                                this.addLogEntry((byte)3, "Your chosen function name is not valid. Don't use spaces, only use letters, numbers, underscore and minus. Skipping this one: " + functionTemp[1], this.getMySQLConnection() == null);
                                continue;
                            }
                            this.addLogEntry((byte)3, "Your chosen function name is not unique, skipping this one: " + functionTemp[1], this.getMySQLConnection() == null);
                            continue;
                        }
                        this.addLogEntry((byte)3, "This wrong: \"" + sFunctionTemp + "\". Skipping this one. Right format is function class and function name separated with a colon!", this.getMySQLConnection() == null);
                    }
                }
                if ((temp = this.config.getValue("bot_functions_disabled", "").trim()) != null && temp.length() > 0) {
                    sFunctionTemp = null;
                    functionTemp = null;
                    st = new StringTokenizer(temp, ",", false);
                    while (st.hasMoreTokens()) {
                        sFunctionTemp = st.nextToken().trim();
                        functionTemp = sFunctionTemp.split(":");
                        if (functionTemp.length == 2) {
                            if (this.functionList_Prefix.indexOf(functionTemp[1]) == -1) {
                                ruleCheck = this.patternFunctionPrefix.matcher(functionTemp[1]);
                                if (ruleCheck.matches()) {
                                    this.functionList_Name.addElement(functionTemp[0]);
                                    this.functionList_Prefix.addElement(functionTemp[1]);
                                    this.functionList_Enabled.addElement(false);
                                    this.functionList_Class.addElement(null);
                                    this.functionList_JarFile.addElement(null);
                                    this.functionList_URLClassLoader.addElement(null);
                                    continue;
                                }
                                this.addLogEntry((byte)3, "Your chosen function name is not valid. Don't use spaces, only use letters, numbers, underscore and minus. Skipping this one: " + functionTemp[1], this.getMySQLConnection() == null);
                                continue;
                            }
                            this.addLogEntry((byte)3, "Your chosen function name is not unique, skipping this one: " + functionTemp[1], this.getMySQLConnection() == null);
                            continue;
                        }
                        this.addLogEntry((byte)3, "This wrong: \"" + sFunctionTemp + "\". Skipping this one. Right format is function class and function name separated with a colon!", this.getMySQLConnection() == null);
                    }
                }
                this.loadFunctions();
                if (!fromFile) break block52;
                if (!this.mysqlMode) break block53;
                if (!this.config.loadValues(this.mysqlConnect, this.instanceID)) {
                    return 99;
                }
                break block52;
            }
            if (this.config.loadValues(this.CONFIG_FILE_NAME)) break block52;
            return 32;
        }
        try {
            this.reloadConfig(true);
        }
        catch (NumberFormatException nfe) {
            if (this.logger != null) {
                this.addLogEntry((byte)3, "Exception in loadConfig()!", false);
            }
            if (this.logger != null) {
                this.addLogEntry(nfe, false);
            }
            this.lastNumberValueAtConfigLoad = new String(lastNumberValue);
            return 20;
        }
        catch (Exception e1) {
            if (this.logger != null) {
                this.addLogEntry((byte)3, "Exception in loadConfig()!", false);
            }
            if (this.logger != null) {
                this.addLogEntry(e1, false);
            }
            this.lastExceptionAtConfigLoad = e1.toString();
            return 40;
        }
        return 0;
    }

    String encryptPW(String value) {
        if (this.cryptKey.length() == 0) {
            return value;
        }
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(this.cryptKey.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CFB8/NoPadding");
            cipher.init(1, (Key)skeySpec, new IvParameterSpec(this.cryptIV.getBytes()));
            String encrypt = DatatypeConverter.printBase64Binary(cipher.doFinal(value.getBytes()));
            return String.valueOf('\u0005') + encrypt;
        }
        catch (Exception e) {
            this.addLogEntry((byte)3, "Unknown error while encrypting password!", this.getMySQLConnection() == null);
            this.addLogEntry(e, false);
            return null;
        }
    }

    private String decryptPW(String encrypted) {
        if (this.cryptKey.length() == 0) {
            return encrypted;
        }
        if (encrypted.charAt(0) != '\u0005') {
            return encrypted;
        }
        try {
            SecretKeySpec k = new SecretKeySpec(this.cryptKey.getBytes(), "AES");
            Cipher c = Cipher.getInstance("AES/CFB8/NoPadding");
            c.init(2, (Key)k, new IvParameterSpec(this.cryptIV.getBytes()));
            byte[] decodedValue = DatatypeConverter.parseBase64Binary(encrypted.substring(1));
            byte[] decValue = c.doFinal(decodedValue);
            String decryptedValue = new String(decValue);
            return decryptedValue;
        }
        catch (Exception e) {
            this.addLogEntry((byte)3, "Unknown error while decrypting password!", this.getMySQLConnection() == null);
            this.addLogEntry(e, false);
            return null;
        }
    }

    @Override
    public boolean loadMessages(String configPrefix, String configKey_Path, String[] configValues) {
        String line;
        BufferedReader br;
        String path;
        block8: {
            if (this.mysqlMode) {
                return true;
            }
            path = this.config.getValue(String.valueOf(configPrefix) + configKey_Path);
            if (path == null) {
                this.addLogEntry(configPrefix, (byte)3, "Path to messages was not set in bot config! Check config key: " + configPrefix + configKey_Path, this.getMySQLConnection() == null);
                return false;
            }
            path = path.trim().replace("%apphome%", System.getProperty("app.home", ""));
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), this.MESSAGE_ENCODING));
            line = br.readLine();
            if (this.MESSAGE_ENCODING.equalsIgnoreCase("UTF-8") && line != null && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
            }
            if (line != null && line.equals("# JTS3ServerMod Config File")) break block8;
            this.addLogEntry(configPrefix, (byte)3, "Special config file header is missing at the config file! File path: " + path, this.getMySQLConnection() == null);
            this.addLogEntry(configPrefix, (byte)3, "Check if you set the right file at config key: " + configPrefix + configKey_Path, this.getMySQLConnection() == null);
            br.close();
            return false;
        }
        try {
            int count = 0;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.length() <= 3) continue;
                line = line.replace("\\n", "\n");
                this.config.setValue(configValues[count], line);
                if (++count >= configValues.length) break;
            }
            br.close();
        }
        catch (FileNotFoundException fnfe) {
            this.addLogEntry(configPrefix, (byte)3, "The file you set at config key \"" + configPrefix + configKey_Path + "\" does not exist or missing permission for reading, check file path: " + new File(path).getAbsolutePath(), this.getMySQLConnection() == null);
            return false;
        }
        catch (Exception e) {
            this.addLogEntry(configPrefix, (byte)3, "Unknown error while loading messages, check file you set at config key \"" + configPrefix + configKey_Path + "\", the file path: " + path, this.getMySQLConnection() == null);
            this.addLogEntry(configPrefix, e, false);
            return false;
        }
        return true;
    }

    private void outputStartMSG() {
        if (this.CSVLOGGER_FILE != null) {
            String msg = "Server connection log is activated and will be written into the " + (this.CSVLOGGER_FILE.equals("sql") ? "MySQL database" : "file: " + new File(this.CSVLOGGER_FILE).getAbsolutePath());
            this.addLogEntry((byte)1, msg, true);
        }
        this.slotChecker.handleOnBotConnect();
        this.slotChecker.activate();
        int i = 0;
        while (i < this.functionList_Class.size()) {
            if (this.functionList_Enabled.elementAt(i).booleanValue() && HandleBotEvents.class.isAssignableFrom(this.functionList_Class.elementAt(i).getClass())) {
                try {
                    this.functionList_Class.elementAt(i).handleOnBotConnect();
                    this.functionList_Class.elementAt(i).activate();
                }
                catch (Exception e) {
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Exception in handleOnBotConnect() or activate()!", false);
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                }
            }
            ++i;
        }
    }

    private void setListOptions() {
        this.listOptions.clear();
        if (this.CSVLOGGER_FILE != null || this.clientCache != null) {
            this.listOptions.set(4);
            this.listOptions.set(7);
        }
        this.slotChecker.setListModes(this.listOptions);
        int i = 0;
        while (i < this.functionList_Class.size()) {
            if (LoadConfiguration.class.isAssignableFrom(this.functionList_Class.elementAt(i).getClass())) {
                try {
                    ((LoadConfiguration)((Object)this.functionList_Class.elementAt(i))).setListModes(this.listOptions);
                }
                catch (Exception e) {
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Exception in setListModes()!", false);
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                }
            }
            ++i;
        }
    }

    private void createListArguments() {
        this.listArguments = "";
        int i = this.listOptions.nextSetBit(0);
        while (i >= 0) {
            this.listArguments = this.listArguments.equals("") ? String.valueOf(this.listArguments) + LIST_OPTIONS[i] : String.valueOf(this.listArguments) + "," + LIST_OPTIONS[i];
            i = this.listOptions.nextSetBit(i + 1);
        }
    }

    private void removeInstance() {
        this.manager.removeInstance(this);
    }

    void runThread() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    do {
                        if (JTS3ServerMod.this.reloadState == 2) {
                            JTS3ServerMod.this.initVars();
                            JTS3ServerMod.this.runMod();
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (JTS3ServerMod.this.reloadState != 0);
                }
                catch (Throwable t) {
                    JTS3ServerMod.this.addLogEntry((byte)3, "Unknown error catched, ask bot administrator to check InstanceManager logfile for more information!", true);
                    JTS3ServerMod.this.manager.addLogEntry("ERROR", "Unknown error catched at instance: " + JTS3ServerMod.this.instanceName, false);
                    JTS3ServerMod.this.manager.addLogEntry(t);
                }
                JTS3ServerMod.this.addLogEntry((byte)5, "Virtual bot instance \"" + JTS3ServerMod.this.instanceName + "\" stopped", JTS3ServerMod.this.getMySQLConnection() == null);
                JTS3ServerMod.this.removeInstance();
            }
        });
        t.setName(this.instanceName);
        t.start();
    }

    private void runMod() {
        block52: {
            this.updateStartTimeMySQL();
            this.reloadState = 3;
            this.startTime = System.currentTimeMillis();
            this.addLogEntry((byte)5, "Virtual bot instance \"" + this.instanceName + "\" starts now (build " + 6509L + ")" + (this.DEBUG ? " - Debug mode activated!" : ""), this.getMySQLConnection() == null);
            int configOK = this.loadAndCheckConfig(true);
            this.reloadState = 1;
            if (configOK != 0) {
                this.addLogEntry((byte)4, this.getErrorMessage(configOK), true);
                this.stopBotInstance(0);
                return;
            }
            if (this.SLOW_MODE) {
                this.addLogEntry((byte)1, "Slow mode activated (using less commands at once)", this.getMySQLConnection() == null);
            }
            try {
                if (this.SLOW_MODE && this.manager.isMultiIPModeEnabled()) {
                    this.queryLib.connectTS3Query(this.TS3_ADDRESS, this.TS3_QUERY_PORT, this.manager.getMainIP(), this.localPortMain);
                } else if (this.TS3_QUERY_SSH) {
                    this.queryLib.connectTS3SSHQuery(this.TS3_ADDRESS, this.TS3_QUERY_PORT, this.TS3_LOGIN, this.TS3_PASSWORD);
                } else {
                    this.queryLib.connectTS3Query(this.TS3_ADDRESS, this.TS3_QUERY_PORT);
                }
                this.addLogEntry((byte)1, "Successful connected to " + this.TS3_ADDRESS + (this.TS3_QUERY_SSH ? " (encrypted)" : "") + "!", this.getMySQLConnection() == null);
            }
            catch (Exception e) {
                boolean sendUnableConnectError = true;
                if (this.TS3_QUERY_SSH && e.getMessage().equalsIgnoreCase("auth fail")) {
                    this.addLogEntry((byte)4, "Unable to login as \"" + this.TS3_LOGIN + "\"! SSH connection to Teamspeak 3 server at " + this.TS3_ADDRESS + " aborted!", this.getMySQLConnection() == null);
                    sendUnableConnectError = false;
                }
                if (sendUnableConnectError) {
                    this.addLogEntry((byte)4, "Unable to connect to Teamspeak 3 server at " + this.TS3_ADDRESS + "!", this.getMySQLConnection() == null);
                }
                this.addLogEntry(e, this.getMySQLConnection() == null);
                this.reconnectBot(false);
                return;
            }
            try {
                if (!this.TS3_QUERY_SSH) {
                    this.queryLib.loginTS3(this.TS3_LOGIN, this.TS3_PASSWORD);
                }
                this.addLogEntry((byte)1, "Login as \"" + this.TS3_LOGIN + "\" successful!", this.getMySQLConnection() == null);
            }
            catch (Exception e) {
                String errmsg = "Unable to login as \"" + this.TS3_LOGIN + "\"!";
                boolean errperm = false;
                if (e instanceof TS3ServerQueryException && ((TS3ServerQueryException)e).getFailedPermissionID() >= 0) {
                    errmsg = String.valueOf(errmsg) + " Make sure, that the server group \"Guest Server Query\" has the permission \"b_serverquery_login\"!";
                    errperm = true;
                }
                if (!errperm) {
                    errmsg = String.valueOf(errmsg) + " Maybe this IP address is banned for some minutes on that server!";
                }
                this.addLogEntry((byte)4, errmsg, this.getMySQLConnection() == null);
                this.addLogEntry(e, this.getMySQLConnection() == null);
                this.stopBotInstance(0);
                return;
            }
            if (this.TS3_VIRTUALSERVER_ID >= 1) {
                try {
                    this.queryLib.selectVirtualServer(this.TS3_VIRTUALSERVER_ID, false, false, this.SERVER_QUERY_NAME);
                    this.addLogEntry((byte)1, "Successful selected virtual server " + Integer.toString(this.TS3_VIRTUALSERVER_ID) + "!", this.getMySQLConnection() == null);
                }
                catch (Exception e) {
                    String errmsg = "Unable to select virtual server " + Integer.toString(this.TS3_VIRTUALSERVER_ID) + "!";
                    if (e instanceof TS3ServerQueryException && ((TS3ServerQueryException)e).getFailedPermissionID() >= 0) {
                        errmsg = String.valueOf(errmsg) + " Make sure, that the server group \"Guest Server Query\" has the permission \"b_virtualserver_select\"!";
                    }
                    this.addLogEntry((byte)4, errmsg, this.getMySQLConnection() == null);
                    this.addLogEntry(e, this.getMySQLConnection() == null);
                    this.reconnectBot(false);
                    return;
                }
            }
            try {
                this.queryLib.selectVirtualServer(this.TS3_VIRTUALSERVER_PORT, true, false, this.SERVER_QUERY_NAME);
                this.addLogEntry((byte)1, "Successful selected virtual server on port " + Integer.toString(this.TS3_VIRTUALSERVER_PORT) + "!", this.getMySQLConnection() == null);
            }
            catch (Exception e) {
                String errmsg = "Unable to select virtual server on port " + Integer.toString(this.TS3_VIRTUALSERVER_PORT) + "!";
                if (e instanceof TS3ServerQueryException && ((TS3ServerQueryException)e).getFailedPermissionID() >= 0) {
                    errmsg = String.valueOf(errmsg) + " Make sure, that the server group \"Guest Server Query\" has the permission \"b_virtualserver_select\"!";
                }
                this.addLogEntry((byte)4, errmsg, this.getMySQLConnection() == null);
                this.addLogEntry(e, this.getMySQLConnection() == null);
                this.reconnectBot(false);
                return;
            }
            try {
                this.permissionListCache = this.queryLib.getList(6);
            }
            catch (Exception e) {
                this.permissionListCache = null;
                this.addLogEntry((byte)2, "Unable to receive permission list! If possible, please set the permission \"b_serverinstance_permission_list\" to the bot query account \"" + this.TS3_LOGIN + "\" or the \"Guest Server Query\" group.", this.getMySQLConnection() == null);
            }
            try {
                if (!this.queryLib.getCurrentQueryClientName().equals(this.SERVER_QUERY_NAME)) {
                    this.queryLib.setDisplayName(this.SERVER_QUERY_NAME);
                }
            }
            catch (Exception e) {
                this.addLogEntry((byte)2, "Unable to change name to \"" + this.SERVER_QUERY_NAME + "\"!", this.getMySQLConnection() == null);
                this.addLogEntry(e, this.getMySQLConnection() == null);
                if (this.SERVER_QUERY_NAME_2 == null || this.SERVER_QUERY_NAME_2.length() < 3) break block52;
                this.addLogEntry((byte)1, "Try using \"" + this.SERVER_QUERY_NAME_2 + "\"...", this.getMySQLConnection() == null);
                try {
                    this.queryLib.setDisplayName(this.SERVER_QUERY_NAME_2);
                }
                catch (Exception e2) {
                    this.addLogEntry((byte)2, "Unable to change name to \"" + this.SERVER_QUERY_NAME_2 + "\"!", this.getMySQLConnection() == null);
                    this.addLogEntry(e, this.getMySQLConnection() == null);
                }
            }
        }
        if (this.SLOW_MODE && this.manager.isMultiIPModeEnabled()) {
            this.queryLibChat = new JTS3ServerQuery();
            if (!this.connectBranch(this.queryLibChat, this.manager.getChatIP(), this.localPortChat, "Chat")) {
                this.addLogEntry((byte)2, "Bot could not spawn chat connection! Unable to receive chat messages and welcome messages is not working!", this.getMySQLConnection() == null);
                this.queryLibChat = null;
            }
            if (this.CLIENT_DATABASE_CACHE) {
                this.queryLibCache = new JTS3ServerQuery();
                if (!this.connectBranch(this.queryLibCache, this.manager.getCacheIP(), this.localPortCache, "Cache")) {
                    this.addLogEntry((byte)2, "Bot could not spawn cache connection! Client Database Cache disabled!", this.getMySQLConnection() == null);
                    this.queryLibCache = null;
                    this.CLIENT_DATABASE_CACHE = false;
                }
            }
        }
        if (this.SLOW_MODE) {
            try {
                Thread.sleep(4000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.botTimer == null) {
                return;
            }
        }
        if (this.BOT_CHANNEL_ID > 0 && this.BOT_CHANNEL_ID != this.queryLib.getCurrentQueryClientChannelID()) {
            if (this.queryLib.getCurrentQueryClientID() == -1) {
                this.reconnectBot(false);
            }
            try {
                this.queryLib.moveClient(this.queryLib.getCurrentQueryClientID(), this.BOT_CHANNEL_ID, null);
            }
            catch (Exception e) {
                this.addLogEntry((byte)3, "Unable to switch channel (own client ID: " + Integer.toString(this.queryLib.getCurrentQueryClientID()) + ")!", this.getMySQLConnection() == null);
                this.addLogEntry(e, this.getMySQLConnection() == null);
            }
        }
        if (this.SLOW_MODE && this.manager.isMultiIPModeEnabled()) {
            if (this.queryLibChat != null) {
                this.setNotify(this.queryLibChat);
            }
        } else {
            this.setNotify(this.queryLib);
        }
        if (this.SLOW_MODE && !this.manager.isMultiIPModeEnabled()) {
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.botTimer == null) {
                return;
            }
        }
        this.serverInfoCache = new ServerInfoCache();
        if (!this.handleUpdateCache()) {
            if (this.botTimer != null) {
                this.reconnectBot(false);
            }
            return;
        }
        this.clientCache = this.SLOW_MODE && this.manager.isMultiIPModeEnabled() ? new ClientDatabaseCache(this.queryLibCache, this, this.CLIENT_DATABASE_CACHE, true) : new ClientDatabaseCache(this.queryLib, this, this.CLIENT_DATABASE_CACHE);
        this.outputStartMSG();
        this.setListOptions();
        this.createListArguments();
        if (this.SLOW_MODE && this.manager.isMultiIPModeEnabled()) {
            this.chatCommands = new ChatCommands(this.queryLibChat, this, this.clientCache, this.sdf, this.config, this.manager);
            this.timerKeepAliveChatBranch = new TimerTask(){

                @Override
                public void run() {
                    block6: {
                        if (JTS3ServerMod.this.queryLibChat != null) {
                            HashMap<String, String> result = JTS3ServerMod.this.queryLibChat.doCommand("whoami");
                            try {
                                int iresult = 666;
                                if (result != null) {
                                    iresult = Integer.parseInt(result.get("id"));
                                }
                                if (iresult == 0) break block6;
                                JTS3ServerMod.this.queryLibChat.closeTS3Connection();
                                if (!JTS3ServerMod.this.connectBranch(JTS3ServerMod.this.queryLibChat, JTS3ServerMod.this.manager.getChatIP(), JTS3ServerMod.this.localPortChat, "Chat")) break block6;
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                JTS3ServerMod.this.setNotify(JTS3ServerMod.this.queryLibChat);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
            this.botTimer.schedule(this.timerKeepAliveChatBranch, 120000L, 120000L);
        } else {
            this.chatCommands = new ChatCommands(this.queryLib, this, this.clientCache, this.sdf, this.config, this.manager);
        }
        this.timerCheck = new TimerTask(){

            @Override
            public void run() {
                JTS3ServerMod.this.runCheck();
            }
        };
        this.botTimer.schedule(this.timerCheck, this.CHECK_INTERVAL * 1000);
        this.timerUpdateCache = new TimerTask(){

            @Override
            public void run() {
                JTS3ServerMod.this.updateCache = true;
            }
        };
        this.botTimer.schedule(this.timerUpdateCache, 60000L, 60000L);
        this.addLogEntry((byte)1, "Bot started and connected successful, write !botinfo in server chat to get an answer!", this.getMySQLConnection() == null);
        this.updateSuccessLoginTimeMySQL();
    }

    /*
     * Unable to fully structure code
     */
    private void setNotify(JTS3ServerQuery queryLibBranch) {
        block20: {
            block19: {
                queryLibBranch.setTeamspeakActionListener(this);
                try {
                    queryLibBranch.addEventNotify(4, 0);
                    break block19;
                }
                catch (Exception e) {
                    sbNameList = new StringBuffer();
                    if (this.CSVLOGGER_FILE != null) {
                        sbNameList.append("Connection Log");
                    }
                    if (this.botUpdateCheck == 1 || this.botUpdateCheck == 2) {
                        sbNameList.append("Bot Update Check");
                        this.botUpdateCheck = 0;
                    }
                    tempName = null;
                    ** while (this.classList_ts3EventServer.size() > 0)
                }
lbl-1000:
                // 1 sources

                {
                    tempName = this.getFunctionPrefix(this.classList_ts3EventServer.elementAt(0));
                    if (tempName != null) {
                        if (sbNameList.length() > 0) {
                            sbNameList.append(", ");
                        }
                        sbNameList.append(tempName);
                    }
                    this.unloadFunction(this.classList_ts3EventServer.elementAt(0));
                    continue;
                }
lbl25:
                // 1 sources

                this.addLogEntry((byte)3, "Unable to see joining clients! Following functions disabled: " + sbNameList.toString(), this.getMySQLConnection() == null);
                this.addLogEntry(e, this.getMySQLConnection() == null);
                this.CSVLOGGER_FILE = null;
                if (this.csvLogFile != null) {
                    this.csvLogFile.close();
                    this.csvLogFile = null;
                }
            }
            try {
                queryLibBranch.addEventNotify(5, 0);
                break block20;
            }
            catch (Exception e) {
                sbNameList = new StringBuffer();
                tempName = null;
                ** while (this.classList_ts3EventChannel.size() > 0)
            }
lbl-1000:
            // 1 sources

            {
                tempName = this.getFunctionPrefix(this.classList_ts3EventChannel.elementAt(0));
                if (tempName != null) {
                    if (sbNameList.length() > 0) {
                        sbNameList.append(", ");
                    }
                    sbNameList.append(tempName);
                }
                this.unloadFunction(this.classList_ts3EventChannel.elementAt(0));
                continue;
            }
lbl48:
            // 1 sources

            this.addLogEntry((byte)3, "Unable to receive channel join events! Following functions disabled: " + sbNameList.toString(), this.getMySQLConnection() == null);
            this.addLogEntry(e, this.getMySQLConnection() == null);
        }
        try {
            queryLibBranch.addEventNotify(2, 0);
        }
        catch (Exception e) {
            this.addLogEntry((byte)3, "Unable to receive channel chat messages!", this.getMySQLConnection() == null);
            this.addLogEntry(e, this.getMySQLConnection() == null);
        }
        try {
            queryLibBranch.addEventNotify(3, 0);
        }
        catch (Exception e) {
            this.addLogEntry((byte)3, "Unable to receive private chat messages!", this.getMySQLConnection() == null);
            this.addLogEntry(e, this.getMySQLConnection() == null);
        }
        try {
            queryLibBranch.addEventNotify(1, 0);
        }
        catch (Exception e) {
            this.addLogEntry((byte)3, "Unable to receive server chat messages!", this.getMySQLConnection() == null);
            this.addLogEntry(e, this.getMySQLConnection() == null);
        }
    }

    private boolean connectBranch(JTS3ServerQuery queryLibBranch, String localip, int localport, String nameAdd) {
        block12: {
            try {
                queryLibBranch.connectTS3Query(this.TS3_ADDRESS, this.TS3_QUERY_PORT, localip, localport);
                queryLibBranch.loginTS3(this.TS3_LOGIN, this.TS3_PASSWORD);
                if (this.TS3_VIRTUALSERVER_ID >= 1) {
                    queryLibBranch.selectVirtualServer(this.TS3_VIRTUALSERVER_ID, false);
                } else {
                    queryLibBranch.selectVirtualServer(this.TS3_VIRTUALSERVER_PORT, true);
                }
            }
            catch (Exception e) {
                return false;
            }
            try {
                queryLibBranch.setDisplayName(String.valueOf(this.SERVER_QUERY_NAME) + nameAdd);
            }
            catch (Exception e) {
                if (this.SERVER_QUERY_NAME_2 == null || this.SERVER_QUERY_NAME_2.length() < 3) break block12;
                try {
                    queryLibBranch.setDisplayName(String.valueOf(this.SERVER_QUERY_NAME_2) + nameAdd);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.BOT_CHANNEL_ID > 0) {
            if (queryLibBranch.getCurrentQueryClientID() == -1) {
                return false;
            }
            try {
                queryLibBranch.moveClient(queryLibBranch.getCurrentQueryClientID(), this.BOT_CHANNEL_ID, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private void reconnectBot(boolean force) {
        if (this.RECONNECT_FOREVER || force) {
            this.prepareStopBot();
            this.addLogEntry((byte)1, "Reconnecting in " + Integer.toString(this.reconnectTime / 1000) + " seconds...", this.getMySQLConnection() == null);
            this.timerReconnect = new TimerTask(){

                @Override
                public void run() {
                    if (JTS3ServerMod.this.botTimer != null) {
                        JTS3ServerMod.this.botTimer.cancel();
                    }
                    JTS3ServerMod.this.botTimer = null;
                    JTS3ServerMod.this.reloadState = 2;
                }
            };
            if (this.botTimer == null) {
                this.botTimer = new Timer(true);
            }
            this.botTimer.schedule(this.timerReconnect, this.reconnectTime);
            return;
        }
        this.stopBotInstance(0);
    }

    private void prepareStopBot() {
        this.slotChecker.unload();
        this.unloadAllFunctions();
        if (this.timerCheck != null) {
            this.timerCheck.cancel();
        }
        this.timerCheck = null;
        if (this.clientCache != null) {
            this.clientCache.stopUpdating();
        }
        this.clientCache = null;
        if (this.timerKeepAliveChatBranch != null) {
            this.timerKeepAliveChatBranch.cancel();
        }
        this.timerKeepAliveChatBranch = null;
        if (this.timerUpdateCache != null) {
            this.timerUpdateCache.cancel();
        }
        this.timerUpdateCache = null;
        if (this.SLOW_MODE && this.manager.isMultiIPModeEnabled()) {
            if (this.queryLib != null) {
                this.queryLib.closeTS3Connection();
            }
            if (this.queryLibChat != null) {
                try {
                    this.queryLib.removeTeamspeakActionListener();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.queryLibChat.closeTS3Connection();
                this.queryLibChat = null;
            }
            if (this.queryLibCache != null) {
                this.queryLibCache.closeTS3Connection();
                this.queryLibCache = null;
            }
            if (this.localPortMain != -1) {
                this.manager.releasePort(this.localPortMain);
                this.localPortMain = -1;
            }
            if (this.localPortChat != -1) {
                this.manager.releasePort(this.localPortChat);
                this.localPortChat = -1;
            }
            if (this.localPortCache != -1) {
                this.manager.releasePort(this.localPortCache);
                this.localPortCache = -1;
            }
        } else if (this.queryLib != null) {
            try {
                this.queryLib.removeTeamspeakActionListener();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.queryLib.closeTS3Connection();
        }
    }

    void stopBotInstance(int mode) {
        if (mode == 2) {
            this.addLogEntry((byte)5, "Virtual bot instance \"" + this.instanceName + "\" restarts", this.getMySQLConnection() == null);
        }
        this.prepareStopBot();
        if (this.timerReconnect != null) {
            this.timerReconnect.cancel();
        }
        this.timerReconnect = null;
        if (this.botTimer != null) {
            this.botTimer.cancel();
        }
        this.botTimer = null;
        this.reloadState = mode;
        if (mode == 0 && this.csvLogFile != null) {
            this.csvLogFile.close();
            this.csvLogFile = null;
        }
    }

    void renameBotInstance(String newName) {
        this.addLogEntry((byte)1, "Bot renamed from \"" + this.instanceName + "\" to \"" + newName + "\".", this.getMySQLConnection() == null);
        this.instanceName = newName;
        this.queryLib.changeThreadName(newName);
    }

    private void checkTS3Clients() {
        if (!this.queryLib.isConnected()) {
            String msg = "Connection to Teamspeak 3 server lost...";
            this.addLogEntry((byte)4, msg, this.getMySQLConnection() == null);
            this.reconnectBot(true);
            return;
        }
        try {
            this.clientList = this.queryLib.getList(1, this.listArguments);
        }
        catch (Exception e) {
            this.addLogEntry((byte)4, "Error while getting client list!", this.getMySQLConnection() == null);
            this.addLogEntry(e, true);
            this.reconnectBot(true);
            return;
        }
        if (this.serverInfoCache != null) {
            this.serverInfoCache.updateClientCount(this.clientList);
        }
        if (this.updateCache) {
            this.handleUpdateCache();
        }
        int i = 0;
        while (i < this.functionList_Class.size()) {
            if (this.functionList_Enabled.elementAt(i).booleanValue() && HandleClientList.class.isAssignableFrom(this.functionList_Class.elementAt(i).getClass())) {
                try {
                    ((HandleClientList)((Object)this.functionList_Class.elementAt(i))).handleClientCheck(this.clientList);
                }
                catch (Exception e) {
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Error in handleClientCheck()!", false);
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                }
            }
            ++i;
        }
    }

    private boolean handleUpdateCache() {
        this.updateCache = false;
        try {
            this.channelListCache = this.queryLib.getList(2, "-topic,-flags,-icon,-secondsempty");
        }
        catch (Exception e) {
            this.addLogEntry((byte)3, "Error while getting channel list!", this.getMySQLConnection() == null);
            this.addLogEntry(e, this.getMySQLConnection() == null);
            return false;
        }
        for (HashMap<String, String> channel : this.channelListCache) {
            if (!channel.get("channel_flag_default").equals("1")) continue;
            this.DEFAULT_CHANNEL_ID = Integer.parseInt(channel.get("cid"));
        }
        try {
            this.serverGroupListCache = this.queryLib.getList(4);
        }
        catch (Exception e) {
            this.addLogEntry((byte)3, "Error while getting server group list!", this.getMySQLConnection() == null);
            this.addLogEntry(e, this.getMySQLConnection() == null);
            return false;
        }
        try {
            this.channelGroupListCache = this.queryLib.getList(11);
        }
        catch (Exception e) {
            this.addLogEntry((byte)3, "Error while getting channel group list!", this.getMySQLConnection() == null);
            this.addLogEntry(e, this.getMySQLConnection() == null);
            return false;
        }
        if (this.serverInfoCache != null) {
            try {
                this.serverInfoCache.updateServerInfo(this.queryLib.getInfo(11, -1), this.queryLib.getList(5, "duration=1,-count").firstElement());
            }
            catch (Exception e) {
                this.addLogEntry((byte)3, "Error while getting server info!", this.getMySQLConnection() == null);
                this.addLogEntry(e, this.getMySQLConnection() == null);
                return false;
            }
        }
        int i = 0;
        while (i < this.functionList_Class.size()) {
            if (this.functionList_Enabled.elementAt(i).booleanValue() && HandleBotEvents.class.isAssignableFrom(this.functionList_Class.elementAt(i).getClass())) {
                try {
                    this.functionList_Class.elementAt(i).handleAfterCacheUpdate();
                }
                catch (Exception e) {
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Exception in handleAfterCacheUpdate()!", false);
                    this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public ServerInfoCache_Interface getServerInfoCache() {
        return this.serverInfoCache;
    }

    @Override
    public Vector<HashMap<String, String>> getClientList() {
        return this.clientList;
    }

    @Override
    public Vector<HashMap<String, String>> getChannelList() {
        return this.channelListCache;
    }

    @Override
    public MySQLConnect getMySQLConnection() {
        return this.mysqlConnect;
    }

    @Override
    public int getInstanceID() {
        return this.instanceID;
    }

    @Override
    public int getDefaultChannelID() {
        return this.DEFAULT_CHANNEL_ID;
    }

    @Override
    public ClientDatabaseCache_Interface getClientCache() {
        return this.clientCache;
    }

    @Override
    public int getCheckInterval() {
        return this.CHECK_INTERVAL;
    }

    @Override
    public String getStringFromTimestamp(long timestamp) {
        return this.sdf.format(new Date(timestamp));
    }

    @Override
    public void addTS3ChannelEvent(Object obj) {
        if (obj != null) {
            this.classList_ts3EventChannel.addElement((HandleBotEvents)obj);
        }
    }

    @Override
    public void addTS3ServerEvent(Object obj) {
        if (obj != null) {
            this.classList_ts3EventServer.addElement((HandleBotEvents)obj);
        }
    }

    @Override
    public void addBotTimer(TimerTask task, long firstStart, long interval) {
        if (interval > 0L) {
            this.botTimer.schedule(task, firstStart, interval);
        } else {
            this.botTimer.schedule(task, firstStart);
        }
    }

    @Override
    public boolean isLocalClientDatabaseCacheEnabled() {
        return this.CLIENT_DATABASE_CACHE;
    }

    @Override
    public boolean isGlobalMessageVarsEnabled() {
        return this.GLOBAL_MESSAGE_VARS;
    }

    @Override
    public String replaceGlobalMessageVars(String message) {
        String newMessage = new String(message);
        if (this.serverInfoCache != null) {
            if (this.serverInfoCache.getServerName() != null) {
                newMessage = newMessage.replace("%SERVER_NAME%", this.serverInfoCache.getServerName());
            }
            if (this.serverInfoCache.getServerPlatform() != null) {
                newMessage = newMessage.replace("%SERVER_PLATFORM%", this.serverInfoCache.getServerPlatform());
            }
            if (this.serverInfoCache.getServerVersion() != null) {
                newMessage = newMessage.replace("%SERVER_VERSION%", this.getVersionString(this.serverInfoCache.getServerVersion()));
            }
            newMessage = newMessage.replace("%SERVER_UPTIME%", this.getDifferenceTime(this.serverInfoCache.getServerUptimeTimestamp(), System.currentTimeMillis()));
            newMessage = newMessage.replace("%SERVER_CREATED_DATE%", this.getStringFromTimestamp(this.serverInfoCache.getServerCreatedAt()));
            newMessage = newMessage.replace("%SERVER_UPTIME_DATE%", this.getStringFromTimestamp(this.serverInfoCache.getServerUptimeTimestamp()));
            newMessage = newMessage.replace("%SERVER_UPLOAD_QUOTA%", Long.toString(this.serverInfoCache.getServerUploadQuota()));
            newMessage = newMessage.replace("%SERVER_DOWNLOAD_QUOTA%", Long.toString(this.serverInfoCache.getServerDownloadQuota()));
            newMessage = newMessage.replace("%SERVER_MONTH_BYTES_UPLOADED%", this.getFileSizeString(this.serverInfoCache.getServerMonthBytesUploaded(), false));
            newMessage = newMessage.replace("%SERVER_MONTH_BYTES_DOWNLOADED%", this.getFileSizeString(this.serverInfoCache.getServerMonthBytesDownloaded(), false));
            newMessage = newMessage.replace("%SERVER_TOTAL_BYTES_UPLOADED%", this.getFileSizeString(this.serverInfoCache.getServerTotalBytesUploaded(), false));
            newMessage = newMessage.replace("%SERVER_TOTAL_BYTES_DOWNLOADED%", this.getFileSizeString(this.serverInfoCache.getServerTotalBytesDownloaded(), false));
            newMessage = newMessage.replace("%SERVER_MAX_CLIENTS%", Integer.toString(this.serverInfoCache.getServerMaxClients()));
            newMessage = newMessage.replace("%SERVER_RESERVED_SLOTS%", Integer.toString(this.serverInfoCache.getServerReservedSlots()));
            newMessage = newMessage.replace("%SERVER_CHANNEL_COUNT%", Integer.toString(this.serverInfoCache.getServerChannelCount()));
            newMessage = newMessage.replace("%SERVER_CLIENT_COUNT%", Integer.toString(this.serverInfoCache.getServerClientCount()));
            newMessage = newMessage.replace("%SERVER_CLIENT_CONNECTIONS_COUNT%", Long.toString(this.serverInfoCache.getServerClientConnectionsCount()));
            newMessage = newMessage.replace("%SERVER_CLIENT_DB_COUNT%", Integer.toString(this.serverInfoCache.getServerClientDBCount()));
        }
        return newMessage;
    }

    private Vector<String> splitMessage(String configPrefix, String message) {
        Vector<String> messages = new Vector<String>();
        int pos = -3;
        int pos2 = -1;
        try {
            do {
                if ((pos2 = message.indexOf("\u00a7+\u00a7", pos + 3)) > 0) {
                    messages.addElement(message.substring(pos + 3, pos2));
                } else {
                    messages.addElement(message.substring(pos + 3));
                }
                pos = pos2;
            } while (pos2 != -1);
        }
        catch (Exception e) {
            messages.clear();
            messages.addElement(message);
            this.addLogEntry(configPrefix, (byte)3, "Error in splitMessage(" + configPrefix + ", \"" + message + "\")!", false);
            this.addLogEntry(configPrefix, e, false);
        }
        return messages;
    }

    @Override
    public boolean sendMessageToClient(String configPrefix, String mode, int clientID, String message) {
        boolean retValue;
        block17: {
            if (mode == null) {
                return false;
            }
            if (message == null) {
                return false;
            }
            if (this.GLOBAL_MESSAGE_VARS) {
                message = this.replaceGlobalMessageVars(message);
            }
            retValue = false;
            Vector<String> messages = this.splitMessage(configPrefix, message);
            if (mode.equalsIgnoreCase("poke")) {
                try {
                    int i = 0;
                    while (i < messages.size()) {
                        this.queryLib.pokeClient(clientID, messages.elementAt(i));
                        ++i;
                    }
                    retValue = true;
                }
                catch (TS3ServerQueryException sqe) {
                    this.addLogEntry(configPrefix, (byte)2, "Error while poking Client ID: " + Integer.toString(clientID), false);
                    if (sqe.getFailedPermissionID() < 0) {
                        this.addLogEntry(configPrefix, (byte)2, sqe.toString(), false);
                        break block17;
                    }
                    this.addLogEntry(configPrefix, sqe, false);
                }
                catch (Exception e) {
                    this.addLogEntry(configPrefix, (byte)3, "Error while poking Client ID: " + Integer.toString(clientID), false);
                    this.addLogEntry(configPrefix, e, false);
                }
            } else if (mode.equalsIgnoreCase("chat")) {
                try {
                    int i = 0;
                    while (i < messages.size()) {
                        this.queryLib.sendTextMessage(clientID, 1, messages.elementAt(i));
                        ++i;
                    }
                    retValue = true;
                }
                catch (TS3ServerQueryException sqe) {
                    this.addLogEntry(configPrefix, (byte)2, "Error while sending chat message to Client ID: " + Integer.toString(clientID), false);
                    if (sqe.getFailedPermissionID() < 0) {
                        this.addLogEntry(configPrefix, (byte)2, sqe.toString(), false);
                    } else {
                        this.addLogEntry(configPrefix, sqe, false);
                    }
                }
                catch (Exception e) {
                    this.addLogEntry(configPrefix, (byte)3, "Error while sending chat message to Client ID: " + Integer.toString(clientID), false);
                    this.addLogEntry(configPrefix, e, false);
                }
            }
        }
        return retValue;
    }

    @Override
    public int getUTF8Length(CharSequence sequence) {
        int count = 0;
        int i = 0;
        int len = sequence.length();
        while (i < len) {
            char ch = sequence.charAt(i);
            if (ch <= '\u007f') {
                ++count;
            } else if (ch <= '\u07ff') {
                count += 2;
            } else if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
            } else {
                count += 3;
            }
            ++i;
        }
        return count;
    }

    @Override
    public short getMaxMessageLength(String type) {
        if (type == null) {
            return Short.MAX_VALUE;
        }
        if (type.equalsIgnoreCase("chat")) {
            return 8192;
        }
        if (type.equalsIgnoreCase("poke")) {
            return 100;
        }
        if (type.equalsIgnoreCase("kick")) {
            return 80;
        }
        return Short.MAX_VALUE;
    }

    @Override
    public boolean isMessageLengthValid(String type, String message) {
        Vector<String> messages = this.splitMessage(null, message);
        boolean chatMessage = type.equalsIgnoreCase("chat");
        int i = 0;
        while (i < messages.size()) {
            if ((chatMessage ? this.getUTF8Length(messages.elementAt(i)) : messages.elementAt(i).length()) > this.getMaxMessageLength(type)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public long getIdleTime(HashMap<String, String> clientInfo, int ignoreInChannel) {
        long currentIdleTime;
        block2: {
            currentIdleTime = Long.MAX_VALUE;
            try {
                currentIdleTime = Long.parseLong(clientInfo.get("client_idle_time"));
            }
            catch (NumberFormatException nfe) {
                if (clientInfo.get("cid").equals(Integer.toString(ignoreInChannel))) break block2;
                this.addLogEntry((byte)2, "TS3 Server sends wrong client_idle_time for client " + clientInfo.get("client_nickname") + " (id: " + clientInfo.get("clid") + ")", false);
            }
        }
        return currentIdleTime;
    }

    @Override
    public boolean isIDListed(int searchID, Vector<Integer> list) {
        for (int listID : list) {
            if (searchID != listID) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector<HashMap<String, String>> getServerGroupCache() {
        return this.serverGroupListCache;
    }

    @Override
    public String getServerGroupName(int groupID) {
        if (this.serverGroupListCache == null || groupID < 0) {
            return null;
        }
        for (HashMap<String, String> serverGroupInfo : this.serverGroupListCache) {
            if (!serverGroupInfo.get("sgid").equals(Integer.toString(groupID))) continue;
            return serverGroupInfo.get("name");
        }
        return null;
    }

    @Override
    public int getServerGroupType(int groupID) {
        if (this.serverGroupListCache == null || groupID < 0) {
            return -1;
        }
        for (HashMap<String, String> serverGroupInfo : this.serverGroupListCache) {
            if (!serverGroupInfo.get("sgid").equals(Integer.toString(groupID))) continue;
            return Integer.parseInt(serverGroupInfo.get("type"));
        }
        return -1;
    }

    @Override
    public Vector<HashMap<String, String>> getChannelGroupCache() {
        return this.channelGroupListCache;
    }

    @Override
    public String getChannelGroupName(int groupID) {
        if (this.channelGroupListCache == null || groupID < 0) {
            return null;
        }
        for (HashMap<String, String> channelGroupInfo : this.channelGroupListCache) {
            if (!channelGroupInfo.get("cgid").equals(Integer.toString(groupID))) continue;
            return channelGroupInfo.get("name");
        }
        return null;
    }

    @Override
    public int getChannelGroupType(int groupID) {
        if (this.channelGroupListCache == null || groupID < 0) {
            return -1;
        }
        for (HashMap<String, String> channelGroupInfo : this.channelGroupListCache) {
            if (!channelGroupInfo.get("cgid").equals(Integer.toString(groupID))) continue;
            return Integer.parseInt(channelGroupInfo.get("type"));
        }
        return -1;
    }

    @Override
    public int getListedGroup(String groupIDs, Vector<Integer> list) {
        if (groupIDs == null) {
            return -1;
        }
        StringTokenizer groupTokenizer = new StringTokenizer(groupIDs, ",", false);
        while (groupTokenizer.hasMoreTokens()) {
            int groupID = Integer.parseInt(groupTokenizer.nextToken());
            for (int gID : list) {
                if (groupID != gID) continue;
                return groupID;
            }
        }
        return -1;
    }

    @Override
    public boolean isGroupListed(String groupIDs, Vector<Integer> list) {
        if (groupIDs == null) {
            return false;
        }
        StringTokenizer groupTokenizer = new StringTokenizer(groupIDs, ",", false);
        while (groupTokenizer.hasMoreTokens()) {
            int groupID = Integer.parseInt(groupTokenizer.nextToken());
            for (int gID : list) {
                if (groupID != gID) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isGroupListed(String groupIDs, int searchGroupID) {
        if (groupIDs == null) {
            return false;
        }
        StringTokenizer groupTokenizer = new StringTokenizer(groupIDs, ",", false);
        while (groupTokenizer.hasMoreTokens()) {
            int groupID = Integer.parseInt(groupTokenizer.nextToken());
            if (groupID != searchGroupID) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUIDListed(Vector<String> uidList, String uid) {
        if (uid == null) {
            return false;
        }
        boolean found = false;
        for (String uidListEntry : uidList) {
            if (!uidListEntry.equals(uid)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public HashMap<String, String> getClientListEntry(int clientID) {
        String sClientID = Integer.toString(clientID);
        Vector<HashMap<String, String>> currentClientList = this.getClientList();
        for (HashMap<String, String> clientListEntry : currentClientList) {
            if (!clientListEntry.get("clid").equals(sClientID)) continue;
            return clientListEntry;
        }
        return null;
    }

    @Override
    public boolean removeClientListEntry(int clientID) {
        boolean retValue = false;
        String sClientID = Integer.toString(clientID);
        Vector<HashMap<String, String>> currentClientList = this.getClientList();
        int i = 0;
        while (i < currentClientList.size()) {
            if (currentClientList.elementAt(i).get("clid").equals(sClientID)) {
                currentClientList.removeElementAt(i);
                retValue = true;
                break;
            }
            ++i;
        }
        return retValue;
    }

    boolean isLightAdmin(String sClientID) {
        int clientID = -1;
        try {
            clientID = Integer.parseInt(sClientID);
        }
        catch (Exception e) {
            return false;
        }
        HashMap<String, String> clientListEntry = this.getClientListEntry(clientID);
        if (clientListEntry != null) {
            return this.isGroupListed(clientListEntry.get("client_servergroups"), this.LIGHTADMINGROUP_LIST);
        }
        return false;
    }

    private void handleChatMessage(HashMap<String, String> eventInfo) {
        if (Integer.parseInt(eventInfo.get("invokerid")) == this.queryLib.getCurrentQueryClientID()) {
            return;
        }
        String msg = eventInfo.get("msg").trim();
        msg = msg.replace('\u00a0', ' ');
        String lmsg = msg.toLowerCase();
        if (!msg.startsWith("!")) {
            if (eventInfo.get("targetmode").equals("1")) {
                try {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Please use a valid chat command! Get a list of valid chat commands using the chat command [b]!bothelp[/b]");
                }
                catch (Exception e) {
                    this.addLogEntry((byte)3, "Unable to send a \"use valid chat command\" chat message to client " + eventInfo.get("invokername") + " (id: " + eventInfo.get("invokerid") + ")!", false);
                    this.addLogEntry(e, false);
                }
            }
            return;
        }
        boolean isFullAdmin = this.isUIDListed(this.manager.getFullBotAdminList(), eventInfo.get("invokeruid"));
        boolean isAdmin = this.isUIDListed(this.ADMIN_UID_LIST, eventInfo.get("invokeruid"));
        if (lmsg.equals("!botquit") || lmsg.equals("!quit") || lmsg.equals("!exit")) {
            this.chatCommands.handleBotQuit(msg, eventInfo, this.instanceName, isFullAdmin);
        } else if (lmsg.startsWith("!botinstancestop")) {
            this.chatCommands.handleBotInstanceStop(msg, eventInfo, isFullAdmin, this.instanceName);
        } else if (lmsg.startsWith("!botinstancestart")) {
            this.chatCommands.handleBotInstanceStart(msg, eventInfo, isFullAdmin, this.instanceName);
        } else if (lmsg.equals("!botinstancename")) {
            this.chatCommands.handleBotInstanceName(msg, eventInfo, isFullAdmin, this.instanceName);
        } else if (lmsg.equals("!botinstancelist")) {
            this.chatCommands.handleBotInstanceList(msg, eventInfo, isFullAdmin);
        } else if (lmsg.equals("!botinstancelistreload")) {
            this.chatCommands.handleBotInstanceListReload(msg, eventInfo, isFullAdmin);
        } else if (lmsg.equals("!botreload") || lmsg.equals("!reconnect")) {
            this.chatCommands.handleBotReload(msg, eventInfo, isFullAdmin, isAdmin, this.CONFIG_FILE_NAME, this.mysqlMode, this.instanceID, this.mysqlConnect);
        } else if (lmsg.equals("!botreloadall")) {
            this.chatCommands.handleBotReloadAll(msg, eventInfo, isFullAdmin);
        } else if (lmsg.equals("!botversion") || lmsg.equals("!botversioncheck") || lmsg.equals("!version")) {
            this.chatCommands.handleBotVersionCheck(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.equals("!botfunctionlist") || lmsg.equals("!functionlist")) {
            this.chatCommands.handleBotFunctionList(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!botfunctioninfo") || lmsg.startsWith("!functioninfo")) {
            this.chatCommands.handleBotFunctionInfo(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!botfunctionactivate") || lmsg.startsWith("!functionon")) {
            this.chatCommands.handleBotFunctionActivate(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!botfunctiondisable") || lmsg.startsWith("!functionoff")) {
            this.chatCommands.handleBotFunctionDisable(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!botcfgreload")) {
            this.chatCommands.handleBotCfgReload(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!botcfghelp")) {
            this.chatCommands.handleBotCfgHelp(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!botcfgget")) {
            this.chatCommands.handleBotCfgGet(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!botcfgset")) {
            this.chatCommands.handleBotCfgSet(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.equals("!botcfgcheck")) {
            this.chatCommands.handleBotCfgCheck(msg, eventInfo, isFullAdmin, isAdmin, this.CONFIG_FILE_NAME);
        } else if (lmsg.equals("!botcfgsave")) {
            this.chatCommands.handleBotCfgSave(msg, eventInfo, isFullAdmin, isAdmin, this.CONFIG_FILE_NAME, this.mysqlMode);
        } else if (lmsg.startsWith("!clientsearch") || lmsg.startsWith("!clients") || lmsg.startsWith("!clientlist") || lmsg.startsWith("!searchclient")) {
            this.chatCommands.handleSearchClient(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!searchip")) {
            this.chatCommands.handleSearchIP(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!searchdesc")) {
            this.chatCommands.handleSearchDescription(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!listinactiveclients") || lmsg.startsWith("!inactiveclients")) {
            this.chatCommands.handleListInactiveClients(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!listinactivechannels") || lmsg.startsWith("!emptychannels")) {
            this.chatCommands.handleListInactiveChannels(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!setchannelgroup")) {
            this.chatCommands.handleSetChannelGroup(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!removeservergroups")) {
            this.chatCommands.handleRemoveServerGroups(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!removechannelgroups")) {
            this.chatCommands.handleRemoveChannelGroups(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!listservergroups")) {
            this.chatCommands.handleListServerGroups(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!listchannelgroups")) {
            this.chatCommands.handleListChannelGroups(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!msgchannelgroup")) {
            this.chatCommands.handleMsgChannelGroup(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!msgservergroup")) {
            this.chatCommands.handleMsgServerGroup(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!msgall")) {
            this.chatCommands.handleMsgAll(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!pokechannelgroup")) {
            this.chatCommands.handlePokeChannelGroup(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!pokeservergroup")) {
            this.chatCommands.handlePokeServerGroup(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!pokeall")) {
            this.chatCommands.handlePokeAll(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!botjoinchannel") || lmsg.startsWith("!joinchannel") || lmsg.startsWith("!botchannel")) {
            this.chatCommands.handleBotJoinChannel(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!botrename")) {
            this.chatCommands.handleBotRename(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!setchannelname") || lmsg.startsWith("!renamechannel")) {
            this.chatCommands.handleSetChannelName(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!getchannelid") || lmsg.startsWith("!channellist")) {
            this.chatCommands.handleGetChannelID(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!exec")) {
            this.chatCommands.handleExec(msg, eventInfo, isFullAdmin);
        } else if (lmsg.equals("!botconfirmerrors") || lmsg.equals("!confirmerrors")) {
            this.chatCommands.handleBotConfirmErrors(msg, eventInfo, isFullAdmin, isAdmin);
        } else if (lmsg.equals("!botinfo") || lmsg.equals("!info")) {
            this.chatCommands.handleBotInfo(msg, eventInfo, this.startTime, isFullAdmin, isAdmin);
        } else if (lmsg.equals("!botlog")) {
            this.chatCommands.handleBotLog(msg, eventInfo, this.logFilePath, isFullAdmin, isAdmin);
        } else if (lmsg.startsWith("!bothelp ") || lmsg.equals("!bothelp") || lmsg.startsWith("!h ") || lmsg.equals("!h")) {
            this.chatCommands.handleBotHelp(msg, eventInfo, isFullAdmin, isAdmin);
        } else {
            boolean success = false;
            String sPrefix = null;
            int i = 0;
            while (i < this.functionList_Class.size()) {
                if (this.functionList_Enabled.elementAt(i).booleanValue() && HandleTS3Events.class.isAssignableFrom(this.functionList_Class.elementAt(i).getClass()) && (lmsg.startsWith(String.valueOf(sPrefix = "!" + this.functionList_Prefix.elementAt(i).toLowerCase()) + " ") || lmsg.equals(sPrefix))) {
                    this.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
                    try {
                        success = ((HandleTS3Events)((Object)this.functionList_Class.elementAt(i))).handleChatCommands(msg.length() > sPrefix.length() ? msg.substring(sPrefix.length() + 1) : "", eventInfo, isFullAdmin, isAdmin);
                    }
                    catch (Exception e) {
                        this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Error in handleChatCommands(" + (msg.length() > sPrefix.length() ? msg.substring(sPrefix.length() + 1) : "") + ")!", false);
                        this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                    }
                    break;
                }
                ++i;
            }
            try {
                if (eventInfo.get("targetmode").equals("1") && !success) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "No such command: [b]" + msg + "[/b]");
                }
            }
            catch (Exception e) {
                this.addLogEntry((byte)3, "Unable to send a \"No such command\" chat message to client " + eventInfo.get("invokername") + " (id: " + eventInfo.get("invokerid") + ")!", false);
                this.addLogEntry(e, false);
            }
        }
    }

    private void handleCSVLog(HashMap<String, String> eventInfo) {
        if (this.CSVLOGGER_FILE == null) {
            return;
        }
        if (this.CSVLOGGER_FILE.equals("sql")) {
            if (this.logFilePath.equals("sql")) {
                this.logger.addLogEntry(this.instanceID, null, (byte)66, String.valueOf(eventInfo.get("client_unique_identifier")) + ";" + (eventInfo.get("connection_client_ip") != null ? eventInfo.get("connection_client_ip") : "***") + ";" + eventInfo.get("client_nickname"), false);
            }
            return;
        }
        try {
            if (this.csvLogFile == null) {
                this.csvLogFile = new PrintStream((OutputStream)new FileOutputStream(this.CSVLOGGER_FILE, true), false, "UTF-8");
            }
            this.csvLogFile.print(this.logger.getSDFDebug().format(new Date(System.currentTimeMillis())));
            this.csvLogFile.print(";");
            this.csvLogFile.print(eventInfo.get("client_unique_identifier"));
            this.csvLogFile.print(";");
            this.csvLogFile.print(eventInfo.get("connection_client_ip") != null ? eventInfo.get("connection_client_ip") : "***");
            this.csvLogFile.print(";");
            this.csvLogFile.println(eventInfo.get("client_nickname"));
            this.csvLogFile.flush();
        }
        catch (Exception e) {
            this.addLogEntry((byte)3, "Unable to save connecting client to csv file: " + this.CSVLOGGER_FILE, false);
            this.addLogEntry(e, false);
        }
    }

    private void handleExceptionCheck(HashMap<String, String> eventInfo) {
        if (this.exceptionCounter < 1) {
            return;
        }
        boolean isFullBotAdmin = this.isUIDListed(this.manager.getFullBotAdminList(), eventInfo.get("client_unique_identifier"));
        boolean isBotAdmin = this.isUIDListed(this.ADMIN_UID_LIST, eventInfo.get("client_unique_identifier"));
        if (isFullBotAdmin || isBotAdmin) {
            String sLogFilePath = "";
            if (this.logFilePath != null && !this.logFilePath.equals("sql")) {
                sLogFilePath = " Please check the log file of this bot at " + this.logFilePath + " to solve this issues!";
            } else if (this.logFilePath != null && this.logFilePath.equals("sql")) {
                sLogFilePath = " Please check the log of this bot at the web interface to solve this issues!";
            } else if (this.logFilePath == null) {
                sLogFilePath = " Please check the output on the console of this bot to solve this issues!";
            }
            try {
                this.queryLib.pokeClient(Integer.parseInt(eventInfo.get("clid")), "Since last bot start " + Integer.toString(this.exceptionCounterCache) + " exception " + (this.exceptionCounterCache == 1 ? "error" : "errors") + " occured. Please read the chat message to know more!");
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("clid")), 1, "Important: Already [b]" + Integer.toString(this.exceptionCounterCache) + " exception " + (this.exceptionCounterCache == 1 ? "error" : "errors") + "[/b] occured since last bot start [b]" + this.getDifferenceTime(this.startTime, System.currentTimeMillis()) + "[/b] ago." + sLogFilePath + " You can confirm this message by answering with: [b]!botconfirmerrors[/b]");
            }
            catch (Exception e) {
                this.addLogEntry((byte)3, "Unable to send the exception error poke and chat message to client " + eventInfo.get("client_nickname") + " (id: " + eventInfo.get("clid") + ")!", false);
                this.addLogEntry(e, false);
            }
        }
    }

    void resetExceptionCounter() {
        this.exceptionCounter = 0;
    }

    private void handleUpdateCheck(HashMap<String, String> eventInfo) {
        if (this.botUpdateCheck != 1 && this.botUpdateCheck != 2) {
            return;
        }
        boolean isFullAdmin = this.isUIDListed(this.manager.getFullBotAdminList(), eventInfo.get("client_unique_identifier"));
        if (!isFullAdmin) {
            return;
        }
        StringBuffer versionInfo = new StringBuffer();
        try {
            HashMap<String, String> versionData = JTS3ServerMod.getVersionCheckData();
            if (versionData != null) {
                long finalBuild;
                long devBuild = versionData.get("dev.build") == null ? 0L : Long.parseLong(versionData.get("dev.build"));
                long l = finalBuild = versionData.get("final.build") == null ? 0L : Long.parseLong(versionData.get("final.build"));
                if (6509L < finalBuild && versionData.get("final.version") != null && versionData.get("final.url") != null) {
                    versionInfo.append("\n[b]Latest stable version:[/b] " + versionData.get("final.version") + " [" + versionData.get("final.build") + "]" + " - [url=" + versionData.get("final.url") + "]Download[/url]");
                }
                if (this.botUpdateCheck == 2 && 6509L < devBuild && versionData.get("dev.version") != null && versionData.get("dev.url") != null) {
                    versionInfo.append("\n[b]Latest development version:[/b] " + versionData.get("dev.version") + " [" + versionData.get("dev.build") + "]" + " - [url=" + versionData.get("dev.url") + "]Download[/url]");
                }
            } else {
                this.addLogEntry((byte)3, "Unable to request the current JTS3ServerMod version from https://www.stefan1200.de for the client " + eventInfo.get("client_nickname") + " (id: " + eventInfo.get("clid") + ")!", false);
            }
        }
        catch (Exception e) {
            this.addLogEntry((byte)3, "Unable to request the current JTS3ServerMod version from https://www.stefan1200.de and create the update check chat message for the client " + eventInfo.get("client_nickname") + " (id: " + eventInfo.get("clid") + ")!", false);
            this.addLogEntry(e, false);
        }
        if (versionInfo.length() > 0) {
            try {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("clid")), 1, "New JTS3ServerMod version is available!\n[b]Current installed version:[/b] 6.5.8 Hosting Edition (16.12.2023) [6509]" + versionInfo.toString());
            }
            catch (Exception e) {
                this.addLogEntry((byte)3, "Unable to send the update check chat message to client " + eventInfo.get("client_nickname") + " (id: " + eventInfo.get("clid") + ")!", false);
                this.addLogEntry(e, false);
            }
        }
    }

    @Override
    public String getVersionString(String version) {
        String searchString = " [Build: ";
        int pos1 = version.indexOf(searchString);
        int pos2 = version.indexOf("]", pos1 + searchString.length());
        try {
            long lTime = Long.parseLong(version.substring(pos1 + searchString.length(), pos2)) * 1000L;
            return String.valueOf(version.substring(0, pos1)) + " (" + this.sdf.format(new Date(lTime)) + ")";
        }
        catch (Exception e) {
            return version;
        }
    }

    @Override
    public String getFileSizeString(long size, boolean base1000) {
        String retValue;
        int base = base1000 ? 1000 : 1024;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(1);
        nf.setMaximumFractionDigits(2);
        if (size > (long)(base * base * base)) {
            double value = (double)size / (double)base / (double)base / (double)base;
            retValue = String.valueOf(nf.format(value)) + " " + (base1000 ? "GB" : "GiB");
        } else if (size > (long)(base * base)) {
            double value = (double)size / (double)base / (double)base;
            retValue = String.valueOf(nf.format(value)) + " " + (base1000 ? "MB" : "MiB");
        } else if (size > (long)base) {
            double value = (double)size / (double)base;
            retValue = String.valueOf(nf.format(value)) + " " + (base1000 ? "kB" : "KiB");
        } else {
            retValue = String.valueOf(size) + " byte";
        }
        return retValue;
    }

    @Override
    public void teamspeakActionPerformed(String eventType, HashMap<String, String> eventInfo) {
        block19: {
            try {
                if (eventType.equals("notifytextmessage")) {
                    this.handleChatMessage(eventInfo);
                    break block19;
                }
                if (eventType.equals("notifyclientleftview") && this.clientCache != null && this.clientCache.isCacheLocal()) {
                    Vector<HashMap<String, String>> clientListCache = this.clientList;
                    for (HashMap<String, String> clientInfo : clientListCache) {
                        if (!clientInfo.get("clid").equals(eventInfo.get("clid")) || Integer.parseInt(clientInfo.get("client_type")) != 0) continue;
                        this.clientCache.updateSingleClient(clientInfo);
                        break;
                    }
                }
                if (eventType.equals("notifycliententerview") && Integer.parseInt(eventInfo.get("client_type")) == 0) {
                    try {
                        HashMap<String, String> clientInfo = this.queryLib.getInfo(13, Integer.parseInt(eventInfo.get("clid")));
                        eventInfo.putAll(clientInfo);
                    }
                    catch (TS3ServerQueryException sqe) {
                        this.addLogEntry((byte)2, "Error while requesting information of the client \"" + eventInfo.get("client_nickname") + "\" (id: " + eventInfo.get("clid") + ") from the TS3 server!", false);
                        if (sqe.getFailedPermissionID() < 0) {
                            this.addLogEntry((byte)2, sqe.toString(), false);
                        } else {
                            this.addLogEntry(sqe, false);
                        }
                    }
                    catch (Exception e) {
                        this.addLogEntry((byte)3, "Error while requesting information of the client \"" + eventInfo.get("client_nickname") + "\" (id: " + eventInfo.get("clid") + ") from the TS3 server!", false);
                        this.addLogEntry(e, false);
                    }
                    this.handleCSVLog(eventInfo);
                    if (this.clientCache != null) {
                        this.clientCache.updateSingleClient(eventInfo);
                    }
                    this.handleUpdateCheck(eventInfo);
                    this.handleExceptionCheck(eventInfo);
                }
                int i = 0;
                while (i < this.functionList_Class.size()) {
                    if (this.functionList_Enabled.elementAt(i).booleanValue()) {
                        if (this.functionList_Class.elementAt(i) == null) {
                            this.addLogEntry((byte)3, "Function " + this.functionList_Prefix.elementAt(i) + " is enabled, but class is not loaded! Please report this to info@stefan1200.de", true);
                        } else if (HandleTS3Events.class.isAssignableFrom(this.functionList_Class.elementAt(i).getClass())) {
                            try {
                                ((HandleTS3Events)((Object)this.functionList_Class.elementAt(i))).handleTS3Events(eventType, eventInfo);
                            }
                            catch (Exception e) {
                                this.addLogEntry(this.functionList_Prefix.elementAt(i), (byte)3, "Exception in handleTS3Events()!", true);
                                this.addLogEntry(this.functionList_Prefix.elementAt(i), e, false);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                this.addLogEntry((byte)3, "Throwable in teamspeakActionPerformed(): " + t.toString(), false);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void runCheck() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getDifferenceTime(long from, long to) {
        long difference = to - from;
        int days = (int)(difference / 86400000L);
        int hours = (int)(difference / 3600000L % 24L);
        int minutes = (int)(difference / 60000L % 60L);
        int seconds = (int)(difference / 1000L % 60L);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(2);
        nf.setMaximumIntegerDigits(2);
        StringBuffer timeString = new StringBuffer();
        if (days > 0) {
            timeString.append(days);
            timeString.append(" days and ");
        }
        if (days > 0 || hours > 0) {
            timeString.append(hours);
            timeString.append(":");
            timeString.append(nf.format(minutes));
            timeString.append(":");
            timeString.append(nf.format(seconds));
            timeString.append(" hours");
        } else if (minutes > 0) {
            timeString.append(minutes);
            timeString.append(":");
            timeString.append(nf.format(seconds));
            timeString.append(" minutes");
        } else {
            timeString.append(seconds);
            timeString.append(" seconds");
        }
        return timeString.toString();
    }

    void addLogEntry(byte type, String msg, boolean outputToSystemOut) {
        this.addLogEntry(null, type, msg, outputToSystemOut);
    }

    @Override
    public void addLogEntry(String functionName, byte type, String msg, boolean outputToSystemOut) {
        if (this.noLogEntry) {
            return;
        }
        if (this.getMySQLConnection() != null) {
            outputToSystemOut = false;
        }
        if (this.logger != null) {
            this.logger.addLogEntry(this.instanceID, functionName, type, msg, outputToSystemOut);
        }
    }

    void addLogEntry(Throwable e, boolean outputToSystemOut) {
        this.addLogEntry(null, e, outputToSystemOut);
    }

    @Override
    public void addLogEntry(String functionName, Throwable e, boolean outputToSystemOut) {
        if (this.noLogEntry) {
            return;
        }
        ++this.exceptionCounter;
        ++this.exceptionCounterCache;
        if (this.getMySQLConnection() != null) {
            outputToSystemOut = false;
        }
        if (this.logger != null) {
            this.logger.addLogEntry(this.instanceID, functionName, e, outputToSystemOut, this);
        }
    }

    @Override
    public int getClientDBID(String uniqueID) {
        HashMap<String, String> response;
        block5: {
            if (uniqueID == null || uniqueID.length() < 25) {
                return -1;
            }
            if (this.clientCache != null) {
                return this.clientCache.getDatabaseID(uniqueID);
            }
            try {
                response = this.queryLib.doCommand("clientgetdbidfromuid cluid=" + uniqueID);
                if (response.get("id").equals("0")) break block5;
                return -1;
            }
            catch (Exception e) {
                return -1;
            }
        }
        response = this.queryLib.parseLine(response.get("response"));
        return Integer.parseInt(response.get("cldbid"));
    }

    static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

