/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod;

import de.stefan1200.jts3servermod.InstanceManager;
import de.stefan1200.jts3servermod.InstanceManagerRemoteClient;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class InstanceManagerServer
extends Thread {
    private ServerSocket serv;
    private InstanceManager botManager;
    private int port = 5873;
    private String adminPW = null;
    private String bindTo = null;
    private Vector<String> telnetWhitelist = null;
    private Vector<String> telnetBlacklist = new Vector();
    private Timer botTelnetServerTimer = null;
    private TimerTask timerDeleteBlacklist = null;
    private Vector<InstanceManagerRemoteClient> clientList = new Vector();

    InstanceManagerServer(InstanceManager botManager, int port, String adminPW, Vector<String> telnetWhitelist, String bindTo) {
        this.botManager = botManager;
        this.adminPW = adminPW;
        this.telnetWhitelist = telnetWhitelist;
        this.bindTo = bindTo;
        if (port > 0) {
            this.port = port;
        }
    }

    private void closeAllConnections() {
        for (InstanceManagerRemoteClient client : this.clientList) {
            client.closeConnection();
        }
    }

    private void checkConnections() {
        try {
            for (InstanceManagerRemoteClient client : this.clientList) {
                if (client.isAlive() && client.isOnline()) continue;
                client.closeConnection();
                this.delConnection(client, null);
            }
        }
        catch (Exception e) {
            this.botManager.addLogEntry(e);
        }
    }

    void addToBlacklist(String ip) {
        if (this.telnetBlacklist.indexOf(ip) == -1 && this.telnetWhitelist.size() == 0) {
            this.telnetBlacklist.addElement(ip);
        }
    }

    void delConnection(InstanceManagerRemoteClient client, String ipAddress) {
        if (this.botManager.isTelnetConnectionLog() && ipAddress != null) {
            this.botManager.addLogEntry("TELNET_CONNECTION", "Closed telnet connection to " + ipAddress + "...", false);
        }
        this.clientList.removeElement(client);
    }

    @Override
    public void run() {
        block20: {
            if (this.adminPW == null || this.adminPW.length() < 6) {
                this.botManager.addLogEntry("TELNET_ERROR", "Query password missing or to short (less than 6 characters)! Query Interface disabled.", true);
                return;
            }
            try {
                if (this.telnetWhitelist.size() == 0) {
                    this.timerDeleteBlacklist = new TimerTask(){

                        @Override
                        public void run() {
                            InstanceManagerServer.this.telnetBlacklist.clear();
                        }
                    };
                    this.botTelnetServerTimer = new Timer(true);
                    this.botTelnetServerTimer.schedule(this.timerDeleteBlacklist, 1800000L, 1800000L);
                }
                InetAddress addr = null;
                if (this.bindTo != null) {
                    try {
                        addr = InetAddress.getByName(this.bindTo);
                    }
                    catch (UnknownHostException e) {
                        this.botManager.addLogEntry("TELNET_BINDTO", "Network interface " + this.bindTo + " not found! Bind to all network interfaces now.", true);
                        addr = null;
                        this.bindTo = null;
                    }
                }
                this.serv = new ServerSocket(this.port, -1, addr);
                this.serv.setSoTimeout(1000);
                this.botManager.addLogEntry("TELNET_START", "Query Interface started on port " + Integer.toString(this.port) + (addr != null ? ", bound to network interface " + this.bindTo : "") + "!", true);
                while (true) {
                    try {
                        while (true) {
                            if (Thread.currentThread().isInterrupted()) {
                                this.closeAllConnections();
                                break block20;
                            }
                            this.checkConnections();
                            Socket client = this.serv.accept();
                            String ipAddress = client.getInetAddress().getHostAddress();
                            if (this.telnetWhitelist.size() == 0 && this.telnetBlacklist.indexOf(ipAddress) != -1) {
                                this.botManager.addLogEntry("TELNET_CONNECTION", "Rejected telnet connection from " + ipAddress + " (blacklisted)...", false);
                                try {
                                    client.close();
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            if (this.telnetWhitelist.size() == 0 || this.telnetWhitelist.size() != 0 && this.telnetWhitelist.indexOf(ipAddress) != -1) {
                                if (this.botManager.isTelnetConnectionLog()) {
                                    this.botManager.addLogEntry("TELNET_CONNECTION", "Accepted telnet connection from " + ipAddress + "...", false);
                                }
                                InstanceManagerRemoteClient c = new InstanceManagerRemoteClient(this.botManager, this, client, this.adminPW);
                                this.clientList.addElement(c);
                                continue;
                            }
                            if (this.botManager.isTelnetConnectionLog()) {
                                this.botManager.addLogEntry("TELNET_CONNECTION", "Rejected telnet connection from " + ipAddress + "...", false);
                            }
                            try {
                                client.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.botManager.addLogEntry("TELNET_ERROR", "Error while starting Query Interface on port " + Integer.toString(this.port) + "!", true);
                this.botManager.addLogEntry(e);
            }
        }
    }
}

