/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod;

import de.stefan1200.jts3servermod.InstanceManager;
import de.stefan1200.jts3servermod.InstanceManagerServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;

class InstanceManagerRemoteClient
extends Thread {
    private final String LINE_BREAK = "\r\n";
    private InstanceManager botManager;
    private InstanceManagerServer botManagerServer;
    private Socket socket;
    private BufferedReader in = null;
    private PrintStream out = null;
    private String adminPW = null;
    private String ipAddress = null;

    InstanceManagerRemoteClient(InstanceManager botManager, InstanceManagerServer botManagerServer, Socket socket, String adminPW) {
        this.botManager = botManager;
        this.botManagerServer = botManagerServer;
        this.socket = socket;
        this.adminPW = adminPW;
        try {
            this.socket.setSoTimeout(600000);
            this.ipAddress = this.socket.getInetAddress().getHostAddress();
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
            this.out = new PrintStream(this.socket.getOutputStream(), true, "UTF-8");
            this.out.print("JTS3ServerMod\r\n");
        }
        catch (IOException e) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        this.start();
    }

    boolean isOnline() {
        if (this.socket == null) {
            return false;
        }
        return this.socket.isConnected();
    }

    void closeConnection() {
        this.interrupt();
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        admin = false;
        loginCount = 0;
        try {
            while ((line = this.in.readLine()) != null && !this.isInterrupted()) {
                if (line.length() > 100) {
                    this.out.print("STATUS ERROR too long string, you are now banned...\r\n");
                    this.botManagerServer.addToBlacklist(this.ipAddress);
                    break;
                }
                if (line.toLowerCase().startsWith("login ")) {
                    ++loginCount;
                    if (line.substring(6).equals(this.adminPW)) {
                        admin = true;
                        this.out.print("STATUS OK\r\n");
                        continue;
                    }
                    admin = false;
                    if (loginCount >= 3) {
                        this.out.print("STATUS ERROR too much tries, you are now banned...\r\n");
                        this.botManager.addLogEntry("TELNET_LOGIN", "Wrong telnet password from " + this.ipAddress + ", now banned!", false);
                        this.botManagerServer.addToBlacklist(this.ipAddress);
                        break;
                    }
                    this.out.print("STATUS ERROR wrong pw\r\n");
                    this.botManager.addLogEntry("TELNET_LOGIN", "Wrong telnet password from " + this.ipAddress + "!", false);
                    continue;
                }
                if (line.equalsIgnoreCase("instancerunningcount")) {
                    this.out.print(String.valueOf(Integer.toString(this.botManager.getInstancesRunningCount())) + "\r\n");
                    this.out.print("STATUS OK\r\n");
                    continue;
                }
                if (line.toLowerCase().startsWith("status ")) {
                    this.out.print(String.valueOf(Integer.toString(this.botManager.isInstanceRunning(line.substring(7).trim()))) + "\r\n");
                    this.out.print("STATUS OK\r\n");
                    continue;
                }
                if (line.toLowerCase().startsWith("statusall")) {
                    this.out.print(String.valueOf(this.botManager.getAllInstanceStatusString()) + "\r\n");
                    this.out.print("STATUS OK\r\n");
                    continue;
                }
                if (line.equalsIgnoreCase("instancelistreload")) {
                    if (admin) {
                        if (this.botManager.loadConfig()) {
                            this.out.print("STATUS OK\r\n");
                            continue;
                        }
                        this.out.print("STATUS ERROR\r\n");
                        continue;
                    }
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
                }
                if (line.toLowerCase().startsWith("start ")) {
                    if (admin) {
                        if (this.botManager.startInstance(line.substring(6).trim(), this.ipAddress)) {
                            this.out.print("STATUS OK\r\n");
                            continue;
                        }
                        this.out.print("STATUS ERROR\r\n");
                        continue;
                    }
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
                }
                if (line.toLowerCase().startsWith("reload ")) {
                    if (admin) {
                        if (this.botManager.reloadInstance(line.substring(7).trim(), this.ipAddress)) {
                            this.out.print("STATUS OK\r\n");
                            continue;
                        }
                        this.out.print("STATUS ERROR\r\n");
                        continue;
                    }
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
                }
                if (line.toLowerCase().startsWith("reloadconfig ")) {
                    if (admin) {
                        result = this.botManager.reloadInstanceConfig(line.substring(13).trim(), this.ipAddress);
                        if (result >= 0) {
                            this.out.print("STATUS OK reloaded " + Integer.toString(result) + " functions successfully" + "\r\n");
                            continue;
                        }
                        if (result == -10) {
                            this.out.print("STATUS ERROR bot name missing\r\n");
                            continue;
                        }
                        if (result == -9) {
                            this.out.print("STATUS ERROR bot name not found\r\n");
                            continue;
                        }
                        if (result == -8) {
                            this.out.print("STATUS ERROR bot name is flood protected, try again later\r\n");
                            continue;
                        }
                        if (result == -1) {
                            this.out.print("STATUS ERROR bot configuration could not be reloaded\r\n");
                            continue;
                        }
                        this.out.print("STATUS ERROR\r\n");
                        continue;
                    }
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
                }
                if (line.toLowerCase().startsWith("activatefunction ")) {
                    if (admin) {
                        pos = line.indexOf(" ") + 1;
                        if (pos == 0) {
                            this.out.print("STATUS ERROR needed arguments not given! Bot name and function prefix needed.\r\n");
                            continue;
                        }
                        pos1 = line.indexOf(" ", pos);
                        if (pos1 == -1) {
                            this.out.print("STATUS ERROR needed arguments not given! Bot name and function prefix needed.\r\n");
                            continue;
                        }
                        result = this.botManager.activateBotFunction(line.substring(pos, pos1), line.substring(pos1 + 1));
                        if (result == 1) {
                            this.out.print("STATUS OK activated function " + line.substring(pos1 + 1) + " successfully" + "\r\n");
                            continue;
                        }
                        if (result == -10) {
                            this.out.print("STATUS ERROR bot name missing\r\n");
                            continue;
                        }
                        if (result == -9) {
                            this.out.print("STATUS ERROR bot name not found\r\n");
                            continue;
                        }
                        if (result == -8) {
                            this.out.print("STATUS ERROR bot name is flood protected, try again later\r\n");
                            continue;
                        }
                        if (result == -1) {
                            this.out.print("STATUS ERROR function prefix not found!\r\n");
                            continue;
                        }
                        if (result == 0) {
                            this.out.print("STATUS ERROR function is already activated!\r\n");
                            continue;
                        }
                        this.out.print("STATUS ERROR\r\n");
                        continue;
                    }
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
                }
                if (line.toLowerCase().startsWith("disablefunction ")) {
                    if (admin) {
                        pos = line.indexOf(" ") + 1;
                        if (pos == 0) {
                            this.out.print("STATUS ERROR needed arguments not given! Bot name and function prefix needed.\r\n");
                            continue;
                        }
                        pos1 = line.indexOf(" ", pos);
                        if (pos1 == -1) {
                            this.out.print("STATUS ERROR needed arguments not given! Bot name and function prefix needed.\r\n");
                            continue;
                        }
                        result = this.botManager.disableBotFunction(line.substring(pos, pos1), line.substring(pos1 + 1));
                        if (result == 1) {
                            this.out.print("STATUS OK disabled function " + line.substring(pos1 + 1) + " successfully" + "\r\n");
                            continue;
                        }
                        if (result == -10) {
                            this.out.print("STATUS ERROR bot name missing\r\n");
                            continue;
                        }
                        if (result == -9) {
                            this.out.print("STATUS ERROR bot name not found\r\n");
                            continue;
                        }
                        if (result == -8) {
                            this.out.print("STATUS ERROR bot name is flood protected, try again later\r\n");
                            continue;
                        }
                        if (result == -1) {
                            this.out.print("STATUS ERROR function prefix not found!\r\n");
                            continue;
                        }
                        if (result == 0) {
                            this.out.print("STATUS ERROR function is already disabled!\r\n");
                            continue;
                        }
                        this.out.print("STATUS ERROR\r\n");
                        continue;
                    }
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
                }
                if (line.toLowerCase().startsWith("stop ")) {
                    if (admin) {
                        if (this.botManager.stopInstance(line.substring(5).trim(), this.ipAddress)) {
                            this.out.print("STATUS OK\r\n");
                            continue;
                        }
                        this.out.print("STATUS ERROR\r\n");
                        continue;
                    }
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
                }
                if (line.toLowerCase().startsWith("rename ")) {
                    if (admin) {
                        pos = 7;
                        pos2 = line.indexOf(";", 7);
                        if (this.botManager.renameInstance(line.substring(pos, pos2).trim(), line.substring(pos2 + 1).trim())) {
                            this.out.print("STATUS OK\r\n");
                            continue;
                        }
                        this.out.print("STATUS ERROR\r\n");
                        continue;
                    }
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
                }
                if (line.equalsIgnoreCase("reloadallinstances")) {
                    if (admin) {
                        this.botManager.reloadAllInstances();
                        this.out.print("STATUS OK\r\n");
                        continue;
                    }
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
                }
                if (line.equalsIgnoreCase("instancelist")) {
                    if (admin) {
                        namesList = this.botManager.getInstanceNames();
                        for (String string : namesList) {
                            this.out.print(String.valueOf(string) + "\r\n");
                        }
                        this.out.print("STATUS OK\r\n");
                        continue;
                    }
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
                }
                if (line.equalsIgnoreCase("reconnectmysqllogger")) {
                    if (admin) {
                        this.botManager.reconnectMySQLLogger();
                        this.out.print("STATUS OK\r\n");
                        continue;
                    }
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
                }
                if (!line.equalsIgnoreCase("botquit")) ** GOTO lbl202
                if (admin) {
                    this.out.print("STATUS OK\r\n");
                    this.botManager.stopAllInstances(true);
                } else {
                    this.out.print("STATUS ERROR login first\r\n");
                    continue;
lbl202:
                    // 1 sources

                    if (!line.equalsIgnoreCase("quit")) {
                        if (line.equalsIgnoreCase("help")) {
                            this.out.print("activatefunction <botname> <prefix>\tActivate the given bot function!\r\n");
                            this.out.print("botquit\t\t\tStops the whole bot process!\r\n");
                            this.out.print("disablefunction <botname> <prefix>\tDisable the given bot function!\r\n");
                            this.out.print("login <password>\tLogin as fulladmin with the given telnet password!\r\n");
                            this.out.print("instancerunningcount\tShows a number of running virtual bot instances!\r\n");
                            this.out.print("instancelistreload\tReloads the instance list!\r\n");
                            this.out.print("instancelist\t\tShows a list of virtual bot instances!\r\n");
                            this.out.print("reconnectmysqllogger\tReconnects the logger to the MySQL server!\r\n");
                            this.out.print("reload <instance name>\tReload the given virtual bot instance!\r\n");
                            this.out.print("reloadconfig <instance name>\tReload config of the given virtual bot instance!\r\n");
                            this.out.print("reloadallinstances\tReloads all virtual bot instances!\r\n");
                            this.out.print("rename <old name>;<new name>\tRename the given virtual bot instance name!\r\n");
                            this.out.print("start <instance name>\tStart the given virtual bot instance!\r\n");
                            this.out.print("status <instance name>\tShow status of a virtual bot instance! 1 = on, 0 = off, -1 = n/a\r\n");
                            this.out.print("statusall\tShow status of all virtual bot instances! 1 = on, 0 = off\r\n");
                            this.out.print("stop <instance name>\tStops the given virtual bot instance!\r\n");
                            this.out.print("quit\t\t\tQuits the current telnet connection!\r\n");
                            this.out.print("STATUS OK\r\n");
                            continue;
                        }
                        this.out.print("STATUS ERROR unknown command\r\n");
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            this.botManager.addLogEntry(e);
        }
        this.botManagerServer.delConnection(this, this.ipAddress);
        this.closeConnection();
    }
}

