/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod;

import de.stefan1200.jts3servermod.ChannelEmptyComparator;
import de.stefan1200.jts3servermod.InstanceManager;
import de.stefan1200.jts3servermod.JTS3ServerMod;
import de.stefan1200.jts3servermod.interfaces.ClientDatabaseCache_Interface;
import de.stefan1200.jts3servermod.interfaces.ServerInfoCache_Interface;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import de.stefan1200.util.MySQLConnect;
import java.io.BufferedInputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ChatCommands {
    ArrangedPropertiesWriter config;
    JTS3ServerMod modClass;
    JTS3ServerQuery queryLib;
    ClientDatabaseCache_Interface clientCache;
    InstanceManager manager;
    SimpleDateFormat sdf;

    ChatCommands(JTS3ServerQuery queryLib, JTS3ServerMod modClass, ClientDatabaseCache_Interface clientCache, SimpleDateFormat sdf, ArrangedPropertiesWriter config, InstanceManager manager) {
        this.queryLib = queryLib;
        this.modClass = modClass;
        this.clientCache = clientCache;
        this.sdf = sdf;
        this.config = config;
        this.manager = manager;
    }

    void handleBotQuit(String msg, HashMap<String, String> eventInfo, String instanceName, boolean isFullAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        if (isFullAdmin) {
            try {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Bye Bye, my master! Stopping all instances...");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
            this.manager.stopAllInstances(true, "COMMAND", "Got !botquit command from " + eventInfo.get("invokername") + " (UID: " + eventInfo.get("invokeruid") + ") on virtual bot instance " + instanceName);
        } else {
            try {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master! You have to be full bot admin to use this command.");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleBotReload(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin, String CONFIG_FILE_NAME, boolean mysqlMode, int mysqlInstanceID, MySQLConnect mysqlConnect) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        if (isFullAdmin || isAdmin) {
            JTS3ServerMod configCheck = new JTS3ServerMod(CONFIG_FILE_NAME, mysqlMode, mysqlInstanceID, mysqlConnect);
            int configOK = configCheck.loadAndCheckConfig(true);
            if (configOK == 0) {
                try {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Config file OK, restarting now!");
                }
                catch (Exception e) {
                    this.modClass.addLogEntry(e, false);
                }
                this.modClass.stopBotInstance(2);
            } else {
                String errorMsg = configCheck.getErrorMessage(configOK);
                try {
                    if (errorMsg.length() > 954) {
                        errorMsg = String.valueOf(errorMsg.substring(0, 950)) + "\n[...]";
                    }
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Config checked and found following errors:\n" + errorMsg);
                }
                catch (Exception e) {
                    this.modClass.addLogEntry(e, false);
                }
            }
        } else {
            try {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleBotVersionCheck(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block11: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            try {
                if (isFullAdmin || isAdmin) {
                    StringBuffer versionInfo = new StringBuffer();
                    try {
                        HashMap<String, String> versionData = JTS3ServerMod.getVersionCheckData();
                        if (versionData != null) {
                            long finalBuild;
                            if (versionData.get("final.version") != null && versionData.get("final.url") != null) {
                                versionInfo.append("\n[b]Latest stable version:[/b] " + versionData.get("final.version") + " [" + versionData.get("final.build") + "]" + " - [url=" + versionData.get("final.url") + "]Download[/url]");
                            }
                            if (versionData.get("dev.version") != null && versionData.get("dev.url") != null) {
                                versionInfo.append("\n[b]Latest development version:[/b] " + versionData.get("dev.version") + " [" + versionData.get("dev.build") + "]" + " - [url=" + versionData.get("dev.url") + "]Download[/url]");
                            }
                            long devBuild = versionData.get("dev.build") == null ? 0L : Long.parseLong(versionData.get("dev.build"));
                            long l = finalBuild = versionData.get("final.build") == null ? 0L : Long.parseLong(versionData.get("final.build"));
                            if (6509L < finalBuild) {
                                versionInfo.append("\nNew stable version is available!");
                            }
                            if (6509L < devBuild) {
                                versionInfo.append("\nNew development version is available!");
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (versionInfo.length() == 0) {
                        versionInfo.append("\nUnable to request the current JTS3ServerMod version from https://www.stefan1200.de");
                    }
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "[b]Current installed version:[/b] 6.5.8 Hosting Edition (16.12.2023) [6509]" + versionInfo.toString());
                    break block11;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleBotFunctionList(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        try {
            if (isFullAdmin || isAdmin) {
                String[] funcList = this.modClass.getCurrentLoadedFunctions();
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, String.valueOf(funcList[0].length() == 0 ? "[b]No bot functions currently activated![/b]" : "[b]The following bot functions are activated:[/b]\n" + funcList[0]) + (funcList[1].length() == 0 ? "\n[b]No bot functions currently disabled![/b]" : "\n[b]The following bot functions are disabled:[/b]\n" + funcList[1]));
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotFunctionInfo(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin) {
                String copyright;
                String answermsg = "Unknown Error!";
                answermsg = arguments.length() == 0 ? "Wrong usage! Right: !botfunctionactivate <function prefix>" : ((copyright = this.modClass.getFunctionCopyright(arguments)) == null ? "Unable to get the information about the function \"" + arguments + "\", unknown name!" : copyright);
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, answermsg);
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotFunctionActivate(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin) {
                String answermsg = "Unknown Error!";
                if (arguments.length() == 0) {
                    answermsg = "Wrong usage! Right: !botfunctionactivate <function prefix>";
                } else {
                    byte result = this.modClass.activateFunction(arguments);
                    if (result == -1) {
                        answermsg = "Unable to activate function \"" + arguments + "\", unknown name!";
                    } else if (result == 0) {
                        answermsg = "Function \"" + arguments + "\" already activated!";
                    } else if (result == 1) {
                        answermsg = "Function \"" + arguments + "\" activated successfully! If wanted, save bot config with !botcfgsave to make change permanent.";
                    }
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, answermsg);
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotFunctionDisable(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin) {
                String answermsg = "Unknown Error!";
                if (arguments.length() == 0) {
                    answermsg = "Wrong usage! Right: !botfunctiondisable <function prefix>";
                } else {
                    byte result = this.modClass.disableFunction(arguments);
                    if (result == -1) {
                        answermsg = "Unable to disable function \"" + arguments + "\", unknown name!";
                    } else if (result == 0) {
                        answermsg = "Function \"" + arguments + "\" already disabled!";
                    } else if (result == 1) {
                        answermsg = "Function \"" + arguments + "\" disabled successfully! If wanted, save bot config with !botcfgsave to make change permanent.";
                    }
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, answermsg);
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotInfo(String msg, HashMap<String, String> eventInfo, long startTime, boolean isFullAdmin, boolean isAdmin) {
        String adminText = "You have no bot admin permissions!";
        if (isFullAdmin) {
            adminText = "You have all bot admin permissions!";
        } else if (isAdmin) {
            adminText = "You have limited bot admin permissions!";
        } else if (this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
            adminText = "You have no bot admin permissions, but you can use some admin commands!";
        }
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        try {
            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "On this server runs JTS3ServerMod 6.5.8 Hosting Edition (16.12.2023) since " + this.modClass.getDifferenceTime(startTime, System.currentTimeMillis()) + ".\nTry !bothelp for a list of commands! " + adminText + "\nYou like this bot? Consider a [url=http://www.stefan1200.de/forum/index.php?topic=189.0]donation[/url]!");
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotLog(String msg, HashMap<String, String> eventInfo, String logFilePath, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        try {
            if (isFullAdmin || isAdmin) {
                String sLogFilePath = "";
                if (logFilePath != null && !logFilePath.equals("sql")) {
                    sLogFilePath = "The log of this bot will be written to the log file of this bot at: " + logFilePath;
                } else if (logFilePath != null && logFilePath.equals("sql")) {
                    sLogFilePath = "The log of this bot will be written to the database of the web interface!";
                } else if (logFilePath == null) {
                    sLogFilePath = "The log of this bot will be written to the console of the JTS3ServerMod!";
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, sLogFilePath);
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master! You have to be bot admin to use this command.");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotConfirmErrors(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        try {
            if (isFullAdmin || isAdmin) {
                this.modClass.resetExceptionCounter();
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Exception error counter was set to 0. You will be notified again, if new exception errors occur.");
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master! You have to be bot admin to use this command.");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotInstanceStop(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, String instanceName) {
        block15: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            if (isFullAdmin) {
                if (arguments.length() == 0) {
                    try {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Bye Bye, my master! Stopping this instance...");
                    }
                    catch (Exception e) {
                        this.modClass.addLogEntry(e, false);
                    }
                    this.modClass.stopBotInstance(0);
                } else if (arguments.equalsIgnoreCase(instanceName)) {
                    try {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Bye Bye, my master! Stopping this instance...");
                    }
                    catch (Exception e) {
                        this.modClass.addLogEntry(e, false);
                    }
                    this.modClass.stopBotInstance(0);
                } else {
                    try {
                        if (this.manager.stopInstance(arguments, null)) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Instance [b]" + arguments + "[/b] stopped!");
                            break block15;
                        }
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Instance name [b]" + arguments + "[/b] not found or not running! Get a instance name list with !botinstancelist");
                    }
                    catch (Exception e) {
                        this.modClass.addLogEntry(e, false);
                    }
                }
            } else {
                try {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master! You have to be full bot admin to use this command.");
                }
                catch (Exception e) {
                    this.modClass.addLogEntry(e, false);
                }
            }
        }
    }

    void handleBotInstanceStart(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, String instanceName) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin) {
                if (arguments.length() == 0) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !botinstancestart <name>");
                } else if (arguments.equalsIgnoreCase(instanceName)) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Instance [b]" + arguments + "[/b] is already running!");
                } else if (this.manager.startInstance(arguments, null)) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Instance [b]" + arguments + "[/b] started!");
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Instance name [b]" + arguments + "[/b] not found, is already running or config file missing! Get a instance name list with !botinstancelist");
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master! You have to be full bot admin to use this command.");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotInstanceName(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, String instanceName) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        try {
            if (isFullAdmin) {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Current bot instance name: " + instanceName);
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master! You have to be full bot admin to use this command.");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotInstanceList(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        try {
            if (isFullAdmin) {
                String temp = null;
                StringBuffer instanceString = new StringBuffer("[b]List of instance names:[/b]");
                Vector<String> instanceNames = this.manager.getInstanceNames();
                Vector<String> messageList = new Vector<String>();
                for (String string : instanceNames) {
                    temp = String.valueOf(string) + " - ";
                    temp = this.manager.isInstanceRunning(string) == 1 ? String.valueOf(temp) + "Running" : String.valueOf(temp) + "Not Running";
                    if (this.modClass.getUTF8Length(String.valueOf(instanceString.toString()) + "\n" + temp) < 1024) {
                        instanceString.append("\n");
                        instanceString.append(temp);
                        continue;
                    }
                    messageList.addElement(instanceString.toString());
                    instanceString.setLength(0);
                    instanceString.append(temp);
                }
                messageList.addElement(instanceString.toString());
                instanceString = null;
                temp = null;
                int i = 0;
                while (i < messageList.size()) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, (String)messageList.elementAt(i));
                    ++i;
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master! You have to be full bot admin to use this command.");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotInstanceListReload(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        try {
            if (isFullAdmin) {
                if (this.manager.loadConfig()) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Succesfully reloaded the instance list!");
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while reloading the instance list!");
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master! You have to be full bot admin to use this command.");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotReloadAll(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        if (isFullAdmin) {
            try {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Restarting all instances!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
            this.manager.reloadAllInstances();
        } else {
            try {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleBotCfgReload(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin) {
                if (this.modClass.loadConfigValues()) {
                    if (arguments.length() > 1) {
                        int result = this.modClass.reloadConfig(arguments);
                        String msgTemp = result == 1 ? "Bot function \"" + arguments + "\" reloaded config successfully!" : (result == 0 ? "Error while reloading config of bot function \"" + arguments + "\"!" : "Bot function \"" + arguments + "\" not found!");
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, msgTemp);
                    } else {
                        int[] count = this.modClass.reloadConfig(false);
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "All bot functions reloaded config, successfull: " + Integer.toString(count[1]) + " / with error: " + Integer.toString(count[0]));
                    }
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Main bot config file could not be reloaded!");
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotCfgHelp(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin) {
                if (arguments.length() == 0) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "[b]List of config keys:[/b]\n");
                    StringBuffer keyString = new StringBuffer();
                    Vector<String> configKeys = this.config.getKeys();
                    int i = 0;
                    while (i < configKeys.size()) {
                        if (isFullAdmin || !configKeys.elementAt(i).toLowerCase().startsWith("ts3_")) {
                            if (keyString.length() != 0) {
                                keyString.append(", ");
                            }
                            keyString.append(configKeys.elementAt(i));
                            if (keyString.length() > 900) {
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, keyString.toString());
                                keyString = new StringBuffer();
                            }
                        }
                        ++i;
                    }
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, keyString.toString());
                } else {
                    String helpText = this.config.getHelpText(arguments);
                    if (helpText == null) {
                        StringBuffer keyString = new StringBuffer();
                        Vector<String> configKeys = this.config.getKeys();
                        int i = 0;
                        while (i < configKeys.size()) {
                            if (configKeys.elementAt(i).toLowerCase().startsWith(arguments.toLowerCase())) {
                                if (keyString.length() != 0) {
                                    keyString.append(", ");
                                }
                                keyString.append(configKeys.elementAt(i));
                            }
                            ++i;
                        }
                        if (keyString.length() > 0) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "[b]List of config keys starting with:[/b] " + arguments + "\n");
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, keyString.toString());
                        } else {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Key [b]" + arguments + "[/b] is not valid!");
                        }
                    } else {
                        if (helpText.length() > 1000 - arguments.length()) {
                            helpText = String.valueOf(helpText.substring(0, 997 - arguments.length())) + "...";
                        }
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "[b]Help of " + arguments + ":[/b]\n" + helpText);
                    }
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotCfgGet(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin) {
                if (arguments.length() == 0) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !botcfgget <key>");
                } else if (arguments.length() < 3) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !botcfgget <key>");
                } else if (!isFullAdmin && arguments.toLowerCase().startsWith("ts3_")) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Requesting value of key [b]" + arguments + "[/b] is not allowed!");
                } else {
                    String value = this.config.getValue(arguments);
                    if (value == null) {
                        if (this.config.getKeys().indexOf(arguments) == -1) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Key [b]" + arguments + "[/b] is not valid!");
                        } else {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "No value set for key [b]" + arguments + "[/b]!");
                        }
                    } else {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Value of [b]" + arguments + "[/b]:" + (value.length() > 10 ? "\n" : " ") + value);
                    }
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotCfgSet(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin) {
                if (arguments.length() == 0) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !botcfgset <key> = <value>");
                } else {
                    int pos = arguments.indexOf("=");
                    if (arguments.length() < 3 || pos == -1) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !botcfgset <key> = <value>");
                    } else {
                        String key = arguments.substring(0, pos).trim();
                        String value = arguments.substring(pos + 1).trim();
                        if (!this.config.canSaveToFile(key)) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Setting value for key [b]" + key + "[/b] is not possible, because it's write protected! Please change it directly at the file and use !botcfgreload to reload this values without restarting the bot.");
                            return;
                        }
                        if (!isFullAdmin && key.toLowerCase().startsWith("ts3_")) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Setting value for key [b]" + key + "[/b] is not allowed!");
                            return;
                        }
                        if (key.equalsIgnoreCase("ts3_server_query_password")) {
                            value = this.modClass.encryptPW(value);
                        }
                        if (this.config.setValue(key, value)) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Successfully set key [b]" + key + "[/b] to value:" + (value.length() > 6 ? "\n" : " ") + value + "\nDon't forget to do [b]!botcfgsave[/b] to make this change permanent!");
                        } else {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Key [b]" + key + "[/b] is not valid!");
                        }
                    }
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotCfgCheck(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin, String CONFIG_FILE_NAME) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        try {
            if (isFullAdmin || isAdmin) {
                this.config.setWriteProtection(true);
                JTS3ServerMod configCheck = new JTS3ServerMod(this.config.clone(), CONFIG_FILE_NAME);
                int configOK = configCheck.loadAndCheckConfig(false);
                this.config.setWriteProtection(false);
                if (configOK == 0) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Config OK!");
                } else {
                    String errorMsg = configCheck.getErrorMessage(configOK);
                    if (errorMsg.length() > 954) {
                        errorMsg = String.valueOf(errorMsg.substring(0, 950)) + "\n[...]";
                    }
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Config checked and found following errors:\n" + errorMsg);
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotCfgSave(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin, String CONFIG_FILE_NAME, boolean mysqlMode) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        try {
            if (isFullAdmin || isAdmin) {
                this.config.setWriteProtection(true);
                JTS3ServerMod configCheck = new JTS3ServerMod(this.config.clone(), CONFIG_FILE_NAME);
                int configOK = configCheck.loadAndCheckConfig(false);
                this.config.setWriteProtection(false);
                if (configOK == 0) {
                    String answerMsg = this.config.save() ? (mysqlMode ? "Config OK and written to database! Do [b]!botcfgreload[/b] or [b]!botreload[/b] to see the changes!" : "Config OK and written to disk! Do [b]!botcfgreload[/b] or [b]!botreload[/b] to see the changes!") : (mysqlMode ? "Config OK, but an error occurred while saving to database!" : "Config OK, but an error occurred while writing to disk! Maybe file write protected?");
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, answerMsg);
                } else {
                    String errorMsg = configCheck.getErrorMessage(configOK);
                    if (errorMsg.length() > 954) {
                        errorMsg = String.valueOf(errorMsg.substring(0, 950)) + "\n[...]";
                    }
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Config checked and found following errors:\n" + errorMsg + "\nNot written to disk!");
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleSearchClient(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                if (this.clientCache == null) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Client database cache disabled, command disabled!");
                } else if (arguments.length() == 0) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !clientsearch <clientname or unique id>\nYou can use * as wildcard (client name only)!");
                } else if (arguments.indexOf("**") != -1) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage, only single wildcards are allowed!");
                } else if (this.clientCache.isUpdateRunning()) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Client database cache is updating, please wait some time and try again!");
                } else {
                    Vector<Integer> clientSearch = this.clientCache.searchClientNickname(arguments);
                    if (clientSearch == null) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage, use a valid search pattern with at least 3 characters!");
                    } else if (clientSearch.size() == 0) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "No clients found in the database!");
                    } else if (arguments.indexOf("*") == -1 && clientSearch.size() <= 30 || clientSearch.size() <= 15) {
                        this.modClass.sendMessageToClient(null, "chat", Integer.parseInt(eventInfo.get("invokerid")), this.getDetailedClientList(clientSearch));
                    } else if (clientSearch.size() > 15 && clientSearch.size() <= 100) {
                        this.modClass.sendMessageToClient(null, "chat", Integer.parseInt(eventInfo.get("invokerid")), this.getSimpleSearchList(clientSearch, (byte)0));
                    } else if (clientSearch.size() > 100) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Found " + Integer.toString(clientSearch.size()) + " entries in the database using the search string \"" + arguments + "\", please refine your search!");
                    }
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleSearchIP(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                if (this.clientCache == null || !this.clientCache.isCacheLocal()) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Client database cache disabled, command disabled!");
                } else if (arguments.length() == 0) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !searchip <ip address>\nYou can use * as wildcard!");
                } else if (arguments.indexOf("**") != -1) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage, only single wildcards are allowed!");
                } else if (this.clientCache.isUpdateRunning()) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Client database cache is updating, please wait some time and try again!");
                } else {
                    Vector<Integer> ipSearch = this.clientCache.searchIPAddress(arguments);
                    if (ipSearch == null) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage, use a valid search pattern with at least 3 characters!");
                    } else if (ipSearch.size() == 0) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "No clients found in the database!");
                    } else if (arguments.indexOf("*") == -1 && ipSearch.size() <= 30 || ipSearch.size() <= 15) {
                        this.modClass.sendMessageToClient(null, "chat", Integer.parseInt(eventInfo.get("invokerid")), this.getDetailedClientList(ipSearch));
                    } else if (ipSearch.size() > 15 && ipSearch.size() <= 100) {
                        this.modClass.sendMessageToClient(null, "chat", Integer.parseInt(eventInfo.get("invokerid")), this.getSimpleSearchList(ipSearch, (byte)1));
                    } else if (ipSearch.size() > 100) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Found " + Integer.toString(ipSearch.size()) + " entries in the database using the search string \"" + arguments + "\", please refine your search!");
                    }
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleSearchDescription(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                if (this.clientCache == null || !this.clientCache.isCacheLocal()) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Client database cache disabled, command disabled!");
                } else if (arguments.length() == 0) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !searchdesc <description>\nYou can use * as wildcard!");
                } else if (arguments.indexOf("**") != -1) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage, only single wildcards are allowed!");
                } else if (this.clientCache.isUpdateRunning()) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Client database cache is updating, please wait some time and try again!");
                } else {
                    Vector<Integer> descriptionSearch = this.clientCache.searchDescription(arguments);
                    if (descriptionSearch == null) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage, use a valid search pattern with at least 3 characters!");
                    } else if (descriptionSearch.size() == 0) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "No clients found in the database!");
                    } else if (arguments.indexOf("*") == -1 && descriptionSearch.size() <= 30 || descriptionSearch.size() <= 15) {
                        this.modClass.sendMessageToClient(null, "chat", Integer.parseInt(eventInfo.get("invokerid")), this.getDetailedClientList(descriptionSearch));
                    } else if (descriptionSearch.size() > 15 && descriptionSearch.size() <= 100) {
                        this.modClass.sendMessageToClient(null, "chat", Integer.parseInt(eventInfo.get("invokerid")), this.getSimpleSearchList(descriptionSearch, (byte)2));
                    } else if (descriptionSearch.size() > 100) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Found " + Integer.toString(descriptionSearch.size()) + " entries in the database using the search string \"" + arguments + "\", please refine your search!");
                    }
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    private String getDetailedClientList(Vector<Integer> clientDBList) {
        StringBuffer sb = new StringBuffer("Found " + Integer.toString(clientDBList.size()) + " entries in the database:");
        Vector<HashMap<String, String>> clientList = this.modClass.getClientList();
        boolean foundClient = false;
        int pos = 0;
        for (int clientDBID : clientDBList) {
            try {
                long createdAt = (long)this.clientCache.getCreatedAt(clientDBID) * 1000L;
                String temp = "\n[b]" + this.clientCache.getNickname(clientDBID) + "[/b] ([i]DB ID:[/i] " + Integer.toString(clientDBID) + ")  [i]public unique ID:[/i] " + this.clientCache.getUniqueID(clientDBID) + "  [i]last IP:[/i] " + this.clientCache.getLastIP(clientDBID) + "  [i]created at:[/i] " + this.sdf.format(new Date(createdAt)) + "  [i]last seen at:[/i] ";
                for (HashMap<String, String> clientOnline : clientList) {
                    if (clientDBID != Integer.parseInt(clientOnline.get("client_database_id"))) continue;
                    temp = String.valueOf(temp) + "currently online (id: " + clientOnline.get("clid") + ")";
                    foundClient = true;
                    break;
                }
                if (!foundClient) {
                    try {
                        long lastOnline = (long)this.clientCache.getLastOnline(clientDBID) * 1000L;
                        temp = String.valueOf(temp) + this.sdf.format(new Date(lastOnline));
                    }
                    catch (Exception e) {
                        this.modClass.addLogEntry(e, false);
                    }
                }
                foundClient = false;
                temp = String.valueOf(temp) + "  [i]description:[/i] " + this.clientCache.getDescription(clientDBID);
                pos = sb.lastIndexOf("\u00a7+\u00a7");
                if (pos == -1) {
                    if (this.modClass.getUTF8Length(String.valueOf(sb.toString()) + temp) > 1024) {
                        sb.append("\u00a7+\u00a7");
                    }
                } else if (this.modClass.getUTF8Length(String.valueOf(sb.substring(pos + 3)) + temp) > 1024) {
                    sb.append("\u00a7+\u00a7");
                }
                sb.append(temp);
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
        return sb.toString();
    }

    private String getSimpleSearchList(Vector<Integer> clientDBList, byte type) {
        StringBuffer sb = new StringBuffer("Found " + Integer.toString(clientDBList.size()) + " entries in the database, please refine your search:\n");
        int pos = 0;
        boolean firstLine = true;
        for (int clientDBID : clientDBList) {
            String temp = type == 1 ? this.clientCache.getLastIP(clientDBID) : (type == 2 ? "\"" + this.clientCache.getDescription(clientDBID) + "\"" : "\"" + this.clientCache.getNickname(clientDBID) + "\"");
            pos = sb.lastIndexOf("\u00a7+\u00a7");
            if (pos == -1 && this.modClass.getUTF8Length(String.valueOf(sb.toString()) + ", " + temp) > 1024 || this.modClass.getUTF8Length(String.valueOf(sb.substring(pos + 3)) + ", " + temp) > 1024) {
                sb.append("\u00a7+\u00a7");
            } else if (!firstLine) {
                sb.append(", ");
            }
            sb.append(temp);
            if (!firstLine) continue;
            firstLine = false;
        }
        return sb.toString();
    }

    void handleListInactiveClients(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block12: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            try {
                if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                    if (this.clientCache == null || !this.clientCache.isCacheLocal()) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Client database cache disabled, command disabled!");
                        break block12;
                    }
                    boolean descMode = true;
                    int days = 10;
                    if (arguments.length() > 0) {
                        try {
                            days = Integer.parseInt(arguments);
                            descMode = false;
                        }
                        catch (Exception e) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !listinactiveclients [minimum days inactive]");
                            return;
                        }
                    }
                    if (days >= 10) {
                        Vector<HashMap<String, Integer>> result = this.clientCache.searchInactiveClients(days, descMode ? 1 : 0);
                        if (result == null) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Please wait until the client database cache is ready!");
                        } else {
                            int count = 0;
                            StringBuffer clientList = new StringBuffer();
                            long currentTime = System.currentTimeMillis() / 1000L;
                            int i = 0;
                            while (i < result.size()) {
                                String temp = "\n[b]" + this.clientCache.getNickname(result.elementAt(i).get("cldbid")) + "[/b] (DB ID: " + result.elementAt(i).get("cldbid") + " - " + (int)((currentTime - (long)result.elementAt(i).get("lastonline").intValue()) / 86400L) + " days)";
                                if (this.modClass.getUTF8Length(String.valueOf(clientList.toString()) + temp) > 1024) break;
                                clientList.append(temp);
                                ++count;
                                ++i;
                            }
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Found " + Integer.toString(result.size()) + " clients which are inactive for at least " + Integer.toString(days) + " days!" + (count > 0 ? " Displaying the " + Integer.toString(count) + (descMode ? " most inactive" : " least inactive") + " clients of them!" : ""));
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, clientList.toString());
                        }
                    } else {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Lowest possible days to list inactive clients are 10 days!");
                    }
                    break block12;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleListInactiveChannels(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block19: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            try {
                if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                    if (this.modClass.getChannelList() == null || this.modClass.getChannelList().size() == 0) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Missing channel list, command disabled!");
                        return;
                    }
                    Vector channelList = (Vector)this.modClass.getChannelList().clone();
                    ChannelEmptyComparator cec = new ChannelEmptyComparator();
                    Collections.sort(channelList, cec);
                    boolean ignoreSpacer = false;
                    Pattern pSpacer = null;
                    Matcher mSpacer = null;
                    if (arguments.toLowerCase().startsWith("nospacer")) {
                        pSpacer = Pattern.compile("\\[.{0,1}spacer\\d*\\].*", 66);
                        arguments = arguments.length() > 9 ? arguments.substring(9) : "";
                        ignoreSpacer = true;
                    }
                    long curtime = System.currentTimeMillis();
                    StringBuffer sbChannelList = new StringBuffer();
                    if (arguments.length() > 0) {
                        int channelID = -1;
                        try {
                            channelID = Integer.parseInt(arguments);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        int count = 0;
                        for (HashMap channel : channelList) {
                            if (channelID >= 0) {
                                if (Integer.parseInt((String)channel.get("cid")) != channelID) continue;
                                String timeString = "Not empty!";
                                if (Long.parseLong((String)channel.get("seconds_empty")) >= 0L) {
                                    timeString = "Empty since " + this.modClass.getDifferenceTime(curtime - Long.parseLong((String)channel.get("seconds_empty")) * 1000L, curtime);
                                }
                                sbChannelList.append("[b]" + (String)channel.get("channel_name") + "[/b] (ID: ");
                                sbChannelList.append((String)channel.get("cid"));
                                sbChannelList.append(") - ");
                                sbChannelList.append(timeString);
                                ++count;
                                break;
                            }
                            if (Long.parseLong((String)channel.get("seconds_empty")) <= 0L) break;
                            if (ignoreSpacer && (mSpacer = pSpacer.matcher((CharSequence)channel.get("channel_name"))).matches() || ((String)channel.get("channel_name")).toLowerCase().indexOf(arguments.toLowerCase()) == -1) continue;
                            String temp = "\n[b]" + (String)channel.get("channel_name") + "[/b] (ID: " + (String)channel.get("cid") + ") - " + this.modClass.getDifferenceTime(curtime - Long.parseLong((String)channel.get("seconds_empty")) * 1000L, curtime);
                            if (this.modClass.getUTF8Length(String.valueOf(sbChannelList.toString()) + temp) > 1024) break;
                            sbChannelList.append(temp);
                            ++count;
                        }
                        if (channelID >= 0) {
                            if (count == 0) {
                                sbChannelList.append("No channel found with channel ID " + Integer.toString(channelID) + "!");
                            }
                        } else {
                            if (count == 0) {
                                sbChannelList.append("No channels found with this name!");
                            }
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "List of empty channels (sorted by empty since time). Displaying " + Integer.toString(count) + " of " + Integer.toString(channelList.size()) + " channels with the search string \"" + arguments + "\":");
                        }
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, sbChannelList.toString());
                        break block19;
                    }
                    int count = 0;
                    int i = 0;
                    int len = channelList.size();
                    while (i < len) {
                        if (Long.parseLong((String)((HashMap)channelList.get(i)).get("seconds_empty")) <= 0L) break;
                        if (!ignoreSpacer || !(mSpacer = pSpacer.matcher((CharSequence)((HashMap)channelList.get(i)).get("channel_name"))).matches()) {
                            String temp = "\n[b]" + (String)((HashMap)channelList.get(i)).get("channel_name") + "[/b] (ID: " + (String)((HashMap)channelList.get(i)).get("cid") + ") - " + this.modClass.getDifferenceTime(curtime - Long.parseLong((String)((HashMap)channelList.get(i)).get("seconds_empty")) * 1000L, curtime);
                            if (this.modClass.getUTF8Length(String.valueOf(sbChannelList.toString()) + temp) > 1024) break;
                            sbChannelList.append(temp);
                            ++count;
                        }
                        ++i;
                    }
                    if (sbChannelList.length() > 0) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "List of empty channels (sorted by empty since time). Displaying " + Integer.toString(count) + " of " + Integer.toString(channelList.size()) + " channels!");
                    } else {
                        sbChannelList.append("No channel is empty!");
                    }
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, sbChannelList.toString());
                    break block19;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleSetChannelGroup(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block13: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            try {
                if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                    if (arguments.length() >= 5) {
                        int clientDBIDArg = -1;
                        int channelGroupID = -1;
                        Vector<Integer> channelList = new Vector<Integer>();
                        try {
                            int pos2;
                            int pos;
                            block12: {
                                pos = 0;
                                pos2 = arguments.indexOf(" ", pos);
                                try {
                                    clientDBIDArg = Integer.parseInt(arguments.substring(pos, pos2));
                                }
                                catch (NumberFormatException e) {
                                    clientDBIDArg = this.modClass.getClientDBID(arguments.substring(pos, pos2));
                                    if (clientDBIDArg >= 0) break block12;
                                    throw new NumberFormatException("Got invalid client database id or unique id!");
                                }
                            }
                            pos = pos2 + 1;
                            pos2 = arguments.indexOf(" ", pos);
                            channelGroupID = Integer.parseInt(arguments.substring(pos, pos2));
                            StringTokenizer st = new StringTokenizer(arguments.substring(pos2 + 1), ",", false);
                            while (st.hasMoreTokens()) {
                                channelList.addElement(Integer.parseInt(st.nextToken().trim()));
                            }
                        }
                        catch (NumberFormatException nfe) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while parsing numbers, command aborted...");
                            this.modClass.addLogEntry(nfe, false);
                        }
                        if (channelList.size() == 0) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage, no channels given! Right: !setchannelgroup <client database id or unique id> <channel group id> <channel list separated with comma>");
                            return;
                        }
                        int count = 0;
                        int errorcount = 0;
                        Iterator iterator = channelList.iterator();
                        while (iterator.hasNext()) {
                            int channelID = (Integer)iterator.next();
                            HashMap<String, String> actionResponse = this.queryLib.doCommand("setclientchannelgroup cgid=" + Integer.toString(channelGroupID) + " cid=" + channelID + " cldbid=" + Integer.toString(clientDBIDArg));
                            if (actionResponse.get("id").equals("0")) {
                                ++count;
                                continue;
                            }
                            ++errorcount;
                        }
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Channel group for client database id " + Integer.toString(clientDBIDArg) + " successfully set to channel group id " + Integer.toString(channelGroupID) + " for " + Integer.toString(count) + " channels!" + (errorcount > 0 ? " " + Integer.toString(errorcount) + " channels could not set to default channel group!" : ""));
                        break block13;
                    }
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !setchannelgroup <client database id or unique id> <channel group id> <channel list separated with comma>");
                    break block13;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    private Vector<Integer> getServerGroupsFromClient(int clientDBIDArg) throws NumberFormatException, TS3ServerQueryException {
        Vector<Integer> serverGroupList = new Vector<Integer>();
        Vector<HashMap<String, String>> serverGroupClientList = this.queryLib.getList(10, "cldbid=" + Integer.toString(clientDBIDArg));
        ServerInfoCache_Interface serverInfoCache = this.modClass.getServerInfoCache();
        int defsgid = serverInfoCache.getServerDefaultServerGroup();
        for (HashMap<String, String> hashMap : serverGroupClientList) {
            if (defsgid == Integer.parseInt(hashMap.get("sgid"))) continue;
            serverGroupList.addElement(Integer.parseInt(hashMap.get("sgid")));
        }
        return serverGroupList;
    }

    private int getClientDBID(String client) throws NumberFormatException {
        int clientDBIDArg;
        block2: {
            clientDBIDArg = -1;
            try {
                clientDBIDArg = Integer.parseInt(client);
            }
            catch (NumberFormatException e) {
                clientDBIDArg = this.modClass.getClientDBID(client);
                if (clientDBIDArg >= 0) break block2;
                throw new NumberFormatException("Got invalid client database id or unique id!");
            }
        }
        return clientDBIDArg;
    }

    void handleRemoveServerGroups(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block10: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            try {
                if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                    if (arguments.length() >= 1) {
                        boolean doAction = false;
                        Vector<Object> serverGroupList = new Vector();
                        int clientDBIDArg = -1;
                        try {
                            clientDBIDArg = this.getClientDBID(arguments);
                            serverGroupList = this.getServerGroupsFromClient(clientDBIDArg);
                            doAction = true;
                        }
                        catch (NumberFormatException nfe) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while parsing numbers, command aborted...");
                            this.modClass.addLogEntry(nfe, false);
                        }
                        catch (Exception e) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while requesting information from TS3 server, command aborted...");
                            this.modClass.addLogEntry(e, false);
                        }
                        if (doAction) {
                            int count = 0;
                            int errorcount = 0;
                            Iterator<Object> iterator = serverGroupList.iterator();
                            while (iterator.hasNext()) {
                                int serverGroupID = (Integer)iterator.next();
                                HashMap<String, String> actionResponse = this.queryLib.doCommand("servergroupdelclient sgid=" + serverGroupID + " cldbid=" + Integer.toString(clientDBIDArg));
                                if (actionResponse.get("id").equals("0")) {
                                    ++count;
                                    continue;
                                }
                                ++errorcount;
                            }
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Removed " + Integer.toString(count) + " server groups of client database id " + Integer.toString(clientDBIDArg) + " successfully!" + (errorcount > 0 ? " " + Integer.toString(errorcount) + " server groups could not removed!" : ""));
                        }
                        break block10;
                    }
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !removeservergroups <client database id or unique id>");
                    break block10;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleListServerGroups(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block20: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            try {
                if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                    if (arguments.length() >= 1) {
                        boolean doAction = false;
                        Vector<Object> serverGroupList = new Vector();
                        int clientDBIDArg = -1;
                        try {
                            clientDBIDArg = this.getClientDBID(arguments);
                            serverGroupList = this.getServerGroupsFromClient(clientDBIDArg);
                            doAction = true;
                        }
                        catch (NumberFormatException nfe) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while parsing numbers, command aborted...");
                            this.modClass.addLogEntry(nfe, false);
                        }
                        catch (Exception e) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while requesting information from TS3 server, command aborted...");
                            this.modClass.addLogEntry(e, false);
                        }
                        if (doAction) {
                            int pos = 0;
                            String line = null;
                            StringBuffer sglist = new StringBuffer("Found " + Integer.toString(serverGroupList.size()) + " server groups of the client with the database id " + Integer.toString(clientDBIDArg) + ":");
                            Iterator<Object> iterator = serverGroupList.iterator();
                            while (iterator.hasNext()) {
                                int serverGroupID = (Integer)iterator.next();
                                line = "\n" + this.modClass.getServerGroupName(serverGroupID) + " (" + Integer.toString(serverGroupID) + ")";
                                pos = sglist.lastIndexOf("\u00a7+\u00a7");
                                if (pos == -1) {
                                    if (this.modClass.getUTF8Length(String.valueOf(sglist.toString()) + line) > 1024) {
                                        sglist.append("\u00a7+\u00a7");
                                    }
                                } else if (this.modClass.getUTF8Length(String.valueOf(sglist.substring(pos + 3)) + line) > 1024) {
                                    sglist.append("\u00a7+\u00a7");
                                }
                                sglist.append(line);
                            }
                            if (!this.modClass.sendMessageToClient(null, "chat", Integer.parseInt(eventInfo.get("invokerid")), sglist.toString())) {
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while sending list to you!");
                            }
                        }
                        break block20;
                    }
                    Vector<HashMap<String, String>> serverGroupList = this.modClass.getServerGroupCache();
                    int pos = 0;
                    String line = null;
                    StringBuffer sglist = new StringBuffer("List of all server groups:");
                    for (HashMap<String, String> serverGroup : serverGroupList) {
                        if (serverGroup.get("type").equals("0")) continue;
                        line = "\n" + serverGroup.get("name") + " (" + serverGroup.get("sgid") + ")";
                        pos = sglist.lastIndexOf("\u00a7+\u00a7");
                        if (pos == -1) {
                            if (this.modClass.getUTF8Length(String.valueOf(sglist.toString()) + line) > 1024) {
                                sglist.append("\u00a7+\u00a7");
                            }
                        } else if (this.modClass.getUTF8Length(String.valueOf(sglist.substring(pos + 3)) + line) > 1024) {
                            sglist.append("\u00a7+\u00a7");
                        }
                        sglist.append(line);
                    }
                    if (!this.modClass.sendMessageToClient(null, "chat", Integer.parseInt(eventInfo.get("invokerid")), sglist.toString())) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while sending list to you!");
                    }
                    break block20;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    private Vector<HashMap<String, String>> getChannelGroupsFromClient(int clientDBIDArg) throws NumberFormatException, TS3ServerQueryException {
        Vector<HashMap<String, String>> channelGroupClientList = null;
        HashMap<String, String> cgcListResponse = this.queryLib.doCommand("channelgroupclientlist cldbid=" + Integer.toString(clientDBIDArg));
        if (!cgcListResponse.get("id").equals("0")) {
            throw new TS3ServerQueryException("getChannelGroupsFromClient(" + Integer.toString(clientDBIDArg) + ")", cgcListResponse.get("id"), cgcListResponse.get("msg"), cgcListResponse.get("extra_msg"), cgcListResponse.get("failed_permid"));
        }
        channelGroupClientList = this.queryLib.parseRawData(cgcListResponse.get("response"));
        return channelGroupClientList;
    }

    void handleListChannelGroups(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block24: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            try {
                if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                    if (arguments.length() >= 1) {
                        boolean doAction;
                        int clientDBIDArg;
                        Vector<HashMap<String, String>> channelGroupClientList;
                        block25: {
                            ServerInfoCache_Interface serverInfoCache = this.modClass.getServerInfoCache();
                            if (serverInfoCache == null) {
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while getting server info, command aborted...");
                                break block24;
                            }
                            channelGroupClientList = null;
                            int defChannelGroupID = -1;
                            clientDBIDArg = -1;
                            doAction = false;
                            try {
                                defChannelGroupID = serverInfoCache.getServerDefaultChannelGroup();
                                if (defChannelGroupID >= 0) {
                                    clientDBIDArg = this.getClientDBID(arguments);
                                    channelGroupClientList = this.getChannelGroupsFromClient(clientDBIDArg);
                                    int i = 0;
                                    while (i < channelGroupClientList.size()) {
                                        if (Integer.parseInt(channelGroupClientList.elementAt(i).get("cgid")) == defChannelGroupID) {
                                            channelGroupClientList.removeElementAt(i);
                                            --i;
                                        }
                                        ++i;
                                    }
                                    doAction = true;
                                    break block25;
                                }
                                throw new NumberFormatException("Got invalid default channel group id!");
                            }
                            catch (NumberFormatException nfe) {
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while parsing numbers, command aborted...");
                                this.modClass.addLogEntry(nfe, false);
                            }
                            catch (TS3ServerQueryException sqe) {
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while getting channel group list for the client database id " + Integer.toString(clientDBIDArg) + ", reason from TS3 server: " + sqe.getErrorMessage());
                                this.modClass.addLogEntry(sqe, false);
                            }
                        }
                        if (doAction) {
                            int cid = 0;
                            int cgid = 0;
                            int pos = 0;
                            String line = null;
                            StringBuffer cglist = new StringBuffer("Found " + Integer.toString(channelGroupClientList.size()) + " channels with a non-default channel group of the client with the database id " + Integer.toString(clientDBIDArg) + ":");
                            for (HashMap<String, String> entry : channelGroupClientList) {
                                cid = Integer.parseInt(entry.get("cid"));
                                cgid = Integer.parseInt(entry.get("cgid"));
                                line = "\n" + this.modClass.getChannelGroupName(cgid) + " (" + Integer.toString(cgid) + ") - " + this.modClass.getChannelName(cid) + " (" + Integer.toString(cid) + ")";
                                pos = cglist.lastIndexOf("\u00a7+\u00a7");
                                if (pos == -1) {
                                    if (this.modClass.getUTF8Length(String.valueOf(cglist.toString()) + line) > 1024) {
                                        cglist.append("\u00a7+\u00a7");
                                    }
                                } else if (this.modClass.getUTF8Length(String.valueOf(cglist.substring(pos + 3)) + line) > 1024) {
                                    cglist.append("\u00a7+\u00a7");
                                }
                                cglist.append(line);
                            }
                            if (!this.modClass.sendMessageToClient(null, "chat", Integer.parseInt(eventInfo.get("invokerid")), cglist.toString())) {
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while sending list to you!");
                            }
                        }
                        break block24;
                    }
                    Vector<HashMap<String, String>> channelGroupList = this.modClass.getChannelGroupCache();
                    int pos = 0;
                    String line = null;
                    StringBuffer cglist = new StringBuffer("List of all channel groups:");
                    for (HashMap<String, String> channelGroup : channelGroupList) {
                        if (channelGroup.get("type").equals("0")) continue;
                        line = "\n" + channelGroup.get("name") + " (" + channelGroup.get("cgid") + ")";
                        pos = cglist.lastIndexOf("\u00a7+\u00a7");
                        if (pos == -1) {
                            if (this.modClass.getUTF8Length(String.valueOf(cglist.toString()) + line) > 1024) {
                                cglist.append("\u00a7+\u00a7");
                            }
                        } else if (this.modClass.getUTF8Length(String.valueOf(cglist.substring(pos + 3)) + line) > 1024) {
                            cglist.append("\u00a7+\u00a7");
                        }
                        cglist.append(line);
                    }
                    if (!this.modClass.sendMessageToClient(null, "chat", Integer.parseInt(eventInfo.get("invokerid")), cglist.toString())) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while sending list to you!");
                    }
                    break block24;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleRemoveChannelGroups(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block13: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            try {
                if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                    if (arguments.length() >= 1) {
                        boolean doAction;
                        int clientDBIDArg;
                        int defChannelGroupID;
                        Vector<Integer> channelList;
                        block14: {
                            ServerInfoCache_Interface serverInfoCache = this.modClass.getServerInfoCache();
                            if (serverInfoCache == null) {
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while getting server info, command aborted...");
                                break block13;
                            }
                            channelList = new Vector<Integer>();
                            defChannelGroupID = -1;
                            clientDBIDArg = -1;
                            doAction = false;
                            try {
                                defChannelGroupID = serverInfoCache.getServerDefaultChannelGroup();
                                if (defChannelGroupID >= 0) {
                                    clientDBIDArg = this.getClientDBID(arguments);
                                    Vector<HashMap<String, String>> channelGroupClientList = this.getChannelGroupsFromClient(clientDBIDArg);
                                    for (HashMap<String, String> hashMap : channelGroupClientList) {
                                        if (Integer.parseInt(hashMap.get("cgid")) == defChannelGroupID) continue;
                                        channelList.addElement(Integer.parseInt(hashMap.get("cid")));
                                    }
                                    doAction = true;
                                    break block14;
                                }
                                throw new NumberFormatException("Got invalid default channel group id!");
                            }
                            catch (NumberFormatException nfe) {
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while parsing numbers, command aborted...");
                                this.modClass.addLogEntry(nfe, false);
                            }
                            catch (TS3ServerQueryException sqe) {
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while getting channel group list for the client database id " + Integer.toString(clientDBIDArg) + ", reason from TS3 server: " + sqe.getErrorMessage());
                                this.modClass.addLogEntry(sqe, false);
                            }
                        }
                        if (doAction) {
                            int count = 0;
                            int errorcount = 0;
                            Iterator iterator = channelList.iterator();
                            while (iterator.hasNext()) {
                                int channelID = (Integer)iterator.next();
                                HashMap<String, String> actionResponse = this.queryLib.doCommand("setclientchannelgroup cgid=" + Integer.toString(defChannelGroupID) + " cid=" + channelID + " cldbid=" + Integer.toString(clientDBIDArg));
                                if (actionResponse.get("id").equals("0")) {
                                    ++count;
                                    continue;
                                }
                                ++errorcount;
                            }
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Channel group for client database id " + Integer.toString(clientDBIDArg) + " successfully set to default channel group for " + Integer.toString(count) + " channels!" + (errorcount > 0 ? " " + Integer.toString(errorcount) + " channels could not set to default channel group!" : ""));
                        }
                        break block13;
                    }
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !removechannelgroups <client database id or unique id>");
                    break block13;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleMsgChannelGroup(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                if (arguments.length() >= 3) {
                    int pos = arguments.indexOf(" ");
                    if (pos == -1) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !msgchannelgroup <channelgroup id> <message>");
                    } else {
                        this.doMsgChannelGroup(arguments.substring(0, pos), arguments.substring(pos + 1), false, eventInfo);
                    }
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !msgchannelgroup <channelgroup id> <message>");
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handlePokeChannelGroup(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                if (arguments.length() >= 3) {
                    int pos = arguments.indexOf(" ");
                    if (pos == -1) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !pokechannelgroup <channelgroup id> <message>");
                    } else {
                        this.doMsgChannelGroup(arguments.substring(0, pos), arguments.substring(pos + 1), true, eventInfo);
                    }
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !pokechannelgroup <channelgroup id> <message>");
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    private void doMsgChannelGroup(String groups, String msg, boolean doPoke, HashMap<String, String> eventInfo) {
        try {
            Vector<Integer> clientListSend = new Vector<Integer>();
            String sendMessage = "Message from " + eventInfo.get("invokername") + (doPoke ? ":\u00a7+\u00a7" : ": ") + msg;
            boolean doAction = false;
            try {
                Vector<Integer> groupList = new Vector<Integer>();
                if (groups != null && groups.length() > 0) {
                    StringTokenizer st = new StringTokenizer(groups, ",", false);
                    while (st.hasMoreTokens()) {
                        groupList.addElement(Integer.parseInt(st.nextToken().trim()));
                    }
                }
                Vector<HashMap<String, String>> clientListGroups = this.queryLib.getList(1, "-groups");
                for (HashMap<String, String> hashMap : clientListGroups) {
                    if (groupList.indexOf(Integer.parseInt(hashMap.get("client_channel_group_id"))) < 0 || Integer.parseInt(hashMap.get("client_type")) != 0 || clientListSend.indexOf(Integer.parseInt(hashMap.get("clid"))) != -1) continue;
                    clientListSend.addElement(Integer.parseInt(hashMap.get("clid")));
                }
                doAction = true;
            }
            catch (NumberFormatException nfe) {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while parsing numbers, command aborted...");
            }
            if (doAction) {
                int count = 0;
                int errorcount = 0;
                Iterator<HashMap<String, String>> iterator = clientListSend.iterator();
                while (iterator.hasNext()) {
                    int clientid;
                    if (this.modClass.sendMessageToClient(null, doPoke ? "poke" : "chat", clientid = ((Integer)((Object)iterator.next())).intValue(), sendMessage)) {
                        ++count;
                        continue;
                    }
                    ++errorcount;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Message sent to " + Integer.toString(count) + " clients!" + (errorcount > 0 ? " Error while sending message to " + Integer.toString(errorcount) + " clients!" : ""));
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleMsgServerGroup(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                if (arguments.length() >= 3) {
                    int pos = arguments.indexOf(" ");
                    if (pos == -1) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !msgservergroup <servergroup id> <message>");
                    } else {
                        this.doMsgServerGroup(arguments.substring(0, pos), arguments.substring(pos + 1), false, eventInfo);
                    }
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !msgservergroup <servergroup id> <message>");
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleMsgAll(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                if (arguments.length() >= 1) {
                    this.doMsgAll(arguments, false, eventInfo);
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !msgall <message>");
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handlePokeAll(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                if (arguments.length() >= 1) {
                    this.doMsgAll(arguments, true, eventInfo);
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !pokeall <message>");
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handlePokeServerGroup(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                if (arguments.length() >= 3) {
                    int pos = arguments.indexOf(" ");
                    if (pos == -1) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !pokeservergroup <servergroup id> <message>");
                    } else {
                        this.doMsgServerGroup(arguments.substring(0, pos), arguments.substring(pos + 1), true, eventInfo);
                    }
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !pokeservergroup <servergroup id> <message>");
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void doMsgServerGroup(String groups, String msg, boolean doPoke, HashMap<String, String> eventInfo) {
        try {
            Vector<Integer> clientListSend = new Vector<Integer>();
            String sendMessage = "Message from " + eventInfo.get("invokername") + (doPoke ? ":\u00a7+\u00a7" : ": ") + msg;
            boolean doAction = false;
            try {
                Vector<Integer> groupList = new Vector<Integer>();
                if (groups != null && groups.length() > 0) {
                    StringTokenizer st = new StringTokenizer(groups, ",", false);
                    while (st.hasMoreTokens()) {
                        groupList.addElement(Integer.parseInt(st.nextToken().trim()));
                    }
                }
                Vector<HashMap<String, String>> clientListGroups = this.queryLib.getList(1, "-groups");
                for (HashMap<String, String> hashMap : clientListGroups) {
                    if (!this.modClass.isGroupListed(hashMap.get("client_servergroups"), groupList) || Integer.parseInt(hashMap.get("client_type")) != 0 || clientListSend.indexOf(Integer.parseInt(hashMap.get("clid"))) != -1) continue;
                    clientListSend.addElement(Integer.parseInt(hashMap.get("clid")));
                }
                doAction = true;
            }
            catch (NumberFormatException nfe) {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while parsing numbers, command aborted...");
            }
            if (doAction) {
                int count = 0;
                int errorcount = 0;
                Iterator<HashMap<String, String>> iterator = clientListSend.iterator();
                while (iterator.hasNext()) {
                    int clientid;
                    if (this.modClass.sendMessageToClient(null, doPoke ? "poke" : "chat", clientid = ((Integer)((Object)iterator.next())).intValue(), sendMessage)) {
                        ++count;
                        continue;
                    }
                    ++errorcount;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Message sent to " + Integer.toString(count) + " clients!" + (errorcount > 0 ? " Error while sending message to " + Integer.toString(errorcount) + " clients!" : ""));
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void doMsgAll(String msg, boolean doPoke, HashMap<String, String> eventInfo) {
        try {
            String sendMessage = "Message from " + eventInfo.get("invokername") + (doPoke ? ":\u00a7+\u00a7" : ": ") + msg;
            try {
                int count = 0;
                int errorcount = 0;
                Vector<HashMap<String, String>> clientList = this.queryLib.getList(1);
                for (HashMap<String, String> hashMap : clientList) {
                    if (Integer.parseInt(hashMap.get("client_type")) != 0) continue;
                    if (this.modClass.sendMessageToClient(null, doPoke ? "poke" : "chat", Integer.parseInt(hashMap.get("clid")), sendMessage)) {
                        ++count;
                        continue;
                    }
                    ++errorcount;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Message sent to " + Integer.toString(count) + " clients!" + (errorcount > 0 ? " Error while sending message to " + Integer.toString(errorcount) + " clients!" : ""));
            }
            catch (NumberFormatException nfe) {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while parsing numbers, command aborted...");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleSetChannelName(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block9: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            try {
                if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                    int channelID;
                    if (arguments.length() < 3) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !setchannelname <channel id> <new channel name>");
                        return;
                    }
                    int pos = arguments.indexOf(" ");
                    if (pos == -1) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !setchannelname <channel id> <new channel name>");
                        return;
                    }
                    try {
                        channelID = Integer.parseInt(arguments.substring(0, pos));
                    }
                    catch (Exception e) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! The channel id has to be a number!");
                        return;
                    }
                    String newChannelName = arguments.substring(pos + 1).trim();
                    HashMap<String, String> actionResponse = this.queryLib.doCommand("channeledit cid=" + Integer.toString(channelID) + " channel_name=" + this.queryLib.encodeTS3String(newChannelName));
                    if (actionResponse.get("id").equals("0")) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Channel id " + Integer.toString(channelID) + " was successfully renamed to: " + newChannelName);
                        this.modClass.setChannelName(channelID, newChannelName);
                    } else {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while rename channel id " + Integer.toString(channelID) + "!");
                    }
                    break block9;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleGetChannelID(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block18: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            try {
                if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                    Vector<HashMap<String, String>> channelList = this.modClass.getChannelList();
                    if (channelList == null) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while getting channel list. Command aborted!");
                        return;
                    }
                    StringBuffer sbChannelList = new StringBuffer();
                    int count = 0;
                    if (arguments.length() == 0) {
                        for (HashMap<String, String> channel : channelList) {
                            String temp = "\nID: " + channel.get("cid") + " - [b]" + channel.get("channel_name") + "[/b]";
                            if (this.modClass.getUTF8Length(String.valueOf(sbChannelList.toString()) + temp) > 1024) break;
                            sbChannelList.append(temp);
                            ++count;
                        }
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Displaying " + Integer.toString(count) + " of " + Integer.toString(channelList.size()) + " channels:");
                    } else {
                        int channelID = -1;
                        try {
                            channelID = Integer.parseInt(arguments);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        int countTotal = 0;
                        for (HashMap<String, String> channel : channelList) {
                            if (channelID >= 0) {
                                if (Integer.parseInt(channel.get("cid")) != channelID) continue;
                                sbChannelList.append("Channel ID: " + channel.get("cid") + " - [b]" + channel.get("channel_name") + "[/b]");
                                ++count;
                                break;
                            }
                            if (channel.get("channel_name").toLowerCase().indexOf(arguments.toLowerCase()) == -1) continue;
                            String temp = "\nID: " + channel.get("cid") + " - [b]" + channel.get("channel_name") + "[/b]";
                            if (this.modClass.getUTF8Length(String.valueOf(sbChannelList.toString()) + temp) <= 1024) {
                                sbChannelList.append(temp);
                                ++count;
                            }
                            ++countTotal;
                        }
                        if (channelID >= 0) {
                            if (count == 0) {
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "No channel found with the channel ID " + Integer.toString(channelID) + "!");
                            }
                        } else if (count == 0) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "No channels found with the search string \"" + arguments + "\"!");
                        } else {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Found the search string \"" + arguments + "\" in " + Integer.toString(countTotal) + " of " + Integer.toString(channelList.size()) + " channel names! Displaying " + Integer.toString(count) + " channels:");
                        }
                    }
                    if (sbChannelList.length() > 0) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, sbChannelList.toString());
                    }
                    break block18;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleExec(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        try {
            if (msg.toLowerCase().startsWith("!execwait")) {
                this.handleExecWait(msg, eventInfo, isFullAdmin);
            } else {
                String arguments = this.getArguments(msg);
                if (isFullAdmin) {
                    if (this.manager.isCommandExecAllowed()) {
                        if (arguments.length() > 0) {
                            try {
                                Runtime.getRuntime().exec(arguments);
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Command executed!");
                            }
                            catch (Exception e) {
                                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while executing command: " + e.toString());
                            }
                        } else {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !exec <system command>");
                        }
                    } else {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Command disabled!");
                    }
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master! You have to be full bot admin to use this command.");
                }
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleExecWait(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin) {
        String arguments = this.getArguments(msg);
        try {
            if (isFullAdmin) {
                if (this.manager.isCommandExecAllowed()) {
                    if (arguments.length() > 0) {
                        try {
                            Process proc = Runtime.getRuntime().exec(arguments);
                            BufferedInputStream bisOut = new BufferedInputStream(proc.getInputStream());
                            BufferedInputStream bisErr = new BufferedInputStream(proc.getErrorStream());
                            int returnValue = proc.waitFor();
                            StringBuffer output = new StringBuffer();
                            while (bisOut.available() > 0) {
                                output.append((char)bisOut.read());
                            }
                            while (bisErr.available() > 0) {
                                output.append((char)bisErr.read());
                            }
                            if (output.length() > 1004) {
                                output.setLength(1000);
                                output.append("\n[...]");
                            }
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Command executed with a return value of " + Integer.toString(returnValue) + "!\n");
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Output:\n" + output.toString());
                        }
                        catch (Exception e) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while executing command: " + e.toString());
                        }
                    } else {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !execwait <system command>");
                    }
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Command disabled!");
                }
            } else {
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master! You have to be full bot admin to use this command.");
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    void handleBotJoinChannel(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block9: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            try {
                if (isFullAdmin || isAdmin) {
                    if (arguments.length() == 0) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Current channel of the bot: [b]" + this.modClass.getChannelName(this.queryLib.getCurrentQueryClientChannelID()) + "[/b]\nChange the channel of the bot with this command: !botjoinchannel <channel id>");
                        break block9;
                    }
                    try {
                        int newChannelID = Integer.parseInt(arguments);
                        if (newChannelID == this.queryLib.getCurrentQueryClientChannelID()) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Bot is already in the given channel!");
                            break block9;
                        }
                        try {
                            this.queryLib.moveClient(this.queryLib.getCurrentQueryClientID(), newChannelID, null);
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Bot was moved into the channel: [b]" + this.modClass.getChannelName(this.queryLib.getCurrentQueryClientChannelID()) + "[/b]");
                            break block9;
                        }
                        catch (Exception e) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while moving bot into the given channel!");
                            this.modClass.addLogEntry(e, false);
                        }
                    }
                    catch (Exception e) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while reading given channel id!");
                    }
                    break block9;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleBotRename(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        block12: {
            this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
            String arguments = this.getArguments(msg);
            try {
                if (isFullAdmin || isAdmin) {
                    if (arguments.length() == 0) {
                        if (this.config.getValue("bot_server_query_name") == null) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "No default name set in bot config! Add a new name to command: !botrename <new name>");
                            return;
                        }
                        if (this.queryLib.getCurrentQueryClientName() != null && this.config.getValue("bot_server_query_name").equals(this.queryLib.getCurrentQueryClientName())) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Bot already has the default name! Add a new name to command: !botrename <new name>");
                            return;
                        }
                        arguments = this.config.getValue("bot_server_query_name");
                    }
                    if (arguments.length() < 3) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while renaming bot, new name needs at least 3 characters!");
                        return;
                    }
                    if (this.queryLib.getCurrentQueryClientName() != null && arguments.equals(this.queryLib.getCurrentQueryClientName())) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Bot already has the name: " + arguments);
                        return;
                    }
                    try {
                        this.queryLib.setDisplayName(arguments);
                        if (this.config.getValue("bot_server_query_name") != null && this.config.getValue("bot_server_query_name").equals(arguments)) {
                            this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Bot name changed back to default name: " + arguments);
                            break block12;
                        }
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Bot name temporary changed to: " + arguments);
                    }
                    catch (TS3ServerQueryException sqe) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while renaming bot to: " + arguments + "\n" + sqe.getMessage());
                    }
                    catch (Exception e) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Error while renaming bot to: " + arguments + "\nError: " + e.toString());
                    }
                    break block12;
                }
                this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "You are not my master!");
            }
            catch (Exception e) {
                this.modClass.addLogEntry(e, false);
            }
        }
    }

    void handleBotHelp(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        this.modClass.addLogEntry((byte)1, "Got command from " + eventInfo.get("invokername") + ": " + msg, false);
        String arguments = this.getArguments(msg);
        try {
            if (arguments.length() == 0) {
                StringBuffer helpText = new StringBuffer("List of commands:\n!botinfo");
                StringBuffer helpTextAdmin = new StringBuffer();
                StringBuffer helpTextBotAdmin = new StringBuffer();
                StringBuffer helpTextFullAdmin = new StringBuffer();
                helpText.append(this.modClass.getCommandList(eventInfo, isFullAdmin, isAdmin));
                if (isFullAdmin || isAdmin || this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                    helpTextAdmin.append("You can also use the following admin commands:\n!getChannelID [channel id or channel name]\n!listchannelgroups <client database id>\n!listinactivechannels [channel id or channel name]\n!listinactiveclients [minimum days inactive]\n!listservergroups <client database id>\n!msgall <message>\n!msgchannelgroup <channelgroup id> <message>\n!msgservergroup <servergroup id> <message>\n!pokeall <message>\n!pokechannelgroup <channelgroup id> <message>\n!pokeservergroup <servergroup id> <message>\n!removeservergroups <client database id>\n!removechannelgroups <client database id>\n!searchclient <nickname>\n!searchdesc <description>\n!searchip <ip address>\n!setchannelgroup <client database id> <channel group id> <channel list separated with comma>\n!setchannelname <channel id> <new channel name>");
                }
                if (isFullAdmin || isAdmin) {
                    helpTextBotAdmin.append("You can also use the following bot admin commands:\n!botcfghelp [config key]\n!botcfgget <config key>\n!botcfgset <config key> = <config value>\n!botcfgcheck\n!botcfgreload\n!botcfgsave\n!botconfirmerrors\n!botfunctionlist\n!botfunctioninfo <prefix>\n!botfunctionactivate <prefix>\n!botfunctiondisable <prefix>\n!botjoinchannel <channel id>\n!botlog\n!botreload\n!botrename <new name>\n!botversioncheck");
                }
                if (isFullAdmin) {
                    helpTextFullAdmin.append("You can also use the following full admin commands:\n!botinstancestart <name>\n!botinstancestop <name>\n!botinstancelist\n!botinstancelistreload\n!botinstancename\n!botreloadall\n!botquit");
                }
                if (isFullAdmin && this.manager.isCommandExecAllowed()) {
                    helpTextFullAdmin.append("\n!exec <system command>\n!execwait <system command>");
                }
                String lastMessage = "\n\nTo get a help about the commands, just do !bothelp <command>";
                if (isFullAdmin || isAdmin) {
                    if (this.modClass.getUTF8Length(String.valueOf(helpText.toString()) + "\n\n" + helpTextAdmin.toString()) > 1024) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, helpText.toString());
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, helpTextAdmin.toString());
                    } else {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, String.valueOf(helpText.toString()) + "\n\n" + helpTextAdmin.toString());
                    }
                    if (isFullAdmin) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, String.valueOf(helpTextBotAdmin.toString()) + "\n\n" + helpTextFullAdmin.toString() + lastMessage);
                    } else {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, String.valueOf(helpTextBotAdmin.toString()) + lastMessage);
                    }
                } else if (this.modClass.isLightAdmin(eventInfo.get("invokerid"))) {
                    if (this.modClass.getUTF8Length(String.valueOf(helpText.toString()) + "\n\n" + helpTextAdmin.toString() + lastMessage) > 1024) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, helpText.toString());
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, String.valueOf(helpTextAdmin.toString()) + lastMessage);
                    } else {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, String.valueOf(helpText.toString()) + "\n\n" + helpTextAdmin.toString() + lastMessage);
                    }
                } else {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, String.valueOf(helpText.toString()) + lastMessage);
                }
            } else {
                String args = arguments.toLowerCase();
                if (args.length() < 3) {
                    this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Wrong usage! Right: !bothelp <command>");
                } else {
                    if (args.charAt(0) == '!') {
                        args = args.substring(1);
                    }
                    String helpText = null;
                    if (args.equals("botinfo") || args.equals("info")) {
                        helpText = "Shows you the running bot version and uptime. It also displays the current bot admin permission level.";
                    } else if (args.equals("botlog")) {
                        helpText = "Shows you the location of the bot log.";
                    } else if (args.equals("botquit") || args.equals("quit") || args.equals("exit")) {
                        helpText = "Disconnect and quits all virtual bot instances.";
                    } else if (args.equals("botreload") || args.equals("reconnect")) {
                        helpText = "Disconnects the current virtual bot instance, reload bot configuration and start the virtual bot instance again. Bot configuration will be checked first!";
                    } else if (args.equals("botreloadall")) {
                        helpText = "Disconnects all virtual bot instances, reload bot configuration and start all virtual bot instances again. This command do not check bot configuration first!";
                    } else if (args.equals("botversioncheck") || args.equals("botversion") || args.equals("version")) {
                        helpText = "Displays current installed, latest final and latest development (if exists) versions of this bot.";
                    } else if (args.equals("botcfghelp")) {
                        helpText = "Returns information about a config key. If no key argument given, a list of config keys will be returned.\nExample: !botcfghelp bot_channel_id";
                    } else if (args.equals("botcfgget")) {
                        helpText = "Returns the value of a current config key.\nExample: !botcfgget bot_channel_id";
                    } else if (args.equals("botcfgset")) {
                        helpText = "Set a new value for a config key. Notice: You have to save and reload the bot configuration to see the changes!\nExample: !botcfgset bot_channel_id = -1";
                    } else if (args.equals("botcfgcheck")) {
                        helpText = "Check if current config (for example after !botcfgset) is valid.";
                    } else if (args.equals("botcfgreload")) {
                        helpText = "Reloads the bot configuration. You can use a function name as argument to reload only that configuration of that function.";
                    } else if (args.equals("botcfgsave")) {
                        helpText = "Saves current bot configuration.";
                    } else if (args.equals("botconfirmerrors") || args.equals("confirmerrors")) {
                        helpText = "Resets the exception error counter, if you solved the configuration error without restarting the bot.";
                    } else if (args.equals("botfunctionlist") || args.equals("functionlist")) {
                        helpText = "Get a list of currently loaded functions.";
                    } else if (args.equals("botfunctioninfo") || args.equals("functioninfo")) {
                        helpText = "Return a short information about the function.\nUsage: !botfunctioninfo <function prefix>";
                    } else if (args.equals("botfunctionactivate") || args.equals("functionon")) {
                        helpText = "Activate the given function.\nUsage: !botfunctionactivate <function prefix>";
                    } else if (args.equals("botfunctiondisable") || args.equals("functionoff")) {
                        helpText = "Disable the given function.\nUsage: !botfunctiondisable <function prefix>";
                    } else if (args.equals("clientsearch") || args.equals("clients") || args.equals("clientlist") || args.equals("searchclient")) {
                        helpText = "Shows some database information of a client. Search using the client name (* as a wildcard possible). You can also search using the complete unique id.\nExample: !clientsearch *foo*bar*";
                    } else if (args.equals("searchip")) {
                        helpText = "Shows some database information of a client found using ip address. Use * as a wildcard. The client database list cache needs to be enabled in the main bot configuration!\nExample: !searchip 127.0.*";
                    } else if (args.equals("searchdesc") || args.equals("searchdescription")) {
                        helpText = "Shows some database information of a client found using the client description. Use * as a wildcard. The client database list cache needs to be enabled in the main bot configuration!\nExample: !searchip *foo*bar*";
                    } else if (args.equals("listinactiveclients") || args.equals("inactiveclients")) {
                        helpText = "List all clients which are inactive since X days. Without argument the most inactive clients will be displayed. The client database list cache needs to be enabled in the main bot configuration!\nUsage: !listinactiveclients [minimum days inactive]";
                    } else if (args.equals("listinactivechannels") || args.equals("emptychannels")) {
                        helpText = "List of empty channels sorted by empty since time. Optionally you can add a channel name or channel id to this command to filter the list. You can use nospacer as first argument to ignore spacer channels in this list.\nUsage: !listinactivechannels [nospacer] [channel id or part of the channel name]";
                    } else if (args.equals("botinstancestart")) {
                        helpText = "Starts a virtual bot instance with the given name.\nUsage: !botinstancestart <name>";
                    } else if (args.equals("botinstancestop")) {
                        helpText = "Stops a virtual bot instance with the given name. If no name given, the current instance will be stopped.\nUsage: !botinstancestop [name]";
                    } else if (args.equals("botinstancelist")) {
                        helpText = "Shows a list of all virtual bot instances with the current status.";
                    } else if (args.equals("botinstancelistreload")) {
                        helpText = "Reloads the bot list from the JTS3ServerMod configuration. This command also reloads the most settings from the JTS3ServerMod_InstanceManager.cfg file like the Bot Full Admin List or the exec command state.";
                    } else if (args.equals("botinstancename")) {
                        helpText = "Returns the name of the current instance.";
                    } else if (args.equals("setchannelname") || args.equals("renamechannel")) {
                        helpText = "Set a new channel name for the given channel id.\nUsage: !setchannelname <channel id> <new channel name>";
                    } else if (args.equals("getchannelid") || args.equals("channellist")) {
                        helpText = "Search for channel name to see the channel id or vice versa. The full channel name is not needed, just enter a part of the channel name.\nUsage: !getchannelid [channel id or part of the channel name]";
                    } else if (args.equals("setchannelgroup")) {
                        helpText = "Sets channel group to client to all specified channels! Separate all channels with a comma at the end of this command!\nUsage: !setchannelgroup <client database id or unique id> <channel group id> <channel list separated with comma>";
                    } else if (args.equals("removeservergroups")) {
                        helpText = "Removes all server groups of a client!\nUsage: !removeservergroups <client database id or unique id>";
                    } else if (args.equals("removechannelgroups")) {
                        helpText = "Sets all non-default channel groups of a client to the default channel group in all channels!\nUsage: !removechannelgroups <client database id or unique id>";
                    } else if (args.equals("listservergroups")) {
                        helpText = "Get a list of all server groups of a client! Without arguments you get a complete list of all server groups.\nUsage: !listservergroups [client database id or unique id]";
                    } else if (args.equals("listchannelgroups")) {
                        helpText = "Get a list of all channel groups of a client! Without arguments you get a complete list of all channel groups.\nUsage: !listchannelgroups [client database id or unique id]";
                    } else if (args.equals("msgall")) {
                        helpText = "Sends a private message to all online clients. You can use \u00a7+\u00a7 to split a message into multiple messages.\nUsage: !msgall <message>\nExample: !msgall Hello guys!";
                    } else if (args.equals("msgchannelgroup") || args.equals("msgchannelgroups")) {
                        helpText = "Sends a private message to all online clients with this specified channel groups at the moment. Multiple comma separated channel groups without spaces are possible. You can use \u00a7+\u00a7 to split a message into multiple messages.\nUsage: !msgchannelgroup <channelgroup id> <message>\nExample: !msgchannelgroup 8,5 Hello guys!";
                    } else if (args.equals("msgservergroup") || args.equals("msgservergroups")) {
                        helpText = "Sends a private message to all online clients that are member of the specified server groups. Multiple comma separated server groups without spaces are possible. You can use \u00a7+\u00a7 to split a message into multiple messages.\nUsage: !msgservergroup <servergroup id> <message>\nExample: !msgservergroup 6,7 Hello guys!";
                    } else if (args.equals("pokechannelgroup") || args.equals("pokechannelgroups")) {
                        helpText = "Sends a poke message to all online clients with this specified channel groups at the moment. Multiple comma separated channel groups without spaces are possible. You can use \u00a7+\u00a7 to split a message into multiple messages.\nUsage: !pokechannelgroup <channelgroup id> <message>\nExample: !pokechannelgroup 8,5 Hello guys!";
                    } else if (args.equals("pokeservergroup") || args.equals("pokeservergroups")) {
                        helpText = "Sends a poke message to all online clients that are member of the specified server groups. Multiple comma separated server groups without spaces are possible. You can use \u00a7+\u00a7 to split a message into multiple messages.\nUsage: !pokeservergroup <servergroup id> <message>\nExample: !pokeservergroup 6,7 Hello guys!";
                    } else if (args.equals("pokeall")) {
                        helpText = "Sends a poke message to all online clients. You can use \u00a7+\u00a7 to split a message into multiple messages.\nUsage: !pokeall <message>\nExample: !pokeall Hello guys!";
                    } else if (args.equals("botjoinchannel") || args.equals("joinchannel") || args.equals("botchannel")) {
                        helpText = "Switch the bot into another channel. Without argument, the current channel of the bot will be returned.\nUsage: !botjoinchannel [channel id]";
                    } else if (args.equals("botrename")) {
                        helpText = "Without argument bot renames back to default client name from bot config. Specify a client name as argument to set a new temporary client name for the bot.\nUsage: !botrename [new name]";
                    } else if (args.equals("exec")) {
                        helpText = "Executes the specified system command. This command don't return the text output, just fire and forget! For security reasons this command needs to be enabled at the JTS3ServerMod_InstanceManager.cfg file.\nUsage: !exec <system command>";
                    } else if (args.equals("execwait")) {
                        helpText = "Executes the specified system command and waits for process end. Program output and return code will be send as answer. For security reasons this command needs to be enabled at the JTS3ServerMod_InstanceManager.cfg file.\nUsage: !execwait <system command>";
                    }
                    if (helpText == null) {
                        helpText = this.modClass.getCommandHelp(args);
                    }
                    if (helpText == null) {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "No such command: [b]!" + args + "[/b]");
                    } else {
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, "Help of the command [b]!" + args + "[/b]:\n");
                        this.queryLib.sendTextMessage(Integer.parseInt(eventInfo.get("invokerid")), 1, helpText);
                    }
                }
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(e, false);
        }
    }

    private String getArguments(String command) {
        int pos = command.indexOf(" ");
        if (pos == -1) {
            return "";
        }
        return command.substring(pos).trim();
    }
}

