/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.util;

public class DatatypeConverter {
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();
    private static final char[] encodeMap = DatatypeConverter.initEncodeMap();
    private static final byte[] decodeMap = DatatypeConverter.initDecodeMap();
    private static final byte PADDING = 127;

    private static char[] initEncodeMap() {
        char[] map = new char[64];
        int i = 0;
        while (i < 26) {
            map[i] = (char)(65 + i);
            ++i;
        }
        i = 26;
        while (i < 52) {
            map[i] = (char)(97 + (i - 26));
            ++i;
        }
        i = 52;
        while (i < 62) {
            map[i] = (char)(48 + (i - 52));
            ++i;
        }
        map[62] = 43;
        map[63] = 47;
        return map;
    }

    private static byte[] initDecodeMap() {
        byte[] map = new byte[128];
        int i = 0;
        while (i < 128) {
            map[i] = -1;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            map[i] = (byte)(i - 65);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            map[i] = (byte)(i - 97 + 26);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            map[i] = (byte)(i - 48 + 52);
            ++i;
        }
        map[43] = 62;
        map[47] = 63;
        map[61] = 127;
        return map;
    }

    public static char encode(int i) {
        return encodeMap[i & 0x3F];
    }

    private static int guessLength(String text) {
        int padSize;
        int len = text.length();
        int j = len - 1;
        while (j >= 0) {
            byte code = decodeMap[text.charAt(j)];
            if (code != 127) {
                if (code != -1) break;
                return text.length() / 4 * 3;
            }
            --j;
        }
        if ((padSize = len - ++j) > 2) {
            return text.length() / 4 * 3;
        }
        return text.length() / 4 * 3 - padSize;
    }

    public static String printHexBinary(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
            ++n2;
        }
        return r.toString();
    }

    public static String printBase64Binary(byte[] input) {
        return DatatypeConverter.printBase64Binary(input, 0, input.length);
    }

    public static String printBase64Binary(byte[] input, int offset, int len) {
        char[] buf = new char[(len + 2) / 3 * 4];
        int ptr = DatatypeConverter.printBase64Binary(input, offset, len, buf, 0);
        assert (ptr == buf.length);
        return new String(buf);
    }

    public static int printBase64Binary(byte[] input, int offset, int len, char[] buf, int ptr) {
        int remaining = len;
        int i = offset;
        while (remaining >= 3) {
            buf[ptr++] = DatatypeConverter.encode(input[i] >> 2);
            buf[ptr++] = DatatypeConverter.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
            buf[ptr++] = DatatypeConverter.encode((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3);
            buf[ptr++] = DatatypeConverter.encode(input[i + 2] & 0x3F);
            remaining -= 3;
            i += 3;
        }
        if (remaining == 1) {
            buf[ptr++] = DatatypeConverter.encode(input[i] >> 2);
            buf[ptr++] = DatatypeConverter.encode((input[i] & 3) << 4);
            buf[ptr++] = 61;
            buf[ptr++] = 61;
        }
        if (remaining == 2) {
            buf[ptr++] = DatatypeConverter.encode(input[i] >> 2);
            buf[ptr++] = DatatypeConverter.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
            buf[ptr++] = DatatypeConverter.encode((input[i + 1] & 0xF) << 2);
            buf[ptr++] = 61;
        }
        return ptr;
    }

    public static byte[] parseBase64Binary(String text) {
        int buflen = DatatypeConverter.guessLength(text);
        byte[] out = new byte[buflen];
        int o = 0;
        int len = text.length();
        byte[] quadruplet = new byte[4];
        int q = 0;
        int i = 0;
        while (i < len) {
            char ch = text.charAt(i);
            byte v = decodeMap[ch];
            if (v != -1) {
                quadruplet[q++] = v;
            }
            if (q == 4) {
                out[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
                if (quadruplet[2] != 127) {
                    out[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
                }
                if (quadruplet[3] != 127) {
                    out[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
                }
                q = 0;
            }
            ++i;
        }
        if (buflen == o) {
            return out;
        }
        byte[] nb = new byte[o];
        System.arraycopy(out, 0, nb, 0, o);
        return nb;
    }
}

