/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleTS3Events;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.util.ArrangedPropertiesWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class ServerGroupNotify
implements HandleBotEvents,
HandleTS3Events,
LoadConfiguration {
    private String configPrefix = "";
    private JTS3ServerMod_Interface modClass = null;
    private JTS3ServerQuery queryLib = null;
    private boolean pluginEnabled = false;
    private Vector<Integer> SERVERGROUPNOTIFY_GROUPS = new Vector();
    private Vector<Integer> SERVERGROUPNOTIFY_GROUPTARGETS = new Vector();
    private Vector<String> SERVERGROUPNOTIFY_SHOWONCONNECTION = new Vector();
    private String SERVERGROUPNOTIFY_MESSAGE_MODE = null;
    private String SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE = null;
    private String SERVERGROUPNOTIFY_FILE = null;
    private String SERVERGROUPNOTIFY_MESSAGE = null;
    private String SERVERGROUPNOTIFY_MESSAGENOTIFIED = null;
    private String SERVERGROUPNOTIFY_MESSAGENOTNOTIFIED = null;
    private Vector<Integer> SERVERGROUPNOTIFY_CHANNEL_LIST = new Vector();
    private boolean SERVERGROUPNOTIFY_CHANNEL_LIST_IGNORE = true;

    @Override
    public void initClass(JTS3ServerMod_Interface modClass, JTS3ServerQuery queryLib, String prefix) {
        this.modClass = modClass;
        this.queryLib = queryLib;
        this.configPrefix = prefix.trim();
    }

    @Override
    public void handleOnBotConnect() {
        if (!this.pluginEnabled) {
            return;
        }
        StringBuffer groupTmp = new StringBuffer();
        for (int groupID : this.SERVERGROUPNOTIFY_GROUPS) {
            if (groupTmp.length() != 0) {
                groupTmp.append(", ");
            }
            groupTmp.append(groupID);
        }
        StringBuffer groupTmp2 = new StringBuffer();
        for (int groupID : this.SERVERGROUPNOTIFY_GROUPTARGETS) {
            if (groupTmp2.length() != 0) {
                groupTmp2.append(", ");
            }
            groupTmp2.append(groupID);
        }
        String msg = "Watching for new connecting clients of selected server groups (id: " + groupTmp.toString() + "), sending message to all online clients of server group ids: " + groupTmp2.toString();
        this.modClass.addLogEntry(this.configPrefix, (byte)1, msg, true);
    }

    @Override
    public void handleAfterCacheUpdate() {
    }

    @Override
    public void activate() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void unload() {
        this.SERVERGROUPNOTIFY_GROUPS = null;
        this.SERVERGROUPNOTIFY_GROUPTARGETS = null;
        this.SERVERGROUPNOTIFY_CHANNEL_LIST = null;
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter config) {
        config.addKey(String.valueOf(this.configPrefix) + "_groups", "A comma separated list (without spaces) of server group ids, which should be watched on joining.");
        config.addKey(String.valueOf(this.configPrefix) + "_grouptargets", "A comma separated list (without spaces) of server group ids, which should be notified about joining clients.");
        config.addKey(String.valueOf(this.configPrefix) + "_showonconnectionnumber", "A comma separated list (without spaces) of the total connection count (it's the same value as %CLIENT_TOTALCONNECTIONS% at the welcome message),\nwhen this message should be send to the clients. Set this to -1 to show it every time.\nRanges like 1-100, -20 (means 20 or less) or 100- (means 100 or more) are also possible.", "-1");
        config.addKey(String.valueOf(this.configPrefix) + "_channel_list", "A comma separated list (without spaces) of channel ids.\nDepends on the given mode, target clients in this channels can be ignored or only clients in this channels receive the notify message!\nIf no channels should be ignored, set no channels here and select the channel list mode ignore!");
        config.addKey(String.valueOf(this.configPrefix) + "_channel_list_mode", "Select one of the two modes for the channel list.\nignore = Clients in the selected channels will be ignored.\nonly = Only clients in the selected channels receive the notify message.", "ignore");
        config.addKey(String.valueOf(this.configPrefix) + "_message_mode", "Select the message mode, how the notified clients should get the message.\npoke, chat or none are valid values!", "poke");
        config.addKey(String.valueOf(this.configPrefix) + "_messagenotified_mode", "Select the message mode, how the clients (who joined the server) should get the message.\npoke, chat or none are valid values!", "none");
        if (this.modClass.getMySQLConnection() == null) {
            config.addKey(String.valueOf(this.configPrefix) + "_file", "Path to file which contains the server group notify message", "%apphome%config/server1/servergroupnotifymessages.cfg");
        }
        config.addKey(String.valueOf(this.configPrefix) + "_message", "Server Group Notify message, specified clients get this message as chat or poke message.\nYou can use the following keywords, which will be replaced:\n%SERVER_GROUP_ID% - Server Group ID\n%SERVER_GROUP_NAME% - Server Group Name\n%CLIENT_NAME% - Client Name\n%CLIENT_DBID% - Client Database ID\n%CLIENT_UNIQUEID% - Client Unique ID\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.", this.modClass.getMySQLConnection() != null);
        config.addKey(String.valueOf(this.configPrefix) + "_messagenotified", "Server Group Notify message for the watched client.\nIf enabled, clients with a watched server group connecting the server get this message as chat or poke message.\nYou can use the following keywords, which will be replaced:\n%CLIENT_COUNT% - Number of target group clients who get informed about this client\n%CLIENT_NAMES% - List of names of target group clients who get informed about this client\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.", this.modClass.getMySQLConnection() != null);
        config.addKey(String.valueOf(this.configPrefix) + "_messagenotnotified", "Server Group Notify message for the watched client, if no target group client is online\nIf enabled, clients with a watched server group connecting the server get this message as chat or poke message.\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.", this.modClass.getMySQLConnection() != null);
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter config, boolean slowMode) throws BotConfigurationException, NumberFormatException {
        this.pluginEnabled = false;
        if (slowMode) {
            this.modClass.addLogEntry(this.configPrefix, (byte)2, "Slow Mode is activated, if the bot gets banned by the TS3 server, you should disable the Server Group Notify!", true);
        }
        String lastNumberValue = "";
        String temp = null;
        try {
            StringTokenizer st;
            this.SERVERGROUPNOTIFY_FILE = config.getValue(String.valueOf(this.configPrefix) + "_file");
            this.SERVERGROUPNOTIFY_MESSAGE_MODE = config.getValue(String.valueOf(this.configPrefix) + "_message_mode", "chat").trim();
            this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE = config.getValue(String.valueOf(this.configPrefix) + "_messagenotified_mode", "chat").trim();
            String[] configKeys = new String[]{String.valueOf(this.configPrefix) + "_message", String.valueOf(this.configPrefix) + "_messagenotified", String.valueOf(this.configPrefix) + "_messagenotnotified"};
            if (!this.modClass.loadMessages(this.configPrefix, "_file", configKeys)) {
                throw new BotConfigurationException("Server Group Notify messages could not be loaded!");
            }
            this.SERVERGROUPNOTIFY_MESSAGE = config.getValue(configKeys[0]);
            if (this.SERVERGROUPNOTIFY_MESSAGE == null || this.SERVERGROUPNOTIFY_MESSAGE.length() == 0) {
                throw new BotConfigurationException("Server Group Notify message could not be loaded!");
            }
            if (this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE.equalsIgnoreCase("poke") || this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE.equalsIgnoreCase("chat")) {
                this.SERVERGROUPNOTIFY_MESSAGENOTIFIED = config.getValue(configKeys[1]);
                if (this.SERVERGROUPNOTIFY_MESSAGENOTIFIED == null || this.SERVERGROUPNOTIFY_MESSAGENOTIFIED.length() == 0) {
                    throw new BotConfigurationException("Server Group Notify message for the watched client missing in config!");
                }
                this.SERVERGROUPNOTIFY_MESSAGENOTNOTIFIED = config.getValue(configKeys[2]);
                if (this.SERVERGROUPNOTIFY_MESSAGENOTNOTIFIED == null || this.SERVERGROUPNOTIFY_MESSAGENOTNOTIFIED.length() == 0) {
                    throw new BotConfigurationException("Server Group Notify message for the watched client (if no target group client is online) missing in config!");
                }
            }
            this.SERVERGROUPNOTIFY_SHOWONCONNECTION.clear();
            temp = config.getValue(String.valueOf(this.configPrefix) + "_showonconnectionnumber", "-1");
            lastNumberValue = String.valueOf(this.configPrefix) + "_showonconnectionnumber";
            if (temp != null && temp.length() > 0) {
                st = new StringTokenizer(temp, ",", false);
                while (st.hasMoreTokens()) {
                    this.SERVERGROUPNOTIFY_SHOWONCONNECTION.addElement(st.nextToken().trim());
                }
            }
            temp = null;
            this.SERVERGROUPNOTIFY_GROUPS.clear();
            temp = config.getValue(String.valueOf(this.configPrefix) + "_groups");
            lastNumberValue = String.valueOf(this.configPrefix) + "_groups";
            if (temp != null && temp.length() > 0) {
                st = new StringTokenizer(temp, ",", false);
                while (st.hasMoreTokens()) {
                    this.SERVERGROUPNOTIFY_GROUPS.addElement(Integer.parseInt(st.nextToken().trim()));
                }
            }
            temp = null;
            this.SERVERGROUPNOTIFY_GROUPTARGETS.clear();
            temp = config.getValue(String.valueOf(this.configPrefix) + "_grouptargets");
            lastNumberValue = String.valueOf(this.configPrefix) + "_grouptargets";
            if (temp != null && temp.length() > 0) {
                st = new StringTokenizer(temp, ",", false);
                while (st.hasMoreTokens()) {
                    this.SERVERGROUPNOTIFY_GROUPTARGETS.addElement(Integer.parseInt(st.nextToken().trim()));
                }
            }
            temp = null;
            this.SERVERGROUPNOTIFY_CHANNEL_LIST.clear();
            temp = config.getValue(String.valueOf(this.configPrefix) + "_channel_list");
            lastNumberValue = String.valueOf(this.configPrefix) + "_channel_list";
            if (temp != null && temp.length() > 0) {
                st = new StringTokenizer(temp, ",", false);
                while (st.hasMoreTokens()) {
                    this.SERVERGROUPNOTIFY_CHANNEL_LIST.addElement(Integer.parseInt(st.nextToken().trim()));
                }
            }
            boolean bl = this.SERVERGROUPNOTIFY_CHANNEL_LIST_IGNORE = !config.getValue(String.valueOf(this.configPrefix) + "_channel_list_mode", "ignore").trim().equalsIgnoreCase("only");
            if (this.SERVERGROUPNOTIFY_GROUPS.size() == 0 || this.SERVERGROUPNOTIFY_GROUPTARGETS.size() == 0) {
                throw new BotConfigurationException("No server groups in bot configuration set. Check config values of " + this.configPrefix + "_groups and " + this.configPrefix + "_grouptargets");
            }
            this.modClass.addTS3ServerEvent(this);
            this.pluginEnabled = true;
        }
        catch (NumberFormatException e) {
            NumberFormatException nfe = new NumberFormatException("Config value of \"" + lastNumberValue + "\" is not a number! Current value: " + config.getValue(lastNumberValue, "not set"));
            nfe.setStackTrace(e.getStackTrace());
            throw nfe;
        }
        return this.pluginEnabled;
    }

    @Override
    public void setListModes(BitSet listOptions) {
        listOptions.set(1);
        listOptions.set(4);
    }

    @Override
    public String[] botChatCommandList(HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        return null;
    }

    @Override
    public String botChatCommandHelp(String command) {
        return null;
    }

    @Override
    public boolean handleChatCommands(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        return false;
    }

    @Override
    public void handleTS3Events(String eventType, HashMap<String, String> eventInfo) {
        int groupID;
        Vector<HashMap<String, String>> clientList;
        if (!this.pluginEnabled) {
            return;
        }
        if (eventType.equals("notifycliententerview") && eventInfo.get("client_type").equals("0") && this.matchConnectionCount(eventInfo.get("clid")) && (clientList = this.modClass.getClientList()) != null && (groupID = this.modClass.getListedGroup(eventInfo.get("client_servergroups"), this.SERVERGROUPNOTIFY_GROUPS)) > 0) {
            Vector<String> targetClients = new Vector<String>();
            Vector<String> targetClients_UID = new Vector<String>();
            String sgName = this.modClass.getServerGroupName(groupID);
            String sgnMessage = new String(this.SERVERGROUPNOTIFY_MESSAGE);
            sgnMessage = sgnMessage.replace("%SERVER_GROUP_ID%", Integer.toString(groupID));
            sgnMessage = sgnMessage.replace("%SERVER_GROUP_NAME%", sgName == null ? "Unknown" : sgName);
            if (!this.modClass.isMessageLengthValid(this.SERVERGROUPNOTIFY_MESSAGE_MODE, sgnMessage = sgnMessage.replace("%CLIENT_NAME_CLICKABLE%", "[URL=client://0/" + eventInfo.get("client_unique_identifier") + "]" + eventInfo.get("client_nickname") + "[/URL]"))) {
                this.modClass.addLogEntry(this.configPrefix, (byte)2, "Server Group Notify message is to long! Make sure that " + this.SERVERGROUPNOTIFY_MESSAGE_MODE + " messages are not longer than " + Short.toString(this.modClass.getMaxMessageLength(this.SERVERGROUPNOTIFY_MESSAGE_MODE)) + " characters (including spaces and BBCode), check file: " + this.SERVERGROUPNOTIFY_FILE, true);
            }
            int clientID = -1;
            for (HashMap<String, String> clientInfo : clientList) {
                if (!clientInfo.get("client_type").equals("0") || !this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.SERVERGROUPNOTIFY_GROUPTARGETS)) continue;
                boolean result = this.modClass.isIDListed(Integer.parseInt(clientInfo.get("cid")), this.SERVERGROUPNOTIFY_CHANNEL_LIST);
                if (!(this.SERVERGROUPNOTIFY_CHANNEL_LIST_IGNORE ? !result : result)) continue;
                clientID = Integer.parseInt(clientInfo.get("clid"));
                if (!this.SERVERGROUPNOTIFY_MESSAGE_MODE.equalsIgnoreCase("none") && !this.modClass.sendMessageToClient(this.configPrefix, this.SERVERGROUPNOTIFY_MESSAGE_MODE, clientID, this.createMessage(sgnMessage, eventInfo))) continue;
                targetClients.addElement(clientInfo.get("client_nickname"));
                targetClients_UID.addElement(clientInfo.get("client_unique_identifier"));
            }
            if (this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE.equalsIgnoreCase("poke") || this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE.equalsIgnoreCase("chat")) {
                clientID = Integer.parseInt(eventInfo.get("clid"));
                if (targetClients.size() == 0) {
                    if (!this.modClass.isMessageLengthValid(this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE, this.SERVERGROUPNOTIFY_MESSAGENOTNOTIFIED)) {
                        this.modClass.addLogEntry(this.configPrefix, (byte)2, "Server Group Notify message for the watched client (if no target group client is online) is to long! Make sure that " + this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE + " messages are not longer than " + Short.toString(this.modClass.getMaxMessageLength(this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE)) + " characters (including spaces and BBCode)" + (this.modClass.getMySQLConnection() == null ? ", check file: " + this.SERVERGROUPNOTIFY_FILE : "!"), true);
                    }
                    this.modClass.sendMessageToClient(this.configPrefix, this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE, clientID, this.createMessage(this.SERVERGROUPNOTIFY_MESSAGENOTNOTIFIED, eventInfo));
                } else {
                    StringBuffer sb = new StringBuffer();
                    StringBuffer sbURL = new StringBuffer();
                    int i = 0;
                    while (i < targetClients.size()) {
                        if (i > 0) {
                            sb.append(", ");
                            sbURL.append(", ");
                        }
                        sb.append((String)targetClients.elementAt(i));
                        sbURL.append("[URL=client://0/" + (String)targetClients_UID.elementAt(i) + "]" + (String)targetClients.elementAt(i) + "[/URL]");
                        ++i;
                    }
                    String cnMessageNotified = new String(this.SERVERGROUPNOTIFY_MESSAGENOTIFIED);
                    cnMessageNotified = cnMessageNotified.replace("%CLIENT_COUNT%", Integer.toString(targetClients.size()));
                    cnMessageNotified = cnMessageNotified.replace("%CLIENT_NAMES%", sb.toString());
                    if (!this.modClass.isMessageLengthValid(this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE, cnMessageNotified = cnMessageNotified.replace("%CLIENT_NAMES_CLICKABLE%", sbURL.toString()))) {
                        this.modClass.addLogEntry(this.configPrefix, (byte)2, "Server Group Notify message for the watched client is to long! Make sure that " + this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE + " messages are not longer than " + Short.toString(this.modClass.getMaxMessageLength(this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE)) + " characters (including spaces and BBCode)" + (this.modClass.getMySQLConnection() == null ? ", check file: " + this.SERVERGROUPNOTIFY_FILE : "!"), true);
                    }
                    this.modClass.sendMessageToClient(this.configPrefix, this.SERVERGROUPNOTIFY_MESSAGENOTIFIED_MODE, clientID, this.createMessage(cnMessageNotified, eventInfo));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchConnectionCount(String clientID) {
        try {
            HashMap<String, String> clientInfo;
            if (this.SERVERGROUPNOTIFY_SHOWONCONNECTION.indexOf("-1") != -1) return true;
            try {
                clientInfo = this.queryLib.getInfo(13, Integer.parseInt(clientID));
                if (clientInfo == null) {
                    throw new NullPointerException("Invalid client information returned!");
                }
            }
            catch (Exception e) {
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Error while requesting information of client id " + clientID + " from TS3 server!", false);
                this.modClass.addLogEntry(this.configPrefix, e, false);
                return false;
            }
            if (clientInfo.get("client_totalconnections") == null) {
                this.modClass.addLogEntry(this.configPrefix, new NullPointerException("Got no client_totalconnections value from TS3 server!"), false);
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= this.SERVERGROUPNOTIFY_SHOWONCONNECTION.size()) {
                    return false;
                }
                int currentValue = Integer.parseInt(clientInfo.get("client_totalconnections"));
                String value = this.SERVERGROUPNOTIFY_SHOWONCONNECTION.elementAt(i);
                int pos = value.indexOf("-");
                if (pos != -1) {
                    int firstNumber = 0;
                    int secondNumber = Integer.MAX_VALUE;
                    if (pos > 0) {
                        firstNumber = Integer.parseInt(value.substring(0, pos).trim());
                    }
                    if (pos < value.length() - 1) {
                        secondNumber = Integer.parseInt(value.substring(pos + 1).trim());
                    }
                    if (currentValue >= firstNumber && currentValue <= secondNumber) {
                        return true;
                    }
                } else if (currentValue == Integer.parseInt(value)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(this.configPrefix, e, false);
            return false;
        }
    }

    private String createMessage(String template, HashMap<String, String> clientInfo) {
        String message = null;
        try {
            message = template;
            if (clientInfo.get("cid") != null) {
                message = message.replace("%CLIENT_ID%", clientInfo.get("cid"));
            }
            if (clientInfo.get("client_nickname") != null) {
                message = message.replace("%CLIENT_NAME%", clientInfo.get("client_nickname"));
            }
            if (clientInfo.get("client_database_id") != null) {
                message = message.replace("%CLIENT_DBID%", clientInfo.get("client_database_id"));
            }
            if (clientInfo.get("client_unique_identifier") != null) {
                message = message.replace("%CLIENT_UNIQUEID%", clientInfo.get("client_unique_identifier"));
            }
            if (clientInfo.get("client_country") != null) {
                message = message.replace("%CLIENT_COUNTRY%", clientInfo.get("client_country") == "" ? "unknown" : (CharSequence)clientInfo.get("client_country"));
            }
            if (clientInfo.get("client_version") != null) {
                message = message.replace("%CLIENT_VERSION%", this.modClass.getVersionString(clientInfo.get("client_version")));
            }
            if (clientInfo.get("client_platform") != null) {
                message = message.replace("%CLIENT_PLATFORM%", clientInfo.get("client_platform"));
            }
            if (clientInfo.get("connection_client_ip") != null) {
                message = message.replace("%CLIENT_IP%", clientInfo.get("connection_client_ip"));
            }
            if (clientInfo.get("client_created") != null) {
                message = message.replace("%CLIENT_CREATED%", this.modClass.getStringFromTimestamp(Long.parseLong(clientInfo.get("client_created")) * 1000L));
            }
            if (clientInfo.get("client_totalconnections") != null) {
                message = message.replace("%CLIENT_TOTALCONNECTIONS%", clientInfo.get("client_totalconnections"));
            }
            if (clientInfo.get("client_month_bytes_uploaded") != null) {
                message = message.replace("%CLIENT_MONTH_BYTES_UPLOADED%", this.modClass.getFileSizeString(Long.parseLong(clientInfo.get("client_month_bytes_uploaded")), false));
            }
            if (clientInfo.get("client_month_bytes_downloaded") != null) {
                message = message.replace("%CLIENT_MONTH_BYTES_DOWNLOADED%", this.modClass.getFileSizeString(Long.parseLong(clientInfo.get("client_month_bytes_downloaded")), false));
            }
            if (clientInfo.get("client_total_bytes_uploaded") != null) {
                message = message.replace("%CLIENT_TOTAL_BYTES_UPLOADED%", this.modClass.getFileSizeString(Long.parseLong(clientInfo.get("client_total_bytes_uploaded")), false));
            }
            if (clientInfo.get("client_total_bytes_downloaded") != null) {
                message = message.replace("%CLIENT_TOTAL_BYTES_DOWNLOADED%", this.modClass.getFileSizeString(Long.parseLong(clientInfo.get("client_total_bytes_downloaded")), false));
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(this.configPrefix, e, false);
            message = null;
        }
        return message;
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Server Group Notify function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }
}

