/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.FunctionExceptionLog;
import de.stefan1200.jts3servermod.interfaces.ClientDatabaseCache_Interface;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3servermod.interfaces.ServerInfoCache_Interface;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.Vector;

public class InactiveClientsCleaner
implements HandleBotEvents,
LoadConfiguration {
    private String configPrefix = "";
    private JTS3ServerMod_Interface modClass = null;
    private JTS3ServerQuery queryLib = null;
    private ClientDatabaseCache_Interface clientCache = null;
    private boolean pluginEnabled = false;
    private int inactivityDays = 180;
    private Vector<Integer> groupList = new Vector();
    private boolean groupListIgnore = true;
    private TimerTask timerICC = null;
    private FunctionExceptionLog fel = new FunctionExceptionLog();

    @Override
    public void initClass(JTS3ServerMod_Interface modClass, JTS3ServerQuery queryLib, String prefix) {
        this.modClass = modClass;
        this.queryLib = queryLib;
        this.configPrefix = prefix.trim();
    }

    @Override
    public void handleOnBotConnect() {
        if (!this.pluginEnabled) {
            return;
        }
        String msg = "Delete clients from Teamspeak 3 database after being inactive for at least " + Integer.toString(this.inactivityDays) + " days.";
        if (!this.groupListIgnore || this.groupList.size() > 0) {
            msg = String.valueOf(msg) + " Only members of " + Integer.toString(this.groupList.size()) + " specified server groups will " + (this.groupListIgnore ? "not " : "") + "be deleted.";
        }
        this.modClass.addLogEntry(this.configPrefix, (byte)1, msg, true);
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter config) {
        config.addKey(String.valueOf(this.configPrefix) + "_inactivity_days", "How many days a client has to be inactive to get deleted from the TS3 server database?\nPossible values are between 30 and 730.\nNotice: After the client was deleted, the client can connect again to the server, but all permissions are lost!", "180");
        config.addKey(String.valueOf(this.configPrefix) + "_group_list", "A comma separated list (without spaces) of server group ids.\nDepends on the given mode, this server groups can be ignored or only this server groups will be checked!\nIf no server groups should be ignored, set no server groups here and select the group list mode ignore!");
        config.addKey(String.valueOf(this.configPrefix) + "_group_list_mode", "Select one of the two modes for the server group list.\nignore = The selected server groups will be ignored.\nonly = Only the selected server groups will be checked.", "ignore");
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter config, boolean slowMode) throws BotConfigurationException, NumberFormatException {
        String lastNumberValue = "";
        String temp = null;
        this.pluginEnabled = false;
        if (!this.modClass.isLocalClientDatabaseCacheEnabled()) {
            throw new BotConfigurationException("The local Client Database Cache of the JTS3ServerMod must be enabled to use this function!");
        }
        try {
            lastNumberValue = String.valueOf(this.configPrefix) + "_inactivity_days";
            temp = config.getValue(String.valueOf(this.configPrefix) + "_inactivity_days");
            if (temp == null) {
                throw new NumberFormatException();
            }
            this.inactivityDays = Integer.parseInt(temp.trim());
            if (this.inactivityDays < 30) {
                this.inactivityDays = 30;
            } else if (this.inactivityDays > 730) {
                this.inactivityDays = 730;
            }
            temp = null;
            this.groupList.clear();
            temp = config.getValue(String.valueOf(this.configPrefix) + "_group_list");
            lastNumberValue = String.valueOf(this.configPrefix) + "_group_list";
            if (temp != null && temp.length() > 0) {
                StringTokenizer st = new StringTokenizer(temp, ",", false);
                while (st.hasMoreTokens()) {
                    this.groupList.addElement(Integer.parseInt(st.nextToken().trim()));
                }
            }
            boolean bl = this.groupListIgnore = !config.getValue(String.valueOf(this.configPrefix) + "_group_list_mode", "ignore").trim().equalsIgnoreCase("only");
            if (!this.groupListIgnore && this.groupList.size() == 0) {
                throw new BotConfigurationException("An empty group list is not allowed while using the group list mode only!");
            }
            this.pluginEnabled = true;
        }
        catch (NumberFormatException e) {
            NumberFormatException nfe = new NumberFormatException("Config value of \"" + lastNumberValue + "\" is not a number! Current value: " + config.getValue(lastNumberValue, "not set"));
            nfe.setStackTrace(e.getStackTrace());
            throw nfe;
        }
        return this.pluginEnabled;
    }

    @Override
    public void setListModes(BitSet listOptions) {
    }

    @Override
    public void handleAfterCacheUpdate() {
    }

    @Override
    public void activate() {
        if (!this.pluginEnabled) {
            return;
        }
        if (this.timerICC != null) {
            this.timerICC.cancel();
        }
        this.timerICC = null;
        this.timerICC = new TimerTask(){

            @Override
            public void run() {
                InactiveClientsCleaner.this.checkInactiveClients();
            }
        };
        this.modClass.addBotTimer(this.timerICC, 86400000L, 86400000L);
    }

    @Override
    public void disable() {
        if (this.timerICC != null) {
            this.timerICC.cancel();
        }
        this.timerICC = null;
    }

    @Override
    public void unload() {
        this.groupList = null;
        this.fel = null;
    }

    private void checkInactiveClients() {
        if (this.clientCache == null) {
            this.clientCache = this.modClass.getClientCache();
            if (this.clientCache == null) {
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "The local Client Database Cache of the JTS3ServerMod must be enabled to use this function!", true);
                this.pluginEnabled = false;
                this.modClass.unloadFunction(this);
                return;
            }
        }
        int count = 0;
        Vector<Integer> sgList = null;
        Vector<HashMap<String, Integer>> cldbidList = this.clientCache.searchInactiveClients(this.inactivityDays, -1);
        this.modClass.addLogEntry(this.configPrefix, (byte)1, "Start checking " + Integer.toString(cldbidList.size()) + " clients, which are already inactive for at least " + Integer.toString(this.inactivityDays) + " days!", false);
        for (HashMap<String, Integer> client : cldbidList) {
            block16: {
                if (client.get("cldbid").equals(Integer.toString(this.queryLib.getCurrentQueryClientDatabaseID()))) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    break;
                }
                if (!this.groupListIgnore || this.groupList.size() > 0) {
                    try {
                        sgList = this.getServerGroupsFromClient(client.get("cldbid"));
                        this.fel.clearException(client.get("cldbid"));
                        boolean result = this.isGroupListed(sgList, this.groupList);
                        if (this.groupListIgnore) {
                            if (result) {
                                continue;
                            }
                        } else if (!result) {
                        }
                        break block16;
                    }
                    catch (TS3ServerQueryException sqe) {
                        if (sqe.getErrorID() == 512) {
                            this.clientCache.deleteClientFromCache(client.get("cldbid"));
                            continue;
                        }
                        if (this.fel.existsException(sqe, client.get("cldbid"))) continue;
                        this.fel.addException(sqe, client.get("cldbid"));
                        this.modClass.addLogEntry(this.configPrefix, (byte)2, "Can't request server groups for client db id " + Integer.toString(client.get("cldbid")) + "!", false);
                        if (sqe.getFailedPermissionID() < 0) {
                            this.modClass.addLogEntry(this.configPrefix, (byte)2, sqe.toString(), false);
                            continue;
                        }
                        this.modClass.addLogEntry(this.configPrefix, sqe, false);
                    }
                    catch (Exception e) {}
                    continue;
                }
            }
            this.clientCache.deleteClientFromCache(client.get("cldbid"));
            if (this.deleteClientFromTS3Database(client.get("cldbid"))) {
                ++count;
            }
            if (Thread.currentThread().isInterrupted()) break;
        }
        this.modClass.addLogEntry(this.configPrefix, (byte)1, "Deleted " + Integer.toString(count) + " inactive clients from the Teamspeak 3 database!", false);
    }

    private boolean deleteClientFromTS3Database(int cldbid) {
        HashMap<String, String> response = this.queryLib.doCommand("clientdbdelete cldbid=" + Integer.toString(cldbid));
        if (response.get("id").equals("0")) {
            this.fel.clearException(cldbid);
            return true;
        }
        try {
            throw new TS3ServerQueryException("ServerGroupProtection", response.get("id"), response.get("msg"), response.get("extra_msg"), response.get("failed_permid"));
        }
        catch (TS3ServerQueryException sqe) {
            if (!this.fel.existsException(sqe, cldbid)) {
                this.fel.addException(sqe, cldbid);
                this.modClass.addLogEntry(this.configPrefix, (byte)3, "Error while deleting inactive client db id " + Integer.toString(cldbid) + " from the Teamspeak 3 database!", false);
                if (sqe.getFailedPermissionID() < 0) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)3, sqe.toString(), false);
                } else {
                    this.modClass.addLogEntry(this.configPrefix, sqe, false);
                }
            }
            return false;
        }
    }

    private boolean isGroupListed(Vector<Integer> groupIDs, Vector<Integer> list) {
        for (int groupID : groupIDs) {
            for (int gID : list) {
                if (groupID != gID) continue;
                return true;
            }
        }
        return false;
    }

    private Vector<Integer> getServerGroupsFromClient(int clientDBIDArg) throws NumberFormatException, TS3ServerQueryException {
        Vector<Integer> serverGroupList = new Vector<Integer>();
        Vector<HashMap<String, String>> serverGroupClientList = this.queryLib.getList(10, "cldbid=" + Integer.toString(clientDBIDArg));
        ServerInfoCache_Interface serverInfoCache = this.modClass.getServerInfoCache();
        int defsgid = serverInfoCache.getServerDefaultServerGroup();
        for (HashMap<String, String> hashMap : serverGroupClientList) {
            if (defsgid == Integer.parseInt(hashMap.get("sgid"))) continue;
            serverGroupList.addElement(Integer.parseInt(hashMap.get("sgid")));
        }
        return serverGroupList;
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Inactive Clients Cleaner function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }
}

