/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod;

import de.stefan1200.jts3servermod.InstanceManager;
import de.stefan1200.jts3servermod.JTS3ServerMod;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.MySQLConnect;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class MyLogger {
    private HashMap<Integer, String> logSettingList = new HashMap();
    private HashMap<Integer, Byte> logLevelSettingList = new HashMap();
    private HashMap<Integer, String> instanceNameList = new HashMap();
    private HashMap<Integer, PrintStream> fileStreamList = new HashMap();
    private HashMap<Integer, JTS3ServerMod> botClassList = new HashMap();
    private SimpleDateFormat sdfDebug = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private MySQLConnect mysqlConnect = null;
    private InstanceManager manager = null;
    private PreparedStatement pstAddLog = null;
    private PreparedStatement pstDelLog = null;
    private PreparedStatement pstDelConnectionLog = null;

    public MyLogger(MySQLConnect mysqlConnect, InstanceManager manager) {
        this.mysqlConnect = mysqlConnect;
        this.manager = manager;
        this.initDB();
    }

    SimpleDateFormat getSDFDebug() {
        return this.sdfDebug;
    }

    boolean initDB() {
        if (this.mysqlConnect == null) {
            return false;
        }
        if (this.pstAddLog != null) {
            return true;
        }
        try {
            this.mysqlConnect.connect();
            this.pstAddLog = this.mysqlConnect.getPreparedStatement("INSERT INTO jts3servermod_log (instance_id, logtime, logtype, functionname, message) VALUES (?, ?, ?, ?, ?)");
            this.pstDelLog = this.mysqlConnect.getPreparedStatement("DELETE FROM jts3servermod_log WHERE logtype != 'CLIENT_CONNECTED' AND logtime < ?");
            this.pstDelConnectionLog = this.mysqlConnect.getPreparedStatement("DELETE FROM jts3servermod_log WHERE logtype = 'CLIENT_CONNECTED' AND logtime < ?");
            this.manager.addLogEntry("LOGGER_SQL_CONNECT", "Successfully connected to MySQL server for logging!", true);
            return true;
        }
        catch (Exception e) {
            try {
                this.mysqlConnect.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.manager.addLogEntry("LOGGER_SQL_ERROR", "Critical: Cannot connect to MySQL server for logging!", true);
            this.manager.addLogEntry(e);
            this.pstAddLog = null;
            this.pstDelLog = null;
            this.pstDelConnectionLog = null;
            return false;
        }
    }

    public void addLogInstance(int instanceID, String instanceName, String logSetting, byte logLevel) {
        if (instanceName == null) {
            return;
        }
        if (logSetting != null && !logSetting.equals("sql")) {
            String errorMessage = null;
            File logFileCheck = new File(logSetting);
            try {
                if (logFileCheck.exists()) {
                    File oldLogFileCheck = new File(String.valueOf(logSetting) + ".old");
                    if (oldLogFileCheck.exists()) {
                        if (oldLogFileCheck.delete()) {
                            if (!logFileCheck.renameTo(oldLogFileCheck)) {
                                errorMessage = "Unable to rename file " + logSetting + " to " + logSetting + ".old";
                            }
                        } else {
                            errorMessage = "Unable to delete file " + logSetting + ".old";
                        }
                    } else if (!logFileCheck.renameTo(oldLogFileCheck)) {
                        errorMessage = "Unable to rename file " + logSetting + " to " + logSetting + ".old";
                    }
                }
            }
            catch (Exception e) {
                errorMessage = e.toString();
            }
            try {
                this.fileStreamList.put(instanceID, new PrintStream((OutputStream)new FileOutputStream(logSetting, true), true, "UTF-8"));
                System.out.println(String.valueOf(instanceName) + ": Writing bot log file to: " + logFileCheck.getAbsolutePath());
                if (errorMessage != null) {
                    this.addLogEntry(instanceID, null, (byte)3, "Error while checking old logfile: " + errorMessage, false);
                }
            }
            catch (Exception e) {
                this.fileStreamList.put(instanceID, null);
                System.out.println(String.valueOf(instanceName) + ": Error while creating log file, please check write permissions at path: " + logFileCheck.getAbsolutePath());
                System.out.println(String.valueOf(instanceName) + ": Error message: " + e.toString());
            }
        }
        this.botClassList.put(instanceID, null);
        this.instanceNameList.put(instanceID, instanceName);
        this.logSettingList.put(instanceID, logSetting);
        this.logLevelSettingList.put(instanceID, logLevel);
    }

    public boolean updateLogInstanceClass(int instanceID, JTS3ServerMod botClass) {
        if (this.instanceNameList.get(instanceID) == null) {
            return false;
        }
        this.botClassList.put(instanceID, botClass);
        return true;
    }

    public boolean updateLogLevel(int instanceID, byte newLogLevel) {
        if (this.logLevelSettingList.get(instanceID) == null) {
            return false;
        }
        this.logLevelSettingList.put(instanceID, newLogLevel);
        return true;
    }

    public boolean updateBotName(int instanceID, String newBotName) {
        if (this.instanceNameList.get(instanceID) == null) {
            return false;
        }
        this.instanceNameList.put(instanceID, newBotName);
        return true;
    }

    public boolean removeLogInstance(int instanceID) {
        if (this.instanceNameList.get(instanceID) == null) {
            return false;
        }
        if (this.logSettingList.get(instanceID) != null && !this.logSettingList.get(instanceID).equals("sql") && this.fileStreamList.get(instanceID) != null) {
            this.fileStreamList.get(instanceID).close();
        }
        this.botClassList.remove(instanceID);
        this.instanceNameList.remove(instanceID);
        this.logSettingList.remove(instanceID);
        this.logLevelSettingList.remove(instanceID);
        this.fileStreamList.remove(instanceID);
        return true;
    }

    public void clearAllLogInstances() {
        this.botClassList.clear();
        this.instanceNameList.clear();
        this.logSettingList.clear();
        this.logLevelSettingList.clear();
        this.fileStreamList.clear();
    }

    public void deleteLogEntries(int days, boolean doReconnect) {
        block6: {
            if (days <= 0) {
                return;
            }
            if (this.pstDelLog == null) {
                return;
            }
            try {
                this.pstDelLog.setLong(1, System.currentTimeMillis() - 86400000L * (long)days);
                int delCount = this.pstDelLog.executeUpdate();
                this.manager.addLogEntry("LOGGER_DELETE_LOG", "Deleted " + Integer.toString(delCount) + " log entries successfully!", false);
            }
            catch (Exception e) {
                try {
                    this.mysqlConnect.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pstAddLog = null;
                this.pstDelLog = null;
                this.pstDelConnectionLog = null;
                this.manager.addLogEntry("LOGGER_SQL_ERROR", "Critical: Cannot delete log entry at MySQL server!", true);
                this.manager.addLogEntry(e);
                if (!doReconnect) break block6;
                this.manager.addLogEntry("LOGGER_SQL_ERROR", "Try to reconnect to MySQL server...", true);
                if (!this.initDB()) break block6;
                this.deleteLogEntries(days, false);
            }
        }
    }

    public void deleteConnectionLogEntries(int days, boolean doReconnect) {
        block6: {
            if (days <= 0) {
                return;
            }
            if (this.pstDelConnectionLog == null) {
                return;
            }
            try {
                this.pstDelConnectionLog.setLong(1, System.currentTimeMillis() - 86400000L * (long)days);
                int delCount = this.pstDelConnectionLog.executeUpdate();
                this.manager.addLogEntry("LOGGER_DELETE_LOG", "Deleted " + Integer.toString(delCount) + " connection log entries successfully!", false);
            }
            catch (Exception e) {
                try {
                    this.mysqlConnect.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pstAddLog = null;
                this.pstDelLog = null;
                this.pstDelConnectionLog = null;
                this.manager.addLogEntry("LOGGER_SQL_ERROR", "Critical: Cannot delete log entry at MySQL server!", true);
                this.manager.addLogEntry(e);
                if (!doReconnect) break block6;
                this.manager.addLogEntry("LOGGER_SQL_ERROR", "Try to reconnect to MySQL server...", true);
                if (!this.initDB()) break block6;
                this.deleteConnectionLogEntries(days, false);
            }
        }
    }

    private synchronized void addSQLEntry(int instanceID, String functionName, String type, String msg, boolean doReconnect) {
        block5: {
            if (this.pstAddLog == null) {
                return;
            }
            try {
                this.pstAddLog.setInt(1, instanceID);
                this.pstAddLog.setLong(2, System.currentTimeMillis());
                this.pstAddLog.setString(3, type.toUpperCase());
                this.pstAddLog.setString(4, functionName);
                this.pstAddLog.setString(5, msg);
                this.pstAddLog.executeUpdate();
            }
            catch (Exception e) {
                try {
                    this.mysqlConnect.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pstAddLog = null;
                this.pstDelLog = null;
                this.pstDelConnectionLog = null;
                this.manager.addLogEntry("LOGGER_SQL_ERROR", "Critical: Cannot write log entry to MySQL server!", true);
                this.manager.addLogEntry(e);
                if (!doReconnect) break block5;
                this.manager.addLogEntry("LOGGER_SQL_ERROR", "Try to reconnect to MySQL server...", true);
                if (!this.initDB()) break block5;
                this.addSQLEntry(instanceID, functionName, type, msg, false);
            }
        }
    }

    void addLogEntry(int instanceID, String functionName, byte type, String msg, boolean outputToSystemOut) {
        String instanceName = this.instanceNameList.get(instanceID);
        if (msg == null) {
            System.err.println(String.valueOf(this.sdfDebug.format(new Date(System.currentTimeMillis()))) + "\t" + "Unknown logging error at bot \"" + instanceName + "\": " + (type == 66 ? "CLIENT_CONNECTED" : JTS3ServerMod.ERROR_LEVEL_NAMES[type]));
            try {
                throw new NullPointerException("Please send this information to info@stefan1200.de");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            if (type < this.logLevelSettingList.get(instanceID)) {
                return;
            }
            String logSetting = this.logSettingList.get(instanceID);
            if (outputToSystemOut || logSetting == null) {
                System.out.println(String.valueOf(instanceName) + (functionName == null ? "" : " / " + functionName) + ": " + msg);
            }
            if (logSetting != null && !logSetting.equals("sql")) {
                if (this.fileStreamList.get(instanceID) != null) {
                    this.fileStreamList.get(instanceID).println(String.valueOf(this.sdfDebug.format(new Date(System.currentTimeMillis()))) + "\t" + (functionName == null ? "JTS3ServerMod" : "Function " + functionName) + "\t" + (type == 66 ? "CLIENT_CONNECTED" : JTS3ServerMod.ERROR_LEVEL_NAMES[type]) + "\t" + msg);
                }
            } else if (logSetting != null && logSetting.equals("sql")) {
                this.addSQLEntry(instanceID, functionName == null ? "JTS3ServerMod" : functionName, type == 66 ? "CLIENT_CONNECTED" : JTS3ServerMod.ERROR_LEVEL_NAMES[type], msg, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addLogEntry(int instanceID, String functionName, Throwable e, boolean outputToSystemOut, JTS3ServerMod modClass) {
        String instanceName = this.instanceNameList.get(instanceID);
        try {
            String permissionName;
            String logSetting = this.logSettingList.get(instanceID);
            if (outputToSystemOut || logSetting == null) {
                System.out.println(String.valueOf(this.sdfDebug.format(new Date(System.currentTimeMillis()))) + "\t" + instanceName + ": " + e.toString());
            }
            String permissionMsg = null;
            if (e instanceof TS3ServerQueryException && ((TS3ServerQueryException)e).getFailedPermissionID() >= 0 && (permissionName = modClass.getPermissionName(((TS3ServerQueryException)e).getFailedPermissionID())) != null) {
                permissionMsg = "Missing permission or not enough power: " + permissionName;
                if (outputToSystemOut || logSetting == null) {
                    System.out.println(String.valueOf(instanceName) + (functionName == null ? "" : " / " + functionName) + ": " + permissionMsg);
                }
            }
            if (logSetting != null && !logSetting.equals("sql")) {
                if (this.fileStreamList.get(instanceID) != null) {
                    if (this.logLevelSettingList.get(instanceID) == 0) {
                        this.fileStreamList.get(instanceID).println(String.valueOf(this.sdfDebug.format(new Date(System.currentTimeMillis()))) + "\t" + (functionName == null ? "JTS3ServerMod" : "Function " + functionName) + "\t" + "EXCEPTION" + "\t" + "Bot Version: " + "6.5.8 Hosting Edition (16.12.2023)");
                        e.printStackTrace(this.fileStreamList.get(instanceID));
                        if (permissionMsg != null) {
                            this.fileStreamList.get(instanceID).println(String.valueOf(this.sdfDebug.format(new Date(System.currentTimeMillis()))) + "\t" + (functionName == null ? "JTS3ServerMod" : "Function " + functionName) + "\t" + JTS3ServerMod.ERROR_LEVEL_NAMES[3] + "\t" + permissionMsg);
                        }
                    } else {
                        this.fileStreamList.get(instanceID).println(String.valueOf(this.sdfDebug.format(new Date(System.currentTimeMillis()))) + "\t" + (functionName == null ? "JTS3ServerMod" : "Function " + functionName) + "\t" + "EXCEPTION" + "\t" + e.toString());
                        if (permissionMsg != null) {
                            this.fileStreamList.get(instanceID).println(String.valueOf(this.sdfDebug.format(new Date(System.currentTimeMillis()))) + "\t" + (functionName == null ? "JTS3ServerMod" : "Function " + functionName) + "\t" + JTS3ServerMod.ERROR_LEVEL_NAMES[3] + "\t" + permissionMsg);
                        }
                    }
                }
            } else if (logSetting != null && logSetting.equals("sql")) {
                if (this.logLevelSettingList.get(instanceID) == 0) {
                    this.addSQLEntry(instanceID, functionName == null ? "JTS3ServerMod" : functionName, "EXCEPTION", JTS3ServerMod.getStackTrace(e), true);
                    if (permissionMsg != null) {
                        this.addSQLEntry(instanceID, functionName == null ? "JTS3ServerMod" : functionName, JTS3ServerMod.ERROR_LEVEL_NAMES[3], permissionMsg, true);
                    }
                } else {
                    this.addSQLEntry(instanceID, functionName == null ? "JTS3ServerMod" : functionName, "EXCEPTION", e.toString(), true);
                    if (permissionMsg != null) {
                        this.addSQLEntry(instanceID, functionName == null ? "JTS3ServerMod" : functionName, JTS3ServerMod.ERROR_LEVEL_NAMES[3], permissionMsg, true);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

