@echo off
REM JTSDNS Service Script v2 by Stefan Martens
REM 
REM If you want, change the path to the JTSDNS tools directory. It has to end with a backslash!
SET PR_PATH=%~dp0
REM 
REM Set the service name
SET PR_SERVICE_NAME=JTSDNS
REM 
REM Do not change anything below this line!
SET PR_SERVICE_DESCRIPTION=The MySQL TSDNS alternative from http://www.stefan1200.de
SET PR_JAR=JTSDNS.jar
SET START_CLASS=de.stefan1200.jtsdns.JTSDNS
SET START_METHOD=main
SET STOP_CLASS=java.lang.System
SET STOP_METHOD=exit
SET STOP_PARAMS=0
SET JVM_OPTIONS=-Dapp.home="%PR_PATH%..\\"

echo Installing JTSDNS service...
echo.

SET AdminTestPath=%windir%\System32\testadmintemp
mkdir "%AdminTestPath%" 2>nul
IF ERRORLEVEL 1 (
  echo You need admin permissions to run this script!
  goto END;
) else (
  rmdir "%AdminTestPath%"
)

"%PR_PATH%procrun\prunsrv.exe" //IS//%PR_SERVICE_NAME% --Description="%PR_SERVICE_DESCRIPTION%" --Install="%PR_PATH%procrun\prunsrv.exe" --Jvm=auto --Startup=auto --StartMode=jvm --StartClass=%START_CLASS% --StartMethod=%START_METHOD% --StopMode=jvm --StopClass=%STOP_CLASS% --StopMethod=%STOP_METHOD% ++StopParams=%STOP_PARAMS% --Classpath="%PR_PATH%..\%PR_JAR%" --DisplayName="%PR_SERVICE_NAME%" ++JvmOptions=%JVM_OPTIONS% --StdError=auto
IF ERRORLEVEL 1 (
	echo.
	echo Check if the service name %PR_SERVICE_NAME% already exists!
) else (
	echo.
	echo Now you should be able to start service with:
	echo net start %PR_SERVICE_NAME%
)

:END
PAUSE