/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class MySQLConnect {
    private Connection dbConnection = null;
    private String url = null;
    private String username = null;
    private String password = null;

    public MySQLConnect(String mysqlHost, int mysqlPort, String mysqlDB, String mysqlUser, String mysqlPW, byte verifyServerCertificate, byte useSSL, byte requireSSL, byte useCompression) throws ClassNotFoundException {
        if (mysqlPort < 0 || mysqlPort > 65535) {
            mysqlPort = 3306;
        }
        if (mysqlHost == null) {
            mysqlHost = "localhost";
        }
        if (mysqlDB == null) {
            mysqlDB = "";
        }
        if (mysqlUser == null) {
            mysqlUser = "root";
        }
        if (mysqlPW == null) {
            mysqlPW = "";
        }
        StringBuffer sbMySQLArgs = new StringBuffer();
        if (verifyServerCertificate >= 0) {
            sbMySQLArgs.append("?verifyServerCertificate=");
            sbMySQLArgs.append(verifyServerCertificate == 1 ? "true" : "false");
        }
        if (useSSL >= 0) {
            if (sbMySQLArgs.length() > 0) {
                sbMySQLArgs.append("&useSSL=");
            } else {
                sbMySQLArgs.append("?useSSL=");
            }
            sbMySQLArgs.append(useSSL == 1 ? "true" : "false");
        }
        if (requireSSL >= 0) {
            if (sbMySQLArgs.length() > 0) {
                sbMySQLArgs.append("&requireSSL=");
            } else {
                sbMySQLArgs.append("?requireSSL=");
            }
            sbMySQLArgs.append(requireSSL == 1 ? "true" : "false");
        }
        if (useCompression >= 0) {
            if (sbMySQLArgs.length() > 0) {
                sbMySQLArgs.append("&useCompression=");
            } else {
                sbMySQLArgs.append("?useCompression=");
            }
            sbMySQLArgs.append(useCompression == 1 ? "true" : "false");
        }
        this.url = "jdbc:mysql://" + mysqlHost + ":" + Integer.toString(mysqlPort) + "/" + mysqlDB + sbMySQLArgs.toString();
        this.username = mysqlUser;
        this.password = mysqlPW;
        Class.forName("com.mysql.jdbc.Driver");
    }

    public void close() {
        try {
            if (!this.dbConnection.isClosed()) {
                this.dbConnection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connect() throws SQLException {
        if (this.dbConnection == null || this.dbConnection.isClosed()) {
            this.dbConnection = DriverManager.getConnection(this.url, this.username, this.password);
        }
    }

    public Connection getConnection() {
        return this.dbConnection;
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        return this.dbConnection.prepareStatement(sql);
    }

    public Statement getStatement() throws SQLException {
        return this.dbConnection.createStatement();
    }
}

