/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jtsdns;

import de.stefan1200.jtsdns.JTSDNS;
import de.stefan1200.jtsdns.JTSDNSQuery;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.regex.Pattern;

public class JTSDNSClient
extends Thread {
    private Socket client = null;
    private BufferedReader in = null;
    private PrintStream out = null;
    private String sSearch = null;
    private JTSDNS mainClass = null;
    private JTSDNSQuery queryDB = null;
    private Pattern patternIPv4 = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private Pattern patternIPv6 = Pattern.compile("\\[([a-f0-9]{0,4}:){2,7}[a-f0-9]{0,4}\\]", 2);

    public JTSDNSClient(Socket client, JTSDNSQuery queryDB, JTSDNS mainClass) {
        this.client = client;
        this.mainClass = mainClass;
        this.queryDB = queryDB;
        this.start();
    }

    private boolean getSearch(String[] sSearchArray, int pos) {
        if (sSearchArray.length < pos) {
            return false;
        }
        StringBuffer sSearchTemp = new StringBuffer("*");
        int i = pos;
        while (i < sSearchArray.length) {
            sSearchTemp.append("." + sSearchArray[i]);
            ++i;
        }
        this.sSearch = sSearchTemp.toString();
        return true;
    }

    private void updateHost(String sAddress) {
        if (sAddress == null || sAddress.equals("404")) {
            return;
        }
        try {
            int updateCount = this.queryDB.updateHostname(this.sSearch);
            if (updateCount == 1) {
                this.mainClass.addLogEntry("Updated host statistics for " + this.sSearch, false, true);
            } else {
                this.mainClass.addLogEntry("Error while updating host statistics for " + this.sSearch, false, true);
            }
        }
        catch (Exception e) {
            this.mainClass.addLogEntry(e, false);
        }
    }

    private String readUntilEnd() {
        try {
            StringBuffer sb = new StringBuffer();
            do {
                sb.append((char)this.in.read());
            } while (this.in.ready());
            return sb.toString().trim();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void run() {
        String sAddress;
        block38: {
            this.mainClass.addLogEntry("Get connection from: " + this.client.getInetAddress().getHostAddress(), false, true);
            sAddress = "404";
            boolean skipAll = false;
            try {
                this.client.setSoTimeout(3000);
                this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream(), "UTF-8"));
                this.sSearch = this.readUntilEnd();
                this.mainClass.addLogEntry(String.valueOf(this.client.getInetAddress().getHostAddress()) + ": Asking for hostname " + this.sSearch, false, false);
                sAddress = this.queryDB.queryHostname(this.sSearch);
                if (sAddress == null) {
                    sAddress = "404";
                } else if (sAddress.equalsIgnoreCase("NORESPONSE")) {
                    skipAll = true;
                    this.mainClass.addLogEntry(String.valueOf(this.client.getInetAddress().getHostAddress()) + ": NORESPONSE keyword found, closing connection without sending anything", false, false);
                } else if (sAddress.equals("404")) {
                    String[] sSearchArray = this.sSearch.split("\\.");
                    int searchPos = 1;
                    while (this.getSearch(sSearchArray, searchPos)) {
                        sAddress = this.queryDB.queryHostname(this.sSearch);
                        if (sAddress != null && !sAddress.equals("404")) break;
                        searchPos = (byte)(searchPos + 1);
                    }
                }
                if (!skipAll) {
                    this.out = new PrintStream(this.client.getOutputStream(), true, "UTF-8");
                    String resolvedAddress = this.getIPAddress(sAddress);
                    this.out.print(resolvedAddress);
                    this.out.flush();
                    if (sAddress.equals("404")) {
                        this.mainClass.addLogEntry(String.valueOf(this.client.getInetAddress().getHostAddress()) + ": No address found, send 404", false, false);
                    } else {
                        this.mainClass.addLogEntry(String.valueOf(this.client.getInetAddress().getHostAddress()) + ": Send address " + resolvedAddress, false, false);
                    }
                }
            }
            catch (SocketTimeoutException ste) {
                this.mainClass.addLogEntry(String.valueOf(this.client.getInetAddress().getHostAddress()) + ": No hostname received!", false, false);
                sAddress = null;
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                    if (this.out != null) {
                        this.out.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.client.close();
                }
                catch (Exception exception) {}
                break block38;
            }
            catch (Exception e) {
                try {
                    this.mainClass.addLogEntry(e, false);
                    sAddress = null;
                    break block38;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                        if (this.out != null) {
                            this.out.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        this.client.close();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.updateHost(sAddress);
    }

    private String getIPAddress(String hostname) {
        if (hostname.equals("404")) {
            return "404";
        }
        StringBuffer sb = new StringBuffer();
        String[] multipleHostnames = hostname.split("[ ,]");
        int i = 0;
        while (i < multipleHostnames.length) {
            int posPort = multipleHostnames[i].lastIndexOf("]:");
            posPort = posPort == -1 ? multipleHostnames[i].lastIndexOf(58) : ++posPort;
            String tempHost = posPort == -1 ? multipleHostnames[i] : multipleHostnames[i].substring(0, posPort);
            if (this.patternIPv4.matcher(tempHost).matches()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(multipleHostnames[i]);
            } else if (this.patternIPv6.matcher(tempHost).matches()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(multipleHostnames[i]);
            } else {
                String ipAddress = tempHost;
                try {
                    this.mainClass.addLogEntry(String.valueOf(this.client.getInetAddress().getHostAddress()) + ": Try to resolve hostname " + tempHost, false, false);
                    InetAddress inetaddress = InetAddress.getByName(tempHost);
                    ipAddress = inetaddress.getHostAddress();
                    if (ipAddress.indexOf(":") != -1 && ipAddress.charAt(0) != '[') {
                        ipAddress = "[" + ipAddress + "]";
                    }
                }
                catch (Exception e) {
                    this.mainClass.addLogEntry(String.valueOf(this.client.getInetAddress().getHostAddress()) + ": Error while resolving hostname, error: " + e.toString(), false, false);
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ipAddress);
                if (posPort == -1) {
                    sb.append(":$PORT");
                } else {
                    sb.append(multipleHostnames[i].substring(posPort));
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

