/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jtsdns;

import de.stefan1200.jtsdns.JTSDNSClient;
import de.stefan1200.jtsdns.JTSDNSQuery;
import de.stefan1200.util.MySQLConnect;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class JTSDNS {
    private static final int PORT = 41144;
    private static final String VERSION = "JTSDNS 1.6.0 (31.03.2018)";
    private String configFile = String.valueOf(System.getProperty("app.home", "")) + "JTSDNS.cfg";
    private String mysqlHost = null;
    private int mysqlPort = 3306;
    private String mysqlDB = null;
    private String mysqlUser = null;
    private String mysqlPW = null;
    private byte mysqlVerifyServerCertificate = (byte)-1;
    private byte mysqlUseSSL = (byte)-1;
    private byte mysqlRequireSSL = (byte)-1;
    private byte mysqlUseCompression = (byte)-1;
    private String logFilePath = "";
    private PrintStream logFile = null;
    private SimpleDateFormat sdfDebug = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ServerSocket serv;
    private JTSDNSQuery queryDB = null;
    private boolean doStop = false;
    private boolean stopped = false;

    public JTSDNS() {
        if (this.loadConfig()) {
            this.addLogEntry("Starting JTSDNS 1.6.0 (31.03.2018)", true, true);
            boolean dbConnectError = false;
            try {
                this.queryDB = new JTSDNSQuery(new MySQLConnect(this.mysqlHost, this.mysqlPort, this.mysqlDB, this.mysqlUser, this.mysqlPW, this.mysqlVerifyServerCertificate, this.mysqlUseSSL, this.mysqlRequireSSL, this.mysqlUseCompression), this);
            }
            catch (Exception e) {
                this.addLogEntry("Error while opening MySQL database connection, reason:", true, true);
                this.addLogEntry(e, true);
                dbConnectError = true;
            }
            if (!dbConnectError) {
                Runtime runtime = Runtime.getRuntime();
                runtime.addShutdownHook(new Thread(new Runnable(){

                    public void run() {
                        JTSDNS.this.addLogEntry("Got signal from operating system, quitting now...", true, true);
                        try {
                            JTSDNS.this.doStop = true;
                            do {
                                Thread.sleep(100L);
                            } while (!JTSDNS.this.stopped);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }));
                this.runServer();
            }
        } else {
            this.addLogEntry("Error while loading configuration from " + this.configFile, true, true);
        }
    }

    private void runServer() {
        block10: {
            this.addLogEntry("Waiting for connections on port " + Integer.toString(41144), true, true);
            try {
                try {
                    this.serv = new ServerSocket(41144);
                    this.serv.setSoTimeout(1000);
                    while (true) {
                        try {
                            while (!Thread.currentThread().isInterrupted()) {
                                if (this.doStop) {
                                    break block10;
                                }
                                Socket client = this.serv.accept();
                                new JTSDNSClient(client, this.queryDB, this);
                            }
                        }
                        catch (SocketTimeoutException client) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    this.addLogEntry(e, true);
                    this.queryDB.closeDB();
                    this.stopped = true;
                }
            }
            finally {
                this.queryDB.closeDB();
                this.stopped = true;
            }
        }
    }

    private boolean loadConfig() {
        File confFile;
        boolean retValue;
        block13: {
            retValue = true;
            confFile = new File(this.configFile);
            if (confFile.isFile()) break block13;
            return false;
        }
        try {
            Properties prop = new Properties();
            prop.load(new FileInputStream(confFile));
            this.logFilePath = prop.getProperty("logfile");
            this.logFilePath = this.logFilePath.replace("%apphome%", System.getProperty("app.home", ""));
            if (this.logFilePath != null && this.logFilePath.length() > 0) {
                try {
                    this.logFile = new PrintStream((OutputStream)new FileOutputStream(this.logFilePath, true), true, "UTF-8");
                }
                catch (Exception e) {
                    this.logFile = null;
                }
            }
            this.mysqlHost = prop.getProperty("mysql_host");
            if (this.mysqlHost == null || this.mysqlHost.length() == 0) {
                retValue = false;
            }
            try {
                this.mysqlPort = Integer.parseInt(prop.getProperty("mysql_port", "-1"));
                if (this.mysqlPort < 0 || this.mysqlPort > 65535) {
                    retValue = false;
                }
            }
            catch (Exception e) {
                retValue = false;
            }
            this.mysqlUser = prop.getProperty("mysql_user");
            if (this.mysqlUser == null || this.mysqlUser.length() == 0) {
                retValue = false;
            }
            this.mysqlPW = prop.getProperty("mysql_password");
            if (this.mysqlPW == null) {
                retValue = false;
            }
            this.mysqlDB = prop.getProperty("mysql_database");
            if (this.mysqlDB == null || this.mysqlDB.length() == 0) {
                retValue = false;
            }
            this.mysqlVerifyServerCertificate = Byte.parseByte(prop.getProperty("mysql_verifyServerCertificate", "-1"));
            this.mysqlUseSSL = Byte.parseByte(prop.getProperty("mysql_useSSL", "-1"));
            this.mysqlRequireSSL = Byte.parseByte(prop.getProperty("mysql_requireSSL", "-1"));
            this.mysqlUseCompression = Byte.parseByte(prop.getProperty("mysql_useCompression", "-1"));
        }
        catch (Exception e) {
            retValue = false;
        }
        return retValue;
    }

    public void addLogEntry(String msg, boolean outputToSystemOut, boolean addDate) {
        try {
            if (outputToSystemOut) {
                System.out.println(msg);
            }
            if (this.logFile != null) {
                if (addDate) {
                    this.logFile.println(String.valueOf(this.sdfDebug.format(new Date(System.currentTimeMillis()))) + ": " + msg);
                } else {
                    this.logFile.println(msg);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addLogEntry(Throwable e, boolean outputToSystemOut) {
        try {
            if (outputToSystemOut) {
                System.out.println(e.toString());
            }
            if (this.logFile != null) {
                this.logFile.println(String.valueOf(this.sdfDebug.format(new Date(System.currentTimeMillis()))) + ": " + "EXCEPTION - JTSDNS Version: " + VERSION);
                e.printStackTrace(this.logFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        new JTSDNS();
    }
}

