/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jtsdns;

import de.stefan1200.jtsdns.JTSDNS;
import de.stefan1200.util.MySQLConnect;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JTSDNSQuery {
    private MySQLConnect mysqlConnect = null;
    private PreparedStatement pstSearch = null;
    private PreparedStatement pstUpdate = null;
    private JTSDNS mainClass = null;
    private boolean doReconnect = true;

    public JTSDNSQuery(MySQLConnect mysqlConnect, JTSDNS mainClass) throws SQLException {
        this.mysqlConnect = mysqlConnect;
        this.mainClass = mainClass;
        mysqlConnect.connect();
        this.pstUpdate = mysqlConnect.getPreparedStatement("UPDATE jtsdns SET lastused = ?, usecount = usecount+1 WHERE hostname = ?");
        this.pstSearch = mysqlConnect.getPreparedStatement("SELECT ipaddress FROM jtsdns WHERE hostname = ? AND enabled = 1");
    }

    boolean initDB() {
        if (this.mysqlConnect == null) {
            return false;
        }
        try {
            this.mysqlConnect.connect();
            this.pstUpdate = this.mysqlConnect.getPreparedStatement("UPDATE jtsdns SET lastused = ?, usecount = usecount+1 WHERE hostname = ?");
            this.pstSearch = this.mysqlConnect.getPreparedStatement("SELECT ipaddress FROM jtsdns WHERE hostname = ? AND enabled = 1");
            return true;
        }
        catch (Exception e) {
            try {
                this.mysqlConnect.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mainClass.addLogEntry("Cannot connect to the MySQL server:", false, true);
            this.mainClass.addLogEntry(e.toString(), false, true);
            this.pstUpdate = null;
            this.pstSearch = null;
            return false;
        }
    }

    synchronized String queryHostname(String hostname) {
        if (!this.doReconnect) {
            return null;
        }
        try {
            this.pstSearch.setString(1, hostname);
            ResultSet searchResult = this.pstSearch.executeQuery();
            if (searchResult.next()) {
                return searchResult.getString(1);
            }
            return "404";
        }
        catch (Exception e) {
            block8: {
                try {
                    this.mainClass.addLogEntry("Error while talking to the MySQL database, reason:", false, true);
                    this.mainClass.addLogEntry(e.toString(), false, true);
                    this.mainClass.addLogEntry("Try to reconnect...", false, true);
                    if (this.initDB()) break block8;
                    return null;
                }
                catch (Exception e2) {
                    this.mainClass.addLogEntry("Error while talking to the MySQL database, reason:", false, true);
                    this.mainClass.addLogEntry(e2.toString(), false, true);
                    return null;
                }
            }
            this.pstSearch.setString(1, hostname);
            ResultSet searchResult = this.pstSearch.executeQuery();
            if (searchResult.next()) {
                return searchResult.getString(1);
            }
            return "404";
        }
    }

    synchronized int updateHostname(String hostname) {
        if (!this.doReconnect) {
            return -666;
        }
        try {
            this.pstUpdate.setLong(1, System.currentTimeMillis() / 1000L);
            this.pstUpdate.setString(2, hostname);
            return this.pstUpdate.executeUpdate();
        }
        catch (Exception e) {
            block6: {
                try {
                    this.mainClass.addLogEntry("Error while talking to the MySQL database, reason:", false, true);
                    this.mainClass.addLogEntry(e.toString(), false, true);
                    this.mainClass.addLogEntry("Try to reconnect...", false, true);
                    if (this.initDB()) break block6;
                    return -666;
                }
                catch (Exception e2) {
                    this.mainClass.addLogEntry("Error while talking to the MySQL database, reason:", false, true);
                    this.mainClass.addLogEntry(e2.toString(), false, true);
                    return -666;
                }
            }
            this.pstUpdate.setLong(1, System.currentTimeMillis() / 1000L);
            this.pstUpdate.setString(2, hostname);
            return this.pstUpdate.executeUpdate();
        }
    }

    void closeDB() {
        this.doReconnect = false;
        this.mysqlConnect.close();
    }
}

