package de.stefan1200.jts3servermod.interfaces;

import de.stefan1200.jts3serverquery.JTS3ServerQuery;

/**
 * This is the main interface, every plugin has to implement it!<br><br>
 * 
 * The author of the JTS3ServerMod is not responsible for any damage or data loss!<br><br>
 * 
 * <b>E-Mail:</b><br><a href="mailto:info@stefan1200.de">info@stefan1200.de</a><br><br>
 * <b>Homepage:</b><br><a href="http://www.stefan1200.de" target="_blank">http://www.stefan1200.de</a>
 * @author Stefan Martens
 *
 */
public interface HandleBotEvents
{
	/**
	 * This method will be called while loading all functions/plugins. Save class instances and plugin prefix to interact with the bot and TS3 server.
	 * @param modClass Main bot class
	 * @param queryLib Query connection used by the main bot class
	 * @param prefix This is the prefix for config keys and chat commands.
	 */
	public void initClass(JTS3ServerMod_Interface modClass, JTS3ServerQuery queryLib, String prefix);
	
	/**
	 * This method will be called after the JTS3ServerMod connected successfully to the TS3 server.
	 * Use this method to output a description message to the log.
	 * Important: This method never gets called if the function is disabled at bot connect! 
	 */
	public void handleOnBotConnect();
	
	/**
	 * This method will be called after updating the server info, server group list or channel list cache.
	 * Use this method to update Server, Server Group or Channel information.
	 */
	public void handleAfterCacheUpdate();
	
	/**
	 * This method will be called after connected successfully to the TS3 server after calling handleOnBotConnect(), after reloading configuration or after receiving the function/plugin activate request by bot admin.
	 * Use this method if you have to start a timer or something similar to start the job of this function/plugin.
	 */
	public void activate();
	
	/**
	 * This method will be called while disconnecting from TS3 server, before reloading the configuration or after receiving the function/plugin disable request by bot admin.
	 * Use this method if you have to stop a timer or something similar to sleep this function/plugin.
	 * Plugin keeps loaded in memory, but should do nothing.
	 */
	public void disable();
	
	/**
	 * This method will be called while disconnecting from TS3 server after calling disable().
	 * Use this method if you have to clean up stuff to unload this function/plugin from memory.
	 */
	public void unload();
	
	/**
	 * On loading all functions/plugins this method will be called to know, if multiple instances of this function/plugin per virtual bot are allowed.
	 * @return <code>true</code> if multiple instances are allowed, <code>false</code> if not.
	 */
	public boolean multipleInstances();
	
	/**
	 * On loading all functions/plugins this method will be called to know, if the api build of the plugin match with the JTS3ServerMod.
	 * @return Returns the api build, for which this plugin was compiled against.
	 */
	public int getAPIBuild();
	
	/**
	 * The plugin name and copyright. 
	 * @return Returns the copyright line of the plugin. 
	 */
	public String getCopyright();
}
