/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleTS3Events;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import de.stefan1200.util.MySQLConnect;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AutoMove
implements HandleBotEvents,
HandleTS3Events,
LoadConfiguration {
    private String a;
    private JTS3ServerMod_Interface a;
    private JTS3ServerQuery a;
    private boolean a;
    private HashMap a;
    private String b;
    private String c = null;
    private Vector a;
    private Vector b;
    private String d = null;
    private boolean b = false;
    private int a = -1;

    public AutoMove() {
        this.b = new Vector();
    }

    @Override
    public void initClass(JTS3ServerMod_Interface jTS3ServerMod_Interface, JTS3ServerQuery jTS3ServerQuery, String string) {
        this.a = jTS3ServerMod_Interface;
        this.a = jTS3ServerQuery;
        this.a = string.trim();
    }

    @Override
    public void handleOnBotConnect() {
        String string2;
        if (!this.a) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : this.a) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string2);
        }
        string2 = "Auto Move is enabled, default channels for " + Integer.toString(this.a.size()) + " server groups set" + (stringBuffer.length() > 0 ? " (for clients with the operating systems: " + stringBuffer.toString() + ")." : ".");
        if (this.a.getMySQLConnection() == null) {
            string2 = String.valueOf(string2) + " Using Auto Move configuration file (bot config value " + this.a + "_file): " + this.d;
        }
        this.a.addLogEntry(this.a, (byte)1, string2, true);
    }

    @Override
    public void handleAfterCacheUpdate() {
        this.a = this.a.getDefaultChannelID();
    }

    @Override
    public void activate() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void unload() {
        this.a = null;
        this.a = null;
        this.b = null;
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter arrangedPropertiesWriter) {
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_platform_list", "A comma separated list (without spaces) of platform names (it's the same value as %CLIENT_PLATFORM% at the welcome message).\nOnly selected platforms will be moved or leave this empty to move all platforms.\nPossible platforms: Windows, Mac, Linux, Android, iOS", "");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_ignore_default_channel", "Ignore the selected default channel from a client?\nSet yes or no here!", "no");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message_mode", "Select the message mode, how the clients should get the message.\npoke, chat or none are valid values!", "chat");
        if (this.a.getMySQLConnection() == null) {
            arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_file", "Path to file which contains the auto move configuration and message.", "%apphome%config/server1/automove.cfg");
        }
        if (this.a.getMySQLConnection() != null) {
            arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message", "Set the chat message for the auto move function.\nYou can use \\n for a new line and typical BBCode like in Teamspeak 3 Client.");
        }
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter arrangedPropertiesWriter, boolean bl) {
        this.a = false;
        if (bl) {
            this.a.addLogEntry(this.a, (byte)2, "Slow Mode is activated, if the bot gets banned by the TS3 server, you should disable Auto Move!", true);
        }
        this.b = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_message_mode", "none").trim();
        this.a.clear();
        this.b.clear();
        String string = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_platform_list", "").trim().toLowerCase(Locale.ENGLISH);
        if (string.length() > 1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                this.b.addElement(string);
                if (string.equals("ios")) {
                    this.a.addElement("iOS");
                    continue;
                }
                this.a.addElement(String.valueOf(string.trim().substring(0, 1).toUpperCase(Locale.ENGLISH)) + (string.length() > 1 ? string.trim().substring(1) : ""));
            }
        }
        this.b = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_ignore_default_channel", "no").trim().equalsIgnoreCase("yes");
        this.d = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_file");
        if (!this.a(arrangedPropertiesWriter)) {
            throw new BotConfigurationException("Auto Move message and configuration could not be loaded!");
        }
        if (this.a.size() == 0) {
            throw new BotConfigurationException("Auto Move needs at least one server group set!" + (this.d == null ? "" : " Config file: " + this.d));
        }
        if (this.b.equalsIgnoreCase("chat") || this.b.equalsIgnoreCase("poke")) {
            if (this.c == null || this.c.length() == 0) {
                throw new BotConfigurationException("Auto Move message could not be loaded!");
            }
            if (!this.a.isMessageLengthValid(this.b, this.c)) {
                this.a.addLogEntry(this.a, (byte)2, "Auto Move message is to long! Make sure that " + this.b + " messages are not longer than " + Short.toString(this.a.getMaxMessageLength(this.b)) + " characters (including spaces and BBCode)" + (this.a.getMySQLConnection() == null ? ", check file: " + this.d : ""), true);
            }
        }
        this.a.addTS3ServerEvent(this);
        this.a = true;
        return this.a;
    }

    private boolean a(ArrangedPropertiesWriter object) {
        BufferedReader bufferedReader;
        block37: {
            if (this.a.getMySQLConnection() != null) {
                boolean bl;
                block36: {
                    MySQLConnect mySQLConnect = this.a.getMySQLConnection();
                    this.c = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_message");
                    PreparedStatement preparedStatement = null;
                    ResultSet resultSet = null;
                    try {
                        try {
                            mySQLConnect.connect();
                            preparedStatement = mySQLConnect.getPreparedStatement("SELECT servergroup_id, channel_id FROM jts3servermod_automove WHERE instance_id = ? AND prefix = ?");
                            preparedStatement.setInt(1, this.a.getInstanceID());
                            preparedStatement.setString(2, this.a);
                            resultSet = preparedStatement.executeQuery();
                            this.a.clear();
                            while (resultSet.next()) {
                                this.a.put(resultSet.getInt(1), resultSet.getInt(2));
                            }
                            bl = true;
                        }
                        catch (Exception exception) {
                            bl = false;
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                            catch (Exception exception2) {}
                            try {
                                if (preparedStatement != null) {
                                    preparedStatement.close();
                                }
                            }
                            catch (Exception exception3) {}
                            mySQLConnect.close();
                            break block36;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (Exception exception) {}
                        try {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                        catch (Exception exception) {}
                        mySQLConnect.close();
                        throw throwable;
                    }
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (Exception exception) {}
                    mySQLConnect.close();
                }
                return bl;
            }
            if (this.d == null) {
                this.a.addLogEntry(this.a, (byte)3, "Path to Auto Move config file was not set in bot config! Check config key: " + this.a + "_file", true);
                return false;
            }
            this.d = this.d.trim().replace("%apphome%", System.getProperty("app.home", ""));
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.d), this.a.getMessageEncoding()));
            object = bufferedReader.readLine();
            if (this.a.getMessageEncoding().equalsIgnoreCase("UTF-8") && object != null && ((String)object).charAt(0) == '\ufeff') {
                object = ((String)object).substring(1);
            }
            if (object != null && ((String)object).equals("# JTS3ServerMod Config File")) break block37;
            this.a.addLogEntry(this.a, (byte)3, "Special config file header is missing at Auto Move config file! File path: " + this.d, true);
            this.a.addLogEntry(this.a, (byte)3, "Check if you set the right file at config key: " + this.a + "_file", true);
            bufferedReader.close();
            return false;
        }
        try {
            this.a.clear();
            int n = 0;
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).startsWith("#") || ((String)object).length() < 3) continue;
                if (n == 0) {
                    this.c = object = ((String)object).replace("\\n", "\n");
                }
                if (n > 0) {
                    int n2 = ((String)object).indexOf(",");
                    if (n2 == -1 || n2 == 0) continue;
                    try {
                        this.a.put(Integer.parseInt(((String)object).substring(0, n2).trim()), Integer.parseInt(((String)object).substring(n2 + 1).trim()));
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                ++n;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.a.addLogEntry(this.a, (byte)3, "Auto Move config file you set at config key \"" + this.a + "_file\" does not exist or missing permission for reading, check file path: " + new File(this.d).getAbsolutePath(), true);
            return false;
        }
        catch (Exception exception) {
            this.a.addLogEntry(this.a, (byte)3, "Unknown error while loading Auto Move config file! Check file you set at config key \"" + this.a + "_file\", the file path: " + this.d, true);
            this.a.addLogEntry(this.a, exception, true);
            return false;
        }
        return true;
    }

    @Override
    public void setListModes(BitSet bitSet) {
    }

    @Override
    public String[] botChatCommandList(HashMap hashMap, boolean bl, boolean bl2) {
        return null;
    }

    @Override
    public String botChatCommandHelp(String string) {
        return null;
    }

    @Override
    public boolean handleChatCommands(String string, HashMap hashMap, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public void handleTS3Events(String string, HashMap hashMap) {
        if (!this.a) {
            return;
        }
        if (string.equals("notifycliententerview") && Integer.parseInt((String)hashMap.get("client_type")) == 0 && (this.b || Integer.parseInt((String)hashMap.get("ctid")) == this.a.getDefaultChannelID()) && (this.b.size() == 0 || this.a.isUIDListed(this.b, ((String)hashMap.get("client_platform")).toLowerCase(Locale.ENGLISH)))) {
            int n;
            int n2;
            Object object;
            int n3;
            block9: {
                n3 = Integer.parseInt((String)hashMap.get("clid"));
                HashMap hashMap2 = this.a;
                object = (String)hashMap.get("client_servergroups");
                AutoMove autoMove = this;
                object = new StringTokenizer((String)object, ",", false);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    int n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
                    Integer n5 = (Integer)hashMap2.get(n4);
                    if (n5 == null) continue;
                    if (n5 != autoMove.a) {
                        n2 = n5;
                        break block9;
                    }
                    autoMove.a.addLogEntry(autoMove.a, (byte)2, "Skipping target channel (id: " + n5.toString() + ") of the server group id " + Integer.toString(n4) + ". The default TS3 server channel was configured as target channel! TS3 Clients are already in this channel after connecting.", true);
                }
                n2 = n = -1;
            }
            if (n2 > 0) {
                object = this.a.getChannelName(n);
                try {
                    this.a.moveClient(n3, n, null);
                    this.a.addLogEntry(this.a, (byte)1, "Client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") has connected, moved to channel: " + (object != null ? String.valueOf(object) + " (id: " + Integer.toString(n) + ")" : "Unknown"), false);
                    this.a.sendMessageToClient(this.a, this.b, n3, this.c.replace("%CHANNEL_NAME%", (CharSequence)(object != null ? object : "Unknown")));
                    return;
                }
                catch (TS3ServerQueryException tS3ServerQueryException) {
                    this.a.addLogEntry(this.a, (byte)2, "Client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") has connected, but an error occurred while moving to channel: " + (object != null ? String.valueOf(object) + " (id: " + Integer.toString(n) + ")" : "Unknown"), false);
                    if (tS3ServerQueryException.getFailedPermissionID() < 0) {
                        this.a.addLogEntry(this.a, (byte)2, tS3ServerQueryException.toString(), false);
                        return;
                    }
                    this.a.addLogEntry(this.a, tS3ServerQueryException, false);
                    return;
                }
                catch (Exception exception) {
                    this.a.addLogEntry(this.a, (byte)1, "Client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") has connected, but an error occurred while moving to channel: " + (object != null ? String.valueOf(object) + " (id: " + Integer.toString(n) + ")" : "Unknown"), false);
                    this.a.addLogEntry(this.a, exception, false);
                }
            }
        }
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Auto Move function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }
}

