/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jzlib;

import com.jcraft.jsch.jzlib.Adler32;
import com.jcraft.jsch.jzlib.Checksum;
import com.jcraft.jsch.jzlib.Deflate;
import com.jcraft.jsch.jzlib.Inflate;
import com.jcraft.jsch.jzlib.JZlib;

class ZStream {
    private static final int MAX_WBITS = 15;
    private static final int DEF_WBITS = 15;
    private static final int Z_NO_FLUSH = 0;
    private static final int Z_PARTIAL_FLUSH = 1;
    private static final int Z_SYNC_FLUSH = 2;
    private static final int Z_FULL_FLUSH = 3;
    private static final int Z_FINISH = 4;
    private static final int MAX_MEM_LEVEL = 9;
    private static final int Z_OK = 0;
    private static final int Z_STREAM_END = 1;
    private static final int Z_NEED_DICT = 2;
    private static final int Z_ERRNO = -1;
    private static final int Z_STREAM_ERROR = -2;
    private static final int Z_DATA_ERROR = -3;
    private static final int Z_MEM_ERROR = -4;
    private static final int Z_BUF_ERROR = -5;
    private static final int Z_VERSION_ERROR = -6;
    byte[] next_in;
    int next_in_index;
    int avail_in;
    long total_in;
    byte[] next_out;
    int next_out_index;
    int avail_out;
    long total_out;
    String msg;
    Deflate dstate;
    Inflate istate;
    int data_type;
    Checksum adler;

    ZStream() {
        this(new Adler32());
    }

    ZStream(Checksum adler) {
        this.adler = adler;
    }

    int inflateInit() {
        return this.inflateInit(15);
    }

    int inflateInit(boolean nowrap) {
        return this.inflateInit(15, nowrap);
    }

    int inflateInit(int w) {
        return this.inflateInit(w, false);
    }

    int inflateInit(JZlib.WrapperType wrapperType) {
        return this.inflateInit(15, wrapperType);
    }

    int inflateInit(int w, JZlib.WrapperType wrapperType) {
        boolean nowrap = false;
        if (wrapperType == JZlib.W_NONE) {
            nowrap = true;
        } else if (wrapperType == JZlib.W_GZIP) {
            w += 16;
        } else if (wrapperType == JZlib.W_ANY) {
            w |= 0x40000000;
        } else if (wrapperType == JZlib.W_ZLIB) {
            // empty if block
        }
        return this.inflateInit(w, nowrap);
    }

    int inflateInit(int w, boolean nowrap) {
        this.istate = new Inflate(this);
        return this.istate.inflateInit(nowrap ? -w : w);
    }

    int inflate(int f2) {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflate(f2);
    }

    int inflateEnd() {
        if (this.istate == null) {
            return -2;
        }
        int ret = this.istate.inflateEnd();
        return ret;
    }

    int inflateSync() {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflateSync();
    }

    int inflateSyncPoint() {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflateSyncPoint();
    }

    int inflateSetDictionary(byte[] dictionary, int dictLength) {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflateSetDictionary(dictionary, dictLength);
    }

    boolean inflateFinished() {
        return this.istate.mode == 12;
    }

    int deflateInit(int level) {
        return this.deflateInit(level, 15);
    }

    int deflateInit(int level, boolean nowrap) {
        return this.deflateInit(level, 15, nowrap);
    }

    int deflateInit(int level, int bits) {
        return this.deflateInit(level, bits, false);
    }

    int deflateInit(int level, int bits, int memlevel, JZlib.WrapperType wrapperType) {
        if (bits < 9 || bits > 15) {
            return -2;
        }
        if (wrapperType == JZlib.W_NONE) {
            bits *= -1;
        } else if (wrapperType == JZlib.W_GZIP) {
            bits += 16;
        } else {
            if (wrapperType == JZlib.W_ANY) {
                return -2;
            }
            if (wrapperType == JZlib.W_ZLIB) {
                // empty if block
            }
        }
        return this.deflateInit(level, bits, memlevel);
    }

    int deflateInit(int level, int bits, int memlevel) {
        this.dstate = new Deflate(this);
        return this.dstate.deflateInit(level, bits, memlevel);
    }

    int deflateInit(int level, int bits, boolean nowrap) {
        this.dstate = new Deflate(this);
        return this.dstate.deflateInit(level, nowrap ? -bits : bits);
    }

    int deflate(int flush) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflate(flush);
    }

    int deflateEnd() {
        if (this.dstate == null) {
            return -2;
        }
        int ret = this.dstate.deflateEnd();
        this.dstate = null;
        return ret;
    }

    int deflateParams(int level, int strategy) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflateParams(level, strategy);
    }

    int deflateSetDictionary(byte[] dictionary, int dictLength) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflateSetDictionary(dictionary, dictLength);
    }

    void flush_pending() {
        int len = this.dstate.pending;
        if (len > this.avail_out) {
            len = this.avail_out;
        }
        if (len == 0) {
            return;
        }
        if (this.dstate.pending_buf.length <= this.dstate.pending_out || this.next_out.length <= this.next_out_index || this.dstate.pending_buf.length < this.dstate.pending_out + len || this.next_out.length < this.next_out_index + len) {
            // empty if block
        }
        System.arraycopy(this.dstate.pending_buf, this.dstate.pending_out, this.next_out, this.next_out_index, len);
        this.next_out_index += len;
        this.dstate.pending_out += len;
        this.total_out += (long)len;
        this.avail_out -= len;
        this.dstate.pending -= len;
        if (this.dstate.pending == 0) {
            this.dstate.pending_out = 0;
        }
    }

    int read_buf(byte[] buf, int start, int size) {
        int len = this.avail_in;
        if (len > size) {
            len = size;
        }
        if (len == 0) {
            return 0;
        }
        this.avail_in -= len;
        if (this.dstate.wrap != 0) {
            this.adler.update(this.next_in, this.next_in_index, len);
        }
        System.arraycopy(this.next_in, this.next_in_index, buf, start, len);
        this.next_in_index += len;
        this.total_in += (long)len;
        return len;
    }

    long getAdler() {
        return this.adler.getValue();
    }

    void free() {
        this.next_in = null;
        this.next_out = null;
        this.msg = null;
    }

    void setOutput(byte[] buf) {
        this.setOutput(buf, 0, buf.length);
    }

    void setOutput(byte[] buf, int off, int len) {
        this.next_out = buf;
        this.next_out_index = off;
        this.avail_out = len;
    }

    void setInput(byte[] buf) {
        this.setInput(buf, 0, buf.length, false);
    }

    void setInput(byte[] buf, boolean append) {
        this.setInput(buf, 0, buf.length, append);
    }

    void setInput(byte[] buf, int off, int len, boolean append) {
        if (len <= 0 && append && this.next_in != null) {
            return;
        }
        if (this.avail_in > 0 && append) {
            byte[] tmp = new byte[this.avail_in + len];
            System.arraycopy(this.next_in, this.next_in_index, tmp, 0, this.avail_in);
            System.arraycopy(buf, off, tmp, this.avail_in, len);
            this.next_in = tmp;
            this.next_in_index = 0;
            this.avail_in += len;
        } else {
            this.next_in = buf;
            this.next_in_index = off;
            this.avail_in = len;
        }
    }

    byte[] getNextIn() {
        return this.next_in;
    }

    void setNextIn(byte[] next_in) {
        this.next_in = next_in;
    }

    int getNextInIndex() {
        return this.next_in_index;
    }

    void setNextInIndex(int next_in_index) {
        this.next_in_index = next_in_index;
    }

    int getAvailIn() {
        return this.avail_in;
    }

    void setAvailIn(int avail_in) {
        this.avail_in = avail_in;
    }

    byte[] getNextOut() {
        return this.next_out;
    }

    void setNextOut(byte[] next_out) {
        this.next_out = next_out;
    }

    int getNextOutIndex() {
        return this.next_out_index;
    }

    void setNextOutIndex(int next_out_index) {
        this.next_out_index = next_out_index;
    }

    int getAvailOut() {
        return this.avail_out;
    }

    void setAvailOut(int avail_out) {
        this.avail_out = avail_out;
    }

    long getTotalOut() {
        return this.total_out;
    }

    long getTotalIn() {
        return this.total_in;
    }

    String getMessage() {
        return this.msg;
    }

    int end() {
        return 0;
    }

    boolean finished() {
        return false;
    }
}

